<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Customreferenceshandler
{
    private $ci;

    public function __construct()
    {
        $this->ci = &get_instance();
        $this->ci->load->model(['common', 'customreferencesmodel', 'Singlestatusmodel']);
        $this->ci->load->library(["uniqloediservices", "Customstatustoknlogin"]);
    }

    public function pullOrderReferenceXml(array $data): void
    {
        $orderInfo = $data['SVKEDITransmissionBody'];
        $orderHeader = $data['SVKEDITransmissionHeader'];
        if (array_key_exists("0", $orderInfo['OrderStatus']) == 1) {
            foreach ($orderInfo['OrderStatus'] as $orderStatus) {
                $orderInformation = $this->orderRefernecesData($orderStatus);
                $recordType = is_array($orderStatus['RecordType']) ? "" : $orderStatus['RecordType'];
                if (strtoupper($recordType) == "EVENTS") {
                    $this->insertOrderCustomStatus($orderInformation);
                } else {
                    $this->insertOrderReferences($orderInformation);
                }
            }
        } else {
            $orderID = is_array($orderInfo['OrderStatus']['OrderID']) ? "" : $orderInfo['OrderStatus']['OrderID'];
            $recordType = is_array($orderInfo['OrderStatus']['RecordType']) ? "" : $orderInfo['OrderStatus']['RecordType'];
            $orderInformation = $this->orderRefernecesData($orderInfo['OrderStatus']);
            if (strtoupper($recordType) == "EVENTS") {
                $this->insertOrderCustomStatus($orderInformation);
            } else {
                $this->insertOrderReferences($orderInformation);
            }
        }
    }

    private function orderRefernecesData(array $orderStatus): array
    {
        if (empty($orderStatus)) {
            return [];
        }
        $orderInformation = [
            'orderID' => is_array($orderStatus['OrderID']) ? "" : $orderStatus['OrderID'],
            'shipmentID' => is_array($orderStatus['ShipmentID']) ? "" : $orderStatus['ShipmentID'],
            'statusCode' => is_array($orderStatus['StatusCode']) ? "" : $orderStatus['StatusCode'],
            'statusName' => is_array($orderStatus['StatusName']) ? "" : $orderStatus['StatusName'],
            'referenceValue' => is_array($orderStatus['ReferenceValue']) ? "" : $orderStatus['ReferenceValue'],
            'city' => is_array($orderStatus['City']) ? "" : $orderStatus['City'],
            'country' => is_array($orderStatus['Country']) ? "" : $orderStatus['Country'],
            'dateTime' => is_array($orderStatus['DateTime']) ? "" : $orderStatus['DateTime'],
            'timeZone' => is_array($orderStatus['TimeZone']) ? "" : $orderStatus['TimeZone'],
            'actionUser' => is_array($orderStatus['ActionUser']) ? "" : $orderStatus['ActionUser']
        ];
        return $orderInformation ?? [];
    }

    public function insertOrderCustomStatus(array $orderInformation): void
    {
        $isOrderReference = $this->ci->common->gettblrowdata(['ref_value'=>$orderInformation['orderID'],'status'=>1],'order_id','tb_order_references',0,0);
        if (!empty($isOrderReference)) {
            $orderDetails = $this->ci->common->gettblrowdata(['id'=>$isOrderReference['order_id']],'order_id','tb_orders',0,0);
            $orderInformation['orderID'] = $orderDetails ? $orderDetails['order_id'] : $orderInformation['orderID'];
        }
        $getOrderinfo = $this->ci->common->gettblrowdata(
            ['order_id' => $orderInformation['orderID'], 'status <>' => '0'],
            "id,user_id,shift_id,trip_id,plat,plng,CONCAT(`pickup_address1`,',',`pickup_city`,',',`pickup_address2`,',',`pickup_country`,',',`pickup_pincode`) AS pickupaddress",
            "tb_orders",
            0,
            0
        );
        if (!empty($getOrderinfo)) {
            $previousLegsStatus = 1;
            if (trim($orderInformation['shipmentID'])) {
                $sql = "SELECT `id`,`shift_leg_id` FROM `tb_shifts` WHERE `shipmentid` = ? AND `status` = ? AND `shift_leg_id` > ? ";
                $isXBRDR = $this->ci->common->fetchRecordsByCustomQry($sql,[$orderInformation['shipmentID'],1,0],false);
                if ($isXBRDR) {
                    $legInfo = explode('-',$orderInformation['shipmentID']);
                    if (isset($legInfo[1]) && $legInfo[1] > 1) {
                        $previousLegId = --$legInfo[1];
                        $validateShipmentId = $legInfo[0].'-'.$previousLegId;
                        $sql = "SELECT id FROM tb_stop_status WHERE shipment_id = (SELECT id FROM tb_shifts WHERE shipmentid = ? LIMIT ?) AND `status` = ? AND `status_code` = ?";
                        $earlyLegInfo = $this->ci->common->fetchRecordsByCustomQry($sql,[$validateShipmentId,1,1,'2300'],false);
                        $previousLegsStatus = $earlyLegInfo ? 1 : 0;
                    }
                }
            }
            if ($previousLegsStatus === 1) {
                $orderId = $getOrderinfo['id'];
                $pickupAddress = $getOrderinfo['pickupaddress'];
                $statusCode = $orderInformation['statusCode'];
                $statusName = $orderInformation['statusName'];
                if ($orderInformation['city'] == "" && $orderInformation['country'] == "") {
                    $latitude = $getOrderinfo['plat'];
                    $longitude = $getOrderinfo['plng'];
                } else {
                    $statusLocation = $orderInformation['city'] . ", " . $orderInformation['country'];
                    $statusLaitudeLongitude = getlatlngsbyplace($statusLocation);
                    $latitude = @$statusLaitudeLongitude[0];
                    $longitude = @$statusLaitudeLongitude[1];
                }
                if ($latitude == "" || $longitude == "") {
                    $pickupLaitudeLongitude = getlatlngsbyplace($pickupAddress);
                    $latitude = @$pickupLaitudeLongitude[0];
                    $longitude = @$pickupLaitudeLongitude[1];
                }
                $timezone = $this->ci->customreferencesmodel->getUserTimeZone($getOrderinfo['user_id']);
                $statusdate = str_replace("T", " ", $orderInformation['dateTime']);
                $customStatusDate = getdatetimebytimezone(DFLT_TZ, $statusdate, $timezone);
                $statusDateTime = $customStatusDate['datetime'];
                $statusId = $this->ci->customreferencesmodel->getStatusCodeId($statusCode, $statusName);
                $statusData = [
                    'order_id' => $orderId,
                    'status_id' => $statusId,
                    'latitude' => $latitude,
                    'longitude' => $longitude,
                    'status_code' => $statusCode,
                    'status_date' => $statusDateTime,
                    'shift_id' => $getOrderinfo['shift_id'],
                    'action_user' => $orderInformation['actionUser'],
                    'comment' => $orderInformation['referenceValue'] ?? "",
                    'status_reason'=> 'From EDI'
                ];
                $statusCodes = ['1075', '0212', '0420', '0500', '0191', '1550', '0192', '2300', '3000', '0218'];
                if (!in_array($statusCode, $statusCodes)) {
                    $this->ci->customreferencesmodel->insertOrderStatus($statusData);
                    $this->ci->customstatustoknlogin->sendCustomStatustoKNlogin($orderId);
                }
                if ($getOrderinfo['shift_id'] > 0) {
                    $ordersData[] = [
                        "OrderID" => $orderInformation['orderID'],
                        "shipmentLegId" => (string)$orderInformation['shipmentID'],
                        "statustype" => $statusCode,
                        "statuscode" => $statusCode,
                        "statusvalue" => $statusName,
                        "datetime" => $statusdate,
                        "lat" => $latitude,
                        "lng" => $longitude,
                        "location" => "",
                        "actionuser" => $orderInformation['actionUser'],
                        "PODURL" => "",
                        "timezone" => "",
                        "utc" => "",
                        "referenceCode" => "",
                        "externalreferenceid" => "",
                        "referenceValue" => $orderInformation['referenceValue'] ?? ""
                    ];
                    $this->ci->Singlestatusmodel->updateStatus(json_encode($ordersData));
                }

            }
        }
    }

    public function insertOrderReferences(array $orderInformation): void
    {
        if ($orderInformation['orderID'] == "") {
            log_message("error", "There is no Order No." . $orderInformation['orderID']);
            return;
        }
        $getOrderinfo = $this->ci->common->gettblrowdata(
            ['order_id' => $orderInformation['orderID'], 'status <>' => '0'],
            "id,user_id,shift_id,trip_id,company_code",
            "tb_orders",
            0,
            0
        );
        if (!empty($getOrderinfo)) {
            $orderId = $getOrderinfo['id'];
            $referenceId = $this->ci->customreferencesmodel->getReferenceId($orderInformation);
            if ($referenceId != 0) {
                if (($orderInformation['referenceValue'] == "") && ($orderInformation['statusCode'] == 'AWB')) {
                    log_message("error", "Empty Reference Received " . $orderInformation['orderID'] . " - " . $orderInformation['statusCode']);
                    $ordtypemsg = "Forward Order";
                    $errorMailInfo = [
                        "failmsg" => $orderInformation['city'],
                        "order_id" => $orderId,
                        "ordtype" => $ordtypemsg
                    ];
                    $sendmail = $this->sendemailfornoawb($errorMailInfo);
                    $nocData = [
                        "failMessage" => $orderInformation['city'],
                        "order_id" => $orderId
                    ];
                    $this->sendNOCToWarehouse($nocData);
                    return;
                }
                $referenceData = [
                    'order_id' => $orderId,
                    'reference_id' => $orderInformation['statusCode'],
                    'ref_value' => $orderInformation['referenceValue']
                ];
                $this->ci->customreferencesmodel->addOrderReferences($referenceData);
                if ($orderInformation['statusCode'] == "AWB" && $getOrderinfo['user_id'] == "244") {
                    $checkCarrier = $this->ci->customreferencesmodel->checkOrderCarrier($orderId);
                    if ($checkCarrier == 1) {
                        $this->ci->load->library("uniqloediservices");
                        $this->ci->uniqloediservices->senddocketnumber($orderId);
                    }
                }

                if ((checkAccessConditions('CHECK_STATUS_RETRIGGER_COMPANY', $getOrderinfo['company_code'])) && (checkAccessConditions('CHECK_STATUS_RETRIGGER_REFERENCE', $orderInformation['statusCode']))) {
                    log_message("error", "DTO Order Reference " . $orderId . " - " . $orderInformation['statusCode'] . " - " . $orderInformation['referenceValue']);
                    try {
                        $this->ci->load->library('orderstatusretriggertoedi214');
                        $this->ci->orderstatusretriggertoedi214->retriggeredPreviousStatus($orderId);
                    } catch (Exception $ex) {
                        log_message("error", "Some Problem occured!, While Sending Order Referene to Altova " . $ex->getMessage());
                    }
                }

            }
        }
    }

    public function sendemailfornoawb($mailinfo)
    {
        //log_message("error", "sendemailfornoawb inbound data: " . implode(', ', $mailinfo));

        $orditem = $mailinfo['order_id'];
        $ordtypemsg = $mailinfo['ordtype'];
        $failmsg = $mailinfo['failmsg'];
        $sub1 = "eTN: " . $orditem . " " . $ordtypemsg . " Assigning Failed";
        $this->ci->load->library('email');
        $this->ci->email->from(SVKONEKT_EMAIL, 'svkonekt');
        $this->ci->email->to(UNIQLO_ORDER_MAILS);
        $this->ci->email->subject($sub1);
        $this->ci->email->set_mailtype("html");
        $body = "Dear Team, <br/>";
        $body .= $sub1 . " <br/>";
        $body .= "Details. <br/><br/>";
        $body .= $failmsg . "<br/><br/>";
        $body .= "Thank You <br/>";
        $body .= "Svkonekt <br/>";
        $this->ci->email->message($body);
        $this->ci->email->send();

        return true;
    }

    private function sendNOCToWarehouse($nocData)
    {
        $setNocData = [
            "allocated_carrier_id" => 0,
            "allocate_status" => 1,
            "nsz" => $nocData['failMessage']
        ];
        $whereData = [
            "order_id" => $nocData['order_id']
        ];
        $this->ci->common->updatetbledata("tb_allocate_ratio_txn", $setNocData, $whereData);
        $orderWhere = [
            "id" => $nocData['order_id']
        ];
        $orderSetData = [
            "status" => 1,
            "shift_id" => 0
        ];

        $this->ci->common->updatetbledata("tb_orders", $orderSetData, $orderWhere);

        $this->ci->uniqloediservices->senddocketnumber($nocData['order_id']);
    }
}
