<?php
require_once APPPATH . "/third_party/PHPExcel.php";
class Dailyincustbsreport
{

    private const MAIL_ATTACHMENT_PATH = 'assets/BS_Report/';
    private $ci;
    private $customersId;
    private $customersEmails;
    private $customersTestEmails;
    private $emailSubject;
    private $fileName;
    public function __construct()
    {
        $this->ci = &get_instance();
        $this->ci->load->model('common');
        $this->ci->load->model('DataArrayFormatter_model');
        $this->ci->load->model('DataQueryFormatter_model');
        $this->ci->load->model('Datatables_model');
    }


    public function generateEatonReport()
    {
        $this->customersId = '5241,7377,7378';
        $this->customersEmails = EATON_CUST_MAILS;
        $this->customersTestEmails = EATON_CUST_TEST_MAILS;
        $this->emailSubject = date('Y-m-d') . " : Eaton Basic Shipment Report";
        $this->fileName = 'EATONbasicshipmentreport_' . date("dMy") . '.xlsx';
        $this->generateReport();
    }

    public function generateEricssonReport()
    {
        $this->customersId = '12';
        $this->customersEmails = ERICSSON_CUST_MAILS;
        $this->customersTestEmails = ERICSSON_CUST_TEST_MAILS;
        $this->emailSubject = date('Y-m-d') . " : Ericsson Basic Shipment Report";
        $this->fileName = 'EricssonBasicshipmentreport_' . date("dMy") . '.xlsx';
        $this->generateReport();
    }

    public function generateMultipleCustomersBSRReport(int $customerId, string $name)
    {
        $this->customersId = $customerId;
        $this->customersTestEmails = $this->customersEmails = MULTICUST_BSR_TEST_MAILS;
        $this->emailSubject = date('Y-m-d') . " : <b>".$name."</b> Basic Shipment Report";
        $this->fileName = str_replace(" ","",$name).'-Basicshipmentreport_' . date("dMy") . '.xlsx';
        $this->generateReport();
    }

    private function generateReport()
    {
        $data = [];
        $timeZone = "Asia/Kolkata";
        $defaultTimeZone = "UTC";
        $orderTableCondition = $where = [];
        $selectColumns = [
            'o.id',
            'o.order_id',
            'o.pickup_datetime',
            'o.delivery_datetime',
            'o.pickup_company',
            'o.delivery_company',
            'o.pickup_country',
            'o.delivery_country',
            'o.pickup_city',
            'o.delivery_city',
            'o.pickup_pincode',
            'o.delivery_pincode',
            'o.pickup_address2',
            'o.delivery_address2',
            'o.goods_value',
            'o.transport_mode',
            'o.drop_endtime',
            'o.createdon',
            'o.customer_id',
            'o.shift_id',
            's.createdon as delivered_date',
            'v.name as vendor_name',
            'cust.id as customer_id',
            'cust.name as customer_name',
        ];
        $tableName = 'tb_orders o';
        $indexColumn = 'o.id';
        $groupBy = 'o.id';
        $excludeCountQuery = 'Yes';
        $date = date('Y-m-d H:i:s');
        if ($date != "") {
            $ddate = date('Y-m-d', strtotime($date));
            $pastdate = date('Y-m-d', strtotime("-1 days"));
            $ydate = date('Y-m-d', strtotime("-60 days"));
            $where["DATE_FORMAT(s.createdon,'%Y-%m-%d') >="] = $ydate;
            $where["DATE_FORMAT(s.createdon,'%Y-%m-%d') <="] = $ddate;
        }
        if (!empty($where)) {
            foreach ($where as $key => $value) {
                $value = "'$value'";
                $orderTableCondition[] = $key . $value;
            }
        }
        $orderTableCondition[] = "o.trip_id!= 0";
        $orderTableCondition[] = "o.status!= 0";
        $orderTableWhere = implode(' AND ', $orderTableCondition);
        if ($orderTableWhere != '') {
            $orderTableWhere = " and $orderTableWhere ";
        }
        $orderTableWhere .= " and o.customer_id in ($this->customersId)";
        $wherecondition = $indexColumn . "!='' " . $orderTableWhere;
        $dataTableSortOrdering = [];
        $joinsArray[] = [
            'table_name' => 'tb_stop_status as s',
            'condition' => "s.order_id=o.id AND s.status ='1'",
            'join_type' => 'left'
        ];
        $joinsArray[] = [
            'table_name' => 'tb_vendors as v',
            'condition' => "v.id=o.vendor_id AND v.status ='1'",
            'join_type' => 'left'
        ];
        $joinsArray[] = [
            'table_name' => 'tb_customers as cust',
            'condition' => "cust.id=o.customer_id",
            'join_type' => 'left'
        ];
        $getRecordListing = $this->ci->Datatables_model->datatablesQuery($selectColumns, $dataTableSortOrdering, $tableName, $joinsArray, $wherecondition, $indexColumn, 'TRUE', $groupBy, $excludeCountQuery, 'POST');
        $reqData = ['id', 'shift_id'];
        $this->ci->db->query('SET SESSION  group_concat_max_len=10240');
        $formattedData = $this->ci->DataArrayFormatter_model->getCommaSeparatedFields($reqData, $getRecordListing['data']);
        if (isset($formattedData['commaSeparated']['id']) && $formattedData['commaSeparated']['id'] != '') {
            $formattedData = $this->ci->DataQueryFormatter_model->getOrderReferenceData($formattedData['commaSeparated']['id'], $formattedData);
            $formattedData = $this->ci->DataQueryFormatter_model->getOrderCargoDetails($formattedData['commaSeparated']['id'], $formattedData);
            $formattedData = $this->ci->DataQueryFormatter_model->getOrderCargoContent($formattedData['commaSeparated']['id'], $formattedData);
            $formattedData = $this->ci->DataQueryFormatter_model->getEstimatedPickup($formattedData['commaSeparated']['id'], $formattedData);
            $formattedData = $this->ci->DataQueryFormatter_model->getPODDelivered($formattedData['commaSeparated']['id'], $formattedData);
            $formattedData = $this->ci->DataQueryFormatter_model->getOrderStatusDates($formattedData['commaSeparated']['id'], $formattedData);
            $formattedData = $this->ci->DataQueryFormatter_model->getOrderStopStatusStatus($formattedData['commaSeparated']['id'], $formattedData);
        }

        if (isset($formattedData['commaSeparated']['shift_id']) && $formattedData['commaSeparated']['shift_id'] != '') {
            $deliveredStatusArray = $this->ci->DataQueryFormatter_model->getStopStatusDelviered($formattedData['commaSeparated']['shift_id']);
            $genericStatusArray = $this->ci->DataQueryFormatter_model->getStopStatusGeneric($formattedData['commaSeparated']['shift_id']);
        }
        $getRecordListing = [];
        if (isset($formattedData['orders'])) {
            $getRecordListing = $formattedData['orders'];
            krsort($getRecordListing);
        }
        if (!empty($getRecordListing)) {
            foreach ($getRecordListing as $res) {
                $delivery_date = $delivery_dtime = "";
                if (isset($res['delivered_date'])) {
                    $utcdelivery_date = $res['delivered_date'];
                    if ($utcdelivery_date != "" && $utcdelivery_date != "0000-00-00 00:00:00") {
                        $d_date = getdatetimebytimezone($timeZone, $utcdelivery_date, $defaultTimeZone);
                        $delivery_date = date('Y-m-d', strtotime($d_date['datetime']));
                        $delivery_dtime = date('Y-m-d H:i:s', strtotime($d_date['datetime']));
                    }
                }
                $referenceData = $res['reference_value'] ?? "";
                $arrayData = $this->ci->DataArrayFormatter_model->formatReferenceParameters($referenceData);
                $store_code = $arrayData['COI'] ?? "";
                $scannedQuantity = $res['scanned_quantity'] ?? '';
                $totalQuantity = $res['totqty'] ?? '';
                $totalWeight = $res['totwg'] ?? '';
                $totalVolume = $res['totvolume'] ?? '';
                $estDeliveryDate = $podAvailable = "";

                if ($res['delivery_datetime'] != "" && $res['delivery_datetime'] != "0000-00-00 00:00:00") {
                    $estd_date = getdatetimebytimezone($timeZone, $res['delivery_datetime'], $defaultTimeZone);
                    $estDeliveryDate = date('Y-m-d', strtotime($estd_date['datetime']));
                }
                if (isset($res['pod_available'])) {
                    if ($res['pod_available'] != "" && $res['pod_available'] != "0000-00-00 00:00:00") {
                        $podavailable = getdatetimebytimezone($timeZone, $res['pod_available'], $defaultTimeZone);
                        $podAvailable = date('Y-m-d h:i A', strtotime($podavailable['datetime']));
                    }
                }
                $this->ci->load->helper('local_timezone_helper');
                $date = '0000-00-00 00:00:00';
                if (isset($res['estimated_pickup_time'])) {
                    $estimatedPickupTime = dateConvertByTimeZone($res['estimated_pickup_time'], 'UTC', $timeZone);
                    if ($estimatedPickupTime != '') {
                        $createdon = $estimatedPickupTime;
                    } else {
                        $createdon = '';
                    }
                } else {
                    $createdon = '';
                }
                if (isset($res['delivery_datetime'])) {
                    $estimatedDeliveryTime = dateConvertByTimeZone($res['delivery_datetime'], 'UTC', $timeZone);
                    if ($estimatedDeliveryTime != '') {
                        $estimateDeliveryDate = $estimatedDeliveryTime;
                    } else {
                        $estimateDeliveryDate = '';
                    }
                } else {
                    $estimateDeliveryDate = '';
                }

                /* Time zone conversions*/
                if (isset($res['pickup_datetime'])) {
                    $res['pickup_datetime'] = dateConvertByTimeZone($res['pickup_datetime'], 'UTC', $timeZone);
                }
                if (isset($res['drop_endtime'])) {
                    $res['drop_endtime'] = dateConvertByTimeZone($res['drop_endtime'], 'UTC', $timeZone);
                }
                if (isset($res['delivery_datetime'])) {
                    $res['delivery_datetime'] = dateConvertByTimeZone($res['delivery_datetime'], 'UTC', $timeZone);
                }

                if ($createdon != '' || $estimateDeliveryDate != '') {
                    if (($createdon != $date) && ($createdon != null)) {
                        $pickup_date = date("d M Y", strtotime($createdon));
                    } else {
                        $pickup_date = date("d M Y", strtotime($res['pickup_datetime']));
                    }
                } else {
                    $pickup_date = date("d M Y", strtotime($res['pickup_datetime']));
                }

                $reqStatusData = [
                    'status_code' => '',
                    'stop_type' => '',
                    'status_id' => '',
                    'createdon' => '',
                    'loc_name' => '',
                    'latitude' => '',
                    'longitude' => ''
                ];
                if (isset($res['shift_id']) && $res['shift_id'] > 0) {
                    $shiftIndex = $res['shift_id'];
                    if (isset($deliveredStatusArray[$shiftIndex])) {
                        if ($deliveredStatusArray[$shiftIndex]['delivered_status_status_code'] == '3000') {
                            $last_status_name = $deliveredStatusArray[$shiftIndex]['delivered_status_status_name'];
                            $reqStatusData['status_code'] = $deliveredStatusArray[$shiftIndex]['delivered_status_status_code'];
                            $reqStatusData['stop_type'] = $deliveredStatusArray[$shiftIndex]['delivered_status_stop_type'];
                            $reqStatusData['status_id'] = $deliveredStatusArray[$shiftIndex]['delivered_status_id'];
                            $reqStatusData['createdon'] = $deliveredStatusArray[$shiftIndex]['delivered_status_createdon'];
                            $reqStatusData['loc_name'] = $deliveredStatusArray[$shiftIndex]['delivered_status_loc_name'];
                            $reqStatusData['latitude'] = $deliveredStatusArray[$shiftIndex]['delivered_status_latitude'];
                            $reqStatusData['longitude'] = $deliveredStatusArray[$shiftIndex]['delivered_status_longitude'];
                        }
                    } else {
                        if (isset($genericStatusArray[$shiftIndex])) {
                            $last_status_name = $genericStatusArray[$shiftIndex]['generic_status_status_name'];
                            $reqStatusData['status_code'] = $genericStatusArray[$shiftIndex]['generic_status_status_code'];
                            $reqStatusData['stop_type'] = $genericStatusArray[$shiftIndex]['generic_status_stop_type'];
                            $reqStatusData['status_id'] = $genericStatusArray[$shiftIndex]['generic_status_id'];
                            $reqStatusData['createdon'] = $genericStatusArray[$shiftIndex]['generic_status_createdon'];
                            $reqStatusData['loc_name'] = $genericStatusArray[$shiftIndex]['generic_status_loc_name'];
                            $reqStatusData['latitude'] = $genericStatusArray[$shiftIndex]['generic_status_latitude'];
                            $reqStatusData['longitude'] = $genericStatusArray[$shiftIndex]['generic_status_longitude'];
                        }
                    }

                    if ($reqStatusData['status_id'] == 1) {
                        if ($reqStatusData['stop_type'] == "P") {
                            $last_status_name = "Pickedup";
                        } else {
                            $last_status_name = "Delivered";
                        }
                    }
                    if ($reqStatusData['status_code'] == '0192' && $reqStatusData['stop_type'] == 'D') {
                        $last_status_name = "In Transit";
                    }
                    if ($reqStatusData['status_code'] == '0420' || ($reqStatusData['status_code'] == '0191' && $reqStatusData['stop_type'] == 'P')) {
                        $last_status_name = "Pick Up";
                    }
                    if ($reqStatusData['status_code'] == '3000' && $reqStatusData['stop_type'] == 'D') {
                        $last_status_name = "Delivered";
                        $date = '0000-00-00 00:00:00';
                        $d_time = getEDAofNZShipmentbyord($res['id']);
                        $d_date = $d_time['time'];
                        if (isset($d_date) && $d_date != "") {
                            if (($d_date != $date) || (strtotime($d_date) > 0)) {
                                $delivery_date = date("d M Y", strtotime($d_date));
                            } else {
                                $delivery_date = "";
                            }
                        }
                    }
                    $last_loc = "";
                    if ($reqStatusData['loc_name'] != null) {
                        $last_loc = $reqStatusData['loc_name'];
                    } else {
                        $lat = $reqStatusData['latitude'];
                        $lng = $reqStatusData['longitude'];
                        if ($lat != '' && $lng != '') {
                            $last_loc = getLocationName($lat, $lng);
                        }
                    }
                }
                $invoice_num = $arrayData['IV'] ?? '';
                $cust_reference_num = $arrayData['CR'] ?? ($arrayData['DQ'] ?: "");
                $docket_num = $arrayData['AWB'] ?? ($arrayData['BN'] ?? $arrayData['DQ']);
                $consignment_num = $arrayData['DQ'] ?? "";
                $container_num = $arrayData['CTR'] ?? $res['order_id'];
                if (isset($res['cargo_content'])) {
                    $dummyTempContentArray = explode('?????', $res['cargo_content']);
                    $tempContentArray = array_unique($dummyTempContentArray);
                    $res['cargo_content'] = implode(',', $tempContentArray);
                } else {
                    $res['cargo_content'] = '';
                }
                $order_cdate = $res['createdon'];
                if ($order_cdate != "" && $order_cdate != "0000-00-00 00:00:00" && $order_cdate != "0") {
                    $ocreatedon = getdatetimebytimezone($timeZone, $order_cdate, DFLT_TZ);
                    $order_cdate = date('Y-m-d h:i A', strtotime($ocreatedon['datetime']));
                }
                $carrierservice = $scanned_date = $manifest = $accepted = $statusRecord = $transit = "";
                if (isset($res['stop_status_code'])) {
                    if ($res['stop_status_code'] != '') {
                        $stopStatusArray = [$res['stop_status_createdon'], $res['stop_status_code']];
                        $getStopStatusArray = $this->ci->DataArrayFormatter_model->buildGenericArray($stopStatusArray);
                        if (!empty($getStopStatusArray)) {
                            foreach ($getStopStatusArray as $eachItem) {
                                if ($eachItem['status_code'] == '3000') {
                                    //delivery time
                                    $delivered_time = $eachItem['createdon'];
                                    if ($delivered_time != "" && $delivered_time != "0000-00-00 00:00:00" && $delivered_time != "0") {
                                        $deliverydate = getdatetimebytimezone($timeZone, $delivered_time, DFLT_TZ);
                                        $deliveredTimeFt = date('Y-m-d', strtotime($deliverydate['datetime']));
                                        if ($deliveredTimeFt < $pastdate) {
                                            $statusRecord = 'notvalid';
                                        }
                                    }
                                } elseif ($eachItem['status_code'] == '1550') {
                                    //Transit time
                                    $transit = $eachItem['createdon'];
                                    if ($transit != "" && $transit != "0000-00-00 00:00:00" && $transit != "0") {
                                        $transitdate = getdatetimebytimezone($timeZone, $transit, DFLT_TZ);
                                        $transit = date('Y-m-d h:i A', strtotime($transitdate['datetime']));
                                    }
                                } elseif ($eachItem['status_code'] == '0191') {
                                    //Gate out time
                                    $gateout = $eachItem['createdon'];
                                    if ($gateout != "" && $gateout != "0000-00-00 00:00:00" && $gateout != "0") {
                                        $gateoutdate = getdatetimebytimezone($timeZone, $gateout, DFLT_TZ);
                                        $gateout = date('Y-m-d h:i A', strtotime($gateoutdate['datetime']));
                                    }
                                } elseif ($eachItem['status_code'] == '0500') {
                                    //Pickup  time
                                    $pickupdate = $eachItem['createdon'];
                                    if ($pickupdate != "" && $pickupdate != "0000-00-00 00:00:00" && $pickupdate != "0") {
                                        $pdate = getdatetimebytimezone($timeZone, $pickupdate, DFLT_TZ);
                                        $pickupdate = date('Y-m-d h:i A', strtotime($pdate['datetime']));
                                    }
                                } elseif ($eachItem['status_code'] == '0212') {
                                    //Accepted  time
                                    $accepted = $eachItem['createdon'];
                                    if ($accepted != "" && $accepted != "0000-00-00 00:00:00" && $accepted != "0") {
                                        $pdate = getdatetimebytimezone($timeZone, $accepted, DFLT_TZ);
                                        $accepted = date('Y-m-d h:i A', strtotime($pdate['datetime']));
                                    } else {
                                        $accepted = '';
                                    }
                                }
                            }
                        }
                    }
                }
                $imglink = '';
                if (isset($res['imgpath'])) {
                    $ext = pathinfo($res['imgpath'], PATHINFO_EXTENSION);
                    $imglink = checkimageintmsorknlmv($res['imgpath'], false);
                }
                if (!isset($container_num)) {
                    $container_num = '';
                    $trackLink = '';
                } else {
                    $trackLink = base_url('tracking/ordertracking') . '/' . $container_num;
                }
                $uom = ($res['totwg'] > 0) ? 'Kgs' : '';
                if ($last_status_name == 'Gate Out') {
                    $last_status_name = "Delivered";
                } elseif ($last_status_name == 'Gate In') {
                    $last_status_name = "Pickup";
                }
                $outside_del_area = $service_mode = $remarks = '';
                if ($statusRecord == '') {
                    $data[] = [
                        'docket_num' => $docket_num,
                        'order_id' => $res['order_id'],
                        'invoice_num' => $invoice_num,
                        'container_no' => $container_num,
                        'cust_reference_num' => $cust_reference_num,
                        'consignment_note' => $consignment_num,
                        'goods_value' => $res['goods_value'],
                        'transport_mode' => $res['transport_mode'],
                        'shipper_name' => $res['pickup_company'],
                        'shipper_city' => $res['pickup_city'],
                        'shipper_state' => $res['pickup_address2'],
                        'shipper_pincode' => $res['pickup_pincode'],
                        'consignee_name' => $res['delivery_company'],
                        'consignee_city' => $res['delivery_city'],
                        'consignee_state' => $res['delivery_address2'],
                        'consignee_postalcode' => $res['delivery_pincode'],
                        'store_code' => $store_code,
                        'service_type' => $carrierservice,
                        'goods_desc' => '',
                        'total_pckgs' => $totalQuantity,
                        'scanned' => $scannedQuantity,
                        'weight' => $totalWeight,
                        'volume' => $totalVolume,
                        'vendor_name' => $res['vendor_name'],
                        'est_del_date' => $estDeliveryDate,
                        'transit' => $transit,
                        'pod_available' => $podAvailable,
                        'tracking_link' => $trackLink,
                        'pod' => $imglink,
                        'outside_del_area' => $outside_del_area,
                        'service_mode' => $service_mode,
                        'remarks' => $remarks,
                        'last_loc' => $last_loc,
                        'manifest' => $manifest,
                        'scanned_date' => $scanned_date,
                        'last_status_name' => $last_status_name,
                        'uom' => $uom,
                        'delivery_date' => $delivery_date,
                        'accepted' => $accepted,
                        'order_cdate' => $order_cdate,
                        'pickup_date' => $pickup_date,
                        'estimate_d_date' => $estimateDeliveryDate,
                        'volumetric_weight' => $res['volumetric_weight'],
                        'delivery_dtime' => $delivery_dtime,
                        'customer_name'=>$res['customer_name']
                    ];
                }
            }
        }
        $info = $this->downloadexceldata($data);
        if ($info['attachment'] != "") {
              $this->sendmailtocust($info);
        }
    }

    private function sendmailtocust($data)
    {
        $this->ci->load->library('email');
        $this->ci->email->from(SVKONEKT_EMAIL, 'svkonekt');
        $cc_mail = [];
        if (SYS_TYPE == 'TMS') {
            $rec_mail = $this->customersEmails;
        } else {
            $rec_mail = $this->customersTestEmails;
        }
        if (!empty($rec_mail)) {
            $this->ci->email->to($rec_mail);
            $message = "<b>Greetings from Kuehne + Nagel!<b><br>";
            $message .= "<br><b>Dear Sir / Madam,<b><br><br>
            Please find the attached Daily Shipment Report.<br>
            Looking forward to more opportunities to be of service to you.<br><br><br>
            Sincerely,<br>
            Customer Service Team<br>
            Mobile +91-9574730799.<br><br><br><br>";
            if (!empty($cc_mail)) {
                $this->ci->email->cc($cc_mail);
            }
            $this->ci->email->subject($this->emailSubject);
            $this->ci->email->set_mailtype("html");
            $this->ci->email->message($message);
            $epodpath = sprintf('%s/%s', self::MAIL_ATTACHMENT_PATH, $data['attachment']);
            $this->ci->email->attach($epodpath);
            $this->ci->email->print_debugger();
            $this->ci->email->send();

            if(!$this->ci->email->send()) {
                log_message("error", "BSReport >> sendmail >> " . $this->ci->email->print_debugger());
            } else {
                echo "Mail Sent Successfully";
            }

            $this->ci->email->clear(true);
        }
    }

    private function downloadexceldata($data): array
    {
        $fileName =  "";
        if (!empty($data)) {
            $styleArray = [
                'font' => [
                    'bold' => true,
                    'color' => ['rgb' => 'FFFFFF'],
                    'size' => 10,
                    'name' => 'Verdana'
                ]
            ];
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->setActiveSheetIndex(0);
            $objPHPExcel->getActiveSheet()
                ->getStyle('A1:AN1')
                ->applyFromArray(
                    [
                        'fill' => [
                            'type' => PHPExcel_Style_Fill::FILL_SOLID,
                            'color' => ['rgb' => '0c3b81']
                        ]
                    ]
                );
            $objPHPExcel->getActiveSheet()->SetCellValue('A1', 'Vendor Docket Number');
            $objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('B1', 'Customer Name');
            $objPHPExcel->getActiveSheet()->getStyle('B1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('C1', 'Customer Invoice Reference Number');
            $objPHPExcel->getActiveSheet()->getStyle('C1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('D1', 'Container Number');
            $objPHPExcel->getActiveSheet()->getStyle('D1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('E1', 'Consignment Note');
            $objPHPExcel->getActiveSheet()->getStyle('E1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('F1', 'Invoice Value');
            $objPHPExcel->getActiveSheet()->getStyle('F1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('G1', 'Mode Of Transport');
            $objPHPExcel->getActiveSheet()->getStyle('G1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('H1', 'Shipper Name');
            $objPHPExcel->getActiveSheet()->getStyle('H1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('I1', 'Shipper City');
            $objPHPExcel->getActiveSheet()->getStyle('I1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('J1', 'Shipper State');
            $objPHPExcel->getActiveSheet()->getStyle('J1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('K1', 'Shipper Pincode');
            $objPHPExcel->getActiveSheet()->getStyle('K1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('L1', 'Consignee Name');
            $objPHPExcel->getActiveSheet()->getStyle('L1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('M1', 'Consignee City');
            $objPHPExcel->getActiveSheet()->getStyle('M1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('N1', 'Consignee State');
            $objPHPExcel->getActiveSheet()->getStyle('N1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('O1', 'Consignee Postalcode');
            $objPHPExcel->getActiveSheet()->getStyle('O1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('P1', 'Invoice Number');
            $objPHPExcel->getActiveSheet()->getStyle('P1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('Q1', 'Outside Delivery Area (ODA)/Regular Service Location (RSL)');
            $objPHPExcel->getActiveSheet()->getStyle('Q1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('R1', 'Service Mode');
            $objPHPExcel->getActiveSheet()->getStyle('R1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('S1', 'Goods Description');
            $objPHPExcel->getActiveSheet()->getStyle('S1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('T1', 'Total Pkgs');
            $objPHPExcel->getActiveSheet()->getStyle('T1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('U1', 'Scanned Quantity');
            $objPHPExcel->getActiveSheet()->getStyle('U1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('V1', 'Gross Weight');
            $objPHPExcel->getActiveSheet()->getStyle('V1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('W1', 'UOM');
            $objPHPExcel->getActiveSheet()->getStyle('W1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('X1', 'Volumetric Weight');
            $objPHPExcel->getActiveSheet()->getStyle('X1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('Y1', 'Vendor Name');
            $objPHPExcel->getActiveSheet()->getStyle('Y1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('Z1', 'Booking Date');
            $objPHPExcel->getActiveSheet()->getStyle('Z1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('AA1', 'Scanned Date');
            $objPHPExcel->getActiveSheet()->getStyle('AA1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('AB1', 'Manifest');
            $objPHPExcel->getActiveSheet()->getStyle('AB1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('AC1', 'Pickup Date');
            $objPHPExcel->getActiveSheet()->getStyle('AC1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('AD1', 'Accepted by Driver');
            $objPHPExcel->getActiveSheet()->getStyle('AD1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('AE1', 'In Transit');
            $objPHPExcel->getActiveSheet()->getStyle('AE1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('AF1', 'Estimated Delivery Date');
            $objPHPExcel->getActiveSheet()->getStyle('AF1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('AG1', 'Delivered to Consignee');
            $objPHPExcel->getActiveSheet()->getStyle('AG1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('AH1', 'Delivery Date');
            $objPHPExcel->getActiveSheet()->getStyle('AH1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('AI1', 'Last Status');
            $objPHPExcel->getActiveSheet()->getStyle('AI1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('AJ1', 'Last location');
            $objPHPExcel->getActiveSheet()->getStyle('AJ1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('AK1', 'POD Available');
            $objPHPExcel->getActiveSheet()->getStyle('AK1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('AL1', 'Remarks for On Hold or In-Transit Status');
            $objPHPExcel->getActiveSheet()->getStyle('AL1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('AM1', 'Tracking Link');
            $objPHPExcel->getActiveSheet()->getStyle('AM1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('AN1', 'POD Download');
            $objPHPExcel->getActiveSheet()->getStyle('AN1')->applyFromArray($styleArray);
            $rowCount = 2;

            foreach ($data as $result) {
                $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $result['docket_num']);
                $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $result['customer_name']);
                $objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $result['cust_reference_num']);
                $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $result['container_no']);
                $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $result['consignment_note']);
                $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, $result['goods_value']);
                $objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount, $result['transport_mode']);
                $objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount, $result['shipper_name']);
                $objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount, $result['shipper_city']);
                $objPHPExcel->getActiveSheet()->SetCellValue('J' . $rowCount, $result['shipper_state']);
                $objPHPExcel->getActiveSheet()->SetCellValue('K' . $rowCount, $result['shipper_pincode']);
                $objPHPExcel->getActiveSheet()->SetCellValue('L' . $rowCount, $result['consignee_name']);
                $objPHPExcel->getActiveSheet()->SetCellValue('M' . $rowCount, $result['consignee_city']);
                $objPHPExcel->getActiveSheet()->SetCellValue('N' . $rowCount, $result['consignee_state']);
                $objPHPExcel->getActiveSheet()->SetCellValue('O' . $rowCount, $result['consignee_postalcode']);
                $objPHPExcel->getActiveSheet()->SetCellValue('P' . $rowCount, $result['invoice_num']);
                $objPHPExcel->getActiveSheet()->SetCellValue('Q' . $rowCount, $result['outside_del_area']);
                $objPHPExcel->getActiveSheet()->SetCellValue('R' . $rowCount, $result['service_mode']);
                $objPHPExcel->getActiveSheet()->SetCellValue('S' . $rowCount, $result['goods_desc']);
                $objPHPExcel->getActiveSheet()->SetCellValue('T' . $rowCount, $result['total_pckgs']);
                $objPHPExcel->getActiveSheet()->SetCellValue('U' . $rowCount, $result['scanned']);
                $objPHPExcel->getActiveSheet()->SetCellValue('V' . $rowCount, $result['weight']);
                $objPHPExcel->getActiveSheet()->SetCellValue('W' . $rowCount, $result['uom']);
                $objPHPExcel->getActiveSheet()->SetCellValue('X' . $rowCount, $result['volumetric_weight']);
                $objPHPExcel->getActiveSheet()->SetCellValue('Y' . $rowCount, $result['vendor_name']);
                $objPHPExcel->getActiveSheet()->SetCellValue('Z' . $rowCount, $result['order_cdate']);
                $objPHPExcel->getActiveSheet()->SetCellValue('AA' . $rowCount, $result['scanned_date']);
                $objPHPExcel->getActiveSheet()->SetCellValue('AB' . $rowCount, $result['manifest']);
                $objPHPExcel->getActiveSheet()->SetCellValue('AC' . $rowCount, $result['pickup_date']);
                $objPHPExcel->getActiveSheet()->SetCellValue('AD' . $rowCount, $result['accepted']);
                $objPHPExcel->getActiveSheet()->SetCellValue('AE' . $rowCount, $result['transit']);
                $objPHPExcel->getActiveSheet()->SetCellValue('AF' . $rowCount, $result['estimate_d_date']);
                $objPHPExcel->getActiveSheet()->SetCellValue('AG' . $rowCount, $result['delivery_dtime']);
                $objPHPExcel->getActiveSheet()->SetCellValue('AH' . $rowCount, $result['delivery_dtime']);
                $objPHPExcel->getActiveSheet()->SetCellValue('AI' . $rowCount, $result['last_status_name']);
                $objPHPExcel->getActiveSheet()->SetCellValue('AJ' . $rowCount, $result['last_loc']);
                $objPHPExcel->getActiveSheet()->SetCellValue('AK' . $rowCount, $result['pod_available']);
                $objPHPExcel->getActiveSheet()->SetCellValue('AL' . $rowCount, $result['remarks']);
                // trackLink
                $objPHPExcel->getActiveSheet()->SetCellValue('AM' . $rowCount, '=Hyperlink("' . $result['tracking_link'] . '","Track")');
                if (isset($result['pod'])) {
                    if ($result['pod'] != '') {
                        $objPHPExcel->getActiveSheet()->SetCellValue('AN' . $rowCount, '=Hyperlink("' . $result['pod'] . '","Download")');
                    } else {
                        $objPHPExcel->getActiveSheet()->SetCellValue('AN' . $rowCount, "No POD");
                    }
                } else {
                    $objPHPExcel->getActiveSheet()->SetCellValue('AN' . $rowCount, "No POD");
                }
                $rowCount++;
            }
            $fileName = $this->fileName;
            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
            if (!file_exists(self::MAIL_ATTACHMENT_PATH)) {
                mkdir($concurrentDirectory = self::MAIL_ATTACHMENT_PATH, 0710, true);
            }
            $objWriter->save(str_replace(__FILE__, self::MAIL_ATTACHMENT_PATH . '/' . $fileName, __FILE__));
        }
        $info = ['attachment' => $fileName];
        return $info;
    }
}
