<?php 

/**
 * Description of EdiEngine
 *      It will manages  EDI's chunk of tasks.   
 *       
 * @author Apple
 */
class Edi_engine {

    private $ci;
 
    //put your code here
    function __construct() {
 
        $this->ci = & get_instance();
        $this->ci->load->model('common');
        $this->ci->load->model('Order');
    }

    /*
     *  Purpose:    Based on shipment Id we will fetch order ids from tb_orders table.
     *  @param      shipmentid      int    
     *  return      array       
     */

    function getOrderIds($shipment_id) {
        $orderids = array();
        $where = array("shift_id" => $shipment_id);
        $orderids = $this->ci->common->gettbldata($where, "id", "tb_orders", 0,
                0);
        return $orderids;
    }

    /*
     *  Purpose:    Based on Order Id we will fech OrderRelated Routing Information. from tb_order and tb_order_details.
     *  @param      orderid      int    
     *  return      array  
     */

    function getOrderRoutingDetails($order_id) {
        $result = array();
        $res = $this->ci->Order->getordertoedit($order_id); // ->row_array();
        if ($res->num_rows() > 0) {
            $result = $res->row_array();
        }
        return $result;
    }

    /*
     *  Purpose : To get Order id related cargo details sums
     *  @param      order_id        int
     *  return      array
     */

    function getCargoDetailsSum($order_id) {
        $where = array("order_id" => $order_id, "status" => 1);
        $params = "count(*) total_cargos_count,group_concat(cargo_id,',') cargo_id, group_concat(handling_unit,',') handling_unit, sum(length) as length, sum(width) width, sum(height) height, sum(weight) weight, sum(volume) volume, sum(quantity) quantity,quantity_type,cargo_content";
        $this->ci->db->select($params);
        $this->ci->db->from('tb_order_cargodetails');
        $this->ci->db->where($where);
        $this->ci->db->group_by('order_id');
        $result = $this->ci->db->get()->row_array();
        return $result;
    }
    
     /*
     *  Purpose : To get shipper and consingee details.
     *  @param      type        string      Shipper || Consignee  
     *  @param      ord_row_id  int     
     *  return      array
     */

    
    function getOrderParites($type, $ord_row_id) {

        
        $result = array();
        $select = array("pm.order_id", "pm.party_master_id", "pm.location_id", "pm.street",
            "pm.address", "pm.pincode", "pm.country");
        $from = array("`tbl_party_types` pt,`tb_order_parties` po, `tbl_orderparty_address` pm");
        $where = "po.party_type=pt.id and po.party_id = pm.party_master_id";
        $where1 = array("pt.name" => $type, "po.order_id" => $ord_row_id, "pm.order_id" => $ord_row_id);

        $shipper_info = $this->ci->db->select($select)
                        ->from($from)
                        ->where($where)->where($where1)->get();
        if ($shipper_info->num_rows() > 0) {
            $result = $shipper_info->row_array();
            $party_master_id = $shipper_info->row()->party_master_id;
            $getname = $this->ci->db->select(array("name", "email", "mobile"))
                            ->from('tbl_party_master')
                            ->where(array("id" => $party_master_id))->get();
            if ($getname->num_rows() > 0) {
                $result['name'] = $getname->row()->name;
                $result['email'] = $getname->row()->email;
                $result['mobile'] = $getname->row()->mobile;
            }
        } else {
            $select = "pm.name,pm.email,pm.mobile,pm.location_id,pm.address,pm.street,pm.pincode,po.order_id";
            $from = "`tbl_party_types` pt,`tb_order_parties` po, `tbl_party_master` pm";
            $where = "po.party_type=pt.id and po.party_id=pm.id";
            $where1 = array('pt.name' => $type, "po.order_id" => $ord_row_id);
            
            $shipperinfo = $this->ci->db->select($select)
                                        ->from($from)
                                        ->where($where)->where($where1)->get();
            if ($shipper_info->num_rows() > 0) {
                $result = $shipper_info->row_array();
            }
        }
        return $result;
    }  


 /*
     *  Purpose : To get pickup  and deliviry instructions.
     *  @param      ord_row_id  int     
     *  return      array
     */


    function gePickupInstructins($ord_row_id) {
        $ci = &get_instance();
        $ci->load->model("common");
        $result = array();
        $pickup_detais = $ci->common->gettbldata(array('order_id' => $ord_row_id,'reference_id' =>'ORD_PIKINST'),
        "reference_id,ref_value", "tb_order_references", 0, 0);
 

        if (count($pickup_detais) != 0) { 
            return $pickup_detais[0]['ref_value']; 
        } 
      
    }


    function geDeliverInstructins($ord_row_id) {
 
        $ci = &get_instance();
        $ci->load->model("common");
        $result = array();
        $deliver_detais = $ci->common->gettbldata(array('order_id' => $ord_row_id,'reference_id' =>'ORD_DLVINST'),
        "reference_id,ref_value", "tb_order_references", 0, 0);

        if (count($deliver_detais) != 0) { return $deliver_detais[0]['ref_value']; }
      
      
    }

    /*
     *  Purpose : To get shipper and consingee details.
     *  @param      type        string      Career
     *  @param      ord_row_id  int     
     *  return      array
     */

    function gecareerdDetails($ord_row_id) {
        $ci = &get_instance();
        $result = array();
		$resultqry = $ci->db->query("SELECT p.id,p.party_type_id, p.name, p.mobile, 
    p.email,p.partyindetifier,p.code, p.location_id, p.address, p.country,p.state, pt.name,
    p.street, p.pincode, o.party_type, a.party_master_id, a.location_id as plocation_id,
    a.street as pstreet,a.state as pstate,a.address as paddress,a.pincode as ppincode,
    a.country as pcountry FROM tbl_party_master p INNER JOIN tb_order_parties o ON 
    p.id=o.party_id AND o.status=1 LEFT JOIN tbl_orderparty_address
     a ON o.party_id=a.party_master_id AND o.order_id=a.order_id AND a.status=1 LEFT JOIN tbl_party_types  pt ON p.party_type_id=pt.id
     WHERE p.status=1 AND o.order_id='$ord_row_id' and pt.name='Carrier' GROUP BY o.party_type");
		if($resultqry->num_rows() > 0){
			$result = $resultqry->result();
		}
        return $result;
    }



    /*
     *  Purpose : All involved prties of order.
     *  @param      ord_row_id  int     
     *  return      array
     */

    function geAllinvolvedParties($ord_row_id) {
        $ci = &get_instance();
        $result = array();
		$resultqry = $ci->db->query("SELECT p.id,p.party_type_id, p.name, p.mobile, 
    p.email,p.partyindetifier,p.code, p.location_id, p.address, p.country,p.state, pt.name,
    p.street, p.pincode, o.party_type, a.party_master_id, a.location_id as plocation_id,
    a.street as pstreet,a.state as pstate,a.address as paddress,a.pincode as ppincode,
    a.country as pcountry FROM tbl_party_master p INNER JOIN tb_order_parties o ON 
    p.id=o.party_id AND o.status=1 LEFT JOIN tbl_orderparty_address
     a ON o.party_id=a.party_master_id AND o.order_id=a.order_id AND a.status=1 LEFT JOIN tbl_party_types  pt ON p.party_type_id=pt.id
     WHERE p.status=1 AND o.order_id='$ord_row_id' GROUP BY o.party_type");
		if($resultqry->num_rows() > 0){
			$result = $resultqry->result();
		}
        return $result;

    }

     /*
     *  Purpose : Chack API already Tiggered or not
     *  @param      ord_row_id  int     
     *  return      int
     */

    function checkTrigerStatus($ord_row_id) {
        $ci = &get_instance();
        $resultqry = $ci->db->query("SELECT * from tb_order_references where order_id='$ord_row_id' and reference_id='RUCK' and status='1'");
         return $resultqry->num_rows();

    }

    
    



}
