<?php

class Edi_logger {

    function __construct() {
        
    }

    private $edi_type=0;
    private $transaction_id=0;
    private $edi_id=0;
    private $edi_name='';
    private $bounded_type=0;
    private $edi_format_type='JSON';
    private $status='';
    private $obj_type='';
    private $txn_obj_id='';
    private $user_id='';
    private $company_code='';
    private $branch_code='';
    private $edi_request='';
    private $edi_response=''; 
    private $obj_type_name='';

    function getEdi_type() {
        return $this->edi_type;
    }

    function getTransaction_id() {
        return $this->transaction_id;
    }

    function getEdi_id() {
        return $this->edi_id;
    }

    function getEdi_name() {
        return $this->edi_name;
    }

    function getBounded_type() {
        return $this->bounded_type;
    }

    function getEdi_format_type() {
        return $this->edi_format_type;
    }

    function getStatus() {
        return $this->status;
    }

    function getObj_type() {
        return $this->obj_type;
    }

    function getTxn_obj_id() {
        return $this->txn_obj_id;
    }

    function getUser_id() {
        return $this->user_id;
    }

    function getCompany_code() {
        return $this->company_code;
    }

    function getBranch_code() {
        return $this->branch_code;
    }

    function getEdi_request() {
        return $this->edi_request;
    }

    function getEdi_response() {
        return $this->edi_response;
    }

    function getObj_type_name() {
        return $this->obj_type_name;
    }
 
    function setEdi_type($edi_type): void {
        $this->edi_type = $edi_type;
    }

    function setTransaction_id($transaction_id): void {
        $this->transaction_id = $transaction_id;
    }

    function setEdi_id($edi_id): void {
        $this->edi_id = $edi_id;
    }

    function setEdi_name($edi_name): void {
        $this->edi_name = $edi_name;
    }

    function setBounded_type($bounded_type): void {
        $this->bounded_type = $bounded_type;
    }

    function setEdi_format_type($edi_format_type): void {
        $this->edi_format_type = $edi_format_type;
    }

    function setStatus($status): void {
        $this->status = $status;
    }

    function setObj_type($obj_type): void {
        $this->obj_type = $obj_type;
    }

    function setTxn_obj_id($txn_obj_id): void {
        $this->txn_obj_id = $txn_obj_id;
    }

    function setUser_id($user_id): void {
        $this->user_id = $user_id;
    }

    function setCompany_code($company_code): void {
        $this->company_code = $company_code;
    }

    function setBranch_code($branch_code): void {
        $this->branch_code = $branch_code;
    }

    function setEdi_request($edi_request): void {
        $this->edi_request = $edi_request;
    }

    function setEdi_response($edi_response): void {
        $this->edi_response = $edi_response;
    }

    function setObj_type_name($obj_type_name): void {
        $this->obj_type_name = $obj_type_name;
    }
    
    function saveToEdiLogs(){
        $this->is_edi_already_register();
        $this->is_edi_object_name_register();
        $params = array(
            'edi_type' => $this->getEdi_type(), // '1->EDI Transport Order,2->EDI Status'
            'transaction_id' => $this->getTransaction_id(),
            'edi_id' => $this->getEdi_id(),
            'edi_name' =>$this->getEdi_name(),
            'bounded_type' => $this->getBounded_type(), // 1->Inbound(partner => kN),2->Outbound (KN => partner)'
            'edi_format_type' => $this->getEdi_format_type(),
            'status' => $this->getStatus(),
            'obj_type' => $this->getObj_type(), // --
            'txn_obj_id' => $this->getTxn_obj_id(), // --
            'user_id' => $this->getUser_id(),
            'company_code' => $this->getCompany_code(),
            'branch_code' => $this->getBranch_code(),
            'edi_request' => $this->getEdi_request(),
            'edi_response' => $this->getEdi_response()
        );
        $ci = & get_instance();
        $ci->load->model('common');
        try {
            $ci->common->insertTableData('tb_etn_edi_transactions', $params);
        } catch (Exception $exc) {
            log_message("error","edi_logger>>saveToEdiLogs input data>>".json_encode($params));
            log_message("error","edi_logger>>saveToEdiLogs>>".$exc->getTraceAsString());
        }

    }

    function is_edi_already_register(){
        $ci = & get_instance();
        $ci->load->model('common'); 
        $result_set = $ci->common->gettblrowdata(array('edi_name'=>$this->getEdi_name()),array('id'),'tb_edi_types',1,0);
        if(isset($result_set['id']) && $result_set['id']>0){
            $this->setEdi_id($result_set['id']); 
        }else{
            $this->setEdi_id($ci->common->insertTableData('tb_edi_types',array('edi_name'=>$this->getEdi_name())));
        }
    }

    function is_edi_object_name_register(){
        $ci = & get_instance();
        $ci->load->model('common'); 
        $result_set = $ci->common->gettblrowdata(array('obj_type_name'=>$this->getObj_type_name()),array('id'),'tb_edi_object_types',1,0);
        if(isset($result_set['id']) && $result_set['id']>0){         
            $this->setObj_type($result_set['id']);
        }else{
            $this->setObj_type($ci->common->insertTableData('tb_edi_object_types',array('obj_type_name'=>$this->getObj_type_name(),"description"=>$this->getObj_type_name())));
        }
    }

    /*
     * Adding a new tb_etn_edi_transaction
     * @param       status          int         => 1-success and 0 fail
     * @param       edi_request     string     
     * @param       edi_response    string      
     */

    function log_bite_transit_transport_order($status, $ediRequest, $ediResponse, $orderId) {
        $ci = & get_instance();
        $order_info = $this->getOrderinfo($orderId);
        if (!empty($order_info)) {
            $this->setEdi_type(1); //'1->EDI Transport Order,2->EDI Status'
            $this->setTransaction_id(time());
            $this->setEdi_name('BiteTransit');
            $this->setBounded_type(2); // '1->Inbound(partner => kN),2->Outbound (KN => partner)'
            $this->setEdi_format_type('JSON');
            $this->setStatus($status);
            $this->setTxn_obj_id($orderId);
            $this->setUser_id($order_info['user_id']);
            $this->setCompany_code($order_info['company_code']);
            $this->setBranch_code($order_info['branch_code']);
            $this->setEdi_request($ediRequest);
            $this->setEdi_response($ediResponse);
            $this->setObj_type_name('order-id');
            $this->saveToEdiLogs();
        }
    }

    function log_bite_transit_transport_status($status, $ediRequest, $ediResponse, $orderId)
    {
        $ci = &get_instance();
        $orderInfo = $this->getOrderinfo($orderId);
        if (!empty($orderInfo)) {
            $this->setEdi_type(1); //'1->EDI Transport Order,2->EDI Status'
            $this->setTransaction_id(time());
            $this->setEdi_name('BiteTransit');
            $this->setBounded_type(1); // '1->Inbound(partner => kN),2->Outbound (KN => partner)'
            $this->setEdi_format_type('XML');
            $this->setStatus($status);
            $this->setTxn_obj_id($orderId);
            $this->setUser_id($orderInfo['user_id']);
            $this->setCompany_code($orderInfo['company_code']);
            $this->setBranch_code($orderInfo['branch_code']);
            $this->setEdi_request($ediRequest);
            $this->setEdi_response($ediResponse);
            $this->setObj_type_name('order-id');
            $this->saveToEdiLogs();
        }
    }

    function log_vozovoz_transport_order($status, $ediRequest, $ediResponse, $orderId) {
        $ci = & get_instance();
        $orderInfo = $this->getOrderinfo($orderId);
        if (!empty($orderInfo)) {
            $this->setEdi_type(1); //'1->EDI Transport Order,2->EDI Status'
            $this->setTransaction_id(time());
            $this->setEdi_name('Vozovoz');
            $this->setBounded_type(2); // '1->Inbound(partner => kN),2->Outbound (KN => partner)'
            $this->setEdi_format_type('JSON');
            $this->setStatus($status);
            $this->setTxn_obj_id($orderId);
            $this->setUser_id($orderInfo['user_id']);
            $this->setCompany_code($orderInfo['company_code']);
            $this->setBranch_code($orderInfo['branch_code']);
            $this->setEdi_request($ediRequest);
            $this->setEdi_response($ediResponse);
            $this->setObj_type_name('order-id');
            $this->saveToEdiLogs();
        }
    }

	/*
		* Edi logger for nicplace.
		* @param       status          int         => 1-success and 0 fail
		* @param       edi_request     string
		* @param       edi_response    string
		* @return void
		*/
    function log_nicplace_transport_order($status, $edi_request, $edi_response, $order_id, $trasaction_id = null)
    {
      $ci = &get_instance();
      $ci->load->model('common');
      $order_info = $ci->common->gettblrowdata(array("order_id" => $order_id), "user_id,company_code,branch_code", "tb_orders", 0, 0);
      $edi_info = $ci->common->gettblrowdata(['edi_name' => 'NICPLACE', 'status' => 1], 'id as edi_id, edi_name', 'tb_edi_types', 0, 0);
      if (!empty($edi_info)) {
        $params = array(
          'edi_type'        => 1,
          'transaction_id'  => $trasaction_id ?? time(),
          'edi_id'          => $edi_info['edi_id'],
          'edi_name'        => $edi_info['edi_name'],
          'bounded_type'    => 2,
          'edi_format_type' => 'JSON',
          'status'          => $status,
          'obj_type'        => 1,
          'txn_obj_id'      => $order_id,
          'user_id'         => $order_info['user_id'],
          'company_code'    => $order_info['company_code'],
          'branch_code'     => $order_info['branch_code'],
          'edi_request'     => $edi_request,
          'edi_response'    => $edi_response
        );
        $ci->common->insertTableData('tb_etn_edi_transactions', $params);
      } else {
        log_message('error', 'Nicplace ins edi_trans failed >>> edi type not existed');
      }
    }

    function log_vozovoz_status($status, $ediRequest, $ediResponse, $orderId)
    {
        $ci = &get_instance();
        $orderInfo = $this->getOrderinfo($orderId);
        if (!empty($orderInfo)) {
            $this->setEdi_type(2); //'1->EDI Transport Order,2->EDI Status'
            $this->setTransaction_id(time());
            $this->setEdi_name('Vozovoz');
            $this->setBounded_type(2); // '1->Inbound(partner => kN),2->Outbound (KN => partner)'
            $this->setEdi_format_type('JSON');
            $this->setStatus($status);
            $this->setTxn_obj_id($orderId);
            $this->setUser_id($orderInfo['user_id']);
            $this->setCompany_code($orderInfo['company_code']);
            $this->setBranch_code($orderInfo['branch_code']);
            $this->setEdi_request($ediRequest);
            $this->setEdi_response($ediResponse);
            $this->setObj_type_name('order-id');
            $this->saveToEdiLogs();
        }
    }

    function log_ruexp_order($status, $ediRequest, $ediResponse, $orderId, $bound)
    {
        $ci = &get_instance();
        $orderInfo = $this->getOrderinfo($orderId);
        if (!empty($orderInfo)) {
            $this->setEdi_type(1); //'1->EDI Transport Order,2->EDI Status'
            $this->setTransaction_id(time());
            $this->setEdi_name('RUEXP');
            $this->setBounded_type($bound); // '1->Inbound(partner => kN),2->Outbound (KN => partner)'
            $this->setEdi_format_type('XML');
            $this->setStatus($status);
            $this->setTxn_obj_id($orderId);
            $this->setUser_id($orderInfo['user_id']);
            $this->setCompany_code($orderInfo['company_code']);
            $this->setBranch_code($orderInfo['branch_code']);
            $this->setEdi_request($ediRequest);
            $this->setEdi_response($ediResponse);
            $this->setObj_type_name('order-id');
            $this->saveToEdiLogs();
        }
    }

    function log_skif_order($status, $edi_request, $edi_response, $order_id, $bound)
    {
        $ci = &get_instance();
        $user_id = "0";
        $company_code = "";
        $branch_code = "";

        $ci->load->model('common');
        if (is_array($edi_response)) {
            $edi_response = json_decode($edi_response);
        }

        // values getting from DB not from session because when cron job runs session will not be there
        if ($order_id != "") {
            $whr = array("order_id" => $order_id);
            $user_details = $ci->common->gettblrowdata($whr, "user_id,company_code,branch_code", "tb_orders", 1, 0);
            $user_id = $user_details['user_id'];
            $company_code = $user_details['company_code'];
            $branch_code = $user_details['branch_code'];

        }

        $params = array(
            'edi_type' => 1, //'1->EDI Transport Order,2->EDI Status'
            'transaction_id' => time(),
            'edi_id' => 4, // edi id based on name take it from tb_edi_types
            'edi_name' => 'SKIF',
            'bounded_type' => $bound, // '1->Inbound(partner => kN),2->Outbound (KN => partner)'
            'edi_format_type' => 'XML',
            'status' => $status,
            'obj_type' => 1,
            'txn_obj_id' => $order_id,
            'user_id' => $user_id,
            'company_code' => $company_code,
            'branch_code' => $branch_code,
            'edi_request' => $edi_request,
            'edi_response' => $edi_response
        );
        $ci->common->insertTableData('tb_etn_edi_transactions', $params);

    }
    function getOrderinfo(string $orderId): array
    {
        $ci = &get_instance();
        $ci->load->model('common');
        $orderInfo = [];
        $getOrderInfo = $ci->common->gettblrowdata(["order_id" => $orderId], "user_id,company_code,branch_code", "tb_orders", 0, 0);
        if (!empty($getOrderInfo)) {
            $orderInfo = $getOrderInfo;
        }
        return $orderInfo;
    }

}

