<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
require_once APPPATH . "/third_party/PHPExcel.php";
require_once './vendor/autoload.php';

use PhpAmqpLib\Message\AMQPMessage;
use PhpAmqpLib\Connection\AMQPSSLConnection;
use PhpAmqpLib\Wire;

class Exchangerate
{

    public function __construct()
    {
        $ci =& get_instance();
        $ci->load->model('common');
        $ci->load->model('Order');
        $ci->load->model('aconedimodel');
        $ci->load->model('Orderrevenuesmodel');
    }

    public function checkorderrevenuecurrency($orderids)
    {
        $ci =& get_instance();
        $company_code = $session_companycode = $ci->session->userdata('company_code');
        $user_currency = $ci->session->userdata("usr_tzone")['currency'];
        if (!empty($orderids)) {
            foreach ($orderids as $ids) {
                $order_id = $ids['ids'];
                $getrevenues = $ci->common->gettbldata(array('order_id' => $order_id, 'invoice_status' => '0', 'status' => '1'), "id,exchange_rate,foreign_currency", "tb_reveneus", 0, 0);
                if (!empty($getrevenues)) {
                    foreach ($getrevenues as $rev) {
                        $revenue_id = $rev['id'];
                        $foreign_currency = $rev['foreign_currency'];
                        $getcharges = $ci->common->gettbldata(array('revenue_id' => $revenue_id, 'status' => '1'), "amount,currency", "tb_charges", 0, 0);
                        if ($company_code == 'PLKN') {
                            $charge_withnousrcurrency = $ci->db->query("SELECT id,amount,currency FROM tb_charges WHERE revenue_id ='" . $revenue_id . "' AND currency NOT LIKE 'PLN' AND status ='1'");
                        } else {
                            $charge_withnousrcurrency = $ci->db->query("SELECT id,amount,currency FROM tb_charges WHERE revenue_id ='" . $revenue_id . "' AND currency NOT LIKE '" . $user_currency . "' AND status ='1'");
                        }

                        if ($charge_withnousrcurrency->num_rows() > 0) {
                            foreach ($charge_withnousrcurrency->result() as $res) {
                                $charge_row_id = $res->id;
                                $charge_amount = $res->amount;
                                $charge_currency = $res->currency;
                                if ($company_code == 'PLKN') {
                                    $exchange_amount = $rev['exchange_rate'];
                                    if ($exchange_amount != "0" && $exchange_amount != "") {
                                        $user_amount = $charge_amount * $exchange_amount;
                                        $charge_amount = round($user_amount, 2);
                                        $upd_charges = $ci->common->updatetbledata("tb_charges", array('local_amount' => $charge_amount, 'local_currency' => 'PLN'), array('id' => $charge_row_id));
                                        if ($upd_charges) {
                                            $upd = $this->updatetotal_amountforrev($revenue_id);
                                        }
                                    }
                                } else {
                                    if ($foreign_currency == $charge_currency) {
                                        $exchange_amount = $rev['exchange_rate'];
                                        if ($exchange_amount != "0" && $exchange_amount != "") {
                                            $user_amount = $charge_amount * $exchange_amount;
                                            $charge_amount = round($user_amount, 2);
                                            if($company_code == "VNKN"){
                                                $charge_amount = round($user_amount);
                                            }
                                            $upd_charges = $ci->common->updatetbledata("tb_charges", array('local_amount' => $charge_amount, 'local_currency' => $user_currency), array('id' => $charge_row_id));
                                            if ($upd_charges) {
                                                $upd = $this->updatetotal_amountforrev($revenue_id);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public function checkordersinglerevenuecurrency($revenue_id)
    {

        $ci =& get_instance();
        $company_code = $session_companycode = $ci->session->userdata('company_code');
        $user_currency = $ci->session->userdata("usr_tzone")['currency'];
        $revenues = $ci->common->gettblrowdata(array('id' => $revenue_id, 'invoice_status' => '0', 'status' => '1'), "id,exchange_rate,foreign_currency", "tb_reveneus", 0, 0);
        if (!empty($revenues)) {
            $revenue_id = $revenues['id'];
            $foreign_currency = $revenues['foreign_currency'];
            $getcharges = $ci->common->gettbldata(array('revenue_id' => $revenue_id, 'status' => '1'), "amount,currency", "tb_charges", 0, 0);
            if ($company_code == 'PLKN') {
                $charge_withnousrcurrency = $ci->db->query("SELECT id,amount,currency FROM tb_charges WHERE revenue_id ='" . $revenue_id . "' AND currency NOT LIKE 'PLN' AND status ='1'");
            } else {
                $charge_withnousrcurrency = $ci->db->query("SELECT id,amount,currency FROM tb_charges WHERE revenue_id ='" . $revenue_id . "' AND currency NOT LIKE '" . $user_currency . "' AND status ='1'");
            }

            if ($charge_withnousrcurrency->num_rows() > 0) {
                foreach ($charge_withnousrcurrency->result() as $res) {
                    $charge_row_id = $res->id;
                    $charge_amount = $res->amount;
                    $charge_currency = $res->currency;
                    if ($company_code == 'PLKN') {
                        $exchange_amount = $revenues['exchange_rate'];
                        if ($exchange_amount != "0" && $exchange_amount != "") {
                            $user_amount = $charge_amount * $exchange_amount;
                            $charge_amount = round($user_amount, 2);
                            $upd_charges = $ci->common->updatetbledata("tb_charges", array('local_amount' => $charge_amount, 'local_currency' => 'PLN'), array('id' => $charge_row_id));
                            if ($upd_charges) {
                                $upd = $this->updatetotal_amountforrev($revenue_id);
                            }
                        }
                    } else {
                        if ($foreign_currency == $charge_currency) {
                            $exchange_amount = $revenues['exchange_rate'];
                            if ($exchange_amount != "0" && $exchange_amount != "") {
                                $user_amount = $charge_amount * $exchange_amount;
                                $charge_amount = round($user_amount, 2);
                                if ($company_code == "VNKN") {
                                    $charge_amount = round($user_amount);
                                }
                                $upd_charges = $ci->common->updatetbledata("tb_charges", array('local_amount' => $charge_amount, 'local_currency' => $user_currency), array('id' => $charge_row_id));
                                if ($upd_charges) {
                                    $upd = $this->updatetotal_amountforrev($revenue_id);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public function updateexchangerate_byorderid($postdata)
    {
        $ci =& get_instance();
        $order_createddate = date('Y-m-d');
        $revenue_count = $accural_count = 0;
        if (!empty($postdata)) {
            $order_id = isset($postdata['ord_id']) ? $postdata['ord_id'] : "0";
            $company_code = isset($postdata['company_code']) ? $postdata['company_code'] : "0";
            $user_id = isset($postdata['user_id']) ? $postdata['user_id'] : "0";
            $user_currency = isset($postdata['session_currency']) ? $postdata['session_currency'] : "0";
            $curdt = date('Y-m-d H:i:s');
            $zonecode = $ci->session->userdata("usr_tzone");
            $curtz = $zonecode['timezone'];
            $cntryname = $zonecode['country_name'];
            $cntrycode = $zonecode['country'];
            $currency = $user_currency;
            $getactual = getdatetimebytimezone($curtz, $curdt, DFLT_TZ);
            $timestamp = $getactual['date'] . "T" . $getactual['time'] . "Z";
            $branch_code = $ci->session->userdata("branch_code");
            $name = $ci->session->userdata("name");
            $country_code = substr($company_code, 0, 2);
            if ($order_id != "0" && $order_id != "") {
                $orderids[] = array('ids' => $order_id);
                $chk_currency = $this->checkorderrevenuecurrency($orderids);
                $curtz = $ci->session->userdata("usr_tzone")['timezone'];
                $order_ids[] = array('ids' => $order_id);
                if (!empty($order_ids)) {

                    $user_id = $ci->session->userdata('user_id');
                    $info = array('order_ids' => $order_ids, 'curtz' => $curtz, 'user_id' => $user_id);
                    $invoiced_row_ids = makeselectedordersasinvoice($info);
                    foreach ($order_ids as $order_id) {
                        $order_id = $order_id['ids'];
                        $delivery_note = "";
                        $getdnote = $ci->db->select("ref_value")->get_where("tb_order_references", array('order_id' => $order_id, 'reference_id' => 'DQ'));
                        if ($getdnote->num_rows() > 0) {
                            $delivery_note = $getdnote->row()->ref_value;
                        }
                        $chkorder = $ci->aconedimodel->getordertoedit($order_id);
                        if ($chkorder->num_rows() > 0) {
                            $cargos = array();
                            $total_volume = $total_weight = $total_quantity = 1;
                            $ordernum = $chkorder->row()->order_id;
                            $where = array('order_id' => $order_id, 'status' => '1');
                            $select = "cargo_id, handling_unit, length, width, height, weight, volume, quantity,quantity_type,cargo_content";
                            $table = "tb_order_cargodetails";
                            $getcargos = $ci->aconedimodel->gettabledata($where, $select, $table);
                            if (count($getcargos) > 0) {
                                foreach ($getcargos as $res) {
                                    $volume = $res['volume'];
                                    $weight = $res['weight'];
                                    if ($volume == "") {
                                        $volume = 1;
                                    }
                                    if ($weight == "") {
                                        $weight = 1;
                                    }
                                    $weight_unit = "KG";
                                    $volume_unit = "CBM";
                                    $goods_description = "N";
                                    if ($res['cargo_id'] != "") {
                                        $chk = $ci->aconedimodel->gettblrowdata(array("id" => $res['cargo_id']), "weight_unit,volume_unit,goods_description", "tb_cargo_details", 0, 0);
                                        if (count($chk) > 0) {
                                            $weight_unit = $chk['weight_unit'];
                                            $volume_unit = $chk['volume_unit'];
                                            if ($chk['goods_description'] != "") {
                                                $goods_description = $chk['goods_description'];
                                            }
                                        }
                                    }
                                    $content = $res['cargo_content'];
                                    if ($content == "") {
                                        $content == "Dummy";
                                    }
                                    $length = $res['length'];
                                    if ($length == "" || $length == 0) {
                                        $length = 1;
                                    }
                                    $width = $res['width'];
                                    if ($width == "" || $width == 0) {
                                        $width = 1;
                                    }
                                    $height = $res['height'];
                                    if ($height == "" || $height == 0) {
                                        $height = 1;
                                    }
                                    $quantity = $res['quantity'];
                                    if ($quantity == "" || $quantity == 0) {
                                        $quantity = 1;
                                    }
                                    $cargos[] = array('cargo_type' => $res['quantity_type'], 'content' => $content, 'length' => $length, 'width' => $width, 'height' => $height, 'weight' => $weight, 'volume' => $volume, 'quantity' => round($quantity), 'weight_unit' => $weight_unit, 'volume_unit' => $volume_unit, 'goods_description' => $goods_description);
                                    $total_volume += $volume;
                                    $total_weight += $weight;
                                    $total_quantity += $res['quantity'];
                                }
                            }
                            if ($chkorder->row()->company_code != "") {
                                $company_code = $chkorder->row()->company_code;
                            }
                            if ($chkorder->row()->branch_code != "") {
                                $branch_code = $chkorder->row()->branch_code;
                            }
                            $transport_mode = $chkorder->row()->transport_mode;
                            if (($transport_mode == "") || (strlen($transport_mode) > 3)) {
                                $transport_mode = "FTL";
                            }
                            $logicalsender = $acon_country = '';
                            $logicalinfo = $ci->db->query("select logical_sender,acon_country from tb_branch_master where company_code='" . $company_code . "' AND branch_code='" . $branch_code . "'");
                            if ($logicalinfo->num_rows() > 0) {
                                $logicalsender = $logicalinfo->row()->logical_sender;
                                $acon_country = $logicalinfo->row()->acon_country;;
                            }
                            $trip_no = $chkorder->row()->shipmentid;
                            $txnid = $incoterm = $insdate = "";
                            $product = $chkorder->row()->product;
                            if ($product == "") {
                                $product = "KN AsiaDirect";
                            }
                            $product = strtolower($product);
                            if ($product == "kn secure chain") {
                                $producttype = "S";
                            } else {
                                $producttype = "L";
                            }
                            $incoterm = $chkorder->row()->incoterm;
                            if ($incoterm == "") {
                                $incoterm = "FOC";
                            }
                            $service = $chkorder->row()->service;
                            $service_type = "";
                            if ($service > 0) {
                                $chkservice = $ci->db->query("select name from tb_service_master where id='" . $service . "' AND status=1");
                                if ($chkservice->num_rows() > 0) {
                                    $service_type = $chkservice->row()->name;
                                }
                            }
                            if ($service_type == "") {
                                $service_type = "Special";
                            }
                            $delivery_term = $chkorder->row()->delivery_term;
                            if ($delivery_term == "") {
                                $delivery_term = 41;
                            }
                            $pickup_country = $chkorder->row()->pickup_country;
                            $delivery_country = $chkorder->row()->delivery_country;
                            $getrevenues = $ci->aconedimodel->getrevenues($order_id);
                            $revenue_ids = $revenues = $charges = array();
                            if ($getrevenues->num_rows() > 0) {
                                foreach ($getrevenues->result() as $res) {
                                    $acon_code = $res->acon_debitor_code;
                                    $debtor_jfr = $res->debtor_jfr;
                                    if (($acon_code != "") && ($debtor_jfr != "")) {
                                        $charges = array();
                                        $getcharges = $ci->aconedimodel->getcharges($res->id);
                                        if ($getcharges->num_rows() > 0) {
                                            foreach ($getcharges->result() as $charge) {
                                                $charges[] = array('charge_code' => $charge->chargecode, 'amount' => $charge->amount, 'currency' => $charge->currency, 'local_amount' => $charge->local_amount, 'local_currency' => $charge->local_currency);
                                            }
                                        }
                                        if (count($charges) > 0) {
                                            $custcountrycode = $ci->aconedimodel->getcompanycode($res->country);
                                            $revpincode = $res->pincode;
                                            if ($revpincode == "") {
                                                $revpincode = 1000;
                                            }
                                            $rev_currency = $res->currency;
                                            if ($rev_currency == "") {
                                                $rev_currency = $currency;
                                            }
                                            if ($company_code == 'PLKN') {
                                                $user_currency = "PLN";
                                            }
                                            $revenues[] = array('revenue_id' => $res->id, 'recipient_role' => $res->recipient_role, 'recipient_code' => $res->recipient_code, 'debtor_jfr' => $res->debtor_jfr, 'bu_jfr' => $res->bu_jfr, 'amount' => $res->amount, 'currency' => $rev_currency, 'exchange_rate' => $res->exchange_rate, 'foreign_currency' => $res->foreign_currency, 'remarks' => $res->remarks, "name" => substr($res->name, 0, 34), "code" => $res->code, "customeridentifier" => $res->customeridentifier, "city" => $res->location_id, "country" => $custcountrycode, "street" => $res->street, "pincode" => $revpincode, "acon_code" => $res->acon_debitor_code, 'charges' => $charges, "delivery_note" => $delivery_note, "local_currency" => $currency, 'acon_country' => $acon_country, 'ordernum' => $ordernum);
                                            $invoice_date = $getactual['date'];
                                            $upd_revenue = $ci->db->where(array('id' => $res->id))->update("tb_reveneus", array('invoice_date' => $invoice_date, 'invoice_status' => 2));
                                            $revenue_count++;
                                        }
                                    }
                                }
                            }

                            $chekparty = $ci->aconedimodel->getparty($order_id);
                            if ($chekparty->num_rows() > 0) {
                                foreach ($chekparty->result() as $rr) {
                                    $ptype = $rr->party_type;
                                    $chktype = $ci->aconedimodel->gettblrowdata(array("id" => $ptype), "name", "tbl_party_types", 0, 0);
                                    if (count($chktype) > 0) {
                                        if ($chktype['name'] == "Consignee") {
                                            $consignee = array('name' => substr($rr->name, 0, 34), 'phone' => $rr->mobile, 'email' => $rr->email, 'code' => $rr->code, 'customeridentifier' => $rr->customeridentifier, 'fax' => $rr->fax);
                                        } else if ($chktype['name'] == "Shipper") {
                                            $shipper = array('name' => substr($rr->name, 0, 34), 'phone' => $rr->mobile, 'email' => $rr->email, 'code' => $rr->code, 'customeridentifier' => $rr->customeridentifier, 'fax' => $rr->fax);
                                        }
                                    }
                                }
                            }
                            $shipper['street'] = $chkorder->row()->pickup_address1;
                            $shipper['state'] = $chkorder->row()->pickup_address2;
                            $shipper['city'] = $chkorder->row()->pickup_city;
                            $shipper['country'] = $ci->aconedimodel->getcompanycode($pickup_country);
                            $shipper['pincode'] = $chkorder->row()->pickup_pincode;

                            $consignee['street'] = $chkorder->row()->delivery_address1;
                            $consignee['state'] = $chkorder->row()->delivery_address2;
                            $consignee['city'] = $chkorder->row()->delivery_city;
                            $consignee['country'] = $ci->aconedimodel->getcompanycode($delivery_country);
                            $consignee['pincode'] = $chkorder->row()->delivery_pincode;

                            if ($shipper['pincode'] == "" || !is_numeric($shipper['pincode'])) {
                                $shipper['pincode'] = 1061;
                            }
                            if ($consignee['pincode'] == "" || !is_numeric($consignee['pincode'])) {
                                $consignee['pincode'] = 1061;
                            }
                            $pickup_datetime = $chkorder->row()->pickup_datetime;
                            $delivery_datetime = $chkorder->row()->delivery_datetime;
                            $getactual = getdatetimebytimezone($curtz, $pickup_datetime, DFLT_TZ);
                            $early_pickup = $getactual['date'] . "T" . $getactual['time'] . "Z";
                            $getactual = getdatetimebytimezone($curtz, $delivery_datetime, DFLT_TZ);
                            $early_delivery = $getactual['date'] . "T" . $getactual['time'] . "Z";
                            $department_code = $chkorder->row()->department_code;
                            if ($department_code == "") {
                                $department_code = "CTP";
                            }
                            $deliverydate = $delivery_datetime;
                            $bookingid = $chkorder->row()->order_id;
                            if ($bookingid != "") {
                                $get_deliverydate = $ci->db->query("select tps.createdon from `tb_stop_status` tps,`tb_shifts` ts,`tb_employee` te where ts.id=tps.shipment_id AND te.shift_id=ts.id  AND tps.stop_type='D' AND tps.status_code='3000' AND te.order_id='" . $bookingid . "' order by tps.id desc LIMIT 1");
                                if ($get_deliverydate->num_rows() > 0) {
                                    $delivery_date = $get_deliverydate->row()->createdon;
                                    if ($delivery_date != "") {
                                        $getactual = getdatetimebytimezone($curtz, $delivery_date, DFLT_TZ);
                                        $deliverydate = $getactual['date'] . "T" . $getactual['time'] . "Z";
                                        /*$deliverydate= date("Y-m-d\TH:i:s\Z",strtotime($delivery_date));*/
                                    }
                                }
                            }
                            $data = array("timestamp" => $timestamp, 'order_id' => $bookingid, 'early_pickup' => $early_pickup, 'early_delivery' => $early_delivery, 'branch_code' => $branch_code, 'company_code' => $company_code, 'department_code' => $department_code, 'cargos' => $cargos, 'total_weight' => $total_weight, 'total_volume' => $total_volume, "currency" => $currency, "trip_no" => $trip_no, "quantity" => round($total_quantity), "incoterm" => $incoterm, "product" => $product, "service_type" => $service_type, 'country_name' => $cntryname, "cntrycode" => $cntrycode, "revenues" => $revenues, "consignee" => $consignee, "shipper" => $shipper, "name" => $name, "delivery_term" => $delivery_term, "transport_mode" => $transport_mode, "deliverydate" => $deliverydate, "producttype" => $producttype);
                            $ci->load->library('uuid');
                            $uuid = $ci->uuid->v4();
                            $ShipmentPayLoadarr = $this->orderxml($data, $uuid);
                            $headerdata = array('uuid' => $uuid, 'logsenderid' => $logicalsender, 'routing_country' => $country_code, 'routing_company' => $acon_country, 'routing_branch' => $branch_code, 'routing_department' => $department_code);
                            if (count($ShipmentPayLoadarr) > 0) {
                                /*   $this->publishxml($ShipmentPayLoadarr,$headerdata);*/
                            }
                        }
                    }
                    $accuraledi = $this->knaconaccuraledi($order_ids);
                    $accural_count = $accuraledi;
                }

            }
        }
    }

    public function updatetotal_amountforrev($revenue_id)
    {
        $ci =& get_instance();
        $upd_arr = array();
        $vat_amount = 0;
        $company_code = $session_companycode = $ci->session->userdata('company_code');
        $session_currency = $ci->session->userdata("usr_tzone")['currency'];
        if ($company_code == 'PLKN') {
            $session_currency = 'PLN';
        }
        $total_amount = 0;
        if ($revenue_id != "0" && $revenue_id != "") {
            $gettotalamount = $ci->db->query("SELECT amount,currency,local_amount,local_currency,vat_percentage,vat_amount,local_vat_amount FROM tb_charges WHERE revenue_id ='" . $revenue_id . "' AND status = '1'");
            if ($gettotalamount->num_rows() > 0) {
                foreach ($gettotalamount->result() as $res) {
                    $charge_currency = $res->currency;
                    $charge_amount = $res->amount;
                    $vat_percentage = $res->vat_percentage;
                    $vat_amount = $res->vat_amount;
                    if ($charge_currency != $session_currency) {
                        $local_currency = $res->local_currency;
                        $local_amount = $res->local_amount;
                        if (is_numeric($local_amount)) {
                            if($local_amount != "0"){
                                $charge_amount = $local_amount; 
                            }
                        }
                        $local_vat_amount = $res->local_vat_amount;
                        if(is_numeric($local_vat_amount)){
                            if($local_vat_amount != "0"){
                                $vat_amount = $local_vat_amount;
                            }
                        }
                    }
                    if ($vat_percentage && $vat_amount > 0) {
                        $total_amount += $vat_amount;
                    }
                    $total_amount += $charge_amount;
                }
            }
            $getcurentamount = $ci->common->gettblrowdata(array('id' => $revenue_id), "amount,currency,exchange_rate,foreign_currency", "tb_reveneus", 0, 0);
            if (!empty($getcurentamount)) {
                $current_amount = $getcurentamount['amount'];
                $rev_foreign_currency = $getcurentamount['foreign_currency'];
                $foreign_currency = "";
                $currency = $getcurentamount['currency'];
                $charge_amount = round($total_amount, 4);
                $exchange_rate = $getcurentamount['exchange_rate'];
                if($company_code == "VNKN"){
                    if($rev_foreign_currency == ""){
                        $charge_amount = round($charge_amount);
                    }else{
                        if($exchange_rate > 0){
                            $charge_amount = round($charge_amount);  
                        }
                    }
                }
                
                if ($company_code == 'PLKN') {
                    $foreign_currency = 'EUR';
                    $currency = 'PLN';
                    $upd_rev = $ci->common->updatetbledata("tb_reveneus", array('amount' => $charge_amount, 'currency' => $session_currency, 'foreign_currency' => $foreign_currency), array('id' => $revenue_id));
                } else {
                    $upd_rev = $ci->common->updatetbledata("tb_reveneus", array('amount' => $charge_amount, 'currency' => $session_currency), array('id' => $revenue_id));
                }
            }
        }
    }

    public function orderxml($data, $uuid)
    {
        $revenues = $data['revenues'];
        $yearmonth = date('Ym');
        $ShipmentPayLoadarr = array();
        if (count($revenues) > 0) {
            foreach ($revenues as $revenue) {
                $ShipmentPayLoad = "";
                if ($revenue['recipient_role'] == "Customer") {
                    $ShipmentPayLoad .= '<?xml version="1.0" encoding="UTF-8"?><billingMessage xmlns="http://services.kn.com/xsd/knbill/Invoicing/v1">';
                    $ShipmentPayLoad .= '<messageHeader>';
                    $ShipmentPayLoad .= '<sendingSystem>eTN</sendingSystem>';
                    $ShipmentPayLoad .= '<timestamp>' . $data['timestamp'] . '</timestamp>';
                    $ShipmentPayLoad .= '<processMode>STANDARD</processMode>';
                    $ShipmentPayLoad .= '</messageHeader>';
                    $ShipmentPayLoad .= '<financialDocument>';
                    $ShipmentPayLoad .= '<financialDocumentHeader>';
                    $ShipmentPayLoad .= '<documentId>' . $uuid . '</documentId>';
                    $ShipmentPayLoad .= '<companyCode>' . $data['company_code'] . '</companyCode>';
                    $ShipmentPayLoad .= '<branchCode>' . $data['branch_code'] . '</branchCode>';
                    $ShipmentPayLoad .= '<receivingBranchCode>' . $data['branch_code'] . '</receivingBranchCode>';
                    $ShipmentPayLoad .= '<departmentCode>' . $data['department_code'] . '</departmentCode>';
                    $ShipmentPayLoad .= '<aconCode>' . $revenue['acon_code'] . '</aconCode>';
                    $ShipmentPayLoad .= '<documentType>INVOICE</documentType>';
                    $ShipmentPayLoad .= '<documentDate>' . $data['timestamp'] . '</documentDate>';
                    $ShipmentPayLoad .= '<documentRecipient>CUSTOMER</documentRecipient>';
                    $ShipmentPayLoad .= '<billingComplete>Y</billingComplete>';
                    $ShipmentPayLoad .= '<freightSourceCountry>' . $data['shipper']['country'] . '</freightSourceCountry>';
                    $ShipmentPayLoad .= '<freightDestinationCountry>' . $data['consignee']['country'] . '</freightDestinationCountry>';
                    $ShipmentPayLoad .= '<invoicePayerCountry>' . $revenue['country'] . '</invoicePayerCountry>';
                    if ($revenue['foreign_currency'] != "") {
                        $ShipmentPayLoad .= '<invoiceCurrency>' . $revenue['foreign_currency'] . '</invoiceCurrency>';
                    } else {
                        $ShipmentPayLoad .= '<localCurrency>' . $revenue['local_currency'] . '</localCurrency>';
                    }
                    $ShipmentPayLoad .= '<localCurrency>' . $revenue['local_currency'] . '</localCurrency>';
                    $ShipmentPayLoad .= '<creatingUser>root</creatingUser>';
                    if ($revenue['foreign_currency'] != "" && $revenue['exchange_rate'] > 0) {
                        $ShipmentPayLoad .= '<exchangeRates>';
                        $ShipmentPayLoad .= '<exchangeRate>';
                        $ShipmentPayLoad .= '<fromCurrency>' . $revenue['foreign_currency'] . '</fromCurrency>';
                        $ShipmentPayLoad .= '<toCurrency>' . $revenue['local_currency'] . '</toCurrency>';
                        $ShipmentPayLoad .= '<rate>' . $revenue['exchange_rate'] . '</rate>';
                        $ShipmentPayLoad .= '</exchangeRate>';
                        $ShipmentPayLoad .= '</exchangeRates>';
                    }
                    $ShipmentPayLoad .= '</financialDocumentHeader>';
                    $ShipmentPayLoad .= '<shipment>';
                    $ShipmentPayLoad .= '<shipmentType>' . $data['transport_mode'] . '</shipmentType>';
                    $ShipmentPayLoad .= '<incoTerm>' . $data['incoterm'] . '</incoTerm>';
                    $ShipmentPayLoad .= '<deliveryTerm>' . $data['delivery_term'] . '</deliveryTerm>';
                    $ShipmentPayLoad .= '<knProduct>' . $data['producttype'] . '</knProduct>';
                    $ShipmentPayLoad .= '<businessSolution>OL</businessSolution>';
                    $ShipmentPayLoad .= '<deliveryDate>' . $data['deliverydate'] . '</deliveryDate>';
                    $ShipmentPayLoad .= '<chargeableWeight>' . $data['total_weight'] . '</chargeableWeight>';
                    $ShipmentPayLoad .= '<departureDate>' . $data['early_pickup'] . '</departureDate>';
                    $ShipmentPayLoad .= '<arrivalDate>' . $data['early_delivery'] . '</arrivalDate>';
                    $ShipmentPayLoad .= '<manifestNumber>' . 'ET' . $data['order_id'] . '</manifestNumber>';
                    $ShipmentPayLoad .= '<comRef>' . $revenue['delivery_note'] . '</comRef>';
                    $ShipmentPayLoad .= '<trackingNumber>' . $data['order_id'] . '</trackingNumber>';
                    $ShipmentPayLoad .= '<cashOnDelivery>N</cashOnDelivery>';
                    $ShipmentPayLoad .= '<route>';
                    $ShipmentPayLoad .= '<receivingDepot>' . $data['branch_code'] . '</receivingDepot>';
                    $ShipmentPayLoad .= '</route>';
                    $ShipmentPayLoad .= '<shipper>';
                    $ShipmentPayLoad .= '<customerCode>' . $data['shipper']['customeridentifier'] . '</customerCode>';
                    $ShipmentPayLoad .= '<name>' . $data['shipper']['name'] . '</name>';
                    $ShipmentPayLoad .= '<street>' . $data['shipper']['street'] . '</street>';
                    $ShipmentPayLoad .= '<zipcode>' . $data['shipper']['pincode'] . '</zipcode>';
                    $ShipmentPayLoad .= '<city>' . $data['shipper']['city'] . '</city>';
                    $ShipmentPayLoad .= '<country>' . $data['shipper']['country'] . '</country>';
                    $ShipmentPayLoad .= '</shipper>';
                    $ShipmentPayLoad .= '<consignee>';
                    $ShipmentPayLoad .= '<customerCode>' . $data['consignee']['customeridentifier'] . '</customerCode>';
                    $ShipmentPayLoad .= '<name>' . $data['consignee']['name'] . '</name>';
                    $ShipmentPayLoad .= '<street>' . $data['consignee']['street'] . '</street>';
                    $ShipmentPayLoad .= '<zipcode>' . $data['consignee']['pincode'] . '</zipcode>';
                    $ShipmentPayLoad .= '<city>' . $data['consignee']['city'] . '</city>';
                    $ShipmentPayLoad .= '<country>' . $data['consignee']['country'] . '</country>';
                    $ShipmentPayLoad .= '</consignee>';
                    $ShipmentPayLoad .= '<invoiceTo>';
                    $ShipmentPayLoad .= '<customerCode>' . $revenue['customeridentifier'] . '</customerCode>';
                    $ShipmentPayLoad .= '<name>' . $revenue['name'] . '</name>';
                    $ShipmentPayLoad .= '<street>' . $revenue['street'] . '</street>';
                    $ShipmentPayLoad .= '<zipcode>' . $revenue['pincode'] . '</zipcode>';
                    $ShipmentPayLoad .= '<city>' . $revenue['city'] . '</city>';
                    $ShipmentPayLoad .= '<country>' . $revenue['country'] . '</country>';
                    $ShipmentPayLoad .= '</invoiceTo>';
                    $ShipmentPayLoad .= '<dimensions>';
                    $ShipmentPayLoad .= '<grossWeight>' . $data['total_weight'] . '</grossWeight>';
                    $ShipmentPayLoad .= '<volume>' . $data['total_volume'] . '</volume>';
                    $ShipmentPayLoad .= '<loadingMeters>0</loadingMeters>';
                    $ShipmentPayLoad .= '</dimensions>';
                    $ShipmentPayLoad .= '<shipmentDetails>';
                    foreach ($data['cargos'] as $info) {
                        $ShipmentPayLoad .= '<shipmentLine>';
                        $ShipmentPayLoad .= '<quantity>' . $info['quantity'] . '</quantity>';
                        $ShipmentPayLoad .= '<packageType>PLT</packageType>';
                        $ShipmentPayLoad .= '<descriptionOfGoods>' . $info['goods_description'] . '</descriptionOfGoods>';
                        $ShipmentPayLoad .= '<grossWeight>' . $info['weight'] . '</grossWeight>';
                        $ShipmentPayLoad .= '<loadingMetre>0</loadingMetre>';
                        $ShipmentPayLoad .= '<volume>' . $info['volume'] . '</volume>';
                        $ShipmentPayLoad .= '<dimensionLength>' . $info['length'] . '</dimensionLength>';
                        $ShipmentPayLoad .= '<dimensionWidth>' . $info['width'] . '</dimensionWidth>';
                        $ShipmentPayLoad .= '<dimensionHeight>' . $info['height'] . '</dimensionHeight>';
                        $ShipmentPayLoad .= '</shipmentLine>';
                    }
                    $ShipmentPayLoad .= '</shipmentDetails>';
                    $ShipmentPayLoad .= '<shipmentFreeText>';
                    $ShipmentPayLoad .= '<line>{LABEL.LOADING}' . $data['shipper']['country'] . "," . $data['shipper']['street'] . "," . $data['shipper']['city'] . '</line>';
                    $ShipmentPayLoad .= '<line>{LABEL.UNLOADING}' . $data['consignee']['country'] . "," . $data['consignee']['street'] . "," . $data['consignee']['city'] . '</line>';
                    $ShipmentPayLoad .= '</shipmentFreeText>';
                    $ShipmentPayLoad .= '</shipment>';
                    $ShipmentPayLoad .= '<financialDocumentDetails>';
                    $i = 1;
                    foreach ($revenue['charges'] as $charge) {
                        $ShipmentPayLoad .= '<financialDocumentLine>';
                        $ShipmentPayLoad .= '<sequenceNumber>' . $i . '</sequenceNumber>';
                        $ShipmentPayLoad .= '<chargeCode>' . $charge['charge_code'] . '</chargeCode>';
                        $ShipmentPayLoad .= '<jobFileNumberSender>' . $revenue['debtor_jfr'] . '</jobFileNumberSender>';
                        $ShipmentPayLoad .= '<jobFileNumberReceiver>' . $revenue['debtor_jfr'] . '</jobFileNumberReceiver>';
                        $ShipmentPayLoad .= '<profitCentre>' . $data['department_code'] . '</profitCentre>';
                        $ShipmentPayLoad .= '<filePeriod>' . $yearmonth . '</filePeriod>';
                        $ShipmentPayLoad .= '<filePeriodTo>' . $yearmonth . '</filePeriodTo>';
                        $ShipmentPayLoad .= '<invoiceAmount>' . $charge['amount'] . '</invoiceAmount>';
                        $ShipmentPayLoad .= '<remarks>KN CHARGE</remarks>';
                        $ShipmentPayLoad .= '</financialDocumentLine>';
                        $i++;
                    }
                    $ShipmentPayLoad .= '</financialDocumentDetails>';
                    $ShipmentPayLoad .= '</financialDocument>';
                    $ShipmentPayLoad .= '</billingMessage>';
                    $ShipmentPayLoadarr[] = $ShipmentPayLoad;
                    log_message("error", "Acon invoice ShipmentPayLoad- " . $ShipmentPayLoad);
                }
            }
        }
        return $ShipmentPayLoadarr;
    }

    public function publishxml($ShipmentPayLoadarr, $headerdata)
    {
        $ci =& get_instance();
        $ssl_options = array(
            'verify_peer' => false,
            'verify_peer_name' => false
        );
        $headers = new Wire\AMQPTable
        (array(
            'uuid' => $headerdata['uuid'],
            'KN_MS_PhysSenderID' => 'KNRLG01',
            'KN_MS_LogSenderID' => $headerdata['logsenderid'],
            'KNESB_Routing_SenderId' => ACON_SENDERID,
            'KNESB_Routing_SenderInstance' => 'TEST_ACCEPTANCE',
            'KNESB_Routing_ReceiverId' => ACON_RECEIVERID,
            'KNESB_Routing_ReceiverInstance' => 'ACCEPTT',
            'KNESB_Routing_Country' => $headerdata['routing_country'],
            'KNESB_Routing_Company' => $headerdata['routing_company'],
            'KNESB_Routing_Branch' => $headerdata['routing_branch'],
            'KNESB_Routing_Department' => $headerdata['routing_department']
        ));
        $headers->set('short', -1024, Wire\AMQPTable::T_INT_SHORT);
        $connection = new AMQPSSLConnection(ACON_URL, 5671, ACON_USRNAME, SALOG_PWD, ACON_ESB, $ssl_options);
        $channel = $connection->channel();
        foreach ($ShipmentPayLoadarr as $ShipmentPayLoad) {
            $Xmldata = new AMQPMessage($ShipmentPayLoad, array('content_type' => 'Application/xml', 'delivery_mode' => AMQPMessage::DELIVERY_MODE_PERSISTENT));
            $Xmldata->set('application_headers', $headers);
            $channel->basic_publish($Xmldata, ACON_PUBLISHURL, null);
        }
        /*echo " [x] Sent 'Hello World!'\n";*/
        $channel->close();
        $connection->close();

    }

    public function knaconaccuraledi($order_ids)
    {
        $ci =& get_instance();
        $curdt = date('Y-m-d H:i:s');
        $accural_count = 0;
        $accuralxmls = array();
        $zonecode = $ci->session->userdata("usr_tzone");
        $curtz = $zonecode['timezone'];
        $cntryname = $zonecode['country_name'];
        $cntrycode = $zonecode['country'];
        $session_currency = isset($zonecode['currency']) ? $zonecode['currency'] : "";
        $getactual = getdatetimebytimezone($curtz, $curdt, DFLT_TZ);
        $timestamp = $getactual['date'] . "T" . $getactual['time'] . "Z";
        $invoice_date = $getactual['date'];
        $company_code = $ci->session->userdata("company_code");
        $branch_code = $ci->session->userdata("branch_code");
        $country_code = substr($company_code, 0, 2);
        $invoice_no = $acon_code = $currency = $routing_company = "";
        $user_id = $ci->session->userdata('user_id');
        $user_name = "";
        $getuserdetails = $ci->common->gettblrowdata(array('id' => $user_id), 'name', 'tb_users', 0, 0);
        if (!empty($getuserdetails)) {
            $user_name = $getuserdetails['name'];
        }
        $acon_country = $logical_sender = "";
        $getacon_country = $ci->aconedimodel->gettblrowdata(array("branch_code" => $branch_code, 'company_code' => $company_code), "logical_sender,acon_country", "tb_branch_master", 0, 0);
        if (count($getacon_country) > 0) {
            $acon_country = $routing_company = $getacon_country['acon_country'];
            $logical_sender = $getacon_country['logical_sender'];
        }
        $data_arr = $orderids = array();
        foreach ($order_ids as $order_id) {
            $orderids[] = $order_id['ids'];
        }
        $rev_where = array("r.type" => '0', 'r.invoice_status' => '2', 'r.status' => '1');
        $ci->db->select("r.id,r.order_id,r.recipient_code,r.debtor_jfr,r.invoice_number,r.invoice_date,r.amount,r.currency,r.foreign_currency,p.name,p.acon_debitor_code");
        $ci->db->from("tb_reveneus r");
        $ci->db->join("tbl_party_master p", "r.recipient_code=p.code", "LEFT");
        $ci->db->where($rev_where);
        $ci->db->where_in("r.order_id", $orderids);
        $ci->db->group_by("r.id");
        $getrevenues = $ci->db->get();
        $order_id = "";
        if ($getrevenues->num_rows() > 0) {
            foreach ($getrevenues->result() as $res) {
                $data = array();
                $order_id = $res->order_id;
                $debtor_jfr = $res->debtor_jfr;
                $invoice_no = $res->invoice_number;
                /*$invoice_date =  $res->invoice_date;*/
                /*$invoice_date = date('Y-m-d',strtotime($invoice_date));
                $fileperiod = date('Ym',strtotime($invoice_date));*/
                $fileperiod = date('Ym', strtotime($invoice_date));
                $where = array("r.type" => '1', 'r.order_id' => $order_id, 'r.amount >' => '0', 'r.invoice_status' => 0, 'r.status' => '1');
                $getcost_revenue = $ci->aconedimodel->getallrevenues($where);
                if ($getcost_revenue->num_rows() > 0) {
                    foreach ($getcost_revenue->result() as $rescost) {
                        $costrevid = $rescost->id;
                        $carrier_code = $rescost->recipient_code;
                        $carrier_aconcode = $rescost->acon_debitor_code;
                        if (($debtor_jfr != "") && ($carrier_aconcode != "")) {
                            $charges = array();
                            $currency = $rescost->currency;
                            if ($currency == "") {
                                $currency = $session_currency;
                            }
                            if ($company_code == "PLKN") {
                                $session_currency = "PLN";
                            }
                            $getcharges = $ci->aconedimodel->getcharges($costrevid);
                            if ($getcharges->num_rows() > 0) {
                                foreach ($getcharges->result() as $charge) {
                                    $charge_currency = $charge->currency;
                                    if ($charge_currency != $session_currency) {
                                        $charges[] = array('amount' => $charge->amount, 'currency' => $charge_currency, 'local_amount' => $charge->local_amount, 'local_currency' => $charge->local_currency);
                                    } else {
                                        $charges[] = array('amount' => $charge->amount, 'currency' => $charge_currency, 'local_amount' => 0, 'local_currency' => "");
                                    }
                                }
                            }
                            if (count($charges) > 0) {
                                $upd_rev = $ci->db->where(array('id' => $costrevid))->update("tb_reveneus", array('debtor_jfr' => $debtor_jfr, 'invoice_number' => $invoice_no, 'invoice_date' => $invoice_date, 'invoice_creation_date' => $curdt, 'invoice_receivdon_date' => $curdt, 'invoice_status' => 2));
                                if ($upd_rev) {
                                    $order_weight = 0;
                                    $getorderdetails = $ci->common->gettblrowdata(array('id' => $order_id), 'weight', 'tb_orders', 0, 0);
                                    if (!empty($getorderdetails)) {
                                        $order_weight = $getorderdetails['weight'];
                                    }
                                    $data_arr[] = array('carrier_aconcode' => $carrier_aconcode, 'order_weight' => $order_weight, 'invoice_date' => $invoice_date, 'currency' => $currency, 'invoice_no' => $invoice_no, 'charges' => $charges, 'fileperiod' => $fileperiod, 'user_name' => $user_name, 'acon_country' => $acon_country, 'debtor_jfr' => $debtor_jfr);
                                    $accural_count++;
                                    // $accuralxmls[] = $this->accuralxml($data);
                                    // echo htmlentities($accuralxml);
                                }
                            }
                        }
                    }
                }
            }
        }
        if (count($data_arr) > 0) {
            $accuralxml = $this->accuralxml($data_arr);
            log_message("error", "KN accuralxml - " . $accuralxml);
            $ci->load->library('uuid');
            $uuid = $ci->uuid->v4();
            $headerdata = array('uuid' => $uuid, 'logical_sender' => $logical_sender, 'country_code' => $country_code, 'acon_country' => $acon_country, 'branch_code' => $branch_code, 'routing_department' => "");
            log_message("error", "KN Accural headerdata - " . json_encode($headerdata));
            /*   $publishaccuralxml =$this->publishaccuralxml($accuralxml,$headerdata);*/
        }
        /*echo htmlentities($accuralxml);*/
        return $accural_count;
    }

    public function accuralxml($data_arr)
    {
        $accuralxml = "";
        $accuralxml .= '<?xml version="1.0" encoding="UTF-8"?>';
        $accuralxml .= '<AccruedExpenses xmlns="http://services.kn.com/xsd/acon/fsl/AccuredExpenses/v1">';
        $i = 1;
        foreach ($data_arr as $data) {
            foreach ($data['charges'] as $charges) {
                $accuralxml .= '<AccruedExpense>';
                $accuralxml .= '<CompanyCode>' . $data['acon_country'] . '</CompanyCode>';
                $accuralxml .= '<CallingApplication>ETRUCACC</CallingApplication>';
                $accuralxml .= '<TxDate>' . $data['invoice_date'] . '</TxDate>';
                $accuralxml .= '<CreditorCode>' . $data['carrier_aconcode'] . '</CreditorCode>';
                $accuralxml .= '<JobFileNo>' . $data['debtor_jfr'] . '</JobFileNo>';
                $accuralxml .= '<FilePeriod>' . $data['fileperiod'] . '</FilePeriod>';
                $accuralxml .= '<ChargeCategory>045</ChargeCategory>';
                if ($charges['local_amount'] > 0) {
                    $accuralxml .= '<CurrencyCode>' . $charges['local_currency'] . '</CurrencyCode>';
                    $accuralxml .= '<LCDecimalPlace>2</LCDecimalPlace>';
                    $accuralxml .= '<AccrualLCAmount>' . $charges['local_amount'] . '</AccrualLCAmount>';
                } else {
                    $accuralxml .= '<CurrencyCode>' . $charges['currency'] . '</CurrencyCode>';
                    $accuralxml .= '<LCDecimalPlace>2</LCDecimalPlace>';
                    $accuralxml .= '<AccrualLCAmount>' . $charges['amount'] . '</AccrualLCAmount>';
                }
                $accuralxml .= '<Weight>' . $data['order_weight'] . '</Weight>';
                $accuralxml .= '<SequenceNo>' . $i . '</SequenceNo>';
                $accuralxml .= '<InterfaceStatus>A</InterfaceStatus>';
                $accuralxml .= '<CostType>R</CostType>';
                if ($charges['local_amount'] > 0) {
                    $accuralxml .= '<ForeignCurrencyCode>' . $charges['currency'] . '</ForeignCurrencyCode>';
                    $accuralxml .= '<AccrualFCAmount>' . $charges['amount'] . '</AccrualFCAmount>';
                }

                $accuralxml .= '<LastUpdatedUser>' . $data['user_name'] . '</LastUpdatedUser>';
                $accuralxml .= '</AccruedExpense>';
                $i++;
            }
        }
        $accuralxml .= '</AccruedExpenses>';
        return $accuralxml;
    }

    public function publishaccuralxml($accuralxml, $headerdata)
    {
        $ssl_options = array(
            'verify_peer' => false,
            'verify_peer_name' => false
        );

        $headers = new Wire\AMQPTable

        (array(
            'uuid' => $headerdata['uuid'],
            'KN_MS_PhysSenderID' => 'KNRLG01',
            'KN_MS_LogSenderID' => $headerdata['logical_sender'],
            'KNESB_Routing_SenderId' => ACON_USRNAME,
            'KNESB_Routing_SenderInstance' => 'PROD',
            'KNESB_Routing_ReceiverId' => 'KNBILL',
            'KNESB_Routing_ReceiverInstance' => 'PROD',
            'KNESB_Routing_Country' => $headerdata['country_code'],
            'KNESB_Routing_Company' => $headerdata['acon_country'],
            'KNESB_Routing_Branch' => $headerdata['branch_code'],
            'KNESB_Routing_Department' => 'CTP'
        ));

        $headers->set('short', -1024, Wire\AMQPTable::T_INT_SHORT);
        $connection = new AMQPSSLConnection(ACON_URL, 5671, ACON_USRNAME, ACON_PWD, ACON_ESB, $ssl_options);
        $channel = $connection->channel();
        $Xmldata = new AMQPMessage($accuralxml, array('content_type' => 'Application/xml', 'delivery_mode' => AMQPMessage::DELIVERY_MODE_PERSISTENT));
        $Xmldata->set('application_headers', $headers);
        $channel->basic_publish($Xmldata, 'e.acon.accrualv0120', null);
        $channel->close();
        $connection->close();

    }
    public function checkexchangerateexistsornot($order_id,$rev_id){
        $exchange_rate = "0";
        $ci =& get_instance();
        $curtz = $ci->session->userdata("usr_tzone")['timezone'];
        $company_code = $ci->session->userdata('company_code');
        if($rev_id >0){
            $info = array('company_code'=>$company_code,'user_currency' =>$curtz,'order_id'=>$order_id,'rev_id'=>$rev_id);
            $exchange_rate = $ci->Orderrevenuesmodel->checkothercurrencyexistsornot($info);
        }
        return $exchange_rate;
    }
    public function updatelocalamout_byexchangerate($rev_id,$exchange_rate_amount,$foreign_currency){
        $ci =& get_instance();
        $vat_amount = 0;
        $upd_arr = array();
        $local_currency = $ci->session->userdata("usr_tzone")['currency'];
        $company_code = $ci->session->userdata('company_code');
        if($rev_id >0){
            $upd_examount = $ci->common->updatetbledata("tb_reveneus",array('exchange_rate'=>$exchange_rate_amount,'foreign_currency'=>$foreign_currency),array('id'=>$rev_id));
            if($foreign_currency != ""){
                $getcharges = $ci->common->gettbldata(array('revenue_id'=>$rev_id,'currency'=>$foreign_currency,'status'=>'1'),"id,amount,local_amount,vat_percentage,vat_amount","tb_charges",0,0);
                if(!empty($getcharges)){
                    foreach ($getcharges as $charge){
                        $amount               = $charge['amount'];
                        $charge_row_id        = $charge['id'];
                        $charge_local_amount  = $charge['local_amount'];
                        $vat_percentage       = $charge['vat_percentage'];
                        
                        if($charge_local_amount >0){
                        }else{
                            $final_local_amount = $amount * $exchange_rate_amount;
                            if($final_local_amount >0){
                                $upd_arr['local_amount']   = $final_local_amount;
                                if($company_code == "VNKN"){
                                    $upd_arr['local_amount']   = round($final_local_amount);
                                }
                                $final_total_amount   =  0;
                                $upd_arr['local_currency'] = $local_currency;
                                if($vat_percentage > 0){
                                    $vat_amount = $charge['vat_amount'];
                                    if($vat_amount >0){
                                        $local_vat_amount = $vat_amount * $exchange_rate_amount;
                                        $upd_arr['local_vat_amount'] = $local_vat_amount;
                                    }
                                    $final_total_amount = $local_vat_amount + $upd_arr['local_amount'];
                                }
                                $upd_arr['local_total_amount'] = $final_total_amount;
                                if($company_code == "VNKN"){
                                    $upd_arr['local_total_amount'] = round($final_total_amount);
                                }
                                if(!empty($upd_arr)){
                                    $upd_localamount = $ci->common->updatetbledata("tb_charges",$upd_arr,array('id'=>$charge_row_id));
                                }

                            }
                        }
                    }
                }
            }
        }
    }
}