<?php
require_once APPPATH . "/third_party/inspectPdf/InspectPdf.php";

class InspectPdfLibrary
{
    public function __construct()
    {
        $this->ci = &get_instance();
    }

    public function validatePdf(string $filePath): bool
    {
        try {
            $scanPdf = new InspectPdf();
            $analysePDF = $scanPdf->analysePDF(['filename' => $filePath, 'md5' => md5_file($filePath), 'sha256' => '']);
            if ($analysePDF['is_malware'] == 0 && $analysePDF['not_pdf'] == 0) {
                return true;
            }
        } catch (Exception $ex) {
            log_message("error", "PDF inspection failed " . $ex->getMessage());
        }
        return false;
    }
}
