<?php

class Kpireportinsertion
{
    private $ci;
    private const  TRIP_ACCEPTED_STATUS_CODE = '0212';
    private const  GATE_IN_PICKUP_STATUS_CODE = '0420';
    private const  GATE_OUT_PICKUP_STATUS_CODE = '0191';
    private const  GATE_IN_DELIVERY_STATUS_CODE = '0192';
    private const  GATEOUT_STATUS_CODE = '3000';
    private const  INTRASIT_STATUS_CODE = '1550';
    private const  ADMIN_DRIVER_STATUS_CODE = ['0501', '0502', '0500'];
    private const  DELIVERY_STATUS_CODE = ['2300', '0503', '0504', '0505'];
    private const  PICKUP_COMMENT_STATUS_CODE = ['0500', '0501', '0502'];
    private const  DELIVERY_COMMENT_STATUS_CODE = ['2300', '0503', '0504', '0505'];

    public function __construct()
    {
        $this->ci = &get_instance();
        $this->userTimeZone = $this->ci->session->userdata("usr_tzone")['timezone'];
        $this->companyCode = $this->ci->session->userdata("company_code");
        $this->userId = $this->ci->session->userdata("user_id");
        $this->ci->load->model('common');
    }

    public function insertDataIntoKpiReports(int $orderRowId = 0)
    {
        $logDate = date('Y-m-d H:i:s');
        $getActual = getdatetimebytimezone(DFLT_TZ, $logDate, $this->userTimeZone);
        $createdDate = $getActual['datetime'];
        $orderDaysTotalScore = [];
        if ($orderRowId === 0) {
            return false;
        }
        $orderDataQuery = $this->ci->common->gettblrowdata(["id" => $orderRowId, "status" => 2], "id,order_id,pickup_datetime,delivery_datetime,transport_mode,customer_id,vendor_id,shift_id,convertToClientTZ(createdon,'" . $this->userTimeZone . "') as createdon,shipmentid,modeoftransport", "tb_orders", 0, 0);

        if (empty($orderDataQuery)) {
            return false;
        }
        $id = $orderRowId = $orderDataQuery['id'];
        $orderId = $orderDataQuery['order_id'];
        $vendorId = $orderDataQuery['vendor_id'];
        $customerId = $orderDataQuery['customer_id'];
        $orderShipmentId = $orderDataQuery['shift_id'];
        $transportMode = $orderDataQuery['transport_mode'];
        $bookingCreateDate = $orderDataQuery['createdon'];
        $pickupDateTime = $orderDataQuery['pickup_datetime'];
        $deliveryDateTime = $orderDataQuery['delivery_datetime'];
        $shipmentId = $orderDataQuery['shipmentid'];

        $deliveryNoteQuery = $this->ci->common->gettblrowdata(['order_id' => $orderRowId, 'reference_id' => 'DQ', 'status' => '1'], "id,order_id,reference_id,ref_value,ref_belongs_to, order_shortno,status,createdon,updatedon", "tb_order_references", 0, 0);
        $deliveryNote = $deliveryNoteQuery['ref_value'] ?? "";

        $getVendorDetails = $this->ci->common->gettblrowdata(["id" => $vendorId, "status" => 1], "id,name", "tb_vendors", 0, 0);
        $carrierName = $getVendorDetails['name'] ?? "";

        $customerQuery = $this->ci->common->gettblrowdata(["id" => $customerId, "status" => 1], "id,name", "tb_customers", 0, 0);
        $customerName = $customerQuery['name'];

        $shipmentCreatedQuery = $this->ci->common->gettblrowdata(["shift_id" => $orderShipmentId], "convertToClientTZ(created_on,'" . $this->userTimeZone . "') as created_on", "tb_trips", 0, 0);
        $shipmentCreatedDate = $shipmentCreatedQuery['created_on'] ?? "";

        $carrierAssignedQuery = $this->ci->common->gettblrowdata(["id" => $orderShipmentId], "convertToClientTZ(created_on,'" . $this->userTimeZone . "') as created_on", "tb_shifts", 0, 0);
        $carrierAssignedDate = $carrierAssignedQuery['created_on'] ?? "";

        $ePodDateQuery = $this->ci->common->gettblrowdata(["order_id" => $orderRowId], "id,convertToClientTZ(createdon,'" . $this->userTimeZone . "') as createdon", "tb_pod_uploads", 0, 0);
        $ePodDate = $ePodDateQuery['createdon'] ?? "";

        $tenderAcceptedDateQuery = $this->ci->common->gettblrowdata(["shipment_id" => $orderShipmentId, "status_code" => self::TRIP_ACCEPTED_STATUS_CODE], "convertToClientTZ(createdon,'" . $this->userTimeZone . "') as createdon", "tb_stop_status", 0, 0);
        $tenderAcceptedDate = $tenderAcceptedDateQuery['createdon'] ?? "";

        $actuallyPickupDateData = $this->getStopStatusByStatusCodes(['timeZone' => $this->userTimeZone, 'orderRowId' => $orderRowId, 'orderShipmentId' => $orderShipmentId, 'codes' => self::ADMIN_DRIVER_STATUS_CODE, 'stopType' => 'P']);
        $actuallyPickupDate = $actuallyPickupDateData['createdon'] ?? "";
        $actuallyPickupFormatedDate = $actuallyPickupDateData['formateddate'] ?? "";

        $actuallyDeliveryDateData = $this->getStopStatusByStatusCodes(['timeZone' => $this->userTimeZone, 'orderRowId' => $orderRowId, 'orderShipmentId' => $orderShipmentId, 'codes' => self::DELIVERY_STATUS_CODE, 'stopType' => 'D']);
        $actuallyDeliveryDate = $actuallyDeliveryDateData['createdon'] ?? "";
        $actuallyDeliveryFormatedDate = $actuallyDeliveryDateData['formateddate'] ?? "";

        $gateInPickupDateData = $this->getStopStatusByStatusCodes(['timeZone' => $this->userTimeZone, 'orderRowId' => $orderRowId, 'orderShipmentId' => $orderShipmentId, 'codes' => [self::GATE_IN_PICKUP_STATUS_CODE], 'stopType' => 'P']);
        $gateInPickupDate = $gateInPickupDateData['createdon'] ?? "";
        $gateInPickupFormatedDate = $gateInPickupDateData['formateddate'] ?? "";

        $gateOutPickupDateData = $this->getStopStatusByStatusCodes(['timeZone' => $this->userTimeZone, 'orderRowId' => $orderRowId, 'orderShipmentId' => $orderShipmentId, 'codes' => [self::GATE_OUT_PICKUP_STATUS_CODE], 'stopType' => 'P']);
        $gateOutPickupDate = $gateOutPickupDateData['createdon'] ?? "";
        $gateOutPickupFormatedDate = $gateOutPickupDateData['formateddate'] ?? "";

        $gateInDeliveryDateData = $this->getStopStatusByStatusCodes(['timeZone' => $this->userTimeZone, 'orderRowId' => $orderRowId, 'orderShipmentId' => $orderShipmentId, 'codes' => [self::GATE_IN_DELIVERY_STATUS_CODE], 'stopType' => 'D']);
        $gateInDeliveryDate = $gateInDeliveryDateData['createdon'] ?? "";
        $gateInDeliveryFormatedDate = $gateInDeliveryDateData['formateddate'] ?? "";


        $gateOutDeliveryDateData = $this->getStopStatusByStatusCodes(['timeZone' => $this->userTimeZone, 'orderRowId' => $orderRowId, 'orderShipmentId' => $orderShipmentId, 'codes' => [self::GATEOUT_STATUS_CODE], 'stopType' => 'D']);
        $gateOutDeliveryDate = $gateOutDeliveryDateData['createdon'] ?? "";
        $gateOutDeliveryFormatedDate = $gateOutDeliveryDateData['formateddate'] ?? "";

        $pickupCommentsData = $this->getStopStatusByStatusCodes(['timeZone' => $this->userTimeZone, 'orderRowId' => $orderRowId, 'orderShipmentId' => $orderShipmentId, 'codes' => self::PICKUP_COMMENT_STATUS_CODE, 'stopType' => 'P']);
        $pickupStatus = $pickupCommentsData['status_stage'] ?? "";
        $pickupComments = $pickupCommentsData['comment'] ?? "";

        $deliveryCommentsData = $this->getStopStatusByStatusCodes(['timeZone' => $this->userTimeZone, 'orderRowId' => $orderRowId, 'orderShipmentId' => $orderShipmentId, 'codes' => self::DELIVERY_COMMENT_STATUS_CODE, 'stopType' => 'D']);
        $deliveryStatus = $deliveryCommentsData['status_stage'] ?? "";
        $deliveryComments = $deliveryCommentsData['comment'] ?? "";


        $inTrasitDateData = $this->getStopStatusByStatusCodes(['timeZone' => $this->userTimeZone, 'orderRowId' => $orderRowId, 'orderShipmentId' => $orderShipmentId, 'codes' => [self::INTRASIT_STATUS_CODE], 'stopType' => '']);
        $dateWiseStates = $inTrasitDateData ?? [];
        $perOneDay = 0;
        $inTransitEventsKPI = $this->getKpiValue(['dateWiseStates' => $dateWiseStates, 'orderDaysTotalScore' => $orderDaysTotalScore, 'actuallyPickupDate' => $actuallyPickupDate, 'actuallyDeliveryDate' => $actuallyDeliveryDate, 'perOneDay' => $perOneDay]);
        $kpiDepartureToArrvial = $this->getKpiValue(['dateWiseStates' => $dateWiseStates, 'orderDaysTotalScore' => $orderDaysTotalScore, 'actuallyPickupDate' => $gateOutPickupDate, 'actuallyDeliveryDate' => $gateInDeliveryDate, 'perOneDay' => $perOneDay]);

        $kpiInsert['order_row_id'] = $id ?? '';
        $kpiInsert['order_id'] = $orderId ?? '';
        $kpiInsert['delivery_note'] = $deliveryNote ?? '';
        $kpiInsert['shift_id'] = $shipmentId ?? '';
        $kpiInsert['transport_mode'] = $transportMode ?? '';
        $kpiInsert['vendor_id'] = $vendorId ?? '';
        $kpiInsert['customer_id'] = $customerId ?? '';
        $kpiInsert['carrier_name'] = $carrierName ?? '';
        $kpiInsert['customer_name'] = $customerName ?? '';
        $kpiInsert['booking'] = $bookingCreateDate ?? '';
        $kpiInsert['pickup_datetime'] = $pickupDateTime ?? '';
        $kpiInsert['delivery_datetime'] = $deliveryDateTime ?? '';
        $kpiInsert['epod_date'] = $ePodDate ?? '';
        $kpiInsert['shipment'] = $shipmentCreatedDate ?? '';
        $kpiInsert['tender'] = $tenderAcceptedDate ?? '';
        $kpiInsert['pickup'] = $actuallyPickupFormatedDate ?? '';
        $kpiInsert['delivery'] = $actuallyDeliveryFormatedDate ?? '';
        $kpiInsert['score'] = $inTransitEventsKPI['score'] ?? '';
        $kpiInsert['total_days'] = $inTransitEventsKPI['total_days'] ?? '';
        $kpiInsert['KPI'] = $inTransitEventsKPI['inTransitEventsKPI'] ?? '';
        $kpiInsert['user_id'] = $this->userId;
        $kpiInsert['company_code'] = $this->companyCode;
        $kpiInsert['createdon'] = $createdDate ?? '';
        $kpiInsert['status'] = 1 ?? '';
        $kpiInsert['gate_in_pickup_datetime'] = $gateInPickupFormatedDate ?? '';
        $kpiInsert['gate_out_pickup_datetime'] = $gateOutPickupFormatedDate ?? '';
        $kpiInsert['gate_in_delivery_datetime'] = $gateInDeliveryFormatedDate ?? '';
        $kpiInsert['gate_out_delivery_datetime'] = $gateOutDeliveryFormatedDate ?? '';
        $kpiInsert['kpi_departure_to_arrvial'] = $kpiDepartureToArrvial['inTransitEventsKPI'] ?? '';
        $kpiInsert['gate_in_out_score'] = $kpiDepartureToArrvial['score'] ?? '';
        $kpiInsert['gate_in_out_totaldays'] = $kpiDepartureToArrvial['total_days'] ?? '';
        $kpiInsert['pickup_status'] = $pickupStatus ?? '';
        $kpiInsert['pickup_comments'] = $pickupComments ?? '';
        $kpiInsert['delivery_status'] = $deliveryStatus ?? '';
        $kpiInsert['delivery_comments'] = $deliveryComments ?? '';
        $orderDaysTotalScore['kpi_insert'] = json_encode($kpiInsert) ?? '';
        $orderDaysTotalScore['dateWiseStates'] = json_encode($dateWiseStates) ?? '';
        $kpiInsert['details'] = json_encode($orderDaysTotalScore) ?? '';
        $kpiInsert['carrier_assigned_date'] = $carrierAssignedDate ?? '';

        $checkKpiReport = $this->ci->common->gettblrowdata(['order_id' => $orderId, 'order_row_id' => $id], "id", "kpi_report", 0, 0);
        if (empty($checkKpiReport)) {
            $kpiInsert['createdon'] = $createdDate ?? '';
            $kpiId = $this->ci->common->insertTableData("kpi_report", $kpiInsert);
        } else {
            $kpiInsert['updatedon'] = $getActual['datetime'] ?? '';
            $reportUpdate = $this->ci->common->updatetbledata("kpi_report", $kpiInsert, ['id' => $checkKpiReport['id']]);
        }
        $perOneDay = 1;
        $inTransitEventsKPI = $this->getKpiValue(['dateWiseStates' => $dateWiseStates, 'orderDaysTotalScore' => $orderDaysTotalScore, 'actuallyPickupDate' => $actuallyPickupDate, 'actuallyDeliveryDate' => $actuallyDeliveryDate, 'perOneDay' => $perOneDay]);
        $kpiDepartureToArrvial = $this->getKpiValue(['dateWiseStates' => $dateWiseStates, 'orderDaysTotalScore' => $orderDaysTotalScore, 'actuallyPickupDate' => $gateOutPickupDate, 'actuallyDeliveryDate' => $gateInDeliveryDate, 'perOneDay' => $perOneDay]);

        $kpiInsert['score'] = $inTransitEventsKPI['score'] ?? '';
        $kpiInsert['total_days'] = $inTransitEventsKPI['total_days'] ?? '';
        $kpiInsert['KPI'] = $inTransitEventsKPI['inTransitEventsKPI'] ?? '';
        $kpiInsert['kpi_departure_to_arrvial'] = $kpiDepartureToArrvial['inTransitEventsKPI'] ?? '';
        $kpiInsert['gate_in_out_score'] = $kpiDepartureToArrvial['score'] ?? '';
        $kpiInsert['gate_in_out_totaldays'] = $kpiDepartureToArrvial['total_days'] ?? '';

        $checkKpiOneDayReport = $this->ci->common->gettblrowdata(['order_id' => $orderId, 'order_row_id' => $id], "id", "kpi_report_one_day", 0, 0);
        if (empty($checkKpiOneDayReport)) {
            $kpiInsert['createdon'] = $createdDate ?? '';
            $kpiId = $this->ci->common->insertTableData("kpi_report_one_day", $kpiInsert);
        } else {
            $kpiInsert['updatedon'] = $getActual['datetime'] ?? '';
            $reportUpdate = $this->ci->common->updatetbledata("kpi_report_one_day", $kpiInsert, ['id' => $checkKpiOneDayReport['id']]);
        }
        return $orderDaysTotalScore;
    }

    public function getStopStatusByStatusCodes(array $data): array
    {
        $stopStatusByStatusCodes = [];
        $whereCondition = "status =1 AND order_id = " . $data['orderRowId'] . " AND shipment_id =" . $data['orderShipmentId'] . " AND status_code IN ('" . implode("','", $data['codes']) . "') ";
        if (!empty($data['stopType'])) {
            $whereCondition .= " AND stop_type = '" . $data['stopType'] . "'";
        }
        $stopStatusByStatusCodesQuery = $this->ci->common->gettbldata($whereCondition, 'id,status_code,DATE_FORMAT(convertToClientTZ(createdon,"' . $data['timeZone'] . '"),"%H") as hours,DATE_FORMAT(convertToClientTZ(createdon,"' . $data['timeZone'] . '"),"%y-%m-%d") as createdon,convertToClientTZ(createdon,"' . $data['timeZone'] . '") as formateddate,status_stage,comment,reason', 'tb_stop_status', 0, 0);
        foreach ($stopStatusByStatusCodesQuery as $stopStatusByStatusCodesRow) {
            if ($data['codes'][0] == self::INTRASIT_STATUS_CODE) {
                $stopStatusByStatusCodes[$stopStatusByStatusCodesRow['createdon']][] = $stopStatusByStatusCodesRow;
            } else {
                $stopStatusByStatusCodes = $stopStatusByStatusCodesRow;
            }
        }
        return $stopStatusByStatusCodes;
    }

    public function getKpiValue(array $data): array
    {
        $invalidIntransits = 0;
        $withMissingDates = $oneDayScoreTotal = [];
        if (count($data['dateWiseStates']) === 1) {
            $data['dateWiseStates'][$data['actuallyDeliveryDate']][] = $data['actuallyDeliveryDate'];
        }

        $firstInTransitDate = array_key_first($data['dateWiseStates']);
        $lastInTransitDate = array_key_last($data['dateWiseStates']);
        $firstInTransitStrtoTime = strtotime($firstInTransitDate);
        $lastInTransitStrtoTime = strtotime($lastInTransitDate);
        for (
            $currentDate = $firstInTransitStrtoTime;
            $currentDate <= $lastInTransitStrtoTime;
            $currentDate += (86400)
        ) {
            $Store = date('y-m-d', $currentDate);
            $withMissingDates[] = $Store;
        }

        if (isset($data['dateWiseStates']) && is_array($data['dateWiseStates'])) {
            foreach ($data['dateWiseStates'] as $date => $dateWiseState) {
                $actualPickDate = date_create($data['actuallyPickupDate']);
                $pickupDate = date_format($actualPickDate, "y-m-d");

                $actualDeliveryDate = date_create($data['actuallyDeliveryDate']);
                $deliveryDate = date_format($actualDeliveryDate, "y-m-d");

                if ($date == $pickupDate) {
                    array_shift($data['dateWiseStates']);
                    array_shift($withMissingDates);
                }
                if ($date == $deliveryDate) {
                    array_pop($data['dateWiseStates']);
                    array_pop($withMissingDates);
                }
                if (($date >= $pickupDate) && ($date <= $deliveryDate)) {
                    $invalidIntransits = 0;
                } else {
                    $invalidIntransits = 1;
                    break;
                }
            }

            foreach ($data['dateWiseStates'] as $date => $dateWiseState) {
                $date_count = count($dateWiseState);
                if ($data['perOneDay'] == 1) {
                    $oneDayScore = 1;
                } elseif ($date_count == 1) {
                    $oneDayScore = 0.5;
                } else {
                    $firstHalf = $secoundHalf = 0;
                    foreach ($dateWiseState as $key => $value) {
                        $hourCheck = $value['hours'];
                        if (($hourCheck > 0) && ($hourCheck < 12)) {
                            $firstHalf = 0.5;
                        } elseif (($hourCheck >= 12) && ($hourCheck <= 23)) {
                            $secoundHalf = 0.5;
                        }
                        $oneDayScore = $firstHalf + $secoundHalf;
                    }
                }
                $oneDayScoreTotal[] = $oneDayScore;
                $data['orderDaysTotalScore'][$date]['oneDayScore'] = $oneDayScore;
                $data['orderDaysTotalScore'][$date][] = $dateWiseState;
            }
        }
        $score = array_sum($oneDayScoreTotal);
        $data['orderDaysTotalScore']['withMissingDates'] = $withMissingDates;
        $data['orderDaysTotalScore']['score'] = $score ?? '';

        $dateDifference = strtotime($data['actuallyDeliveryDate']) - strtotime($data['actuallyPickupDate']);
        $differenceInDays = round($dateDifference / 86400) - 1;
        $data['orderDaysTotalScore']['total_days'] = $differenceInDays ?? 0;

        $inTransitEventsResult = $this->inTransitEvents(['withMissingDates' => $withMissingDates, 'deliveryDate' => $data['actuallyDeliveryDate'], 'pickupDate' => $data['actuallyPickupDate'], 'score' => $score]);
        $inTransitEventsKPI = ($invalidIntransits === 1) ? 'N/A' : $inTransitEventsResult;
        if ($inTransitEventsKPI === null) {
            $kpi_data = $data['orderDaysTotalScore']['score'] / $data['orderDaysTotalScore']['total_days'];
            $inTransitEventsKPI = round($kpi_data * 100, 2);
        }
        $data['orderDaysTotalScore']['inTransitEventsKPI'] = $inTransitEventsKPI;
        return $data['orderDaysTotalScore'];
    }

    public function inTransitEvents(array $data)
    {
        $dateDifference = strtotime($data['deliveryDate']) - strtotime($data['pickupDate']);
        $differenceInDays = round($dateDifference / 86400) - 1;
        if ($differenceInDays < -1) {
            return 'N/A';
        } elseif (in_array($differenceInDays, [-1, 0], true)) {
            return 100;
        } else {
            if ($data['score'] === 0) {
                return 0;
            }
        }
        return null;
    }
}
