<?php

/**
 * Description of VozovozEdi
 *
 * @author Apple
 */
class LinfoxEdi {

    private $ci;

    //put your code here
    function __construct() {
        $this->ci = & get_instance();
        $this->ci->load->library("edi/EdiEngine");
        $this->ci->load->library("edi/EdiStatusProcess");
    }

    public function shipmentdata($shift_id,$response) {
        $api_messages = array();
        $this->ci->load->library("edi/EdiEngine");
        if ($shift_id != "") {
            $getorderids = $this->ci->ediengine->getOrderIds($shift_id);
            $orders_size = count($getorderids);
            if ($orders_size == 0) {
                echo "No orders found.";
                exit();
            }
            if ((!empty($getorderids)) && $orders_size > 1) {
                for ($i = 0; $i < $orders_size; $i++) {
                    $order_id = $getorderids[$i]['id'];
                    $api_messages[] = $this->getOrderInfo($order_id);
                }
                echo json_encode(array("status" => 1, "message" => "API triggered successfully."));
                return;
            } else {
                $order_id = $getorderids[0]['id'];
                return $this->getOrderInfo($order_id);
            }
        }
    }

    public function getOrderInfo($order_id) {
        $order_routing_details = $this->ci->ediengine->getOrderRoutingDetails($order_id);
        $getcargos = $this->ci->ediengine->getCargoDetailsSum($order_id);
        $pickup_details = $this->ci->ediengine->getOrderParites('Shipper', $order_id);
        $drop_details = $this->ci->ediengine->getOrderParites('Consignee', $order_id);
        $customer_details = $this->ci->ediengine->getOrderRelatedCustomer($order_routing_details['customer_id'])[0];
        $order_details = array(
            "routing_details" => $order_routing_details,
            "cargo_details" => $getcargos,
            "pickup_details" => $pickup_details,
            "drop_details" => $drop_details,
            "service_doc" => $this->ci->ediengine->order_related_vas_existance_checking($order_id, 'DOC'),
            "customer_details" => $customer_details
        );
        return $this->createrequestformat($order_details);
//        }
    }

    public function createrequestformat($data) {
        $curtz = $this->ci->session->userdata("usr_tzone")['timezone'];
        $routing_details = $data['routing_details'];
        $cargo_details = $data['cargo_details'];
        $pickup_details = $data['pickup_details'];
        $drop_details = $data['drop_details'];
        $customer_details = $data['customer_details'];
        $service_doc = $data['service_doc'];

        $order_row_id = $routing_details['id'];
        $createdon = getdatetimebytimezone($curtz, $routing_details['createdon'], DFLT_TZ);
        $pickup_datetime = getdatetimebytimezone($curtz, $routing_details['pickup_datetime'], DFLT_TZ);
        $pickup_endtime = getdatetimebytimezone($curtz, $routing_details['pickup_endtime'], DFLT_TZ);
        $delivery_datetime = getdatetimebytimezone($curtz, $routing_details['delivery_datetime'], DFLT_TZ);
        $drop_endtime = getdatetimebytimezone($curtz, $routing_details['drop_endtime'], DFLT_TZ);

        // pickup and delivery inst
        $pickup_ins = $this->ci->ediengine->getOrderReferences($order_row_id, 'ORD_PIKINST');
        $delivery_ins = $this->ci->ediengine->getOrderReferences($order_row_id, 'ORD_DLVINST');
        if ($pickup_ins == "" || strlen(trim($pickup_ins)) == 0) {
            $order_DQ_reference = $this->ci->ediengine->getOrderReferences($order_row_id, 'DQ', '0');
        } else {
            $order_DQ_reference = $this->ci->ediengine->getOrderReferences($order_row_id, 'DQ', '1');
        }

        // vas id base condtion
        $service_doc_value = ($service_doc == 1) ? array(
            "retrieveAD" => array(
                "location" => "РОССИЯ", // Fixed
                "address" => "1129090, Россия, Москва, Олимпийский проспект д. 14, 8 этаж, Бизнес-центр Diamond Hall" // Fixed
            )) : array();

        $request_format = array(
            "object" => "order", // Fix "order"
            "action" => "set", // Fix "set"
            "params" => array(
                "cargo" => array(
                    "correspondence" => TRUE, // Fix true
                    "dimension" => array(
                        "max" => array(
                            "height" => 0.1, // Fix "0.1"
                            "length" => 0.1, // Fix "0.1"
                            "weight" => 0.1, // Fix "0.1"
                            "width" => 0.1   // Fix "0.1"
                        ),
                        "quantity" => (float) (($cargo_details['quantity'] > 0) ? $cargo_details['quantity'] : 1),
                        "volume" => (float) (($cargo_details['volume'] > 0) ? $cargo_details['volume'] : 0.1),
                        "weight" => (float) (($cargo_details['weight'] > 0) ? $cargo_details['weight'] : 0.1)
                    ),
                    "barCode" => $this->ci->ediengine->bite_transit_barcodes_processor($order_row_id, 'Z04'),
                    "insurance" => $this->ci->ediengine->bite_transit_insurance_val_process($this->ci->ediengine->getOrderReferences($order_row_id, 'Z08', 0)), // Fix Map value of Z08 reference, number only; if empty map 0 as number
                    "insuranceNdv" => TRUE
                ),
                "customId" => $routing_details['order_id'], // ORDER ID.
                "gateway" => array(
                    "dispatch" => array(
                        "point" => array(
                            "location" => $routing_details['pickup_address1'] . ',' . $routing_details['pickup_city'] . ',' . $routing_details['pickup_address2'],
                            "address" => $routing_details['pickup_address1'] . ',' . $routing_details['pickup_city'] . ',' . $routing_details['pickup_address2'],
                            "date" => $pickup_datetime['date']
                            , "time" => array(
                                "start" => $this->ci->ediengine->bite_tranist_time_val_process(substr($pickup_datetime['time'], 0, 5)),
                                "end" => $this->ci->ediengine->bite_tranist_time_val_process(substr($pickup_endtime['time'], 0, 5)),
                                "fix" => TRUE
                            )
                            , "note" => $pickup_ins . $order_DQ_reference
                        ),
                        // IF VAS == DOC THEN ONLY WE NEED TO INCLUDE THIS BLOCK INTO REQUEST FORMAT.
                        "service" => $service_doc_value,
                        "customer" => array(
                            "companyName" => $routing_details['pickup'],
                            "email" => $pickup_details['email'],
                            "name" => $routing_details['pickup'],
                            "phone" => $pickup_details['mobile'],
                            "type" => "corporation", // Fix" corporation"
                            "inn" => $this->ci->ediengine->bite_transit_vat_reg_no_process($pickup_details['vat_reg_no'], $order_row_id, 'Z10')
                        )
                    ),
                    "destination" => array(
                        "point" => array(
                            "location" => $routing_details['delivery_address1'] . ',' . $routing_details['delivery_city'] . ',' . $routing_details['delivery_address2'],
                            "address" => $routing_details['delivery_address1'] . ',' . $routing_details['delivery_city'] . ',' . $routing_details['delivery_address2'],
                            "date" => $delivery_datetime['date'],
                            "time" => array(
                                "start" => $this->ci->ediengine->bite_tranist_time_val_process(substr($delivery_datetime['time'], 0, 5)),
                                "end" => $this->ci->ediengine->bite_tranist_time_val_process(substr($drop_endtime['time'], 0, 5)),
                                "fix" => TRUE
                            )
                            , "note" => $delivery_ins
                        ),
                        "customer" => array(
                            "companyName" => $routing_details['delivery'], // Consignee Company Name
                            "email" => $drop_details['email'], // Consignee email
                            "name" => $routing_details['delivery'], // Consignee contact name
                            "phone" => $drop_details['mobile'], // Consignee phone number
                            "type" => "corporation", // Fix" corporation"
                            "inn" => $this->ci->ediengine->bite_transit_vat_reg_no_process($drop_details['vat_reg_no'], $order_row_id, 'Z10') // If exists Consignee Vat Registration Id Number, else Value of reference Z10
                        )
                    )
                )
            ),
            "payer" => array(
                "companyName" => "Общество с ограниченной ответственностью \"Кюне+Нагель\"", // FIXED
                "email" => "ali.gabidulin@kuehne-nagel.com", // FIXED
                "name" => "Али Габидулин", // FIXED
                "phone" => "74957952023", //FIXED
                "type" => "corporation", // FIXED
                "inn" => "7710431565" // FIXED
            ),
            "promoCode" => ""
        );

        //return $this->vozovozapicall($request_format, $order_row_id, $routing_details['order_id']);
    }

    public function vozovozapicall($request_format, $order_row_id, $order_id) {
        log_message("error", "Vozovoz-" . $order_id . ":Request " . json_encode($request_format, JSON_UNESCAPED_UNICODE));
        /*
         *  Vozovoz Transit api curl call.
         */
        $vozovoz_response = vozovoz_transport_order_curl($request_format);
        $response = $vozovoz_response['response'];
        $err = $vozovoz_response['err'];
        if ($err) {
            $message = "cURL Error #:" . $err;
            //log_message("error", 'VOZOVOZ ERROR BLOCK-1--' . $message);
        } else {
            $response = json_decode($response);
            if (isset($response->error) && count($response->error) > 0) {
                $error = $response->error;
                $message = $error->message;
                echo json_encode(array("status" => "0", "message" => $message));
                //log_message("Error", "VOZOVOZ ERROR BLOCK-2...." . $message);
                return;
            }
            $final_response = $response->response;
            if ((!empty($final_response)) && isset($final_response->id) && $final_response->id != '') {
                log_message("error", "Vozovoz-" . $order_id . ":Response " . json_encode($final_response, JSON_UNESCAPED_UNICODE));
                // success block
                $id = $final_response->id;
                $number = $final_response->number;
                $order_reference_insert = array(
                    "order_id" => $order_row_id,
                    "reference_id" => "RUCK",
                    "ref_value" => $id,
                    "order_shortNo" => $number,
                    "createdon" => getdatetimebytimezone(DFLT_TZ, date('Y-m-d H:i:s'), '')['datetime']
                );
                if ($this->ci->common->insertTableData('tb_order_references', $order_reference_insert) > 0) {
                    echo json_encode(array("status" => 1, "message" => "API triggered successfully."));
                } else {
                    echo json_encode(array("status" => 0, "message" => "API trigger Failed."));
                }
                return;
            } else {
                echo json_encode(array("status" => 0, "message" => "Invalid reponse from carriers."));
                log_message("error", 'Invalid reponse from carriers.');
            }
        }
    }

    function generate_status_tacking_format($order_reference_id) {
        $request_format = array(
            "object" => "order",
            "action" => "get",
            "params" => array(
                "filters" => array(
                    "number" => array(
                        $order_reference_id
                    )
                )
            )
        );
//        return $request_format;
        return $request_format;
    }

    function status_codes($given, $taken) {
        $status_code = array("0", "0500", "3000");
        if ($taken == "" && $given == "") {
            return $status_code[0];
        }
        if ($taken != "" && $given == "") {
            return $status_code[1];
        }
        if ($taken != "" && $given != "") {
            return $status_code[2];
        }
    }

    function status_tracking($order_reference_id) {
        $this->ci->load->library("edi/EdiEngine");
        $request_format = $this->generate_status_tacking_format($order_reference_id);
        $status_tracking_response = vozovoz_status_tracking_curl($request_format);
        log_message("error", json_encode($status_tracking_response));
        $response = $status_tracking_response['response'];
        $err = $status_tracking_response['err'];
        $response_data = json_decode($response);
        $data = $response_data->response->data;
        $data_size = sizeof($data);
        if ($data_size == 0) {
            echo "invalid response";
        } else {
            // we can process data.
            if (isset($data[0]->number) && isset($data[0]->id) && isset($data[0]->dates) && count($data[0]->dates) > 0 && strlen($data[0]->id) > 4) {
                $dates = $data[0]->dates;
                $create = $dates->create;
                $taken = $dates->taken; // pickup date.
                $shipped = $dates->shipped;
                $arrived = $dates->arrived;
                $given = $dates->given; // delivery date..
                $status_code = $this->status_codes($given, $taken);
                $order_details = $this->ci->ediengine->get_order_id_based_on_order_reference('RUCK', $order_reference_id);
                // print_r($order_details);
                $this->status_update_process($order_details['order_id'], $status_code, $taken, $given);
            }
        }
    }

    function status_update_process($order_id, $status, $pickup_date, $delivered_date) {
        $stop_id = $stop_detail_id = 0;
        $stop_type = 'P';

        $company_code = $this->ci->session->userdata('company_code');
        $branch_code = $this->ci->session->userdata('branch_code');
        /*
         *  Before Inserting  time it must be convert into UTC .
         */
        $createdon = getdatetimebytimezone(DFLT_TZ, date('Y-m-d H:i:s'), '')['datetime'];
        $pickup_date = getdatetimebytimezone(DFLT_TZ, $pickup_date, '')['datetime'];
        $delivered_date = getdatetimebytimezone(DFLT_TZ, $delivered_date, '')['datetime'];

        /*
         *  check carrier related status codes are exists in tb_status_master else insert them with company and branch code.
         *  and then start using them in tb_Stop_Status.
         */
        $this->ci->edistatusprocess->bite_transit_carrier_status_update($company_code, $branch_code, $createdon);

        /*
         *  carrier status codes
         */
        $status_list = array("0500", "3000");
        $status_codes = array("PICKUP" => "0500", "DELIVERY" => "1300");
        /*
         *  kn status names.
         */
        $avilable_status = array("Accept", "Gate In", "Pickup", "Gate Out", "In-Transit", "Gate IN", "Delivery", "Gate Out", "Close");
        if (in_array($status, array("3000"))) {
            $stop_type = 'D';
        }
        /*
         *  Get shift_id and trip id
         */
        $order = $this->ci->edistatusprocess->getshipment_id($order_id);

        $shipment_id = $order['shift_id'];
        $trip_id = $order['trip_id'];
        $big_order_id = $order['order_id'];

        /*
         *  Get Stop_id
         */
        $stop_id = $this->ci->edistatusprocess->get_order_stop_id($shipment_id, $stop_type);
        /*
         *  stop_detail_id
         */
        $stop_detail_id = $this->ci->edistatusprocess->get_order_stops_details_id($shipment_id, $big_order_id);

        /*
         * vehicel info
         */
        $vehicle_info = $this->ci->edistatusprocess->get_vehicle_info($shipment_id);
        $driver_id = $vehicle_info['driver_id'];
        $vehicle_id = $vehicle_info['vehicle_id'];


        /*
         * get driver phone number
         */

        $mobile_num = $this->ci->edistatusprocess->get_driver_info($driver_id);
        /*
         * Default Lat and Lng
         */
        $lat = 0;
        $lng = 0;
        $reason = 'From Vozovoz';

        if (in_array($status, $status_list)) {
            if ($status == "0500") {
                // i.e. pickup is happend
                /*
                 *  Gate In
                 */
                $status_info = $this->ci->edistatusprocess->get_status_ids($avilable_status[1], $company_code, 'name');
                log_message("error", $this->ci->db->last_query());

                $status_id = $status_info['id'];
                $status_code = $status_info['status_code'];

                /*
                 *  check if status already inserted or not if not insert else no need to update .i.e we can leave it.
                 */
                $check_array = array('order_id' => $order_id, 'shipment_id' => $shipment_id, 'stop_id' => $stop_id, 'stop_detail_id' => $stop_detail_id, 'stop_type' => $stop_type, 'trip_id' => $trip_id, 'status_id' => $status_id, 'status_code' => $status_code, 'driver_id' => $driver_id, 'vehicle_id' => $vehicle_id);
                if ($this->ci->edistatusprocess->check_stop_status_exists_or_not($check_array) == "0") {
                    $innr_array = array('order_id' => $order_id, 'shipment_id' => $shipment_id, 'stop_id' => $stop_id, 'stop_detail_id' => $stop_detail_id, 'stop_type' => $stop_type, 'trip_id' => $trip_id, 'status_id' => $status_id, 'status_code' => $status_code, 'status' => 1, 'reason' => $reason, 'latitude' => $lat, 'longitude' => $lng, 'createdon' => $pickup_date, 'loc_name' => '', 'driver_id' => $driver_id, 'vehicle_id' => $vehicle_id);
                    $this->ci->edistatusprocess->add_stop_status($innr_array);
                }



                /*
                 *  Pickup
                 */
                $status_info = $this->ci->edistatusprocess->get_status_ids($status_codes['PICKUP'], $company_code, 'code');
                $status_id = $status_info['id'];
                $status_code = $status_info['status_code'];
                /*
                 *  check if status already inserted or not if not insert else no need to update .i.e we can leave it.
                 */
                $check_array = array('order_id' => $order_id, 'shipment_id' => $shipment_id, 'stop_id' => $stop_id, 'stop_detail_id' => $stop_detail_id, 'stop_type' => $stop_type, 'trip_id' => $trip_id, 'status_id' => $status_id, 'status_code' => $status_code, 'driver_id' => $driver_id, 'vehicle_id' => $vehicle_id);
                if ($this->ci->edistatusprocess->check_stop_status_exists_or_not($check_array) == "0") {
                    $innr_array = array('order_id' => $order_id, 'shipment_id' => $shipment_id, 'stop_id' => $stop_id, 'stop_detail_id' => $stop_detail_id, 'stop_type' => $stop_type, 'trip_id' => $trip_id, 'status_id' => $status_id, 'status_code' => $status_code, 'status' => 1, 'reason' => $reason, 'latitude' => $lat, 'longitude' => $lng, 'createdon' => $pickup_date, 'loc_name' => '', 'driver_id' => $driver_id, 'vehicle_id' => $vehicle_id);
                    $this->ci->edistatusprocess->add_stop_status($innr_array);
                }

                /*
                 *  Gate Out
                 */
                $status_info = $this->ci->edistatusprocess->get_status_ids($avilable_status[3], $company_code, 'name');
                $status_id = $status_info['id'];
                $status_code = $status_info['status_code'];
                /*
                 *  check if status already inserted or not if not insert else no need to update .i.e we can leave it.
                 */
                $check_array = array('order_id' => $order_id, 'shipment_id' => $shipment_id, 'stop_id' => $stop_id, 'stop_detail_id' => $stop_detail_id, 'stop_type' => $stop_type, 'trip_id' => $trip_id, 'status_id' => $status_id, 'status_code' => $status_code, 'driver_id' => $driver_id, 'vehicle_id' => $vehicle_id);
                if ($this->ci->edistatusprocess->check_stop_status_exists_or_not($check_array) == "0") {
                    $innr_array = array('order_id' => $order_id, 'shipment_id' => $shipment_id, 'stop_id' => $stop_id, 'stop_detail_id' => $stop_detail_id, 'stop_type' => $stop_type, 'trip_id' => $trip_id, 'status_id' => $status_id, 'status_code' => $status_code, 'status' => 1, 'reason' => $reason, 'latitude' => $lat, 'longitude' => $lng, 'createdon' => $pickup_date, 'loc_name' => '', 'driver_id' => $driver_id, 'vehicle_id' => $vehicle_id);
                    $this->ci->edistatusprocess->add_stop_status($innr_array);
                }

                /*
                 *  InTransit
                 */
                $status_info = $this->ci->edistatusprocess->get_status_ids($avilable_status[4], $company_code, 'name');
                $status_id = $status_info['id'];
                $status_code = $status_info['status_code'];
                /*
                 *  check if status already inserted or not if not insert else no need to update .i.e we can leave it.
                 */
                $check_array = array('order_id' => $order_id, 'shipment_id' => $shipment_id, 'stop_id' => $stop_id, 'stop_detail_id' => $stop_detail_id, 'stop_type' => $stop_type, 'trip_id' => $trip_id, 'status_id' => $status_id, 'status_code' => $status_code, 'driver_id' => $driver_id, 'vehicle_id' => $vehicle_id);
                if ($this->ci->edistatusprocess->check_stop_status_exists_or_not($check_array) == "0") {
                    $innr_array = array('order_id' => $order_id, 'shipment_id' => $shipment_id, 'stop_id' => $stop_id, 'stop_detail_id' => $stop_detail_id, 'stop_type' => $stop_type, 'trip_id' => $trip_id, 'status_id' => $status_id, 'status_code' => $status_code, 'status' => 1, 'reason' => $reason, 'latitude' => $lat, 'longitude' => $lng, 'createdon' => $pickup_date, 'loc_name' => '', 'driver_id' => $driver_id, 'vehicle_id' => $vehicle_id);
                    $this->ci->edistatusprocess->add_stop_status($innr_array);
                }
            }

            if ($status == "3000") {
                /*
                 *  Gate In
                 */
                $status_info = $this->ci->edistatusprocess->get_status_ids($avilable_status[1], $company_code, 'name');
                $status_id = $status_info['id'];
                $status_code = $status_info['status_code'];
                /*
                 *  check if status already inserted or not if not insert else no need to update .i.e we can leave it.
                 */
                $check_array = array('order_id' => $order_id, 'shipment_id' => $shipment_id, 'stop_id' => $stop_id, 'stop_detail_id' => $stop_detail_id, 'stop_type' => $stop_type, 'trip_id' => $trip_id, 'status_id' => $status_id, 'status_code' => $status_code, 'driver_id' => $driver_id, 'vehicle_id' => $vehicle_id);
                if ($this->ci->edistatusprocess->check_stop_status_exists_or_not($check_array) == "0") {
                    $innr_array = array('order_id' => $order_id, 'shipment_id' => $shipment_id, 'stop_id' => $stop_id, 'stop_detail_id' => $stop_detail_id, 'stop_type' => $stop_type, 'trip_id' => $trip_id, 'status_id' => $status_id, 'status_code' => $status_code, 'status' => 1, 'reason' => $reason, 'latitude' => $lat, 'longitude' => $lng, 'createdon' => $delivered_date, 'loc_name' => '', 'driver_id' => $driver_id, 'vehicle_id' => $vehicle_id);
                    $this->ci->edistatusprocess->add_stop_status($innr_array);
                }


                /*
                 *  Drop/delivery
                 */
                $status_info = $this->ci->edistatusprocess->get_status_ids($status_codes['DELIVERY'], $company_code, 'code');
                $status_id = $status_info['id'];
                $status_code = $status_info['status_code'];
                /*
                 *  check if status already inserted or not if not insert else no need to update .i.e we can leave it.
                 */
                $check_array = array('order_id' => $order_id, 'shipment_id' => $shipment_id, 'stop_id' => $stop_id, 'stop_detail_id' => $stop_detail_id, 'stop_type' => $stop_type, 'trip_id' => $trip_id, 'status_id' => $status_id, 'status_code' => $status_code, 'driver_id' => $driver_id, 'vehicle_id' => $vehicle_id);
                if ($this->ci->edistatusprocess->check_stop_status_exists_or_not($check_array) == "0") {
                    $innr_array = array('order_id' => $order_id, 'shipment_id' => $shipment_id, 'stop_id' => $stop_id, 'stop_detail_id' => $stop_detail_id, 'stop_type' => $stop_type, 'trip_id' => $trip_id, 'status_id' => $status_id, 'status_code' => $status_code, 'status' => 1, 'reason' => $reason, 'latitude' => $lat, 'longitude' => $lng, 'createdon' => $delivered_date, 'loc_name' => '', 'driver_id' => $driver_id, 'vehicle_id' => $vehicle_id);
                    $this->ci->edistatusprocess->add_stop_status($innr_array);
                }

                /*
                 *  Gate Out
                 */
                $status_info = $this->ci->edistatusprocess->get_status_ids($avilable_status[3], $company_code, 'name');
                $status_id = $status_info['id'];
                $status_code = $status_info['status_code'];
                /*
                 *  check if status already inserted or not if not insert else no need to update .i.e we can leave it.
                 */
                $check_array = array('order_id' => $order_id, 'shipment_id' => $shipment_id, 'stop_id' => $stop_id, 'stop_detail_id' => $stop_detail_id, 'stop_type' => $stop_type, 'trip_id' => $trip_id, 'status_id' => $status_id, 'status_code' => $status_code, 'driver_id' => $driver_id, 'vehicle_id' => $vehicle_id);
                if ($this->ci->edistatusprocess->check_stop_status_exists_or_not($check_array) == "0") {
                    $innr_array = array('order_id' => $order_id, 'shipment_id' => $shipment_id, 'stop_id' => $stop_id, 'stop_detail_id' => $stop_detail_id, 'stop_type' => $stop_type, 'trip_id' => $trip_id, 'status_id' => $status_id, 'status_code' => $status_code, 'status' => 1, 'reason' => $reason, 'latitude' => $lat, 'longitude' => $lng, 'createdon' => $delivered_date, 'loc_name' => '', 'driver_id' => $driver_id, 'vehicle_id' => $vehicle_id);
                    $this->ci->edistatusprocess->add_stop_status($innr_array);
                }

                /*
                 *  Close Trip/
                 */

                // $this->ci->edistatusprocess->close_shipment($order_id, $shipment_id, $trip_id);
            }

            /*
             * add_driver_location info
             */
            if ($vehicle_id != '' && $driver_id != '') {
                $this->ci->edistatusprocess->add_driver_location($driver_id, $vehicle_id, $trip_id, $lat, $lng, $mobile_num, $createdon);
            }
            /*
             *  Add Truck Data.
             */
            if ($vehicle_id != '') {
                $this->ci->edistatusprocess->add_truck_data($vehicle_id, $lat, $lng);
            }
        }
    }

}
