<?php

require_once './vendor/autoload.php';
/*
 *  Rabbitmq 
 */

use PhpAmqpLib\Connection\AMQPStreamConnection;
use PhpAmqpLib\Message\AMQPMessage;
use PhpAmqpLib\Connection\AMQPSSLConnection;
use PhpAmqpLib\Wire;

class Macadam_Status {

    private static function pickup_gate_in($data) {
        $request_xml = "<?xml version='1.0' encoding='UTF-8'?>
            <roadstatus:RoadStatus xmlns:roadstatus='http://knie4.int.kn/msg/roadstatus/0100' xmlns:DateUtil='com.surikat.mobility.common.util.DateUtil' xmlns:date='http://exslt.org/dates-and-times' xmlns:ext='http://exslt.org/common' xmlns:lhdr='http://knie4.int.kn/com/lhdr/0200' xmlns:lmlv='http://knie4.int.kn/com/lmlv/0200' xmlns:lpaci='http://knie4.int.kn/com/lpaci/0200' xmlns:lrcc='http://knie4.int.kn/msg/roadcarriercost/0100' xmlns:lref='http://knie4.int.kn/com/lref/0100' xmlns:lsts='http://knie4.int.kn/com/lsts/0200' xmlns:ltru='http://knie4.int.kn/com/ltru/0200' xmlns:ltypes='http://knie4.int.kn/com/ltypes/0200'>
               <lhdr:MessageHeader>
                  <ReceiverDetails ltypes:AddressType='FW'>
                     <PhysicalReceiver>" . $data['physicalsender'] . "</PhysicalReceiver>
                     <LogicalReceiver>" . $data['logicalsender'] . "</LogicalReceiver>
                  </ReceiverDetails>
                  <PhysicalSender>" . $data['physicalreceiver'] . "</PhysicalSender>
                  <LogicalSender>" . $data['logicalreceiver'] . "</LogicalSender>
                  <SendingApplication>SVKONEKT</SendingApplication>
                  <MessageType>RoadStatus</MessageType>
                  <VersionNumber>0100</VersionNumber>
                  <CreationDateTime>" . $data['current_date_time'] . "</CreationDateTime>
               </lhdr:MessageHeader>
               <Message>
                  <lmlv:MessageLevel>
                     <TrackingNumber>" . $data['order_id'] . "</TrackingNumber>
                     <SenderInformation>
                        <CompanyCode>KNFR</CompanyCode>
                        <BranchCode>" . $data['logicalsender'] . "</BranchCode>
                        <ModeOfTransport>1</ModeOfTransport>
                        <ExportImportFlag>1</ExportImportFlag>
                     </SenderInformation>
                     <MessageNumber>" . $data['assoc_id'] . "</MessageNumber>
                     <MessageReferences ltypes:AddressType='FF'>
                        <Code>INN</Code>
                        <Value>" . $data['ref_value_kn_office'] . "</Value>
                     </MessageReferences>
                  </lmlv:MessageLevel>
                  <lsts:StatusInformation ltypes:StatusCode='" . $data['status_code'] . "'>
                    <StatusDate>" . $data['current_date'] . "</StatusDate>
                    <StatusTime>" . $data['current_time'] . "</StatusTime>
                    <StatusLocation ltypes:LocationIssuer='ZZZ'>" . $data['city'] . "</StatusLocation> 
                    <AdditionalStatusInformation>
                        <CreationIdentifier>X</CreationIdentifier>
                        <StatusEntryDateTime>" . $data['current_date_time'] . "</StatusEntryDateTime>
                        <UserIdentifier>9210ec43-4f33-4f6f-8afa-2db7e974044c</UserIdentifier> 
                    </AdditionalStatusInformation>
                    <AdditionalRoadStatusInformation>
                        <DeviceId>" . $data['device_id'] . "</DeviceId>
                        <User></User>
                    </AdditionalRoadStatusInformation>
                  </lsts:StatusInformation>
                  <Shipment>
                    <lref:ReferencesDetails ltypes:AddressType='FF'>
                       <Code>TTY</Code>
                       <Value>CLL</Value>
                    </lref:ReferencesDetails> 
                  </Shipment>
                  </Message>
            </roadstatus:RoadStatus>";
        return $request_xml;
    }

    private static function pickup_broken($data) {
        $request_xml = "<?xml version='1.0' encoding='UTF-8'?>
            <roadstatus:RoadStatus xmlns:roadstatus='http://knie4.int.kn/msg/roadstatus/0100' xmlns:date='http://exslt.org/dates-and-times' xmlns:ext='http://exslt.org/common' xmlns:lrcc='http://knie4.int.kn/msg/roadcarriercost/0100' xmlns:lsts='http://knie4.int.kn/com/lsts/0200' xmlns:lpaci='http://knie4.int.kn/com/lpaci/0200' xmlns:lref='http://knie4.int.kn/com/lref/0100' xmlns:DateUtil='com.surikat.mobility.common.util.DateUtil' xmlns:lhdr='http://knie4.int.kn/com/lhdr/0200' xmlns:lmlv='http://knie4.int.kn/com/lmlv/0200' xmlns:ltru='http://knie4.int.kn/com/ltru/0200' xmlns:ltypes='http://knie4.int.kn/com/ltypes/0200'>
               <lhdr:MessageHeader>
                  <ReceiverDetails ltypes:AddressType='FW'>
                     <PhysicalReceiver>" . $data['physicalsender'] . "</PhysicalReceiver>
                     <LogicalReceiver>" . $data['logicalsender'] . "</LogicalReceiver>
                  </ReceiverDetails>
                  <PhysicalSender>" . $data['physicalreceiver'] . "</PhysicalSender>
                  <LogicalSender>" . $data['logicalreceiver'] . "</LogicalSender>
                  <SendingApplication>SVKONEKT</SendingApplication>
                  <MessageType>RoadStatus</MessageType>
                  <VersionNumber>0100</VersionNumber>
                  <CreationDateTime>" . $data['current_date_time'] . "</CreationDateTime>
               </lhdr:MessageHeader>
               <Message>
                  <lmlv:MessageLevel>
                     <TrackingNumber>" . $data['order_id'] . "</TrackingNumber>
                     <SenderInformation>
                        <CompanyCode>KNFR</CompanyCode>
                        <BranchCode>" . $data['logicalsender'] . "</BranchCode>
                        <ModeOfTransport>1</ModeOfTransport>
                        <ExportImportFlag>1</ExportImportFlag>
                     </SenderInformation>
                     <MessageNumber>" . $data['assoc_id'] . "</MessageNumber>
                     <MessageReferences ltypes:AddressType='FF'>
                        <Code>INN</Code>
                        <Value>" . $data['ref_value_kn_office'] . "</Value>
                     </MessageReferences>
                  </lmlv:MessageLevel>
                  <lsts:StatusInformation ltypes:StatusCode='" . $data['status_code'] . "'>
                    <StatusDate>" . $data['current_date'] . "</StatusDate>
                    <StatusTime>" . $data['current_time'] . "</StatusTime>
                    <StatusLocation ltypes:LocationIssuer='ZZZ'>" . $data['city'] . "</StatusLocation>
                    <ExceptionCode>" . $data['exception_code'] . "</ExceptionCode>
                    <AdditionalStatusInformation>
                        <CreationIdentifier>X</CreationIdentifier>
                        <StatusEntryDateTime>" . $data['current_date_time'] . "</StatusEntryDateTime>
                        <UserIdentifier>9210ec43-4f33-4f6f-8afa-2db7e974044c</UserIdentifier> 
                        <Remarks>" . $data['remark'] . "</Remarks>
                    </AdditionalStatusInformation>
                    <AdditionalRoadStatusInformation>
                        <ContactName>" . $data['pod_signee'] . "</ContactName>
                        <DeviceId>" . $data['device_id'] . "</DeviceId>
                        <User></User>
                        <SignatureType>SignaturePapier</SignatureType>
                        <DocumentId>" . $data['document_id'] . "</DocumentId>
                        <PhotoId>" . $data['picture_id'] . "</PhotoId>
                    </AdditionalRoadStatusInformation>
                  </lsts:StatusInformation>
                  <Shipment>
                    <lref:ReferencesDetails ltypes:AddressType='FF'>
                       <Code>TTY</Code>
                       <Value>CLL</Value>
                    </lref:ReferencesDetails> 
                  </Shipment>
                  </Message>
            </roadstatus:RoadStatus>";
        return $request_xml;
    }

    private static function pickup_ok($data) {
        $request_xml = "<?xml version='1.0' encoding='UTF-8'?>
            <roadstatus:RoadStatus xmlns:roadstatus='http://knie4.int.kn/msg/roadstatus/0100' xmlns:DateUtil='com.surikat.mobility.common.util.DateUtil' xmlns:date='http://exslt.org/dates-and-times' xmlns:ext='http://exslt.org/common' xmlns:lhdr='http://knie4.int.kn/com/lhdr/0200' xmlns:lmlv='http://knie4.int.kn/com/lmlv/0200' xmlns:lpaci='http://knie4.int.kn/com/lpaci/0200' xmlns:lrcc='http://knie4.int.kn/msg/roadcarriercost/0100' xmlns:lref='http://knie4.int.kn/com/lref/0100' xmlns:lsts='http://knie4.int.kn/com/lsts/0200' xmlns:ltru='http://knie4.int.kn/com/ltru/0200' xmlns:ltypes='http://knie4.int.kn/com/ltypes/0200'>
               <lhdr:MessageHeader>
                  <ReceiverDetails ltypes:AddressType='FW'>
                     <PhysicalReceiver>" . $data['physicalsender'] . "</PhysicalReceiver>
                     <LogicalReceiver>" . $data['logicalsender'] . "</LogicalReceiver>
                  </ReceiverDetails>
                  <PhysicalSender>" . $data['physicalreceiver'] . "</PhysicalSender>
                  <LogicalSender>" . $data['logicalreceiver'] . "</LogicalSender>
                  <SendingApplication>SVKONEKT</SendingApplication>
                  <MessageType>RoadStatus</MessageType>
                  <VersionNumber>0100</VersionNumber>
                  <CreationDateTime>" . $data['current_date_time'] . "</CreationDateTime>
               </lhdr:MessageHeader>
               <Message>
                  <lmlv:MessageLevel>
                     <TrackingNumber>" . $data['order_id'] . "</TrackingNumber>
                     <SenderInformation>
                        <CompanyCode>KNFR</CompanyCode>
                        <BranchCode>" . $data['logicalsender'] . "</BranchCode>
                        <ModeOfTransport>1</ModeOfTransport>
                        <ExportImportFlag>1</ExportImportFlag>
                     </SenderInformation>
                     <MessageNumber>" . $data['assoc_id'] . "</MessageNumber>
                     <MessageReferences ltypes:AddressType='FF'>
                        <Code>INN</Code>
                        <Value>" . $data['ref_value_kn_office'] . "</Value>
                     </MessageReferences>
                  </lmlv:MessageLevel>
                  <lsts:StatusInformation ltypes:StatusCode='" . $data['status_code'] . "'>
                    <StatusDate>" . $data['current_date'] . "</StatusDate>
                    <StatusTime>" . $data['current_time'] . "</StatusTime>
                    <StatusLocation ltypes:LocationIssuer='ZZZ'>" . $data['city'] . "</StatusLocation>
                    <AdditionalStatusInformation>
                        <CreationIdentifier>X</CreationIdentifier>
                        <StatusEntryDateTime>" . $data['current_date_time'] . "</StatusEntryDateTime>
                        <UserIdentifier>9210ec43-4f33-4f6f-8afa-2db7e974044c</UserIdentifier> 
                        <Remarks>" . $data['remark'] . "</Remarks>
                    </AdditionalStatusInformation>
                    <AdditionalRoadStatusInformation>
                        <ContactName>" . $data['pod_signee'] . "</ContactName>
                        <DeviceId>" . $data['device_id'] . "</DeviceId>
                        <User></User>
                        <SignatureType>SignaturePapier</SignatureType>
                        <DocumentId>" . $data['document_id'] . "</DocumentId>
                        <PhotoId>" . $data['picture_id'] . "</PhotoId>
                    </AdditionalRoadStatusInformation>
                  </lsts:StatusInformation>
                  <Shipment>
                    <lref:ReferencesDetails ltypes:AddressType='FF'>
                       <Code>TTY</Code>
                       <Value>CLL</Value>
                    </lref:ReferencesDetails> 
                  </Shipment>
                  </Message>
            </roadstatus:RoadStatus>";
        return $request_xml;
    }

    private static function pickup_not_done($data) {
        $request_xml = "<?xml version='1.0' encoding='UTF-8'?>
            <roadstatus:RoadStatus xmlns:roadstatus='http://knie4.int.kn/msg/roadstatus/0100' xmlns:DateUtil='com.surikat.mobility.common.util.DateUtil' xmlns:date='http://exslt.org/dates-and-times' xmlns:ext='http://exslt.org/common' xmlns:lhdr='http://knie4.int.kn/com/lhdr/0200' xmlns:lmlv='http://knie4.int.kn/com/lmlv/0200' xmlns:lpaci='http://knie4.int.kn/com/lpaci/0200' xmlns:lrcc='http://knie4.int.kn/msg/roadcarriercost/0100' xmlns:lref='http://knie4.int.kn/com/lref/0100' xmlns:lsts='http://knie4.int.kn/com/lsts/0200' xmlns:ltru='http://knie4.int.kn/com/ltru/0200' xmlns:ltypes='http://knie4.int.kn/com/ltypes/0200'>
               <lhdr:MessageHeader>
                  <ReceiverDetails ltypes:AddressType='FW'>
                     <PhysicalReceiver>" . $data['physicalsender'] . "</PhysicalReceiver>
                     <LogicalReceiver>" . $data['logicalsender'] . "</LogicalReceiver>
                  </ReceiverDetails>
                  <PhysicalSender>" . $data['physicalreceiver'] . "</PhysicalSender>
                  <LogicalSender>" . $data['logicalreceiver'] . "</LogicalSender>
                  <SendingApplication>SVKONEKT</SendingApplication>
                  <MessageType>RoadStatus</MessageType>
                  <VersionNumber>0100</VersionNumber>
                  <CreationDateTime>" . $data['current_date_time'] . "</CreationDateTime>
               </lhdr:MessageHeader>
               <Message>
                  <lmlv:MessageLevel>
                     <TrackingNumber>" . $data['order_id'] . "</TrackingNumber>
                     <SenderInformation>
                        <CompanyCode>KNFR</CompanyCode>
                        <BranchCode>" . $data['logicalsender'] . "</BranchCode>
                        <ModeOfTransport>1</ModeOfTransport>
                        <ExportImportFlag>1</ExportImportFlag>
                     </SenderInformation>
                     <MessageNumber>" . $data['assoc_id'] . "</MessageNumber>
                     <MessageReferences ltypes:AddressType='FF'>
                        <Code>INN</Code>
                        <Value>" . $data['ref_value_kn_office'] . "</Value>
                     </MessageReferences>
                  </lmlv:MessageLevel>
                  <lsts:StatusInformation ltypes:StatusCode='" . $data['status_code'] . "'>
                    <StatusDate>" . $data['current_date'] . "</StatusDate>
                    <StatusTime>" . $data['current_time'] . "</StatusTime>
                    <StatusLocation ltypes:LocationIssuer='ZZZ'>" . $data['city'] . "</StatusLocation>
                    <ExceptionCode>" . $data['exception_code'] . "</ExceptionCode>
                    <AdditionalStatusInformation>
                        <CreationIdentifier>X</CreationIdentifier>
                        <StatusEntryDateTime>" . $data['current_date_time'] . "</StatusEntryDateTime>
                        <UserIdentifier>9210ec43-4f33-4f6f-8afa-2db7e974044c</UserIdentifier> 
                        <Remarks>" . $data['remark'] . "</Remarks>
                    </AdditionalStatusInformation>
                    <AdditionalRoadStatusInformation>
                        <ContactName>" . $data['pod_signee'] . "</ContactName>
                        <DeviceId>" . $data['device_id'] . "</DeviceId>
                        <User></User>
                        <SignatureType>SignaturePapier</SignatureType>
                        <DocumentId>" . $data['document_id'] . "</DocumentId>
                        <PhotoId>" . $data['picture_id'] . "</PhotoId>
                    </AdditionalRoadStatusInformation>
                  </lsts:StatusInformation>
                  <Shipment>
                    <lref:ReferencesDetails ltypes:AddressType='FF'>
                       <Code>TTY</Code>
                       <Value>CLL</Value>
                    </lref:ReferencesDetails> 
                   </Shipment>
                  </Message>
            </roadstatus:RoadStatus>";
        return $request_xml;
    }

    private static function pickup_gate_out($data) {
        $request_xml = "<?xml version='1.0' encoding='UTF-8'?>
            <roadstatus:RoadStatus xmlns:roadstatus='http://knie4.int.kn/msg/roadstatus/0100' xmlns:DateUtil='com.surikat.mobility.common.util.DateUtil' xmlns:date='http://exslt.org/dates-and-times' xmlns:ext='http://exslt.org/common' xmlns:lhdr='http://knie4.int.kn/com/lhdr/0200' xmlns:lmlv='http://knie4.int.kn/com/lmlv/0200' xmlns:lpaci='http://knie4.int.kn/com/lpaci/0200' xmlns:lrcc='http://knie4.int.kn/msg/roadcarriercost/0100' xmlns:lref='http://knie4.int.kn/com/lref/0100' xmlns:lsts='http://knie4.int.kn/com/lsts/0200' xmlns:ltru='http://knie4.int.kn/com/ltru/0200' xmlns:ltypes='http://knie4.int.kn/com/ltypes/0200'>
               <lhdr:MessageHeader>
                  <ReceiverDetails ltypes:AddressType='FW'>
                     <PhysicalReceiver>" . $data['physicalsender'] . "</PhysicalReceiver>
                     <LogicalReceiver>" . $data['logicalsender'] . "</LogicalReceiver>
                  </ReceiverDetails>
                  <PhysicalSender>" . $data['physicalreceiver'] . "</PhysicalSender>
                  <LogicalSender>" . $data['logicalreceiver'] . "</LogicalSender>
                  <SendingApplication>SVKONEKT</SendingApplication>
                  <MessageType>RoadStatus</MessageType>
                  <VersionNumber>0100</VersionNumber>
                  <CreationDateTime>" . $data['current_date_time'] . "</CreationDateTime>
               </lhdr:MessageHeader>
               <Message>
                  <lmlv:MessageLevel>
                     <TrackingNumber>" . $data['order_id'] . "</TrackingNumber>
                     <SenderInformation>
                        <CompanyCode>KNFR</CompanyCode>
                        <BranchCode>" . $data['logicalsender'] . "</BranchCode>
                        <ModeOfTransport>1</ModeOfTransport>
                        <ExportImportFlag>1</ExportImportFlag>
                     </SenderInformation>
                     <MessageNumber>" . $data['assoc_id'] . "</MessageNumber>
                     <MessageReferences ltypes:AddressType='FF'>
                        <Code>INN</Code>
                        <Value>" . $data['ref_value_kn_office'] . "</Value>
                     </MessageReferences>
                  </lmlv:MessageLevel>
                  <lsts:StatusInformation ltypes:StatusCode='" . $data['status_code'] . "'>
                    <StatusDate>" . $data['current_date'] . "</StatusDate>
                    <StatusTime>" . $data['current_time'] . "</StatusTime>
                    <StatusLocation ltypes:LocationIssuer='ZZZ'>" . $data['city'] . "</StatusLocation> 
                    <AdditionalStatusInformation>
                        <CreationIdentifier>X</CreationIdentifier>
                        <StatusEntryDateTime>" . $data['current_date_time'] . "</StatusEntryDateTime>
                        <UserIdentifier>9210ec43-4f33-4f6f-8afa-2db7e974044c</UserIdentifier> 
                    </AdditionalStatusInformation>
                    <AdditionalRoadStatusInformation>
                        <DeviceId>" . $data['device_id'] . "</DeviceId>
                        <User></User>
                    </AdditionalRoadStatusInformation>
                  </lsts:StatusInformation>
                  <Shipment>
                    <lref:ReferencesDetails ltypes:AddressType='FF'>
                       <Code>TTY</Code>
                       <Value>CLL</Value>
                    </lref:ReferencesDetails> 
                  </Shipment>
                  </Message>
            </roadstatus:RoadStatus>";
        return $request_xml;
    }

    private static function delivery_gate_in($data) {
        $request_xml = "<?xml version='1.0' encoding='UTF-8'?>
            <roadstatus:RoadStatus xmlns:roadstatus='http://knie4.int.kn/msg/roadstatus/0100' xmlns:DateUtil='com.surikat.mobility.common.util.DateUtil' xmlns:date='http://exslt.org/dates-and-times' xmlns:ext='http://exslt.org/common' xmlns:lhdr='http://knie4.int.kn/com/lhdr/0200' xmlns:lmlv='http://knie4.int.kn/com/lmlv/0200' xmlns:lpaci='http://knie4.int.kn/com/lpaci/0200' xmlns:lrcc='http://knie4.int.kn/msg/roadcarriercost/0100' xmlns:lref='http://knie4.int.kn/com/lref/0100' xmlns:lsts='http://knie4.int.kn/com/lsts/0200' xmlns:ltru='http://knie4.int.kn/com/ltru/0200' xmlns:ltypes='http://knie4.int.kn/com/ltypes/0200'>
               <lhdr:MessageHeader>
                  <ReceiverDetails ltypes:AddressType='FW'>
                     <PhysicalReceiver>" . $data['physicalsender'] . "</PhysicalReceiver>
                     <LogicalReceiver>" . $data['logicalsender'] . "</LogicalReceiver>
                  </ReceiverDetails>
                  <PhysicalSender>" . $data['physicalreceiver'] . "</PhysicalSender>
                  <LogicalSender>" . $data['logicalreceiver'] . "</LogicalSender>
                  <SendingApplication>SVKONEKT</SendingApplication>
                  <MessageType>RoadStatus</MessageType>
                  <VersionNumber>0100</VersionNumber>
                  <CreationDateTime>" . $data['current_date_time'] . "</CreationDateTime>
               </lhdr:MessageHeader>
               <Message>
                  <lmlv:MessageLevel>
                     <TrackingNumber>" . $data['order_id'] . "</TrackingNumber>
                     <SenderInformation>
                        <CompanyCode>KNFR</CompanyCode>
                        <BranchCode>" . $data['logicalsender'] . "</BranchCode>
                        <ModeOfTransport>1</ModeOfTransport>
                        <ExportImportFlag>1</ExportImportFlag>
                     </SenderInformation>
                     <MessageNumber>" . $data['assoc_id'] . "</MessageNumber>
                     <MessageReferences ltypes:AddressType='FF'>
                        <Code>INN</Code>
                        <Value>" . $data['ref_value_kn_office'] . "</Value>
                     </MessageReferences>
                  </lmlv:MessageLevel>
                  <lsts:StatusInformation ltypes:StatusCode='" . $data['status_code'] . "'>
                    <StatusDate>" . $data['current_date'] . "</StatusDate>
                    <StatusTime>" . $data['current_time'] . "</StatusTime>
                    <StatusLocation ltypes:LocationIssuer='ZZZ'>" . $data['city'] . "</StatusLocation> 
                    <AdditionalStatusInformation>
                        <CreationIdentifier>X</CreationIdentifier>
                        <StatusEntryDateTime>" . $data['current_date_time'] . "</StatusEntryDateTime>
                        <UserIdentifier>9210ec43-4f33-4f6f-8afa-2db7e974044c</UserIdentifier> 
                    </AdditionalStatusInformation>
                    <AdditionalRoadStatusInformation>
                        <DeviceId>" . $data['device_id'] . "</DeviceId>
                        <User></User>
                    </AdditionalRoadStatusInformation>
                  </lsts:StatusInformation>
                  <Shipment>
                    <lref:ReferencesDetails ltypes:AddressType='FF'>
                       <Code>TTY</Code>
                       <Value>DLV</Value>
                    </lref:ReferencesDetails> 
                  </Shipment>
                  </Message>
            </roadstatus:RoadStatus>";
        return $request_xml;
    }

    private static function delivered_short($data) {
        $request_xml = "<?xml version='1.0' encoding='UTF-8'?>
            <roadstatus:RoadStatus xmlns:roadstatus='http://knie4.int.kn/msg/roadstatus/0100' xmlns:DateUtil='com.surikat.mobility.common.util.DateUtil' xmlns:date='http://exslt.org/dates-and-times' xmlns:ext='http://exslt.org/common' xmlns:lhdr='http://knie4.int.kn/com/lhdr/0200' xmlns:lmlv='http://knie4.int.kn/com/lmlv/0200' xmlns:lpaci='http://knie4.int.kn/com/lpaci/0200' xmlns:lrcc='http://knie4.int.kn/msg/roadcarriercost/0100' xmlns:lref='http://knie4.int.kn/com/lref/0100' xmlns:lsts='http://knie4.int.kn/com/lsts/0200' xmlns:ltru='http://knie4.int.kn/com/ltru/0200' xmlns:ltypes='http://knie4.int.kn/com/ltypes/0200'>
               <lhdr:MessageHeader>
                  <ReceiverDetails ltypes:AddressType='FW'>
                     <PhysicalReceiver>" . $data['physicalsender'] . "</PhysicalReceiver>
                     <LogicalReceiver>" . $data['logicalsender'] . "</LogicalReceiver>
                  </ReceiverDetails>
                  <PhysicalSender>" . $data['physicalreceiver'] . "</PhysicalSender>
                  <LogicalSender>" . $data['logicalreceiver'] . "</LogicalSender>
                  <SendingApplication>SVKONEKT</SendingApplication>
                  <MessageType>RoadStatus</MessageType>
                  <VersionNumber>0100</VersionNumber>
                  <CreationDateTime>" . $data['current_date_time'] . "</CreationDateTime>
               </lhdr:MessageHeader>
               <Message>
                  <lmlv:MessageLevel>
                     <TrackingNumber>" . $data['order_id'] . "</TrackingNumber>
                     <SenderInformation>
                        <CompanyCode>KNFR</CompanyCode>
                        <BranchCode>" . $data['logicalsender'] . "</BranchCode>
                        <ModeOfTransport>1</ModeOfTransport>
                        <ExportImportFlag>1</ExportImportFlag>
                     </SenderInformation>
                     <MessageNumber>" . $data['assoc_id'] . "</MessageNumber>
                     <MessageReferences ltypes:AddressType='FF'>
                        <Code>INN</Code>
                        <Value>" . $data['ref_value_kn_office'] . "</Value>
                     </MessageReferences>
                  </lmlv:MessageLevel>
                  <lsts:StatusInformation ltypes:StatusCode='" . $data['status_code'] . "'>
                    <StatusDate>" . $data['current_date'] . "</StatusDate>
                    <StatusTime>" . $data['current_time'] . "</StatusTime>
                    <StatusLocation ltypes:LocationIssuer='ZZZ'>" . $data['city'] . "</StatusLocation>
                    <ExceptionCode>" . $data['exception_code'] . "</ExceptionCode>
                    <AdditionalStatusInformation>
                        <CreationIdentifier>X</CreationIdentifier>
                        <StatusEntryDateTime>" . $data['current_date_time'] . "</StatusEntryDateTime>
                        <UserIdentifier>9210ec43-4f33-4f6f-8afa-2db7e974044c</UserIdentifier> 
                        <Remarks>" . $data['remark'] . "</Remarks>
                    </AdditionalStatusInformation>
                    <AdditionalRoadStatusInformation>
                        <ContactName>" . $data['pod_signee'] . "</ContactName>
                        <DeviceId>" . $data['device_id'] . "</DeviceId>
                        <User></User>
                        <SignatureType>SignaturePapier</SignatureType>
                        <DocumentId>" . $data['document_id'] . "</DocumentId>
                        <PhotoId>" . $data['picture_id'] . "</PhotoId>
                        <NumberUnits>" . $data['missing_qty'] . "</NumberUnits>
                    </AdditionalRoadStatusInformation>
                  </lsts:StatusInformation>
                  <Shipment>
                    <lref:ReferencesDetails ltypes:AddressType='FF'>
                       <Code>TTY</Code>
                       <Value>DLV</Value>
                    </lref:ReferencesDetails> 
                  </Shipment>
                  </Message>
            </roadstatus:RoadStatus>";
        return $request_xml;
    }

    private static function delivered_with_damage($data) {
        $request_xml = "<?xml version='1.0' encoding='UTF-8'?>
            <roadstatus:RoadStatus xmlns:roadstatus='http://knie4.int.kn/msg/roadstatus/0100' xmlns:DateUtil='com.surikat.mobility.common.util.DateUtil' xmlns:date='http://exslt.org/dates-and-times' xmlns:ext='http://exslt.org/common' xmlns:lhdr='http://knie4.int.kn/com/lhdr/0200' xmlns:lmlv='http://knie4.int.kn/com/lmlv/0200' xmlns:lpaci='http://knie4.int.kn/com/lpaci/0200' xmlns:lrcc='http://knie4.int.kn/msg/roadcarriercost/0100' xmlns:lref='http://knie4.int.kn/com/lref/0100' xmlns:lsts='http://knie4.int.kn/com/lsts/0200' xmlns:ltru='http://knie4.int.kn/com/ltru/0200' xmlns:ltypes='http://knie4.int.kn/com/ltypes/0200'>
               <lhdr:MessageHeader>
                  <ReceiverDetails ltypes:AddressType='FW'>
                     <PhysicalReceiver>" . $data['physicalsender'] . "</PhysicalReceiver>
                     <LogicalReceiver>" . $data['logicalsender'] . "</LogicalReceiver>
                  </ReceiverDetails>
                  <PhysicalSender>" . $data['physicalreceiver'] . "</PhysicalSender>
                  <LogicalSender>" . $data['logicalreceiver'] . "</LogicalSender>
                  <SendingApplication>SVKONEKT</SendingApplication>
                  <MessageType>RoadStatus</MessageType>
                  <VersionNumber>0100</VersionNumber>
                  <CreationDateTime>" . $data['current_date_time'] . "</CreationDateTime>
               </lhdr:MessageHeader>
               <Message>
                  <lmlv:MessageLevel>
                     <TrackingNumber>" . $data['order_id'] . "</TrackingNumber>
                     <SenderInformation>
                        <CompanyCode>KNFR</CompanyCode>
                        <BranchCode>" . $data['logicalsender'] . "</BranchCode>
                        <ModeOfTransport>1</ModeOfTransport>
                        <ExportImportFlag>1</ExportImportFlag>
                     </SenderInformation>
                     <MessageNumber>" . $data['assoc_id'] . "</MessageNumber>
                     <MessageReferences ltypes:AddressType='FF'>
                        <Code>INN</Code>
                        <Value>" . $data['ref_value_kn_office'] . "</Value>
                     </MessageReferences>
                  </lmlv:MessageLevel>
                  <lsts:StatusInformation ltypes:StatusCode='" . $data['status_code'] . "'>
                    <StatusDate>" . $data['current_date'] . "</StatusDate>
                    <StatusTime>" . $data['current_time'] . "</StatusTime>
                    <StatusLocation ltypes:LocationIssuer='ZZZ'>" . $data['city'] . "</StatusLocation>
                    <ExceptionCode>" . $data['exception_code'] . "</ExceptionCode>
                    <AdditionalStatusInformation>
                        <CreationIdentifier>X</CreationIdentifier>
                        <StatusEntryDateTime>" . $data['current_date_time'] . "</StatusEntryDateTime>
                        <UserIdentifier>9210ec43-4f33-4f6f-8afa-2db7e974044c</UserIdentifier> 
                        <Remarks>" . $data['remark'] . "</Remarks>
                    </AdditionalStatusInformation>
                    <AdditionalRoadStatusInformation>
                        <ContactName>" . $data['pod_signee'] . "</ContactName>
                        <DeviceId>" . $data['device_id'] . "</DeviceId>
                        <User></User>
                        <SignatureType>SignaturePapier</SignatureType>
                        <DocumentId>" . $data['document_id'] . "</DocumentId>
                        <PhotoId>" . $data['picture_id'] . "</PhotoId>
                    </AdditionalRoadStatusInformation>
                  </lsts:StatusInformation>
                  <Shipment>
                    <lref:ReferencesDetails ltypes:AddressType='FF'>
                       <Code>TTY</Code>
                       <Value>DLV</Value>
                    </lref:ReferencesDetails> 
                  </Shipment>
                  </Message>
            </roadstatus:RoadStatus>";
        return $request_xml;
    }

    private static function delivered($data) {
        $request_xml = "<?xml version='1.0' encoding='UTF-8'?>
            <roadstatus:RoadStatus xmlns:roadstatus='http://knie4.int.kn/msg/roadstatus/0100' xmlns:DateUtil='com.surikat.mobility.common.util.DateUtil' xmlns:date='http://exslt.org/dates-and-times' xmlns:ext='http://exslt.org/common' xmlns:lhdr='http://knie4.int.kn/com/lhdr/0200' xmlns:lmlv='http://knie4.int.kn/com/lmlv/0200' xmlns:lpaci='http://knie4.int.kn/com/lpaci/0200' xmlns:lrcc='http://knie4.int.kn/msg/roadcarriercost/0100' xmlns:lref='http://knie4.int.kn/com/lref/0100' xmlns:lsts='http://knie4.int.kn/com/lsts/0200' xmlns:ltru='http://knie4.int.kn/com/ltru/0200' xmlns:ltypes='http://knie4.int.kn/com/ltypes/0200'>
               <lhdr:MessageHeader>
                  <ReceiverDetails ltypes:AddressType='FW'>
                     <PhysicalReceiver>" . $data['physicalsender'] . "</PhysicalReceiver>
                     <LogicalReceiver>" . $data['logicalsender'] . "</LogicalReceiver>
                  </ReceiverDetails>
                  <PhysicalSender>" . $data['physicalreceiver'] . "</PhysicalSender>
                  <LogicalSender>" . $data['logicalreceiver'] . "</LogicalSender>
                  <SendingApplication>SVKONEKT</SendingApplication>
                  <MessageType>RoadStatus</MessageType>
                  <VersionNumber>0100</VersionNumber>
                  <CreationDateTime>" . $data['current_date_time'] . "</CreationDateTime>
               </lhdr:MessageHeader>
               <Message>
                  <lmlv:MessageLevel>
                     <TrackingNumber>" . $data['order_id'] . "</TrackingNumber>
                     <SenderInformation>
                        <CompanyCode>KNFR</CompanyCode>
                        <BranchCode>" . $data['logicalsender'] . "</BranchCode>
                        <ModeOfTransport>1</ModeOfTransport>
                        <ExportImportFlag>1</ExportImportFlag>
                     </SenderInformation>
                     <MessageNumber>" . $data['assoc_id'] . "</MessageNumber>
                     <MessageReferences ltypes:AddressType='FF'>
                        <Code>INN</Code>
                        <Value>" . $data['ref_value_kn_office'] . "</Value>
                     </MessageReferences>
                  </lmlv:MessageLevel>
                  <lsts:StatusInformation ltypes:StatusCode='" . $data['status_code'] . "'>
                    <StatusDate>" . $data['current_date'] . "</StatusDate>
                    <StatusTime>" . $data['current_time'] . "</StatusTime>
                    <StatusLocation ltypes:LocationIssuer='ZZZ'>" . $data['city'] . "</StatusLocation>
                    <AdditionalStatusInformation>
                        <CreationIdentifier>X</CreationIdentifier>
                        <StatusEntryDateTime>" . $data['current_date_time'] . "</StatusEntryDateTime>
                        <UserIdentifier>9210ec43-4f33-4f6f-8afa-2db7e974044c</UserIdentifier> 
                        <Remarks>" . $data['remark'] . "</Remarks>
                    </AdditionalStatusInformation>
                    <AdditionalRoadStatusInformation>
                        <ContactName>" . $data['pod_signee'] . "</ContactName>
                        <DeviceId>" . $data['device_id'] . "</DeviceId>
                        <User></User>
                        <SignatureType>SignaturePapier</SignatureType>
                        <DocumentId>" . $data['document_id'] . "</DocumentId>
                        <PhotoId>" . $data['picture_id'] . "</PhotoId>
                    </AdditionalRoadStatusInformation>
                  </lsts:StatusInformation>
                  <Shipment>
                    <lref:ReferencesDetails ltypes:AddressType='FF'>
                       <Code>TTY</Code>
                       <Value>DLV</Value>
                    </lref:ReferencesDetails> 
                  </Shipment>
                  </Message>
            </roadstatus:RoadStatus>";
        return $request_xml;
    }

    private static function delivery_not_done($data) {
        $request_xml = "<?xml version='1.0' encoding='UTF-8'?>
            <roadstatus:RoadStatus xmlns:roadstatus='http://knie4.int.kn/msg/roadstatus/0100' xmlns:DateUtil='com.surikat.mobility.common.util.DateUtil' xmlns:date='http://exslt.org/dates-and-times' xmlns:ext='http://exslt.org/common' xmlns:lhdr='http://knie4.int.kn/com/lhdr/0200' xmlns:lmlv='http://knie4.int.kn/com/lmlv/0200' xmlns:lpaci='http://knie4.int.kn/com/lpaci/0200' xmlns:lrcc='http://knie4.int.kn/msg/roadcarriercost/0100' xmlns:lref='http://knie4.int.kn/com/lref/0100' xmlns:lsts='http://knie4.int.kn/com/lsts/0200' xmlns:ltru='http://knie4.int.kn/com/ltru/0200' xmlns:ltypes='http://knie4.int.kn/com/ltypes/0200'>
               <lhdr:MessageHeader>
                  <ReceiverDetails ltypes:AddressType='FW'>
                     <PhysicalReceiver>" . $data['physicalsender'] . "</PhysicalReceiver>
                     <LogicalReceiver>" . $data['logicalsender'] . "</LogicalReceiver>
                  </ReceiverDetails>
                  <PhysicalSender>" . $data['physicalreceiver'] . "</PhysicalSender>
                  <LogicalSender>" . $data['logicalreceiver'] . "</LogicalSender>
                  <SendingApplication>SVKONEKT</SendingApplication>
                  <MessageType>RoadStatus</MessageType>
                  <VersionNumber>0100</VersionNumber>
                  <CreationDateTime>" . $data['current_date_time'] . "</CreationDateTime>
               </lhdr:MessageHeader>
               <Message>
                  <lmlv:MessageLevel>
                     <TrackingNumber>" . $data['order_id'] . "</TrackingNumber>
                     <SenderInformation>
                        <CompanyCode>KNFR</CompanyCode>
                        <BranchCode>" . $data['logicalsender'] . "</BranchCode>
                        <ModeOfTransport>1</ModeOfTransport>
                        <ExportImportFlag>1</ExportImportFlag>
                     </SenderInformation>
                     <MessageNumber>" . $data['assoc_id'] . "</MessageNumber>
                     <MessageReferences ltypes:AddressType='FF'>
                        <Code>INN</Code>
                        <Value>" . $data['ref_value_kn_office'] . "</Value>
                     </MessageReferences>
                  </lmlv:MessageLevel>
                  <lsts:StatusInformation ltypes:StatusCode='" . $data['status_code'] . "'>
                    <StatusDate>" . $data['current_date'] . "</StatusDate>
                    <StatusTime>" . $data['current_time'] . "</StatusTime>
                    <StatusLocation ltypes:LocationIssuer='ZZZ'>" . $data['city'] . "</StatusLocation>
                    <ExceptionCode>" . $data['exception_code'] . "</ExceptionCode>
                    <AdditionalStatusInformation>
                        <CreationIdentifier>X</CreationIdentifier>
                        <StatusEntryDateTime>" . $data['current_date_time'] . "</StatusEntryDateTime>
                        <UserIdentifier>9210ec43-4f33-4f6f-8afa-2db7e974044c</UserIdentifier> 
                        <Remarks>" . $data['remark'] . "</Remarks>
                    </AdditionalStatusInformation>
                    <AdditionalRoadStatusInformation>
                        <ContactName>" . $data['pod_signee'] . "</ContactName>
                        <DeviceId>" . $data['device_id'] . "</DeviceId>
                        <User></User>
                        <SignatureType>SignaturePapier</SignatureType>
                        <DocumentId>" . $data['document_id'] . "</DocumentId>
                        <PhotoId>" . $data['picture_id'] . "</PhotoId>
                    </AdditionalRoadStatusInformation>
                  </lsts:StatusInformation>
                  <Shipment>
                    <lref:ReferencesDetails ltypes:AddressType='FF'>
                       <Code>TTY</Code>
                       <Value>DLV</Value>
                    </lref:ReferencesDetails>
                  </Shipment>
                  </Message>
            </roadstatus:RoadStatus>";
        return $request_xml;
    }

    private static function delivery_refused($data) {
        $request_xml = "<?xml version='1.0' encoding='UTF-8'?>
            <roadstatus:RoadStatus xmlns:roadstatus='http://knie4.int.kn/msg/roadstatus/0100' xmlns:DateUtil='com.surikat.mobility.common.util.DateUtil' xmlns:date='http://exslt.org/dates-and-times' xmlns:ext='http://exslt.org/common' xmlns:lhdr='http://knie4.int.kn/com/lhdr/0200' xmlns:lmlv='http://knie4.int.kn/com/lmlv/0200' xmlns:lpaci='http://knie4.int.kn/com/lpaci/0200' xmlns:lrcc='http://knie4.int.kn/msg/roadcarriercost/0100' xmlns:lref='http://knie4.int.kn/com/lref/0100' xmlns:lsts='http://knie4.int.kn/com/lsts/0200' xmlns:ltru='http://knie4.int.kn/com/ltru/0200' xmlns:ltypes='http://knie4.int.kn/com/ltypes/0200'>
               <lhdr:MessageHeader>
                  <ReceiverDetails ltypes:AddressType='FW'>
                     <PhysicalReceiver>" . $data['physicalsender'] . "</PhysicalReceiver>
                     <LogicalReceiver>" . $data['logicalsender'] . "</LogicalReceiver>
                  </ReceiverDetails>
                  <PhysicalSender>" . $data['physicalreceiver'] . "</PhysicalSender>
                  <LogicalSender>" . $data['logicalreceiver'] . "</LogicalSender>
                  <SendingApplication>SVKONEKT</SendingApplication>
                  <MessageType>RoadStatus</MessageType>
                  <VersionNumber>0100</VersionNumber>
                  <CreationDateTime>" . $data['current_date_time'] . "</CreationDateTime>
               </lhdr:MessageHeader>
               <Message>
                  <lmlv:MessageLevel>
                     <TrackingNumber>" . $data['order_id'] . "</TrackingNumber>
                     <SenderInformation>
                        <CompanyCode>KNFR</CompanyCode>
                        <BranchCode>" . $data['logicalsender'] . "</BranchCode>
                        <ModeOfTransport>1</ModeOfTransport>
                        <ExportImportFlag>1</ExportImportFlag>
                     </SenderInformation>
                     <MessageNumber>" . $data['assoc_id'] . "</MessageNumber>
                     <MessageReferences ltypes:AddressType='FF'>
                        <Code>INN</Code>
                        <Value>" . $data['ref_value_kn_office'] . "</Value>
                     </MessageReferences>
                  </lmlv:MessageLevel>
                  <lsts:StatusInformation ltypes:StatusCode='" . $data['status_code'] . "'>
                    <StatusDate>" . $data['current_date'] . "</StatusDate>
                    <StatusTime>" . $data['current_time'] . "</StatusTime>
                    <StatusLocation ltypes:LocationIssuer='ZZZ'>" . $data['city'] . "</StatusLocation>
                    <ExceptionCode>" . $data['exception_code'] . "</ExceptionCode>
                    <AdditionalStatusInformation>
                        <CreationIdentifier>X</CreationIdentifier>
                        <StatusEntryDateTime>" . $data['current_date_time'] . "</StatusEntryDateTime>
                        <UserIdentifier>9210ec43-4f33-4f6f-8afa-2db7e974044c</UserIdentifier> 
                        <Remarks>" . $data['remark'] . "</Remarks>
                    </AdditionalStatusInformation>
                    <AdditionalRoadStatusInformation>
                        <ContactName>" . $data['pod_signee'] . "</ContactName>
                        <DeviceId>" . $data['device_id'] . "</DeviceId>
                        <User></User>
                        <SignatureType>SignaturePapier</SignatureType>
                        <DocumentId>" . $data['document_id'] . "</DocumentId>  
                        <PhotoId>" . $data['picture_id'] . "</PhotoId>
                    </AdditionalRoadStatusInformation>
                  </lsts:StatusInformation>
                  <Shipment>
                    <lref:ReferencesDetails ltypes:AddressType='FF'>
                       <Code>TTY</Code>
                       <Value>DLV</Value>
                    </lref:ReferencesDetails>
                  </Shipment>
                  </Message>
            </roadstatus:RoadStatus>";
        return $request_xml;
    }

    private static function delivery_gate_out($data) {
        $request_xml = "<?xml version='1.0' encoding='UTF-8'?>
            <roadstatus:RoadStatus xmlns:roadstatus='http://knie4.int.kn/msg/roadstatus/0100' xmlns:DateUtil='com.surikat.mobility.common.util.DateUtil' xmlns:date='http://exslt.org/dates-and-times' xmlns:ext='http://exslt.org/common' xmlns:lhdr='http://knie4.int.kn/com/lhdr/0200' xmlns:lmlv='http://knie4.int.kn/com/lmlv/0200' xmlns:lpaci='http://knie4.int.kn/com/lpaci/0200' xmlns:lrcc='http://knie4.int.kn/msg/roadcarriercost/0100' xmlns:lref='http://knie4.int.kn/com/lref/0100' xmlns:lsts='http://knie4.int.kn/com/lsts/0200' xmlns:ltru='http://knie4.int.kn/com/ltru/0200' xmlns:ltypes='http://knie4.int.kn/com/ltypes/0200'>
               <lhdr:MessageHeader>
                  <ReceiverDetails ltypes:AddressType='FW'>
                     <PhysicalReceiver>" . $data['physicalsender'] . "</PhysicalReceiver>
                     <LogicalReceiver>" . $data['logicalsender'] . "</LogicalReceiver>
                  </ReceiverDetails>
                  <PhysicalSender>" . $data['physicalreceiver'] . "</PhysicalSender>
                  <LogicalSender>" . $data['logicalreceiver'] . "</LogicalSender>
                  <SendingApplication>SVKONEKT</SendingApplication>
                  <MessageType>RoadStatus</MessageType>
                  <VersionNumber>0100</VersionNumber>
                  <CreationDateTime>" . $data['current_date_time'] . "</CreationDateTime>
               </lhdr:MessageHeader>
               <Message>
                  <lmlv:MessageLevel>
                     <TrackingNumber>" . $data['order_id'] . "</TrackingNumber>
                     <SenderInformation>
                        <CompanyCode>KNFR</CompanyCode>
                        <BranchCode>" . $data['logicalsender'] . "</BranchCode>
                        <ModeOfTransport>1</ModeOfTransport>
                        <ExportImportFlag>1</ExportImportFlag>
                     </SenderInformation>
                     <MessageNumber>" . $data['assoc_id'] . "</MessageNumber>
                     <MessageReferences ltypes:AddressType='FF'>
                        <Code>INN</Code>
                        <Value>" . $data['ref_value_kn_office'] . "</Value>
                     </MessageReferences>
                  </lmlv:MessageLevel>
                  <lsts:StatusInformation ltypes:StatusCode='" . $data['status_code'] . "'>
                    <StatusDate>" . $data['current_date'] . "</StatusDate>
                    <StatusTime>" . $data['current_time'] . "</StatusTime>
                    <StatusLocation ltypes:LocationIssuer='ZZZ'>" . $data['city'] . "</StatusLocation> 
                    <AdditionalStatusInformation>
                        <CreationIdentifier>X</CreationIdentifier>
                        <StatusEntryDateTime>" . $data['current_date_time'] . "</StatusEntryDateTime>
                        <UserIdentifier>9210ec43-4f33-4f6f-8afa-2db7e974044c</UserIdentifier> 
                    </AdditionalStatusInformation>
                    <AdditionalRoadStatusInformation>
                        <DeviceId>" . $data['device_id'] . "</DeviceId>
                        <User></User>
                    </AdditionalRoadStatusInformation>
                  </lsts:StatusInformation>
                  <Shipment>
                    <lref:ReferencesDetails ltypes:AddressType='FF'> 
                       <Code>TTY</Code>
                       <Value>DLV</Value>
                    </lref:ReferencesDetails> 
                  </Shipment>
                  </Message>
            </roadstatus:RoadStatus>";
        return $request_xml;
    }

    public function macadam_status_hanlder($data, $status_stage) {
        self::validateStatusData($data);
        $request_xml = '';
        switch ($status_stage) {
            case "PICKUP_GATE_IN":
                $request_xml = self::pickup_gate_in($data);
                break;
            case "PICKUP_OK":
                $request_xml = self::pickup_ok($data);
                break;
            case "PICKUP_NOT_DONE":
                $request_xml = self::pickup_not_done($data);
                break;
            case "PICKUP_GATE_OUT":
                $request_xml = self::pickup_gate_out($data);
                break;
            case "PICKUP_BROKEN":
                $request_xml = self::pickup_broken($data);
                break;
            case "DELIVERY_GATE_IN":
                $request_xml = self::delivery_gate_in($data);
                break;
            case "DELIVERY_SHORT":
                $request_xml = self::delivered_short($data);
                break;
            case "DELIVERED":
                $request_xml = self::delivered($data);
                break;
            case "DELIVERED_WITH_DAMAGE":
                $request_xml = self::delivered_with_damage($data);
                break;
            case "DELIVERY_NOT_DONE":
                $request_xml = self::delivery_not_done($data);
                break;
            case "DELIVERY_REFUSED":
                $request_xml = self::delivery_refused($data);
                break;
            case "DELIVERY_GATE_OUT":
                $request_xml = self::delivery_gate_out($data);
                break;
        } 
        if($request_xml ==''){
            self::throwException('Macadam Status xml is empty');
        }
        self::publishxml($request_xml, $data);
    }

    private static function publishxml($request, $data) {
        $response = "Fail";
        $ci = & get_instance();
        $ci->load->library('uuid');
        $ci->load->helper('log');
        $uuid = $ci->uuid->v4();
        $ssl_options = array(
            'verify_peer' => false,
            'verify_peer_name' => false
        );
        $headers = new Wire\AMQPTable(array(
            'uuid' => $uuid,
            'KNESB_Routing_SenderId' => KNESB_SENDERID,
            'KNESB_Routing_ReceiverId' => KNESB_Routing_ReceiverId,
            'KN_MS_PhysRecvID' => $data['physicalsender'],
            'KN_MS_LogRecvID' => $data['logicalreceiver'],
            'KN_MS_PhysSenderID' => $data['physicalreceiver']
        ));
        try {
            $headers->set('short', -1024, Wire\AMQPTable::T_INT_SHORT);
            $connection = new AMQPSSLConnection(SALOG_URL, 5671, SALOG_USRNAME, SALOG_PWD, SALOG_ESB, $ssl_options);
            $channel = $connection->channel();
            $Xmldata = new AMQPMessage($request, array('content_type' => 'Application/xml', 'delivery_mode' => AMQPMessage::DELIVERY_MODE_PERSISTENT));
            $Xmldata->set('application_headers', $headers);
            $channel->basic_publish($Xmldata, MACADAM_EROADSTATUS, null);
            $channel->close();
            $connection->close();
            $response = "Success";
        } catch (Exception $exc) {
            $response = "Exception Occur when Pushing xml to ESB:" . $exc->getMessage();
            log_error($response);
        } finally {
            log_debug('Macadam Status XMLs storing into EDI logs');
            $ci->load->library('Edi_logger');
            $ci->edi_logger->setEdi_type(2);
            $ci->edi_logger->setTransaction_id(time());
            $ci->edi_logger->setEdi_name('Macadam');
            $ci->edi_logger->setBounded_type(2);
            $ci->edi_logger->setEdi_format_type('XML');
            $ci->edi_logger->setStatus(($response == 'Success' ? 1 : 0));
            $ci->edi_logger->setObj_type_name('order-id');
            $ci->edi_logger->setTxn_obj_id($data['order_id']);
            $ci->edi_logger->setEdi_request($request);
            $ci->edi_logger->setEdi_response($response);
            $ci->edi_logger->setCompany_code($data['company_code']);
            $ci->edi_logger->setBranch_code($data['branch_code']);
            $ci->edi_logger->setUser_id($data['user_id']);
            $ci->edi_logger->saveToEdiLogs();
        }
    }
    
    private static function validateStatusData($data){
        switch (true) {
            case ! isset($data['physicalsender']):
                self::throwException('Physical sender is undefined');

            case ! isset($data['logicalsender']):
                self::throwException('Logical Sender is undefined');

            case ! isset($data['physicalreceiver']):
                self::throwException('Physical receiver is undefined');

            case ! isset($data['logicalreceiver']):
                self::throwException('Logical receiver is undefined');

            case ! isset($data['current_date_time']):
                self::throwException('Current date time is undefined');

            case ! isset($data['order_id']):
                self::throwException('Tracking number/Order ID is undefined');

            case ! isset($data['assoc_id']):
                self::throwException('Assoc ID/Voyage Number is undefined');
                
            case ! isset($data['ref_value_kn_office']):
                self::throwException('KN office reference is undefined');
                
            case ! isset($data['status_code']):
                self::throwException('Status code is undefined');
                
            case ! isset($data['device_id']):
                self::throwException('Status code is undefined');
        }
    }
    
    private static function throwException(string $message) :void
    {   
        $ci = & get_instance();
        $ci->load->helper('log');
        log_error($message, 2); 
        throw new \RuntimeException($message);
    }

    public function publishXMLHandler(string $request, array $data): void
    {
        self::publishxml($request, $data);
    }
}
