<?php

defined('BASEPATH') or exit('No direct script access allowed');

require_once './vendor/pear/http_request2/HTTP/Request2.php';

class Nicplace_l
{

  /**
   * Reference to CodeIgniter instance
   *
   * @var object
   */
  protected $ci;

  private $alarm_emails;
  // --------------------------------------------------------------------

  public function __Construct()
  {
    $this->ci = &get_instance();
    $this->ci->load->model('common');
    $this->alarm_emails = []; //["knktw.tobacco.overland@kuehne-nagel.com"]; @TODO add email for alerts now we are removed due to bulk emails triggering..
  }

  /**
   * get assets
   *
   * Get all assets visible for user form Nic-place
   *
   *
   * @return    array
   */
  public function get_assets(): array
  {
    $url = nicplace_host . '/assets';

    return $this->nicplace_curl(HTTP_Request2::METHOD_GET, $url);
  }

  /**
   * get alarms
   *
   * Get all alarma visible for user form Nic-place
   *
   *
   * @return    array
   */
  public function get_alarms(): array
  {
    $url = nicplace_host . '/alarms';

    return (array)$this->nicplace_curl(HTTP_Request2::METHOD_GET, $url);
  }

  public function get_asset_db($truckNumber = null): array
  {
    $where = ['status' => 1];
    if ($truckNumber) {
      $where['name'] = $truckNumber;
    }
    $res = $this->ci->common->gettblrowdata($where, '*', 'tb_nic_assets', 0, 0);

    return $res;
  }

  public function get_alarms_db($for_truck_trail): array
  {
    $where = ['status' => 1, $for_truck_trail => 1];
    $res   = $this->ci->common->gettbldata($where, '*', 'tb_nic_alarms', 0, 0);

    return $res;
  }

  public function get_all_alarms_db(): array
  {
    $where = ['status is not ' => null];
    $res   = $this->ci->common->gettbldata($where, '*, IF(status=1, "Active", "Inactive") as ActiveStatus, IF(for_trailer=1, "Yes", "-") as forTrailer, IF(for_truck=1, "Yes", "-") as forTruck', 'tb_nic_alarms', 0, 0);

    return $res;
  }

  public function get_pois($params = []): array
  {
    $url = nicplace_host . '/pois';
    if (! empty($params)) {
      $url .= '?' . http_build_query($params);
    }
    $res = $this->nicplace_curl(HTTP_Request2::METHOD_GET, $url, $params);

    return $res;
  }

  public function create_pois(array $input_post): array
  {
    $url = nicplace_host . '/pois';
    $res = ['id' => 0];
    if (isset($input_post['poi_customer_identifier'])) {
      $poi_ci = $input_post['poi_customer_identifier'];
      $res    = $this->ci->common->gettblrowdata(['customer_identifier' => $poi_ci], 'poi_id as id, customer_identifier', 'tb_nic_poi', 0, 0);
      $post = [
        "name"       => $input_post['poi_name'],
        "type"       => "CIRCLE_POI",
        "address"    => [
          "postalCode" => $input_post['poi_postal_code'],
          "city"       => $input_post['poi_city'],
          "country"    => $input_post['poi_country'],
          "street"     => $input_post['poi_street']
        ],
        "externalId" => $poi_ci,
        "geometry"   => [
          "type" => "POINT"
        ],
        "radius"     => 250
      ];
      if (empty($res) || is_null($res['id'])) {
        $nic_res = $this->nicplace_curl(HTTP_Request2::METHOD_POST, $url, $post, true);
        log_error( 'Error Message >>>>> create poi => ' . json_encode($nic_res, 128));

        if (isset($nic_res['http_status']) && $nic_res['http_status'] > 300) {
          $nic_poi_data = $this->get_pois(['externalId' => $poi_ci])[0];
            if (empty($nic_poi_data) || is_null($nic_poi_data)) {
                $nic_poi_data = $this->get_pois(['name' => $input_post['poi_name']])[0];
            }
            if (empty($nic_poi_data) || is_null($nic_poi_data)) {
                $post["name"] = $poi_ci . '-' . $input_post['poi_name'];
                $nic_res = $this->nicplace_curl(HTTP_Request2::METHOD_POST, $url, $post, true);
                if (isset($nic_res['http_status']) && $nic_res['http_status'] > 300) {
                    log_error('Error Message >>>>> create poi => ' . json_encode($nic_res, 128));
                } else {
                    $nic_poi_data = $nic_res['response_body'];
                }
            }
          log_error( 'Error Message >>>>>> poi data => ' . json_encode($nic_poi_data, 128));
          $ins_poi = [
            "poi_id"              => $nic_poi_data['id']??null,
            "poi_name"            => $input_post['poi_name'],
            "poi_address"         => implode(', ', $post['address']),
            "poi_request"         => json_encode($post),
            "poi_response"        => json_encode($nic_poi_data),
            "ip_address"          => $this->ci->input->ip_address(),
            "trip_id"             => $input_post['order_id'],
            "customer_identifier" => $poi_ci,
          ];
          if (! empty($nic_poi_data) && isset($res['customer_identifier'])) {
            $this->ci->common->updatetbledata('tb_nic_poi', $ins_poi, ['customer_identifier' => $poi_ci]);
          } else {
            $this->ci->common->insertTableData('tb_nic_poi', $ins_poi);
          }
          $res = $nic_poi_data;
        } else {
          $res     = $nic_res['response_body'];
          $ins_poi = [
            "poi_id"              => $res['id']??null,
            "poi_name"            => $input_post['poi_name'],
            "poi_address"         => implode(', ', $post['address']),
            "poi_request"         => json_encode($post),
            "poi_response"        => json_encode($res),
            "ip_address"          => $this->ci->input->ip_address(),
            "trip_id"             => $input_post['order_id'],
            "customer_identifier" => $poi_ci,
          ];
          $this->ci->common->insertTableData('tb_nic_poi', $ins_poi);
        }
      }
    }

    return array_key_exists('id', $res) ? ["poi_id" => $res['id']] : ["error" => "error occurred check logs", "error_description" => $res];
  }

  public function create_tour(array $input_post, string $nicplace_ref_id = null): array
  {
    $url = nicplace_host . '/tours';
    $this->ci->load->library("Edi_logger");

    $start_poi_data = $this->create_pois($input_post['START_POI']);
    $end_poi_data = $this->create_pois($input_post['END_POI']);
    $tour_data = $input_post['TOUR_DATA'];
    $tour_data['START_POI'] = $start_poi_data['poi_id']??0;
    $tour_data['END_POI'] = $end_poi_data['poi_id']??0;
    $post = [
      "name"           => $tour_data['tour_name'],
      "externalId"     => $tour_data['order_id'].'_'.strtoupper($tour_data['request_for']),
      "asset"          => [
        "type" => "KNOWN",
        "id"   => $tour_data['asset_id']
      ],
      "sharings"       => [],
      "startCondition" => [
        "type"       => "START_POI",
        "poiId"      => $tour_data['START_POI'],
        "event"      => "STANDING_IN",
        "plannedAt"  => $tour_data['pickup_late_datetime'],
        "earliestAt" => $tour_data['pickup_early_datetime']
      ],
      "intermediates"  => [],
      "endCondition"   => [
        "type"               => "END_POI",
        "poiId"              => $tour_data['END_POI'],
        "event"              => "DRIVE_IN",
        "scheduledArrivalAt" => $tour_data['delivery_early_datetime']
      ],
    ];
    $intermediate_stop = $this->ci->nicplacemodel->getIntermediateCheck($tour_data['carrier_code']);

    if($intermediate_stop) {
      $intermediate_stop_poi_data = $intermediate_stop[$tour_data['carrier_code']];
      $intermediate_stop_poi_data['order_id'] = 'CPOI_' . $tour_data['order_id'];
      $intermediate_stop_poi = $this->create_pois($intermediate_stop_poi_data);

      $post["intermediates"] = [
        [
          "poiId"              => $intermediate_stop_poi['poi_id'] ?? 0,
          "isAlternativeStart" => false,
          "isAlternativeEnd"   => false,
          "serviceTime"        => 30,
          "scheduledArrivalAt" => $tour_data['pickup_early_datetime']
        ]
      ];
    }
    if (! empty($tour_data['ALARMS'])) {
      $post["alarms"] = [
        "ids"           => $tour_data['ALARMS'],
        "notifications" => [
          [
            "mediaType"  => "MAIL",
            "recipients" => $this->alarm_emails //@TODO need to enable email ids
          ],
        ]
      ];
    }
//    log_error( "Nicplace input array " . json_encode($post, 128));
    $HTTP_REQ_METHOD = HTTP_Request2::METHOD_POST;
    if ($nicplace_ref_id) {
      $HTTP_REQ_METHOD = HTTP_Request2::METHOD_PUT;
      $url             .= '/' . $nicplace_ref_id;
    }
    $complete_response = $this->nicplace_curl($HTTP_REQ_METHOD, $url, $post, true);
    log_error( 'Error Message create tour API response' . json_encode($complete_response, 128));
    $res = $complete_response['response_body'];
    $res['http_status'] = $complete_response['http_status'];
    if ($res['id']) {
      sleep(30);
      $error_msg = $start_tour_res['error'] ?? 'Something went wrong';
      $start_tour_res = $this->tourAction($res['id']); //start tour
      $start_tour_flag = $start_tour_res['http_status'] < 300 ? "<span class=\"text-primary\">RUNNING</span>" : "<span class=\"text-danger\">Transmission Failed <i class=\"fa fa-question-circle nicplace-error cursor-pointer \" title=\"" . $error_msg . "\"></i></span>";
      $res['TOUR_ACTION'] = $start_tour_res['http_status'] < 300 ? 'RUNNING': 'WAITING';
    }
    if (array_key_exists('id', $res)) {
      $return = [
        "status"     => 1,
        "start_tour" => $start_tour_flag,
        "order_id"   => $post['externalId'],
        "tour_id"    => $res['id'],
        "message"    => "<span class=\"text-success\">Transmission to NicPlace successful</span>"
      ];
    } else {
      $errors = $res['invalidFields'] ?? $res['error'];
      if (is_array($errors)) {
        $error_message = '';
        foreach ($errors as $e) {
          $error_message .= $e['field'] . ' - ' . $e['message'];
        }
      } else {
        $error_message = $errors;
      }
      $return = [
        "status"            => 0,
        "start_tour"        => 0,
        "order_id"          => $post['externalId'],
        "tour_id"           => null,
        "message"           => "<span class=\"text-danger\">Transmission Failed <i class=\"fa fa-question-circle nicplace-error cursor-pointer \" title=\"".$error_message."\"></i></span>",
        "error"             => "error occurred check logs",
        "error_description" => $res
      ];
    }

    $this->insertNicplaceOrderDB($tour_data, $post, $res, $nicplace_ref_id);
    return $return;
  }

  private function insertNicplaceOrderDB($tour_data, $post, $res, $nicplace_ref_id, $start_tour_flag = 0)
  {
    $HTTP_REQ_METHOD = HTTP_Request2::METHOD_POST;
    $ref_action_type = 'insertTableData';
    if ($nicplace_ref_id) {
      $ref_action_type = 'updatetbledata';
      $HTTP_REQ_METHOD = HTTP_Request2::METHOD_PUT;
    } elseif ($start_tour_flag) {
      $HTTP_REQ_METHOD = 'PATCH';
    }

    $order_info        = $this->ci->common->gettblrowdata(["order_id" => $tour_data['order_id']], "id, user_id, company_code, branch_code", "tb_orders", 0, 0);
    $this->ci->load->helper('string');
    $request_unique_id = random_string('numeric',9);
    $tour_status_creation_tour = $res['http_status'] < 300 ? $res['status'] ?? 'WAITING' : null;
    $tour_status = $res['TOUR_ACTION'] ?? $tour_status_creation_tour;
    $ins_tour = [
      "trip_id"             => $tour_data['order_id'],
      "user_id"             => $order_info['user_id'] ?? 0,
      "company_code"        => $order_info['company_code'] ?? 'NULL',
      "branch_code"         => $order_info['branch_code'] ?? 'NULL',
      "asset_id"            => $tour_data['asset_id'],
      "pickup_poi_id"       => $tour_data['START_POI'],
      "delivery_poi_id"     => $tour_data['END_POI'],
      "tour_id"             => $res['id'] ?? null,
      "tour_name"           => $tour_data['tour_name'],
      "tour_request"        => json_encode($post),
      "tour_response"       => json_encode($res),
      "http_status"         => $res['http_status'] ?? 401,
      "http_request_method" => $HTTP_REQ_METHOD,
      "request_for"         => $tour_data['request_for'] ?? 'truck', //truck or trailer
      "request_unique_id"   => $request_unique_id,
      "tour_status"         => $tour_status,
      "ip_address"          => $this->ci->input->ip_address(),
    ];
    $ins_tour_id       = $this->ci->common->insertTableData('tb_nic_tour', $ins_tour);
    if(!$start_tour_flag) {
      $ref_input_data = ['nic_ord_id' => $order_info['id'], 'request_for' => $tour_data['request_for'], 'tour_id' => $res['id']];
      $this->refOrderTours($ref_input_data, $ref_action_type, $tour_data['ref_pk_id']);
    }
    log_error( ' $ins_tour_id >>> ' . $ins_tour_id);
    $status = $ins_tour["http_status"] < 300 ? 1 : 0;
    $this->ci->edi_logger->log_nicplace_transport_order($status, json_encode($post, JSON_UNESCAPED_UNICODE), json_encode($res, JSON_UNESCAPED_UNICODE), $tour_data['order_id'], $request_unique_id);

  }

  public function refOrderTours(array $inputPost, string $ref_action_type = 'insertTableData', $ref_pk_id = null)
  {
    $orderRefData = [
      'order_id'       => $inputPost['nic_ord_id'],
      'reference_id'   => 'ORD_NICPLACE_TOUR_ID',
      'ref_value'      => $inputPost['tour_id'] ?? 0,
      'status'         => 1,
      'ref_belongs_to' => $inputPost['request_for'],
    ];
    if ($ref_pk_id) {
      $ref_action_type_whr = ['id' => $ref_pk_id, 'order_id' => $inputPost['nic_ord_id'], 'status' => 1];
      $orderRefData['updatedon'] = date('Y-m-d H:i:s');
      $ref_action_type = 'updatetbledata';
    } else {
      $orderRefData['createdon'] = date('Y-m-d H:i:s');
      $orderRefData['updatedon'] = date('Y-m-d H:i:s');
      $ref_action_type_whr = '';
    }
    $this->ci->common->$ref_action_type('tb_order_references', $orderRefData, $ref_action_type_whr);
  }

  public function update_tour(array $input_post, string $nicplace_ref_id = null): array
  {
    return $this->create_tour($input_post, $nicplace_ref_id); // if create tour has nic-place ref id it goes to update tour
  }

  public function checkTourByOrderId($params, $checkFlag = false)
  {
    if (!empty($params)) {
      $url = nicplace_host . '/tours';
      $url .= '?' . http_build_query($params);

      $res = $this->nicplace_curl(HTTP_Request2::METHOD_GET, $url, $params);
      if ($checkFlag && !empty($res)) {
          $res = ['tour_id' => $res[0]['id']];
      }
      return $res;
    } else {
      return ['status' => 0, 'message' => 'provide order id'];
    }
  }

  public function deleteTour($nicplaceId)
  {
    if (!empty($nicplaceId)) {
      $url = nicplace_host . '/tours';
      $url .= '/'.$nicplaceId;

      $res = $this->nicplace_curl(HTTP_Request2::METHOD_DELETE, $url, []);
      return $res;
    } else {
      return ['status' => 0, 'message' => 'provide order id'];
    }
  }

  public function tourAction($nicplaceId, $action = 'start' )
  {
    if (!empty($nicplaceId)) {
      $url = nicplace_host . 'tours';
      $url .= '/' . $nicplaceId . '/' . $action;

      $res = $this->nicplace_curl('PATCH', $url, [], true);
      return $res;
    } else {
      return ['status' => 0, 'message' => 'provide order id'];
    }
  }
  
  public function create_tour_test()
  {
    $url  = nicplace_host . '/tours';
    $post = [
      "name"           => "Test3", // Tour name
      "externalId"     => "Own identifiers 123",
      "asset"          => ["type" => "KNOWN", "id" => "823542"],
      "sharings"       => [],
      "startCondition" =>
        [
          "type"       => "START_POI",
          "poiId"      => "496878",
          "event"      => "DRIVE_OUT",
          "plannedAt"  => "2019-10-06T15:40:00Z",
          "earliestAt" => "2019-10-06T15:10:00Z"
        ],
      "intermediates"  => [],
      "endCondition"   =>
        [
          "type"               => "END_POI",
          "poiId"              => "496935",
          "event"              => "DRIVE_IN",
          "scheduledArrivalAt" => "2019-10-07T17:40:00Z"
        ]
    ];

    return $this->nicplace_curl(HTTP_Request2::METHOD_POST, $url, $post);
  }

  public function get_tour(string $id): array
  {
    $url = nicplace_host . '/tours/' . $id;

    return $this->nicplace_curl(HTTP_Request2::METHOD_GET, $url);
  }

  public function nicplace_curl($method, $url, $post = [], $http_status = false): array
  {
    return nicplace_request_curl($method, $url, $post, $http_status);
  }
}
