<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Notifytrigger {

    public function __construct(){
        $ci =& get_instance();
        $ci->load->model(['common','notifymodel','Roadlogtosalogmodel']);
        $ci->load->library(['parser', 'PhpMailerLibrary']);
    }

    public function sendordernotify(array $data): void
    {
        $ci =& get_instance();
        $orderInfo = $ci->common->gettblrowdata(['id' => $data['order_id']], 'order_id,company_code,branch_code,vendor_id,customer_id,user_id,product,pickup_country,delivery_country', 'tb_orders', 0, 0);
        $orderDetails = $ci->common->gettblrowdata(['order_row_id' => $data['order_id']], 'service,order_type,incoterm inco_term,department_code', 'tb_order_details', 0, 0);
        $orderDetails['from_country'] = $orderInfo['pickup_country'];
        $orderDetails['to_country'] = $orderInfo['delivery_country'];
        $orderDetails['company_code'] = $orderInfo['company_code'];
        $orderDetails['branch_code'] = $orderInfo['branch_code'];
        $orderDetails['customer_id'] = $orderInfo['customer_id'];
        $orderDetails['product'] = $orderInfo['product'];
        $notificationId = $this->pickNotifyConfigure($orderDetails);
        if (!empty($orderInfo) && $notificationId != null) {
            $involvedParties = $ci->notifymodel->orderinvolvedparties($data['order_id']);
            $getCustomerDetails = $getCarrierDetails = 1;
            foreach ($involvedParties as $eachInvolvedParty) {
                $partyType = strtoupper($eachInvolvedParty['party_type']);
                if ($partyType == "CUSTOMER") {
                    $getCustomerDetails = 0;
                } elseif ($partyType == "CARRIER") {
                    $getCarrierDetails = 0;
                }
            }
            $adminInformantion = $ci->common->gettblrowdata(['id' => $orderInfo['user_id']], 'name username,mobile_no mobile,emailid', 'tb_users', 0, 0);
            if ($adminInformantion) {
                $adminInformantion['party_master_id'] = 0;
                $adminInformantion['party_type'] = 'Admin';
                $involvedParties[] = $adminInformantion;
                $userLogins = $ci->common->gettbldata(['user_id' => $orderInfo['user_id'], 'status' => 1], 'name username,mobile_no mobile,emailid', 'tb_user_logins', 0, 0);
                foreach ($userLogins as $eachUserLogin) {
                    $eachUserLogin['party_master_id'] = 0;
                    $eachUserLogin['party_type'] = 'Admin';
                    $involvedParties[] = $eachUserLogin;
                }
            }
            $action = $data['action'];
            if ($getCustomerDetails > 0) {
                if ($orderInfo['customer_id'] != 0) {
                    $getCustomerinfo = $ci->common->gettblrowdata(['id' => $orderInfo['customer_id']], 'name,phone,email_id', 'tb_customers', 0, 0);
                    if ($getCustomerinfo) {
                        $customer = ['party_master_id' => 0, 'username' => $getCustomerinfo['name'], 'emailid' => $getCustomerinfo['email_id'], 'mobile' => $getCustomerinfo['phone'], 'party_type' => 'Customer'];
                        $involvedParties[] = $customer;
                    }
                }
            }
            if ($action != 'booking_create' && $action != 'booking_edit' && $action != 'booking_delete') {
                if ($getCarrierDetails > 0) {
                    if ($orderInfo['vendor_id'] != 0) {
                        $getCarrierInfo = $ci->common->gettblrowdata(['id' => $orderInfo['vendor_id']], 'name,mobile,email', 'tb_vendors', 0, 0);
                        if ($getCarrierInfo) {
                            $carrier = ['party_master_id' => 0, 'username' => $getCarrierInfo['name'], 'emailid' => $getCarrierInfo['email'], 'mobile' => $getCarrierInfo['mobile'], 'party_type' => 'Carrier'];
                            $involvedParties[] = $carrier;
                        }
                    }
                }
            }
            if (!empty($involvedParties)) {
                $sendMailIds = [];
                $where['notification_id'] = $notificationId;
                foreach ($involvedParties as $eachParty) {
                    $where['party_type'] = $eachParty['party_type'];
                    $notifyData = $ci->notifymodel->getNotifyTrigger($where);
                    if (!empty($notifyData)) {
                        $eachParty['order_id'] = $orderInfo['order_id'];
                        if ($notifyData[$data['action']] == 1) {
                            if ($notifyData['email_note'] == 1) {
                                $eachParty['subject'] = $data['subject'] ?? "Notification Trigger";
                                $eachParty = array_merge($eachParty, $data);
                                $eachParty['body'] = $ci->parser->parse_string($eachParty['body'], ['username' => $eachParty['username']], true);
                                if ($eachParty['emailid'] != '') {
                                    if (!in_array($eachParty['emailid'], $sendMailIds)) {
                                        $this->sendstatusmail($eachParty);
                                        $sendMailIds[] = $eachParty['emailid'];
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public function sendtripnotify(array $data): void
    {
        $ci =& get_instance();
        $tripInfo = $ci->common->gettblrowdata(['id' => $data['shift_id']], 'vendor_id,company_code,branch_code,user_id', 'tb_shifts', 0, 0);
        if (!empty($tripInfo)) {
            $involvedParties = [];
            $orderInfo = $ci->common->gettblrowdata(['id' => $data['order_id']], 'id,order_id,company_code,branch_code,vendor_id,customer_id,user_id,product,pickup_country,delivery_country', 'tb_orders', 0, 0);
            if (!empty($orderInfo)) {
                $involvedParties = $ci->notifymodel->orderinvolvedparties($orderInfo['id']);
                $getCustomerDetails = $getCarrierDetails = 1;
                foreach ($involvedParties as $eachInvolvedParty) {
                    $partyType = strtoupper($eachInvolvedParty['party_type'] ?? "");
                    if ($partyType == "CUSTOMER") {
                        $getCustomerDetails = 0;
                    } elseif ($partyType == "CARRIER") {
                        $getCarrierDetails = 0;
                    }
                }
                if ($getCarrierDetails > 0) {
                    $carrierInfo = $ci->common->gettblrowdata(['id' => $tripInfo['vendor_id']], 'name username,mobile,email as emailid', 'tb_vendors', 0, 0);
                    if ($carrierInfo) {
                        $carrierInfo['party_master_id'] = 0;
                        $carrierInfo['party_type'] = 'Carrier';
                        $involvedParties[] = $carrierInfo;
                    }
                }
                $adminInfo = $ci->common->gettblrowdata(['id' => $tripInfo['user_id']], 'name username,mobile_no mobile,emailid', 'tb_users', 0, 0);
                if ($adminInfo) {
                    $adminInfo['party_master_id'] = 0;
                    $adminInfo['party_type'] = 'Admin';
                    $involvedParties[] = $adminInfo;
                    $userLogins = $ci->common->gettbldata(['user_id' => $tripInfo['user_id'], 'status' => 1], 'name username,mobile_no mobile,emailid', 'tb_user_logins', 0, 0);
                    foreach ($userLogins as $singleUser) {
                        $singleUser['party_master_id'] = 0;
                        $singleUser['party_type'] = 'Admin';
                        $involvedParties[] = $singleUser;
                    }
                }
                $orderDetails = $ci->common->gettblrowdata(['order_row_id' => $orderInfo['id']], 'service,order_type,incoterm inco_term,department_code', 'tb_order_details', 0, 0);
                $orderDetails['from_country'] = $orderInfo['pickup_country'];
                $orderDetails['to_country'] = $orderInfo['delivery_country'];
                $orderDetails['company_code'] = $orderInfo['company_code'];
                $orderDetails['branch_code'] = $orderInfo['branch_code'];
                $orderDetails['customer_id'] = $orderInfo['customer_id'];
                $orderDetails['product'] = $orderInfo['product'];
                $notificationID = $this->pickNotifyConfigure($orderDetails);
                if ($getCustomerDetails > 0) {
                    if ($orderInfo['customer_id'] != 0) {
                        $getCustomerInfo = $ci->common->gettblrowdata(['id' => $orderInfo['customer_id']], 'name,phone,email_id', 'tb_customers', 0, 0);
                        if ($getCustomerInfo) {
                            $customer = ['party_master_id' => 0, 'username' => $getCustomerInfo['name'], 'emailid' => $getCustomerInfo['email_id'], 'mobile' => $getCustomerInfo['phone'], 'party_type' => 'Customer'];
                            $involvedParties[] = $customer;
                        }
                    }
                }
            }
            if (!empty($involvedParties) && $notificationID) {
                $sendMailIds = [];
                $where['notification_id'] = $notificationID;
                foreach ($involvedParties as $party) {
                    $where['party_type'] = $party['party_type'];
                    $notifyData = $ci->notifymodel->getNotifyTrigger($where);
                    if (!empty($notifyData)) {
                        if ($notifyData[$data['action']] == 1) {
                            if ($notifyData['email_note'] == 1) {
                                $party['subject'] = $data['subject'] ?? "Notification Trigger";
                                $party = array_merge($party, $data);
                                $party['body'] = $ci->parser->parse_string($party['body'], ['username' => $party['username']], true);
                                if ($party['emailid'] != '') {
                                    if (!in_array($party['emailid'], $sendMailIds)) {
                                        $this->sendstatusmail($party);
                                        $sendMailIds[] = $party['emailid'];
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }


    public function sendstatusmail(array $data)
    {
        $ci =& get_instance();
        $ci->load->library('email');
        $ci->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');
        $ci->email->to($data['emailid'], $data['username']);
        if (isset($data['cc'])) {
            $ci->email->cc($data['cc']);
        }
        $ci->email->subject($data['subject']);
        $ci->email->set_mailtype("html");
        $ci->email->message($data['body']);
        if (isset($data['attachment']) && !empty($data['attachment'])) {
            $ci->email->attach($data['attachment']);
        }
        $ci->email->send();
        $ci->email->clear(true);
        return true;
    }

    public function sendstatussms($data){
        $ci =& get_instance();
        $ci->load->library('sms');
        $params=array();
        $params['user_id']= 3;
        $params['mobile']=$data["mobile"];
        $params['module']="Notification Trigger Module";
        $params['message']="Notification Message";
        $res = $ci->sms->send($params);
        echo "SMS res".$res;
        return true;
    }

    public function sendstatuswhatsapp($party){
        $ci =& get_instance();
        $ci->load->library('sms');
        $params=array();
        $params['user_id']= 3;
        $params['mobile']=$party["mobile"];
        $params['module']="Notification Trigger Module";
        $params['message']="Notification Message";
        $res = $ci->sms->send($params);
        return true;
    }

    public function getCountryNameAndCode(string $value): array
    {
        $country = [$value];
        $ci =& get_instance();
        if (!empty($value)) {
            $query = $ci->db->query("SELECT country_name,country_code FROM tbl_country_master WHERE country_name = ? OR country_code = ? AND status =?", [$value, $value, 1]);
            if ($query->num_rows() > 0) {
                $country = [$query->row()->country_name, $query->row()->country_code];
            }
        }
        return $country;
    }

    public function picknotifyconfigure($orderinfo)
    {
        $ci =& get_instance();
        $notificationID = null;
        $fromCountries = $this->getCountryNameAndCode($orderinfo['from_country']);
        $toCountries = $this->getCountryNameAndCode($orderinfo['to_country']);
        $zeroString = '0';
        $queryString = "SELECT company_code,branch_code,customer_id,order_type,product,service,inco_term,notification_id,department_code FROM tb_notify_management WHERE company_code = ? AND branch_code = ? AND customer_id = ? AND from_country IN ? AND to_country IN ? AND status =?";
        $queryParams = [$orderinfo['company_code'], $orderinfo['branch_code'], $orderinfo['customer_id'], $fromCountries, $toCountries, 1];
        $queryString .= " AND ( order_type = ? OR service = ? OR product = ? OR inco_term = ?  OR  department_code = ? ) GROUP BY notification_id ORDER BY `id` DESC";
        $queryParams[] = !empty($orderinfo['order_type']) ? $orderinfo['order_type'] : "";
        $queryParams[] = !empty($orderinfo['service']) ? $orderinfo['service'] : "";
        $orderinfo['product'] = preg_replace('/[^a-zA-Z0-9\s]/', '', $orderinfo['product']);
        $queryParams[] = !empty($orderinfo['product']) ? $orderinfo['product'] : "";
        $queryParams[] = !empty($orderinfo['inco_term']) ? $orderinfo['inco_term'] : "";
        $queryParams[] = !empty($orderinfo['department_code']) ? $orderinfo['department_code'] : "";
        $getDbResult = $ci->db->query($queryString, $queryParams);
        $data = $getDbResult->result_array();
        if (empty($data)) {
            $getDbResult = $ci->db->query(
                "SELECT company_code,branch_code,customer_id,order_type,product,service,inco_term,notification_id,department_code FROM tb_notify_management WHERE company_code = ? AND branch_code = ? AND customer_id = ? AND from_country IN ? AND to_country IN ? AND status =? AND order_type = '' AND service = '' AND product = '' AND inco_term = ''  AND  department_code = ''  GROUP BY notification_id ORDER BY `id` DESC",
                [$orderinfo['company_code'], $orderinfo['branch_code'], $orderinfo['customer_id'], $fromCountries, $toCountries, 1]
            );
            $data = $getDbResult->result_array();
            if (empty($data)) {
                $getDbResult = $ci->db->query("SELECT company_code,branch_code,customer_id,order_type,product,service,inco_term,notification_id,department_code FROM tb_notify_management WHERE company_code = ? AND branch_code = ? AND customer_id = ? AND from_country = ? AND to_country = ? AND status =? GROUP BY notification_id ORDER BY `id` DESC", [$orderinfo['company_code'], $orderinfo['branch_code'], $orderinfo['customer_id'], $zeroString, $zeroString, 1]);
                $data = $getDbResult->result_array();
                if (empty($data)) {
                    $getDbResult = $ci->db->query("SELECT company_code,branch_code,customer_id,order_type,product,service,inco_term,notification_id,department_code FROM tb_notify_management WHERE company_code = ? AND branch_code = ? AND customer_id = ? AND from_country IN ? AND to_country IN ? AND status =? GROUP BY notification_id ORDER BY `id` DESC", [$orderinfo['company_code'], $orderinfo['branch_code'], $zeroString, $fromCountries, $toCountries, 1]);
                    $data = $getDbResult->result_array();
                    if (empty($data)) {
                        $getDbResult = $ci->db->query(
                            "SELECT company_code,branch_code,customer_id,order_type,product,service,inco_term,notification_id,department_code FROM tb_notify_management WHERE company_code = ? AND branch_code = ? AND customer_id = ? AND from_country = ? AND to_country = ? AND order_type='' AND product='' AND service='' AND inco_term='' AND department_code='' AND status =? GROUP BY notification_id ORDER BY `id` DESC",
                            [$orderinfo['company_code'], $orderinfo['branch_code'], $zeroString, $zeroString, $zeroString, 1]
                        );
                        $data = $getDbResult->result_array();
                    }
                }
            }
        }
        unset($orderinfo['from_country']);
        unset($orderinfo['to_country']);
        ksort($orderinfo);
        $matchcnt = 0;
        foreach ($data as $eachLine) {
            $notifyid = $eachLine['notification_id'];
            unset($eachLine['notification_id']);
            ksort($eachLine);
            $intersect = array_intersect_uassoc($orderinfo, $eachLine, function ($a, $b) {
                return ($a == $b) ? 0 : 1;
            });
            $eachLine = array_filter($eachLine, function ($val) {
                return (!empty($val)) ? 1 : 0;
            });
            $intersect = array_filter($intersect, function ($val) {
                return (!empty($val)) ? 1 : 0;
            });
            if (count($intersect) > $matchcnt && count($eachLine) == count($intersect)) {
                $matchcnt = count($intersect);
                $notificationID = $notifyid;
            } elseif ($matchcnt == count($intersect) && array_key_exists('order_type', $intersect) && count($eachLine) == count($intersect)) {
                $matchcnt = count($intersect);
                $notificationID = $notifyid;
            } elseif ($matchcnt == count($intersect) && count($eachLine) == count($intersect)) {
                $matchcnt = count($intersect);
                $notificationID = $notifyid;
            }
        }
        return $notificationID;
    }

    public function sendNotificationToConsignee(int $orderRowId, string $statusCode): void
    {
        $ci =& get_instance();
        if ($orderRowId === 0) {
            return;
        }
        $consigneeDetails = $ci->notifymodel->getConsigneeDetailsByOrderId($orderRowId);
        if (empty($consigneeDetails)) {
            return;
        }
        $ccMails = [];
        $cdate = date('Y-m-d H:i:s');
        $statusName['0212'] = "Dispatched";
        $statusName['0500'] = "Picked";
        $statusName['2300'] = "Delivered";
        $subject = "Confirmation of Order  " . $statusName[$statusCode] . " - " . $consigneeDetails['bookingId'] . ", " . $consigneeDetails['deliveryNote'];
        $customerName = "Hi " . $consigneeDetails['customerName'] . ",<br>";
        $consigneeName = "Hi " . $consigneeDetails['name'] . ",<br>";
        $message = "This is to notify that your booking has been " . $statusName[$statusCode] . ".<br>";
        $message .= "Consignment Number: " . $consigneeDetails['bookingId'] . "<br>";
        $message .= "Reference: " . $consigneeDetails['deliveryNote'] . "<br><br>";
        $message .= "You can track your consignment via the following tracking link:<a href=" . base_url('tracking/orderTracking/' . $consigneeDetails['bookingId']) . ">" . base_url() . "tracking</a><br><br><br><br>";
        $message .= "Wishes,<br>";
        $message .= "KN Admin";
        $consigneeMail = $consigneeDetails['mailId'];
        if ($consigneeMail != "") {
            $mailIdsArray = explode(';', $consigneeMail);
            $toMail = "";
            for ($i = 0, $iMax = count($mailIdsArray); $i < $iMax; $i++) {
                $mailId = $mailIdsArray[$i] ?? "";
                if ($mailId === "") {
                    continue;
                }
                if ($i > 0) {
                    $ccMails[] = $mailId;
                } else {
                    $toMail = $mailId;
                }
            }
            $emailSentStatus = 0;
            if ($ci->phpmailerlibrary->sendmail($toMail, $subject, $consigneeName . $message, $ccMails, [])) {
                $emailSentStatus = 1;
                log_message("error", "NotifyTrigger-mailSendToConsignee - " . $consigneeDetails['bookingId']);
            } else {
                log_message("error", "NotifyTrigger-mailNotSendToConsignee - " . $consigneeDetails['bookingId']);
            }
            $ci->common->insertTableData("tb_email_log", ['module' => $consigneeDetails['companyCode'] . "_ConsigneeMail", 'customer_code' => $consigneeDetails['customerCid'], 'sent_to' => $consigneeMail, 'sent_from' => SVKONEKT_EMAIL, 'email_status' => $emailSentStatus, 'status' => '1', 'sent_on' => $cdate, 'message' => $consigneeName . $message, 'subject' => $subject]);
        }
        if (checkAccessConditions('SEND_CONSIGNEE_NOTIFICATION_TO_CUSTOMER', $consigneeDetails['companyCode'])) {
            if ($consigneeDetails['customerMail'] === "") {
                return;
            }
            $emailSentStatus = 0;
            if (checkAccessConditions('RELATED_2_SENDING_MAIL_TOKNIDS_FOR_MILESTONE', $consigneeDetails['customerCid'])) {
                $staticCCMailIds = ['m.sivakumar@kuehne-nagel.com', 'joel.padua@kuehne-nagel.com', 'florylie-joy.gumboc@kuehne-nagel.com', 'angelie.omes@kuehne-nagel.com'];
                if ($consigneeDetails['branchCode'] == "PHCEB") {
                    $staticCCMailIds = array_merge($staticCCMailIds, [
                        'yvonne.he@Kuehne-Nagel.com',
                        'angela.gimoros@kuehne-nagel.com',
                    ]);
                }
                $customerCCMails = array_merge($ccMails, $staticCCMailIds);
                $bccMails = ['sol.ignacio@kuehne-nagel.com'];
            }
            if ($ci->phpmailerlibrary->sendmail($consigneeDetails['customerMail'], $subject, $customerName . $message, $customerCCMails ?? $ccMails, $bccMails ?? [])) {
                $emailSentStatus = 1;
                log_message("error", "NotifyTrigger-mailSendToCustomer - " . $consigneeDetails['bookingId'].'
                Customer Mail -'.$consigneeDetails['customerMail'].' Customer Cid - '.$consigneeDetails['customerCid']);
            } else {
                log_message("error", "NotifyTrigger-mailNotSendToCustomer - " . $consigneeDetails['bookingId']);
            }
            $ci->common->insertTableData("tb_email_log", ['module' => $consigneeDetails['companyCode'] . "_CustomerMail", 'customer_code' => $consigneeDetails['customerCid'], 'sent_to' => $consigneeDetails['customerMail'], 'sent_from' => SVKONEKT_EMAIL, 'email_status' => $emailSentStatus, 'status' => '1', 'sent_on' => $cdate, 'message' => $customerName . $message, 'subject' => $subject]);
        }
    }

    public function sendNotificationToCarrier(int $shiftRowId,string $companyCode,string $functionCode = 'CR' ): void
    {
        if ((checkAccessConditions('SEND_TRIP_NOTIFICATION_TO_CARRIER', $companyCode)) == false) {
            return;
        }
        $ci =& get_instance();
        $getDataForCarrierNotification = $ci->notifymodel->getDataForCarrierNotification($shiftRowId);
        $toMailIds = $bccMailIDs = $ccMailID = [];
        if (!empty($getDataForCarrierNotification) && ($getDataForCarrierNotification['carrier_mail'] ?? '') != '') {
            $carrierCodeAndEmail = explode('?????', $getDataForCarrierNotification['carrier_mail']);
            $carrierCode = $carrierCodeAndEmail[0];
            $carrierEmailId = $carrierCodeAndEmail[1];
            $salogTrackingNos = $getDataForCarrierNotification['salog_tracking_nos'];
            $bookingIds = $getDataForCarrierNotification['booking_ids'];
            $branchCode = $getDataForCarrierNotification['branch_code'];
            if ($branchCode == 'CNSZX') {
                $toMailIds = ['kncn_szx_overland@kuehne-nagel.com'];
                $ccMailID = [$carrierEmailId];
            } elseif ($branchCode == 'CNBJS') {
                $toMailIds = ['kncn_ncn_overland@kuehne-nagel.com'];
                $ccMailID = [$carrierEmailId];
            } elseif ($branchCode == 'TWTPE') {
                $toMailIds = ['kntw_tpe_overland@kuehne-nagel.com'];
                $ccMailID = [$carrierEmailId];
            } elseif ($branchCode == "PHCEB") {
                $toMailIds = [$carrierEmailId];
                $ccMailID = ['angelie.omes@kuehne-nagel.com', 'florylie-joy.gumboc@kuehne-nagel.com', 'm.sivakumar@kuehne-nagel.com', 'joel.padua@kuehne-nagel.com', 'yvonne.he@Kuehne-Nagel.com', 'angela.gimoros@kuehne-nagel.com'];
                $bccMailIDs = ['sol.ignacio@kuehne-nagel.com'];
            } elseif ($branchCode == "PHMNL") {
                $toMailIds = [$carrierEmailId];
                $ccMailID = ['angelie.omes@kuehne-nagel.com', 'florylie-joy.gumboc@kuehne-nagel.com', 'm.sivakumar@kuehne-nagel.com', 'joel.padua@kuehne-nagel.com'];
                $bccMailIDs = ['sol.ignacio@kuehne-nagel.com'];
            } else {
                $toMailIds = [$carrierEmailId];
            }
            $message = "Hi, <br><br>";
            if($functionCode == 'CR'){
                $subject  = 'New Trip created and assigned, ';
                $message .= "Trip has been created and assigned to you.<br>";
            } else {
                $subject = 'Trip cancelled, ';
                $message .= "Trip has been cancelled.<br>";
            }
            $subject .= 'SALOG tracking number '.$salogTrackingNos;
            if ($companyCode == "PHKN") {
                $subject .= ' or non-SALOG '.$bookingIds;
            }
            $message .= "Svkonekt Booking ID : " . $bookingIds . "<br>";
            $message .= "SALOG Tracking No : " . ($salogTrackingNos ?? '') . "<br><br>";
            $message .= "Best Regards,<br>";
            $message .= "Svkonekt Team";
            try {
                if ($ci->phpmailerlibrary->sendMultipleToMail($toMailIds, $subject, $message, $ccMailID, [], $bccMailIDs)) {
                    log_message("error", "carrier trip notification email sucess ".$subject." to - ".json_encode($toMailIds)." cc - ".json_encode($ccMailID)." bcc - ".json_encode($bccMailIDs));
                } else {
                    log_message("error", "carrier trip notification email failed ".$subject." to - ".json_encode($toMailIds)." cc - ".json_encode($ccMailID)." bcc - ".json_encode($bccMailIDs));
                }
            } catch (Exception $e) {
                log_message("error", "carrier trip notification email failed - " . $e->getMessage());
            }
        }
    }

    public function orderStatusNotification(string $bookingId, string $statusCode, string $dateTime): void
    {
        $ci =& get_instance();
        $statusCodeAndName = [
            '0200' => 'Empty Gate Out',
            '0220' => 'Empty Placed at Supplier',
            '0500' => 'Picked',
            '3000' => 'Delivered'
        ];
        if (!isset($statusCodeAndName[$statusCode])) {
            return;
        }
        $data = $ci->notifymodel->getOrderDataForStatusNotification($bookingId);
        if ((($data['code'] ?? '') != '1000099184') || empty($data)) {
            return;
        }
        if ($data['customer_id'] > 0) {
            $customerGroupEmailIds = $ci->Roadlogtosalogmodel->getCustomerGroupEmailIds($data['customer_id']);
        }
        $toMailIds = [$data['salog_creator_email']];
        $ccMailIds = [$data['carrier_mail']];
        $subject = ($data['salog_tracking_no'] ?? '') . " Order  " . $bookingId . "(" . $data['name'] . ") " . ($statusCodeAndName[$statusCode] ?? '');
        $message = "Hi, <br><br>";
        $message .= "Booking status<br>";
        $message .= "Tracking No : " . ($data['salog_tracking_no'] ?? '') . "<br>";
        $message .= "Svkonekt Booking ID : " . $bookingId . "<br><br>";
        $message .= ($statusCodeAndName[$statusCode] ?? '') . " : " . date("d-M-Y h:i A", strtotime($dateTime)) . "<br><br>";
        $message .= "You can track your consignment via the following tracking link https://elog360.app/svkonekt_test/tracking <br><br>";
        $message .= "Best Regards,<br>";
        $message .= "Svkonekt Team";
        $ccMailIds = array_merge(($customerGroupEmailIds ?? []), $ccMailIds);
        log_message("error", "SALOG status notification email success " . $subject .$message. " to - " . json_encode($toMailIds) . " cc - " . json_encode($ccMailIds));
        try {
            if ($ci->phpmailerlibrary->sendMultipleToMail($toMailIds, $subject, $message, $ccMailIds, [], [])) {
                log_message("error", "SALOG status notification email success " . $subject .$message. " to - " . json_encode($toMailIds) . " cc - " . json_encode($ccMailIds));
            } else {
                log_message("error", "SALOG status notification email failed " . $subject .$message. " to - " . json_encode($toMailIds) . " cc - " . json_encode($ccMailIds));
            }
        } catch (Exception $e) {
            log_message("error", "SALOG status notification email failed - " . $e->getMessage());
        }
    }
}
