<?php

use App\Libraries\OrderCreationSourceHelper;
use phpseclib\Net\SFTP;


class OpenboxStatusAccept
{
    private $ci;

    public function __construct()
    {
        $this->ci = &get_instance();
        $this->ci->load->helper(['edivalidation', 'Log']);
        $this->ci->load->model('common');
    }

    public function pushStatusXml(int $tripId): void
    {
        log_debug('Open-box-info: Tip id:  \'' . $tripId);
        if (!$tripId) {
            log_error('Open-box-info: Trip id is not valid');
            return;
        }

        if (!openBoxcheckCustomerIdvalid($tripId, 'tripid')) {
            log_error('Open-box-info: Trip not match with customer.');
            return;
        }
        $orders = $this->ci->common->gettbldata(
            ['trip_id' => $tripId],
            'id,order_id,vendor_id,shipmentid,created_source',
            'tb_orders',
            0,
            0
        );
        if (empty($orders)) {
            log_error('Open-box-info: Order(s) not found.');
            return;
        }
        $allOrders = $orders;
        $order = array_shift($orders);
        $vendorId = $order['vendor_id'];

        $data = ['tripid' => $order['shipmentid'], 'getorderids' => $allOrders, 'orderRowId' => $order['id'], 'created_source' => $order['created_source']];

        $stopStatus = $this->ci->common->gettbldata(
            ['trip_id' => $tripId, 'status_code' => '0212'],
            'id,status_code,createdon',
            'tb_stop_status',
            0,
            0
        );

        if (empty($stopStatus)) {
            log_error('Open-box-info: Status is not relevant.');
            return;
        }

        $firstCreatedOn = reset($stopStatus)['createdon'];
        $data['acceptanceTimestamp'] =  (new DateTime($firstCreatedOn))
            ->format("Y-m-d\TH:i:s\Z");

        $data['vendordetails'] = $this->getVendorData($vendorId);
        $this->generateXml($data);
    }

    private function getVendorData(string $vendorId): array
    {
        $vendorDetails = $this->ci->common->gettblrowdata(['id' => $vendorId], 'name,code', 'tb_vendors', 0, 0) ?: [];

        if (!$vendorDetails) {
            log_error('Open-box-info: Vendor not found.');
        }

        return $vendorDetails;
    }

    private static function generateXml($data): void
    {
        $seqNo = $data['orderRowId'];
        $fileName = $seqNo . '_openbox_accept_status.xml';
        $xmlString = '<?xml version="1.0" encoding="UTF-8"?>
		<Acceptance_Status xmlns="https://elog360.app/svkonekt_test/edi/carrier/acceptance_status/v1">
		<AcceptanceTimestamp>'.$data['acceptanceTimestamp'].'</AcceptanceTimestamp>
		<Header>
		<Version>V1</Version>
		<SequenceNumber>' . ((new \DateTime())->getTimestamp()) . '</SequenceNumber>
		<SourceApp>SVKONEKT</SourceApp>
		<DestinationApp>OPENBOXES</DestinationApp>
		</Header>
		<Action>ACCEPT</Action>
		<TripDetails>
		<TripID>' . $data['tripid'] . '</TripID>
		<Carrier>
		<ID>' . $data['vendordetails']['code'] . '</ID>
		<Name>' . $data['vendordetails']['name'] . '</Name>
		</Carrier>
		</TripDetails>
		<TripOrderDetails>';
        foreach ($data['getorderids'] as $res) {
            $xmlString .= '<OrderID>' . $res['order_id'] . '</OrderID>';
        }

        $xmlString .= '
		</TripOrderDetails>
		</Acceptance_Status>';

        $sftp = new SFTP(OPENBOX_SERVER_IP);
        if (!$sftp->login(OPENBOX_USERNAME, OPENBOX_PASSWORD)) {
            unset($sftp);
            log_error('error', 'Open-box-info: FTP LOGIN FAIL.');
            return;
        }


        if (!$sftp->chdir(OPENBOX_ACCEPT_STATUS_PATH)) {
            log_message('error', 'Open-box-info: Unable to find directory.');
            return;
        }

        if ($sftp->put($fileName, $xmlString)) {
            log_error('Open-box-info: File moved to FTP.');
        }
        unset($sftp);
    }
}
