<?php

namespace App\Libraries;

use http\Exception\RuntimeException;

class OrderCreationSourceHelper
{
    const DRIVERCOLLECT = 'DRIVER COLLECT';
    const CUSTQUOTE = 'CUST QUOTE';
    const QUICKBOOK = 'QUICKBOOK';
    const GENERALBOOKINGEXCEL = 'GENERAL BOOKING / EXCEL';
    const UPLOAD = 'UPLOAD';
    const SALOG = 'SALOG';
    const SHIPMENT = 'SHIPMENT';
    const NZEDI = 'NZ EDI';
    const SHIPPEO = 'SHIPPEO';
    const QUOTEMODULE = 'QUOTE MODULE';
    const KNLOGIN = 'KNLOGIN';
    const MACADAM = 'MACADAM';
    const AMAZONEDI = 'AMAZON EDI';
    const SWIFLOG = 'SWIFLOG';
    const SWIFLOGRETURN = 'SWIFLOG RETURN';
    const OPENBOXES = 'OPENBOXES';
    const ROADLOG = 'ROADLOG';
    const API_TRIPMANAGEMENT = 'API TRIPMANAGEMENT';

    private $ci;

    public function __construct()
    {
        $this->ci = &get_instance();
        $this->ci->load->model('common');
    }

    public function getOrderSourceName(?int $orderCreatedSourceId): string
    {
        $sourceInfo = $this->ci->common->gettblrowdata(["source_id" => $orderCreatedSourceId, "status" => '1'], 'source_name', 'order_creations_source_master', 0, 0);
        return empty($sourceInfo['source_name']) ? 'GENERAL BOOKING / EXCEL UPLOAD' : $sourceInfo['source_name'];
    }

    public function getOrderSourceId(string $orderCreatedSourceName): int
    {
        if (empty(trim($orderCreatedSourceName))) {
            throw new RuntimeException('Standard Interface : Invalid source app name./' . $orderCreatedSourceName);
        }
        $sourceInfo = $this->ci->common->gettblrowdata(["source_name" => $orderCreatedSourceName, "status" => '1'], 'source_id', 'order_creations_source_master', 0, 0);
        if (empty($sourceInfo)) {
            return $this->addOrderCreatedSources($orderCreatedSourceName);
        }
        return $sourceInfo['source_id'];
    }

    private function addOrderCreatedSources(string $sourceName): int
    {
        return $this->ci->common->insertTableData('order_creations_source_master', ['source_name' => $sourceName]);
    }
}
