<?php

class OtmBookingHandler
{
	private $ci;

	public function __construct()
	{
		$this->ci = &get_instance();
		$this->ci->load->model(['common', 'OtmBookingModel']);
		$this->ci->load->library(['OtmStandardBookingHandler']);
	}

	public function getOtmOrderReleaseData(string $data): string
	{  
	    //log_message("ERROR","Order Release Request:".$data);
		$xml = simplexml_load_string($data);
		$gLogElement = $xml->xpath('/Transmission/TransmissionBody/GLogXMLElement');
		$release = $gLogElement[0]->xpath('Release/ReleaseHeader');
		//log_message("error","releaseHeader1111:".json_encode($gLogElement[0]));
		$domainName = empty($gLogElement[0]->xpath('Release/ReleaseGid/Gid/DomainName')) ? 0 : (string)$gLogElement[0]->xpath('Release/ReleaseGid/Gid/DomainName')[0];
		$bookingId = empty($gLogElement[0]->xpath('Release/ReleaseGid/Gid/Xid')) ? 0 : (string)$gLogElement[0]->xpath('Release/ReleaseGid/Gid/Xid')[0];
		$organizationAry = $this->getOrganizationInfo($domainName);
		$customerAry = $this->getCustomerInfo($organizationAry, $domainName);
		$serviceProviderId = empty($release[0]->xpath('ServiceProviderGid')) ? '' : $release[0]->xpath('ServiceProviderGid/Gid/Xid')[0];
		$carrierAry = $carrierInfo = [];
		if($serviceProviderId <> '')
		{
		    $carrierAry = $this->getCarrierInfo($organizationAry, $domainName, $release);
		    $carrierInfo = $this->setCarrierInfo($carrierAry);
		}
		$addonsAry = $this->getAddonsInfo($release);
    	$shipFromLocationRef = $gLogElement[0]->xpath('Release/ShipFromLocationRef/LocationRef/Location');
		$sourceAry = $this->getShipFromLocationInfo($shipFromLocationRef);
		$shipToLocationRef = $gLogElement[0]->xpath('Release/ShipToLocationRef/LocationRef/Location');
		$destinationAry = $this->getShipToLocationInfo($shipToLocationRef);
		$timeWindowAry = $this->getTimeWindow($gLogElement);
		$cargoSummaryAry = $this->getCargoSummary($gLogElement);
		$outerCargos = $this->getShipUnitInfo($gLogElement);
		$outerReleaseCargos = $this->getReleaseLineInfo($gLogElement);
		$referencesAry = $this->getManageReferences($gLogElement);
		$remarksAry = $this->getRemarks($gLogElement);
		$involvedPartiesAry = $this->getInvolvedParties($gLogElement);
		
		$headerInfo = $this->setHeaderInfo($bookingId);
		$organizationInfo = $this->setOrganizationInfo($organizationAry, $domainName);
		$bookingInfo = $this->setBookingInfo($bookingId);
		$bookingHeaderInfo = $this->setBookingHeaderInfo($organizationAry, $gLogElement);
		//$customerInfo = $this->setCustomerInfo($involvedPartiesAry);
		$customerInfo = $this->setCustomerInfo($customerAry);
		
		$sourceInfo = $this->setShipFromLocationInfo($sourceAry, $timeWindowAry);
		$destinationInfo = $this->setShipToLocationInfo($destinationAry, $timeWindowAry);
		$cargoSummaryInfo = $this->setCargoSummaryInfo($cargoSummaryAry);
		$outerCargosInfo = $this->setShipUnitInfo($outerCargos);
		if(empty($outerCargosInfo)){
		    $outerReleaseCargosInfo = $this->setReleaseLineInfo($outerReleaseCargos);
		}
		$addonsInfo = $this->setAddonsInfo($addonsAry);
		$referencesInfo = $this->setManageReferences($referencesAry, $bookingId, $domainName);
		$remarksInfo = $this->setRemarks($remarksAry);
		$involvedPartiesInfo = $this->setInvolvedPartiesInfo($involvedPartiesAry, $sourceAry, $destinationAry, $customerAry, $carrierAry);
		
		$orderXML = '<SVKEDIMessage>' .$headerInfo. '<SVKEDIOrderBody>' .$organizationInfo .$bookingInfo .$bookingHeaderInfo .$customerInfo;
		
		if (!empty($carrierInfo)) {
            // convert array to string if needed
            $orderXML .= is_array($carrierInfo) ? implode("", $carrierInfo) : $carrierInfo;
        }
        
        $orderXML .= '<LocationInfo>' .$sourceInfo .$destinationInfo. '</LocationInfo>' .$cargoSummaryInfo .'<CargoDetails>' .$outerCargosInfo /*.$outerReleaseCargosInfo */.'</CargoDetails>' .$addonsInfo .'<InvolvedParties>' .$involvedPartiesInfo .'</InvolvedParties>' . $referencesInfo . $remarksInfo . '</SVKEDIOrderBody></SVKEDIMessage>';
		print_r($orderXML);
		
        $orderXML = str_replace('&', '&amp;', $orderXML);
        $orderXML = json_decode(json_encode(simplexml_load_string($orderXML, "SimpleXMLElement", LIBXML_NOCDATA)), true, 512, JSON_THROW_ON_ERROR);
        $this->ci->otmstandardbookinghandler->pullOrderXml($orderXML);
	
		/*$ediInfo = [
				'edi_type' => "OTM",
				'edi_name' => "Order Release",
				'edi_format' => "XML",
				'transaction_id' => $bookingId,
				'edi_request' => $data,
				'edi_response' => $response,
				'org_id' => $organizationAry['organizationId'],
				'business_entity_id' => $organizationAry['businessEntityValue']
			];
		$this->ci->common->insertTableData('tb_edi_logs', $ediInfo);*/
		return "";
	}

	public function getOrganizationInfo(string $domainName): array
	{
		$organizationId = $businessEntityValue = "";
		$orgDetails = $this->ci->OtmBookingModel->getOrganizationInfo($domainName);
		if (count($orgDetails) > 0) {
			$organizationId = $orgDetails['organization_name'];
			$businessEntityValue = $orgDetails['business_entity_value'];
		}
		$organizationAry = [
			'organizationId' => $organizationId,
			'businessEntityValue' => $businessEntityValue,
		];
		return $organizationAry;
	}

	public function getCustomerInfo(array $organizationAry, string $domainName): array
	{
		$customerId = $customerName = $registrationNumber = $address1 = $address2 = $street = "";
		$province = $city = $state = $postal = $country = $latitude = $longitude = "";
		$countryCode = $contactNo = $emailAddress = "";
		$customerId = $this->ci->OtmBookingModel->getOtmPartyType($organizationAry['organizationId'], $organizationAry['businessEntityValue'],'ALL','CUSTOMER');
		//log_message("error","customerName".$customerName);
		$customerDetails = $this->ci->OtmBookingModel->getOtmPartyInfo($organizationAry['organizationId'], $organizationAry['businessEntityValue'], $customerId, 'CUSTOMER');
		foreach ($customerDetails as $customerDet)
		{
			$customerId = $customerDet['code'];
			$customerName = $customerDet['name'];
			$registrationNumber = $customerDet['customer_code'];
			$address1 = $customerDet['address'];
			$address2 = $customerDet['house_number'];
			$street = $customerDet['street'];
			$province = $customerDet['state'];
			$city = $customerDet['location_id'];
			$state = $customerDet['state'];
			$postal = $customerDet['pincode'];
			$country = $customerDet['country'];
			$latitude = $customerDet['latitude'];
			$longitude = $customerDet['longitude'];
			$countryCode = $customerDet['country'];
			$contactNo = $customerDet['mobile'];
			$emailAddress = $customerDet['email'];
		}
        $customerAry = [
			'customerId' => $customerId,
			'customerName' => $customerName,
			'registrationNumber' => $registrationNumber,
			'address1' => $address1,
			'address2' => $address2,
			'street' => $street,
			'province' => $province,
			'city' => $city,
			'state' => $state,
			'postal' => $postal,
			'country' => $country,
			'latitude' => $latitude,
			'longitude' => $longitude,
			'countryCode' => $countryCode,
			'contactNo' => $contactNo,
			'emailAddress' => $emailAddress,
		];

		return $customerAry;
	}
	
	public function getCarrierInfo(array $organizationAry, string $domainName, array $releaseHeader): array
	{
		$serviceProviderId = empty($releaseHeader[0]->xpath('ServiceProviderGid')) ? '' : $releaseHeader[0]->xpath('ServiceProviderGid/Gid/Xid')[0];
        if ($serviceProviderId == "") {
            $serviceProviderId = empty($releaseHeader[0]->xpath('ServiceProviderGid')) ? '' : $releaseHeader[0]->xpath('ServiceProviderGid/Gid/Xid')[0];
        }
        
        $carrierId = $this->ci->OtmBookingModel->getOtmPartyType($organizationAry['organizationId'], $organizationAry['businessEntityValue'], $serviceProviderId,'CARRIER');
        
		$carrierId = $carrierName = $registrationNumber = $address1 = $address2 = $street = "";
		$province = $city = $state = $postal = $country = $latitude = $longitude = "";
		$countryCode = $contactNo = $emailAddress = "";
		$carrierId = $this->ci->OtmBookingModel->getOtmPartyType($organizationAry['organizationId'], $organizationAry['businessEntityValue'], $serviceProviderId,'CARRIER');
		if(empty($carrierId)){
		    $carrierId = $this->ci->OtmBookingModel->getOtmPartyType($organizationAry['organizationId'], $organizationAry['businessEntityValue'],'ALL','CARRIER');
		    $carrierDetails = $this->ci->OtmBookingModel->getOtmPartyInfo($organizationAry['organizationId'], $organizationAry['businessEntityValue'], $carrierId, 'CARRIER');
        }
        else
        {
            $carrierDetails = $this->ci->OtmBookingModel->getOtmCarrierPartyInfo($organizationAry['organizationId'], $organizationAry['businessEntityValue'], $carrierId, 'CARRIER');
        }
		
		foreach ($carrierDetails as $carrierDet)
		{
			$carrierId = $carrierDet['code'];
			$carrierName = $carrierDet['name'];
			$registrationNumber = $carrierDet['customer_code'];
			$address1 = $carrierDet['address'];
			$address2 = $carrierDet['house_number'];
			$street = $carrierDet['street'];
			$province = $carrierDet['state'];
			$city = $carrierDet['location_id'];
			$state = $carrierDet['state'];
			$postal = $carrierDet['pincode'];
			$country = $carrierDet['country'];
			$latitude = $carrierDet['latitude'];
			$longitude = $carrierDet['longitude'];
			$countryCode = $carrierDet['country'];
			$contactNo = $carrierDet['mobile'];
			$emailAddress = $carrierDet['email'];
		}
        $carrierAry = [
			'carrierId' => $carrierId,
			'carrierName' => $carrierName,
			'registrationNumber' => $registrationNumber,
			'address1' => $address1,
			'address2' => $address2,
			'street' => $street,
			'province' => $province,
			'city' => $city,
			'state' => $state,
			'postal' => $postal,
			'country' => $country,
			'latitude' => $latitude,
			'longitude' => $longitude,
			'countryCode' => $countryCode,
			'contactNo' => $contactNo,
			'emailAddress' => $emailAddress,
		];

		return $carrierAry;
	}

	public function getShipFromLocationInfo(array $shipFromLocationRef): array
	{
	    $shipFromLocationId = empty($shipFromLocationRef[0]->xpath('LocationGid/Gid/Xid')[0]) ? $shipFromLocationRef[0]->xpath('LocationName') : $shipFromLocationRef[0]->xpath('LocationGid/Gid/Xid')[0];
		$shipFromLocationName = empty($shipFromLocationRef[0]->xpath('LocationName')) ? (string)$shipFromLocationRef[0]->xpath('LocationGid/Gid/Xid')[0] : (string)$shipFromLocationRef[0]->xpath('LocationName')[0];
		$shipFromAddress = empty($shipFromLocationRef[0]->xpath('Address/AddressLines')) ? [] : $shipFromLocationRef[0]->xpath('Address/AddressLines');
		$shipFromAddressAry = [];
		foreach ($shipFromAddress as $fromAddress)
		{
			$address = empty($fromAddress->xpath('AddressLine')[0]) ? "" : $fromAddress->xpath('AddressLine')[0];
			array_push($shipFromAddressAry , $address);
		}
		$shipFromCity = empty($shipFromLocationRef[0]->xpath('Address/City')) ? 0 : (string)$shipFromLocationRef[0]->xpath('Address/City')[0];
		$shipFromProvince = empty($shipFromLocationRef[0]->xpath('Address/Province')) ? "" : (string)$shipFromLocationRef[0]->xpath('Address/Province')[0];
		$shipFromProvinceCode = empty($shipFromLocationRef[0]->xpath('Address/ProvinceCode')) ? "" : (string)$shipFromLocationRef[0]->xpath('Address/ProvinceCode')[0];
		$shipFromPostalCode = empty($shipFromLocationRef[0]->xpath('Address/PostalCode')) ? "" : (string)$shipFromLocationRef[0]->xpath('Address/PostalCode')[0];
		$shipFromCountryCode = empty($shipFromLocationRef[0]->xpath('Address/CountryCode3Gid/Gid/Xid')) ? "" : (string)$shipFromLocationRef[0]->xpath('Address/CountryCode3Gid/Gid/Xid')[0];
		$shipFromLatitude = empty($shipFromLocationRef[0]->xpath('Address/Latitude')) ? 0 : (string)$shipFromLocationRef[0]->xpath('Address/Latitude')[0];
		$shipFromLongitude = empty($shipFromLocationRef[0]->xpath('Address/Longitude')) ? 0 : (string)$shipFromLocationRef[0]->xpath('Address/Longitude')[0];

		$sourceAry = [
		    'shipFromLocationId' => $shipFromLocationId,
			'shipFromLocationName' => $shipFromLocationName,
			'shipFromAddressAry' => $shipFromAddressAry,
			'shipFromCity' => $shipFromCity,
			'shipFromProvince' => $shipFromProvince,
			'shipFromProvinceCode' => $shipFromProvinceCode,
			'shipFromPostalCode' => $shipFromPostalCode,
			'shipFromCountryCode' => $shipFromCountryCode,
			'shipFromLatitude' => $shipFromLatitude,
			'shipFromLongitude' => $shipFromLongitude,
		];

		return $sourceAry;
	}

	public function getShipToLocationInfo(array $shipToLocationRef): array
	{
	    $shipToLocationId = empty($shipToLocationRef[0]->xpath('LocationGid/Gid/Xid')[0]) ? $shipToLocationRef[0]->xpath('LocationName') : $shipToLocationRef[0]->xpath('LocationGid/Gid/Xid')[0];
		$shipToLocationName = empty($shipToLocationRef[0]->xpath('LocationName')) ? (string)$shipToLocationRef[0]->xpath('LocationGid/Gid/Xid')[0] : (string)$shipToLocationRef[0]->xpath('LocationName')[0];
		$shipToAddress = empty($shipToLocationRef[0]->xpath('Address/AddressLines')) ? [] : $shipToLocationRef[0]->xpath('Address/AddressLines');
		$shipToAddressAry = [];

		foreach ($shipToAddress as $toAddress)
		{
			$address = empty($toAddress->xpath('AddressLine')[0]) ? "" : $toAddress->xpath('AddressLine')[0];
			array_push($shipToAddressAry ,$address);
		}

		$shipToCity = empty($shipToLocationRef[0]->xpath('Address/City')) ? 0 : (string)$shipToLocationRef[0]->xpath('Address/City')[0];
		$shipToProvince = empty($shipToLocationRef[0]->xpath('Address/Province')) ? 0 : (string)$shipToLocationRef[0]->xpath('Address/Province')[0];
		$shipToProvinceCode = empty($shipToLocationRef[0]->xpath('Address/ProvinceCode')) ? "" : (string)$shipToLocationRef[0]->xpath('Address/ProvinceCode')[0];
		$shipToPostalCode = empty($shipToLocationRef[0]->xpath('Address/PostalCode')) ? "" : (string)$shipToLocationRef[0]->xpath('Address/PostalCode')[0];
		$shipToCountryCode = empty($shipToLocationRef[0]->xpath('Address/CountryCode3Gid/Gid/Xid')) ? "" : (string)$shipToLocationRef[0]->xpath('Address/CountryCode3Gid/Gid/Xid')[0];
		$shipToLatitude = empty($shipToLocationRef[0]->xpath('Address/Latitude')) ? 0 : (string)$shipToLocationRef[0]->xpath('Address/Latitude')[0];
		$shipToLongitude = empty($shipToLocationRef[0]->xpath('Address/Longitude')) ? 0 : (string)$shipToLocationRef[0]->xpath('Address/Longitude')[0];

		$destinationAry = [
		    'shipToLocationId' => $shipToLocationId,
			'shipToLocationName' => $shipToLocationName,
			'shipToAddressAry' => $shipToAddressAry,
			'shipToCity' => $shipToCity,
			'shipToProvince' => $shipToProvince,
			'shipToProvinceCode' => $shipToProvinceCode,
			'shipToPostalCode' => $shipToPostalCode,
			'shipToCountryCode' => $shipToCountryCode,
			'shipToLatitude' => $shipToLatitude,
			'shipToLongitude' => $shipToLongitude,
		];
		return $destinationAry;
	}

	public function getTimeWindow(array $gLogElement): array
	{
		$timeWindow = $gLogElement[0]->xpath('Release/TimeWindow');

		$earlyPickupDate = empty($timeWindow[0]->xpath('EarlyPickupDt/GLogDate')) ? "" : date("Y-m-d\TH:i:s",strtotime((integer)$timeWindow[0]->xpath('EarlyPickupDt/GLogDate')[0]));
		$earlyPickupTime = empty($timeWindow[0]->xpath('EarlyPickupDt/TZId')) ? "" : (string)$timeWindow[0]->xpath('EarlyPickupDt/TZId')[0];
		$earlyPickupZone = empty($timeWindow[0]->xpath('EarlyPickupDt/TZOffset')) ? "" : (string)$timeWindow[0]->xpath('EarlyPickupDt/TZOffset')[0];
		$earlyPickupTimeZone = empty($earlyPickupZone) ? "" : $earlyPickupZone . "/" . $earlyPickupTime;

		$latePickupDate = empty($timeWindow[0]->xpath('LatePickupDt/GLogDate')) ? "" : date("Y-m-d\TH:i:s",strtotime((integer)$timeWindow[0]->xpath('LatePickupDt/GLogDate')[0]));
		$latePickupTime = empty($timeWindow[0]->xpath('LatePickupDt/TZId')) ? "" : (string)$timeWindow[0]->xpath('LatePickupDt/TZId')[0];
		$latePickupZone = empty($timeWindow[0]->xpath('LatePickupDt/TZOffset')) ? "" : (string)$timeWindow[0]->xpath('LatePickupDt/TZOffset')[0];
		$latePickupTimeZone = empty($latePickupZone) ? "" : $latePickupZone . "/" . $latePickupTime;

		$earlyDeliveryDate = empty($timeWindow[0]->xpath('EarlyDeliveryDt/GLogDate')) ? "" : date("Y-m-d\TH:i:s",strtotime((integer)$timeWindow[0]->xpath('EarlyDeliveryDt/GLogDate')[0]));
		$earlyDeliveryTime = empty($timeWindow[0]->xpath('EarlyDeliveryDt/TZId')) ? "" : (string)$timeWindow[0]->xpath('EarlyDeliveryDt/TZId')[0];
		$earlyDeliveryZone = empty($timeWindow[0]->xpath('EarlyDeliveryDt/TZOffset')) ? "" : (string)$timeWindow[0]->xpath('EarlyDeliveryDt/TZOffset')[0];
		$earlyDeliveryTimeZone = empty($earlyDeliveryZone) ? "" : $earlyDeliveryZone . "/" . $earlyDeliveryTime;

		$lateDeliveryDate = empty($timeWindow[0]->xpath('LateDeliveryDt/GLogDate')) ? "" : date("Y-m-d\TH:i:s",strtotime((integer)$timeWindow[0]->xpath('LateDeliveryDt/GLogDate')[0]));
		$lateDeliveryTime = empty($timeWindow[0]->xpath('LateDeliveryDt/TZId')) ? "" : (string)$timeWindow[0]->xpath('LateDeliveryDt/TZId')[0];
		$lateDeliveryZone = empty($timeWindow[0]->xpath('LateDeliveryDt/TZOffset')) ? "" : (string)$timeWindow[0]->xpath('LateDeliveryDt/TZOffset')[0];
		$lateDeliveryTimeZone = empty($lateDeliveryZone) ? "" : $lateDeliveryZone . "/" . $lateDeliveryTime;
		
		if($earlyPickupDate == $lateDeliveryDate)
		{
		    $earlyPickupDate = $lateDeliveryDate = "";
		}
		
		$timeWindowAry = [
			'earlyPickupDate' => $earlyPickupDate,
			'earlyPickupTimeZone' => $earlyPickupTimeZone,
			'latePickupDate' => $latePickupDate,
			'latePickupTimeZone' => $latePickupTimeZone,
			'earlyDeliveryDate' => $earlyDeliveryDate,
			'earlyDeliveryTimeZone' => $earlyDeliveryTimeZone,
			'lateDeliveryDate' => $lateDeliveryDate,
			'lateDeliveryTimeZone' => $lateDeliveryTimeZone,
		];

		return $timeWindowAry;
	}

	public function getCargoSummary(array $gLogElement): array
	{
		$totalWeight = $gLogElement[0]->xpath('Release/TotalWeightVolume/WeightVolume/Weight');
		$totalVolume = $gLogElement[0]->xpath('Release/TotalWeightVolume/WeightVolume/Volume');

		$totalWeightValue = empty($totalWeight[0]->xpath('WeightValue')) ? '0' : (string)$totalWeight[0]->xpath('WeightValue')[0];
		$totalWeightUOM = empty($totalWeight[0]->xpath('WeightUOMGid/Gid/Xid')) ? 'DEFAULT WEIGHT' : (string)$totalWeight[0]->xpath('WeightUOMGid/Gid/Xid')[0];
		$totalVolumeValue = empty($totalVolume[0]->xpath('VolumeValue')) ? 0 : (string)$totalVolume[0]->xpath('VolumeValue')[0];
		$totalVolumeUOM = empty($totalVolume[0]->xpath('VolumeUOMGid/Gid/Xid')) ? 'DEFAULT VOLUME' : (string)$totalVolume[0]->xpath('VolumeUOMGid/Gid/Xid')[0];
		$totalQuantityValue = empty($gLogElement[0]->xpath('Release/TotalPackagedItemCount')) ? 0 : (string)$gLogElement[0]->xpath('Release/TotalPackagedItemCount')[0];

		$cargoSummaryAry = [
			'totalWeightValue' => $totalWeightValue,
			'totalWeightUOM' => $totalWeightUOM,
			'totalVolumeValue' => $totalVolumeValue,
			'totalVolumeUOM' => $totalVolumeUOM,
			'totalQuantityValue' => $totalQuantityValue,
		];
		return $cargoSummaryAry;
	}
	
	public function getShipUnitInfo(array $gLogElement): array
    {
        $releaseLine = $gLogElement[0]->xpath('Release/ReleaseLine');
        $shipUnit = $gLogElement[0]->xpath('Release/ShipUnit');
		
        $innerReleaseLines = $releaseLine;
        $shipUnits = empty($shipUnit) ? [] : $shipUnit;
        $outerCargos = [];
        $matchedReleaseLineXids = []; 
    
        foreach ($shipUnits as $shipUnit) {
            $shipUnitContent = $shipUnit[0]->xpath('ShipUnitContent')[0];
            $shipUnitCargoId = (string) $shipUnit[0]->xpath('ShipUnitGid/Gid/Xid')[0];
    
            $packagingWeightVolume = $shipUnit[0]->xpath('WeightVolume')[0];
            $shipUnitPackagingDimensions = $shipUnit->xpath('LengthWidthHeight');
    
            $outerPackageType = $outerPackageDesc = "DEFAULT";
            $outerPackageWeightUOM = $outerPackageVolumeUOM = $outerPackageLengthUOM = $outerPackageWidthUOM = $outerPackageHeightUOM = "";
            $outerPackageWeightValue = $outerPackageVolumeValue = $outerPackageLengthValue = $outerPackageWidthValue = $outerPackageHeightValue = 0;
            $outerPackageQuantity = empty((string) $shipUnit[0]->xpath('ShipUnitCount')[0]) ? "0" : (string) $shipUnit[0]->xpath('ShipUnitCount')[0];
    
            if (!empty($shipUnit[0]->xpath('TransportHandlingUnitRef/ShipUnitSpecRef/ShipUnitSpecGid'))) {
                $outerPackageType = (string) $shipUnit[0]->xpath('TransportHandlingUnitRef/ShipUnitSpecRef/ShipUnitSpecGid/Gid/Xid')[0];
            }
    
            $outerPackageDesc = $outerPackageType;
    
            if (!empty($packagingWeightVolume)) {
                $outerPackageWeightValue = empty((string) $packagingWeightVolume[0]->xpath('Weight/WeightValue')[0]) ? 0 : (string) $packagingWeightVolume[0]->xpath('Weight/WeightValue')[0];
                $outerPackageWeightUOM = empty((string) $packagingWeightVolume[0]->xpath('Weight/WeightUOMGid/Gid/Xid')[0]) ? 'DEFAULT WEIGHT' : (string) $packagingWeightVolume[0]->xpath('Weight/WeightUOMGid/Gid/Xid')[0];
                $outerPackageVolumeValue = empty((string) $packagingWeightVolume[0]->xpath('Volume/VolumeValue')[0]) ? 0 : (string) $packagingWeightVolume[0]->xpath('Volume/VolumeValue')[0];
                $outerPackageVolumeUOM = empty((string) $packagingWeightVolume[0]->xpath('Volume/VolumeUOMGid/Gid/Xid')[0]) ? 'DEFAULT VOLUME' : (string) $packagingWeightVolume[0]->xpath('Volume/VolumeUOMGid/Gid/Xid')[0];
            }
    
            if(!empty($shipUnitPackagingDimensions))
            {
            $outerPackageLengthValue = empty((string)$shipUnitPackagingDimensions[0]->xpath('Length/LengthValue')[0]) ? 0 : (string)$shipUnitPackagingDimensions[0]->xpath('Length/LengthValue')[0];
            $outerPackageLengthUOM = empty((string)$shipUnitPackagingDimensions[0]->xpath('Length/LengthUOMGid/Gid/Xid')[0]) ? 0 : (string)$shipUnitPackagingDimensions[0]->xpath('Length/LengthUOMGid/Gid/Xid')[0];
            $outerPackageWidthValue = empty((string)$shipUnitPackagingDimensions[0]->xpath('Width/WidthValue')[0]) ? 0 : (string)$shipUnitPackagingDimensions[0]->xpath('Width/WidthValue')[0];
            $outerPackageWidthUOM = empty((string)$shipUnitPackagingDimensions[0]->xpath('Width/WidthUOMGid/Gid/Xid')[0]) ? 0 : (string)$shipUnitPackagingDimensions[0]->xpath('Width/WidthUOMGid/Gid/Xid')[0];
            $outerPackageHeightValue = empty((string)$shipUnitPackagingDimensions[0]->xpath('Height/HeightValue')[0]) ? 0 : (string)$shipUnitPackagingDimensions[0]->xpath('Height/HeightValue')[0];
            $outerPackageHeightUOM = empty((string)$shipUnitPackagingDimensions[0]->xpath('Height/HeightUOMGid/Gid/Xid')[0]) ? 0 : (string)$shipUnitPackagingDimensions[0]->xpath('Height/HeightUOMGid/Gid/Xid')[0];
            }
    
            $innerCargosAry = [];
            $releaseLines = $shipUnit[0]->xpath('ShipUnitContent/ReleaseLineGid/Gid');
    
            foreach ($releaseLines as $releaseLine) {
                $outerReleaseLineXid = (string) $releaseLine->xpath('Xid')[0];
                foreach ($innerReleaseLines as $innerReleaseLine) {
                    $innerReleaseLineXid = (string) $innerReleaseLine[0]->xpath('ReleaseLineGid/Gid/Xid')[0];
                    if (strcasecmp($innerReleaseLineXid, $outerReleaseLineXid) == 0) {
                        $matchedReleaseLineXids[] = $innerReleaseLineXid;
                        
                        $innerPackaging = empty($innerReleaseLine->xpath('PackagedItemRef/PackagedItem/Packaging')) ? [] : $innerReleaseLine->xpath('PackagedItemRef/PackagedItem/Packaging');

                        if (!empty($innerReleaseLine->xpath('PackageDimensions'))) {
                            $innerPackagingDimensions = $innerReleaseLine->xpath('PackageDimensions');
                        } elseif (!empty($innerPackaging)) {
                            $innerPackagingDimensions = $innerPackaging[0]->xpath('PackageShipUnitLWH');
                        }

                        if (!empty($innerPackaging) && !empty($innerPackaging[0]->xpath('PackageShipUnitWeightVolume'))) {
                            $innerPackagingWeightVolume = $innerPackaging[0]->xpath('PackageShipUnitWeightVolume');
                        }elseif (!empty($innerReleaseLine->xpath('ItemQuantity'))) {
                            $innerPackagingWeightVolume = $innerReleaseLine->xpath('ItemQuantity/WeightVolume');
                        } 
                        
                        $innerPackageType = $innerPackageDesc = $innerPackageType = $innerPackageWeightUOM = $innerPackageVolumeUOM = $innerPackageLengthUOM = $innerPackageWidthUOM = $innerPackageHeightUOM = "";
                        $innerPackageQuantity = $innerPackageWeightValue = $innerPackageVolumeValue = $innerPackageLengthValue = $innerPackageWidthValue = $innerPackageHeightValue = 0;

                        $innerPackageQuantity = empty((string) $innerReleaseLine[0]->xpath('ItemQuantity/PackagedItemCount')[0]) ? "0" : (string) $innerReleaseLine[0]->xpath('ItemQuantity/PackagedItemCount')[0];
                        if (!empty($innerReleaseLine[0]->xpath('PackagedItemRef/PackagedItem/Item/ItemGid'))) {
                            $innerPackageType = is_array($innerReleaseLine[0]->xpath('PackagedItemRef/PackagedItem/Item/ItemGid/Gid/Xid')[0]) ? 0 : $innerReleaseLine[0]->xpath('PackagedItemRef/PackagedItem/Item/ItemGid/Gid/Xid')[0];
                        } elseif (!empty($innerReleaseLine[0]->xpath('PackagedItemRef/PackagedItemGid'))) {
                            $innerPackageType = is_array($innerReleaseLine[0]->xpath('PackagedItemRef/PackagedItemGid/Gid/Xid')[0]) ? 0 : $innerReleaseLine[0]->xpath('PackagedItemRef/PackagedItemGid/Gid/Xid')[0];
                        } elseif (!empty($innerReleaseLine[0]->xpath('PackagedItemSpecRef/ShipUnitSpecRef/ShipUnitSpecGid'))) {
                            $innerPackageType = is_array($innerReleaseLine[0]->xpath('PackagedItemSpecRef/ShipUnitSpecRef/ShipUnitSpecGid/Gid/Xid')[0]) ? 0 : $innerReleaseLine[0]->xpath('PackagedItemSpecRef/ShipUnitSpecRef/ShipUnitSpecGid/Gid/Xid')[0];
                        } elseif (!empty($innerPackaging) && !empty($innerReleaseLine[0]->xpath('PackagedItemRef/PackagedItem/Packaging/PackagedItemSpecRef/ShipUnitSpecRef/ShipUnitSpecRef'))) {
                            $innerPackageType = is_array($innerPackaging[0]->xpath('PackagedItemRef/PackagedItem/Packaging/PackagedItemSpecRef/ShipUnitSpecRef/ShipUnitSpecRef/Gid/Xid')[0]) ? 0 : $innerPackaging[0]->xpath('PackagedItemRef/PackagedItem/Packaging/PackagedItemSpecRef/ShipUnitSpecRef/ShipUnitSpecRef/Gid/Xid')[0];
                        } 

                        if (!empty($innerPackaging) && !empty($innerPackaging[0]->xpath('PackagedItemRef/PackagedItem/Item/ItemGid'))) {
                            $innerPackageDesc = is_array($innerPackaging[0]->xpath('PackagedItemRef/PackagedItem/Item/ItemGid/Gid/Xid')[0]) ? 0 : $innerPackaging[0]->xpath('PackagedItemRef/PackagedItem/Item/ItemGid/Gid/Xid')[0];
                        } elseif (!empty($innerReleaseLine[0]->xpath('PackagedItemRef/PackagedItem/Item/Description'))) {
                            $innerPackageDesc = is_array($innerReleaseLine[0]->xpath('PackagedItemRef/PackagedItem/Item/Description')[0]) ? 0 : $innerReleaseLine[0]->xpath('PackagedItemRef/PackagedItem/Item/Description')[0];
                        } else {
                            $innerPackageDesc = $innerPackageType;
                        }

                        if (!empty($innerPackagingWeightVolume)) {
                            $innerPackageWeightValue = empty($innerPackagingWeightVolume[0]->xpath('Weight/WeightValue')[0]) ? 0 : (string) $innerPackagingWeightVolume[0]->xpath('Weight/WeightValue')[0];
                            $innerPackageWeightUOM = empty($innerPackagingWeightVolume[0]->xpath('Weight/WeightUOMGid/Gid/Xid')[0]) ? 0 : (string) $innerPackagingWeightVolume[0]->xpath('Weight/WeightUOMGid/Gid/Xid')[0];
                            $innerPackageVolumeValue = empty($innerPackagingWeightVolume[0]->xpath('Volume/VolumeValue')[0]) ? 0 : (string) $innerPackagingWeightVolume[0]->xpath('Volume/VolumeValue')[0];
                            $innerPackageVolumeUOM = empty($innerPackagingWeightVolume[0]->xpath('Volume/VolumeUOMGid/Gid/Xid')[0]) ? 0 : (string) $innerPackagingWeightVolume[0]->xpath('Volume/VolumeUOMGid/Gid/Xid')[0];
                        }
                        
                        if (!empty($innerPackagingDimensions)) {
                            $innerPackageLengthValue = empty($innerPackagingDimensions[0]->xpath('Length/LengthValue')[0]) ? 0 : (string) $innerPackagingDimensions[0]->xpath('Length/LengthValue')[0];
                            $innerPackageLengthUOM = empty($innerPackagingDimensions[0]->xpath('Length/LengthUOMGid/Gid/Xid')[0]) ? 0 : (string) $innerPackagingDimensions[0]->xpath('Length/LengthUOMGid/Gid/Xid')[0];
                            $innerPackageWidthValue = empty($innerPackagingDimensions[0]->xpath('Width/WidthValue')[0]) ? 0 : (string) $innerPackagingDimensions[0]->xpath('Width/WidthValue')[0];
                            $innerPackageWidthUOM = empty($innerPackagingDimensions[0]->xpath('Width/WidthUOMGid/Gid/Xid')[0]) ? 0 : (string) $innerPackagingDimensions[0]->xpath('Width/WidthUOMGid/Gid/Xid')[0];
                            $innerPackageHeightValue = empty($innerPackagingDimensions[0]->xpath('Height/HeightValue')[0]) ? 0 : (string) $innerPackagingDimensions[0]->xpath('Height/HeightValue')[0];
                            $innerPackageHeightUOM = empty($innerPackagingDimensions[0]->xpath('Height/HeightUOMGid/Gid/Xid')[0]) ? 0 : (string) $innerPackagingDimensions[0]->xpath('Height/HeightUOMGid/Gid/Xid')[0];
                        }
                        
                        $innerCargosAry[] = [
                            'externalInnerCargoId' => $innerReleaseLineXid,
                            'innerPackageType' => $innerPackageType,
                            'innerPackageDesc' => $innerPackageDesc,
                            'innerPackageWeightValue' => $innerPackageWeightValue,
                            'innerPackageWeightUOM' => $innerPackageWeightUOM,
                            'innerPackageVolumeValue' => $innerPackageVolumeValue,
                            'innerPackageVolumeUOM' => $innerPackageVolumeUOM,
                            'innerPackageLengthValue' => $innerPackageLengthValue,
                            'innerPackageLengthUOM' => $innerPackageLengthUOM,
                            'innerPackageWidthValue' => $innerPackageWidthValue,
                            'innerPackageWidthUOM' => $innerPackageWidthUOM,
                            'innerPackageHeightValue' => $innerPackageHeightValue,
                            'innerPackageHeightUOM' => $innerPackageHeightUOM,
                            'innerPackageQuantity' => $innerPackageQuantity,
                        ];
                    }
                }
            }
    
            $outerCargos[] = [
                'externalOuterCargoId' => $shipUnitCargoId,
                'outerPackageType' => $outerPackageType,
                'outerPackageDesc' => $outerPackageDesc,
                'outerPackageWeightValue' => $outerPackageWeightValue,
                'outerPackageWeightUOM' => $outerPackageWeightUOM,
                'outerPackageVolumeValue' => $outerPackageVolumeValue,
                'outerPackageVolumeUOM' => $outerPackageVolumeUOM,
                'outerPackageLengthValue' => $outerPackageLengthValue,
                'outerPackageLengthUOM' => $outerPackageLengthUOM,
                'outerPackageWidthValue' => $outerPackageWidthValue,
                'outerPackageWidthUOM' => $outerPackageWidthUOM,
                'outerPackageHeightValue' => $outerPackageHeightValue,
                'outerPackageHeightUOM' => $outerPackageHeightUOM,
                'outerPackageQuantity' => $outerPackageQuantity,
                'innerCargos' => $innerCargosAry,
            ];
        }
    
        foreach ($innerReleaseLines as $innerReleaseLine) {
            $innerReleaseLineXid = (string) $innerReleaseLine[0]->xpath('ReleaseLineGid/Gid/Xid')[0];
            if (!in_array($innerReleaseLineXid, $matchedReleaseLineXids)) {
                
                $innerPackaging = empty($innerReleaseLine->xpath('PackagedItemRef/PackagedItem/Packaging')) ? [] : $innerReleaseLine->xpath('PackagedItemRef/PackagedItem/Packaging');

                if (!empty($innerReleaseLine->xpath('PackageDimensions'))) {
                    $innerPackagingDimensions = $innerReleaseLine->xpath('PackageDimensions');
                } elseif (!empty($innerPackaging)) {
                    $innerPackagingDimensions = $innerPackaging[0]->xpath('PackageShipUnitLWH');
                }

                if (!empty($innerReleaseLine->xpath('ItemQuantity'))) {
                    $innerPackagingWeightVolume = $innerReleaseLine->xpath('ItemQuantity/WeightVolume');
                } elseif (!empty($innerPackaging)) {
                    $innerPackagingWeightVolume = $innerPackaging[0]->xpath('PackageShipUnitWeightVolume');
                }
                
                $innerPackageType = $innerPackageDesc = $innerPackageType = $innerPackageWeightUOM = $innerPackageVolumeUOM = $innerPackageLengthUOM = $innerPackageWidthUOM = $innerPackageHeightUOM = "";
                $innerPackageQuantity = $innerPackageWeightValue = $innerPackageVolumeValue = $innerPackageLengthValue = $innerPackageWidthValue = $innerPackageHeightValue = 0;

                $innerPackageQuantity = empty((string) $innerReleaseLine[0]->xpath('ItemQuantity/PackagedItemCount')[0]) ? "0" : (string) $innerReleaseLine[0]->xpath('ItemQuantity/PackagedItemCount')[0];
                if (!empty($innerReleaseLine[0]->xpath('PackagedItemRef/PackagedItem/Item/ItemGid'))) {
                    $innerPackageType = is_array($innerReleaseLine[0]->xpath('PackagedItemRef/PackagedItem/Item/ItemGid/Gid/Xid')[0]) ? 0 : $innerReleaseLine[0]->xpath('PackagedItemRef/PackagedItem/Item/ItemGid/Gid/Xid')[0];
                } elseif (!empty($innerReleaseLine[0]->xpath('PackagedItemRef/PackagedItemGid'))) {
                    $innerPackageType = is_array($innerReleaseLine[0]->xpath('PackagedItemRef/PackagedItemGid/Gid/Xid')[0]) ? 0 : $innerReleaseLine[0]->xpath('PackagedItemRef/PackagedItemGid/Gid/Xid')[0];
                } elseif (!empty($innerReleaseLine[0]->xpath('PackagedItemSpecRef/ShipUnitSpecRef/ShipUnitSpecGid'))) {
                    $innerPackageType = is_array($innerReleaseLine[0]->xpath('PackagedItemSpecRef/ShipUnitSpecRef/ShipUnitSpecGid/Gid/Xid')[0]) ? 0 : $innerReleaseLine[0]->xpath('PackagedItemSpecRef/ShipUnitSpecRef/ShipUnitSpecGid/Gid/Xid')[0];
                } elseif (!empty($innerPackaging) && !empty($innerReleaseLine[0]->xpath('PackagedItemRef/PackagedItem/Packaging/PackagedItemSpecRef/ShipUnitSpecRef/ShipUnitSpecRef'))) {
                    $innerPackageType = is_array($innerPackaging[0]->xpath('PackagedItemRef/PackagedItem/Packaging/PackagedItemSpecRef/ShipUnitSpecRef/ShipUnitSpecRef/Gid/Xid')[0]) ? 0 : $innerPackaging[0]->xpath('PackagedItemRef/PackagedItem/Packaging/PackagedItemSpecRef/ShipUnitSpecRef/ShipUnitSpecRef/Gid/Xid')[0];
                } 

                if (!empty($innerPackaging) && !empty($innerPackaging[0]->xpath('PackagedItemRef/PackagedItem/Item/ItemGid'))) {
                    $innerPackageDesc = is_array($innerPackaging[0]->xpath('PackagedItemRef/PackagedItem/Item/ItemGid/Gid/Xid')[0]) ? 0 : $innerPackaging[0]->xpath('PackagedItemRef/PackagedItem/Item/ItemGid/Gid/Xid')[0];
                } elseif (!empty($innerReleaseLine[0]->xpath('PackagedItemRef/PackagedItem/Item/Description'))) {
                    $innerPackageDesc = is_array($innerReleaseLine[0]->xpath('PackagedItemRef/PackagedItem/Item/Description')[0]) ? 0 : $innerReleaseLine[0]->xpath('PackagedItemRef/PackagedItem/Item/Description')[0];
                } else {
                    $innerPackageDesc = $innerPackageType;
                }

                if (!empty($innerPackagingWeightVolume)) {
                    $innerPackageWeightValue = empty($innerPackagingWeightVolume[0]->xpath('Weight/WeightValue')[0]) ? 0 : (string) $innerPackagingWeightVolume[0]->xpath('Weight/WeightValue')[0];
                    $innerPackageWeightUOM = empty($innerPackagingWeightVolume[0]->xpath('Weight/WeightUOMGid/Gid/Xid')[0]) ? 0 : (string) $innerPackagingWeightVolume[0]->xpath('Weight/WeightUOMGid/Gid/Xid')[0];
                    $innerPackageVolumeValue = empty($innerPackagingWeightVolume[0]->xpath('Volume/VolumeValue')[0]) ? 0 : (string) $innerPackagingWeightVolume[0]->xpath('Volume/VolumeValue')[0];
                    $innerPackageVolumeUOM = empty($innerPackagingWeightVolume[0]->xpath('Volume/VolumeUOMGid/Gid/Xid')[0]) ? 0 : (string) $innerPackagingWeightVolume[0]->xpath('Volume/VolumeUOMGid/Gid/Xid')[0];
                } else {
                    $innerPackageWeightValue = empty($innerPackagingWeightVolume[0]->xpath('Weight/WeightValue')[0]) ? 0 : (string) $innerPackagingWeightVolume[0]->xpath('Weight/WeightValue')[0];
                    $innerPackageWeightUOM = empty($innerPackagingWeightVolume[0]->xpath('Weight/WeightUOMGid/Gid/Xid')[0]) ? 0 : (string) $innerPackagingWeightVolume[0]->xpath('Weight/WeightUOMGid/Gid/Xid')[0];
                    $innerPackageVolumeValue = empty($innerPackagingWeightVolume[0]->xpath('Volume/VolumeValue')[0]) ? 0 : (string) $innerPackagingWeightVolume[0]->xpath('Volume/VolumeValue')[0];
                    $innerPackageVolumeUOM = empty($innerPackagingWeightVolume[0]->xpath('Volume/VolumeUOMGid/Gid/Xid')[0]) ? 0 : (string) $innerPackagingWeightVolume[0]->xpath('Volume/VolumeUOMGid/Gid/Xid')[0];
                }
                if (!empty($innerPackagingDimensions)) {
                    $innerPackageLengthValue = empty($innerPackagingDimensions[0]->xpath('Length/LengthValue')[0]) ? 0 : (string) $innerPackagingDimensions[0]->xpath('Length/LengthValue')[0];
                    $innerPackageLengthUOM = empty($innerPackagingDimensions[0]->xpath('Length/LengthUOMGid/Gid/Xid')[0]) ? 0 : (string) $innerPackagingDimensions[0]->xpath('Length/LengthUOMGid/Gid/Xid')[0];
                    $innerPackageWidthValue = empty($innerPackagingDimensions[0]->xpath('Width/WidthValue')[0]) ? 0 : (string) $innerPackagingDimensions[0]->xpath('Width/WidthValue')[0];
                    $innerPackageWidthUOM = empty($innerPackagingDimensions[0]->xpath('Width/WidthUOMGid/Gid/Xid')[0]) ? 0 : (string) $innerPackagingDimensions[0]->xpath('Width/WidthUOMGid/Gid/Xid')[0];
                    $innerPackageHeightValue = empty($innerPackagingDimensions[0]->xpath('Height/HeightValue')[0]) ? 0 : (string) $innerPackagingDimensions[0]->xpath('Height/HeightValue')[0];
                    $innerPackageHeightUOM = empty($innerPackagingDimensions[0]->xpath('Height/HeightUOMGid/Gid/Xid')[0]) ? 0 : (string) $innerPackagingDimensions[0]->xpath('Height/HeightUOMGid/Gid/Xid')[0];
                }
                
                $outerCargos[] = [
                    'externalOuterCargoId' => $innerReleaseLineXid,
                    'outerPackageType' => $innerPackageType,
                    'outerPackageDesc' => $innerPackageDesc,
                    'outerPackageWeightValue' => $innerPackageWeightValue,
                    'outerPackageWeightUOM' => $innerPackageWeightUOM,
                    'outerPackageVolumeValue' => $innerPackageVolumeValue,
                    'outerPackageVolumeUOM' => $innerPackageVolumeUOM,
                    'outerPackageLengthValue' => $innerPackageLengthValue,
                    'outerPackageLengthUOM' => $innerPackageLengthUOM,
                    'outerPackageWidthValue' => $innerPackageWidthValue,
                    'outerPackageWidthUOM' => $innerPackageWidthUOM,
                    'outerPackageHeightValue' => $innerPackageHeightValue,
                    'outerPackageHeightUOM' => $innerPackageHeightUOM,
                    'outerPackageQuantity' => $innerPackageQuantity,
                    'innerCargos' => [],
                ];
            }
        }
    
        return $outerCargos;
    }

	public function getReleaseLineInfo(array $gLogElement): array
	{
		$innerReleaseLines = $gLogElement[0]->xpath('Release/ReleaseLine');
		$shipUnits = empty($gLogElement[0]->xpath('Release/ShipUnit')) ? [] : $gLogElement[0]->xpath('Release/ShipUnit');
		$outerReleaseCargos = [];
		foreach ($innerReleaseLines as $innerReleaseLine) {
			$outerReleaseLineXid = (string)$innerReleaseLine->xpath('ReleaseLineGid/Gid/Xid')[0];
            $incValue = 0;
			if (sizeof($shipUnits) == 0) {
				$incValue++;
			}
			$releaseLineValue = 0;
			$innerReleaseLineXid = 0;
			foreach ($shipUnits as $shipUnit) {
				$releaseLines = $shipUnit->xpath('ShipUnitContent/ReleaseLineGid/Gid');
				$innerReleaseLineXid = (string)$releaseLines[0]->xpath('Xid')[0];
                if ($innerReleaseLineXid == $outerReleaseLineXid) {
					$releaseLineValue++;
				}
			}
			if ($incValue >= 1 || $releaseLineValue == 0) {

				$innerPackaging = $innerReleaseLine->xpath('PackagedItemRef/PackagedItem/Packaging');
				$innerPackagingWeightVolume = $innerPackaging[0]->xpath('PackageShipUnitWeightVolume');
				$innerPackagingDimensions = $innerPackaging[0]->xpath('PackageShipUnitLWH');

				$itemInnerPackaging = $innerReleaseLine->xpath('ItemQuantity/WeightVolume');

				$innerPackageWeightUOM = $innerPackageVolumeUOM = $innerPackageLengthUOM = $innerPackageWidthUOM = $innerPackageHeightUOM = "";
				$innerPackageQuantity = $innerPackageWeightValue = $innerPackageVolumeValue = $innerPackageLengthValue = $innerPackageWidthValue = $innerPackageHeightValue = 0;
				$innerPackageDesc = $innerPackageType = "DEFAULT";
				if(!empty($innerPackaging[0]->xpath('PackagedItemGid')))
				{
					$innerPackageType = is_array($innerPackaging[0]->xpath('PackagedItemGid/Gid/Xid')[0]) ? "DEFAULT" : $innerPackaging[0]->xpath('PackagedItemGid/Gid/Xid')[0];
					$innerPackageDesc = $innerPackageType;
				}
				
                if(!empty($innerPackagingWeightVolume))
				{
					$innerPackageWeightValue = empty((string)$innerPackagingWeightVolume[0]->xpath('Weight/WeightValue')[0]) ? 0 : (string)$innerPackagingWeightVolume[0]->xpath('Weight/WeightValue')[0];
					$innerPackageWeightUOM = empty((string)$innerPackagingWeightVolume[0]->xpath('Weight/WeightUOMGid/Gid/Xid')[0]) ? 'DEFAULT WEIGHT' : (string)$innerPackagingWeightVolume[0]->xpath('Weight/WeightUOMGid/Gid/Xid')[0];
					$innerPackageVolumeValue = empty((string)$innerPackagingWeightVolume[0]->xpath('Volume/VolumeValue')[0]) ? 0 : (string)$innerPackagingWeightVolume[0]->xpath('Volume/VolumeValue')[0];
					$innerPackageVolumeUOM = empty((string)$innerPackagingWeightVolume[0]->xpath('Volume/VolumeUOMGid/Gid/Xid')[0]) ? 'DEFAULT VOLUME' : (string)$innerPackagingWeightVolume[0]->xpath('Volume/VolumeUOMGid/Gid/Xid')[0];
				}
				else
				{
    	            $innerPackageWeightValue = empty((string)$itemInnerPackaging[0]->xpath('Weight/WeightValue')[0]) ? 0 : (string)$itemInnerPackaging[0]->xpath('Weight/WeightValue')[0];
    				$innerPackageWeightUOM = empty((string)$itemInnerPackaging[0]->xpath('Weight/WeightUOMGid/Gid/Xid')[0]) ? 'DEFAULT WEIGHT' : (string)$itemInnerPackaging[0]->xpath('Weight/WeightUOMGid/Gid/Xid')[0];
    				$innerPackageVolumeValue = empty((string)$itemInnerPackaging[0]->xpath('Volume/VolumeValue')[0]) ? 0 : (string)$itemInnerPackaging[0]->xpath('Volume/VolumeValue')[0];
    				$innerPackageVolumeUOM = empty((string)$itemInnerPackaging[0]->xpath('Volume/VolumeUOMGid/Gid/Xid')[0]) ? 'DEFAULT VOLUME' : (string)$itemInnerPackaging[0]->xpath('Volume/VolumeUOMGid/Gid/Xid')[0];
				}
					
				$innerPackageQuantity = empty((string)$innerReleaseLine[0]->xpath('ItemQuantity/PackagedItemCount')[0]) ? "0" : (string)$innerReleaseLine[0]->xpath('ItemQuantity/PackagedItemCount')[0];

				/*if(!empty($innerReleaseLine[0]->xpath('PackagedItemSpecRef/ShipUnitSpecRef/ShipUnitSpecGid')))
				{
					$innerPackageType = is_array($innerReleaseLine[0    ]->xpath('PackagedItemSpecRef/ShipUnitSpecRef/ShipUnitSpecGid/Gid/Xid')[0]) ? 0 : $innerReleaseLine[0]->xpath('PackagedItemSpecRef/ShipUnitSpecRef/ShipUnitSpecGid/Gid/Xid')[0];
				}
				elseif(!empty($innerPackaging[0]->xpath('PackagedItemRef/PackagedItem/Packaging/PackagedItemSpecRef/ShipUnitSpecRef/ShipUnitSpecRef')))
				{
					$innerPackageType = is_array($innerPackaging[0]->xpath('PackagedItemRef/PackagedItemSpecRef/ShipUnitSpecRef/ShipUnitSpecRef/Gid/Xid')[0]) ? 0 : $innerPackaging[0]->xpath('PackagedItemSpecRef/ShipUnitSpecRef/ShipUnitSpecRef/Gid/Xid')[0];
				}
				elseif(!empty($innerReleaseLine[0]->xpath('PackagedItemRef/PackagedItem/Item/ItemGid')))
				{
					$innerPackageType = is_array($innerReleaseLine[0]->xpath('PackagedItemRef/PackagedItem/Item/ItemGid/Gid/Xid')[0]) ? 0 : $innerReleaseLine[0]->xpath('PackagedItemRef/PackagedItem/Item/ItemGid/Gid/Xid')[0];
				}

				if(!empty($innerReleaseLine[0]->xpath('PackagedItemRef/PackagedItem/Item/Description')))
				{
					$innerPackageDesc = is_array($innerReleaseLine[0]->xpath('PackagedItemRef/PackagedItem/Item/Description')[0]) ? 0 : $innerReleaseLine[0]->xpath('PackagedItemRef/PackagedItem/Item/Description')[0];
				}
				elseif(!empty($innerPackaging[0]->xpath('PackagedItemRef/PackagedItem/Item/ItemGid')))
				{
					$innerPackageDesc = is_array($innerPackaging[0]->xpath('PackagedItemRef/PackagedItem/Item/ItemGid/Gid/Xid')[0]) ? 0 : $innerPackaging[0]->xpath('PackagedItemRef/PackagedItem/Item/ItemGid/Gid/Xid')[0];
				}
				else
				{
					$innerPackageDesc = $innerPackageType;
				}*/

				/*if(!empty($innerPackagingWeightVolume))
				{
					$innerPackageWeightValue = empty((string)$innerPackagingWeightVolume[0]->xpath('Weight/WeightValue')[0]) ? 0 : (string)$innerPackagingWeightVolume[0]->xpath('Weight/WeightValue')[0];
					$innerPackageWeightUOM = empty((string)$innerPackagingWeightVolume[0]->xpath('Weight/WeightUOMGid/Gid/Xid')[0]) ? 'DEFAULT WEIGHT' : (string)$innerPackagingWeightVolume[0]->xpath('Weight/WeightUOMGid/Gid/Xid')[0];
					$innerPackageVolumeValue = empty((string)$innerPackagingWeightVolume[0]->xpath('Volume/VolumeValue')[0]) ? 0 : (string)$innerPackagingWeightVolume[0]->xpath('Volume/VolumeValue')[0];
					$innerPackageVolumeUOM = empty((string)$innerPackagingWeightVolume[0]->xpath('Volume/VolumeUOMGid/Gid/Xid')[0]) ? 'DEFAULT VOLUME' : (string)$innerPackagingWeightVolume[0]->xpath('Volume/VolumeUOMGid/Gid/Xid')[0];
				}
				else
				{
					$innerPackageWeightValue = empty((string)$itemInnerPackaging[0]->xpath('Weight/WeightValue')[0]) ? 0 : (string)$itemInnerPackaging[0]->xpath('Weight/WeightValue')[0];
					$innerPackageWeightUOM = empty((string)$itemInnerPackaging[0]->xpath('Weight/WeightUOMGid/Gid/Xid')[0]) ? 'DEFAULT WEIGHT' : (string)$itemInnerPackaging[0]->xpath('Weight/WeightUOMGid/Gid/Xid')[0];
					$innerPackageVolumeValue = empty((string)$itemInnerPackaging[0]->xpath('Volume/VolumeValue')[0]) ? 0 : (string)$itemInnerPackaging[0]->xpath('Volume/VolumeValue')[0];
					$innerPackageVolumeUOM = empty((string)$itemInnerPackaging[0]->xpath('Volume/VolumeUOMGid/Gid/Xid')[0]) ? 'DEFAULT VOLUME' : (string)$itemInnerPackaging[0]->xpath('Volume/VolumeUOMGid/Gid/Xid')[0];
				}*/

				if(!empty($innerPackagingDimensions))
				{
					$innerPackageLengthValue = empty((string)$innerPackagingDimensions[0]->xpath('Length/LengthValue')[0]) ? 0 : (string)$innerPackagingDimensions[0]->xpath('Length/LengthValue')[0];
					if($innerPackageLengthValue != 0){
    					$innerPackageLengthUOM = empty((string)$innerPackagingDimensions[0]->xpath('Length/LengthUOMGid/Gid/Xid')[0]) ? 'DEFAULT' : (string)$innerPackagingDimensions[0]->xpath('Length/LengthUOMGid/Gid/Xid')[0];
					}
					$innerPackageWidthValue = empty((string)$innerPackagingDimensions[0]->xpath('Width/WidthValue')[0]) ? 0 : (string)$innerPackagingDimensions[0]->xpath('Width/WidthValue')[0];
					if($innerPackageWidthValue != 0){
    					$innerPackageWidthUOM = empty((string)$innerPackagingDimensions[0]->xpath('Width/WidthUOMGid/Gid/Xid')[0]) ? 'DEFAULT' : (string)$innerPackagingDimensions[0]->xpath('Width/WidthUOMGid/Gid/Xid')[0];
					}
					$innerPackageHeightValue = empty((string)$innerPackagingDimensions[0]->xpath('Height/HeightValue')[0]) ? 0 : (string)$innerPackagingDimensions[0]->xpath('Height/HeightValue')[0];
					if($innerPackageHeightValue != 0){
    					$innerPackageHeightUOM = empty((string)$innerPackagingDimensions[0]->xpath('Height/HeightUOMGid/Gid/Xid')[0]) ? 'DEFAULT' : (string)$innerPackagingDimensions[0]->xpath('Height/HeightUOMGid/Gid/Xid')[0];
					}
				}

				$releaseLineAry = [];
				$releaseLineAry = [
					'externalOuterCargoId' => $outerReleaseLineXid,
					'outerPackageType' => $innerPackageType,
					'outerPackageDesc' => $innerPackageDesc,
					'outerPackageWeightValue' => $innerPackageWeightValue,
					'outerPackageWeightUOM' => $innerPackageWeightUOM,
					'outerPackageVolumeValue' => $innerPackageVolumeValue,
					'outerPackageVolumeUOM' => $innerPackageVolumeUOM,
					'outerPackageLengthValue' => $innerPackageLengthValue,
					'outerPackageLengthUOM' => $innerPackageLengthUOM,
					'outerPackageWidthValue' => $innerPackageWidthValue,
					'outerPackageWidthUOM' => $innerPackageWidthUOM,
					'outerPackageHeightValue' => $innerPackageHeightValue,
					'outerPackageHeightUOM' => $innerPackageHeightUOM,
					'outerPackageQuantity' => $innerPackageQuantity,
				];

				array_push($outerReleaseCargos, $releaseLineAry);
			}

		}
		return $outerReleaseCargos;
	}
	
	public function getAddonsInfo(array $releaseHeader): array
	{
	    $specialService = empty($releaseHeader[0]->xpath('ReleaseSpecialService')) 
        ? '' 
        : (string) $releaseHeader[0]->xpath('ReleaseSpecialService/SpecialServiceGid/Gid/Xid')[0];
    
        $specialServiceDuration = empty($releaseHeader[0]->xpath('ReleaseSpecialService/Time/Duration')) 
            ? '' 
            : (string) $releaseHeader[0]->xpath('ReleaseSpecialService/Time/Duration/DurationValue')[0];
        
        $specialServiceDurationTime = empty($releaseHeader[0]->xpath('ReleaseSpecialService/Time/Duration')) 
            ? '' 
            : (string) $releaseHeader[0]->xpath('ReleaseSpecialService/Time/Duration/DurationUOMGid/Gid/Xid')[0];
        
        $accessorialCode = empty($releaseHeader[0]->xpath('AccessorialCodeGid')) 
            ? '' 
            : (string) $releaseHeader[0]->xpath('AccessorialCodeGid/Gid/Xid')[0];
        
        $addonsAry = [];
        
        if ($accessorialCode !== '') {
            $addonsAry[] = $accessorialCode;
        }
        if ($specialService !== '') {
            $addonsAry[] = $specialService;
        }
        if ($specialServiceDuration !== '') {
            $addonsAry[] = $specialServiceDuration;
        }
        if ($specialServiceDurationTime !== '') {
            $addonsAry[] = $specialServiceDurationTime;
        }
        
        return $addonsAry;
	}

	public function getManageReferences(array $gLogElement): array
	{
		$releaseRefNums = empty($gLogElement[0]->xpath('Release/ReleaseRefnum')) ? [] : $gLogElement[0]->xpath('Release/ReleaseRefnum');
		$referencesAry = [];
		foreach ($releaseRefNums as $releaseRefNum)
		{
			$refCode = empty($releaseRefNum->xpath('ReleaseRefnumQualifierGid/Gid/Xid')[0]) ? 'DEFAULT' : $releaseRefNum->xpath('ReleaseRefnumQualifierGid/Gid/Xid')[0];
			$refValue = (string)$releaseRefNum->xpath('ReleaseRefnumValue')[0];
			$references = [];
			array_push($references ,$refCode);
			array_push($references, $refValue);
			array_push($referencesAry, $references);
		}

		return $referencesAry;
	}

	public function getRemarks(array $gLogElement): array
	{
		$releaseRemarks = empty($gLogElement[0]->xpath('Release/Remark')) ? [] : $gLogElement[0]->xpath('Release/Remark');
		$remarksAry = [];
		foreach ($releaseRemarks as $remark)
		{
			$remarkCode = empty($remark->xpath('RemarkQualifierGid/Gid/Xid')[0]) ? 'DEFAULT' : $remark->xpath('RemarkQualifierGid/Gid/Xid')[0];
			$remarkValue = (string)$remark->xpath('RemarkText')[0];
			$remarks = [];
			array_push($remarks ,$remarkCode);
			array_push($remarks, $remarkValue);
			array_push($remarksAry, $remarks);
		}
		return $remarksAry;
	}

	public function getInvolvedParties(array $gLogElement): array
	{
		$involvedParties = empty($gLogElement[0]->xpath('Release/InvolvedParty')) ? [] : $gLogElement[0]->xpath('Release/InvolvedParty');
		$involvedPartiesAry = [];
		foreach ($involvedParties as $involvedParty)
		{
			$partyType = empty((string)$involvedParty->xpath('InvolvedPartyQualifierGid/Gid/Xid')[0]) ? "" : (string)$involvedParty->xpath('InvolvedPartyQualifierGid/Gid/Xid')[0];
			$id = empty($involvedParty->xpath('ContactRef/Contact/ContactGid/Gid/Xid')) ? "" : (string)$involvedParty->xpath('ContactRef/Contact/ContactGid/Gid/Xid')[0];
			$email = empty($involvedParty->xpath('ContactRef/Contact/EmailAddress')) ? "" : (string)$involvedParty->xpath('ContactRef/Contact/EmailAddress')[0];
			$firstName = empty($involvedParty->xpath('ContactRef/Contact/FirstName')) ? "" : (string)$involvedParty->xpath('ContactRef/Contact/FirstName')[0];
			$phone = empty($involvedParty->xpath('ContactRef/Contact/Phone1')) ? "" : (string)$involvedParty->xpath('ContactRef/Contact/Phone1')[0];
			$parties = [];
			$parties = [
				'partyType' => $partyType,
				'id' => $id,
				'email' => $email,
				'firstName' => $firstName,
				'phone' => $phone
			];
			array_push($involvedPartiesAry, $parties);
		}
		return $involvedPartiesAry;
	}

	public function setHeaderInfo(string $bookingId): string
	{
	    $date = date("YYMMDDHHMMSS");
	    $senderTransmissionNo = $bookingId . "_" . $date;
		$headerInfo = '<SVKEDIOrderHeader>';
		$headerInfo .= '<Version>1.0</Version>';
		$headerInfo .= '<UserName>SVKONEKT</UserName>';
		$headerInfo .= '<Password>SVKONEKT</Password>';
		$headerInfo .= '<SenderTransmissionNo>' . $senderTransmissionNo . '</SenderTransmissionNo>';
		$headerInfo .= '<AckSpec>';
		$headerInfo .= '<EmailAddress>dummy@email.com</EmailAddress>';
		$headerInfo .= '<AckOption>SUCCESS</AckOption>';
		$headerInfo .= '</AckSpec>';
		$headerInfo .= '<SourceApp>OTM</SourceApp>';
		$headerInfo .= '<DestinationApp>SVKONEKT</DestinationApp>';
		$headerInfo .= '<ReferenceId>Booking</ReferenceId>';
		$headerInfo .= '<Action>IU</Action>';
		$headerInfo .= '</SVKEDIOrderHeader>';

		return $headerInfo;
	}

	public function setOrganizationInfo(array $organizationAry, string $domainName): string
	{
	    $emptyValue = $logicalReceiver = "";
	    $logicalReceiver = $this->ci->OtmBookingModel->getLogicalReceiver($organizationAry['organizationId'], $organizationAry['businessEntityValue']);
		$organizationInfo = '<SVKOrgDetails>';
		$organizationInfo .= '<CompanyCode>' . $organizationAry['organizationId'] . '</CompanyCode>';
		$organizationInfo .= '<BranchCode>'.$organizationAry['businessEntityValue'].'</BranchCode>';
		$organizationInfo .= '<DepartmentCode/>';
		$organizationInfo .= '<PhysicalReceiver>'.$emptyValue.'</PhysicalReceiver>';
		$organizationInfo .= '<LogicalReceiver>'.$logicalReceiver.'</LogicalReceiver>';
		$organizationInfo .= '<LogicalSender>'.$emptyValue.'</LogicalSender>';
		$organizationInfo .= '<PhysicalSender>'.$emptyValue.'</PhysicalSender>';
		$organizationInfo .= '</SVKOrgDetails>';

		return $organizationInfo;
	}

	public function setBookingInfo(string $bookingId): string
	{
	    $bookingInfo = '<OrderID>'.$bookingId.'</OrderID>';
		$bookingInfo .= '<EXTOrderID>'.$bookingId.'</EXTOrderID>';
		return $bookingInfo;
	}

	public function setBookingHeaderInfo(array $organizationAry, array $gLogElement): string
	{
		$orderType = $modeOfTransport = "DEFAULT";
		/*$orderType = $this->ci->OtmBookingModel->getOrderType($organizationAry['organizationId'], $organizationAry['businessEntityValue']);
		$modeOfTransport = $this->ci->OtmBookingModel->getModeOfTransport($organizationAry['organizationId'], $organizationAry['businessEntityValue']);*/
		if(!empty($gLogElement[0]->xpath('Release/ReleaseTypeGid/Gid/Xid')[0]))
		{
			$orderType = empty((string)$gLogElement[0]->xpath('Release/ReleaseTypeGid/Gid/Xid')[0]) ? "DEFAULT" : (string)$gLogElement[0]->xpath('Release/ReleaseTypeGid/Gid/Xid')[0];
		}
		if(!empty($gLogElement[0]->xpath('Release/ReleaseHeader/TransportModeGid/Gid/Xid')[0]))
		{
			$modeOfTransport = empty((string)$gLogElement[0]->xpath('Release/ReleaseHeader/TransportModeGid/Gid/Xid')[0]) ? "DEFAULT" : (string)$gLogElement[0]->xpath('Release/ReleaseHeader/TransportModeGid/Gid/Xid')[0];
		}
		$incoTerm = "";
		if(!empty($gLogElement[0]->xpath('Release/ReleaseHeader/CommercialTerms/IncoTermGid/Gid/Xid')[0]))
		{
			$incoTerm = empty((string)$gLogElement[0]->xpath('Release/ReleaseHeader/CommercialTerms/IncoTermGid/Gid/Xid')[0]) ? "" : (string)$gLogElement[0]->xpath('Release/ReleaseHeader/CommercialTerms/IncoTermGid/Gid/Xid')[0];
		}
		$vehicleType = "";
		if(!empty($gLogElement[0]->xpath('Release/ReleaseHeader/EquipmentGroupGid/Gid/Xid')[0]))
		{
			$vehicleType = empty((string)$gLogElement[0]->xpath('Release/ReleaseHeader/EquipmentGroupGid/Gid/Xid')[0]) ? "" : (string)$gLogElement[0]->xpath('Release/ReleaseHeader/EquipmentGroupGid/Gid/Xid')[0];
		}
		
		$emptyValue = "";
		$bookingHeaderInfo = '<Transits><TransitLegId/></Transits>';
		$bookingHeaderInfo = '<OrderType>'.$orderType.'</OrderType>';
		$bookingHeaderInfo .= '<ModeOfTransport>'.$modeOfTransport.'</ModeOfTransport>';
		$bookingHeaderInfo .= '<VehicleType>'.$vehicleType.'</VehicleType>';
		$bookingHeaderInfo .= '<Product>'.$emptyValue.'</Product>';
		$bookingHeaderInfo .= '<ServiceType>'.$emptyValue.'</ServiceType>';
		$bookingHeaderInfo .= '<TypeOfBusiness>'.$emptyValue.'</TypeOfBusiness>';
		$bookingHeaderInfo .= '<TermsOfTrade>';
		$bookingHeaderInfo .= '<Incoterm>'.$incoTerm.'</Incoterm>';
		$bookingHeaderInfo .= '<FreightTerm>';
		$bookingHeaderInfo .= '<Term>'.$emptyValue.'</Term>';
		$bookingHeaderInfo .= '<Name>'.$emptyValue.'</Name>';
		$bookingHeaderInfo .= '</FreightTerm>';
		$bookingHeaderInfo .= '</TermsOfTrade>';

		return $bookingHeaderInfo;
	}

	public function setCustomerInfo(array $involvedPartiesAry): string
	{
		$customerInfo = $emptyValue = "";
		//foreach ($involvedPartiesAry as $involvedParties) {
		    //print_r(json_encode($involvedParties));
			//if (strtoupper($involvedParties['partyType']) == 'CUSTOMER') {
				$customerInfo = '';
				$customerInfo .= '<CustomerDetails>';
				$customerInfo .= '<ID>' . $involvedPartiesAry['customerId'] . '</ID>';
				$customerInfo .= '<Company>';
				$customerInfo .= '<Name>' . $involvedPartiesAry['customerName'] . '</Name>';
				$customerInfo .= '<RegistrationNumber>' . $involvedPartiesAry['registrationNumber'] . '</RegistrationNumber>';
				$customerInfo .= '</Company>';
				$customerInfo .= '<Address>';
				$customerInfo .= '<Address1>' . $involvedPartiesAry['address1'] . '</Address1>';
				$customerInfo .= '<Address2>' . $involvedPartiesAry['address2'] . '</Address2>';
				$customerInfo .= '<Street>' . $involvedPartiesAry['street'] . '</Street>';
				$customerInfo .= '<City>' . $involvedPartiesAry['city'] . '</City>';
				$customerInfo .= '<Province>' . $involvedPartiesAry['province'] . '</Province>';
				$customerInfo .= '<State>' . $involvedPartiesAry['state'] . '</State>';
				$customerInfo .= '<Postal>' . $involvedPartiesAry['postal'] . '</Postal>';
				$customerInfo .= '<Country>' . $involvedPartiesAry['country'] . '</Country>';
				$customerInfo .= '<Latitude>' . $involvedPartiesAry['latitude'] . '</Latitude>';
				$customerInfo .= '<Longitude>' . $involvedPartiesAry['longitude'] . '</Longitude>';
				$customerInfo .= '<ContactInfo>';
				$customerInfo .= '<CountryCode>' . $involvedPartiesAry['countryCode'] . '</CountryCode>';
				$customerInfo .= '<ContactNo>' . $involvedPartiesAry['contactNo'] . '</ContactNo>';
				$customerInfo .= '<EmailAddress>' . $involvedPartiesAry['emailAddress'] . '</EmailAddress>';
				$customerInfo .= '</ContactInfo>';
				$customerInfo .= '</Address>';
				$customerInfo .= '</CustomerDetails>';
			//}
		//}
		if($customerInfo == "")
		{
			$customerInfo = '';
			$customerInfo .= '<CustomerDetails>';
			$customerInfo .= '<ID>' . "ALL" . '</ID>';
			$customerInfo .= '<Company>';
			$customerInfo .= '<Name>' . "ALL" . '</Name>';
			$customerInfo .= '<RegistrationNumber>' . "ALL" . '</RegistrationNumber>';
			$customerInfo .= '</Company>';
			$customerInfo .= '<Address>';
			$customerInfo .= '<Address1>' . $emptyValue . '</Address1>';
			$customerInfo .= '<Address2>' . $emptyValue . '</Address2>';
			$customerInfo .= '<Street>' . $emptyValue . '</Street>';
			$customerInfo .= '<City>' . $emptyValue . '</City>';
			$customerInfo .= '<Province>' . $emptyValue . '</Province>';
			$customerInfo .= '<State>' . $emptyValue . '</State>';
			$customerInfo .= '<Postal>' . $emptyValue . '</Postal>';
			$customerInfo .= '<Country>' . $emptyValue . '</Country>';
			$customerInfo .= '<Latitude>' . $emptyValue . '</Latitude>';
			$customerInfo .= '<Longitude>' . $emptyValue . '</Longitude>';
			$customerInfo .= '<ContactInfo>';
			$customerInfo .= '<CountryCode>' . $emptyValue . '</CountryCode>';
			$customerInfo .= '<ContactNo>' . $emptyValue . '</ContactNo>';
			$customerInfo .= '<EmailAddress>' . $emptyValue . '</EmailAddress>';
			$customerInfo .= '</ContactInfo>';
			$customerInfo .= '</Address>';
			$customerInfo .= '</CustomerDetails>';
		}
		return $customerInfo;
	}
	/*public function setCustomerInfo(array $involvedPartiesAry): string
	{
		$customerInfo = $emptyValue = "";
		foreach ($involvedPartiesAry as $involvedParties) {
			if (strtoupper($involvedParties['partyType']) == 'CUSTOMER') {
				$customerInfo = '';
				$customerInfo .= '<CustomerDetails>';
				$customerInfo .= '<ID>' . $involvedParties['id'] . '</ID>';
				$customerInfo .= '<Company>';
				$customerInfo .= '<Name>' . $involvedParties['id'] . '</Name>';
				$customerInfo .= '<RegistrationNumber>' . $involvedParties['id'] . '</RegistrationNumber>';
				$customerInfo .= '</Company>';
				$customerInfo .= '<Address>';
				$customerInfo .= '<Address1>' . $emptyValue . '</Address1>';
				$customerInfo .= '<Address2>' . $emptyValue . '</Address2>';
				$customerInfo .= '<Street>' . $emptyValue . '</Street>';
				$customerInfo .= '<City>' . $emptyValue . '</City>';
				$customerInfo .= '<Province>' . $emptyValue . '</Province>';
				$customerInfo .= '<State>' . $emptyValue . '</State>';
				$customerInfo .= '<Postal>' . $emptyValue . '</Postal>';
				$customerInfo .= '<Country>' . $emptyValue . '</Country>';
				$customerInfo .= '<Latitude>' . $emptyValue . '</Latitude>';
				$customerInfo .= '<Longitude>' . $emptyValue . '</Longitude>';
				$customerInfo .= '<ContactInfo>';
				$customerInfo .= '<CountryCode>' . $emptyValue . '</CountryCode>';
				$customerInfo .= '<ContactNo>' . $involvedParties['phone'] . '</ContactNo>';
				$customerInfo .= '<EmailAddress>' . $involvedParties['email'] . '</EmailAddress>';
				$customerInfo .= '</ContactInfo>';
				$customerInfo .= '</Address>';
				$customerInfo .= '</CustomerDetails>';
			}
		}
		if($customerInfo == "")
		{
			$customerInfo = '';
			$customerInfo .= '<CustomerDetails>';
			$customerInfo .= '<ID>' . "ALL" . '</ID>';
			$customerInfo .= '<Company>';
			$customerInfo .= '<Name>' . "ALL" . '</Name>';
			$customerInfo .= '<RegistrationNumber>' . "ALL" . '</RegistrationNumber>';
			$customerInfo .= '</Company>';
			$customerInfo .= '<Address>';
			$customerInfo .= '<Address1>' . $emptyValue . '</Address1>';
			$customerInfo .= '<Address2>' . $emptyValue . '</Address2>';
			$customerInfo .= '<Street>' . $emptyValue . '</Street>';
			$customerInfo .= '<City>' . $emptyValue . '</City>';
			$customerInfo .= '<Province>' . $emptyValue . '</Province>';
			$customerInfo .= '<State>' . $emptyValue . '</State>';
			$customerInfo .= '<Postal>' . $emptyValue . '</Postal>';
			$customerInfo .= '<Country>' . $emptyValue . '</Country>';
			$customerInfo .= '<Latitude>' . $emptyValue . '</Latitude>';
			$customerInfo .= '<Longitude>' . $emptyValue . '</Longitude>';
			$customerInfo .= '<ContactInfo>';
			$customerInfo .= '<CountryCode>' . $emptyValue . '</CountryCode>';
			$customerInfo .= '<ContactNo>' . $emptyValue . '</ContactNo>';
			$customerInfo .= '<EmailAddress>' . $emptyValue . '</EmailAddress>';
			$customerInfo .= '</ContactInfo>';
			$customerInfo .= '</Address>';
			$customerInfo .= '</CustomerDetails>';
		}
		return $customerInfo;
	}*/
	
	public function setCarrierInfo(array $carrierAry): string
	{
		$carrierInfo = $emptyValue = "";
		$carrierInfo = '';
		$carrierInfo .= '<CarrierDetails>';
		$carrierInfo .= '<ID>' . $carrierAry['carrierId'] . '</ID>';
		$carrierInfo .= '<Company>';
		$carrierInfo .= '<Name>' . $carrierAry['carrierName'] . '</Name>';
		$carrierInfo .= '<RegistrationNumber>' . $carrierAry['registrationNumber'] . '</RegistrationNumber>';
		$carrierInfo .= '</Company>';
		$carrierInfo .= '<Address>';
		$carrierInfo .= '<Address1>' . $carrierAry['address1'] . '</Address1>';
		$carrierInfo .= '<Address2>' . $carrierAry['address2'] . '</Address2>';
		$carrierInfo .= '<Street>' . $carrierAry['street'] . '</Street>';
		$carrierInfo .= '<City>' . $carrierAry['city'] . '</City>';
		$carrierInfo .= '<Province>' . $carrierAry['province'] . '</Province>';
		$carrierInfo .= '<State>' . $carrierAry['state'] . '</State>';
		$carrierInfo .= '<Postal>' . $carrierAry['postal'] . '</Postal>';
		$carrierInfo .= '<Country>' . $carrierAry['country'] . '</Country>';
		$carrierInfo .= '<Latitude>' . $carrierAry['latitude'] . '</Latitude>';
		$carrierInfo .= '<Longitude>' . $carrierAry['longitude'] . '</Longitude>';
		$carrierInfo .= '<ContactInfo>';
		$carrierInfo .= '<CountryCode>' . $carrierAry['countryCode'] . '</CountryCode>';
		$carrierInfo .= '<ContactNo>' . $carrierAry['contactNo'] . '</ContactNo>';
		$carrierInfo .= '<EmailAddress>' . $carrierAry['emailAddress'] . '</EmailAddress>';
		$carrierInfo .= '</ContactInfo>';
		$carrierInfo .= '</Address>';
		$carrierInfo .= '</CarrierDetails>';
		
		return $carrierInfo;
	}

	public function setShipFromLocationInfo(array $sourceAry, array $timeWindowAry): string
	{
		$emptyValue = $sourceInfo = $earlyPickupDate = $earlyPickupTimeZone = $latePickupDate = $latePickupTimeZone = $street = "";
		
		foreach($sourceAry["shipFromAddressAry"] ?? [] as $eachSeqLine){
            $street .= $eachSeqLine;
        }

		$sourceInfo .= '<Source>';
		$sourceInfo .= '<ID>'.$sourceAry['shipFromLocationId'].'</ID>';
		$sourceInfo .= '<Company>';
		$sourceInfo .= '<Name>'.$sourceAry['shipFromLocationName'].'</Name>';
		$sourceInfo .= '<RegistrationNumber>'.$sourceAry['shipFromLocationId'].'</RegistrationNumber>';
		$sourceInfo .= '</Company>';
		$sourceInfo .= '<Address>';
		$sourceInfo .= '<Address1>'.(empty($sourceAry['shipFromAddressAry'][0]) ? "" : $sourceAry['shipFromAddressAry'][0]).'</Address1>';
		$sourceInfo .= '<Address2>'.(empty($sourceAry['shipFromAddressAry'][1]) ? "" : $sourceAry['shipFromAddressAry'][1]).'</Address2>';
		$sourceInfo .= '<Street>'.$street.'</Street>';
		$sourceInfo .= '<City>'.$sourceAry['shipFromCity'].'</City>';
		$sourceInfo .= '<Province>'.(empty($sourceAry['shipFromProvince']) ? $sourceAry['shipFromProvinceCode'] : $sourceAry['shipFromProvince']).'</Province>';
		$sourceInfo .= '<State>'.$sourceAry['shipFromProvinceCode'].'</State>';
		$sourceInfo .= '<Postal>'.(empty($sourceAry['shipFromPostalCode']) ? (empty($sourceAry['shipFromAddressAry'][2]) ? "" : $sourceAry['shipFromAddressAry'][2]) : $sourceAry['shipFromPostalCode']).'</Postal>';
		$sourceInfo .= '<Country>'.$sourceAry['shipFromCountryCode'].'</Country>';
		$sourceInfo .= '<Latitude>'.$sourceAry['shipFromLatitude'].'</Latitude>';
		$sourceInfo .= '<Longitude>'.$sourceAry['shipFromLongitude'].'</Longitude>';
		$sourceInfo .= '<ContactInfo>';
		$sourceInfo .= '<CountryCode>'.$sourceAry['shipFromCountryCode'].'</CountryCode>';
		$sourceInfo .= '<ContactNo>'.$emptyValue.'</ContactNo>';
		$sourceInfo .= '<EmailAddress>'.$emptyValue.'</EmailAddress>';
		$sourceInfo .= '</ContactInfo>';
		$sourceInfo .= '</Address>';

		$earlyPickupDate = $timeWindowAry['earlyPickupDate'];
		$earlyPickupTimeZone = $timeWindowAry['earlyPickupTimeZone'];
		$latePickupDate = $timeWindowAry['latePickupDate'];
		$latePickupTimeZone = $timeWindowAry['latePickupTimeZone'];

		$sourceInfo .= '<EstimatedDateTime>';
		$sourceInfo .= '<From>';
		$sourceInfo .= '<DateTime>'.$earlyPickupDate.'</DateTime>';
		$sourceInfo .= '<TimeZone>'.$earlyPickupTimeZone.'</TimeZone>';
		$sourceInfo .= '<UTC>';
		$sourceInfo .= '<Time>'.$earlyPickupDate.'</Time>';
		$sourceInfo .= '</UTC>';
		$sourceInfo .= '</From>';
		$sourceInfo .= '<To>';
		$sourceInfo .= '<DateTime>'.$latePickupDate.'</DateTime>';
		$sourceInfo .= '<TimeZone>'.$latePickupTimeZone.'</TimeZone>';
		$sourceInfo .= '<UTC>';
		$sourceInfo .= '<Time>'.$latePickupDate.'</Time>';
		$sourceInfo .= '</UTC>';
		$sourceInfo .= '</To>';
		$sourceInfo .= '</EstimatedDateTime>';
		$sourceInfo .= '</Source>';

		return $sourceInfo;
	}

	public function setShipToLocationInfo(array $destinationAry, array $timeWindowAry): string
	{
		$emptyValue = $destinationInfo = $earlyDeliveryDate = $earlyDeliveryTimeZone = $lateDeliveryDate = $lateDeliveryTimeZone =  $street = '';
		foreach($destinationAry["shipToAddressAry"] ?? [] as $eachSeqLine){
            $street .= $eachSeqLine;
        }
		$destinationInfo .= '<Destination>';
		$destinationInfo .= '<ID>'.$destinationAry['shipToLocationId'].'</ID>';
		$destinationInfo .= '<Company>';
		$destinationInfo .= '<Name>'.$destinationAry['shipToLocationName'].'</Name>';
		$destinationInfo .= '<RegistrationNumber>'.$destinationAry['shipToLocationId'].'</RegistrationNumber>';
		$destinationInfo .= '</Company>';
		$destinationInfo .= '<Address>';
		$destinationInfo .= '<Address1>'.(empty($destinationAry['shipToAddressAry'][0]) ? "" : $destinationAry['shipToAddressAry'][0]).'</Address1>';
		$destinationInfo .= '<Address2>'.(empty($destinationAry['shipToAddressAry'][1]) ? "" : $destinationAry['shipToAddressAry'][1]).'</Address2>';
		$destinationInfo .= '<Street>'.$street.'</Street>';
		$destinationInfo .= '<City>'.$destinationAry['shipToCity'].'</City>';
		$destinationInfo .= '<Province>'.(empty($destinationAry['shipToProvince']) ? $destinationAry['shipToProvinceCode'] : $destinationAry['shipToProvince']).'</Province>';
		$destinationInfo .= '<State>'.$destinationAry['shipToProvinceCode'].'</State>';
		$destinationInfo .= '<Postal>'.(empty($destinationAry['shipToPostalCode']) ? (empty($destinationAry['shipToAddressAry'][2]) ? "" : $destinationAry['shipToAddressAry'][2]) : $destinationAry['shipToPostalCode']).'</Postal>';
		$destinationInfo .= '<Country>'.$destinationAry['shipToCountryCode'].'</Country>';
		$destinationInfo .= '<Latitude>'.$destinationAry['shipToLatitude'].'</Latitude>';
		$destinationInfo .= '<Longitude>'.$destinationAry['shipToLongitude'].'</Longitude>';
		$destinationInfo .= '<ContactInfo>';
		$destinationInfo .= '<CountryCode>'.$destinationAry['shipToCountryCode'].'</CountryCode>';
		$destinationInfo .= '<ContactNo>'.$emptyValue.'</ContactNo>';
		$destinationInfo .= '<EmailAddress>'.$emptyValue.'</EmailAddress>';
		$destinationInfo .= '</ContactInfo>';
		$destinationInfo .= '</Address>';

		$earlyDeliveryDate = $timeWindowAry['earlyDeliveryDate'];
		$earlyDeliveryTimeZone = $timeWindowAry['earlyDeliveryTimeZone'];
		$lateDeliveryDate = $timeWindowAry['lateDeliveryDate'];
		$lateDeliveryTimeZone = $timeWindowAry['lateDeliveryTimeZone'];

		$destinationInfo .= '<EstimatedDateTime>';
		$destinationInfo .= '<From>';
		$destinationInfo .= '<DateTime>'.$earlyDeliveryDate.'</DateTime>';
		$destinationInfo .= '<TimeZone>'.$earlyDeliveryTimeZone.'</TimeZone>';
		$destinationInfo .= '<UTC>';
		$destinationInfo .= '<Time>'.$earlyDeliveryDate.'</Time>';
		$destinationInfo .= '</UTC>';
		$destinationInfo .= '</From>';
		$destinationInfo .= '<To>';
		$destinationInfo .= '<DateTime>'.$lateDeliveryDate.'</DateTime>';
		$destinationInfo .= '<TimeZone>'.$lateDeliveryTimeZone.'</TimeZone>';
		$destinationInfo .= '<UTC>';
		$destinationInfo .= '<Time>'.$lateDeliveryDate.'</Time>';
		$destinationInfo .= '</UTC>';
		$destinationInfo .= '</To>';
		$destinationInfo .= '</EstimatedDateTime>';
		$destinationInfo .= '</Destination>';

		return $destinationInfo;
	}

	public function setInvolvedPartiesInfo(array $involvedPartiesAry, array $sourceAry, array $destinationAry, array $customerAry, array $carrierAry): string
	{
		$emptyValue = $involvedPartiesInfo = "";
		$shipper = $consignee = $carrier = $customer= $pickup = $delivery = 0;
		foreach ($involvedPartiesAry as $involvedParties) {
		    if(strtoupper($involvedParties['partyType'])=='CUSTOMER')
			{
				$customer++;
			}
			if(strtoupper($involvedParties['partyType'])=='SHIPPER')
			{
				$shipper++;
			}
			else if(strtoupper($involvedParties['partyType'])=='CONSIGNEE')
			{
				$consignee++;
			}
			/*else if(strtoupper($involvedParties['partyType'])=='CUSTOMER')
			{
				$customer++;
			}
			else if(strtoupper($involvedParties['partyType'])=='PICKUP')
			{
				$pickup++;
			}
			else if(strtoupper($involvedParties['partyType'])=='DELIVERY')
			{
				$delivery++;
			}*/
			$involvedPartiesInfo .= '<PartyType>';
			$involvedPartiesInfo .= '<Type>' . strtoupper($involvedParties['partyType']) . '</Type>';
			$involvedPartiesInfo .= '<ID>' . $involvedParties['id'] . '</ID>';
			$involvedPartiesInfo .= '<Company>';
			$involvedPartiesInfo .= '<Name>' . $involvedParties['id'] . '</Name>';
			$involvedPartiesInfo .= '<RegistrationNumber>' . $involvedParties['id'] . '</RegistrationNumber>';
			$involvedPartiesInfo .= '</Company>';
			$involvedPartiesInfo .= '<Address>';
			$involvedPartiesInfo .= '<Address1>' . $emptyValue . '</Address1>';
			$involvedPartiesInfo .= '<Address2>' . $emptyValue . '</Address2>';
			$involvedPartiesInfo .= '<Street>' . $emptyValue . '</Street>';
			$involvedPartiesInfo .= '<City>' . $emptyValue . '</City>';
			$involvedPartiesInfo .= '<Province>' . $emptyValue . '</Province>';
			$involvedPartiesInfo .= '<State>' . $emptyValue . '</State>';
			$involvedPartiesInfo .= '<Postal>' . $emptyValue . '</Postal>';
			$involvedPartiesInfo .= '<Country>' . $emptyValue . '</Country>';
			$involvedPartiesInfo .= '<Latitude>' . $emptyValue . '</Latitude>';
			$involvedPartiesInfo .= '<Longitude>' . $emptyValue . '</Longitude>';
			$involvedPartiesInfo .= '<ContactInfo>';
			$involvedPartiesInfo .= '<CountryCode>' . $emptyValue . '</CountryCode>';
			$involvedPartiesInfo .= '<ContactNo>' . $involvedParties['phone'] . '</ContactNo>';
			$involvedPartiesInfo .= '<EmailAddress>' . $involvedParties['email'] . '</EmailAddress>';
			$involvedPartiesInfo .= '</ContactInfo>';
			$involvedPartiesInfo .= '</Address>';
			$involvedPartiesInfo .= '</PartyType>';
		}
		if($customer==0)
		{
			$involvedPartiesInfo .= '<PartyType>';
			$involvedPartiesInfo .= '<Type>CUSTOMER</Type>';
			$involvedPartiesInfo .= '<ID>'.$customerAry['customerId'].'</ID>';
			$involvedPartiesInfo .= '<Company>';
			$involvedPartiesInfo .= '<Name>'.$customerAry['customerName'].'</Name>';
			$involvedPartiesInfo .= '<RegistrationNumber>'.$customerAry['registrationNumber'].'</RegistrationNumber>';
			$involvedPartiesInfo .= '</Company>';
			$involvedPartiesInfo .= '<Address>';
			$involvedPartiesInfo .= '<Address1>'.$customerAry['address1'].'</Address1>';
			$involvedPartiesInfo .= '<Address2>'.$customerAry['address2'].'</Address2>';
			$involvedPartiesInfo .= '<Street>'.$customerAry['street'].'</Street>';
			$involvedPartiesInfo .= '<City>'.$customerAry['city'].'</City>';
			$involvedPartiesInfo .= '<Province>'.($customerAry['province'] ?? $customerAry['state']).'</Province>';
			$involvedPartiesInfo .= '<State>'.$customerAry['state'].'</State>';
			$involvedPartiesInfo .= '<Postal>'.$customerAry['postal'].'</Postal>';
			$involvedPartiesInfo .= '<Country>'.$customerAry['country'].'</Country>';
			$involvedPartiesInfo .= '<Latitude>'.$customerAry['latitude'].'</Latitude>';
			$involvedPartiesInfo .= '<Longitude>'.$customerAry['longitude'].'</Longitude>';
			$involvedPartiesInfo .= '<ContactInfo>';
			$involvedPartiesInfo .= '<CountryCode>'.$customerAry['countryCode'].'</CountryCode>';
			$involvedPartiesInfo .= '<ContactNo>'.$customerAry['contactNo'].'</ContactNo>';
			$involvedPartiesInfo .= '<EmailAddress>'.$customerAry['emailAddress'].'</EmailAddress>';
			$involvedPartiesInfo .= '</ContactInfo>';
			$involvedPartiesInfo .= '</Address>';
			$involvedPartiesInfo .= '</PartyType>';
		}
		if($carrier==0 && $carrierAry <> [])
		{
			$involvedPartiesInfo .= '<PartyType>';
			$involvedPartiesInfo .= '<Type>CARRIER</Type>';
			$involvedPartiesInfo .= '<ID>'.$carrierAry['carrierId'].'</ID>';
			$involvedPartiesInfo .= '<Company>';
			$involvedPartiesInfo .= '<Name>'.$carrierAry['carrierName'].'</Name>';
			$involvedPartiesInfo .= '<RegistrationNumber>'.$carrierAry['registrationNumber'].'</RegistrationNumber>';
			$involvedPartiesInfo .= '</Company>';
			$involvedPartiesInfo .= '<Address>';
			$involvedPartiesInfo .= '<Address1>'.$carrierAry['address1'].'</Address1>';
			$involvedPartiesInfo .= '<Address2>'.$carrierAry['address2'].'</Address2>';
			$involvedPartiesInfo .= '<Street>'.$carrierAry['street'].'</Street>';
			$involvedPartiesInfo .= '<City>'.$carrierAry['city'].'</City>';
			$involvedPartiesInfo .= '<Province>'.($carrierAry['province'] ?? $carrierAry['state']).'</Province>';
			$involvedPartiesInfo .= '<State>'.$carrierAry['state'].'</State>';
			$involvedPartiesInfo .= '<Postal>'.$carrierAry['postal'].'</Postal>';
			$involvedPartiesInfo .= '<Country>'.$carrierAry['country'].'</Country>';
			$involvedPartiesInfo .= '<Latitude>'.$carrierAry['latitude'].'</Latitude>';
			$involvedPartiesInfo .= '<Longitude>'.$carrierAry['longitude'].'</Longitude>';
			$involvedPartiesInfo .= '<ContactInfo>';
			$involvedPartiesInfo .= '<CountryCode>'.$carrierAry['countryCode'].'</CountryCode>';
			$involvedPartiesInfo .= '<ContactNo>'.$carrierAry['contactNo'].'</ContactNo>';
			$involvedPartiesInfo .= '<EmailAddress>'.$carrierAry['emailAddress'].'</EmailAddress>';
			$involvedPartiesInfo .= '</ContactInfo>';
			$involvedPartiesInfo .= '</Address>';
			$involvedPartiesInfo .= '</PartyType>';
		}
		if($shipper==0)
		{
		    $street = "";
            foreach($sourceAry["shipFromAddressAry"] ?? [] as $eachSeqLine){
                $street .= $eachSeqLine;
            }
			$involvedPartiesInfo .= '<PartyType>';
			$involvedPartiesInfo .= '<Type>SHIPPER</Type>';
			$involvedPartiesInfo .= '<ID>'.$sourceAry['shipFromLocationId'].'</ID>';
			$involvedPartiesInfo .= '<Company>';
			$involvedPartiesInfo .= '<Name>'.$sourceAry['shipFromLocationName'].'</Name>';
			$involvedPartiesInfo .= '<RegistrationNumber>'.$sourceAry['shipFromLocationId'].'</RegistrationNumber>';
			$involvedPartiesInfo .= '</Company>';
			$involvedPartiesInfo .= '<Address>';
			$involvedPartiesInfo .= '<Address1>'.(empty($sourceAry['shipFromAddressAry'][0]) ? "" : $sourceAry['shipFromAddressAry'][0]).'</Address1>';
			$involvedPartiesInfo .= '<Address2>'.(empty($sourceAry['shipFromAddressAry'][1]) ? "" : $sourceAry['shipFromAddressAry'][1]).'</Address2>';
			$involvedPartiesInfo .= '<Street>'.$street.'</Street>';
			$involvedPartiesInfo .= '<City>'.$sourceAry['shipFromCity'].'</City>';
			$involvedPartiesInfo .= '<Province>'.(empty($sourceAry['shipFromProvince']) ? $sourceAry['shipFromProvinceCode'] : $sourceAry['shipFromProvince']).'</Province>';
			$involvedPartiesInfo .= '<State>'.$sourceAry['shipFromProvinceCode'].'</State>';
			$involvedPartiesInfo .= '<Postal>'.(empty($sourceAry['shipFromPostalCode']) ? (empty($sourceAry['shipFromAddressAry'][2]) ? "" : $sourceAry['shipFromAddressAry'][2]) : $sourceAry['shipFromPostalCode']).'</Postal>';
			$involvedPartiesInfo .= '<Country>'.$sourceAry['shipFromCountryCode'].'</Country>';
			$involvedPartiesInfo .= '<Latitude>'.$sourceAry['shipFromLatitude'].'</Latitude>';
			$involvedPartiesInfo .= '<Longitude>'.$sourceAry['shipFromLongitude'].'</Longitude>';
			$involvedPartiesInfo .= '<ContactInfo>';
			$involvedPartiesInfo .= '<CountryCode>'.$sourceAry['shipFromCountryCode'].'</CountryCode>';
			$involvedPartiesInfo .= '<ContactNo>'.$emptyValue.'</ContactNo>';
			$involvedPartiesInfo .= '<EmailAddress>'.$emptyValue.'</EmailAddress>';
			$involvedPartiesInfo .= '</ContactInfo>';
			$involvedPartiesInfo .= '</Address>';
			$involvedPartiesInfo .= '</PartyType>';
		}
		/*if($customer==0)
		{
			$involvedPartiesInfo .= '<PartyType>';
			$involvedPartiesInfo .= '<Type>CUSTOMER</Type>';
			$involvedPartiesInfo .= '<ID>ALL</ID>';
			$involvedPartiesInfo .= '<Company>';
			$involvedPartiesInfo .= '<Name>ALL</Name>';
			$involvedPartiesInfo .= '<RegistrationNumber>ALL</RegistrationNumber>';
			$involvedPartiesInfo .= '</Company>';
			$involvedPartiesInfo .= '<Address>';
			$involvedPartiesInfo .= '<Address1>'.$emptyValue.'</Address1>';
			$involvedPartiesInfo .= '<Address2>'.$emptyValue.'</Address2>';
			$involvedPartiesInfo .= '<Street>'.$emptyValue.'</Street>';
			$involvedPartiesInfo .= '<City>'.$emptyValue.'</City>';
			$involvedPartiesInfo .= '<Province>'.$emptyValue.'</Province>';
			$involvedPartiesInfo .= '<State>'.$emptyValue.'</State>';
			$involvedPartiesInfo .= '<Postal>'.$emptyValue.'</Postal>';
			$involvedPartiesInfo .= '<Country>'.$emptyValue.'</Country>';
			$involvedPartiesInfo .= '<Latitude>'.$emptyValue.'</Latitude>';
			$involvedPartiesInfo .= '<Longitude>'.$emptyValue.'</Longitude>';
			$involvedPartiesInfo .= '<ContactInfo>';
			$involvedPartiesInfo .= '<CountryCode>'.$emptyValue.'</CountryCode>';
			$involvedPartiesInfo .= '<ContactNo>'.$emptyValue.'</ContactNo>';
			$involvedPartiesInfo .= '<EmailAddress>'.$emptyValue.'</EmailAddress>';
			$involvedPartiesInfo .= '</ContactInfo>';
			$involvedPartiesInfo .= '</Address>';
			$involvedPartiesInfo .= '</PartyType>';
		}*/
		if($consignee==0)
		{
		    $street = "";
            foreach($destinationAry["shipToAddressAry"] ?? [] as $eachSeqLine){
                $street .= $eachSeqLine;
            }
			$involvedPartiesInfo .= '<PartyType>';
			$involvedPartiesInfo .= '<Type>CONSIGNEE</Type>';
			$involvedPartiesInfo .= '<ID>'.$destinationAry['shipToLocationId'].'</ID>';
			$involvedPartiesInfo .= '<Company>';
			$involvedPartiesInfo .= '<Name>'.$destinationAry['shipToLocationName'].'</Name>';
			$involvedPartiesInfo .= '<RegistrationNumber>'.$destinationAry['shipToLocationId'].'</RegistrationNumber>';
			$involvedPartiesInfo .= '</Company>';
			$involvedPartiesInfo .= '<Address>';
			$involvedPartiesInfo .= '<Address1>'.(empty($destinationAry['shipToAddressAry'][0]) ? "" : $destinationAry['shipToAddressAry'][0]).'</Address1>';
			$involvedPartiesInfo .= '<Address2>'.(empty($destinationAry['shipToAddressAry'][1]) ? "" : $destinationAry['shipToAddressAry'][1]).'</Address2>';
			$involvedPartiesInfo .= '<Street>'.$street.'</Street>';
			$involvedPartiesInfo .= '<City>'.$destinationAry['shipToCity'].'</City>';
			$involvedPartiesInfo .= '<Province>'.(empty($destinationAry['shipToProvince']) ? $destinationAry['shipToProvinceCode'] : $destinationAry['shipToProvince']).'</Province>';
			$involvedPartiesInfo .= '<State>'.$destinationAry['shipToProvinceCode'].'</State>';
			$involvedPartiesInfo .= '<Postal>'.(empty($destinationAry['shipToPostalCode']) ? (empty($destinationAry['shipToAddressAry'][2]) ? "" : $destinationAry['shipToAddressAry'][2]) : $destinationAry['shipToPostalCode']).'</Postal>';
			$involvedPartiesInfo .= '<Country>'.$destinationAry['shipToCountryCode'].'</Country>';
			$involvedPartiesInfo .= '<Latitude>'.$destinationAry['shipToLatitude'].'</Latitude>';
			$involvedPartiesInfo .= '<Longitude>'.$destinationAry['shipToLongitude'].'</Longitude>';
			$involvedPartiesInfo .= '<ContactInfo>';
			$involvedPartiesInfo .= '<CountryCode>'.$destinationAry['shipToCountryCode'].'</CountryCode>';
			$involvedPartiesInfo .= '<ContactNo>'.$emptyValue.'</ContactNo>';
			$involvedPartiesInfo .= '<EmailAddress>'.$emptyValue.'</EmailAddress>';
			$involvedPartiesInfo .= '</ContactInfo>';
			$involvedPartiesInfo .= '</Address>';
			$involvedPartiesInfo .= '</PartyType>';
		}
		/*if($pickup==0)
		{
			$involvedPartiesInfo .= '<PartyType>';
			$involvedPartiesInfo .= '<Type>PICKUP</Type>';
			$involvedPartiesInfo .= '<ID>'.$sourceAry['shipFromLocationName'].'</ID>';
			$involvedPartiesInfo .= '<Company>';
			$involvedPartiesInfo .= '<Name>'.$sourceAry['shipFromLocationName'].'</Name>';
			$involvedPartiesInfo .= '<RegistrationNumber>'.$sourceAry['shipFromLocationName'].'</RegistrationNumber>';
			$involvedPartiesInfo .= '</Company>';
			$involvedPartiesInfo .= '<Address>';
			$involvedPartiesInfo .= '<Address1>'.(empty($sourceAry['shipFromAddressAry'][0]) ? "" : $sourceAry['shipFromAddressAry'][0]).'</Address1>';
			$involvedPartiesInfo .= '<Address2>'.(empty($sourceAry['shipFromAddressAry'][1]) ? "" : $sourceAry['shipFromAddressAry'][1]).'</Address2>';
			$involvedPartiesInfo .= '<Street>'.$emptyValue.'</Street>';
			$involvedPartiesInfo .= '<City>'.$sourceAry['shipFromCity'].'</City>';
			$involvedPartiesInfo .= '<Province>'.$sourceAry['shipFromProvince'].'</Province>';
			$involvedPartiesInfo .= '<State>'.$sourceAry['shipFromProvinceCode'].'</State>';
			$involvedPartiesInfo .= '<Postal>'.$sourceAry['shipFromPostalCode'].'</Postal>';
			$involvedPartiesInfo .= '<Country>'.$sourceAry['shipFromCountryCode'].'</Country>';
			$involvedPartiesInfo .= '<Latitude>'.$sourceAry['shipFromLatitude'].'</Latitude>';
			$involvedPartiesInfo .= '<Longitude>'.$sourceAry['shipFromLongitude'].'</Longitude>';
			$involvedPartiesInfo .= '<ContactInfo>';
			$involvedPartiesInfo .= '<CountryCode>'.$sourceAry['shipFromCountryCode'].'</CountryCode>';
			$involvedPartiesInfo .= '<ContactNo>'.$emptyValue.'</ContactNo>';
			$involvedPartiesInfo .= '<EmailAddress>'.$emptyValue.'</EmailAddress>';
			$involvedPartiesInfo .= '</ContactInfo>';
			$involvedPartiesInfo .= '</Address>';
			$involvedPartiesInfo .= '</PartyType>';
		}
		if($delivery==0)
		{
			$involvedPartiesInfo .= '<PartyType>';
			$involvedPartiesInfo .= '<Type>DELIVERY</Type>';
			$involvedPartiesInfo .= '<ID>'.$destinationAry['shipToLocationName'].'</ID>';
			$involvedPartiesInfo .= '<Company>';
			$involvedPartiesInfo .= '<Name>'.$destinationAry['shipToLocationName'].'</Name>';
			$involvedPartiesInfo .= '<RegistrationNumber>'.$destinationAry['shipToLocationName'].'</RegistrationNumber>';
			$involvedPartiesInfo .= '</Company>';
			$involvedPartiesInfo .= '<Address>';
			$involvedPartiesInfo .= '<Address1>'.(empty($destinationAry['shipToAddressAry'][0]) ? "" : $destinationAry['shipToAddressAry'][0]).'</Address1>';
			$involvedPartiesInfo .= '<Address2>'.(empty($destinationAry['shipToAddressAry'][1]) ? "" : $destinationAry['shipToAddressAry'][1]).'</Address2>';
			$involvedPartiesInfo .= '<Street>'.$emptyValue.'</Street>';
			$involvedPartiesInfo .= '<City>'.$destinationAry['shipToCity'].'</City>';
			$involvedPartiesInfo .= '<Province>'.$destinationAry['shipToProvince'].'</Province>';
			$involvedPartiesInfo .= '<State>'.$destinationAry['shipToProvinceCode'].'</State>';
			$involvedPartiesInfo .= '<Postal>'.$destinationAry['shipToPostalCode'].'</Postal>';
			$involvedPartiesInfo .= '<Country>'.$destinationAry['shipToCountryCode'].'</Country>';
			$involvedPartiesInfo .= '<Latitude>'.$destinationAry['shipToLatitude'].'</Latitude>';
			$involvedPartiesInfo .= '<Longitude>'.$destinationAry['shipToLongitude'].'</Longitude>';
			$involvedPartiesInfo .= '<ContactInfo>';
			$involvedPartiesInfo .= '<CountryCode>'.$destinationAry['shipToCountryCode'].'</CountryCode>';
			$involvedPartiesInfo .= '<ContactNo>'.$emptyValue.'</ContactNo>';
			$involvedPartiesInfo .= '<EmailAddress>'.$emptyValue.'</EmailAddress>';
			$involvedPartiesInfo .= '</ContactInfo>';
			$involvedPartiesInfo .= '</Address>';
			$involvedPartiesInfo .= '</PartyType>';
		}*/
		return $involvedPartiesInfo;
	}

	public function setCargoSummaryInfo(array $cargoSummaryAry): string
	{
		$cargoSummaryInfo = '<CargoSummary>';
		$cargoSummaryInfo .= '<TotalQuantity>';
		$cargoSummaryInfo .= '<Value>'.$cargoSummaryAry['totalQuantityValue'].'</Value>';
		$cargoSummaryInfo .= '<UOM>Numbers</UOM>';
		$cargoSummaryInfo .= '</TotalQuantity>';
		$cargoSummaryInfo .= '<TotalVolume>';
		$cargoSummaryInfo .= '<Value>'.$cargoSummaryAry['totalVolumeValue'].'</Value>';
		$cargoSummaryInfo .= '<UOM>'.$cargoSummaryAry['totalVolumeUOM'].'</UOM>';
		$cargoSummaryInfo .= '</TotalVolume>';
		$cargoSummaryInfo .= '<TotalWeight>';
		$cargoSummaryInfo .= '<Value>'.$cargoSummaryAry['totalWeightValue'].'</Value>';
		$cargoSummaryInfo .= '<UOM>'.$cargoSummaryAry['totalWeightUOM'].'</UOM>';
		$cargoSummaryInfo .= '</TotalWeight>';
		$cargoSummaryInfo .= '</CargoSummary>';

		return $cargoSummaryInfo;
	}

	public function setShipUnitInfo(array $outerCargos): string
	{
		$emptyValue = $outerCargosInfo = "";
		foreach ($outerCargos as $outerCargo) {
		    /*$packageType = $this->ci->OtmBookingModel->getPackageType($outerCargo['outerPackageType'], $organizationAry['organizationId'], $organizationAry['businessEntityValue']);
    		if(!empty($outerCargo['outerPackageType']))
    		{
    			$packageType = $packageType;
    		}*/
			$outerCargosInfo .= '<TransportHandlingUnit>';
			$outerCargosInfo .= '<CargoType>' . $outerCargo['outerPackageType'] . '</CargoType>';
			$outerCargosInfo .= '<GoodsDescription>' . $outerCargo['outerPackageDesc'] . '</GoodsDescription>';
			$outerCargosInfo .= '<MarksandNumbers>N</MarksandNumbers>';
			$outerCargosInfo .= '<HandlingUnit/>';
			$outerCargosInfo .= '<ValueOfGoods>' . $emptyValue . '</ValueOfGoods>';
			$outerCargosInfo .= '<Quantity>' . $outerCargo['outerPackageQuantity'] . '</Quantity>';
			$outerCargosInfo .= '<ScannedQuantity>' . $outerCargo['outerPackageQuantity'] . '</ScannedQuantity>';
			$outerCargosInfo .= '<ItemId>' . $outerCargo['externalOuterCargoId'] . '</ItemId>';
			$outerCargosInfo .= '<Length>';
			$outerCargosInfo .= '<Value>' . $outerCargo['outerPackageLengthValue'] . '</Value>';
			$outerCargosInfo .= '<UOM>' . $outerCargo['outerPackageLengthUOM'] . '</UOM>';
			$outerCargosInfo .= '</Length>';
			$outerCargosInfo .= '<Width>';
			$outerCargosInfo .= '<Value>' . $outerCargo['outerPackageWidthValue'] . '</Value>';
			$outerCargosInfo .= '<UOM>' . $outerCargo['outerPackageWidthUOM'] . '</UOM>';
			$outerCargosInfo .= '</Width>';
			$outerCargosInfo .= '<Height>';
			$outerCargosInfo .= '<Value>' . $outerCargo['outerPackageHeightValue'] . '</Value>';
			$outerCargosInfo .= '<UOM>' . $outerCargo['outerPackageHeightUOM'] . '</UOM>';
			$outerCargosInfo .= '</Height>';
			$outerCargosInfo .= '<ActualWeight>';
			$outerCargosInfo .= '<Value>' . $outerCargo['outerPackageWeightValue'] . '</Value>';
			$outerCargosInfo .= '<UOM>' . $outerCargo['outerPackageWeightUOM'] . '</UOM>';
			$outerCargosInfo .= '</ActualWeight>';
			$outerCargosInfo .= '<Weight>';
			$outerCargosInfo .= '<Value>' . $outerCargo['outerPackageWeightValue'] . '</Value>';
			$outerCargosInfo .= '<UOM>' . $outerCargo['outerPackageWeightUOM'] . '</UOM>';
			$outerCargosInfo .= '</Weight>';
			$outerCargosInfo .= '<VolumetricWeight>';
			$outerCargosInfo .= '<Value>0.000</Value>';
			$outerCargosInfo .= '<UOM/>';
			$outerCargosInfo .= '</VolumetricWeight>';
			$outerCargosInfo .= '<Volume>';
			$outerCargosInfo .= '<Value>' . $outerCargo['outerPackageVolumeValue'] . '</Value>';
			$outerCargosInfo .= '<UOM>' . $outerCargo['outerPackageVolumeUOM'] . '</UOM>';
			$outerCargosInfo .= '</Volume>';
			$outerCargosInfo .= '<ActualVolume>';
			$outerCargosInfo .= '<Value>' . $outerCargo['outerPackageVolumeValue'] . '</Value>';
			$outerCargosInfo .= '<UOM>' . $outerCargo['outerPackageVolumeUOM'] . '</UOM>';
			$outerCargosInfo .= '</ActualVolume>';
			$outerCargosInfo .= '<ldm>0.000</ldm>';
			$outerCargosInfo .= '<GroundedFlag>0</GroundedFlag>';
			$outerCargosInfo .= '<StackableFlag>0</StackableFlag>';
			$outerCargosInfo .= '<SplittableFlag>0</SplittableFlag>';
			$outerCargosInfo .= '<DangerousGoodsFlag>0</DangerousGoodsFlag>';
			$outerCargosInfo .= '<TotalPackagesOfDangerousGoods>0</TotalPackagesOfDangerousGoods>';
			foreach ($outerCargo['innerCargos'] as $innerCargo) {
				$innerCargosInfo = '<PackagingUnit>';
				$innerCargosInfo .= '<PackageType>' .$innerCargo['innerPackageType'] . '</PackageType>';
				$innerCargosInfo .= '<PackageDescription>' . $innerCargo['innerPackageDesc'] . '</PackageDescription>';
				$innerCargosInfo .= '<MarksandNumbers>N</MarksandNumbers>';
				$innerCargosInfo .= '<HandlingUnit/>';
				$innerCargosInfo .= '<ValueOfGoods>' . $emptyValue . '</ValueOfGoods>';
				$innerCargosInfo .= '<Quantity>' . $innerCargo['innerPackageQuantity'] . '</Quantity>';
				$innerCargosInfo .= '<ScannedQuantity>' . $innerCargo['innerPackageQuantity'] . '</ScannedQuantity>';
				$innerCargosInfo .= '<ItemId>' . $innerCargo['externalInnerCargoId'] . '</ItemId>';
				$innerCargosInfo .= '<Length>';
				$innerCargosInfo .= '<Value>' . $innerCargo['innerPackageLengthValue'] . '</Value>';
				$innerCargosInfo .= '<UOM>' . $innerCargo['innerPackageLengthUOM'] . '</UOM>';
				$innerCargosInfo .= '</Length>';
				$innerCargosInfo .= '<Width>';
				$innerCargosInfo .= '<Value>' . $innerCargo['innerPackageWidthValue'] . '</Value>';
				$innerCargosInfo .= '<UOM>' . $innerCargo['innerPackageWidthUOM'] . '</UOM>';
				$innerCargosInfo .= '</Width>';
				$innerCargosInfo .= '<Height>';
				$innerCargosInfo .= '<Value>' . $innerCargo['innerPackageHeightValue'] . '</Value>';
				$innerCargosInfo .= '<UOM>' . $innerCargo['innerPackageHeightUOM'] . '</UOM>';
				$innerCargosInfo .= '</Height>';
				$innerCargosInfo .= '<ActualWeight>';
				$innerCargosInfo .= '<Value>' . $innerCargo['innerPackageWeightValue'] . '</Value>';
				$innerCargosInfo .= '<UOM>' . $innerCargo['innerPackageWeightUOM'] . '</UOM>';
				$innerCargosInfo .= '</ActualWeight>';
				$innerCargosInfo .= '<Weight>';
				$innerCargosInfo .= '<Value>' . $innerCargo['innerPackageWeightValue'] . '</Value>';
				$innerCargosInfo .= '<UOM>' . $innerCargo['innerPackageWeightUOM'] . '</UOM>';
				$innerCargosInfo .= '</Weight>';
				$innerCargosInfo .= '<VolumetricWeight>';
				$innerCargosInfo .= '<Value>0.000</Value>';
				$innerCargosInfo .= '<UOM/>';
				$innerCargosInfo .= '</VolumetricWeight>';
				$innerCargosInfo .= '<Volume>';
				$innerCargosInfo .= '<Value>' . $innerCargo['innerPackageVolumeValue'] . '</Value>';
				$innerCargosInfo .= '<UOM>' . $innerCargo['innerPackageVolumeUOM'] . '</UOM>';
				$innerCargosInfo .= '</Volume>';
				$innerCargosInfo .= '<ActualVolume>';
				$innerCargosInfo .= '<Value>' . $innerCargo['innerPackageVolumeValue'] . '</Value>';
				$innerCargosInfo .= '<UOM>' . $innerCargo['innerPackageVolumeUOM'] . '</UOM>';
				$innerCargosInfo .= '</ActualVolume>';
				$innerCargosInfo .= '<ldm>0.000</ldm>';
				$innerCargosInfo .= '<GroundedFlag>0</GroundedFlag>';
				$innerCargosInfo .= '<StackableFlag>0</StackableFlag>';
				$innerCargosInfo .= '<SplittableFlag>0</SplittableFlag>';
				$innerCargosInfo .= '<DangerousGoodsFlag>0</DangerousGoodsFlag>';
				$innerCargosInfo .= '<TotalPackagesOfDangerousGoods>0</TotalPackagesOfDangerousGoods>';
				$innerCargosInfo .= '</PackagingUnit>';
				$outerCargosInfo .= $innerCargosInfo;
			}
			$outerCargosInfo .= '</TransportHandlingUnit>';
		}

		return $outerCargosInfo;
	}

	public function setReleaseLineInfo(array $outerReleaseCargos): string
	{
		$emptyValue = $outerReleaseCargosInfo = "";
		foreach ($outerReleaseCargos as $outerReleaseCargo) {
			$outerReleaseCargosInfo .= '<TransportHandlingUnit>';
			$outerReleaseCargosInfo .= '<CargoType>' . $outerReleaseCargo['outerPackageType'] . '</CargoType>';
			$outerReleaseCargosInfo .= '<GoodsDescription>' . $outerReleaseCargo['outerPackageDesc'] . '</GoodsDescription>';
			$outerReleaseCargosInfo .= '<MarksandNumbers>N</MarksandNumbers>';
			$outerReleaseCargosInfo .= '<HandlingUnit/>';
			$outerReleaseCargosInfo .= '<ValueOfGoods>' . $emptyValue . '</ValueOfGoods>';
			$outerReleaseCargosInfo .= '<Quantity>' . $outerReleaseCargo['outerPackageQuantity'] . '</Quantity>';
			$outerReleaseCargosInfo .= '<ScannedQuantity>' . $outerReleaseCargo['outerPackageQuantity'] . '</ScannedQuantity>';
			$outerReleaseCargosInfo .= '<ItemId>' . $outerReleaseCargo['externalOuterCargoId'] . '</ItemId>';
			$outerReleaseCargosInfo .= '<Length>';
			$outerReleaseCargosInfo .= '<Value>' . $outerReleaseCargo['outerPackageLengthValue'] . '</Value>';
			$outerReleaseCargosInfo .= '<UOM>' . $outerReleaseCargo['outerPackageLengthUOM'] . '</UOM>';
			$outerReleaseCargosInfo .= '</Length>';
			$outerReleaseCargosInfo .= '<Width>';
			$outerReleaseCargosInfo .= '<Value>' . $outerReleaseCargo['outerPackageWidthValue'] . '</Value>';
			$outerReleaseCargosInfo .= '<UOM>' . $outerReleaseCargo['outerPackageWidthUOM'] . '</UOM>';
			$outerReleaseCargosInfo .= '</Width>';
			$outerReleaseCargosInfo .= '<Height>';
			$outerReleaseCargosInfo .= '<Value>' . $outerReleaseCargo['outerPackageHeightValue'] . '</Value>';
			$outerReleaseCargosInfo .= '<UOM>' . $outerReleaseCargo['outerPackageHeightUOM'] . '</UOM>';
			$outerReleaseCargosInfo .= '</Height>';
			$outerReleaseCargosInfo .= '<ActualWeight>';
			$outerReleaseCargosInfo .= '<Value>' . $outerReleaseCargo['outerPackageWeightValue'] . '</Value>';
			$outerReleaseCargosInfo .= '<UOM>' . $outerReleaseCargo['outerPackageWeightUOM'] . '</UOM>';
			$outerReleaseCargosInfo .= '</ActualWeight>';
			$outerReleaseCargosInfo .= '<Weight>';
			$outerReleaseCargosInfo .= '<Value>' . $outerReleaseCargo['outerPackageWeightValue'] . '</Value>';
			$outerReleaseCargosInfo .= '<UOM>' . $outerReleaseCargo['outerPackageWeightUOM'] . '</UOM>';
			$outerReleaseCargosInfo .= '</Weight>';
			$outerReleaseCargosInfo .= '<VolumetricWeight>';
			$outerReleaseCargosInfo .= '<Value>0.000</Value>';
			$outerReleaseCargosInfo .= '<UOM/>';
			$outerReleaseCargosInfo .= '</VolumetricWeight>';
			$outerReleaseCargosInfo .= '<Volume>';
			$outerReleaseCargosInfo .= '<Value>' . $outerReleaseCargo['outerPackageVolumeValue'] . '</Value>';
			$outerReleaseCargosInfo .= '<UOM>' . $outerReleaseCargo['outerPackageVolumeUOM'] . '</UOM>';
			$outerReleaseCargosInfo .= '</Volume>';
			$outerReleaseCargosInfo .= '<ActualVolume>';
			$outerReleaseCargosInfo .= '<Value>' . $outerReleaseCargo['outerPackageVolumeValue'] . '</Value>';
			$outerReleaseCargosInfo .= '<UOM>' . $outerReleaseCargo['outerPackageVolumeUOM'] . '</UOM>';
			$outerReleaseCargosInfo .= '</ActualVolume>';
			$outerReleaseCargosInfo .= '<ldm>0.000</ldm>';
			$outerReleaseCargosInfo .= '<GroundedFlag>0</GroundedFlag>';
			$outerReleaseCargosInfo .= '<StackableFlag>0</StackableFlag>';
			$outerReleaseCargosInfo .= '<SplittableFlag>0</SplittableFlag>';
			$outerReleaseCargosInfo .= '<DangerousGoodsFlag>0</DangerousGoodsFlag>';
			$outerReleaseCargosInfo .= '<TotalPackagesOfDangerousGoods>0</TotalPackagesOfDangerousGoods>';
			$outerReleaseCargosInfo .= '</TransportHandlingUnit>';
		}

		return $outerReleaseCargosInfo;
	}

	public function setAddonsInfo(array $addonsAry): string
	{
	    if($accessorialCode <> ''){
		    array_push($addons, $accessorialCode);
		}
		if($specialService <> ''){
		    array_push($addons, $specialService);
		}
		if($specialServiceDuration <> ''){
		    array_push($addons, $specialServiceDuration);
		}
		if($specialServiceDurationTime <> ''){
            array_push($addons, $specialServiceDurationTime);
		}
		
		$emptyValue = $addonsInfo = '';
		
		if(! empty($addonsAry))
		{
		    $addonsInfo = '<ValueAddedServices>';
			$addonsInfo .= '<Addon>';
    		$addonsInfo .= '<AddonName>'.$addonsAry[0].'</AddonName>';
    		$addonsInfo .= '<AddonCode>'.$addonsAry[0].'</AddonCode>';
    		$addonsInfo .= '<Currency>'.$emptyValue.'</Currency>';
    		$addonsInfo .= '<RateUnit>'.$emptyValue.'</RateUnit>';
    		$addonsInfo .= '<AddonAmount>'.$emptyValue.'</AddonAmount>';
    		$addonsInfo .= '<AddonQuantity>'.$emptyValue.'</AddonQuantity>';
    		$addonsInfo .= '</Addon>';
    		$addonsInfo .= '<Addon>';
    		$addonsInfo .= '<AddonName>'.$addonsAry[1].'</AddonName>';
    		$addonsInfo .= '<AddonCode>'.$addonsAry[1].'</AddonCode>';
    		$addonsInfo .= '<Currency>'.$emptyValue.'</Currency>';
    		$addonsInfo .= '<RateUnit>'.$addonsAry[3].'</RateUnit>';
    		$addonsInfo .= '<AddonAmount>'.$emptyValue.'</AddonAmount>';
    		$addonsInfo .= '<AddonQuantity>'.$addonsAry[2].'</AddonQuantity>';
    		$addonsInfo .= '</Addon>';
			$addonsInfo .= '</ValueAddedServices>';
		}
		else
		{
		    $addonsInfo = '<ValueAddedServices>';
    		$addonsInfo .= '</ValueAddedServices>';
		}
		return $addonsInfo;
	}

	public function setManageReferences(array $referencesAry, string $bookingId, string $domainName): string
	{
		$referencesInfo = '<ManageReferences>';
		if(empty($referencesAry))
		{
			$referencesInfo .= '<References>';
			$referencesInfo .= '<RefType>';
			$referencesInfo .= '<Code>EXTID</Code>';
			$referencesInfo .= '<Value>'.$bookingId.'</Value>';
			$referencesInfo .= '</RefType>';
			$referencesInfo .= '</References>';
			$referencesInfo .= '<References>';
			$referencesInfo .= '<RefType>';
			$referencesInfo .= '<Code>DOMAIN</Code>';
			$referencesInfo .= '<Value>'.$domainName.'</Value>';
			$referencesInfo .= '</RefType>';
			$referencesInfo .= '</References>';
		}
		
		else
		{
			foreach ($referencesAry as $references)
			{
				$referencesInfo .= '<References>';
				$referencesInfo .= '<RefType>';
				$referencesInfo .= '<Code>'.$references[0].'</Code>';
				$referencesInfo .= '<Value>'.$references[1].'</Value>';
				$referencesInfo .= '</RefType>';
				$referencesInfo .= '</References>';
			}
			$referencesInfo .= '<References>';
			$referencesInfo .= '<RefType>';
			$referencesInfo .= '<Code>EXTID</Code>';
			$referencesInfo .= '<Value>'.$bookingId.'</Value>';
			$referencesInfo .= '</RefType>';
			$referencesInfo .= '</References>';
			$referencesInfo .= '<References>';
			$referencesInfo .= '<RefType>';
			$referencesInfo .= '<Code>DOMAIN</Code>';
			$referencesInfo .= '<Value>'.$domainName.'</Value>';
			$referencesInfo .= '</RefType>';
			$referencesInfo .= '</References>';
		}
		$referencesInfo .= '</ManageReferences>';

		return $referencesInfo;
	}

	public function setRemarks(array $remarksAry): string
	{
		$remarksInfo = "";
		if(empty($remarksAry))
		{
			$remarksInfo .= '<Remarks>';
			$remarksInfo .= '</Remarks>';
		}
		else
		{
			$remarksInfo .= '<Remarks>';
			foreach ($remarksAry as $remarks)
			{
				$remarksInfo .= '<RemarkType>';
				$remarksInfo .= '<Code>'.$remarks[0].'</Code>';
				$remarksInfo .= '<Value>'.$remarks[1].'</Value>';
				$remarksInfo .= '</RemarkType>';
			}
			$remarksInfo .= '</Remarks>';
		}
		return $remarksInfo;
	}
}
