<?php

class Otmordershipmenthandler
{
    private $ci;

    public function __construct()
    {
        $this->ci = &get_instance();

        $this->ci->load->model(['common', 'otmbookingmodel', 'otmshipmentmodel','OtmTripModel','frieghttrack', 'Order']);
        $this->ci->load->library(['OtmStandardBookingHandler','Standardtriphandler','apis/FlipkartEDIServices', 'apis/IwayExxEDIServices']);
        $this->ci->load->helper(["thirdparty_helper"]);
        //$this->ci->load->library('OtmTripHandler');
       
       
    }

    public function pullTripOrderXml(array $data): string
    {
//log_message('error', 'Data: ' . json_encode($data));
        $status = "";
        $filterData = $this->tripOrderData($data);
       // log_message('error', 'filterData: ' . json_encode($filterData));
        if ($filterData['status'] === 1) {
            $status = "Trip Creation Failed, : " . $filterData['message'];
            //echo "Order Creation Failed, : " . $filterData['message'];
            return $status;
        }
        $shipmentID = $this->saveTripDetails($filterData['data']);
        //log_message('error', 'Data:' .json_encode($filterData['data']));
        $status = "Trip Created Successfully: Trip - " . $shipmentID;
        return $status;
        //echo "Trip Created Successfully: Trip - " . $shipmentID;
    }

    public function tripOrderData(array $data): array
    {
        $tripInfo = $data['SVKEDITripBody'];
        $elogHeader = $data['SVKEDITripHeader'];
        $orgDetails = $tripInfo['SVKOrgDetails'];
        $tripHeader = $tripInfo['TripDetails']['TripHeader'];
        $tripOrderDetails = $tripInfo['TripDetails']['TripOrderDetails'];
        $tripId = $tripHeader['TripID'] ?? null; // Extract TripID safely
        $orderData['TripID'] = $tripId;           // Add it to orderData array
        $organizationId = $orgDetails['OrganizationId'];
        $businessEntityValue = $orgDetails['BusinessEntity'];
        $orderInfo   = $data['SVKEDIOrderBody'];
        $orderHeader = $data['SVKEDIOrderHeader'];

        $externalOrderID = (empty($tripHeader['ExternalTripID']) ? "0" : $tripHeader['ExternalTripID']);
        if ($externalOrderID == 0) {
            return ["status" => 1, "message" => 'External Order ID in the XML: ' . $tripHeader['ExternalTripID']];
        }
        $orderType = (empty($tripHeader['TripType']) ? "DEFAULT" : $tripHeader['TripType']);
        if (! empty($orderType)) {
            $orderType = $this->ci->Standardbookingmodel->checkOtmOrderType($organizationId, $businessEntityValue, $orderType);
           
            if (empty($orderType)) {
                log_error('Invalid Order Type ' . $orderType);
                return ["status" => 1, "message" => ' Invalid Order Type ' . $orderType];
            }
        }
        $modeOfTransport = (empty($tripHeader['ModeOfTransport']) ? "DEFAULT" : $tripHeader['ModeOfTransport']);
        if (! empty($modeOfTransport)) {
            $modData = $this->ci->Standardbookingmodel->checkOtmModeOfTransportNew($organizationId, $businessEntityValue, $modeOfTransport);
            $modeOfTransportId = $modData['ModeofTransportId'];
            $modeOfTransport = $modData['ModeofTransport'];
            if (empty($modeOfTransportId)) {
                log_error('Standard Trip Create :  Invalid Mode Of Transport ' . $modeOfTransport);
                return ["status" => 1, "message" => 'Invalid Mode Of Transport ' . $modeOfTransport];
            }
        } /*else {
            log_error('Standard Trip Create : Empty  Mode Of Transport');
            return ["status" => 1, "message" => 'Empty  Mode Of Transport'];
        }*/
        $product = (empty($tripHeader['Product']) ? "" : $tripHeader['Product']);
        if (! empty($product)) {
            $product = $this->ci->Standardbookingmodel->checkProduct($product);
            /*if (empty($product)) {
                log_error('Standard Trip Create :  Invalid Product ' . $product);
                return ["status" => 1, "message" => 'Invalid Product' . $product];
            }*/
        }
        $serviceType = (empty($tripHeader['ServiceType']) ? "" : $orderInfo['ServiceType']);
        if ($serviceType != "") {
            $serviceType = $this->ci->Standardbookingmodel->checkServiceType($serviceType);
            /*if (empty($serviceType)) {
                log_error('Standard Trip Create :  Invalid Service Type ' . $serviceType);
                return ["status" => 1, "message" => ' Invalid Service Type ' . $serviceType];
            }*/
        }
        
        $tripData = [
            'TripHeader' => $tripHeader,
            'TripOrderDetails' => $tripOrderDetails,
            'organizationId' => $organizationId,
            'businessEntityValue' => $businessEntityValue,
            // 'businessEntityID' => $businessEntityValue['entity_id'],
            'domain' => $domain,
            'elogheader' => $elogHeader,
            'organization' => $organization,
            'businessEntity' => $businessEntity,
            'orderType' => $orderType,
            'modeOfTransport' => $modeOfTransport,
            'modeOfTransportId' => $modeOfTransportId,
        ];
        return ["status" => 0, "data" => $tripData];
    }

    public function saveTripDetails(array $orderData): string
    {
        $cdate = date('Y-m-d H:i:s');
       $tripId = isset($orderData['TripHeader']['TripID']) && !is_array($orderData['TripHeader']['TripID'])
    ? $orderData['TripHeader']['TripID']
    : null;

        // Log for debugging
        log_message('error', 'TripID extracted at start of saveTripDetails: ' . ($tripId ?? 'NULL'));
        
        // Pass $tripId directly to orderdetails()
        if (array_key_exists("0", $orderData['TripOrderDetails']) == 1) {
            foreach ($orderData['TripOrderDetails'] as $orderDetail) {
                $bookingIDs[] = $this->orderdetails(
                    $orderDetail,
                    $orderData['organizationId'],
                    $orderData['businessEntityValue'],
                    $orderData['businessEntityID'],
                    $orderData['organization'],
                    $orderData['businessEntity'],
                    $orderData['domain'],
                    $orderData['TripHeader'],
                    $tripId,
                    $orderData['orderType'],
                    $orderData['modeOfTransport'],
                    $orderData['modeOfTransportId']
                );
            }
        } else {
            $bookingIDs[] = $this->orderdetails(
                $orderData['TripOrderDetails'],
                $orderData['organizationId'],
                $orderData['businessEntityValue'],
                $orderData['businessEntityID'],
                $orderData['organization'],
                $orderData['businessEntity'],
                $orderData['domain'],
                $orderData['TripHeader'],
                $tripId,
                $orderData['orderType'],
                $orderData['modeOfTransport'],
                $orderData['modeOfTransportId']
            );
        }

        $carrier_id = 0;
        $user_id = isset($orderData['user_id']) ? (int) $orderData['user_id'] : 0;
        if (!empty($orderData['TripHeader']['CarrierDetails'])) {
            
            $carrier_id = $this->ci->otmstandardbookinghandler->checkPartyDetails(
                $orderData['TripHeader']['CarrierDetails'],
                $orderData['organizationId'],
                $orderData['businessEntityValue'],
                $user_id,
                'CARRIER'
            );
            
            $cwhr = ['code' => $orderData['TripHeader']['CarrierDetails']['ID']];
                $ctable = 'tb_vendors';
                $cselect = 'id, code';
                $chkVendor = $this->ci->common->gettblrowdata($cwhr, $cselect, $ctable, 0, 0);
                 
                if (count($chkVendor) > 0) {
                    $carrierId = $chkVendor['id'];
                    $carrierCode = $chkVendor['code'];
                }
         
        /*$carrier_id = $this->getCarrierDetails(
        $orderData['TripHeader']['CarrierDetails'],
        $orderData['organizationId'],
        $orderData['businessEntityValue'],
        $orderData['businessEntityID'],
        $orderData['organization'],
        $orderData['businessEntity']
        );*/
        }
       $user_id = isset($orderData['user_id']) ? (int) $orderData['user_id'] : 0;
        $customerInfo = $this->ci->otmstandardbookinghandler->checkPartyDetails($orderData['TripOrderDetails']['CustomerDetails'] = [], $orderData['organizationId'], $orderData['businessEntityValue'], $user_id, "Customer");
        
    if (!empty($orderData['TripHeader']['VehicleDetails'])) {
       $vehicle_id = $this->getVehicleDetails(
        $orderData['TripHeader']['VehicleDetails'] ?? [],                    // ensure array
        isset($orderData['organizationId']) ? (string) $orderData['organizationId'] : '',  // string
        isset($orderData['businessEntityValue']) ? (string) $orderData['businessEntityValue'] : '', // string
        isset($orderData['businessEntityID']) ? (string) $orderData['businessEntityID'] : '',  // string
        isset($carrier_id) ? (int) $carrier_id : 0                               // int
      );
      $vehicleType = $orderData['TripHeader']['VehicleDetails']['VehicleTypeCode'] ?? "";
    }

        /*    if (!empty($orderData['TripHeader']['DriverDetails'])) {
        $driver_id = $this->getDriverDetails(
        $orderData['TripHeader']['DriverDetails'],
        $orderData['organizationId'],
        $orderData['businessEntityValue'],
        $orderData['businessEntityID'],
        $carrier_id,
        $vehicle_id
        );
        }*/

        if (!empty($orderData['TripHeader']['TripLocation']['TripStartLocation'])) {
           $user_id = isset($orderData['user_id']) ? (int) $orderData['user_id'] : 0;

        $startlocationID = $this->ci->otmstandardbookinghandler->checkPartyDetails(
            $orderData['TripHeader']['TripLocation']['TripStartLocation'],
            $orderData['organizationId'],
            $orderData['businessEntityValue'],
            $user_id, 
            'PICKUP'
        );
            $startlocationID = $startlocationID['partyContactID'];
        }
        if (!empty($orderData['TripHeader']['TripLocation']['TripEndLocation'])) {
            $endlocationID = $this->ci->otmstandardbookinghandler->checkPartyDetails(
                $orderData['TripHeader']['TripLocation']['TripEndLocation'],
                $orderData['organizationId'],
                $orderData['businessEntityValue'],
                $user_id,
                'DELIVERY'
            );
            $endlocationID = $endlocationID['partyContactID'];
        }

        /*if (!empty($orderData['TripHeader']['TripLocation']['TripStartLocation'])) {
        $startlocationID = $this->getLocationDetails(
        $orderData['TripHeader']['TripLocation']['TripStartLocation']['Address'],
        $orderData['organizationId'],
        $orderData['businessEntityValue'],
        $orderData['businessEntityID'],
        ''
        );
        }
        if (!empty($orderData['TripHeader']['TripLocation']['TripEndLocation'])) {
        $endlocationID = $this->getLocationDetails(
        $orderData['TripHeader']['TripLocation']['TripEndLocation']['Address'],
        $orderData['organizationId'],
        $orderData['businessEntityValue'],
        $orderData['businessEntityID']
        );
        }*/

        // $tripId = is_array($orderData['TripHeader']['TripID']) ? "0" : $orderData['TripHeader']['TripID'];
        // $checkTrip = $this->ci->common->gettblrowdata(
        //     ["external_trip_id" => $tripId, 'status' => 1],
        //     "trip_id",
        //     "tb_trips",
        //     0,
        //     0
        // );
        $tripId = is_array($orderData['TripHeader']['TripID']) ? "0" : $orderData['TripHeader']['TripID'];
        $checkTrip = $this->ci->common->gettblrowdata(
            ["shipmentid" => $tripId, 'status' => 1],
            "id",
            "tb_shifts",
            0,
            0
        );
        
        $tripType = $orderData['tripTypeId'];
        $modeOfTransport = $orderData['modeofTransportId'];

        /*$tripType = $orderData['TripHeader']['TripType'] ?? "";
        if (!empty($tripType)) {
            $destinationTripType = $this->ci->otmshipmentmodel->checkOrderTypeCrossRef($orderData['TripHeader']['TripType'], $orderData['organizationId'],
                $orderData['businessEntityValue']);
            if (!empty($destinationTripType)) {
                $tripType = $this->ci->otmbookingmodel->checkOrderType(
                    $destinationTripType,
                    $orderData['organizationId'],
                    $orderData['businessEntityID'],
                    $orderData['businessEntityValue']
                );
            }
        }
        $modeOfTransport = $orderData['TripHeader']['ModeOfTransport'] ?? "";
        if (!empty($modeOfTransport)) {
            $destinationModeOfTransport = $this->ci->otmshipmentmodel->checkModeOfTransportCrossRef($orderData['TripHeader']['ModeOfTransport'], $orderData['organizationId'],
                $orderData['businessEntityValue']);
            if (!empty($destinationModeOfTransport)) {
                $modeOfTransport = $this->ci->otmbookingmodel->checkModeOfTransport(
                    $destinationModeOfTransport,
                    $orderData['organizationId'],
                    $orderData['businessEntityID'],
                    $orderData['businessEntityValue']
                );
            }
        }*/

        /*$tripType = (empty($orderData['TripHeader']['TripType']) ? "0" : $orderData['TripHeader']['TripType']);
        if ($tripType > 0) {
        $tripType = $this->ci->otmbookingmodel->checkOrderType(
        $orderData['TripHeader']['TripType'],
        $orderData['organizationId'],
        $orderData['businessEntityID'],
        $orderData['businessEntityValue']
        );
        }

        $modeOfTransport = $orderData['TripHeader']['ModeOfTransport'];
        if (!empty($modeOfTransport)) {
        $modeOfTransport = $this->ci->otmbookingmodel->checkModeOfTransport(
        $modeOfTransport,
        $orderData['organizationId'],
        $orderData['businessEntityID'],
        $orderData['businessEntityValue']
        );
        }*/
        $pickup_start_date = str_replace(
            "T",
            " ",
            is_array(
                $orderData['TripHeader']['TripDates']['StartDate']['DateTime']
            ) ? "" : $orderData['TripHeader']['TripDates']['StartDate']['DateTime']
        );
        $delivery_start_date = str_replace(
            "T",
            " ",
            is_array(
                $orderData['TripHeader']['TripDates']['EndDate']['DateTime']
            ) ? "" : $orderData['TripHeader']['TripDates']['EndDate']['DateTime']
        );

        $totalWeightUomCode = $totalVolumeUomCode = "";

        // if (!empty($orderData['TripHeader']['CargoSummary']['TotalWeight']['UOM'])) {
        //     $toWeightUOM = $this->ci->otmshipmentmodel->checkUOM($orderData['TripHeader']['CargoSummary']['TotalWeight']['UOM'], $orderData['organizationId'], $orderData['businessEntityValue']);
        //     if (!empty($toWeightUOM)) {
        //         $totalWeightUomCode = $this->ci->otmshipmentmodel->getUOMId($toWeightUOM);
        //     }
        // }
        // if (!empty($orderData['TripHeader']['CargoSummary']['TotalVolume']['UOM'])) {
        //     $toVolumeUOM = $this->ci->otmshipmentmodel->checkUOM($orderData['TripHeader']['CargoSummary']['TotalVolume']['UOM'], $orderData['organizationId'], $orderData['businessEntityValue']);
        //     if (!empty($toVolumeUOM)) {
        //         $totalVolumeUomCode = $this->ci->otmshipmentmodel->getUOMId($toVolumeUOM);
        //     }
        // }
          if (!empty($orderData['TripHeader']['CargoSummary'])) {
    $cargoSummaryNode = $orderData['TripHeader']['CargoSummary'];

    // Extract values safely
    $totalWeightValue   = (string) ($cargoSummaryNode['TotalWeight']['Value'] ?? 0);
    $totalWeightUOM     = (string) ($cargoSummaryNode['TotalWeight']['UOM'] ?? '');

    $totalVolumeValue   = (string) ($cargoSummaryNode['TotalVolume']['Value'] ?? 0);
    $totalVolumeUOM     = (string) ($cargoSummaryNode['TotalVolume']['UOM'] ?? '');

    $totalQuantityValue = (string) ($cargoSummaryNode['TotalQuantity']['Value'] ?? 0);
    $totalQuantityUOM   = (string) ($cargoSummaryNode['TotalQuantity']['UOM'] ?? '');

    // Build CargoSummary array
    $cargoSummary = [
        'organizationId'      => $orderData['organizationId'] ?? '',
        'businessEntityValue' => $orderData['businessEntityValue'] ?? '',
        'totalWeightValue'    => $totalWeightValue,
        'totalWeightUOM'      => $totalWeightUOM,
        'totalVolumeValue'    => $totalVolumeValue,
        'totalVolumeUOM'      => $totalVolumeUOM,
        'totalQuantityValue'  => $totalQuantityValue,
        'totalQuantityUOM'    => $totalQuantityUOM
    ];

    // TripID may be missing; use null coalescing
    $tripID = $TripHeader['TripID'] ?? '';

    // Log CargoSummary
    /*log_message(
        'error',
        "CargoSummary fetched for TripID {$tripID} | Organization: {$cargoSummary['organizationId']} | BusinessEntity: {$cargoSummary['businessEntityValue']} | Data: " . print_r($cargoSummary, true)
    );*/

} else {
    // TripID may be missing; use null coalescing
    $tripID = $TripHeader['TripID'] ?? '';

    // Log missing CargoSummary
    log_message(
        'error',
        "CargoSummary missing for TripID {$tripID} | Organization: {$orderData['organizationId']} | BusinessEntity: {$orderData['businessEntityValue']}"
    );

   return json_encode([
    "status"  => 1,
    "message" => "CargoSummary is empty for TripID: {$tripID}"
]);

}

$startlocationID = isset($orderData['TripHeader']['TripLocation']['TripStartLocation']['ID'])
    ? (string) $orderData['TripHeader']['TripLocation']['TripStartLocation']['ID']
    : null;

// Safely get Trip End Location ID
$endlocationID = isset($orderData['TripHeader']['TripLocation']['TripEndLocation']['ID'])
    ? (string) $orderData['TripHeader']['TripLocation']['TripEndLocation']['ID']
    : null;

// Log to verify
log_message('error', "Trip Processing Started222| ExternalTripID: {$tripId} | StartPlace: {$startlocationID} | EndPlace: {$endlocationID}");


$tripType        = empty($tripType) ? 0 : $tripType;
$modeOfTransport = empty($modeOfTransport) ? 0 : $modeOfTransport;

// TripID from XML
$tripId = is_array($orderData['TripHeader']['TripID']) ? "0" : $orderData['TripHeader']['TripID'];

// Start log
log_message('error', "Trip Processing Started | ExternalTripID: {$tripId} | StartPlace: {$startlocationID} | EndPlace: {$endlocationID}");
$startlocationNode = $orderData['TripHeader']['TripLocation']['TripStartLocation'] ?? [];
$endlocationNode   = $orderData['TripHeader']['TripLocation']['TripEndLocation'] ?? [];

// Extract latitude/longitude safely
$plat = $startlocationNode['Address']['Latitude']  ?? null;
$plng = $startlocationNode['Address']['Longitude'] ?? null;

$dlat   = $endlocationNode['Address']['Latitude']  ?? null;
$dlng   = $endlocationNode['Address']['Longitude'] ?? null;

if (!empty($pickup_start_date) && $pickup_start_date !== '0') {
    $pickup_start_date_obj = new DateTime($pickup_start_date);
    $stime = $pickup_start_date_obj->format('H:i');
} else {
    $stime = null; // or some default value like '00:00'
}

if (!empty($delivery_start_date) && $delivery_start_date !== '0') {
    $delivery_start_date_obj = new DateTime($delivery_start_date);
    $etime = $delivery_start_date_obj->format('H:i');
} else {
    $etime = null; // or some default value like '00:00'
}

$tripDetails = [
    'trip_type'        => $tripType,
    'splace'           => $startlocationID,
    'eplace'           => $endlocationID,
    'stime'            => $stime,
    'etime'            => $etime,
    'vehicle_id'       => $vehicle_id,
    'external_trip_id' => $tripId,
    'updated_on'       => date('Y-m-d H:i:s'),
    'plat'            => $plat,
    'plng'            => $plng,
    'dlat'            => $dlat,
    'dlng'            => $dlng,

];

$company_code    = $orderData['organizationId'];
$countCode  = substr($company_code, 0, 2);
$year               = date('y');
$week               = date('W');
$bookingId = "";
if (!empty($bookingIDs)) {
    foreach ($bookingIDs as $orders) {
        $bookingId = $orders;
    }
}
if (!empty($checkTrip)) {
    // update
    /*$tripInternalID = $checkTrip['id'];
    $this->ci->common->updatetbledata("tb_trips", $tripDetails, ['id' => $tripInternalID]);*/
    $order_nm = $bookingId;
    $seq_num = substr($order_nm, -6);
    $shipment_gid = "T" . $countCode . $week . $year . $seq_num;
    
   /* log_message('error', "Trip Updated | ID: {$tripInternalID}, ExternalTripID: {$tripId}, ShipmentGID: {$shipment_gid}, SPlace: {$startlocationID}, EPlace: {$endlocationID}");*/

} else {
   
    // insert
    /*$tripInternalID = $this->ci->common->insertTableData('tb_trips', $tripDetails);*/

    $order_nm = $bookingId;
    $seq_num = substr($order_nm, -6);
    $shipment_gid = "T" . $countCode . $week . $year . $seq_num;

    /*$this->ci->common->updatetbledata(
        "tb_trips", 
        [
            'splace'           => $startlocationID,
            'eplace'           => $endlocationID,
            'stime'            => $stime,
            'etime'            => $etime,
            'external_trip_id' => $tripId,
           
        ], 
        ['id' => $tripInternalID]
    );*/

    /*log_message('error', "Trip Inserted | ID: {$tripInternalID}, ExternalTripID: {$tripId}, ShipmentGID: {$shipment_gid}, SPlace: {$startlocationID}, EPlace: {$endlocationID}");*/
}
$cdate = date('Y-m-d H:i:s');

//$modeOfTransport = $orderData['TripHeader']['ModeOfTransport'] ?? "";
$startlocationNode = $orderData['TripHeader']['TripLocation']['TripStartLocation'] ?? [];
$endlocationNode   = $orderData['TripHeader']['TripLocation']['TripEndLocation'] ?? [];

// Extract latitude/longitude safely
$plat = $startlocationNode['Address']['Latitude']  ?? null;
$plng = $startlocationNode['Address']['Longitude'] ?? null;

$dlat   = $endlocationNode['Address']['Latitude']  ?? null;
$dlng   = $endlocationNode['Address']['Longitude'] ?? null;

// Optional: city, address, postal code
$startCity  = $startlocationNode['Address']['City'] ?? null;
$endCity    = $endlocationNode['Address']['City'] ?? null;

$branch_code = $orderData['businessEntityValue'];
$company_code = $orderData['organizationId'] ?? '';
$branch_code  = $branch_code ?? '';
$firstTwoChars = $firstTwoChars ?? '';
log_message("error","branch_code:".$branch_code);
log_message("error","company_code:".$company_code);

$user_id = $this->ci->Standardbookingmodel->checkUser($company_code, $branch_code, $firstTwoChars);

$shiftData = [
    
    'user_id'         => $user_id ?? 0,
    'stime'           => $stime ?? null,
    'etime'           => $etime ?? null,
    'splace'          => $startlocationID ?? null,
    'eplace'          => $endlocationID ?? null,
    'scity'           => $startCity,
    'dcity'           => $endCity ,
    'zone_id'         => $orderData['zone_id'] ?? 0,
    'trip_type'       => $tripType ?? 0,
    'startdate'       => $pickup_start_date ?? null,
    'enddate'         => $delivery_start_date ?? null,
    'shipment_name'   => $orderData['TripHeader']['ShipmentName'] ?? '',
    'shipment_id'     => $tripId,
    'customer_id'     => $customerInfo['customer_id'] ?? 0,
    'vendor_id'       => $carrierId ?? 0,
    'transport_mode'  => $orderData['modeOfTransport'] ,
    'company_code'    => $orderData['organizationId'] ?? '',
    'branch_code'     => $orderData['businessEntityValue'] ?? '',
    'domainname'      => $orderData['domainname'] ?? '',
    'txnid'           => $shipment_gid,
    'status'          => 1,
    'created_on'      => $cdate,
    'slat'            => $plat,
    'slng'            => $plng,
    'elat'            => $dlat,
    'elng'            => $dlng,
    'weight'          => $cargoSummary['totalWeightValue'] ?? 0,  
    'volume'          => $cargoSummary['totalVolumeValue'] ?? 0,
    'units'           => $cargoSummary['totalQuantityValue'] ?? 0,
    'vehicle_type'    => $vehicleType ?? ""
];

$checkShift = $this->ci->common->gettblrowdata(
            ["shipment_id" => $tripId, 'status' => 1],
            "id",
            "tb_shifts",
            0,
            0
        );
if (!empty($checkShift)) {
    $shift_id = $checkShift['id'];
    $this->ci->common->updatetbledata("tb_shifts", $shiftData, ['id' => $shift_id]);
}
else
{
    $shiftData['shipmentid'] = $shipment_gid;
    $this->ci->db->insert('tb_shifts', $shiftData);
    $shift_id = $this->ci->db->insert_id();
}


/*$this->ci->common->updatetbledata(
    "tb_trips", 
    [
        'splace'           => $startlocationID,
        'eplace'           => $endlocationID,
        'stime'            => $pickup_start_date,
        'etime'            => $delivery_start_date,
        'external_trip_id' => $tripId,
        'shift_id'         => $shift_id, // Now this exists
    ], 
    ['id' => $tripInternalID]
);*/


        // if (!empty($orderData['TripHeader']['BusinessParties'])) {
        //     if (array_key_exists("0", $orderData['TripHeader']['BusinessParties']['BusinessParty']) == 1) {
        //         foreach ($orderData['TripHeader']['BusinessParties']['BusinessParty'] as $party) {
        //             $toParty = $this->ci->otmshipmentmodel->checkPartyRole($party['PartyType'], $orderData['organizationId'],
        //                 $orderData['businessEntityValue']);
        //             $partyInfo = $this->ci->otmstandardbookinghandler->checkPartyDetails(
        //                 $party,
        //                 $orderData['organizationId'],
        //                 $orderData['businessEntityValue'],
        //                 $user_id,
        //                 strtoupper($toParty),
        //                 $orderData['organization'],
        //                 $orderData['businessEntity']
        //             );
        //             $tripParty = [
        //                 'trip_id' => $tripInternalID,
        //                 'involved_party_contact_gid' => $partyInfo['partyContactID'],
        //                 'involved_party_qual_gid' => $partyInfo['party_type_id'],
        //                 'organization_id' => $orderData['organizationId'],
        //                 'bisiness_entity_id' => $orderData['businessEntityValue'],
        //             ];
        //             $updateTripParty = [
        //                 'trip_id' => $tripInternalID,
        //                 'involved_party_qual_gid' => $partyInfo['party_type_id'],
        //                 'organization_id' => $orderData['organizationId'],
        //                 'bisiness_entity_id' => $orderData['businessEntityValue'],
        //             ];
        //             $tripInvolvedPartiesInfo = $this->ci->common->gettblrowdata($tripParty, "trip_involved_party_id", "tb_trips_involved_parties", 0, 0);
        //             if (empty($tripInvolvedPartiesInfo)) {
        //                 $this->ci->common->insertTableData('tb_trips_involved_parties', $tripParty);
        //             } else {
        //                 $this->ci->db->where($updateTripParty)->update("tb_trips_involved_parties", $tripParty);
        //             }
        //         }
        //     } else {
        //         $toParty = $this->ci->otmshipmentmodel->checkPartyRole($orderData['TripHeader']['BusinessParties']['BusinessParty']['PartyType'], $orderData['organizationId'],
        //             $orderData['businessEntityValue']);
        //         $partyInfo = $this->ci->otmstandardbookinghandler->checkPartyDetails(
        //             $orderData['TripHeader']['BusinessParties']['BusinessParty'],
        //             $orderData['organizationId'],
        //             $orderData['businessEntityValue'],
        //             $carrier_id,
        //             strtoupper($toParty),
        //             $orderData['organization'],
        //             $orderData['businessEntity']
        //         );
        //         $tripParty = [
        //             'trip_id' => $tripInternalID,
        //             'involved_party_contact_gid' => $partyInfo['partyContactID'],
        //             'involved_party_qual_gid' => $partyInfo['party_type_id'],
        //             'organization_id' => $orderData['organizationId'],
        //             'bisiness_entity_id' => $orderData['businessEntityValue'],
        //         ];
        //         $updateTripParty = [
        //             'trip_id' => $tripInternalID,
        //             'involved_party_qual_gid' => $partyInfo['party_type_id'],
        //             'organization_id' => $orderData['organizationId'],
        //             'bisiness_entity_id' => $orderData['businessEntityValue'],
        //         ];
        //         $tripInvolvedPartiesInfo = $this->ci->common->gettblrowdata($tripParty, "trip_involved_party_id", "tb_trips_involved_parties", 0, 0);
        //         if (empty($tripInvolvedPartiesInfo)) {
        //             $this->ci->common->insertTableData('tb_trips_involved_parties', $tripParty);
        //         } else {
        //             $this->ci->db->where($updateTripParty)->update("tb_trips_involved_parties", $tripParty);
        //         }
        //     }
        // }

        // if (!empty($orderData['TripHeader']['ManageReferences'])) {
        //     if (array_key_exists("0", $orderData['TripHeader']['ManageReferences']['References']) == 1) {
        //         foreach ($orderData['TripHeader']['ManageReferences']['References'] as $orderRef) {
        //             $toRefCode = $this->ci->otmshipmentmodel->checkCrossReferences($orderRef['RefType']['Code'], $orderData['organizationId'], $orderData['businessEntityValue']);
        //             if (!empty($toRefCode)) {
        //                 $referenceId = $this->ci->otmshipmentmodel->getReferenceId($toRefCode);
        //                 $orderRef['RefType']['Code'] = $referenceId;
        //                 $this->ci->otmshipmentmodel->insertTripReferences($tripInternalID, $orderRef, $orderData['organizationId'], $orderData['businessEntityValue']);
        //             }
        //         }
        //     } else {
        //         $toRefCode = $this->ci->otmshipmentmodel->checkCrossReferences($orderData['TripHeader']['ManageReferences']['References']['RefType']['Code'], $orderData['organizationId'], $orderData['businessEntityValue']);
        //         if (!empty($toRefCode)) {
        //             $referenceId = $this->ci->otmshipmentmodel->getReferenceId($toRefCode);
        //             $orderData['manageReferences']['References']['RefType']['Code'] = $referenceId;
        //             $this->ci->otmshipmentmodel->insertTripReferences($tripInternalID, $orderData['TripHeader']['ManageReferences']['References'], $orderData['organizationId'], $orderData['businessEntityValue']);
        //         }
        //     }
        // }
          /*if (!empty($orderData['TripHeader']['ManageReferences'])) {

            // Convert single reference to array for uniform processing
            $references = array_key_exists("0", $orderData['TripHeader']['ManageReferences']['References']) == 1
                ? $orderData['TripHeader']['ManageReferences']['References']
                : [$orderData['TripHeader']['ManageReferences']['References']];
        
            // Collect all reference codes from the XML itself
            $allReferenceCodes = [];
            foreach ($orderData['TripHeader']['ManageReferences']['References'] as $orderRef) {
                $allReferenceCodes[] = $orderRef['RefType']['Code'];
            }
        
            foreach ($references as $orderRef) {
                $refCode = $orderRef['RefType']['Code'];
        
                if (in_array($refCode, $allReferenceCodes)) {
                    log_message('error', "Reference VALID22: {$refCode} for Organization: {$orderData['organizationId']}, Entity: {$orderData['businessEntityValue']}");
                } else {
                    log_message('error', "Reference INVALID22: {$refCode} for Organization: {$orderData['organizationId']}, Entity: {$orderData['businessEntityValue']}");
                }
            }
        }


        if (!empty($orderData['TripHeader']['Remarks'])) {
            if (array_key_exists("0", $orderData['TripHeader']['Remarks']['RemarkType']) == 1) {
                foreach ($orderData['TripHeader']['Remarks']['RemarkType'] as $orderRem) {
                    $toRemarkCode = $this->ci->otmshipmentmodel->checkCrossRemarks($orderRem['Code'], $orderData['organizationId'],
                        $orderData['businessEntityValue']);
                    if (!empty($toRemarkCode)) {
                        $remarkId = $this->ci->otmshipmentmodel->getRemarkId($toRemarkCode);
                        $orderRem['RemarkType']['Code'] = $remarkId;
                        $this->ci->otmshipmentmodel->insertTripRemarks($tripInternalID, $orderRem, $orderData['organizationId'], $orderData['businessEntityValue']);
                    }
                }
            } else {
                $toRemarkCode = $this->ci->otmshipmentmodel->checkCrossRemarks($orderData['TripHeader']['Remarks']['RemarkType']['Code'], $orderData['organizationId'],
                    $orderData['businessEntityValue']);
                if (!empty($toRemarkCode)) {
                    $remarkId = $this->ci->otmshipmentmodel->getRemarkId($toRemarkCode);
                    $orderData['TripHeader']['Remarks']['RemarkType']['Code'] = $remarkId;
                    $this->ci->otmshipmentmodel->insertTripRemarks($tripInternalID, $orderData['TripHeader']['Remarks'], $orderData['organizationId'], $orderData['businessEntityValue']);
                }
            }
        }*/

        //$endlocationID = empty($endlocationID) ? 0 : $endlocationID;
       
        if (!empty($orderData['TripHeader']['TripStops'])) {
            foreach ($orderData['TripHeader']['TripStops']['TripStop'] as $tripStop) {
               
               $this->insertTripStopsDetails(
    $tripStop,
    isset($orderData['organizationId']) ? (string)$orderData['organizationId'] : '',
    isset($orderData['businessEntityValue']) ? (string)$orderData['businessEntityValue'] : '',
    isset($orderData['businessEntityID']) ? (string)$orderData['businessEntityID'] : '',
    //(int)$tripInternalID,
    $shift_id,
    (int)$startlocationID,
    (int)$endlocationID,
    'NEW',
    isset($orderData['organization']) ? (string)$orderData['organization'] : '',
    isset($orderData['businessEntity']) ? (string)$orderData['businessEntity'] : ''
);
            }
        }

        if (!empty($bookingIDs)) {
    foreach ($bookingIDs as $orders) {
       
        $orderinfo = $this->ci->common->gettblrowdata(
            ['order_id' => $orders],
            "id, customer_id, plat, plng, dlat, dlng, pickup_company, delivery_company, pickup_pincode, delivery_pincode, pickup_city, delivery_city, user_id, shift_id,vendor_id, order_id, pickup_datetime, pickup_endtime, delivery_datetime, drop_endtime, pickup_address1, delivery_address1, pickup_address2, delivery_address2, shipment_id, quantity, weight, volume, pickup_custid, drop_custid, trip_id, transport_mode",
            "tb_orders",
            0,
            0
        );
        
        if (!empty($orderinfo)) {
           
           
            $this->ci->common->updatetbledata(
                "tb_orders",
                 ['shift_id' => $shift_id, 'vendor_id' => $carrierId, 'shipmentid' => $shipment_gid, 'status' => 2],
                ['id' => $orderinfo['id']]
            );
           
            /*$tripOrders = [
                'trip_id'  => $tripInternalID,
                'order_id' => $orderinfo['id'],
            ];

            $orderinfo1 = $this->ci->common->gettblrowdata($tripOrders, "trip_id", "tb_stop_status", 0, 0);
            if (empty($orderinfo1)) {
                $this->ci->common->insertTableData('tb_stop_status', $tripOrders);
                log_message('error', "tb_stop_status inserted | OrderID: {$orderinfo['id']} | TripID: {$tripInternalID}");
            } else {
                log_message('error', "tb_stop_status already exists | OrderID: {$orderinfo['id']} | TripID: {$tripInternalID}");
            }*/

            $this->ci->standardtriphandler->insertOrderAcknowledgementStatus(
                //$tripInternalID,
                $orders,
                $orderData['organizationId'],
                $orderData['businessEntityValue']
            );
           
            $this->ci->common->updatetbledata(
                "tb_orders",
                ['order_status' => 1],
                ['id' => $orderinfo['id'], 'order_id' => $orders]
            );
            
            /*$this->ci->common->updatetbledata(
                "tb_stop_status",
                ['order_id' => $orderinfo['id']],
                ['trip_id' => $tripInternalID]
            );*/
            
            $orderData['ModeOfTransport'] = $orderinfo['transport_mode'];
            $orderData['OrderID'] = $orderinfo['order_id'];
            $orderData['Incoterm'] = '';
            $orderData['FreightTerm'] = '';
            $orderData['FreightTermName'] = '';
            
            $ship_row_id = $this->insertShipmentData($orderData, $orderData['organizationId'], $orderData['businessEntityValue']);
            
            $pickshipArr = [
                'stopname' => $orderinfo['pickup_city'],
                'plat' => $orderinfo['plat'],
                'plng' => $orderinfo['plng'],
                'stopcity' => $orderinfo['pickup_city'],
                'address' => $orderinfo['pickup_address1'],
                'stoptype' => 'P',
                'stopstatus' => 0,
                'shipment_id' => $shift_id,
                'ordernumber' => 1,
                'startdate' => $orderinfo['pickup_datetime'],
                'enddate' => $orderinfo['pickup_endtime'],
                'shipmentstopid' => 0,
                'txncode' => 'NP',
                'status' => 1,
                'order_id' => $orderinfo['id'],
                'weight' => $orderinfo['weight'],
                'volume' => $orderinfo['volume'],
                'created_on' => $cdate
            ];
            $pickupData = $this->ci->common->gettblrowdata(['order_id' => $orderinfo['id'], 'stoptype' => 'P'], "id", "tb_shiporder_stops", 0, 0);
            if (empty($pickupData)) {
                $insPickupShip = $this->ci->common->insertTableData("tb_shiporder_stops", $pickshipArr);
            }
            else
            {
                $insPickupShip = $pickupData['id'];
            }
            $DdropshipArr = [
                'stopname' => $orderinfo['delivery_city'],
                'plat' => $orderinfo['dlat'],
                'plng' => $orderinfo['dlng'],
                'stopcity' => $orderinfo['delivery_city'],
                'address' => $orderinfo['delivery_address1'],
                'stoptype' => 'D',
                'stopstatus' => 0,
                'shipment_id' => $shift_id,
                'ordernumber' => 2,
                'startdate' => $orderinfo['delivery_datetime'],
                'enddate' => $orderinfo['drop_endtime'],
                'shipmentstopid' => 0,
                'txncode' => 'NP',
                'status' => 1,
                'order_id' => $orderinfo['id'],
                'created_on' => $cdate
            ];
            $deliveryData = $this->ci->common->gettblrowdata(['order_id' => $orderinfo['id'], 'stoptype' => 'D'], "id", "tb_shiporder_stops", 0, 0);
            if (empty($deliveryData)) {
                $insDropShip = $this->ci->common->insertTableData("tb_shiporder_stops", $DdropshipArr);   
            }
            else
            {
                $insDropShip = $deliveryData['id'];
            }
          
            $employeearr = [
                'assoc_id ' => $shipment_gid,
                'customer_id' => $orderinfo['customer_id'],
                'plat' => $orderinfo['plat'],
                'plng' => $orderinfo['plng'],
                'dlat' => $orderinfo['dlat'],
                'dlng' => $orderinfo['dlng'],
                'pickup_city'       => $orderinfo['pickup_city'],
                'drop_city'     => $orderinfo['delivery_city'],
                'user_id' => $orderinfo['user_id'],
                'shift_id' => $shift_id,
                'vendor_id' => $carrierId,
                'order_id' => $orderinfo['order_id'],
                'status' => 1,
                'startdate' => $orderinfo['pickup_datetime'],
                'enddate' => $orderinfo['delivery_datetime'],
                'pickup_datetime' => $orderinfo['pickup_datetime'],
                'drop_datetime' => $orderinfo['delivery_datetime'],
                'pickup' => $orderinfo['pickup_address1'],
                'drop' => $orderinfo['delivery_address1'],
                'ship_type' => 'P',
                'stop_id' => $insPickupShip,
                'drop_stopid' => $insDropShip,
                'stop_order' => 1,
                'address' => $orderinfo['pickup_address1'],
                'createdon' => $cdate,
                'shipment_id' => $orderinfo['pickup_address1'],
                'capacity' => $orderinfo['quantity'],
                'shipment_weight' => $orderinfo['weight'],
                'shipment_volume' => $orderinfo['volume'],
                //'trip_id' => $tripInternalID,
            ];
            
            $employeeData = $this->ci->common->gettblrowdata(['order_id' => $orderinfo['order_id']], "id", "tb_employee", 0, 0);
            if (empty($employeeData)) {
                $employeeRowId = $this->ci->common->insertTableData("tb_employee", $employeearr);
            }
            
            $getstatusid = $this->ci->db->select( "id" )->get_where( "tb_status_master", array( 'status_code' => 'SV0100') );
             $status_id = 0;
            if ( $getstatusid->num_rows() > 0 ) {
                $status_id = $getstatusid->row()->id;
            }

            $tripOrders = [
                //'trip_id'  => $tripInternalID,
                'order_id' => $orderinfo['id'],
            ];

            $orderinfo1 = $this->ci->common->gettblrowdata($tripOrders, "trip_id", "tb_stop_status", 0, 0);
            if (empty($orderinfo1)) {
                $insertedStatus = $this->ci->common->insertTableData("tb_stop_status", ['order_id' => $orderinfo['id'], 'status_id' => $status_id, 'status_code' => 'SV0100', 'shipment_id' => $shift_id, 'stop_type' => '', 'loc_name' => '', 'comment' => '', 'status' => '1', 'reason' => '', 'createdon' => $cdate]);
                } 
            }
            
            $thuData = [];

            if (! empty($orderData['TripOrderDetails']['CargoDetails']['CargoThuDetails'])) {
                $thuData = $orderData['TripOrderDetails']['CargoDetails']['CargoThuDetails'];
            }

            log_message("error", "thuData:" . json_encode($thuData));

            $orderCargoDetails = [];

            if (is_array($thuData) && array_key_exists(0, $thuData)) {

                foreach ($thuData as $orderCargo) {

                    $cargoType     = is_array($orderCargo['CargoType']) ? '' : $orderCargo['CargoType'];
                    $valueOfGoods  = is_array($orderCargo['ValueOfGoods']) ? '' : $orderCargo['ValueOfGoods'];
                    $cargoQuantity = is_array($orderCargo['Quantity']) ? '' : $orderCargo['Quantity'];
                    $itemId        = is_array($orderCargo['ItemID']) ? '' : $orderCargo['ItemID'];

                    $innerCargo = [];

                    if (! empty($orderCargo['PackagingUnit'])) {

                        if (is_array($orderCargo['PackagingUnit']) && array_key_exists(0, $orderCargo['PackagingUnit'])) {

                            foreach ($orderCargo['PackagingUnit'] as $packagingunit) {
                                $innerCargo[] = [
                                    'cargo_type' => is_array($packagingunit['PackageType']) ? '' : $packagingunit['PackageType'],
                                    'quantity'   => is_array($packagingunit['Quantity']) ? '' : $packagingunit['Quantity'],
                                ];
                            }

                        } else {
                            $innerCargo[] = [
                                'cargo_type' => is_array($orderCargo['PackagingUnit']['PackageType']) ? '' : $orderCargo['PackagingUnit']['PackageType'],
                                'quantity'   => is_array($orderCargo['PackagingUnit']['Quantity']) ? '' : $orderCargo['PackagingUnit']['Quantity'],
                            ];
                        }
                    }

                    $orderCargoDetails[] = [
                        'cargo_type'     => $cargoType,
                        'item_id'        => $itemId,
                        'value_of_goods' => $valueOfGoods,
                        'quantity'       => $cargoQuantity,
                        'packaging'      => $innerCargo,
                    ];
                }

            } else {

                $cargoType     = is_array($thuData['CargoType']) ? '' : $thuData['CargoType'];
                $valueOfGoods  = is_array($thuData['ValueOfGoods']) ? '' : $thuData['ValueOfGoods'];
                $cargoQuantity = is_array($thuData['Quantity']) ? '' : $thuData['Quantity'];
                $itemId        = is_array($thuData['ItemID']) ? '' : $thuData['ItemID'];

                $innerCargo = [];

                if (! empty($thuData['PackagingUnit'])) {

                    if (is_array($thuData['PackagingUnit']) && array_key_exists(0, $thuData['PackagingUnit'])) {

                        foreach ($thuData['PackagingUnit'] as $packagingunit) {
                            $innerCargo[] = [
                                'cargo_type' => is_array($packagingunit['PackageType']) ? '' : $packagingunit['PackageType'],
                                'quantity'   => is_array($packagingunit['Quantity']) ? '' : $packagingunit['Quantity'],
                            ];
                        }

                    } else {
                        $innerCargo[] = [
                            'cargo_type' => is_array($thuData['PackagingUnit']['PackageType']) ? '' : $thuData['PackagingUnit']['PackageType'],
                            'quantity'   => is_array($thuData['PackagingUnit']['Quantity']) ? '' : $thuData['PackagingUnit']['Quantity'],
                        ];
                    }
                }

                $orderCargoDetails[] = [
                    'cargo_type'     => $cargoType,
                    'item_id'        => $itemId,
                    'value_of_goods' => $valueOfGoods,
                    'quantity'       => $cargoQuantity,
                    'packaging'      => $innerCargo,
                ];
            }

            if($carrierCode == APACEKART)
            {
                $tkn_ref     = ['order_id' => $orderinfo['id'], 'reference_id' => 'TKN'];
                $checkTKNRef = $this->ci->common->gettblrowdata($tkn_ref, "id,ref_value", "tb_order_references", 0, 0);
                if (count($checkTKNRef) == 0) {
                    $docketNo = $this->ci->flipkartediservices->getDocketNo();
                    $tkn_ref['ref_value'] = $docketNo;
                    $this->ci->common->insertTableData("tb_order_references", $tkn_ref);
                    $currentdate          = date('d-m-Y');
                    $total_weight = $total_quantity = 0;
                    $sql = 'SELECT sum(weight) as total_weight, sum(quantity) as total_quantity FROM tb_order_cargodetails WHERE order_id = ?';
                    $gettotal = $this->ci->db->query($sql, [$orderinfo['id']]);
                    if ($gettotal->num_rows() > 0) {
                        //$total_weight = $gettotal->row()->total_weight;
                        //$total_quantity = $gettotal->row()->total_quantity;
                    }
                    $cargo_forship = $lbhData = [];
                    $sql1 = 'SELECT toc.weight as weight, toc.quantity as quantity, toc.cargo_id as cargoId, tcd.length as length, tcd. width as width, tcd.height as height, tcd.length_unit as length_unit, tcd. width_unit as width_unit, tcd.height_unit as height_unit FROM tb_order_cargodetails toc, tb_cargo_details tcd  WHERE toc.cargo_id=tcd.id and toc.order_id = ? and toc.status=1';
                    $getcargos = $this->ci->db->query($sql1, [$orderinfo['id']]);
                    
                    if ($getcargos->num_rows() > 0) {
                        foreach ($getcargos->result() as $res) {
                            $quantity = 0;
                            $weight = $res->weight;
                            $weightUnit = $res->volweight_uom;
                            $quantity = $res->quantity;
                            $orderId = $orderinfo['order_id'];
                            $cargoId = $res->cargoId;
                            $length = $res->length;
                            $lengthUnit = $res->length_unit;
                            $width = $res->width;
                            $widthUnit = $res->width_unit;
                            $height = $res->height;
                            $heightUnit = $res->height_unit;
                            
                            $packetNo = $orderId.'-'.$cargoId;
                            
                            $lengthVal  = $this->ci->frieghttrack->convertToInches($length,  $lengthUnit);
                            $breadthVal = $this->ci->frieghttrack->convertToInches($width, $widthUnit);
                            $heightVal  = $this->ci->frieghttrack->convertToInches($height,  $heightUnit);
                            $weightVal  = $this->ci->Order->weightConvertKgs((string)$weightUnit, (float)($weight));
                            
                            $lbhData[] = [
                                "packetCount"         => (int)$quantity,
                                "packetLength"        => ($this->formatNumber($lengthVal) < 1 ? 1 : $this->formatNumber($lengthVal)),
                                "packetWidth"         => ($this->formatNumber($breadthVal) < 1 ? 1 : $this->formatNumber($breadthVal)),
                                "packetHeight"        => ($this->formatNumber($heightVal) < 1 ? 1 : $this->formatNumber($heightVal)),
                                "packetNo"            => null,
                                "customerPacketRefNo" => $packetNo,
                                "actualWeight"        => $this->formatNumber($weightVal),
                                "invoiceNo"           => null,
                            ];
                        
                            $total_quantity = $total_quantity + ((int)$quantity < 1 ? 1 : (int)$quantity);
                            $total_weight = $total_weight + ((int)$weightVal < 1 ? 1 : (int)$weightVal);
                        }
                    }

                    $flipkartRequest = [
                        "poNumber"                => (string)$orderinfo['order_id'],
                        "travelMode"              => "Road",
                        "grossWeight"             => $this->formatNumber($total_weight < 1 ? 1 : $total_weight),
                        "packetCount"             => (int)$total_quantity < 1 ? 1 : (int)$total_quantity,
                        "material"                => null,
                        "deliveryAppointmentDate" => null,
                        "deliveryTimeSlot"        => null,
                        "lbhData"                 => $lbhData,
                        "invoiceDetails"          => [
                            [
                                "invoiceNo"     => (string)$orderinfo['order_id'],
                                "invoiceAmount" => 1,
                                "ewbNo"         => null,
                                "invoiceDate"   => $currentdate,
                                "ewbDate"       => null,
                                "ewbValidTill"  => null,
                            ],
                        ],
                        "consignor"               => [
                            "consignorCode"    => null,
                            "consignorPincode" => trim($orderinfo['pickup_pincode']),
                            "consignorName"    => trim($orderinfo['pickup_company']),
                            "address1"         => trim($orderinfo['pickup_address1']), //"13th Floor, AIPL Business Club, Golf Course Extension Road, Sector 62, Gurugram, Haryana, 12210",
                            "city"             => trim($orderinfo['pickup_city']),
                            "state"            => trim($orderinfo['pickup_address2']),
                            "contactName"      => null,
                            "contactPhoneno"   => null,
                            "email"            => "",
                        ],
                        "consignee"               => [
                            "consigneeCode"    => null,
                            "consigneePincode" => trim($orderinfo['delivery_pincode']),
                            "consigneeName"    => trim($orderinfo['delivery_company']),
                            "address1"         => trim($orderinfo['delivery_address1']),
                            "city"             => trim($orderinfo['delivery_city']),
                            "state"            => trim($orderinfo['delivery_address2']),
                            "contactName"      => null,
                            "contactPhoneno"   => null,
                            "email"            => null,
                        ],
                        "docketNo"                => $docketNo,
                        "packetLbhUom"            => "IN",
                        "totalConsignmentValue"   => 1,
                        "ftlOrPtl"                => "0",
                        "openBoxPickup"           => 0,
                        "truckType"               => null,
                    ];
                    log_message("error","flipkartRequest:".json_encode($flipkartRequest));
                    $flipkartResponse = $this->ci->flipkartediservices->createOrder($flipkartRequest);
                    log_message("error","flipkartResponse:".json_encode($flipkartResponse));
                    $docketImg = "https://elog360.app/svkonekt_test/assets/poduploads/" . $orderinfo['order_id'] . "_" . $docketNo . "_Docket.pdf";
                    $labelImg = "https://elog360.app/svkonekt_test/assets/poduploads/" . $orderinfo['order_id'] . "_" . $docketNo . "_Label.pdf";

                    $fileContent = file_get_contents($docketImg);
                    $base64 = 'data:application/pdf;base64,'.base64_encode($fileContent);
                    $base64String = base64_encode($fileContent);
                    
                    $domainDetails = $this->ci->OtmBookingModel->getDomain($orderinfo['id']);
                    
                    if (!empty($domainDetails)) {
                        $extOrderId = $domainDetails[0]['external_order_id'];
                        $domainName = $domainDetails[0]['ref_value'];
                        $domainCreatedSource = $domainDetails[0]['created_source'];
                        if($domainName<>"")
                        {
                            $otmRequest = [
                                'glogDate' => date("Ymdhis"),
                                'externalOrderId' => $extOrderId,
                                'domainName' => $domainName,
                                'createdSource'=> $createdsource ? $createdsource :  $domainCreatedSource,
                                'timeZone' => $curtz ?? "",
                                'base64String' => $base64String ?? "",
                                'docType' => 'APACDOCKET' ?? ""
                            ];
                                        
                            $output = sendOTMDocuments($otmRequest);
                        }
                    }

                    $fileContent1 = file_get_contents($labelImg);
                    $base64 = 'data:application/pdf;base64,'.base64_encode($fileContent1);
                    $base64String1 = base64_encode($fileContent1);
                    
                    $domainDetails1 = $this->ci->OtmBookingModel->getDomain($orderinfo['id']);
                    
                    if (!empty($domainDetails1)) {
                        $extOrderId = $domainDetails1[0]['external_order_id'];
                        $domainName = $domainDetails1[0]['ref_value'];
                        $domainCreatedSource = $domainDetails1[0]['created_source'];
                        if($domainName<>"")
                        {
                            $otmRequest = [
                                'glogDate' => date("Ymdhis"),
                                'externalOrderId' => $extOrderId,
                                'domainName' => $domainName,
                                'createdSource'=> $createdsource ? $createdsource :  $domainCreatedSource,
                                'timeZone' => $curtz ?? "",
                                'base64String' => $base64String1 ?? "",
                                'docType' => 'APACLABEL' ?? ""
                            ];
                                        
                            $output = sendOTMDocuments($otmRequest);
                        }
                    }
                }
            }   
        }
    } 


        /*$userId = $this->ci->otmbookingmodel->getUserId('Integration');
        $TripDrivers = [
        'trip_id' => $tripInternalID,
        'vehicle_id' => $vehicle_id,
        'carrier_id' => $carrier_id,
        'driver_id' => $driver_id,
        'status' => 1,
        'user_id' => $userId
        ];
        $tripDriversInfo = $this->ci->common->gettblrowdata($TripDrivers, "id", "tb_trip_assigned_drivers", 0, 0);
        if (empty($tripDriversInfo)) {
        $this->ci->common->insertTableData('tb_trip_assigned_drivers', $TripDrivers);
        }*/
        return $shipment_gid;
    }
    
    public function insertShipmentData(
        array $orderData,
        string $company_code,
        string $branch_code
    ): int {
        $cdate = date('Y-m-d H:i:s');
        if (! empty($orderData['OrderID'])) {
            $shipment_id = $orderData['OrderID'];
        } else {
            $shipment_id = "SVK" . time();
        }
        
        $transportmodeid  = $transportmodename  = "";
        $gettrasnportmode = $this->ci->Standardbookingmodel->getTransportModeName($orderData['ModeOfTransport']);
        if (! empty($gettrasnportmode)) {
            $transportmodeid   = $gettrasnportmode['id'];
            $transportmodename = $gettrasnportmode['name'];
        }
        $incoterm        = empty($orderData['Incoterm']) ?? "";
        $freightTerm     = empty($orderData['FreightTerm']) ?? "60";
        $freightTermName = empty($orderData['FreightTermName']) ?? "Free of Charge";
        $enddate = "";
        //$enddate         = date('Y-m-d H:i:s', strtotime("+1 day"));
        $ship_arr        = [
            'shipid'           => $shipment_id,
            'txnid'            => $shipment_id,
            'trucktype'        => $transportmodename,
            'pickupcnt'        => '1',
            'dropcnt'          => '1',
            'unitspec'         => 1,
            'insertusr'        => "",
            'carrier'          => '0',
            'insertuserdate'   => $cdate,
            'enddate'          => $enddate,
            'insdate'          => $cdate,
            'upddate'          => $cdate,
            'reason'           => 'SHIPMENT',
            'purpose'          => 'SEND INTEGRATION',
            'ship_object'      => 'SHIPMENT',
            'logdate'          => $cdate,
            'transport_mode'   => $orderData['ModeOfTransport'],
            'domainname'       => $branch_code,
            'company_code'     => $company_code,
            'branch_code'      => $branch_code,
            'product'          => $orderData['Product'],
            'freight_term'     => $freightTerm,
            'freight_termname' => $freightTermName,
            'incoterm'         => $incoterm,
            'modeoftransport'  => $transportmodeid,
        ];
        $checkShipid = $this->ci->common->gettblrowdata(['shipid' => $shipment_id], "id", "tb_shipments", 0, 0);
        if (! empty($checkShipid)) {
            $this->ci->db->where(['id' => $checkShipid['id']])->update("tb_shipments", $ship_arr);
            $ship_row_id = $checkShipid['id'];
        } else {
            $ship_arr['createdon'] = $cdate;
            $ship_ins              = $this->ci->db->insert("tb_shipments", $ship_arr);
            $ship_row_id           = $this->ci->db->insert_id();
        }
        return $ship_row_id;
    }

   /* private function insertReferenceInfo(int $tripInternalID, array $orderData, string $toRefCode, array $orderRef): array
    {
        $refId = $this->ci->otmbookingmodel->checkRefMaster($orderRef['RefType']['Code']);
        if ($refId > 0) {
            $orderRef['RefType']['Code'] = $refId;
            $this->ci->otmshipmentmodel->insertTripReferences(
                $tripInternalID,
                $orderData['organizationId'],
                $orderData['businessEntityValue'],
                $orderRef
            );
        }
        return $orderRef;
    }

    private function insertRemarkInfo(int $tripInternalID, array $orderData, string $toRemarkCode, array $orderRem): array
    {
        $remId = $this->ci->otmbookingmodel->checkRemMaster($orderRem['RemarkType']['Code']);
        if ($remId > 0) {
            $orderRem['RemarkType']['Code'] = $remId;
            $this->ci->otmshipmentmodel->insertTripRemarks(
                $tripInternalID,
                $orderData['organizationId'],
                $orderData['businessEntityValue'],
                $orderRem
            );
        }
        return $orderRem;
    } */

    public function insertTripStopsDetails(
        array $tripStop,
        string $organizationId,
        string $businessEntityValue,
        string $businessEntityID,
        //int $tripId,
        int $shipmentId,
        int $startlocationID,
        int $endlocationID,
        string $type,
        string $organization,
        string $businessEntity
    ): void {
         
        if ($type == 'NEW') {
            $sequence = $tripStop['StopSequence'];
            $stopType = $tripStop['StopType'];
            $locationRoleId = 0;
            if ($stopType == "P") {
                $partyType = "PICKUP";
                $locationRoleId = "1";
            }
            if ($stopType == "D") {
                $partyType = "DELIVERY";
                $locationRoleId = "2";
            }
            $locationId = $this->ci->otmstandardbookinghandler->checkPartyDetails(
                $tripStop['Address'],
                $organizationId,
                $businessEntityValue,
                0,
                $partyType
            );
            $locationId = $locationId['partyContactID'];
        }

        if (!empty($tripStop['TripStopDetail'])) {
            if (array_key_exists("0", $tripStop['TripStopDetail']) == 1) {
                foreach ($tripStop['TripStopDetail'] as $tripStopDetail) {
                     
                    $tripStopsInfo = [
                        //'trip_id' => $tripId,
                        'stop_detail_id' => is_array($sequence) ? "" : $sequence,
                        'location_gid' => empty($locationId) ? "0" : $locationId,
                        'location_role_gid' => empty($locationRoleId) ? "0" : $locationRoleId,
                        'planned_arrival' => is_array($tripStop['ArrivalTime']['PlannedTime']) ? "" : $tripStop['ArrivalTime']['PlannedTime'],
                        'estimated_arrival' => is_array($tripStop['ArrivalTime']['EstimatedTime']) ? "" : $tripStop['ArrivalTime']['EstimatedTime'],
                        'planned_departure' => is_array($tripStop['DepartureTime']['PlannedTime']) ? "" : $tripStop['DepartureTime']['PlannedTime'],
                        'estimated_departure' => is_array($tripStop['DepartureTime']['EstimatedTime']) ? "" : $tripStop['DepartureTime']['EstimatedTime'],
                        'dist_from_prev_stop' => is_array($tripStop['DistFromPrevStop']['DistanceValue']) ? "" : $tripStop['DistFromPrevStop']['DistanceValue'],
                        'dist_from_prev_stop_uom_code' => is_array($tripStop['DistFromPrevStop']['DistanceUOMGid']) ? "" : $tripStop['DistFromPrevStop']['DistanceUOMGid'],
                        'activity_time_base' => empty($tripStopDetail['ActivityBase']) ? "" : $tripStopDetail['ActivityBase'],
                        'activity_time' => empty($tripStopDetail['DurationValue']) ? "" : $tripStopDetail['DurationValue'],
                        'activity_time_uom_code' => empty($tripStopDetail['DurationUOMGid']) ? "" : $tripStopDetail['DurationUOMGid'],
                        'ship_unit_id' => empty($tripStopDetail['ShipUnitId']) ? "" : $tripStopDetail['ShipUnitId'],
                        'stop_type' => is_array($tripStop['StopType']) ? empty($tripStop['TripStopDetail']['ActivityBase']) ? "" : $tripStop['TripStopDetail']['ActivityBase'] : $tripStop['StopType'],
                        'is_permanent' => is_array($tripStop['IsPermanent'] == 'N') ? 1 : 0,
                        'is_depot' => is_array($tripStop['IsDepot'] == 'N') ? 1 : 0,
                        'accessorial_time' => is_array($tripStop['AccessorialTime']['DurationValue']) ? "" : $tripStop['AccessorialTime']['DurationValue'],
                        'accessorial_time_uom_code' => is_array($tripStop['AccessorialTime']['DurationUOMGid']) ? "" : $tripStop['AccessorialTime']['DurationUOMGid'],
                        'rush_hour_time' => is_array($tripStop['RushHourTime']['DurationValue']) ? "" : $tripStop['RushHourTime']['DurationValue'],
                        'rush_hour_time_uom_code' => is_array($tripStop['RushHourTime']['DurationUOMGid']) ? "" : $tripStop['RushHourTime']['DurationUOMGid'],
                        'is_mother_vessel' => is_array($tripStop['IsMotherVessel']) ? "" : $tripStop['IsMotherVessel'],
                        'organization_id' => $organizationId,
                        'entity_value_id' => $businessEntityValue,
                        'status' => 1,
                    ];

                    $shipUnitId = empty($tripStopDetail['ShipUnitId']) ? "" : $tripStopDetail['ShipUnitId'];

                    $checkTripStops = [
                        'shipment_id' => $shipmentId,
                        'stop_detail_id' => $sequence,
                        // 'ship_unit_id' => $shipUnitId,
                        'location_gid' => empty($locationId) ? "0" : $locationId,
                        'location_role_gid' => empty($locationRoleId) ? "0" : $locationRoleId,
                        // 'organization_id' => $organizationId,
                        // 'entity_value_id' => $businessEntityValue,
                    ];

                    $checkStopLocation = $this->ci->common->gettblrowdata(
                        $checkTripStops,
                        "stop_id",
                        "tb_stop_status",
                        0,
                        0
                    );

                    if (empty($checkStopLocation)) {
                        $stop_id = $this->ci->common->insertTableData('tb_stop_status', $tripStopsInfo);
                    } else {
                        $stop_id = $checkStopLocation['stop_id'];
                        $this->ci->common->updatetbledata(
                            "tb_stop_status",
                            $tripStopsInfo,
                            ['stop_id' => $stop_id, 
                            // 'ship_unit_id' => $shipUnitId
                            ]
                        );
                    }
                   
                }
            } else {
                // $tripStopsInfo = [
                //     'trip_id' => $tripId,
                //     'stop_detail_id' => is_array($sequence) ? "" : $sequence,
                //     'location_gid' => empty($locationId) ? "0" : $locationId,
                //     'location_role_gid' => empty($locationRoleId) ? "0" : $locationRoleId,
                //     'planned_arrival' => is_array($tripStop['ArrivalTime']['PlannedTime']) ? "" : $tripStop['ArrivalTime']['PlannedTime'],
                //     'estimated_arrival' => is_array($tripStop['ArrivalTime']['EstimatedTime']) ? "" : $tripStop['ArrivalTime']['EstimatedTime'],
                //     'planned_departure' => is_array($tripStop['DepartureTime']['PlannedTime']) ? "" : $tripStop['DepartureTime']['PlannedTime'],
                //     'estimated_departure' => is_array($tripStop['DepartureTime']['EstimatedTime']) ? "" : $tripStop['DepartureTime']['EstimatedTime'],
                //     'dist_from_prev_stop' => is_array($tripStop['DistFromPrevStop']['DistanceValue']) ? "" : $tripStop['DistFromPrevStop']['DistanceValue'],
                //     'dist_from_prev_stop_uom_code' => is_array($tripStop['DistFromPrevStop']['DistanceUOMGid']) ? "" : $tripStop['DistFromPrevStop']['DistanceUOMGid'],
                //     'activity_time_base' => empty($tripStop['TripStopDetail']['ActivityBase']) ? "" : $tripStop['TripStopDetail']['ActivityBase'],
                //     'activity_time' => empty($tripStop['TripStopDetail']['DurationValue']) ? "" : $tripStop['TripStopDetail']['DurationValue'],
                //     'activity_time_uom_code' => empty($tripStop['TripStopDetail']['DurationUOMGid']) ? "" : $tripStop['TripStopDetail']['DurationUOMGid'],
                //     'ship_unit_id' => empty($tripStop['TripStopDetail']['ShipUnitId']) ? "" : $tripStop['TripStopDetail']['ShipUnitId'],
                //     'stop_type' => is_array($tripStop['StopType']) ? empty($tripStop['TripStopDetail']['ActivityBase']) ? "" : $tripStop['TripStopDetail']['ActivityBase'] : $tripStop['StopType'],
                //     'is_permanent' => is_array($tripStop['IsPermanent'] == 'N') ? 1 : 0,
                //     'is_depot' => is_array($tripStop['IsDepot'] == 'N') ? 1 : 0,
                //     'accessorial_time' => is_array($tripStop['AccessorialTime']['DurationValue']) ? "" : $tripStop['AccessorialTime']['DurationValue'],
                //     'accessorial_time_uom_code' => is_array($tripStop['AccessorialTime']['DurationUOMGid']) ? "" : $tripStop['AccessorialTime']['DurationUOMGid'],
                //     'rush_hour_time' => is_array($tripStop['RushHourTime']['DurationValue']) ? "" : $tripStop['RushHourTime']['DurationValue'],
                //     'rush_hour_time_uom_code' => is_array($tripStop['RushHourTime']['DurationUOMGid']) ? "" : $tripStop['RushHourTime']['DurationUOMGid'],
                //     'is_mother_vessel' => is_array($tripStop['IsMotherVessel']) ? "" : $tripStop['IsMotherVessel'],
                //     'organization_id' => $organizationId,
                //     'entity_value_id' => $businessEntityValue,
                //     'status' => 1,
                // ];
             $tripStopsInfo = [
    'shipment_id'       => $shipmentId ?? 0,
    'stopnumber'        => $tripStop['StopSequence'] ?? 0,
    'stopduration'      => is_array($tripStop['TripStopDetail']['DurationValue']) 
                           ? '' : ($tripStop['TripStopDetail']['DurationValue'] ?? ''),
    'location'          => $tripStop['Address']['CompanyName'] ?? '',
    'stopcustomer'      => $tripStop['Address']['City'] ?? '',
    'distfrmprevious'   => is_array($tripStop['DistFromPrevStop']) 
                           ? ($tripStop['DistFromPrevStop']['DistanceValue'] ?? '') 
                           : ($tripStop['DistFromPrevStop'] ?? ''),
    'pickupplanned'     => $tripStop['ArrivalTime']['PlannedTime'] ?? null,
    'pickupestimate'    => $tripStop['ArrivalTime']['EstimatedTime'] ?? null,
    'deliveryplan'      => $tripStop['DepartureTime']['PlannedTime'] ?? null,
    'deliveryestimate'  => $tripStop['DepartureTime']['EstimatedTime'] ?? null,
    'stoptype'          => $tripStop['StopType'] ?? 'P',
    'arrivalact'        => '',   // you can add actuals if present
    'arrivalactduration'=> '',   // you can add actuals if present
    'arrivalashipunit'  => $tripStop['TripStopDetail']['ShipUnitId'] ?? '',
    'deliveract'        => '',   // add actuals if present
    'deliveractduration'=> '',   // add actuals if present
    'deliverashipunit'  => $tripStop['TripStopDetail']['ShipUnitId'] ?? '',
    'status'            => 1,
    'createdon'         => date('Y-m-d H:i:s'),
    'updatedon'         => date('Y-m-d H:i:s')
];

$checkTripStops = [
    'shipment_id'  => $shipmentId ?? 0,
    'stopnumber'   => $sequence ?? 0
];

$checkStopLocation = $this->ci->common->gettblrowdata(
    $checkTripStops,
    "id",
    "tb_shipment_stops",
    0,
    0
);

if (empty($checkStopLocation)) {
    $stop_id = $this->ci->common->insertTableData('tb_shipment_stops', $tripStopsInfo);
} else {
    $stop_id = $checkStopLocation['id'];
    $this->ci->common->updatetbledata(
        "tb_shipment_stops",
        $tripStopsInfo,
        ['id' => $stop_id]
    );
}


                // $shipUnitId = empty($tripStop['TripStopDetail']['ShipUnitId']) ? "" : $tripStop['TripStopDetail']['ShipUnitId'];

                // $checkTripStops = [
                //     'trip_id' => $tripId,
                //     'stop_detail_id' => $sequence,
                //     // 'ship_unit_id' => $shipUnitId,
                //     'location_gid' => empty($locationId) ? "0" : $locationId,
                //     'location_role_gid' => empty($locationRoleId) ? "0" : $locationRoleId,
                //     'organization_id' => $organizationId,
                //     'entity_value_id' => $businessEntityValue,
                // ];

                // $checkStopLocation = $this->ci->common->gettblrowdata(
                //     $checkTripStops,
                //     "stop_id",
                //     "tb_stop_status",
                //     0,
                //     0
                // );

                // if (empty($checkStopLocation)) {
                //     $stop_id = $this->ci->common->insertTableData('tb_stop_status', $tripStopsInfo);
                // } else {
                //     $stop_id = $checkStopLocation['stop_id'];
                //     $this->ci->common->updatetbledata(
                //         "tb_stop_status",
                //         $tripStopsInfo,
                //         ['stop_id' => $stop_id, 
                //         // 'ship_unit_id' => $shipUnitId
                //         ]
                //     );
                // }
            }
        }
    }

    public function getLocationDetails(
        array $locationDetails,
        int $organizationId,
        int $businessEntityValue,
        int $businessEntityID
    ): int {
        $party_location = [
            'name' => is_array($locationDetails['CompanyName']) ? "0" : $locationDetails['CompanyName'],
            'organization_id' => $organizationId,
            'business_entity_value' => $businessEntityValue,
            'business_entity' => $businessEntityID,
            'status' => 1,
        ];

        $checkLocation = $this->ci->common->gettblrowdata(
            $party_location,
            "party_location_id",
            "tb_party_location",
            0,
            0
        );

        if (empty($checkLocation) || $checkLocation === 0) {
            $partyLocationInfo = [
                'name' => is_array($locationDetails['CompanyName']) ? "" : $locationDetails['CompanyName'],
                'address1' => is_array($locationDetails['Address1']) ? "" : $locationDetails['Address1'],
                'address2' => is_array($locationDetails['Address2']) ? "" : $locationDetails['Address2'],
                'city' => is_array($locationDetails['City']) ? "" : $locationDetails['City'],
                'street' => is_array($locationDetails['Street']) ? "" : $locationDetails['Street'],
                'state' => is_array($locationDetails['State']) ? "" : $locationDetails['State'],
                'country' => is_array($locationDetails['Country']) ? "" : $locationDetails['Country'],
                'postal_code' => is_array($locationDetails['Postal']) ? "" : $locationDetails['Postal'],
                'province' => is_array($locationDetails['State']) ? "" : $locationDetails['State'],
                'latitude' => is_array($locationDetails['Latitude']) ? "" : $locationDetails['Latitude'],
                'longitude' => is_array($locationDetails['Longitude']) ? "" : $locationDetails['Longitude'],
                'country_code' => is_array(
                    $locationDetails['ContactInfo']['CountryCode']
                ) ? "" : $locationDetails['ContactInfo']['CountryCode'],
                'phone' => is_array(
                    $locationDetails['ContactInfo']['ContactNo']
                ) ? "0" : $locationDetails['ContactInfo']['ContactNo'],
                'email' => is_array(
                    $locationDetails['ContactInfo']['EmailAddress']
                ) ? "" : $locationDetails['ContactInfo']['EmailAddress'],
                'organization_id' => $organizationId,
                'business_entity_value' => $businessEntityValue,
                'business_entity' => $businessEntityID,
                'status' => 1,
            ];
            $party_location_id = $this->ci->common->insertTableData('tb_party_contacts', $partyLocationInfo);
        } else {
            $party_location_id = $checkLocation['party_location_id'];
        }

        return $party_location_id ?? 0;
    }

    public function getLocationRoleDetails(
        string $locationRoleGid
    ): int {
        $party_role = [
            'party_role' => $locationRoleGid,
            'status' => 1,
        ];
        $checkLocationRole = $this->ci->common->gettblrowdata(
            $party_role,
            "id",
            "tb_party_roles",
            0,
            0
        );
        if (!empty($checkLocationRole)) {
            $partyRole = $checkLocationRole['id'];
        }

        return $partyRole ?? 0;
    }

    public function getDriverDetails(
        array $DriverDetails,
        int $organizationId,
        int $businessEntityValue,
        int $businessEntityID,
        int $carrier_id,
        int $vehicle_id
    ): int {
        $DriverId = is_array($DriverDetails['DriverId']) ? "0" : $DriverDetails['DriverId'];
        $DriverName = is_array($DriverDetails['DriverName']) ? "" : $DriverDetails['DriverName'];
        $DriverLicence = is_array($DriverDetails['DriverLicence']) ? "" : $DriverDetails['DriverLicence'];
        $Address1 = is_array($DriverDetails['Address']['Address1']) ? "" : $DriverDetails['Address']['Address1'];
        $Address2 = is_array($DriverDetails['Address']['Address2']) ? "" : $DriverDetails['Address']['Address2'];
        $Street = is_array($DriverDetails['Address']['Street']) ? "" : $DriverDetails['Address']['Street'];
        $City = is_array($DriverDetails['Address']['City']) ? "" : $DriverDetails['Address']['City'];
        $State = is_array($DriverDetails['Address']['State']) ? "" : $DriverDetails['Address']['State'];
        $Postal = is_array($DriverDetails['Address']['Postal']) ? "" : $DriverDetails['Address']['Postal'];
        $Country = is_array($DriverDetails['Address']['Country']) ? "" : $DriverDetails['Address']['Country'];
        $CountryCode = is_array(
            $DriverDetails['Address']['ContactInfo']['CountryCode']
        ) ? "" : $DriverDetails['Address']['ContactInfo']['CountryCode'];
        $ContactNo = is_array(
            $DriverDetails['Address']['ContactInfo']['ContactNo']
        ) ? "" : $DriverDetails['Address']['ContactInfo']['ContactNo'];
        $EmailAddress = is_array(
            $DriverDetails['Address']['ContactInfo']['EmailAddress']
        ) ? "" : $DriverDetails['Address']['ContactInfo']['EmailAddress'];
        $checkParty = $this->ci->common->gettblrowdata(
            ["driver_name" => $DriverName, 'driving_licence_num' => $DriverLicence, 'status' => "Active"],
            "driver_id",
            "tb_driver_details",
            0,
            0
        );
        if (!empty($checkParty)) {
            $driver_id = $checkParty['driver_id'];
        } else {
            $driverData = [
                'driver_name' => $DriverName,
                'contact_num' => $ContactNo,
                'password' => password_hash($ContactNo, PASSWORD_DEFAULT),
                'driving_licence_num' => $DriverLicence,
                'address1' => $Address1,
                'address2' => $Address2,
                'street' => $Street,
                'city' => $City,
                'state' => $State,
                'pincode' => $Postal,
                'country' => $Country,
                'email' => $EmailAddress,
                "organization_id" => $organizationId,
                "business_entity_value_id" => $businessEntityValue,
                'status' => 1,
            ];
            $driver_id = $this->ci->common->insertTableData('tb_driver_details', $driverData);
        }

        return $driver_id ?? 0;
    }

    public function getVehicleDetails(
        array $VehicleDetails,
        string $organizationId,
        string $businessEntityValue,
        string $businessEntityID,
        int $carrier_id
    ): int {
        // $vehicleTypeCode = is_array($VehicleDetails['VehicleTypeCode']) ? "0" : $VehicleDetails['VehicleTypeCode'];
         $vehicleTypeCode  = isset($VehicleDetails['VehicleTypeCode']) ? (string)$VehicleDetails['VehicleTypeCode'] : '';
        $vehicleModelCode = isset($VehicleDetails['VehicleModelCode']) ? (string)$VehicleDetails['VehicleModelCode'] : '';

        /*$VehicleModelCode = is_array($VehicleDetails['VehicleModelCode']) ? "0" : $VehicleDetails['VehicleModelCode'];
        $RegistrationNumber = is_array(
        $VehicleDetails['RegistrationNumber']
        ) ? "0" : $VehicleDetails['RegistrationNumber'];
        $License = is_array($VehicleDetails['License']) ? "0" : $VehicleDetails['License'];
        $ApplicableForDangerousGoods = is_array(
        $VehicleDetails['ApplicableForDangerousGoods']
        ) ? "0" : $VehicleDetails['ApplicableForDangerousGoods'];
        $CommodityType = is_array($VehicleDetails['CommodityType']) ? "0" : $VehicleDetails['CommodityType'];
        $minWeight = is_array(
        $VehicleDetails['Properties']['Weight']['Min']
        ) ? "0" : $VehicleDetails['Properties']['Weight']['Min'];
        $maxWeight = is_array(
        $VehicleDetails['Properties']['Weight']['Max']
        ) ? "0" : $VehicleDetails['Properties']['Weight']['Max'];
        $weightUOM = is_array(
        $VehicleDetails['Properties']['Weight']['UOM']
        ) ? "0" : $VehicleDetails['Properties']['Weight']['UOM'];
        $minVolume = is_array(
        $VehicleDetails['Properties']['Volume']['Min']
        ) ? "0" : $VehicleDetails['Properties']['Volume']['Min'];
        $maxVolume = is_array(
        $VehicleDetails['Properties']['Volume']['Max']
        ) ? "0" : $VehicleDetails['Properties']['Volume']['Max'];
        $VolumeUOM = is_array(
        $VehicleDetails['Properties']['Volume']['UOM']
        ) ? "0" : $VehicleDetails['Properties']['Volume']['UOM'];
        $minLength = is_array(
        $VehicleDetails['Properties']['Length']['Min']
        ) ? "0" : $VehicleDetails['Properties']['Length']['Min'];
        $maxLength = is_array(
        $VehicleDetails['Properties']['Length']['Max']
        ) ? "0" : $VehicleDetails['Properties']['Length']['Max'];
        $LengthUOM = is_array(
        $VehicleDetails['Properties']['Length']['UOM']
        ) ? "0" : $VehicleDetails['Properties']['Length']['UOM'];
        $minWidth = is_array(
        $VehicleDetails['Properties']['Width']['Min']
        ) ? "0" : $VehicleDetails['Properties']['Width']['Min'];
        $maxWidth = is_array(
        $VehicleDetails['Properties']['Width']['Max']
        ) ? "0" : $VehicleDetails['Properties']['Width']['Max'];
        $WidthUOM = is_array(
        $VehicleDetails['Properties']['Width']['UOM']
        ) ? "0" : $VehicleDetails['Properties']['Width']['UOM'];
        $minHeight = is_array(
        $VehicleDetails['Properties']['Height']['Min']
        ) ? "0" : $VehicleDetails['Properties']['Height']['Min'];
        $maxHeight = is_array(
        $VehicleDetails['Properties']['Height']['Max']
        ) ? "0" : $VehicleDetails['Properties']['Height']['Max'];
        $HeightUOM = is_array(
        $VehicleDetails['Properties']['Height']['UOM']
        ) ? "0" : $VehicleDetails['Properties']['Height']['UOM'];
        $minDistance = is_array(
        $VehicleDetails['Properties']['Distance']['Min']
        ) ? "0" : $VehicleDetails['Properties']['Distance']['Min'];
        $maxDistance = is_array(
        $VehicleDetails['Properties']['Distance']['Max']
        ) ? "0" : $VehicleDetails['Properties']['Distance']['Max'];
        $DistanceUOM = is_array(
        $VehicleDetails['Properties']['Distance']['UOM']
        ) ? "0" : $VehicleDetails['Properties']['Distance']['UOM'];
        $minDimensionGirth = is_array(
        $VehicleDetails['Properties']['DimensionGirth']['Min']
        ) ? "0" : $VehicleDetails['Properties']['DimensionGirth']['Min'];
        $maxDimensionGirth = is_array(
        $VehicleDetails['Properties']['DimensionGirth']['Max']
        ) ? "0" : $VehicleDetails['Properties']['DimensionGirth']['Max'];
        $DimensionGirthUOM = is_array(
        $VehicleDetails['Properties']['DimensionGirth']['UOM']
        ) ? "0" : $VehicleDetails['Properties']['DimensionGirth']['UOM'];
        $minShipmentUnit = is_array(
        $VehicleDetails['Properties']['ShipmentUnit']['Min']
        ) ? "0" : $VehicleDetails['Properties']['ShipmentUnit']['Min'];
        $maxShipmentUnit = is_array(
        $VehicleDetails['Properties']['ShipmentUnit']['Max']
        ) ? "0" : $VehicleDetails['Properties']['ShipmentUnit']['Max'];
        $ShipmentUnitUOM = is_array(
        $VehicleDetails['Properties']['ShipmentUnit']['UOM']
        ) ? "0" : $VehicleDetails['Properties']['ShipmentUnit']['UOM'];
        $minPacketWeight = is_array(
        $VehicleDetails['Properties']['PacketWeight']['Min']
        ) ? "0" : $VehicleDetails['Properties']['PacketWeight']['Min'];
        $maxPacketWeight = is_array(
        $VehicleDetails['Properties']['PacketWeight']['Max']
        ) ? "0" : $VehicleDetails['Properties']['PacketWeight']['Max'];
        $PacketWeightUOM = is_array(
        $VehicleDetails['Properties']['PacketWeight']['UOM']
        ) ? "0" : $VehicleDetails['Properties']['PacketWeight']['UOM'];
        $minPacketVolume = is_array(
        $VehicleDetails['Properties']['PacketVolume']['Min']
        ) ? "0" : $VehicleDetails['Properties']['PacketVolume']['Min'];
        $maxPacketVolume = is_array(
        $VehicleDetails['Properties']['PacketVolume']['Max']
        ) ? "0" : $VehicleDetails['Properties']['PacketVolume']['Max'];
        $PacketVolumeUOM = is_array(
        $VehicleDetails['Properties']['PacketVolume']['UOM']
        ) ? "0" : $VehicleDetails['Properties']['PacketVolume']['UOM'];*/
        // $vehicleTypeInfo = [
        //     "vehicle_type_id" => $vehicleTypeCode,
        //     "vehicle_type_name" => $vehicleTypeCode,
        //     "organization_id" => $organizationId,
        //     "business_entity_id" => $businessEntityID,
        //     "business_entity_value_id" => $businessEntityValue,
        //     'status' => 1,
        // ];
            $vehicleData = [
            "vehicle_type_code"    => $vehicleTypeCode,
            "vehicle_model_code"   => $vehicleModelCode,
            "status"               => 1,
           ];
         $VehicleType = $this->ci->db
        ->where('vehicle_type_code', $vehicleTypeCode)
        ->where('vehicle_model_code', $vehicleModelCode)
        
        ->get('tb_vehicle_master')
        ->row_array();

        if (!empty($VehicleType)) {
            return (int)$VehicleType['id']; 
        }

        
        $this->ci->db->insert('tb_vehicle_master', $vehicleData);
        return (int)$this->ci->db->insert_id();
    }

        // $vehicle_id = $vehicle_type_id = 0;
        // $vehicleTypeCodeValue = $this->ci->common->gettblrowdata($vehicleTypeInfo, "id", "tb_vehicle_type_master", 0, 0);
        // if (!empty($vehicleTypeCodeValue)) {
        //     $vehicle_type_id = $vehicleTypeCodeValue['id'];
        // }
        // if (!empty($vehicleTypeCode) && $vehicle_type_id == 0) {
        //     $vehicle_type_id = $this->ci->common->insertTableData('tb_vehicle_type_master', $vehicleTypeInfo);
        // }

        /*$partyWhere = [
        "register_number" => $RegistrationNumber,
        "organization_id" => $organizationId,
        "business_entity_value_id" => $businessEntityValue,
        'status' => 1,
        ];
        $checkVehicleDetails = $this->ci->common->gettblrowdata($partyWhere, "vehicle_id", "tb_vehicle_details", 0, 0);
        if (!empty($checkVehicleDetails)) {
        $vehicle_id = $checkVehicleDetails['vehicle_id'];
        } else {
        $vehicleDetails = [
        'truck_number' => $RegistrationNumber,
        'length' => $maxLength,
        'length_unit' => $LengthUOM,
        'breadth' => $maxWidth,
        'breadth_unit' => $WidthUOM,
        'vehicle_type' => $vehicle_type_id,
        'truck_brand' => $vehicle_type_id,
        'description' => $RegistrationNumber,
        'register_number' => $RegistrationNumber,
        "organization_id" => $organizationId,
        "business_entity_value_id" => $businessEntityValue,
        ];
        $vehicle_id = $this->ci->common->insertTableData('tb_vehicle_details', $vehicleDetails);
        }*/

    //     return $vehicle_type_id ?? 0;
    // }

    public function getCarrierDetails(
        array $CarrierDetails,
        int $organizationId,
        int $businessEntityValue,
        int $businessEntityID
    ): int {
        $carrierCode = is_array($CarrierDetails['ID']) ? "0" : $CarrierDetails['ID'];
        $carrierName = is_array($CarrierDetails['Company']['Name']) ? "0" : $CarrierDetails['Company']['Name'];
        $party_code = is_array(
            $CarrierDetails['Company']['RegistrationNumber']
        ) ? "0" : $CarrierDetails['Company']['RegistrationNumber'];
        $address1 = is_array($CarrierDetails['Address']['Address1']) ? "" : $CarrierDetails['Address']['Address1'];
        $address2 = is_array($CarrierDetails['Address']['Address2']) ? "" : $CarrierDetails['Address']['Address2'];
        $street = is_array($CarrierDetails['Address']['Street']) ? "" : $CarrierDetails['Address']['Street'];
        $city = is_array($CarrierDetails['Address']['City']) ? "" : $CarrierDetails['Address']['City'];
        $State = (is_array($CarrierDetails['Address']['State']) ? "" : $CarrierDetails['Address']['State']);
        $postal = (is_array($CarrierDetails['Address']['Postal']) ? "" : $CarrierDetails['Address']['Postal']);
        $country = (is_array($CarrierDetails['Address']['Country']) ? "" : $CarrierDetails['Address']['Country']);
        $email = (is_array(
            $CarrierDetails['Address']['ContactInfo']['EmailAddress']
        ) ? "" : $CarrierDetails['Address']['ContactInfo']['EmailAddress']);
        $phone = (is_array(
            $CarrierDetails['Address']['ContactInfo']['ContactNo']
        ) ? "" : $CarrierDetails['Address']['ContactInfo']['ContactNo']);
        $latitude = (is_array($CarrierDetails['Address']['Latitude']) ? "" : $CarrierDetails['Address']['Latitude']);
        $longitude = (is_array($CarrierDetails['Address']['Longitude']) ? "" : $CarrierDetails['Address']['Longitude']);
        $address = $address1 . "," . $address2 . "," . $street . "," . $city . "," . $State . "," . $postal . "," . $country;
        if ($latitude == "" && $longitude == "") {
            $data = getlatlngsbyaddress($address);
            $latitude = @$data[0];
            $longitude = @$data[1];
        }
        $partyWhere = [
            "carrier_name" => $carrierName,
            "code" => $carrierCode,
            "organization_id" => $organizationId,
            "business_entity_value_id" => $businessEntityValue,
            'status' => 1,
        ];
        $checkCarrier = $this->ci->common->gettblrowdata($partyWhere, "carrier_id", "tb_carrier_details", 0, 0);
        if (!empty($checkCarrier)) {
            $partyContactID = $checkCarrier['carrier_id'];
        } else {
            $partyWhere = [
                "carrier_name" => $carrierName,
                "organization_id" => $organizationId,
                "business_entity_value_id" => $businessEntityValue,
                'status' => 1,
            ];
            $checkCarrier = $this->ci->common->gettblrowdata($partyWhere, "carrier_id", "tb_carrier_details", 0, 0);
            if (!empty($checkCarrier)) {
                $partyContactID = $checkCarrier['carrier_id'];
            } else {
                $partycontactInfo = [
                    "carrier_name" => $carrierName,
                    "organization_id" => $organizationId,
                    "business_entity_value_id" => $businessEntityValue,
                    'status' => 1,
                    'address1' => $phone,
                    'address2' => $phone,
                    'mobile' => $phone,
                    'email' => $email,
                    'street' => $street,
                    'city' => $city,
                    'state' => $State,
                    'pincode' => $postal,
                    'country' => $country,
                    'latitude' => $latitude,
                    'longitude' => $longitude,
                ];
                $partyContactID = $this->ci->common->insertTableData('tb_carrier_details', $partycontactInfo);
                if ($carrierCode === 0) {
                    $carrierCode = $organizationId . $businessEntityValue . date('y') . date('W') . $partyContactID;
                    $this->ci->common->updatetbledata(
                        "tb_carrier_details",
                        ['code' => $carrierCode],
                        ['carrier_id' => $partyContactID]
                    );
                }
            }
        }
        return $partyContactID ?? 0;
    }

    /*public function getCarrierDetails(
    array $CarrierDetails,
    int $organizationId,
    int $businessEntityValue,
    int $businessEntityID
    ): int {
    $carrierCode = is_array($CarrierDetails['ID']) ? "0" : $CarrierDetails['ID'];
    $carrierName = is_array($CarrierDetails['Company']['Name']) ? "0" : $CarrierDetails['Company']['Name'];
    $party_code = is_array(
    $CarrierDetails['Company']['RegistrationNumber']
    ) ? "0" : $CarrierDetails['Company']['RegistrationNumber'];
    $address1 = is_array($CarrierDetails['Address']['Address1']) ? "" : $CarrierDetails['Address']['Address1'];
    $address2 = is_array($CarrierDetails['Address']['Address2']) ? "" : $CarrierDetails['Address']['Address2'];
    $street = is_array($CarrierDetails['Address']['Street']) ? "" : $CarrierDetails['Address']['Street'];
    $city = is_array($CarrierDetails['Address']['City']) ? "" : $CarrierDetails['Address']['City'];
    $State = (is_array($CarrierDetails['Address']['State']) ? "" : $CarrierDetails['Address']['State']);
    $postal = (is_array($CarrierDetails['Address']['Postal']) ? "" : $CarrierDetails['Address']['Postal']);
    $country = (is_array($CarrierDetails['Address']['Country']) ? "" : $CarrierDetails['Address']['Country']);
    $email = (is_array(
    $CarrierDetails['Address']['ContactInfo']['EmailAddress']
    ) ? "" : $CarrierDetails['Address']['ContactInfo']['EmailAddress']);
    $phone = (is_array(
    $CarrierDetails['Address']['ContactInfo']['ContactNo']
    ) ? "" : $CarrierDetails['Address']['ContactInfo']['ContactNo']);
    $latitude = (is_array($CarrierDetails['Address']['Latitude']) ? "" : $CarrierDetails['Address']['Latitude']);
    $longitude = (is_array($CarrierDetails['Address']['Longitude']) ? "" : $CarrierDetails['Address']['Longitude']);
    $address = $address1 . "," . $address2 . "," . $street . "," . $city . "," . $State . "," . $postal . "," . $country;
    if ($latitude == "" && $longitude == "") {
    $data = getlatlngsbyaddress($address);
    $latitude = @$data[0];
    $longitude = @$data[1];
    }
    $partyWhere = [
    "carrier_name" => $carrierName,
    "code" => $carrierCode,
    "organization_id" => $organizationId,
    "business_entity_value_id" => $businessEntityValue,
    'status' => 1,
    ];
    $checkCarrier = $this->ci->common->gettblrowdata($partyWhere, "carrier_id", "tb_carrier_details", 0, 0);
    if (!empty($checkCarrier)) {
    $partyContactID = $checkCarrier['carrier_id'];
    } else {
    $partyWhere = [
    "carrier_name" => $carrierName,
    "organization_id" => $organizationId,
    "business_entity_value_id" => $businessEntityValue,
    'status' => 1,
    ];
    $checkCarrier = $this->ci->common->gettblrowdata($partyWhere, "carrier_id", "tb_carrier_details", 0, 0);
    if (!empty($checkCarrier)) {
    $partyContactID = $checkCarrier['carrier_id'];
    } else {
    $partycontactInfo = [
    "carrier_name" => $carrierName,
    "organization_id" => $organizationId,
    "business_entity_value_id" => $businessEntityValue,
    'status' => 1,
    'address1' => $phone,
    'address2' => $phone,
    'mobile' => $phone,
    'email' => $email,
    'street' => $street,
    'city' => $city,
    'state' => $State,
    'pincode' => $postal,
    'country' => $country,
    'latitude' => $latitude,
    'longitude' => $longitude,
    ];
    $partyContactID = $this->ci->common->insertTableData('tb_carrier_details', $partycontactInfo);
    if ($carrierCode === 0) {
    $carrierCode = $organizationId . $businessEntityValue . date('y') . date('W') . $partyContactID;
    $this->ci->common->updatetbledata(
    "tb_carrier_details",
    ['code' => $carrierCode],
    ['carrier_id' => $partyContactID]
    );
    }
    }
    }
    return $partyContactID ?? 0;
    }*/

   public function orderdetails(
    array $order,
    ?string $organizationId,         // nullable string
    ?string $businessEntityValue,    // nullable string
    ?string $businessEntityID,
    ?string $organization,           // nullable string
    ?string $businessEntity,         // nullable string
    ?string $domain,  
    ?array $orderHeader,
    ?string $tripId = null,
    ?string $orderType,
    ?string $modeOfTransport,
    ?string $modeOfTransportId
): string {
    // Ensure variables are never null inside the function
    
    $organizationId = $organizationId ?? '';
    $businessEntityValue = $businessEntityValue ?? '';
    $organization = $organization ?? '';
    $businessEntity = $businessEntity ?? '';
    $domain = $domain ?? '';
        //$orderMovementId = (empty($order['OrderMovementId']) ? "" : $order['OrderMovementId']);
        $orderMovementId = $order['OrderMovementId'];
        //$orderType = (empty($order['OrderType']) ? "0" : $order['OrderType']);
        
        $product = (empty($order['Product']) ? "0" : $order['Product']);
        $serviceType = (empty($order['ServiceType']) ? "0" : $order['ServiceType']);
        $orderData = [
            'TripID' => $tripId ?? "0",
            'OrderID' => (empty($order['OrderID']) ? "0" : $order['OrderID']),
            'EXTOrderID' => (empty($order['EXTOrderID']) ? "0" : $order['EXTOrderID']),
            'OrderType' => $orderType,
            'ModeOfTransport' => $modeOfTransport,
            'modeOfTransportId' => $modeOfTransportId ?? 0,
            'Product' => $product,
            'ServiceType' => $serviceType,
            'organizationId' => $organizationId,
            'businessEntityValue' => $businessEntityValue,
            'businessEntityID' => $businessEntityID,
            'domain' => $domain,
            'company_code' => $organizationId,
            'branch_code' => $businessEntityValue,
            'TypeOfBusiness' => (empty($order['TypeOfBusiness']) ? "" : $order['TypeOfBusiness']),
            'Incoterm' => (empty($order['TermsOfTrade']['Incoterm']) ? "" : $order['TermsOfTrade']['Incoterm']),
            'FreightTerm' => (empty($order['TermsOfTrade']['FreightTerm']['Term']) ? "" : $order['TermsOfTrade']['FreightTerm']['Term']),
            'FreightTermName' => (empty($order['TermsOfTrade']['FreightTerm']['Name']) ? "" : $order['TermsOfTrade']['FreightTerm']['Name']),
            'customerDetails' => $order['CustomerDetails'],
            'sourceInfo' => $order['LocationInfo']['Source'],
            'destinationInfo' => $order['LocationInfo']['Destination'],
            'cargoSummary' => $order['OrderCargoSummary'],
            'cargoDetails' => $order['CargoDetails'],
            'valueAddedServices' => $order['ValueAddedServices'],
            'involvedParties' => $order['InvolvedParties'],
            'manageReferences' => $order['ManageReferences'] ?? [],
            'remarks' => $order['Remarks'] ?? [],
            'organization' => $organization,
            'businessEntity' => $businessEntity,
            'orderMovementId' => $orderMovementId,
            'header' => $orderHeader,
        ];
        
        return $this->ci->otmstandardbookinghandler->saveOrderDetails($orderData);
        /*log_message('error', 'TripID inside orderdetails: ' . ($tripId ?? 'NULL'));*/

    }
    
    public function formatNumber($num) {
        $rounded = round($num, 2);
        if (fmod($rounded, 1) == 0.0) {
            return (int) $rounded;   // no decimals if whole number
        }
        return number_format($rounded, 2, '.', ''); // force 2 decimals
    }
}
