<?php

class Otmordershipmenthandler
{
    private $ci;

    public function __construct()
    {
        $this->ci = &get_instance();

        $this->ci->load->model(['common', 'otmbookingmodel']);
        $this->ci->load->model(['common', 'otmshipmentmodel']);
        $this->ci->load->library('Otmbookinghandler');
    }

    public function pullTripOrderXml(array $data): string
    {
        $status = "";
        $filterData = $this->tripOrderData($data);
        if ($filterData['status'] == 1) {
            $status = "Trip Creation Failed, : " . $filterData['message'];
            echo "Order Creation Failed, : " . $filterData['message'];
            return $status;
        }
        $shipmentID = $this->saveTripDetails($filterData['data']);
        $status = "Trip Created Successfully: Trip - " . $shipmentID;
         echo "Trip Created Successfully: Trip - " . $shipmentID;
        return $status;
    }

    public function tripOrderData(array $data): array
    {
        $tripInfo = $data['ELGEDITripBody'];
        $elogHeader = $data['ELGEDITripHeader'];
        $tripHeader = $tripInfo['TripDetails']['TripHeader'];
        $tripOrderDetails = $tripInfo['TripDetails']['TripOrderDetails'];
        $status = "";
        $domain = (empty($tripInfo['ELGOrgDetails']['DomainName']) ? "" : $tripInfo['ELGOrgDetails']['DomainName']);

        $organization = (empty($tripInfo['ELGOrgDetails']['OrganizationId']) ? "0" : $tripInfo['ELGOrgDetails']['OrganizationId']);
        if ($organization == 0) {
            $status = ["status" => 1, "message" => 'Organization ID is Empty: ' . $tripInfo['ELGOrgDetails']['OrganizationId']];
            return $status;
        }
        $organizationId = $this->ci->common->checkOrganization($organization);
        if ($organizationId == 0) {
            return ["status" => 1, "message" => 'Organization details was Wrong: ' . $organization];
        }
        $businessEntity = (empty($tripInfo['ELGOrgDetails']['BusinessEntity']) ? "0" : $tripInfo['ELGOrgDetails']['BusinessEntity']);
        if ($businessEntity == 0) {
            return ["status" => 1, "message" => 'Business Entity Value is Empty'];
        }
        $businessEntityValue = $this->ci->common->checkBusinessEntity($businessEntity, $organization);
        if (empty($businessEntityValue)) {
            return ["status" => 1, "message" => 'Business Entity Value was Wrong: ' . $businessEntity];
        }
        /*if (empty($tripHeader['CarrierDetails'])) {
        $carrierName = (empty($tripHeader['CarrierDetails']['ID']) ? "ALL" : $tripHeader['CarrierDetails']['ID']);
        $carrier = $this->ci->common->checkPartyTypeCrossRef($organizationId, $businessEntityValue['id'], $domain, 'CARRIER', $carrierName);
        if ($carrier == "") {
        return ["status" => 1, "message" => 'Carrier Details are Empty:' . $tripHeader['CarrierDetails']['ID']];
        }
        }*/

        $subCarrierId = "";

        if (empty($tripHeader['CarrierDetails'])) {
            return ["status" => 1, "message" => 'Carrier Details are Empty:'];
        } else {
            $carrierName = (empty($tripHeader['CarrierDetails']['ID']) ? "ALL" : $tripHeader['CarrierDetails']['ID']);
            $xrefCarrier = $this->ci->common->checkPartyTypeCrossRef($organizationId, $businessEntityValue['id'], $domain, 'CARRIER', $carrierName);
            if ($xrefCarrier == "") {
                return ["status" => 1, "message" => 'XREF Carrier Details are Empty:' . $tripHeader['CarrierDetails']['ID']];
            } else {
                $parentCarrier = $this->ci->common->checkCustomer($xrefCarrier);
                if (empty($parentCarrier)) {
                    return ["status" => 1, "message" => 'XREF Carrier Details Not Matching:' . $tripHeader['CarrierDetails']['ID']];
                } else {
                    if ($tripHeader['CarrierDetails']['ID'] != "ALL") {
                        $subCarrier = $this->ci->common->checkCustomer($tripHeader['CarrierDetails']['ID']);
                        if (empty($subCarrier)) {
                            $userData = [
                                'cusomer_code' => $tripHeader['CarrierDetails']['ID'],
                                'user_id' => $tripHeader['CarrierDetails']['ID'],
                                'parent_id' => $parentCarrier['id'],
                                'privilege' => $parentCarrier['privilege'],
                                'party_type' => $parentCarrier['party_type'],
                                'organization_id' => $organizationId,
                                'structure_id' => $businessEntityValue['id'],
                                'entity_id' => $businessEntityValue['entity_id'],
                                'entity_value_id' => $businessEntityValue['structure_id'],
                                'status' => 1,
                            ];
                            $subCarrierId = $this->ci->otmbookingmodel->insertUser($userData);
                        } else {
                            $subCarrierId = $subCarrier['id'];
                        }
                    } else {
                        $subCarrierId = $parentCarrier['id'];
                    }
                }
            }
        }

        if (!empty($tripHeader['CargoSummary']['TotalWeight']['UOM'])) {
            $toWeightUOM = $this->ci->otmshipmentmodel->checkUOM($tripHeader['CargoSummary']['TotalWeight']['UOM'], 'WT', $organizationId, $businessEntityValue['id']);
            if (empty($toWeightUOM)) {
                return ["status" => 1, "message" => 'Weight UOM not exist for organization: ' . $tripHeader['CargoSummary']['TotalWeight']['UOM']];
            }
        }

        if (!empty($tripHeader['CargoSummary']['TotalVolume']['UOM'])) {
            $toVolumeUOM = $this->ci->otmshipmentmodel->checkUOM($tripHeader['CargoSummary']['TotalVolume']['UOM'], 'VO', $organizationId, $businessEntityValue['id']);
            if (empty($toVolumeUOM)) {
                return ["status" => 1, "message" => 'Volume UOM not exist for organization: ' . $tripHeader['CargoSummary']['TotalVolume']['UOM']];
            }
        }

        if (!empty($tripHeader['BusinessParties'])) {
            if (array_key_exists("0", $tripHeader['BusinessParties']['BusinessParty']) == 1) {
                foreach ($tripHeader['BusinessParties']['BusinessParty'] as $party) {
                    $toParty = $this->ci->otmshipmentmodel->checkPartyRole($party['PartyType'], $organizationId, $businessEntityValue['id']);
                    if (empty($toParty)) {
                        return ["status" => 1, "message" => 'Party Type not exist for organization: ' . $party['PartyType']];
                    }
                }
            } else {
                $toParty = $this->ci->otmshipmentmodel->checkPartyRole($tripHeader['BusinessParties']['BusinessParty']['PartyType'], $organizationId, $businessEntityValue['id']);
                if (empty($toParty)) {
                    return ["status" => 1, "message" => 'Party Type not exist for organization: ' . $tripHeader['BusinessParties']['BusinessParty']['PartyType']];
                }
            }
        }

        if (!empty($tripHeader['ManageReferences'])) {
            if (array_key_exists("0", $tripHeader['ManageReferences']['Reference']) == 1) {
                foreach ($tripHeader['ManageReferences']['Reference'] as $orderRef) {
                    $toRefCode = $this->ci->otmshipmentmodel->checkCrossReferences($orderRef['RefType']['Code'], $organizationId, $businessEntityValue['id']);
                    if (empty($toRefCode)) {
                        return ["status" => 1, "message" => 'Reference not exist for organization: ' . $orderRef['RefType']['Code']];
                    }
                }
            } else {
                $toRefCode = $this->ci->otmshipmentmodel->checkCrossReferences($tripHeader['ManageReferences']['Reference']['RefType']['Code'], $organizationId, $businessEntityValue['id']);
                if (empty($toRefCode)) {
                    return ["status" => 1, "message" => 'Reference not exist for organization: ' . $tripHeader['ManageReferences']['Reference']['RefType']['Code']];
                }
            }
        }

        if (!empty($tripHeader['Remarks'])) {
            if (array_key_exists("0", $tripHeader['Remarks']['RemarkType']) == 1) {
                foreach ($tripHeader['Remarks']['RemarkType'] as $orderRem) {
                    $toRemarkCode = $this->ci->otmshipmentmodel->checkCrossRemarks($orderRem['Code'], $organizationId, $businessEntityValue['id']);
                    if (empty($toRemarkCode)) {
                        return ["status" => 1, "message" => 'Remark not exist for organization: ' . $orderRem['Code']];
                    }
                }
            } else {
                $toRemarkCode = $this->ci->otmshipmentmodel->checkCrossRemarks($tripHeader['Remarks']['RemarkType']['Code'], $organizationId, $businessEntityValue['id']);
                if (empty($toRemarkCode)) {
                    return ["status" => 1, "message" => 'Remark not exist for organization: ' . $tripHeader['Remarks']['RemarkType']['Code']];
                }
            }
        }

        /*if (empty($tripOrderDetails['ELGCUSTOMER'])) {
        $customerName = (empty($tripOrderDetails['ELGCUSTOMER']['ID']) ? "ALL" : $tripOrderDetails['ELGCUSTOMER']['ID']);
        $customer = $this->ci->common->checkPartyTypeCrossRef($organizationId, $businessEntityValue['id'], $domain, 'CUSTOMER', $customerName);
        //$customer = $this->ci->common->checkPartyTypeCrossRef($organization, $businessEntity, 'CUSTOMER', $customerName);
        if ($customer == "") {
        return ["status" => 1, "message" => 'Customer Details are Empty:' . $tripOrderDetails['ELGCUSTOMER']['ID']];
        }
        }*/

        if (empty($tripOrderDetails['ELGCUSTOMER'])) {
            $status = ["status" => 1, "message" => 'Customer Details are Empty:'];
            return $status;
        } else {
            $customerName = (empty($tripOrderDetails['ELGCUSTOMER']['ID']) ? "ALL" : $tripOrderDetails['ELGCUSTOMER']['ID']);
            $xrefCustomer = $this->ci->common->checkPartyTypeCrossRef($organizationId, $businessEntityValue['id'], $domain, 'CUSTOMER', $customerName);
            if ($xrefCustomer == "") {
                $status = ["status" => 1, "message" => 'XREF Customer Details are Empty:' . $tripOrderDetails['ELGCUSTOMER']['ID']];
                return $status;
            } else {
                $parentCustomer = $this->ci->common->checkCustomer($xrefCustomer);
                if (empty($parentCustomer)) {
                    $status = ["status" => 1, "message" => 'XREF Customer Details Not Matching:' . $tripOrderDetails['ELGCUSTOMER']['ID']];
                    return $status;
                } else {
                    if ($tripOrderDetails['ELGCUSTOMER']['ID'] != "ALL") {
                        $subCustomer = $this->ci->common->checkCustomer($tripOrderDetails['ELGCUSTOMER']['ID']);
                        if (empty($subCustomer)) {
                            $userData = [
                                'cusomer_code' => $tripOrderDetails['ELGCUSTOMER']['ID'],
                                'user_id' => $tripOrderDetails['ELGCUSTOMER']['ID'],
                                'parent_id' => $parentCustomer['id'],
                                'privilege' => $parentCustomer['privilege'],
                                'party_type' => $parentCustomer['party_type'],
                                'organization_id' => $organizationId,
                                'structure_id' => $businessEntityValue['id'],
                                'entity_id' => $businessEntityValue['entity_id'],
                                'entity_value_id' => $businessEntityValue['structure_id'],
                                'status' => 1,
                            ];
                            $subCustomerId = $this->ci->otmbookingmodel->insertUser($userData);
                        } else {
                            $subCustomerId = $subCustomer['id'];
                        }
                    } else {
                        $subCustomerId = $parentCustomer['id'];
                    }
                }
            }
        }

        if (!empty($tripOrderDetails['CargoSummary']['TotalWeight']['UOM'])) {
            $toWeightUOM = $this->ci->otmshipmentmodel->checkUOM($tripOrderDetails['CargoSummary']['TotalWeight']['UOM'], 'WT', $organizationId, $businessEntityValue['id']);
            if (empty($toWeightUOM)) {
                return ["status" => 1, "message" => 'Weight UOM not exist for organization: ' . $tripOrderDetails['CargoSummary']['TotalWeight']['UOM']];
            }
        }

        if (!empty($tripOrderDetails['CargoSummary']['TotalVolume']['UOM'])) {
            $toVolumeUOM = $this->ci->otmshipmentmodel->checkUOM($tripOrderDetails['CargoSummary']['TotalVolume']['UOM'], 'VO', $organizationId, $businessEntityValue['id']);
            if (empty($toVolumeUOM)) {
                return ["status" => 1, "message" => 'Volume UOM not exist for organization: ' . $tripOrderDetails['CargoSummary']['TotalVolume']['UOM']];
            }
        }

        if (!empty($orderInfo['CargoDetails'])) {
            if (array_key_exists("0", $orderInfo['CargoDetails']['CargoThuDetails']) == 1) {
                foreach ($orderInfo['CargoDetails']['CargoThuDetails'] as $orderCargo) {
                    $toPackage = $this->ci->otmshipmentmodel->checkPackageType($orderCargo['PackageType'], $organizationId, $businessEntityValue['id']);
                    if (empty($toPackage)) {
                        $status = ["status" => 1, "message" => 'Order Outer Package Type not exist for organization: ' . $orderCargo['PackageType']];
                        return $status;
                    }
                    if (!empty($orderCargo['CargoPuDetails'])) {
                        if (array_key_exists("0", $orderCargo['CargoPuDetails']) == 1) {
                            foreach ($orderCargo['CargoPuDetails'] as $orderInnerCargo) {
                                $toPackage = $this->ci->otmshipmentmodel->checkPackageType($orderInnerCargo['PackageType'], $organizationId, $businessEntityValue['id']);
                                if (empty($toPackage)) {
                                    $status = ["status" => 1, "message" => 'Order Inner Package Type not exist for organization: ' . $orderInnerCargo['PackageType']];
                                    return $status;
                                }
                            }
                        } else {
                            $toPackage = $this->ci->otmshipmentmodel->checkPackageType($orderCargo['CargoPuDetails']['PackageType'], $organizationId, $businessEntityValue['id']);
                            if (empty($toPackage)) {
                                $status = ["status" => 1, "message" => 'Order Inner Package Type not exist for organization: ' . $orderCargo['CargoPuDetails']['PackageType']];
                                return $status;
                            }
                        }
                    }
                }
            } else {
                $toPackage = $this->ci->otmshipmentmodel->checkPackageType($orderInfo['CargoDetails']['CargoThuDetails']['PackageType'], $organizationId, $businessEntityValue['id']);
                if (empty($toPackage)) {
                    $status = ["status" => 1, "message" => 'Order Outer Package Type not exist for organization: ' . $orderInfo['CargoDetails']['CargoThuDetails']['PackageType']];
                    return $status;
                }
                if (!empty($orderCargo['CargoPuDetails'])) {
                    if (array_key_exists("0", $orderCargo['CargoPuDetails']) == 1) {
                        foreach ($orderInfo['CargoDetails']['CargoThuDetails']['CargoPuDetails'] as $orderInnerCargo) {
                            $toPackage = $this->ci->otmshipmentmodel->checkPackageType($orderInnerCargo['PackageType'], $organizationId, $businessEntityValue['id']);
                            if (empty($toPackage)) {
                                $status = ["status" => 1, "message" => 'Order Inner Package Type not exist for organization: ' . $orderInnerCargo['PackageType']];
                                return $status;
                            }
                        }
                    } else {
                        $toPackage = $this->ci->otmshipmentmodel->checkPackageType($orderInfo['CargoDetails']['CargoThuDetails']['CargoPuDetails']['PackageType'], $organizationId, $businessEntityValue['id']);
                        if (empty($toPackage)) {
                            $status = ["status" => 1, "message" => 'Order Inner Package Type not exist for organization: ' . $orderInfo['CargoDetails']['CargoThuDetails']['CargoPuDetails']['PackageType']];
                            return $status;
                        }
                    }
                }
            }
        }

        if (!empty($tripOrderDetails['InvolvedParties'])) {
            if (array_key_exists("0", $tripOrderDetails['InvolvedParties']['InvolvedParty']) == 1) {
                foreach ($tripOrderDetails['InvolvedParties']['InvolvedParty'] as $party) {
                    $toParty = $this->ci->otmshipmentmodel->checkPartyRole($party['PartyType'], $organizationId, $businessEntityValue['id']);
                    if (empty($toParty)) {
                        return ["status" => 1, "message" => 'Party Type not exist for organization: ' . $party['PartyType']];
                    }
                }
            } else {
                $toParty = $this->ci->otmshipmentmodel->checkPartyRole($tripOrderDetails['InvolvedParties']['InvolvedParty']['PartyType'], $organizationId, $businessEntityValue['id']);
                if (empty($toParty)) {
                    return ["status" => 1, "message" => 'Party Type not exist for organization: ' . $tripOrderDetails['InvolvedParties']['InvolvedParty']['PartyType']];
                }
            }
        }

        if (!empty($tripOrderDetails['ManageReferences'])) {
            if (array_key_exists("0", $tripOrderDetails['ManageReferences']['Reference']) == 1) {
                foreach ($tripOrderDetails['ManageReferences']['Reference'] as $orderRef) {
                    $toRefCode = $this->ci->otmshipmentmodel->checkCrossReferences($orderRef['RefType']['Code'], $organizationId, $businessEntityValue['id']);
                    if (empty($toRefCode)) {
                        return ["status" => 1, "message" => 'Reference not exist for organization: ' . $orderRef['RefType']['Code']];
                    }
                }
            } else {
                $toRefCode = $this->ci->otmshipmentmodel->checkCrossReferences($tripOrderDetails['ManageReferences']['Reference']['RefType']['Code'], $organizationId, $businessEntityValue['id']);
                if (empty($toRefCode)) {
                    return ["status" => 1, "message" => 'Reference not exist for organization: ' . $tripOrderDetails['ManageReferences']['Reference']['RefType']['Code']];
                }
            }
        }

        if (!empty($tripOrderDetails['Remarks'])) {
            if (array_key_exists("0", $tripOrderDetails['Remarks']['RemarkType']) == 1) {
                foreach ($tripOrderDetails['Remarks']['RemarkType'] as $orderRem) {
                    $toRemarkCode = $this->ci->otmshipmentmodel->checkCrossRemarks($orderRem['Code'], $organizationId, $businessEntityValue['id']);
                    if (empty($toRemarkCode)) {
                        return ["status" => 1, "message" => 'Remark not exist for organization: ' . $orderRem['Code']];
                    }
                }
            } else {
                $toRemarkCode = $this->ci->otmshipmentmodel->checkCrossRemarks($tripOrderDetails['Remarks']['RemarkType']['Code'], $organizationId, $businessEntityValue['id']);
                if (empty($toRemarkCode)) {
                    return ["status" => 1, "message" => 'Remark not exist for organization: ' . $tripOrderDetails['Remarks']['RemarkType']['Code']];
                }
            }
        }
        $tripId = (empty($tripHeader['TripID']) ? "0" : $tripHeader['TripID']);
        if ($tripId == 0) {
            return ["status" => 1, "message" => 'Trip ID is Empty'];
        }

        $tripData = [
            'TripHeader' => $tripHeader,
            'TripOrderDetails' => $tripOrderDetails,
            'organizationId' => $organizationId,
            'businessEntityValue' => $businessEntityValue['id'],
            'businessEntityID' => $businessEntityValue['entity_id'],
            'domain' => $domain,
            'elogheader' => $elogHeader,
            'organization' => $organization,
            'businessEntity' => $businessEntity,
            'parentCustomer' => $parentCustomer,
            'subCustomerId' => $subCustomerId,
            'parentCarrier' => $parentCarrier,
            'subCarrierId' => $subCarrierId,
        ];
        return ["status" => 0, "data" => $tripData];
    }

    public function saveTripDetails(array $orderData): string
    {
        $cdate = date('Y-m-d H:i:s');
        if (array_key_exists("0", $orderData['TripOrderDetails']) == 1) {
            foreach ($orderData['TripOrderDetails'] as $orderDetail) {
                $bookingIDs[] = $this->orderdetails(
                    $orderDetail,
                    $orderData['organizationId'],
                    $orderData['businessEntityValue'],
                    $orderData['businessEntityID'],
                    $orderData['organization'],
                    $orderData['businessEntity'],
                    $orderData['elogheader']['SourceApp'],
                    $orderData['domain'],
                    $orderData['parentCustomer'],
                    $orderData['subCustomerId'],
                    $orderData['parentCarrier'],
                    $orderData['subCarrierId']
                );
            }
        } else {
            $bookingIDs[] = $this->orderdetails(
                $orderData['TripOrderDetails'],
                $orderData['organizationId'],
                $orderData['businessEntityValue'],
                $orderData['businessEntityID'],
                $orderData['organization'],
                $orderData['businessEntity'],
                $orderData['elogheader']['SourceApp'],
                $orderData['domain'],
                $orderData['parentCustomer'],
                $orderData['subCustomerId'],
                $orderData['parentCarrier'],
                $orderData['subCarrierId']
            );
        }

        $carrier_id = 0;
        if (!empty($orderData['TripHeader']['CarrierDetails'])) {
            $carrier_id = $this->ci->otmbookinghandler->checkPartyDetails($orderData, $orderData['TripHeader']['CarrierDetails'], 'CARRIER', $orderData['organizationId'],
                $orderData['businessEntityValue']);
        }
        if (!empty($orderData['TripHeader']['VehicleDetails'])) {
            $vehicle_id = $this->getVehicleDetails(
                $orderData['TripHeader']['VehicleDetails'],
                $orderData['organizationId'],
                $orderData['businessEntityValue'],
                $orderData['businessEntityID'],
                $carrier_id
            );
        }
        /*    if (!empty($orderData['TripHeader']['DriverDetails'])) {
        $driver_id = $this->getDriverDetails(
        $orderData['TripHeader']['DriverDetails'],
        $orderData['organizationId'],
        $orderData['businessEntityValue'],
        $orderData['businessEntityID'],
        $carrier_id,
        $vehicle_id
        );
        }*/
        if (!empty($orderData['TripHeader']['TripLocation']['TripStartLocation'])) {
            $startlocationID = $this->ci->otmbookinghandler->checkPartyContactsDetails(
                $orderData['TripHeader']['TripLocation']['TripStartLocation'],
                $orderData['organizationId'],
                $orderData['businessEntityValue'],
                $orderData['domain'],
                $carrier_id,
                'PICKUP',
                $orderData['organization'],
                $orderData['businessEntity']
            );
            $startlocationID = $startlocationID['partyContactID'];
        }
        if (!empty($orderData['TripHeader']['TripLocation']['TripEndLocation'])) {
            $endlocationID = $this->ci->otmbookinghandler->checkPartyContactsDetails(
                $orderData['TripHeader']['TripLocation']['TripEndLocation'],
                $orderData['organizationId'],
                $orderData['businessEntityValue'],
                $orderData['domain'],
                $carrier_id,
                'DELIVERY',
                $orderData['organization'],
                $orderData['businessEntity']
            );
            $endlocationID = $endlocationID['partyContactID'];
        }

        /*if (!empty($orderData['TripHeader']['TripLocation']['TripStartLocation'])) {
        $startlocationID = $this->getLocationDetails(
        $orderData['TripHeader']['TripLocation']['TripStartLocation']['Address'],
        $orderData['organizationId'],
        $orderData['businessEntityValue'],
        $orderData['businessEntityID'],
        ''
        );
        }
        if (!empty($orderData['TripHeader']['TripLocation']['TripEndLocation'])) {
        $endlocationID = $this->getLocationDetails(
        $orderData['TripHeader']['TripLocation']['TripEndLocation']['Address'],
        $orderData['organizationId'],
        $orderData['businessEntityValue'],
        $orderData['businessEntityID']
        );
        }*/

        $tripId = is_array($orderData['TripHeader']['TripID']) ? "0" : $orderData['TripHeader']['TripID'];
        $checkTrip = $this->ci->common->gettblrowdata(
            ["external_trip_id" => $tripId, 'status' => 1],
            "trip_id",
            "tb_trips",
            0,
            0
        );

        $tripType = $orderData['TripHeader']['TripType'] ?? "";
        if (!empty($tripType)) {
            $destinationTripType = $this->ci->otmshipmentmodel->checkOrderTypeCrossRef($orderData['TripHeader']['TripType'], $orderData['organizationId'],
                $orderData['businessEntityValue']);
            if (!empty($destinationTripType)) {
                $tripType = $this->ci->otmbookingmodel->checkOrderType(
                    $destinationTripType,
                    $orderData['organizationId'],
                    $orderData['businessEntityID'],
                    $orderData['businessEntityValue']
                );
            }
        }
        $modeOfTransport = $orderData['TripHeader']['ModeOfTransport'] ?? "";
        if (!empty($modeOfTransport)) {
            $destinationModeOfTransport = $this->ci->otmshipmentmodel->checkModeOfTransportCrossRef($orderData['TripHeader']['ModeOfTransport'], $orderData['organizationId'],
                $orderData['businessEntityValue']);
            if (!empty($destinationModeOfTransport)) {
                $modeOfTransport = $this->ci->otmbookingmodel->checkModeOfTransport(
                    $destinationModeOfTransport,
                    $orderData['organizationId'],
                    $orderData['businessEntityID'],
                    $orderData['businessEntityValue']
                );
            }
        }

        /*$tripType = (empty($orderData['TripHeader']['TripType']) ? "0" : $orderData['TripHeader']['TripType']);
        if ($tripType > 0) {
        $tripType = $this->ci->otmbookingmodel->checkOrderType(
        $orderData['TripHeader']['TripType'],
        $orderData['organizationId'],
        $orderData['businessEntityID'],
        $orderData['businessEntityValue']
        );
        }

        $modeOfTransport = $orderData['TripHeader']['ModeOfTransport'];
        if (!empty($modeOfTransport)) {
        $modeOfTransport = $this->ci->otmbookingmodel->checkModeOfTransport(
        $modeOfTransport,
        $orderData['organizationId'],
        $orderData['businessEntityID'],
        $orderData['businessEntityValue']
        );
        }*/
        $pickup_start_date = str_replace(
            "T",
            " ",
            is_array(
                $orderData['TripHeader']['TripDates']['StartDate']['DateTime']
            ) ? "" : $orderData['TripHeader']['TripDates']['StartDate']['DateTime']
        );
        $delivery_start_date = str_replace(
            "T",
            " ",
            is_array(
                $orderData['TripHeader']['TripDates']['EndDate']['DateTime']
            ) ? "" : $orderData['TripHeader']['TripDates']['EndDate']['DateTime']
        );

        $totalWeightUomCode = $totalVolumeUomCode = "";

        if (!empty($orderData['TripHeader']['CargoSummary']['TotalWeight']['UOM'])) {
            $toWeightUOM = $this->ci->otmshipmentmodel->checkUOM($orderData['TripHeader']['CargoSummary']['TotalWeight']['UOM'], 'WT', $orderData['organizationId'], $orderData['businessEntityValue']);
            /*if (!empty($toWeightUOM)) {
            $totalWeightUomCode = $this->ci->otmshipmentmodel->getUOMId($toWeightUOM);
            }*/
            $totalWeightUomCode = $toWeightUOM;
        }
        if (!empty($orderData['TripHeader']['CargoSummary']['TotalVolume']['UOM'])) {
            $toVolumeUOM = $this->ci->otmshipmentmodel->checkUOM($orderData['TripHeader']['CargoSummary']['TotalVolume']['UOM'], 'VO', $orderData['organizationId'], $orderData['businessEntityValue']);
            /*if (!empty($toVolumeUOM)) {
            $totalVolumeUomCode = $this->ci->otmshipmentmodel->getUOMId($toVolumeUOM);
            }*/
            $totalVolumeUomCode = $toVolumeUOM;
        }
        $tripType = empty($tripType) ? 0 : $tripType;
        $modeOfTransport = empty($modeOfTransport) ? 0 : $modeOfTransport;
        $tripDetails = [
            'shipment_gid' => 0,
            'shipment_name' => 0,
            'transport_mode' => $modeOfTransport,
            'shipment_type_gid' => $tripType,
            'source_location_gid' => $startlocationID,
            'dest_location_gid' => $endlocationID,
            'start_time' => $pickup_start_date,
            'end_time' => $delivery_start_date,
            'carrier_id' => $carrier_id,
            'organization_id' => $orderData['organizationId'],
            'bisiness_entity_id' => $orderData['businessEntityValue'],
            'total_weight' => is_array(
                $orderData['TripHeader']['CargoSummary']['TotalWeight']['Value']
            ) ? "" : $orderData['TripHeader']['CargoSummary']['TotalWeight']['Value'],
            'total_weight_uom_code' => $totalWeightUomCode,
            'total_volume' => is_array(
                $orderData['TripHeader']['CargoSummary']['TotalVolume']['Value']
            ) ? "" : $orderData['TripHeader']['CargoSummary']['TotalVolume']['Value'],
            'total_volume_uom_code' => $totalVolumeUomCode,
            'external_trip_id' => $tripId,
            'vehicletype_id' => $vehicle_id,
            'modifiedon' => date('Y-m-d H:i:s'),
        ];
        if (!empty($checkTrip)) {
            $tripInternalID = $checkTrip['trip_id'];
            $this->ci->common->updatetbledata("tb_trips", $tripDetails, ['trip_id' => $tripInternalID]);
            $shipment_gid = "ELG" . $orderData['organizationId'] . $orderData['businessEntityValue'] . date('y') . date(
                'm') . date('W') . date('d') . date('s') . $tripInternalID;
            $this->ci->common->updatetbledata("tb_trips", ['shipment_gid' => $shipment_gid], ['trip_id' => $tripInternalID]);
        } else {
            $tripInternalID = $this->ci->common->insertTableData('tb_trips', $tripDetails);
            $shipment_gid = "ELG" . $orderData['organizationId'] . $orderData['businessEntityValue'] . date('y') . date(
                'm') . date('W') . date('d') . date('s') . $tripInternalID;
            $this->ci->common->updatetbledata("tb_trips", ['shipment_gid' => $shipment_gid], ['trip_id' => $tripInternalID]);
        }

        if (!empty($orderData['TripHeader']['BusinessParties'])) {
            if (array_key_exists("0", $orderData['TripHeader']['BusinessParties']['BusinessParty']) == 1) {
                foreach ($orderData['TripHeader']['BusinessParties']['BusinessParty'] as $party) {
                    $toParty = $this->ci->otmshipmentmodel->checkPartyRole($party['PartyType'], $orderData['organizationId'],
                        $orderData['businessEntityValue']);
                    $partyInfo = $this->ci->otmbookinghandler->checkPartyContactsDetails(
                        $party,
                        $orderData['organizationId'],
                        $orderData['businessEntityValue'],
                        $orderData['domain'],
                        $carrier_id,
                        strtoupper($toParty),
                        $orderData['organization'],
                        $orderData['businessEntity']
                    );
                    $tripParty = [
                        'trip_id' => $tripInternalID,
                        'involved_party_contact_gid' => $partyInfo['partyContactID'],
                        'involved_party_qual_gid' => $partyInfo['party_type_id'],
                        'organization_id' => $orderData['organizationId'],
                        'bisiness_entity_id' => $orderData['businessEntityValue'],
                    ];
                    $updateTripParty = [
                        'trip_id' => $tripInternalID,
                        'involved_party_qual_gid' => $partyInfo['party_type_id'],
                        'organization_id' => $orderData['organizationId'],
                        'bisiness_entity_id' => $orderData['businessEntityValue'],
                    ];
                    $tripInvolvedPartiesInfo = $this->ci->common->gettblrowdata($tripParty, "trip_involved_party_id", "tb_trips_involved_parties", 0, 0);
                    if (empty($tripInvolvedPartiesInfo)) {
                        $this->ci->common->insertTableData('tb_trips_involved_parties', $tripParty);
                    } else {
                        $this->ci->db->where($updateTripParty)->update("tb_trips_involved_parties", $tripParty);
                    }
                }
            } else {
                $toParty = $this->ci->otmshipmentmodel->checkPartyRole($orderData['TripHeader']['BusinessParties']['BusinessParty']['PartyType'], $orderData['organizationId'],
                    $orderData['businessEntityValue']);
                $partyInfo = $this->ci->otmbookinghandler->checkPartyContactsDetails(
                    $orderData['TripHeader']['BusinessParties']['BusinessParty'],
                    $orderData['organizationId'],
                    $orderData['businessEntityValue'],
                    $orderData['domain'],
                    $carrier_id,
                    strtoupper($toParty),
                    $orderData['organization'],
                    $orderData['businessEntity']
                );
                $tripParty = [
                    'trip_id' => $tripInternalID,
                    'involved_party_contact_gid' => $partyInfo['partyContactID'],
                    'involved_party_qual_gid' => $partyInfo['party_type_id'],
                    'organization_id' => $orderData['organizationId'],
                    'bisiness_entity_id' => $orderData['businessEntityValue'],
                ];
                $updateTripParty = [
                    'trip_id' => $tripInternalID,
                    'involved_party_qual_gid' => $partyInfo['party_type_id'],
                    'organization_id' => $orderData['organizationId'],
                    'bisiness_entity_id' => $orderData['businessEntityValue'],
                ];
                $tripInvolvedPartiesInfo = $this->ci->common->gettblrowdata($tripParty, "trip_involved_party_id", "tb_trips_involved_parties", 0, 0);
                if (empty($tripInvolvedPartiesInfo)) {
                    $this->ci->common->insertTableData('tb_trips_involved_parties', $tripParty);
                } else {
                    $this->ci->db->where($updateTripParty)->update("tb_trips_involved_parties", $tripParty);
                }
            }
        }

        if (!empty($orderData['TripHeader']['ManageReferences'])) {
            if (array_key_exists("0", $orderData['TripHeader']['ManageReferences']['Reference']) == 1) {
                foreach ($orderData['TripHeader']['ManageReferences']['Reference'] as $orderRef) {
                    $toRefCode = $this->ci->otmshipmentmodel->checkCrossReferences($orderRef['RefType']['Code'], $orderData['organizationId'], $orderData['businessEntityValue']);
                    if (!empty($toRefCode)) {
                        $referenceId = $this->ci->otmshipmentmodel->getReferenceId($toRefCode);
                        $orderRef['RefType']['Code'] = $referenceId;
                        $this->ci->otmshipmentmodel->insertTripReferences($tripInternalID, $orderRef, $orderData['organizationId'], $orderData['businessEntityValue']);
                    }
                }
            } else {
                $toRefCode = $this->ci->otmshipmentmodel->checkCrossReferences($orderData['TripHeader']['ManageReferences']['Reference']['RefType']['Code'], $orderData['organizationId'], $orderData['businessEntityValue']);
                if (!empty($toRefCode)) {
                    $referenceId = $this->ci->otmshipmentmodel->getReferenceId($toRefCode);
                    $orderData['manageReferences']['Reference']['RefType']['Code'] = $referenceId;
                    $this->ci->otmshipmentmodel->insertTripReferences($tripInternalID, $orderData['TripHeader']['ManageReferences']['Reference'], $orderData['organizationId'], $orderData['businessEntityValue']);
                }
            }
        }

        if (!empty($orderData['TripHeader']['Remarks'])) {
            if (array_key_exists("0", $orderData['TripHeader']['Remarks']['RemarkType']) == 1) {
                foreach ($orderData['TripHeader']['Remarks']['RemarkType'] as $orderRem) {
                    $toRemarkCode = $this->ci->otmshipmentmodel->checkCrossRemarks($orderRem['Code'], $orderData['organizationId'],
                        $orderData['businessEntityValue']);
                    if (!empty($toRemarkCode)) {
                        $remarkId = $this->ci->otmshipmentmodel->getRemarkId($toRemarkCode);
                        $orderRem['RemarkType']['Code'] = $remarkId;
                        $this->ci->otmshipmentmodel->insertTripRemarks($tripInternalID, $orderRem, $orderData['organizationId'], $orderData['businessEntityValue']);
                    }
                }
            } else {
                $toRemarkCode = $this->ci->otmshipmentmodel->checkCrossRemarks($orderData['TripHeader']['Remarks']['RemarkType']['Code'], $orderData['organizationId'],
                    $orderData['businessEntityValue']);
                if (!empty($toRemarkCode)) {
                    $remarkId = $this->ci->otmshipmentmodel->getRemarkId($toRemarkCode);
                    $orderData['TripHeader']['Remarks']['RemarkType']['Code'] = $remarkId;
                    $this->ci->otmshipmentmodel->insertTripRemarks($tripInternalID, $orderData['TripHeader']['Remarks'], $orderData['organizationId'], $orderData['businessEntityValue']);
                }
            }
        }

        //$endlocationID = empty($endlocationID) ? 0 : $endlocationID;
        if (!empty($orderData['TripHeader']['TripStops'])) {
            foreach ($orderData['TripHeader']['TripStops']['TripStop'] as $tripStop) {
                $this->insertTripStopsDetails(
                    $tripStop,
                    $orderData['organizationId'],
                    $orderData['businessEntityValue'],
                    $orderData['businessEntityID'],
                    $orderData['domain'],
                    $tripInternalID,
                    $startlocationID,
                    $endlocationID,
                    'NEW',
                    $orderData['organization'],
                    $orderData['businessEntity'],
                    $carrier_id
                );
            }
        }

        if (!empty($bookingIDs)) {
            foreach ($bookingIDs as $orders) {
                $orderinfo = $this->ci->common->gettblrowdata(['order_id' => $orders], "id, ship_unit_id", "tb_orders", 0, 0);
                if (!empty($orderinfo)) {
                    $tripOrders = [
                        'trip_id' => $tripInternalID,
                        'order_id' => $orderinfo['id'],
                        'organization_id' => $orderData['organizationId'],
                        'bisiness_entity_id' => $orderData['businessEntityValue'],
                    ];
                    $orderinfo1 = $this->ci->common->gettblrowdata($tripOrders, "trip_order_id", "tb_trip_orders", 0, 0);
                    if (empty($orderinfo1)) {
                        $this->ci->common->insertTableData('tb_trip_orders', $tripOrders);
                    }

                    $this->ci->otmbookingmodel->insertOrderStatus($tripInternalID, $orders, $orderData['organizationId'], $orderData['businessEntityValue']);
                    $this->ci->common->updatetbledata(
                        "tb_orders",
                        ['order_status' => 1],
                        ['id' => $orderinfo['id'], 'order_id' => $orders]
                    );

                    $this->ci->common->updatetbledata(
                        "tb_trip_stops",
                        ['order_id' => $orderinfo['id']],
                        ['trip_id' => $tripInternalID, 'ship_unit_id' => $orderinfo['ship_unit_id']]
                    );
                }
            }
        }

        /*$userId = $this->ci->otmbookingmodel->getUserId('Integration');
        $TripDrivers = [
        'trip_id' => $tripInternalID,
        'vehicle_id' => $vehicle_id,
        'carrier_id' => $carrier_id,
        'driver_id' => $driver_id,
        'status' => 1,
        'user_id' => $userId
        ];
        $tripDriversInfo = $this->ci->common->gettblrowdata($TripDrivers, "id", "tb_trip_assigned_drivers", 0, 0);
        if (empty($tripDriversInfo)) {
        $this->ci->common->insertTableData('tb_trip_assigned_drivers', $TripDrivers);
        }*/
        return $shipment_gid;
    }

    private function insertReferenceInfo(int $tripInternalID, array $orderData, string $toRefCode, array $orderRef): array
    {
        $refId = $this->ci->otmbookingmodel->checkRefMaster($orderRef['RefType']['Code']);
        if ($refId > 0) {
            $orderRef['RefType']['Code'] = $refId;
            $this->ci->otmshipmentmodel->insertTripReferences(
                $tripInternalID,
                $orderData['organizationId'],
                $orderData['businessEntityValue'],
                $orderRef
            );
        }
        return $orderRef;
    }

    private function insertRemarkInfo(int $tripInternalID, array $orderData, string $toRemarkCode, array $orderRem): array
    {
        $remId = $this->ci->otmbookingmodel->checkRemMaster($orderRem['RemarkType']['Code']);
        if ($remId > 0) {
            $orderRem['RemarkType']['Code'] = $remId;
            $this->ci->otmshipmentmodel->insertTripRemarks(
                $tripInternalID,
                $orderData['organizationId'],
                $orderData['businessEntityValue'],
                $orderRem
            );
        }
        return $orderRem;
    }

    public function insertTripStopsDetails(
        array $tripStop,
        int $organizationId,
        int $businessEntityValue,
        int $businessEntityID,
        string $domain,
        int $tripId,
        int $startlocationID,
        int $endlocationID,
        string $type,
        string $organization,
        string $businessEntity,
        string $carrier_id
    ): void {
        if ($type == 'NEW') {
            $sequence = $tripStop['StopSequence'];
            $stopType = $tripStop['StopType'];
            $locationRoleId = 0;
            if ($stopType == "P") {
                $partyType = "PICKUP";
                $locationRoleId = "1";
            }
            if ($stopType == "D") {
                $partyType = "DELIVERY";
                $locationRoleId = "2";
            }
            $locationId = $this->ci->otmbookinghandler->checkPartyContactsDetails(
                $tripStop['Address'],
                $organizationId,
                $businessEntityValue,
                $domain,
                //0,
                $carrier_id,
                $partyType,
                $organization,
                $businessEntity
            );
            $locationId = $locationId['partyContactID'];
        }

        if (!empty($tripStop['TripStopDetail'])) {
            if (array_key_exists("0", $tripStop['TripStopDetail']) == 1) {
                foreach ($tripStop['TripStopDetail'] as $tripStopDetail) {
                    $tripStopsInfo = [
                        'trip_id' => $tripId,
                        'stop_num' => is_array($sequence) ? "" : $sequence,
                        'location_gid' => empty($locationId) ? "0" : $locationId,
                        'location_role_gid' => empty($locationRoleId) ? "0" : $locationRoleId,
                        'planned_arrival' => is_array($tripStop['ArrivalTime']['PlannedTime']) ? "" : $tripStop['ArrivalTime']['PlannedTime'],
                        'estimated_arrival' => is_array($tripStop['ArrivalTime']['EstimatedTime']) ? "" : $tripStop['ArrivalTime']['EstimatedTime'],
                        'planned_departure' => is_array($tripStop['DepartureTime']['PlannedTime']) ? "" : $tripStop['DepartureTime']['PlannedTime'],
                        'estimated_departure' => is_array($tripStop['DepartureTime']['EstimatedTime']) ? "" : $tripStop['DepartureTime']['EstimatedTime'],
                        'dist_from_prev_stop' => is_array($tripStop['DistFromPrevStop']['DistanceValue']) ? "" : $tripStop['DistFromPrevStop']['DistanceValue'],
                        'dist_from_prev_stop_uom_code' => is_array($tripStop['DistFromPrevStop']['DistanceUOMGid']) ? "" : $tripStop['DistFromPrevStop']['DistanceUOMGid'],
                        'activity_time_base' => empty($tripStopDetail['ActivityBase']) ? "" : $tripStopDetail['ActivityBase'],
                        'activity_time' => empty($tripStopDetail['DurationValue']) ? "" : $tripStopDetail['DurationValue'],
                        'activity_time_uom_code' => empty($tripStopDetail['DurationUOMGid']) ? "" : $tripStopDetail['DurationUOMGid'],
                        'ship_unit_id' => empty($tripStopDetail['ShipUnitId']) ? "" : $tripStopDetail['ShipUnitId'],
                        'stop_type' => is_array($tripStop['StopType']) ? empty($tripStop['TripStopDetail']['ActivityBase']) ? "" : $tripStop['TripStopDetail']['ActivityBase'] : $tripStop['StopType'],
                        'is_permanent' => is_array($tripStop['IsPermanent'] == 'N') ? 1 : 0,
                        'is_depot' => is_array($tripStop['IsDepot'] == 'N') ? 1 : 0,
                        'accessorial_time' => is_array($tripStop['AccessorialTime']['DurationValue']) ? "" : $tripStop['AccessorialTime']['DurationValue'],
                        'accessorial_time_uom_code' => is_array($tripStop['AccessorialTime']['DurationUOMGid']) ? "" : $tripStop['AccessorialTime']['DurationUOMGid'],
                        'rush_hour_time' => is_array($tripStop['RushHourTime']['DurationValue']) ? "" : $tripStop['RushHourTime']['DurationValue'],
                        'rush_hour_time_uom_code' => is_array($tripStop['RushHourTime']['DurationUOMGid']) ? "" : $tripStop['RushHourTime']['DurationUOMGid'],
                        'is_mother_vessel' => is_array($tripStop['IsMotherVessel']) ? "" : $tripStop['IsMotherVessel'],
                        'organization_id' => $organizationId,
                        'entity_value_id' => $businessEntityValue,
                        'status' => 1,
                    ];

                    $shipUnitId = empty($tripStopDetail['ShipUnitId']) ? "" : $tripStopDetail['ShipUnitId'];

                    $checkTripStops = [
                        'trip_id' => $tripId,
                        'stop_num' => $sequence,
                        'ship_unit_id' => $shipUnitId,
                        'location_gid' => empty($locationId) ? "0" : $locationId,
                        'location_role_gid' => empty($locationRoleId) ? "0" : $locationRoleId,
                        'organization_id' => $organizationId,
                        'entity_value_id' => $businessEntityValue,
                    ];

                    $checkStopLocation = $this->ci->common->gettblrowdata(
                        $checkTripStops,
                        "trip_stop_id",
                        "tb_trip_stops",
                        0,
                        0
                    );

                    if (empty($checkStopLocation)) {
                        $trip_stop_id = $this->ci->common->insertTableData('tb_trip_stops', $tripStopsInfo);
                    } else {
                        $trip_stop_id = $checkStopLocation['trip_stop_id'];
                        $this->ci->common->updatetbledata(
                            "tb_trip_stops",
                            $tripStopsInfo,
                            ['trip_stop_id' => $trip_stop_id, 'ship_unit_id' => $shipUnitId]
                        );
                    }
                }
            } else {
                $tripStopsInfo = [
                    'trip_id' => $tripId,
                    'stop_num' => is_array($sequence) ? "" : $sequence,
                    'location_gid' => empty($locationId) ? "0" : $locationId,
                    'location_role_gid' => empty($locationRoleId) ? "0" : $locationRoleId,
                    'planned_arrival' => is_array($tripStop['ArrivalTime']['PlannedTime']) ? "" : $tripStop['ArrivalTime']['PlannedTime'],
                    'estimated_arrival' => is_array($tripStop['ArrivalTime']['EstimatedTime']) ? "" : $tripStop['ArrivalTime']['EstimatedTime'],
                    'planned_departure' => is_array($tripStop['DepartureTime']['PlannedTime']) ? "" : $tripStop['DepartureTime']['PlannedTime'],
                    'estimated_departure' => is_array($tripStop['DepartureTime']['EstimatedTime']) ? "" : $tripStop['DepartureTime']['EstimatedTime'],
                    'dist_from_prev_stop' => is_array($tripStop['DistFromPrevStop']['DistanceValue']) ? "" : $tripStop['DistFromPrevStop']['DistanceValue'],
                    'dist_from_prev_stop_uom_code' => is_array($tripStop['DistFromPrevStop']['DistanceUOMGid']) ? "" : $tripStop['DistFromPrevStop']['DistanceUOMGid'],
                    'activity_time_base' => empty($tripStop['TripStopDetail']['ActivityBase']) ? "" : $tripStop['TripStopDetail']['ActivityBase'],
                    'activity_time' => empty($tripStop['TripStopDetail']['DurationValue']) ? "" : $tripStop['TripStopDetail']['DurationValue'],
                    'activity_time_uom_code' => empty($tripStop['TripStopDetail']['DurationUOMGid']) ? "" : $tripStop['TripStopDetail']['DurationUOMGid'],
                    'ship_unit_id' => empty($tripStop['TripStopDetail']['ShipUnitId']) ? "" : $tripStop['TripStopDetail']['ShipUnitId'],
                    'stop_type' => is_array($tripStop['StopType']) ? empty($tripStop['TripStopDetail']['ActivityBase']) ? "" : $tripStop['TripStopDetail']['ActivityBase'] : $tripStop['StopType'],
                    'is_permanent' => is_array($tripStop['IsPermanent'] == 'N') ? 1 : 0,
                    'is_depot' => is_array($tripStop['IsDepot'] == 'N') ? 1 : 0,
                    'accessorial_time' => is_array($tripStop['AccessorialTime']['DurationValue']) ? "" : $tripStop['AccessorialTime']['DurationValue'],
                    'accessorial_time_uom_code' => is_array($tripStop['AccessorialTime']['DurationUOMGid']) ? "" : $tripStop['AccessorialTime']['DurationUOMGid'],
                    'rush_hour_time' => is_array($tripStop['RushHourTime']['DurationValue']) ? "" : $tripStop['RushHourTime']['DurationValue'],
                    'rush_hour_time_uom_code' => is_array($tripStop['RushHourTime']['DurationUOMGid']) ? "" : $tripStop['RushHourTime']['DurationUOMGid'],
                    'is_mother_vessel' => is_array($tripStop['IsMotherVessel']) ? "" : $tripStop['IsMotherVessel'],
                    'organization_id' => $organizationId,
                    'entity_value_id' => $businessEntityValue,
                    'status' => 1,
                ];

                $shipUnitId = empty($tripStop['TripStopDetail']['ShipUnitId']) ? "" : $tripStop['TripStopDetail']['ShipUnitId'];

                $checkTripStops = [
                    'trip_id' => $tripId,
                    'stop_num' => $sequence,
                    'ship_unit_id' => $shipUnitId,
                    'location_gid' => empty($locationId) ? "0" : $locationId,
                    'location_role_gid' => empty($locationRoleId) ? "0" : $locationRoleId,
                    'organization_id' => $organizationId,
                    'entity_value_id' => $businessEntityValue,
                ];

                $checkStopLocation = $this->ci->common->gettblrowdata(
                    $checkTripStops,
                    "trip_stop_id",
                    "tb_trip_stops",
                    0,
                    0
                );

                if (empty($checkStopLocation)) {
                    $trip_stop_id = $this->ci->common->insertTableData('tb_trip_stops', $tripStopsInfo);
                } else {
                    $trip_stop_id = $checkStopLocation['trip_stop_id'];
                    $this->ci->common->updatetbledata(
                        "tb_trip_stops",
                        $tripStopsInfo,
                        ['trip_stop_id' => $trip_stop_id, 'ship_unit_id' => $shipUnitId]
                    );
                }
            }
        }
    }

    public function getLocationDetails(
        array $locationDetails,
        int $organizationId,
        int $businessEntityValue,
        int $businessEntityID
    ): int {
        $party_location = [
            'name' => is_array($locationDetails['CompanyName']) ? "0" : $locationDetails['CompanyName'],
            'organization_id' => $organizationId,
            'business_entity_value' => $businessEntityValue,
            'business_entity' => $businessEntityID,
            'status' => 1,
        ];

        $checkLocation = $this->ci->common->gettblrowdata(
            $party_location,
            "party_location_id",
            "tb_party_location",
            0,
            0
        );

        if (empty($checkLocation) || $checkLocation == 0) {
            $partyLocationInfo = [
                'name' => is_array($locationDetails['CompanyName']) ? "" : $locationDetails['CompanyName'],
                'address1' => is_array($locationDetails['Address1']) ? "" : $locationDetails['Address1'],
                'address2' => is_array($locationDetails['Address2']) ? "" : $locationDetails['Address2'],
                'city' => is_array($locationDetails['City']) ? "" : $locationDetails['City'],
                'street' => is_array($locationDetails['Street']) ? "" : $locationDetails['Street'],
                'state' => is_array($locationDetails['State']) ? "" : $locationDetails['State'],
                'country' => is_array($locationDetails['Country']) ? "" : $locationDetails['Country'],
                'postal_code' => is_array($locationDetails['Postal']) ? "" : $locationDetails['Postal'],
                'province' => is_array($locationDetails['State']) ? "" : $locationDetails['State'],
                'latitude' => is_array($locationDetails['Latitude']) ? "" : $locationDetails['Latitude'],
                'longitude' => is_array($locationDetails['Longitude']) ? "" : $locationDetails['Longitude'],
                'country_code' => is_array(
                    $locationDetails['ContactInfo']['CountryCode']
                ) ? "" : $locationDetails['ContactInfo']['CountryCode'],
                'phone' => is_array(
                    $locationDetails['ContactInfo']['ContactNo']
                ) ? "0" : $locationDetails['ContactInfo']['ContactNo'],
                'email' => is_array(
                    $locationDetails['ContactInfo']['EmailAddress']
                ) ? "" : $locationDetails['ContactInfo']['EmailAddress'],
                'organization_id' => $organizationId,
                'business_entity_value' => $businessEntityValue,
                'business_entity' => $businessEntityID,
                'status' => 1,
            ];
            $party_location_id = $this->ci->common->insertTableData('tb_party_contacts', $partyLocationInfo);
        } else {
            $party_location_id = $checkLocation['party_location_id'];
        }

        return $party_location_id ?? 0;
    }

    public function getLocationRoleDetails(
        string $locationRoleGid
    ): int {
        $party_role = [
            'party_role' => $locationRoleGid,
            'status' => 1,
        ];
        $checkLocationRole = $this->ci->common->gettblrowdata(
            $party_role,
            "id",
            "tb_party_roles",
            0,
            0
        );
        if (!empty($checkLocationRole)) {
            $partyRole = $checkLocationRole['id'];
        }

        return $partyRole ?? 0;
    }

    public function getDriverDetails(
        array $DriverDetails,
        int $organizationId,
        int $businessEntityValue,
        int $businessEntityID,
        int $carrier_id,
        int $vehicle_id
    ): int {
        $DriverId = is_array($DriverDetails['DriverId']) ? "0" : $DriverDetails['DriverId'];
        $DriverName = is_array($DriverDetails['DriverName']) ? "" : $DriverDetails['DriverName'];
        $DriverLicence = is_array($DriverDetails['DriverLicence']) ? "" : $DriverDetails['DriverLicence'];
        $Address1 = is_array($DriverDetails['Address']['Address1']) ? "" : $DriverDetails['Address']['Address1'];
        $Address2 = is_array($DriverDetails['Address']['Address2']) ? "" : $DriverDetails['Address']['Address2'];
        $Street = is_array($DriverDetails['Address']['Street']) ? "" : $DriverDetails['Address']['Street'];
        $City = is_array($DriverDetails['Address']['City']) ? "" : $DriverDetails['Address']['City'];
        $State = is_array($DriverDetails['Address']['State']) ? "" : $DriverDetails['Address']['State'];
        $Postal = is_array($DriverDetails['Address']['Postal']) ? "" : $DriverDetails['Address']['Postal'];
        $Country = is_array($DriverDetails['Address']['Country']) ? "" : $DriverDetails['Address']['Country'];
        $CountryCode = is_array(
            $DriverDetails['Address']['ContactInfo']['CountryCode']
        ) ? "" : $DriverDetails['Address']['ContactInfo']['CountryCode'];
        $ContactNo = is_array(
            $DriverDetails['Address']['ContactInfo']['ContactNo']
        ) ? "" : $DriverDetails['Address']['ContactInfo']['ContactNo'];
        $EmailAddress = is_array(
            $DriverDetails['Address']['ContactInfo']['EmailAddress']
        ) ? "" : $DriverDetails['Address']['ContactInfo']['EmailAddress'];
        $checkParty = $this->ci->common->gettblrowdata(
            ["driver_name" => $DriverName, 'driving_licence_num' => $DriverLicence, 'status' => "Active"],
            "driver_id",
            "tb_driver_details",
            0,
            0
        );
        if (!empty($checkParty)) {
            $driver_id = $checkParty['driver_id'];
        } else {
            $driverData = [
                'driver_name' => $DriverName,
                'contact_num' => $ContactNo,
                'password' => password_hash($ContactNo, PASSWORD_DEFAULT),
                'driving_licence_num' => $DriverLicence,
                'address1' => $Address1,
                'address2' => $Address2,
                'street' => $Street,
                'city' => $City,
                'state' => $State,
                'pincode' => $Postal,
                'country' => $Country,
                'email' => $EmailAddress,
                "organization_id" => $organizationId,
                "business_entity_value_id" => $businessEntityValue,
                'status' => 1,
            ];
            $driver_id = $this->ci->common->insertTableData('tb_driver_details', $driverData);
        }

        return $driver_id ?? 0;
    }

    public function getVehicleDetails(
        array $VehicleDetails,
        int $organizationId,
        int $businessEntityValue,
        int $businessEntityID,
        int $carrier_id
    ): int {
        $vehicleTypeCode = is_array($VehicleDetails['VehicleTypeCode']) ? "0" : $VehicleDetails['VehicleTypeCode'];
        /*$VehicleModelCode = is_array($VehicleDetails['VehicleModelCode']) ? "0" : $VehicleDetails['VehicleModelCode'];
        $RegistrationNumber = is_array(
        $VehicleDetails['RegistrationNumber']
        ) ? "0" : $VehicleDetails['RegistrationNumber'];
        $License = is_array($VehicleDetails['License']) ? "0" : $VehicleDetails['License'];
        $ApplicableForDangerousGoods = is_array(
        $VehicleDetails['ApplicableForDangerousGoods']
        ) ? "0" : $VehicleDetails['ApplicableForDangerousGoods'];
        $CommodityType = is_array($VehicleDetails['CommodityType']) ? "0" : $VehicleDetails['CommodityType'];
        $minWeight = is_array(
        $VehicleDetails['Properties']['Weight']['Min']
        ) ? "0" : $VehicleDetails['Properties']['Weight']['Min'];
        $maxWeight = is_array(
        $VehicleDetails['Properties']['Weight']['Max']
        ) ? "0" : $VehicleDetails['Properties']['Weight']['Max'];
        $weightUOM = is_array(
        $VehicleDetails['Properties']['Weight']['UOM']
        ) ? "0" : $VehicleDetails['Properties']['Weight']['UOM'];
        $minVolume = is_array(
        $VehicleDetails['Properties']['Volume']['Min']
        ) ? "0" : $VehicleDetails['Properties']['Volume']['Min'];
        $maxVolume = is_array(
        $VehicleDetails['Properties']['Volume']['Max']
        ) ? "0" : $VehicleDetails['Properties']['Volume']['Max'];
        $VolumeUOM = is_array(
        $VehicleDetails['Properties']['Volume']['UOM']
        ) ? "0" : $VehicleDetails['Properties']['Volume']['UOM'];
        $minLength = is_array(
        $VehicleDetails['Properties']['Length']['Min']
        ) ? "0" : $VehicleDetails['Properties']['Length']['Min'];
        $maxLength = is_array(
        $VehicleDetails['Properties']['Length']['Max']
        ) ? "0" : $VehicleDetails['Properties']['Length']['Max'];
        $LengthUOM = is_array(
        $VehicleDetails['Properties']['Length']['UOM']
        ) ? "0" : $VehicleDetails['Properties']['Length']['UOM'];
        $minWidth = is_array(
        $VehicleDetails['Properties']['Width']['Min']
        ) ? "0" : $VehicleDetails['Properties']['Width']['Min'];
        $maxWidth = is_array(
        $VehicleDetails['Properties']['Width']['Max']
        ) ? "0" : $VehicleDetails['Properties']['Width']['Max'];
        $WidthUOM = is_array(
        $VehicleDetails['Properties']['Width']['UOM']
        ) ? "0" : $VehicleDetails['Properties']['Width']['UOM'];
        $minHeight = is_array(
        $VehicleDetails['Properties']['Height']['Min']
        ) ? "0" : $VehicleDetails['Properties']['Height']['Min'];
        $maxHeight = is_array(
        $VehicleDetails['Properties']['Height']['Max']
        ) ? "0" : $VehicleDetails['Properties']['Height']['Max'];
        $HeightUOM = is_array(
        $VehicleDetails['Properties']['Height']['UOM']
        ) ? "0" : $VehicleDetails['Properties']['Height']['UOM'];
        $minDistance = is_array(
        $VehicleDetails['Properties']['Distance']['Min']
        ) ? "0" : $VehicleDetails['Properties']['Distance']['Min'];
        $maxDistance = is_array(
        $VehicleDetails['Properties']['Distance']['Max']
        ) ? "0" : $VehicleDetails['Properties']['Distance']['Max'];
        $DistanceUOM = is_array(
        $VehicleDetails['Properties']['Distance']['UOM']
        ) ? "0" : $VehicleDetails['Properties']['Distance']['UOM'];
        $minDimensionGirth = is_array(
        $VehicleDetails['Properties']['DimensionGirth']['Min']
        ) ? "0" : $VehicleDetails['Properties']['DimensionGirth']['Min'];
        $maxDimensionGirth = is_array(
        $VehicleDetails['Properties']['DimensionGirth']['Max']
        ) ? "0" : $VehicleDetails['Properties']['DimensionGirth']['Max'];
        $DimensionGirthUOM = is_array(
        $VehicleDetails['Properties']['DimensionGirth']['UOM']
        ) ? "0" : $VehicleDetails['Properties']['DimensionGirth']['UOM'];
        $minShipmentUnit = is_array(
        $VehicleDetails['Properties']['ShipmentUnit']['Min']
        ) ? "0" : $VehicleDetails['Properties']['ShipmentUnit']['Min'];
        $maxShipmentUnit = is_array(
        $VehicleDetails['Properties']['ShipmentUnit']['Max']
        ) ? "0" : $VehicleDetails['Properties']['ShipmentUnit']['Max'];
        $ShipmentUnitUOM = is_array(
        $VehicleDetails['Properties']['ShipmentUnit']['UOM']
        ) ? "0" : $VehicleDetails['Properties']['ShipmentUnit']['UOM'];
        $minPacketWeight = is_array(
        $VehicleDetails['Properties']['PacketWeight']['Min']
        ) ? "0" : $VehicleDetails['Properties']['PacketWeight']['Min'];
        $maxPacketWeight = is_array(
        $VehicleDetails['Properties']['PacketWeight']['Max']
        ) ? "0" : $VehicleDetails['Properties']['PacketWeight']['Max'];
        $PacketWeightUOM = is_array(
        $VehicleDetails['Properties']['PacketWeight']['UOM']
        ) ? "0" : $VehicleDetails['Properties']['PacketWeight']['UOM'];
        $minPacketVolume = is_array(
        $VehicleDetails['Properties']['PacketVolume']['Min']
        ) ? "0" : $VehicleDetails['Properties']['PacketVolume']['Min'];
        $maxPacketVolume = is_array(
        $VehicleDetails['Properties']['PacketVolume']['Max']
        ) ? "0" : $VehicleDetails['Properties']['PacketVolume']['Max'];
        $PacketVolumeUOM = is_array(
        $VehicleDetails['Properties']['PacketVolume']['UOM']
        ) ? "0" : $VehicleDetails['Properties']['PacketVolume']['UOM'];*/
        $vehicleTypeInfo = [
            "vehicle_type_id" => $vehicleTypeCode,
            "vehicle_type_name" => $vehicleTypeCode,
            "organization_id" => $organizationId,
            "business_entity_id" => $businessEntityID,
            "business_entity_value_id" => $businessEntityValue,
            'status' => 1,
        ];
        $vehicle_id = $vehicle_type_id = 0;
        $vehicleTypeCodeValue = $this->ci->common->gettblrowdata($vehicleTypeInfo, "id", "tb_vehicle_type_master", 0, 0);
        if (!empty($vehicleTypeCodeValue)) {
            $vehicle_type_id = $vehicleTypeCodeValue['id'];
        }
        if (!empty($vehicleTypeCode) && $vehicle_type_id == 0) {
            $vehicle_type_id = $this->ci->common->insertTableData('tb_vehicle_type_master', $vehicleTypeInfo);
        }

        /*$partyWhere = [
        "register_number" => $RegistrationNumber,
        "organization_id" => $organizationId,
        "business_entity_value_id" => $businessEntityValue,
        'status' => 1,
        ];
        $checkVehicleDetails = $this->ci->common->gettblrowdata($partyWhere, "vehicle_id", "tb_vehicle_details", 0, 0);
        if (!empty($checkVehicleDetails)) {
        $vehicle_id = $checkVehicleDetails['vehicle_id'];
        } else {
        $vehicleDetails = [
        'truck_number' => $RegistrationNumber,
        'length' => $maxLength,
        'length_unit' => $LengthUOM,
        'breadth' => $maxWidth,
        'breadth_unit' => $WidthUOM,
        'vehicle_type' => $vehicle_type_id,
        'truck_brand' => $vehicle_type_id,
        'description' => $RegistrationNumber,
        'register_number' => $RegistrationNumber,
        "organization_id" => $organizationId,
        "business_entity_value_id" => $businessEntityValue,
        ];
        $vehicle_id = $this->ci->common->insertTableData('tb_vehicle_details', $vehicleDetails);
        }*/

        return $vehicle_type_id ?? 0;
    }

    public function getCarrierDetails(
        array $CarrierDetails,
        int $organizationId,
        int $businessEntityValue,
        int $businessEntityID
    ): int {
        $carrierCode = is_array($CarrierDetails['ID']) ? "0" : $CarrierDetails['ID'];
        $carrierName = is_array($CarrierDetails['Company']['Name']) ? "0" : $CarrierDetails['Company']['Name'];
        $party_code = is_array(
            $CarrierDetails['Company']['RegistrationNumber']
        ) ? "0" : $CarrierDetails['Company']['RegistrationNumber'];
        $address1 = is_array($CarrierDetails['Address']['Address1']) ? "" : $CarrierDetails['Address']['Address1'];
        $address2 = is_array($CarrierDetails['Address']['Address2']) ? "" : $CarrierDetails['Address']['Address2'];
        $street = is_array($CarrierDetails['Address']['Street']) ? "" : $CarrierDetails['Address']['Street'];
        $city = is_array($CarrierDetails['Address']['City']) ? "" : $CarrierDetails['Address']['City'];
        $State = (is_array($CarrierDetails['Address']['State']) ? "" : $CarrierDetails['Address']['State']);
        $postal = (is_array($CarrierDetails['Address']['Postal']) ? "" : $CarrierDetails['Address']['Postal']);
        $country = (is_array($CarrierDetails['Address']['Country']) ? "" : $CarrierDetails['Address']['Country']);
        $email = (is_array(
            $CarrierDetails['Address']['ContactInfo']['EmailAddress']
        ) ? "" : $CarrierDetails['Address']['ContactInfo']['EmailAddress']);
        $phone = (is_array(
            $CarrierDetails['Address']['ContactInfo']['ContactNo']
        ) ? "" : $CarrierDetails['Address']['ContactInfo']['ContactNo']);
        $latitude = (is_array($CarrierDetails['Address']['Latitude']) ? "" : $CarrierDetails['Address']['Latitude']);
        $longitude = (is_array($CarrierDetails['Address']['Longitude']) ? "" : $CarrierDetails['Address']['Longitude']);
        $address = $address1 . "," . $address2 . "," . $street . "," . $city . "," . $State . "," . $postal . "," . $country;
        if ($latitude == "" && $longitude == "") {
            $data = getlatlngsbyaddress($address);
            $latitude = @$data[0];
            $longitude = @$data[1];
        }
        $partyWhere = [
            "carrier_name" => $carrierName,
            "code" => $carrierCode,
            "organization_id" => $organizationId,
            "business_entity_value_id" => $businessEntityValue,
            'status' => 1,
        ];
        $checkCarrier = $this->ci->common->gettblrowdata($partyWhere, "carrier_id", "tb_carrier_details", 0, 0);
        if (!empty($checkCarrier)) {
            $partyContactID = $checkCarrier['carrier_id'];
        } else {
            $partyWhere = [
                "carrier_name" => $carrierName,
                "organization_id" => $organizationId,
                "business_entity_value_id" => $businessEntityValue,
                'status' => 1,
            ];
            $checkCarrier = $this->ci->common->gettblrowdata($partyWhere, "carrier_id", "tb_carrier_details", 0, 0);
            if (!empty($checkCarrier)) {
                $partyContactID = $checkCarrier['carrier_id'];
            } else {
                $partycontactInfo = [
                    "carrier_name" => $carrierName,
                    "organization_id" => $organizationId,
                    "business_entity_value_id" => $businessEntityValue,
                    'status' => 1,
                    'address1' => $phone,
                    'address2' => $phone,
                    'mobile' => $phone,
                    'email' => $email,
                    'street' => $street,
                    'city' => $city,
                    'state' => $State,
                    'pincode' => $postal,
                    'country' => $country,
                    'latitude' => $latitude,
                    'longitude' => $longitude,
                ];
                $partyContactID = $this->ci->common->insertTableData('tb_carrier_details', $partycontactInfo);
                if ($carrierCode == 0) {
                    $carrierCode = $organizationId . $businessEntityValue . date('y') . date('W') . $partyContactID;
                    $this->ci->common->updatetbledata(
                        "tb_carrier_details",
                        ['code' => $carrierCode],
                        ['carrier_id' => $partyContactID]
                    );
                }
            }
        }
        return $partyContactID ?? 0;
    }

    /*public function getCarrierDetails(
    array $CarrierDetails,
    int $organizationId,
    int $businessEntityValue,
    int $businessEntityID
    ): int {
    $carrierCode = is_array($CarrierDetails['ID']) ? "0" : $CarrierDetails['ID'];
    $carrierName = is_array($CarrierDetails['Company']['Name']) ? "0" : $CarrierDetails['Company']['Name'];
    $party_code = is_array(
    $CarrierDetails['Company']['RegistrationNumber']
    ) ? "0" : $CarrierDetails['Company']['RegistrationNumber'];
    $address1 = is_array($CarrierDetails['Address']['Address1']) ? "" : $CarrierDetails['Address']['Address1'];
    $address2 = is_array($CarrierDetails['Address']['Address2']) ? "" : $CarrierDetails['Address']['Address2'];
    $street = is_array($CarrierDetails['Address']['Street']) ? "" : $CarrierDetails['Address']['Street'];
    $city = is_array($CarrierDetails['Address']['City']) ? "" : $CarrierDetails['Address']['City'];
    $State = (is_array($CarrierDetails['Address']['State']) ? "" : $CarrierDetails['Address']['State']);
    $postal = (is_array($CarrierDetails['Address']['Postal']) ? "" : $CarrierDetails['Address']['Postal']);
    $country = (is_array($CarrierDetails['Address']['Country']) ? "" : $CarrierDetails['Address']['Country']);
    $email = (is_array(
    $CarrierDetails['Address']['ContactInfo']['EmailAddress']
    ) ? "" : $CarrierDetails['Address']['ContactInfo']['EmailAddress']);
    $phone = (is_array(
    $CarrierDetails['Address']['ContactInfo']['ContactNo']
    ) ? "" : $CarrierDetails['Address']['ContactInfo']['ContactNo']);
    $latitude = (is_array($CarrierDetails['Address']['Latitude']) ? "" : $CarrierDetails['Address']['Latitude']);
    $longitude = (is_array($CarrierDetails['Address']['Longitude']) ? "" : $CarrierDetails['Address']['Longitude']);
    $address = $address1 . "," . $address2 . "," . $street . "," . $city . "," . $State . "," . $postal . "," . $country;
    if ($latitude == "" && $longitude == "") {
    $data = getlatlngsbyaddress($address);
    $latitude = @$data[0];
    $longitude = @$data[1];
    }
    $partyWhere = [
    "carrier_name" => $carrierName,
    "code" => $carrierCode,
    "organization_id" => $organizationId,
    "business_entity_value_id" => $businessEntityValue,
    'status' => 1,
    ];
    $checkCarrier = $this->ci->common->gettblrowdata($partyWhere, "carrier_id", "tb_carrier_details", 0, 0);
    if (!empty($checkCarrier)) {
    $partyContactID = $checkCarrier['carrier_id'];
    } else {
    $partyWhere = [
    "carrier_name" => $carrierName,
    "organization_id" => $organizationId,
    "business_entity_value_id" => $businessEntityValue,
    'status' => 1,
    ];
    $checkCarrier = $this->ci->common->gettblrowdata($partyWhere, "carrier_id", "tb_carrier_details", 0, 0);
    if (!empty($checkCarrier)) {
    $partyContactID = $checkCarrier['carrier_id'];
    } else {
    $partycontactInfo = [
    "carrier_name" => $carrierName,
    "organization_id" => $organizationId,
    "business_entity_value_id" => $businessEntityValue,
    'status' => 1,
    'address1' => $phone,
    'address2' => $phone,
    'mobile' => $phone,
    'email' => $email,
    'street' => $street,
    'city' => $city,
    'state' => $State,
    'pincode' => $postal,
    'country' => $country,
    'latitude' => $latitude,
    'longitude' => $longitude,
    ];
    $partyContactID = $this->ci->common->insertTableData('tb_carrier_details', $partycontactInfo);
    if ($carrierCode == 0) {
    $carrierCode = $organizationId . $businessEntityValue . date('y') . date('W') . $partyContactID;
    $this->ci->common->updatetbledata(
    "tb_carrier_details",
    ['code' => $carrierCode],
    ['carrier_id' => $partyContactID]
    );
    }
    }
    }
    return $partyContactID ?? 0;
    }*/

    public function orderdetails(
        array $order,
        int $organizationId,
        int $businessEntityValue,
        int $businessEntityID,
        string $organization,
        string $businessEntity,
        string $source,
        string $domain,
        array $parentCustomer,
        string $subCustomerId,
        array $parentCarrier,
        string $subCarrierId
    ): string {
        //$orderMovementId = (empty($order['OrderMovementId']) ? "" : $order['OrderMovementId']);
        $orderMovementId = $order['OrderMovementId'];
        //$orderType = (empty($order['OrderType']) ? "0" : $order['OrderType']);
        $orderType = ($order['OrderType']);
        $modeOfTransport = (empty($order['ModeOfTransport']) ? "0" : $order['ModeOfTransport']);
        $product = (empty($order['Product']) ? "0" : $order['Product']);
        $serviceType = (empty($order['ServiceType']) ? "0" : $order['ServiceType']);
        $orderData = [
            'TripID' => "0",
            'OrderID' => (empty($order['OrderID']) ? "0" : $order['OrderID']),
            'EXTOrderID' => (empty($order['EXTOrderID']) ? "0" : $order['EXTOrderID']),
            'OrderType' => $orderType,
            'ModeOfTransport' => $modeOfTransport,
            'Product' => $product,
            'ServiceType' => $serviceType,
            'organizationId' => $organizationId,
            'businessEntityValue' => $businessEntityValue,
            'businessEntityID' => $businessEntityID,
            'TypeOfBusiness' => (empty($order['TypeOfBusiness']) ? "" : $order['TypeOfBusiness']),
            'Incoterm' => (empty($order['TermsOfTrade']['Incoterm']) ? "" : $order['TermsOfTrade']['Incoterm']),
            'FreightTerm' => (empty($order['TermsOfTrade']['FreightTerm']['Term']) ? "" : $order['TermsOfTrade']['FreightTerm']['Term']),
            'FreightTermName' => (empty($order['TermsOfTrade']['FreightTerm']['Name']) ? "" : $order['TermsOfTrade']['FreightTerm']['Name']),
            'customerDetails' => $order['ELGCUSTOMER'],
            'sourceInfo' => $order['LocationInfo']['Source'],
            'destinationInfo' => $order['LocationInfo']['Destination'],
            'cargoSummary' => $order['OrderCargoSummary'],
            'cargoDetails' => $order['CargoDetails'],
            'valueAddedServices' => $order['ValueAddedServices'],
            'involvedParties' => $order['InvolvedParties'],
            'manageReferences' => $order['ManageReferences'] ?? [],
            'remarks' => $order['Remarks'] ?? [],
            'organization' => $organization,
            'businessEntity' => $businessEntity,
            'orderMovementId' => $orderMovementId,
            'source' => $source,
            'domain' => $domain,
            'parentCustomer' => $parentCustomer,
            'subCustomerId' => $subCustomerId,
            'parentCarrier' => $parentCarrier,
            'subCarrierId' => $subCarrierId,
        ];
        return $this->ci->otmbookinghandler->saveOrderDetails($orderData);
    }
}
