<?php if (! defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Ratemanagement
{

    public function __Construct()
    {
        $ci = &get_instance();
        $ci->load->model('common');
        $ci->load->model('Order');
        $ci->load->model(['RateManagementModel','Orderrevenuesmodel']);
        $ci->load->library('Vatcalculationtorate');
        $ci->load->helper('home_helper');
    }
    public function getcustomerprofiledetailsbyid($cust_id, $service_id, $ploc, $dloc, $info)
    {
        $ci            = &get_instance();
        $customer_code = 0;
        $orderproduct  = "";
        $services      = [];
        $serviceIds    = [];
        if (! empty($info)) {
            $order_id     = isset($info['order_id']) ? $info['order_id'] : "0";
            $orderproduct = isset($info['product']) ? $info['product'] : "";
        }
        $company_code = $ci->session->userdata('company_code');
        $user_id      = $ci->session->userdata('user_id');
        $custwhr      = ['id' => $cust_id];
        if ($cust_id != "" && $cust_id != '0') {
            if ($company_code == 'RUKN') {
                $custwhr = ['id' => $cust_id, 'company_code' => $company_code];
            } else {
                $custwhr = ['id' => $cust_id, 'user_id' => $user_id];
            }
            $getcustomer_code = $ci->common->gettblrowdata($custwhr, "code", 'tb_customers', 0, 0);
            if (! empty($getcustomer_code)) {
                $customer_code = $getcustomer_code['code'];
            } else {
                $customer_code = $cust_id;
            }
            if (! empty($ploc)) {
                if (strtoupper($ploc['country']) == 'AUSTRALIA') {
                    $pickupgeocode = checkgeocode($ploc);
                    $dropgeocode   = checkgeocode($dloc);
                    if (! empty($pickupgeocode) && ! empty($dropgeocode)) {
                        $services = $this->getlanesandservicebygeocodes($pickupgeocode, $dropgeocode, $ploc['user_id'], $ploc['country']);
                    }
                }
            }
            if ($customer_code != '0') {
                $getservices = $ci->Order->getcustomerbasedservices($customer_code, $service_id);
                if ($getservices->num_rows() > 0) {
                    foreach ($getservices->result() as $res) {
                        $service_name = $res->service_name;
                        $product      = $res->product;
                        if ($orderproduct != "") {
                            if ($product != "") {
                                if (strtoupper($orderproduct) == strtoupper($product)) {
                                    $service = $service_id = $res->service_id;
                                    if ($service_name != "") {
                                        $service = $service_id . "-" . $service_name;
                                    } else {
                                        $service = $service_id;
                                    }
                                    if (count($services) > 0) {
                                        for ($i = 0, $sMax = count($services); $i < $sMax; $i++) {
                                            if (! in_array($res->id, $serviceIds)) {
                                                $serviceIds[] = $res->id;
                                                $services[]   = ['service_row_id' => $res->id, 'service_id' => $service];
                                            }
                                        }
                                    } else {
                                        $serviceIds[] = $res->id;
                                        $services[]   = ['service_row_id' => $res->id, 'service_id' => $service];
                                    }
                                }
                            } else {
                                $service = $service_id = $res->service_id;
                                if ($service_name != "") {
                                    $service = $service_id . "-" . $service_name;
                                } else {
                                    $service = $service_id;
                                }
                                if (count($services) > 0) {
                                    for ($i = 0, $sMax = count($services); $i < $sMax; $i++) {
                                        if (! in_array($res->id, $serviceIds)) {
                                            $serviceIds[] = $res->id;
                                            $services[]   = ['service_row_id' => $res->id, 'service_id' => $service];
                                        }
                                    }
                                } else {
                                    $serviceIds[] = $res->id;
                                    $services[]   = ['service_row_id' => $res->id, 'service_id' => $service];
                                }
                            }
                        } else {
                            $service = $service_id = $res->service_id;
                            if ($service_name != "") {
                                $service = $service_id . "-" . $service_name;
                            } else {
                                $service = $service_id;
                            }
                            if (count($services) > 0) {
                                for ($i = 0, $sMax = count($services); $i < $sMax; $i++) {
                                    if (! in_array($res->id, $serviceIds)) {
                                        $serviceIds[] = $res->id;
                                        $services[]   = ['service_row_id' => $res->id, 'service_id' => $service];
                                    }
                                }
                            } else {
                                $serviceIds[] = $res->id;
                                $services[]   = ['service_row_id' => $res->id, 'service_id' => $service];
                            }
                        }
                    }
                }
            }
        }
        $service_id = $this->getservicesbyorderlanes($order_id);
        if (! empty($services)) {
            foreach ($services as $ser) {
                $service_row_id = $ser['service_row_id'];
                if ($service_row_id > 0) {
                    if (in_array($service_row_id, $service_id)) {
                        $result[] = ['service_row_id' => $ser['service_row_id'], 'service_id' => $ser['service_id']];
                    }
                }
            }
        }
        return $result ?? [];

    }

    public function getservicesbyorderlanes($order_id)
    {
        $ci             = &get_instance();
        $service_id     = [];
        $user_id        = $ci->session->userdata('user_id');
        $delivery_zcode = $pickup_zcode = $delivery_city = $pickup_city = $delivery_country = $pickup_country = $pickupState = $deliveryState = "";
        if ($order_id != "" && $order_id > 0) {
            $getdetails = $ci->common->gettblrowdata(['id' => $order_id], "id,pickup_country,delivery_country,pickup_city,delivery_city,pickup_pincode,delivery_pincode,pickup_address2,delivery_address2,pickup_custid,pickup_partyid,drop_custid,drop_partyid", "tb_orders", 0, 0);
            if (! empty($getdetails)) {
                $pickup_country         = $getdetails['pickup_country'];
                $delivery_country       = $getdetails['delivery_country'];
                $pickup_city            = $getdetails['pickup_city'];
                $delivery_city          = $ci->db->escape_str($getdetails['delivery_city']);
                $pickup_zcode           = $getdetails['pickup_pincode'];
                $delivery_zcode         = $getdetails['delivery_pincode'];
                $pickupState            = $getdetails['pickup_address2'];
                $deliveryState          = $ci->db->escape_str($getdetails['delivery_address2']);
                $pickup_sub_district    = '';
                $pickup_division_name   = '';
                $delivery_sub_district  = '';
                $delivery_division_name = '';
                $pwhr                   = " id = '" . $getdetails['pickup_custid'] . "' OR code = '" . $getdetails['pickup_custid'] . "' OR customeridentifier='" . $getdetails['pickup_custid'] . "' ";
                $getpickupsubdetails    = $ci->common->gettblrowdata($pwhr, "sub_district,division_name", "tbl_party_master", 0, 0);
                if (! empty($getpickupsubdetails)) {
                    $pickup_sub_district  = $getpickupsubdetails['sub_district'];
                    $pickup_division_name = $getpickupsubdetails['division_name'];
                }

                $dwhr              = " id = '" . $getdetails['drop_custid'] . "' OR code = '" . $getdetails['drop_custid'] . "' OR customeridentifier='" . $getdetails['drop_custid'] . "'";
                $getdropsubdetails = $ci->common->gettblrowdata($dwhr, "sub_district,division_name", "tbl_party_master", 0, 0);
                if (! empty($getdropsubdetails)) {
                    $delivery_sub_district  = $getdropsubdetails['sub_district'];
                    $delivery_division_name = $getdropsubdetails['division_name'];
                }
            }
        }
        $source = [
            'pickup_country'         => $pickup_country,
            'delivery_country'       => $delivery_country,
            'pickup_city'            => $pickup_city,
            'delivery_city'          => $delivery_city,
            'pickup_zcode'           => $pickup_zcode,
            'delivery_zcode'         => $delivery_zcode,
            'user_id'                => $user_id,
            'pickup_sub_district'    => $pickup_sub_district,
            'pickup_division_name'   => $pickup_division_name,
            'delivery_sub_district'  => $delivery_sub_district,
            'delivery_division_name' => $delivery_division_name,
            'pickup_state'           => $pickupState,
            'delivery_state'         => $deliveryState,
        ];
        $getservice_id = $ci->Order->getserviceid_bylanes($source);
        foreach ($getservice_id as $row) {
            if ($row['rate_id'] > 0) {
                $service_id[] = $row['rate_id'];
            }
        }
        return $service_id;
    }
    public function getlanesandservicebygeocodes($pickup, $delivery, $user_id, $country)
    {
        $ci           = &get_instance();
        $lane_id      = 0;
        $services     = [];
        $company_code = $ci->session->userdata('company_code');
        if (! empty($pickup) && ! empty($delivery)) {
            $pickup_region   = isset($pickup['region']) ? $pickup['region'] : "";
            $delivery_region = isset($delivery['region']) ? $delivery['region'] : "";
            if ($pickup_region != "" && $delivery_region != "") {
                if ($company_code == "RUKN") {
                    $chkqry = $ci->db->query("SELECT l.id FROM tb_lanes_master l,tb_geo_master g WHERE g.name LIKE 'Region' AND g.id=l.source_geo AND l.source='" . $pickup_region . "' AND l.source_country='" . $country . "' AND g.id =l.destination_geo  AND l.destination ='" . $delivery_region . "' AND l.destination_country='" . $country . "'");
                } else {
                    $chkqry = $ci->db->query("SELECT l.id FROM tb_lanes_master l,tb_geo_master g WHERE g.name LIKE 'Region' AND g.id=l.source_geo AND l.source='" . $pickup_region . "' AND l.source_country='" . $country . "' AND g.id =l.destination_geo  AND l.destination ='" . $delivery_region . "' AND l.destination_country='" . $country . "' AND l.user_id ='" . $user_id . "'");
                }
                if ($chkqry->num_rows() > 0) {
                    $lane_id = $chkqry->row()->id;
                }
            }
        }
        if ($lane_id != "0") {
            if ($company_code == "RUKN") {
                $chkservice = $ci->db->query("SELECT r.id,r.service_id,r.service_name FROM tb_rate_services r,tb_rateservice_lanes l WHERE l.lane_id='" . $lane_id . "' AND l.rate_id =r.id AND l.status='1' AND r.status ='1' ");
            } else {
                $chkservice = $ci->db->query("SELECT r.id,r.service_id,r.service_name FROM tb_rate_services r,tb_rateservice_lanes l WHERE l.lane_id='" . $lane_id . "' AND l.rate_id =r.id AND l.status='1' AND r.status ='1' AND r.user_id ='" . $user_id . "' ");
            }
            if ($chkservice->num_rows() > 0) {
                foreach ($chkservice->result() as $res) {
                    $service_name = $res->service_name;
                    $service      = $service_id      = $res->service_id;
                    if ($service_name != "") {
                        $service = $service_id . "-" . $service_name;
                    } else {
                        $service = $service_id;
                    }
                    $services[] = ['service_row_id' => $res->id, 'service_id' => $service];
                }
            }
        }

        return $services;
    }
    public function getvendorprofiledetailsbyid($vendor_id, $service_id, $info)
    {
        $ci          = &get_instance();
        $vendor_code = 0;
        $services    = [];
        if ($vendor_id != "" && $vendor_id != '0') {
            $getvendor_code = $ci->common->gettblrowdata(['id' => $vendor_id], "code", 'tb_vendors', 0, 0);
            if (! empty($getvendor_code)) {
                $vendor_code = $getvendor_code['code'];
            }
            if ($vendor_code != '0') {
                $getservices = $ci->Order->getVendorbasedservices($vendor_code, $service_id);
                if ($getservices->num_rows() > 0) {
                    foreach ($getservices->result() as $res) {
                        $service_name = $res->service_name;
                        $service      = $service_id      = $res->service_id;
                        if ($service_name != "") {
                            $service = $service_id . "-" . $service_name;
                        } else {
                            $service = $service_id;
                        }
                        $services[] = ['service_row_id' => $res->id, 'service_id' => $service, 'vendor_code' => $vendor_code];
                    }
                }
            }
        }
        return $services;
    }

    public function getlaneids_byservice($service_id, $order_id, $mainsource, $shift_id = "")
    {

        $ci             = &get_instance();
        $ci->load->database();
        $lanes          = [];
        $delivery_zcode = $pickup_zcode = $delivery_city = $pickup_city = $delivery_country = $pickup_country = "";
        if ($order_id != "") {
            $pickup_country = $delivery_country = "";
            $getdetails     = $ci->common->gettblrowdata(['id' => $order_id], "id,pickup_country,delivery_country,pickup_city,delivery_city,pickup_pincode,delivery_pincode,pickup_custid,pickup_partyid,drop_custid,drop_partyid,delivery_address2,pickup_address2", "tb_orders", 0, 0);
            if (! empty($getdetails)) {
                $pickup_country         = $getdetails['pickup_country'];
                $delivery_country       = $getdetails['delivery_country'];
                $pickup_city            = $getdetails['pickup_city'];
                $delivery_city          = $getdetails['delivery_city'];
                $pickup_zcode           = $getdetails['pickup_pincode'];
                $delivery_zcode         = $getdetails['delivery_pincode'];
                $pickup_state           = $getdetails['pickup_address2'];
                $delivery_state         = $getdetails['delivery_address2'];
                $pickup_sub_district    = '';
                $pickup_division_name   = '';
                $delivery_sub_district  = '';
                $delivery_division_name = '';
                $pwhr                   = " id = '" . $getdetails['pickup_custid'] . "' OR code = '" . $getdetails['pickup_custid'] . "' OR customeridentifier='" . $getdetails['pickup_custid'] . "' ";
                $getpickupsubdetails    = $ci->common->gettblrowdata($pwhr, "sub_district,division_name", "tbl_party_master", 0, 0);
                if (! empty($getpickupsubdetails)) {
                    $pickup_sub_district  = $getpickupsubdetails['sub_district'];
                    $pickup_division_name = $getpickupsubdetails['division_name'];
                }

                $dwhr              = " id = '" . $getdetails['drop_custid'] . "' OR code = '" . $getdetails['drop_custid'] . "' OR customeridentifier='" . $getdetails['drop_custid'] . "' ";
                $getdropsubdetails = $ci->common->gettblrowdata($dwhr, "sub_district,division_name", "tbl_party_master", 0, 0);
                if (! empty($getdropsubdetails)) {
                    $delivery_sub_district  = $getdropsubdetails['sub_district'];
                    $delivery_division_name = $getdropsubdetails['division_name'];
                }
            }
        } else if ($shift_id != "") {
            $pickup_country = $delivery_country = "";
            $query = $ci->db->select("id,pickup_country,delivery_country,pickup_city,delivery_city,pickup_pincode,delivery_pincode,pickup_custid,pickup_partyid,drop_custid,drop_partyid,delivery_address2,pickup_address2")
                ->from("tb_orders")
                ->where('shift_id', $shift_id)
                ->get();

            $gettripdetails = $query->result_array();
            $len = count($gettripdetails);
            if (!empty($gettripdetails)) {
                $pickup_country         = $gettripdetails[0]['pickup_country'];
                $delivery_country       = $gettripdetails[$len - 1]['delivery_country'];
                $pickup_city            = $gettripdetails[0]['pickup_city'];
                $delivery_city          = $gettripdetails[$len - 1]['delivery_city'];
                $pickup_zcode           = $gettripdetails[0]['pickup_pincode'];
                $delivery_zcode         = $gettripdetails[$len - 1]['delivery_pincode'];
                $pickup_state           = $gettripdetails[0]['pickup_address2'];
                $delivery_state         = $gettripdetails[$len - 1]['delivery_address2'];
                $pickup_sub_district    = '';
                $pickup_division_name   = '';
                $delivery_sub_district  = '';
                $delivery_division_name = '';


                $pwhr                   = " id = '" . $gettripdetails[0]['pickup_custid'] . "' OR code = '" . $gettripdetails[0]['pickup_custid'] . "' OR customeridentifier='" . $gettripdetails[0]['pickup_custid'] . "' ";
                $getpickupsubdetails    = $ci->common->gettblrowdata($pwhr, "sub_district,division_name", "tbl_party_master", 0, 0);
                if (! empty($getpickupsubdetails)) {
                    $pickup_sub_district  = $getpickupsubdetails['sub_district'];
                    $pickup_division_name = $getpickupsubdetails['division_name'];
                }

                $dwhr              = " id = '" . $gettripdetails[$len - 1]['drop_custid'] . "' OR code = '" . $gettripdetails[$len - 1]['drop_custid'] . "' OR customeridentifier='" . $gettripdetails[$len - 1]['drop_custid'] . "' ";
                $getdropsubdetails = $ci->common->gettblrowdata($dwhr, "sub_district,division_name", "tbl_party_master", 0, 0);
                if (! empty($getdropsubdetails)) {
                    $delivery_sub_district  = $getdropsubdetails['sub_district'];
                    $delivery_division_name = $getdropsubdetails['division_name'];
                }
            }
        } else {
            $pickup_country         = $mainsource['pickup_country'] ?? "";
            $delivery_country       = $mainsource['delivery_country'] ?? "";
            $pickup_city            = $mainsource['pickup_city'] ?? "";
            $delivery_city          = $mainsource['delivery_city'] ?? "";
            $pickup_zcode           = $mainsource['pickup_pincode'] ?? "";
            $delivery_zcode         = $mainsource['delivery_pincode'] ?? "";
            $pickup_sub_district    = '';
            $pickup_division_name   = '';
            $delivery_sub_district  = '';
            $delivery_division_name = '';
            $pickup_state           = '';
            $delivery_state         = '';
        }

        $source = [
            'pickup_country'         => $pickup_country,
            'delivery_country'       => $delivery_country,
            'pickup_city'            => $pickup_city,
            'delivery_city'          => $delivery_city,
            'pickup_zcode'           => $pickup_zcode,
            'delivery_zcode'         => $delivery_zcode,
            'pickup_sub_district'    => $pickup_sub_district,
            'pickup_division_name'   => $pickup_division_name,
            'delivery_sub_district'  => $delivery_sub_district,
            'delivery_division_name' => $delivery_division_name,
            'pickup_state'           => $pickup_state,
            'delivery_state'         => $delivery_state,
        ];
        $getlanes = $ci->Order->getlanes_byservice($source, $service_id);

        foreach ($getlanes as $eachLane) {
            $laneid    = $eachLane['lane_id'];
            $lane_name = $eachLane['lane_name'];
            $lane_id   = $laneid;
            if ($lane_name != "") {
                $lane_id = $laneid . "-" . $lane_name;
            } else {
                $lane_id = $laneid;
            }
            $lanes[] = ['lane_row_id' => $eachLane['id'], 'lane_id' => $lane_id];
        }
        if ($pickup_country == 'AUSTRALIA') {
            $getlanesby_range = $ci->Order->getlanes_byservicerange($service_id);
            if ($getlanesby_range->num_rows() > 0) {
                foreach ($getlanesby_range->result() as $res) {
                    $laneid    = $res->lane_id;
                    $lane_name = $res->lane_name;
                    $lane_id   = $laneid;
                    if ($lane_name != "") {
                        $lane_id = $laneid . "-" . $lane_name;
                    } else {
                        $lane_id = $laneid;
                    }
                    $lanes[] = ['lane_row_id' => $res->id, 'lane_id' => $lane_id];
                }
            }
        }

        return $lanes;

    }

    public function getoffering_bylane($lane_id, $type, $offering_type, $rate_service, $order_id, $shift_id = "")
    {
        $ci            = &get_instance();
        $offering      = [];
        $vendor_id     = $customer_id     = 0;
        $customer_code = $vendor_code = "";
        $table         = "tb_rate_offerings";
        $where         = ['lane_id' => $lane_id, 'offering_active' => '1', 'status' => '1', 'offering_type' => $offering_type, 'rate_service_id' => $rate_service];
        if ($type == '0') {
            $where = ['lane_id' => $lane_id, 'offering_active' => '1', 'tarrif_type' => 'SELL', 'status' => '1', 'offering_type' => $offering_type, 'rate_service_id' => $rate_service];
        } else if ($type == '1') {
            $where = ['lane_id' => $lane_id, 'offering_active' => '1', 'tarrif_type' => 'BUY', 'status' => '1', 'offering_type' => $offering_type, 'rate_service_id' => $rate_service];
        }
        $select      = "id,offering_id,offering_name,cust_profile_id,vendor_profile_id";
        $getoffering = $ci->common->gettbldata($where, $select, $table, 0, 0);
        if (! empty($getoffering)) {
            foreach ($getoffering as $res) {
                $offering_id       = $res['offering_id'];
                $offerings         = "";
                $cust_profile_id   = $res['cust_profile_id'];
                $vendor_profile_id = $res['vendor_profile_id'];
                if ($cust_profile_id == "") {
                    $cust_profile_id = 0;
                }
                if ($vendor_profile_id == "") {
                    $vendor_profile_id = 0;
                }
                if ($order_id != "") {
                    /* Check customer */
                    $getordercustid = $ci->common->gettblrowdata(['id' => $order_id, 'status!=' => 0], 'customer_id,vendor_id', "tb_orders", 0, 0);
                    if (! empty($getordercustid)) {
                        $customer_id = $getordercustid['customer_id'];
                        $vendor_id   = $getordercustid['vendor_id'];
                    }
                }
                if ($shift_id != "") {
                    /* Check customer */
                    $getordercustid = $ci->common->gettblrowdata(['shift_id' => $shift_id, 'status!=' => 0], 'customer_id,vendor_id', "tb_orders", 0, 0);
                    if (! empty($getordercustid)) {
                        $customer_id = $getordercustid['customer_id'];
                        $vendor_id   = $getordercustid['vendor_id'];
                    }
                }
                if ($type == 0) {
                    if ($customer_id > 0) {
                        $getcustomercode = $ci->common->gettblrowdata(['id' => $customer_id, 'status' => 1], 'code', "tb_customers", 0, 0);
                        if (! empty($getcustomercode)) {
                            $customer_code = $getcustomercode['code'];
                        }
                        if ($customer_code != "") {
                            $chkcust_profile = $ci->common->gettblrowdata(['cp_id' => $cust_profile_id, 'profile_id' => $customer_code, 'status' => 1], 'id', "tb_customer_profile_list", 0, 0);
                            if (! empty($chkcust_profile)) {
                                $offering_name = $res['offering_name'];
                                if ($offering_name != "") {
                                    $offerings = $offering_id . "-" . $offering_name;
                                } else {
                                    $offerings = $offering_id;
                                }
                            }
                        }
                    }
                } else if ($type == "1") {
                    if ($vendor_id > 0) {
                        $getvendorcode = $ci->common->gettblrowdata(['id' => $vendor_id, 'status' => 1], 'code', "tb_vendors", 0, 0);
                        if (! empty($getvendorcode)) {
                            $vendor_code = $getvendorcode['code'];
                        }
                        if ($vendor_code != "") {
                            $chkvendor_profile = $ci->common->gettblrowdata(['vp_id' => $vendor_profile_id, 'profile_id' => $vendor_code, 'status' => 1], 'id', "tb_vendor_profile_list", 0, 0);
                            if (! empty($chkvendor_profile)) {
                                $offering_name = $res['offering_name'];
                                if ($offering_name != "") {
                                    $offerings = $offering_id . "-" . $offering_name;
                                } else {
                                    $offerings = $offering_id;
                                }
                            }
                        }
                    }
                }
                if ($offerings != "") {
                    $offering[] = ['offering_row_id' => $res['id'], 'offering_id' => $offerings];
                }
            }
        }
        return $offering;
    }

    public function getrecord_byoffering($offering_id, $order_id, $shft_id = "")
    {
        $ci        = &get_instance();
        $ci->load->database();
        $record    = [];
        $table     = "tb_rate_records";
        $where     = ['offering_id' => $offering_id, 'status' => '1'];
        $select    = "id,rate_id,record_name";
        $getrecord = $ci->common->gettbldata($where, $select, $table, 0, 0);
        if ($order_id != "") {
            $getrecord = $ci->common->gettbldata($where, $select, $table, 0, 0);
            $ids = $ci->common->gettbldata(['id' => $order_id], "id", "tb_orders", 0, 0);
        } else if ($shft_id != "") {
            $getrecord = $ci->common->gettbldata($where, $select, $table, 0, 0);
            $ids = $ci->common->gettbldata(['shift_id' => $shft_id], "id", "tb_orders", 0, 0);
        } else {
            $ids = [$order_id];
        }
        if (! empty($getrecord)) {
            foreach ($getrecord as $res) {
                $recordname = $res['rate_id'] . "-" . $res['record_name'];
                foreach ($ids as $orderid) {
                    $refcheck   = $this->checkrefandorcondition($orderid, $res['id']);
                    if ($refcheck == 1) {
                        $record[] = ['record_row_id' => $res['id'], 'record_name' => $recordname];
                    }
                }
            }

        }
        return $record;
    }

    public function addrevchargesbyrecord($data, $user_id, $currency)
    {
        $ci               = &get_instance();
        $ci->load->database();
        $ins_id           = $exchange_rate           = 0;
        $cdate            = date('Y-m-d H:i:s');
        $type             = isset($data['type']) ? $data['type'] : "";
        $record           = isset($data['record']) ? $data['record'] : "";
        $rate_service     = isset($data['rate_service']) ? $data['rate_service'] : "";
        $early_pickup     = isset($data['early_pickup']) ? $data['early_pickup'] : "";
        $early_delivery   = isset($data['early_delivery']) ? $data['early_delivery'] : "";
        $code             = $total_amount             = 0;
        $shift_id = $data['shift_id'] ?? "";
        $order_id = $data['order_id'] ?? "";
        $foreign_currency = "";
        if ($type == '0') {
            $code = isset($data['customer_code']) ? $data['customer_code'] : "";
        } else {
            $code = isset($data['vendor_code']) ? $data['vendor_code'] : "";
        }
        if (isset($data['shift_id'])) {
            $oidquery = $ci->db->select('id')
                ->from('tb_orders')
                ->where('shift_id', $data['shift_id'])
                ->get();
            $oid = $oidquery->result();
            $order_id = $oid[0]->id;
        }
        //need to start loop for multiple orders
        else {
            $order_id = isset($data['order_id']) ? $data['order_id'] : 0;
        }
        $rate_offering     = isset($data['rate_offering']) ? $data['rate_offering'] : "";
        $lane_id           = isset($data['lane_id']) ? $data['lane_id'] : "";
        $charge_ar_country = $charge_ar_vas = $charge_ar = [];
        $lanecharges       = $this->getchargesthrouglaneid($lane_id, $order_id, $user_id, $early_pickup, $early_delivery);
        if ($order_id != "" && $order_id != "0") {
            $vascharges = $this->getchargesthrougvasbyrecord($rate_offering, $record, $order_id, $user_id, $type, $shift_id);
        }
        $offeringvascharges = $this->getchargesthrougvasbyoffering($rate_offering, $type, $order_id, $user_id, $shift_id);
        $getraterecord_id   = $ci->common->gettblrowdata(['id' => $record, 'status' => '1'], 'rate_id', "tb_rate_records", 0, 0);
        $record_id          = 1;
        if (! empty($getraterecord_id)) {
            $record_id = $getraterecord_id['rate_id'];
        }
        $lane_chargerow_id = "38";
        $lane_chargename   = "Freight Charges";
        if (! empty($lanecharges)) {
            $getcharge_forlane = $ci->common->gettblrowdata(['charge_code' => 'CAP', 'status' => '1'], 'id,name', "tb_charge_codes", 0, 0);
            if (! empty($getcharge_forlane)) {
                $lane_chargerow_id = $getcharge_forlane['id'];
                $lane_chargename   = $getcharge_forlane['name'];
            }
            $charge_ar_country = ['charge_code' => $lane_chargerow_id, 'description' => $lane_chargename, 'quantity_unit' => '1', 'value' => '1', 'rate_id' => $record_id, 'amount' => $lanecharges['abs_value'], 'rate_service_id' => $rate_service, 'rate_offering_id' => $rate_offering, 'rate_record_id' => $record, 'currency' => $lanecharges['currency'], 'user_id' => $user_id, 'createdon' => $cdate];
        }
        $charge_of_country = [];
        $offering_gid      = 1;
        if (! empty($offeringvascharges)) {
            foreach ($offeringvascharges as $res) {
                $getoffering_id = $ci->common->gettblrowdata(['id' => $rate_offering, 'status' => '1'], "offering_id", "tb_rate_offerings", 0, 0);
                if (! empty($getoffering_id)) {
                    $offering_gid = $getoffering_id['offering_id'];
                }
                $getcharge_forlane = $ci->common->gettblrowdata(['id' => $res['charge_id'], 'status' => '1'], 'id,name', "tb_charge_codes", 0, 0);
                if (! empty($getcharge_forlane)) {
                    $lane_chargerow_id = $getcharge_forlane['id'];
                    $lane_chargename   = $getcharge_forlane['name'];
                }
                $charge_of_country[] = ['charge_code' => $res['charge_id'], 'description' => $lane_chargename, 'quantity_unit' => '1', 'value' => '1', 'rate_id' => $offering_gid, 'amount' => $res['amount'], 'rate_service_id' => $rate_service, 'rate_offering_id' => $rate_offering, 'rate_record_id' => $record, 'currency' => $res['currency'], 'user_id' => $user_id, 'createdon' => $cdate, 'source_created' => 'AT - Apply Tariffs'];
            }
        }
        if (! empty($vascharges)) {
            foreach ($vascharges as $vas) {
                $vas_charge_id = $vas['charge_id'];
                if ($vas_charge_id != '0' && $vas_charge_id != "") {
                    $getcharge_forlane = $ci->common->gettblrowdata(['id' => $vas_charge_id, 'status' => '1'], 'id,name', "tb_charge_codes", 0, 0);
                    if (! empty($getcharge_forlane)) {
                        $lane_chargerow_id = $getcharge_forlane['id'];
                        $lane_chargename   = $getcharge_forlane['name'];
                    }
                } else {
                    $getcharge_forlane = $ci->common->gettblrowdata(['charge_code' => 'CSC', 'status' => '1'], 'id,name', "tb_charge_codes", 0, 0);
                    if (! empty($getcharge_forlane)) {
                        $lane_chargerow_id = $getcharge_forlane['id'];
                        $lane_chargename   = $getcharge_forlane['name'];
                    }
                }
                $charge_ar_vas[] = ['charge_code' => $lane_chargerow_id, 'description' => $lane_chargename, 'quantity_unit' => '1', 'value' => '1', 'rate_id' => $record_id, 'amount' => $vas['amount'], 'rate_service_id' => $rate_service, 'rate_offering_id' => $rate_offering, 'rate_record_id' => $record, 'currency' => $vas['currency'], 'user_id' => $user_id, 'createdon' => $cdate, 'source_created' => 'AT - Apply Tariffs'];
            }
        }
        $name = $role = "Customer";
        if ($type == '0') {
            $name = $role = "Customer";
        } else {
            $name = $role = "Carrier";
        }
        $companyCode = $ci->session->userdata('company_code');
        if ($code != "") {
            $getcode = $ci->common->gettblrowdata(['code' => $code, 'status' => '1', 'company_code' => $companyCode], "party_type_id,name,party_types", "tbl_party_master", 0, 0);
            if (! empty($getcode)) {
                $party_type_id = $getcode['party_type_id'];
                if ($type == '0') {
                    $party_type = "Customer";
                } else {
                    $party_type = "Carrier";
                }
                if ($party_type_id > 0) {
                    $gettbl_party = $ci->common->gettblrowdata(['id' => $party_type_id, 'name' => $party_type], "id", "tbl_party_types", 0, 0);
                    if (! empty($gettbl_party)) {
                        $name = $getcode['name'];
                    } else {
                        $getparty_types = $getcode['party_types'];
                        $party_types    = explode(',', $getparty_types);
                        if (is_array($party_types)) {
                            if (! empty($party_types)) {
                                $chkshipper = $ci->db->query("SELECT id FROM tbl_party_types WHERE id IN (" . implode(',', $party_types) . ") AND name LIKE '" . $party_type . "'");
                                if ($chkshipper->num_rows() > 0) {
                                    $name = $getcode['name'];
                                }
                            }
                        }
                    }
                }
            }
            $charge_ar        = $this->getraterecordcharges($rate_offering, $record, $type, $order_id, $record_id, $user_id);
            $invoice_status   = 0;
            $debtor_jfr       = $invoice_number       = $credit_note_number       = "";
            $invoice_date     = '0000-00-00 00:00:00';
            $inv_createddate  = '0000-00-00 00:00:00';
            $inv_receiveddate = '0000-00-00 00:00:00';
            $currency         = '';
            if (! empty($charge_ar)) {
                foreach ($charge_ar as $eachLine) {
                    if ($eachLine['exchange_amount'] > 0) {
                        $exchange_rate = $eachLine['exchange_amount'];
                    }
                }
                $foreign_currency = isset($charge_ar[0]['foreign_currency']) ? $charge_ar[0]['foreign_currency'] : "";
                $currency         = isset($charge_ar[0]['currency']) ? $charge_ar[0]['currency'] : "";
                for ($c = 0; $c < count($charge_ar); $c++) {
                    unset($charge_ar[$c]['foreign_currency']);
                    unset($charge_ar[$c]['exchange_amount']);
                    $charge_ar[$c]['rate_service_id']  = $rate_service;
                    $charge_ar[$c]['rate_offering_id'] = $rate_offering;
                    $charge_ar[$c]['rate_record_id']   = $record;
                    $charge_ar[$c]['source_created']   = "AT - Apply Tariffs";
                }
            }
            $company_code = $ci->session->userdata('company_code');
            if ($company_code == 'PLKN') {
                $exchange_rate = '4.4633199434';
            }
            $revenue_ar         = ['type' => $type, 'recipient_role' => $role, 'recipient_code' => $code, 'recipient_name' => $name, 'debtor_jfr' => $debtor_jfr, 'invoice_number' => $invoice_number, 'credit_note_number' => $credit_note_number, 'invoice_date' => $invoice_date, 'invoice_creation_date' => $inv_createddate, 'invoice_receivdon_date' => $inv_receiveddate, 'amount' => '0', 'currency' => $currency, 'status' => 1, 'user_id' => $user_id, 'createdon' => $cdate, 'exchange_rate' => $exchange_rate, 'invoice_status' => $invoice_status, 'foreign_currency' => $foreign_currency];
            if (!empty($shift_id)) {
                $revenue_ar['shift_id'] = $shift_id;
            } else {
                $revenue_ar['order_id'] = $order_id;
            }
            $ins_id             = $this->insertrecords($revenue_ar, $charge_ar, $charge_ar_country, $charge_ar_vas, $charge_of_country,$order_id,$shift_id);
            $orderCreatedSource = $data['orderCreatedSource'] ?? 0;
            if ($orderCreatedSource > 0) {
                $ci->common->updatetbledata("tb_orders", ['created_source' => $orderCreatedSource], ['id' => $order_id]);
            }

            if ($record > 0 && $ins_id > 0) {
                $addfaf = $this->addfafcharges_toorder($order_id, $ins_id, $record, 'AT - Apply Tariffs', $shift_id);
            }

        }
        return $ins_id;
    }

    public function getchargesthrougvasbyoffering($offering, $type, $order_id, $user_id, $shift_id = "")
    {
        $ci        = &get_instance();
        $charges   = [];
        $unit2     = 1;
        $distance_param = ['KM', 'PER KM'];
        $duartion_param = ['waiting Time(Hrs)'];
        $charge_basis_values = ['PER KG', 'KG', 'PER CBM', 'CBM', 'PER LDM', 'LDM', 'PIECE COUNT', 'PER PIECE', 'GOODS VALUE'];
        $total_ldm = $second_volume = $second_weight = $total_weight = $total_volume = 0;
        if ($offering != "0" && $offering != "") {
            $getcharges = $ci->common->gettbldata(['rateoffering_id' => $offering, 'status' => '1'], "ro_charge_id,charge_basis,min_amount,amount,currency", "tb_rateoffering_services", 0, 0);
            $getorderdetails = $ci->Orderrevenuesmodel->getallordercargodetails($order_id);
            $Coords = $shift_id != "" ? $ci->RateManagementModel->getStopsLatLangByShiftId($shift_id) : [];
            $stops = [];
            $data = [];
            if (count($Coords) > 0) {
                foreach ($Coords as $coord) {
                    $stops[] = ['lat' => $coord['slat'], 'lng' => $coord['slng']];
                    $stops[] = ['lat' => $coord['elat'], 'lng' => $coord['elng']];
                }
                $uniqueStops = [];
                foreach ($stops as $stop) {
                    $key = $stop['lat'] . ',' . $stop['lng'];
                    $uniqueStops[$key] = $stop;
                }
                $stops = array_values($uniqueStops);
                if (count($stops) > 2) {
                    $data = getDistanceAndDurationWithMultipleStops($stops);
                } else if (count($stops) > 0 and count($stops) == 2) {
                    $data = getDistanceAndDurationTwoPoints($stops[0], $stops[1]);
                }
            }
            if (! empty($getcharges)) {
                foreach ($getcharges as $res) {
                    $final_amount = 0;
                    $charge_id    = $res['ro_charge_id'];
                    $amount       = $res['amount'];
                    $charge_basis = strtoupper($res['charge_basis']);
                    $min_amount   = $res['min_amount'];
                    $applycost = max($amount, $min_amount);
                    $currency     = $res['currency'];
                    $final_amount = $amount;
                    if ($order_id != "" && $order_id != "0") {
                        if (in_array($charge_basis, $charge_basis_values)) {
                            $unit_ar = $this->claculateperkgamount($offering, $order_id, $user_id, $type, $amount, $charge_basis, 'non-vas');
                            if (! empty($unit_ar)) {
                                $final_conversion = isset($unit_ar['final_conversion']) ? $unit_ar['final_conversion'] : '0';
                                /*  $unit_result = isset($unit_ar['result']) ? $unit_ar['result'] :  '0';*/
                                if ($final_conversion > 0) {
                                    $unit2 = $final_conversion;
                                } else {

                                    if (! empty($getorderdetails)) {
                                        if ($charge_basis == 'PER KG' || $charge_basis == 'KG') {
                                            $unit2 = $getorderdetails['total_weight'];
                                        } else if ($charge_basis == 'PER LDM' || $charge_basis == 'LDM') {
                                            $unit2 = $getorderdetails['total_ldm'];
                                        } else if ($charge_basis == 'PER CBM' || $charge_basis == 'CBM') {
                                            $unit2 = $getorderdetails['total_volume'];
                                        } else if ($charge_basis == 'PER PIECE') {
                                            $unit2 = $getorderdetails['total_quantity'];
                                        } else if ($charge_basis == 'GOODS VALUE') {
                                            $unit2 = $getorderdetails['goods_value'];
                                        }
                                    }
                                }
                            } else {
                                if (! empty($getorderdetails)) {
                                    if ($charge_basis == 'PER KG' || $charge_basis == 'KG') {
                                        $unit2 = $getorderdetails['total_weight'];
                                    } else if ($charge_basis == 'PER LDM' || $charge_basis == 'LDM') {
                                        $unit2 = $getorderdetails['total_ldm'];
                                    } else if ($charge_basis == 'PER CBM' || $charge_basis == 'CBM') {
                                        $unit2 = $getorderdetails['total_volume'];
                                    } else if ($charge_basis == 'PER PIECE') {
                                        $unit2 = $getorderdetails['total_quantity'];
                                    } else if ($charge_basis == 'GOODS VALUE') {
                                        $unit2 = $getorderdetails['goods_value'];
                                    }
                                }
                            }
                            $final_amount = $unit2 * $amount;
                        } else if (in_array(strtoupper($charge_basis), $distance_param)) {
                            $final_amount = $data['totalDistanceKm'] * $applycost;
                        } 
                        else if($charge_basis=="PER MILE"){
                            $final_amount=$data['totalDistanceKm'] * 0.621371 * $applycost;
                        }
                        elseif (in_array($charge_basis, $duartion_param)) {
                            $final_amount = $data['totalDurationHours'] * $applycost;
                        }
                    }
                    if ($final_amount < $min_amount) {
                        $final_amount = $min_amount;
                    }
                    $charges[] = ['amount' => $final_amount, 'currency' => $currency, 'charge_id' => $charge_id];
                }
            }
        }
        return $charges;
    }

    public function claculateperkgamount($offering, $order_id, $user_id, $type, $amount, $charge_basis, $vastype)
    {

        $ci               = &get_instance();
        $final_amount     = 0;
        $conversion_id    = 0;
        $final_conversion = $result = 0;
        if ($offering > 0) {
            $getconversion_id = $ci->common->gettblrowdata(['id' => $offering, 'status' => '1'], "uom_conversion_id", "tb_rate_offerings", 0, 0);
            if (! empty($getconversion_id)) {
                $conversion_id = $getconversion_id['uom_conversion_id'];
            }
        }
        $chktype = "SELL";
        if ($type == '1') {
            $chktype = 'BUY';
        } else {
            $chktype = 'SELL';
        }
        $country_code = $company_code = "";
        if ($conversion_id != '0' && $conversion_id != "") {
            $get_country = $ci->db->select('country_code,company_code')->get_where("tb_users", ['id' => $user_id]);
            if ($get_country->num_rows() > 0) {
                $country_code = $get_country->row()->country_code;
                $company_code = $get_country->row()->company_code;
            }
            $base_uom = $charge_basis;
            if ($charge_basis == 'PER KG' || $charge_basis == 'KG') {
                $base_uom = 'KG';
            } else if ($charge_basis == 'PER CBM' || $charge_basis == 'CBM') {
                $base_uom = 'CBM';
            } else if ($charge_basis == 'PER LDM' || $charge_basis == 'LDM') {
                $base_uom = 'LDM';
            }
            $getchargeable_weight = $ci->common->gettblrowdata(['id' => $conversion_id, 'country' => $country_code, 'type' => $chktype, 'base_uom' => $base_uom, 'status' => '1'], "uom_type1,uom1,uom1_conversion,uom_type2,uom2,uom2_conversion,uom_type3,uom3,uom3_conversion,uom_type4,uom4,uom4_conversion,customer_id,carrier_id", "tb_knuom_conversion", 0, 0);
            if (! empty($getchargeable_weight)) {
                $sts         = 0;
                $customer_id = $getchargeable_weight['customer_id'];
                $carrier_id  = $getchargeable_weight['carrier_id'];
                if ($type == '1') {
                    if ($carrier_id != "0" && $carrier_id != "") {
                        $chkordertrip = $ci->common->gettblrowdata(['id' => $order_id, 'shift_id >' => '0'], "vendor_id", "tb_orders", 0, 0);
                        if (! empty($chkordertrip)) {
                            $vendor_id = $chkordertrip['vendor_id'];
                            if ($vendor_id > 0) {
                                if ($carrier_id == $vendor_id) {
                                    $sts = 1;
                                } else {
                                    $sts = 0;
                                }
                            }
                        } else {
                            $sts = 1;
                        }
                    } else {
                        $sts = 1;
                    }
                } else {
                    if ($customer_id != "0" && $customer_id != "") {
                        $chkordercustomer = $ci->common->gettblrowdata(['id' => $order_id], "customer_id", "tb_orders", 0, 0);
                        if (! empty($chkordercustomer)) {
                            $order_customer_id = $chkordercustomer['customer_id'];
                            if ($order_customer_id == $customer_id) {
                                $sts = 1;
                            } else {
                                $sts = 0;
                            }
                        }
                    } else {
                        $sts = 1;
                    }
                }
                $total_conversion1 = $total_conversion2 = $total_conversion3 = $total_conversion4 = ['sts' => '0', 'total_amount' => '1'];
                if ($sts == '1') {
                    $uom1 = $getchargeable_weight['uom1'];
                    if ($uom1 != "") {
                        $uom1_conversion   = $getchargeable_weight['uom1_conversion'];
                        $uom_type1         = $getchargeable_weight['uom_type1'];
                        $total_conversion1 = $this->getconversionableamount($uom1, $uom_type1, $uom1_conversion, $order_id);
                    }
                    $uom2 = $getchargeable_weight['uom2'];
                    if ($uom2 != "") {
                        $uom2_conversion   = $getchargeable_weight['uom2_conversion'];
                        $uom_type2         = $getchargeable_weight['uom_type2'];
                        $total_conversion2 = $this->getconversionableamount($uom2, $uom_type2, $uom2_conversion, $order_id);
                    }
                    $uom3 = $getchargeable_weight['uom3'];
                    if ($uom3 != "") {
                        $uom3_conversion   = $getchargeable_weight['uom3_conversion'];
                        $uom_type3         = $getchargeable_weight['uom_type3'];
                        $total_conversion3 = $this->getconversionableamount($uom3, $uom_type3, $uom3_conversion, $order_id);
                    }
                    $uom4 = $getchargeable_weight['uom4'];
                    if ($uom4 != "") {
                        $uom4_conversion   = $getchargeable_weight['uom4_conversion'];
                        $uom_type4         = $getchargeable_weight['uom_type4'];
                        $total_conversion4 = $this->getconversionableamount($uom4, $uom_type4, $uom4_conversion, $order_id);
                    }
                    $final_conversion1 = $final_conversion2 = $final_conversion3 = $final_conversion4 = "0";
                    if ($total_conversion1['sts'] == '1') {
                        $final_conversion1 = $total_conversion1['total_amount'];
                    }
                    if ($total_conversion2['sts'] == '1') {
                        $final_conversion2 = $total_conversion2['total_amount'];
                    }
                    if ($total_conversion3['sts'] == '1') {
                        $final_conversion3 = $total_conversion3['total_amount'];
                    }
                    if ($total_conversion4['sts'] == '1') {
                        $final_conversion4 = $total_conversion4['total_amount'];
                    }
                    $result           = 1;
                    $final_conversion = max($final_conversion1, $final_conversion2, $final_conversion3, $final_conversion4);
                } else {
                    $final_conversion = 0;
                    $result           = 0;
                }
            } else {
                $final_conversion = 0;
                $result           = 0;
            }
        } else {
            $final_conversion = 0;
            $result           = 1;
        }

        $res = ['final_conversion' => $final_conversion, 'result' => $result];
        return $res;
    }

    public function getconversionableamount($uom1, $uom_type1, $conversion1, $order_id)
    {
        $ci           = &get_instance();
        $total_amount = 0;
        $res          = ['sts' => '0', 'total_amount' => $total_amount];
        if ($uom1 != "") {
            if (strtoupper($uom_type1) == 'ACTUAL WEIGHT') {
                $chkorderweight = $ci->db->query("SELECT c.id FROM tb_cargo_details c,tb_order_cargodetails o WHERE c.id =o.cargo_id AND c.weight_unit NOT LIKE '" . $uom1 . "' AND o.order_id='" . $order_id . "' AND o.status ='1'");
                if ($chkorderweight->num_rows() == 0) {
                    $gettotalweight = $ci->db->query("SELECT sum(weight) as weight FROM tb_order_cargodetails WHERE order_id ='" . $order_id . "' AND status ='1'");
                    if ($gettotalweight->num_rows() > 0) {
                        $total_weight = $gettotalweight->row()->weight;
                        $total_amount = $total_weight * $conversion1;
                        $res          = ['sts' => '1', 'total_amount' => $total_amount];
                    }
                }
            }
            if (strtoupper($uom_type1) == 'WEIGHT') {
                $chkorderweight = $ci->db->query("SELECT c.id FROM tb_cargo_details c,tb_order_cargodetails o WHERE c.id =o.cargo_id AND c.secondweight_uom NOT LIKE '" . $uom1 . "' AND o.order_id='" . $order_id . "' AND o.status ='1'");
                if ($chkorderweight->num_rows() == 0) {
                    $gettotalweight = $ci->db->query("SELECT sum(second_weight) as weight FROM tb_order_cargodetails WHERE order_id ='" . $order_id . "' AND status ='1'");
                    if ($gettotalweight->num_rows() > 0) {
                        $total_weight = $gettotalweight->row()->weight;
                        $total_amount = $total_weight * $conversion1;
                        $res          = ['sts' => '1', 'total_amount' => $total_amount];
                    }
                }
            }
            if (strtoupper($uom_type1) == 'ACTUAL VOLUME') {
                $chkordervolume = $ci->db->query("SELECT c.id FROM tb_cargo_details c,tb_order_cargodetails o WHERE c.id =o.cargo_id AND c.volume_unit NOT LIKE '" . $uom1 . "' AND o.order_id='" . $order_id . "' AND o.status ='1'");
                if ($chkordervolume->num_rows() == 0) {
                    $gettotalvolume = $ci->db->query("SELECT sum(volume) as volume FROM tb_order_cargodetails WHERE order_id ='" . $order_id . "' AND status ='1'");
                    if ($gettotalvolume->num_rows() > 0) {
                        $total_volume = $gettotalvolume->row()->volume;
                        $total_amount = $total_volume * $conversion1;
                        $res          = ['sts' => '1', 'total_amount' => $total_amount];
                    }
                }
            }
            if (strtoupper($uom_type1) == 'VOLUME') {
                $chkordervolume = $ci->db->query("SELECT c.id FROM tb_cargo_details c,tb_order_cargodetails o WHERE c.id =o.cargo_id AND c.secondvolume_uom NOT LIKE '" . $uom1 . "' AND o.order_id='" . $order_id . "' AND o.status ='1'");
                if ($chkordervolume->num_rows() == 0) {
                    $gettotalvolume = $ci->db->query("SELECT sum(second_volume) as volume FROM tb_order_cargodetails WHERE order_id ='" . $order_id . "' AND status ='1'");
                    if ($gettotalvolume->num_rows() > 0) {
                        $total_volume = $gettotalvolume->row()->volume;
                        $total_amount = $total_volume * $conversion1;
                        $res          = ['sts' => '1', 'total_amount' => $total_amount];
                    }
                }
            }
            if (strtoupper($uom_type1) == 'VOLUMETRIC WEIGHT') {
                $chkordervolume = $ci->db->query("SELECT c.id FROM tb_cargo_details c,tb_order_cargodetails o WHERE c.id =o.cargo_id AND c.volweight_uom NOT LIKE '" . $uom1 . "' AND o.order_id='" . $order_id . "' AND o.status ='1'");
                if ($chkordervolume->num_rows() == 0) {
                    $gettotalvolume = $ci->db->query("SELECT sum(volumetric_weight) as volume FROM tb_order_cargodetails WHERE order_id ='" . $order_id . "' AND status ='1'");
                    if ($gettotalvolume->num_rows() > 0) {
                        $total_vvolume = $gettotalvolume->row()->volume;
                        $total_amount  = $total_vvolume * $conversion1;
                        $res           = ['sts' => '1', 'total_amount' => $total_amount];
                    }
                }
            }
            if (strtoupper($uom_type1) == 'LDM') {
                $gettotalldm = $ci->db->query("SELECT sum(ldm) as ldm FROM tb_order_cargodetails WHERE order_id ='" . $order_id . "' AND status ='1'");
                if ($gettotalldm->num_rows() > 0) {
                    $total_ldm    = $gettotalldm->row()->ldm;
                    $total_amount = $total_ldm * $conversion1;
                    $res          = ['sts' => '1', 'total_amount' => $total_amount];
                }
            }
            if (strtoupper($uom_type1) == 'QUANTITY') {
                $gettotalldm = $ci->db->query("SELECT sum(quantity) as quantity FROM tb_order_cargodetails WHERE order_id ='" . $order_id . "' AND status ='1'");
                if ($gettotalldm->num_rows() > 0) {
                    $total_quantity = $gettotalldm->row()->quantity;
                    $total_amount   = $total_quantity * $conversion1;
                    $res            = ['sts' => '1', 'total_amount' => $total_amount];
                }
            }
        }
        return $res;
    }

    /*public function getchargesthrougvasbyrecord($rate_offering, $record, $order_id, $user_id, $type)
    {
        $ci      = &get_instance();
        $amount  = $final_conversion  = 0;
        $charges = [];
        if ($record != '0' && $record != "") {
            $getvas_ids = $ci->common->gettbldata(['raterecord_id' => $record, 'status' => '1'], "raterecord_vas_id,raterecord_charge_id,charge_basis,min_amount,amount,currency", "tb_raterecord_services", 0, 0);
            if (! empty($getvas_ids)) {
                foreach ($getvas_ids as $res) {
                    $final_amount = 0;
                    $vas_id       = $res['raterecord_vas_id'];
                    $charge_basis = strtoupper($res['charge_basis']);
                    $recamount    = $res['amount'];
                    $min_amount   = $res['min_amount'];
                    $currency     = $res['currency'];
                    $charge_id    = $res['raterecord_charge_id'];
                    $vas_quantity = 0;
                    $chk_order    = $ci->common->gettblrowdata(['order_id' => $order_id, 'vas_id' => $vas_id, 'status' => '1'], "quantity", "tb_order_vas", 0, 0);
                    if (! empty($chk_order)) {
                        $vas_quantity = $chk_order['quantity'];
                        if ($vas_quantity != '0') {

                            if ($charge_basis == 'PER KG' || $charge_basis == 'KG' || $charge_basis == 'PER CBM' || $charge_basis == 'CBM' || $charge_basis == 'PER LDM' || $charge_basis == 'LDM' || $charge_basis == 'PIECE COUNT' || $charge_basis == 'PER PIECE' || $charge_basis == 'GOODS VALUE') {
                                $amount_ar = $this->claculateperkgamount($rate_offering, $order_id, $user_id, $type, $recamount, $charge_basis, 'vas');
                                if (! empty($amount_ar)) {
                                    $final_conversion = isset($amount_ar['final_conversion']) ? $amount_ar['final_conversion'] : '0';
                                    $amount_result    = isset($amount_ar['result']) ? $amount_ar['result'] : '0';
                                }
                                if ($final_conversion > 0) {
                                    $amount = $final_conversion * $recamount;
                                } else {
                                    $total_volume    = $total_weight    = $total_ldm    = $total_quantity    = 0;
                                    $getorderdetails = $ci->Orderrevenuesmodel->getallordercargodetails($order_id);
                                    if (! empty($getorderdetails)) {
                                        $total_ldm         = $getorderdetails['total_ldm'];
                                        $total_weight      = $getorderdetails['total_weight'];
                                        $total_volume      = $getorderdetails['total_volume'];
                                        $total_quantity    = $getorderdetails['total_quantity'];
                                        $order_goods_value = $getorderdetails['goods_value'];
                                    }
                                    if ($charge_basis == 'PER KG' || $charge_basis == 'KG') {
                                        $amount = $total_weight * $recamount;
                                    } else if ($charge_basis == 'PER CBM' || $charge_basis == 'CBM') {
                                        $amount = $total_volume * $recamount;
                                    } else if ($charge_basis == 'PER LDM' || $charge_basis == 'LDM') {
                                        $amount = $total_ldm * $recamount;
                                    } else if ($charge_basis == 'PER PIECE') {
                                        $amount = $total_quantity * $recamount;
                                    } else if ($charge_basis == 'GOODS VALUE') {
                                        $amount = $order_goods_value * $recamount;
                                    }
                                }

                                if ($amount > 0) {
                                    $amount = $amount;
                                } else {
                                    $amount = ($vas_quantity * $recamount);
                                }
                            } else if ($charge_basis == 'PER TRIP' || $charge_basis == 'TRIP') {
                                $amount = ($vas_quantity * $recamount);
                            } else {
                                $amount = $recamount;
                            }
                            if ($min_amount > $amount) {
                                $amount = $min_amount;
                            }
                            $final_amount += $amount;
                            $charges[] = ['amount' => $final_amount, 'currency' => $currency, 'charge_id' => $charge_id];
                        }
                    }

                }
            }
        }
        return $charges;
    }*/
    
    public function getchargesthrougvasbyrecord($rate_offering, $record, $order_id, $user_id, $type, $shift_id = "")
    {
        $ci      = &get_instance();
        $amount  = $final_conversion  = 0;
        $charges = [];
        $distance_param = ['KM', 'PER KM'];
        $duartion_param = ['waiting Time(Hrs)'];
        $charge_basis_values = ['PER KG', 'KG', 'PER CBM', 'CBM', 'PER LDM', 'LDM', 'PIECE COUNT', 'PER PIECE', 'GOODS VALUE'];

        if ($record != '0' && $record != "") {
            $getvas_ids = $ci->common->gettbldata(['raterecord_id' => $record, 'status' => '1'], "raterecord_vas_id,raterecord_charge_id,charge_basis,min_amount,amount,currency", "tb_raterecord_services", 0, 0);
            //log_message('error', 'vas_ids' . print_r($getvas_ids, true));
            $getorderdetails = $ci->Orderrevenuesmodel->getallordercargodetails($order_id);
            
            $Coords = $shift_id != "" ? $ci->RateManagementModel->getStopsLatLangByShiftId($shift_id) : [];
            $stops = [];
            $data = [];
            if (count($Coords) > 0) {
                foreach ($Coords as $coord) {
                    $stops[] = ['lat' => $coord['slat'], 'lng' => $coord['slng']];
                    $stops[] = ['lat' => $coord['elat'], 'lng' => $coord['elng']];
                }
                $uniqueStops = [];
                foreach ($stops as $stop) {
                    $key = $stop['lat'] . ',' . $stop['lng'];
                    $uniqueStops[$key] = $stop;
                }
                $stops = array_values($uniqueStops);
                if (count($stops) > 2) {
                    $data = getDistanceAndDurationWithMultipleStops($stops);
                } else if (count($stops) > 0 and count($stops) == 2) {
                    $data = getDistanceAndDurationTwoPoints($stops[0], $stops[1]);
                }
            }
            $basis_map = [
                // Weight based
                'PER KG'      => function ($total_weight, $recamount) {
                    return $total_weight * $recamount;
                },
                'KG'          => function ($total_weight, $recamount) {
                    return $total_weight * $recamount;
                },

                // Volume based
                'PER CBM'     => function ($total_volume, $recamount) {
                    return $total_volume * $recamount;
                },
                'CBM'         => function ($total_volume, $recamount) {
                    return $total_volume * $recamount;
                },

                // Length based
                'PER LDM'     => function ($total_ldm, $recamount) {
                    return $total_ldm * $recamount;
                },
                'LDM'         => function ($total_ldm, $recamount) {
                    return $total_ldm * $recamount;
                },

                // Quantity based
                'PER PIECE'   => function ($total_quantity, $recamount) {
                    return $total_quantity * $recamount;
                },

                // Goods value
                'GOODS VALUE' => function ($order_goods_value, $recamount) {
                    return $order_goods_value * $recamount;
                },

                // Distance based
                'KM'          => function ($data, $applycost) {
                    return $data['totalDistanceKm'] * $applycost;
                },
                'PER KM'      => function ($data, $applycost) {
                    return $data['totalDistanceKm'] * $applycost;
                },
                'PER MILE'    => function ($data, $applycost) {
                    return $data['totalDistanceKm'] * 0.621371 * $applycost;
                },

                // Duration based
                'waiting Time(Hrs)' => function ($data, $applycost) {
                    return $data['totalDurationHours'] * $applycost;
                },

                // Trip based
                'PER TRIP'    => function ($vas_quantity, $recamount) {
                    return $vas_quantity * $recamount;
                },
                'TRIP'        => function ($vas_quantity, $recamount) {
                    return $vas_quantity * $recamount;
                },
            ];

            if (! empty($getvas_ids)) {
                foreach ($getvas_ids as $res) {
                    $final_amount = 0;
                    $vas_id       = $res['raterecord_vas_id'];
                    $charge_basis = strtoupper($res['charge_basis']);
                    $recamount    = $res['amount'];
                    $min_amount   = $res['min_amount'];
                    $applycost = max($recamount, $min_amount);
                    $currency     = $res['currency'];
                    $charge_id    = $res['raterecord_charge_id'];
                    $vas_quantity = 0;
                    $total_volume    = $total_weight    = $total_ldm    = $total_quantity = $order_goods_value  = 0;
                    $chk_order    = $ci->common->gettblrowdata(['order_id' => $order_id, 'vas_id' => $vas_id, 'status' => '1'], "quantity", "tb_order_vas", 0, 0);
                    //log_message('error', 'vas_ids' . print_r($chk_order, true));

                    if (! empty($chk_order)) {
                        $vas_quantity = $chk_order['quantity'];
                        if ($vas_quantity != '0') {
                            if (in_array($charge_basis, $charge_basis_values)) {
                                $amount_ar = $this->claculateperkgamount($rate_offering, $order_id, $user_id, $type, $recamount, $charge_basis, 'vas');
                                if (! empty($amount_ar)) {
                                    $final_conversion = isset($amount_ar['final_conversion']) ? $amount_ar['final_conversion'] : '0';
                                    $amount_result    = isset($amount_ar['result']) ? $amount_ar['result'] : '0';
                                }
                                if ($final_conversion > 0) {
                                    $amount = $final_conversion * $recamount;
                                } else {
                                    if (! empty($getorderdetails)) {
                                        $total_ldm         = $getorderdetails['total_ldm'];
                                        $total_weight      = $getorderdetails['total_weight'];
                                        $total_volume      = $getorderdetails['total_volume'];
                                        $total_quantity    = $getorderdetails['total_quantity'];
                                        $order_goods_value = $getorderdetails['goods_value'];
                                    }

                                    if (isset($basis_map[$charge_basis])) {
                                        switch ($charge_basis) {
                                            case 'PER KG':
                                            case 'KG':
                                                $amount = $basis_map[$charge_basis]($total_weight, $recamount);
                                                break;

                                            case 'PER CBM':
                                            case 'CBM':
                                                $amount = $basis_map[$charge_basis]($total_volume, $recamount);
                                                break;

                                            case 'PER LDM':
                                            case 'LDM':
                                                $amount = $basis_map[$charge_basis]($total_ldm, $recamount);
                                                break;

                                            case 'PER PIECE':
                                                $amount = $basis_map[$charge_basis]($total_quantity, $recamount);
                                                break;

                                            case 'GOODS VALUE':
                                                $amount = $basis_map[$charge_basis]($order_goods_value, $recamount);
                                                break;
                                        }
                                    }
                                }
                                if ($amount > 0) {
                                    $amount = $amount;
                                } else {
                                    $amount = ($vas_quantity * $recamount);
                                }
                            } else if ($charge_basis == 'PER TRIP' || $charge_basis == 'TRIP') {
                                $amount = $basis_map[$charge_basis]($vas_quantity, $recamount);
                            } else if (in_array(strtoupper($charge_basis), $distance_param)) {
                                $amount = $basis_map[$charge_basis]($data, $applycost);
                            } elseif (in_array($charge_basis, $duartion_param)) {
                                $amount = $basis_map[$charge_basis]($data, $applycost);
                            } else {
                                $amount = $recamount;
                            }
                            if ($min_amount > $amount) {
                                $amount = $min_amount;
                            }
                            $final_amount += $amount;
                            $charges[] = ['amount' => $final_amount, 'currency' => $currency, 'charge_id' => $charge_id];
//log_message('error', 'charge added' . print_r($charges, true));
                        }
                    }
                }
            }
        }
        return $charges;
    }


    public function getchargesthrouglaneid($lane_id, $order_id, $user_id, $pickup, $delivery)
    {

        $ci              = &get_instance();
        $charges         = [];
        $calendar_row_id = 0;
        $company_code    = $ci->session->userdata('company_code');
        if ($lane_id != '0' && $lane_id != "") {
            if ($company_code == "RUKN") {
                $getcalid = $ci->common->gettblrowdata(['lane_id' => $lane_id, 'status' => '1'], "calendar_id", "tb_rateservice_lanes", 0, 0);
            } else {
                $getcalid = $ci->common->gettblrowdata(['lane_id' => $lane_id, 'status' => '1', 'user_id' => $user_id], "calendar_id", "tb_rateservice_lanes", 0, 0);
            }
            if (! empty($getcalid)) {
                $calendar_row_id = $getcalid['calendar_id'];
            }
        }
        $pickup_date = $delivery_date = date('Y-m-d H:i:s');
        if ($order_id != "" && $order_id != '0') {
            $getpickupdate = $ci->common->gettblrowdata(['id' => $order_id], "pickup_datetime,delivery_datetime", "tb_orders", 0, 0);
            if (! empty($getpickupdate)) {
                $pickup_date   = date('Y-m-d H:i:s', strtotime($getpickupdate['pickup_datetime']));
                $delivery_date = date('Y-m-d H:i:s', strtotime($getpickupdate['delivery_datetime']));
            }
        } else {
            $pickup_date   = $pickup;
            $delivery_date = $delivery;
        }

        if ($calendar_row_id != '0') {
            $getcal_data = $ci->common->gettblrowdata(['id' => $calendar_row_id, 'status' => '1'], "calendar_id,bill_type,apply_type", "tb_calendar_data", 0, 0);
            if (! empty($getcal_data)) {
                $bill_type  = $getcal_data['bill_type'];
                $apply_type = $getcal_data['apply_type'];
                if ($bill_type == "1") { //BOTH
                    $charges = $this->checkamountforbothtypes($calendar_row_id, $pickup_date, $delivery_date, $apply_type);
                } else if ($bill_type == "2") { //DAY CALCULATIONS
                    $charges = $this->checkamountfordaycalculations($calendar_row_id, $pickup_date, $delivery_date);
                } else if ($bill_type == '3') { //HOLIDAY
                    $charges = $this->checkamountforholidays($calendar_row_id, $pickup_date, $delivery_date);
                }
            }
        }
        return $charges;
    }

    public function checkamountforbothtypes($cal_id, $pickup, $delivery, $applytype)
    {
        $holidays       = $this->checkamountforholidays($cal_id, $pickup, $delivery);
        $normal_days    = $this->checkamountfordaycalculations($cal_id, $pickup, $delivery);
        $holiday_amount = isset($holidays['abs_value']) ? round($holidays['abs_value']) : '0';

        $normal_amount = isset($normal_days['abs_value']) ? round($normal_days['abs_value']) : '0';
        $lesstype      = $moretype      = "";
        if ($holiday_amount > $normal_amount) {
            $lesstype = 'n';
            $moretype = 'h';
        } else {
            $lesstype = 'h';
            $moretype = 'n';
        }
        if ($applytype == '1') { // LOWEST
            if ($lesstype != "") {
                if ($lesstype == 'h') {
                    return $holidays;
                } else {
                    return $normal_days;
                }
            }
        } else {
            if ($moretype != "") {
                if ($moretype == 'h') {
                    return $holidays;
                } else {
                    return $normal_days;
                }
            }
        }
    }

    public function checkamountfordaycalculations($cal_id, $pickup, $delivery)
    {
        $result      = [];
        $ci          = &get_instance();
        $time        = date('H:i', strtotime($pickup));
        $day         = strtoupper(date('l', strtotime($pickup)));
        $dday        = strtoupper(date('l', strtotime($delivery)));
        $dtime       = date('H:i', strtotime($delivery));
        $getday_calc = $ci->db->query("SELECT id,abs_value,currency,percent_value FROM tb_ratecal_calculates WHERE rate_cal_id='" . $cal_id . "' AND day_name LIKE '" . $day . "' AND ( daystart_time <='" . $time . "' AND dayend_time >='" . $time . "' ) AND status='1' LIMIT 1");
        if ($getday_calc->num_rows() > 0) {
            $result = ['row_id' => $getday_calc->row()->id, 'abs_value' => $getday_calc->row()->abs_value, 'currency' => $getday_calc->row()->currency, 'percent_value' => $getday_calc->row()->percent_value];
        } else {
            $getdday_calc = $ci->db->query("SELECT id,abs_value,currency,percent_value FROM tb_ratecal_calculates WHERE rate_cal_id='" . $cal_id . "' AND day_name LIKE '" . $dday . "' AND ( daystart_time <='" . $dtime . "' AND dayend_time >='" . $dtime . "' ) AND status='1' LIMIT 1");
            if ($getdday_calc->num_rows() > 0) {
                $result = ['row_id' => $getdday_calc->row()->id, 'abs_value' => $getdday_calc->row()->abs_value, 'currency' => $getdday_calc->row()->currency, 'percent_value' => $getdday_calc->row()->percent_value];
            }
        }
        return $result;
    }

    public function checkamountforholidays($cal_id, $pickup, $delivery)
    {
        $result       = [];
        $ci           = &get_instance();
        $date         = date('Y-m-d', strtotime($pickup));
        $ddate        = date('Y-m-d', strtotime($delivery));
        $getholi_calc = $ci->db->query("SELECT id,asolute,currency,margin_percent FROM tb_ratecal_holidays WHERE rate_cal_id='" . $cal_id . "' AND holiday_date LIKE '" . $date . "' AND status ='1' LIMIT 1");
        if ($getholi_calc->num_rows() > 0) {
            $result = ['row_id' => $getholi_calc->row()->id, 'abs_value' => $getholi_calc->row()->asolute, 'currency' => $getholi_calc->row()->currency, 'percent_value' => $getholi_calc->row()->margin_percent];
        } else {
            $getdholi_calc = $ci->db->query("SELECT id,asolute,currency,margin_percent FROM tb_ratecal_holidays WHERE rate_cal_id='" . $cal_id . "' AND holiday_date LIKE '" . $ddate . "' AND status ='1' LIMIT 1");
            if ($getdholi_calc->num_rows() > 0) {
                $result = ['row_id' => $getdholi_calc->row()->id, 'abs_value' => $getdholi_calc->row()->asolute, 'currency' => $getdholi_calc->row()->currency, 'percent_value' => $getdholi_calc->row()->margin_percent];
            }
        }
        return $result;

    }

    public function addrecodfortripinsertion($arr)
    {
        $ci                = &get_instance();
        $cdate             = date('Y-m-d H:i:s');
        $company_code      = $ci->session->userdata('company_code');
        $user_id           = $ci->session->userdata('user_id');
        $order_service     = $order_product     = $service_chk     = $product_chk     = $order_otype     = $refcheck     = $chk_ref     = $chk_rate_service     = $rate_service_id     = $rate_offering     = $rate_record     = $modechk     = 0;
        $vendor_serviceses = $service_row_ids = [];
        $order_mod         = $offering_type         = "";
        if (! empty($arr)) {
            $order_ids = isset($arr['ordid']) ? $arr['ordid'] : "0";
            if ($order_ids == "") {
                $order_ids = 0;
            }
            $vendor_id = isset($arr['carrierid']) ? $arr['carrierid'] : "0";
            if ($vendor_id == "") {
                $vendor_id = 0;
            }
            $whr = " (company_code = '' OR company_code IS NULL ) ";
            if ($order_ids != "0" && $vendor_id != "0") {
                $getvendor_code = $ci->common->gettblrowdata(['id' => $vendor_id], "code", "tb_vendors", 0, 0);
                if (! empty($getvendor_code)) {
                    $vendor_code   = $getvendor_code['code'];
                    $getprofile_id = $ci->Order->getvendorprofileforpreference($vendor_code, $user_id);
                    if ($getprofile_id->num_rows() > 0) {
                        foreach ($getprofile_id->result() as $profile) {
                            $vend_profile_id = $profile->id;
                            if ($vend_profile_id != "") {
                                $ordeschk = explode(",", $order_ids);
                                if (! empty($ordeschk)) {
                                    foreach ($ordeschk as $ord) {
                                        $modechk      = 0;
                                        $order_mod    = $offering_type    = "";
                                        $getorder_mod = $ci->common->gettblrowdata(['id' => $ord, 'status!=' => 0], "transport_mode", "tb_orders", 0, 0);
                                        if (! empty($getorder_mod)) {
                                            $order_mod = $getorder_mod['transport_mode'];
                                            if ($order_mod == "") {
                                                $modechk = 1;
                                            }
                                            if (is_null($order_mod)) {
                                                $order_mod = "";
                                                $modechk   = 1;
                                            }
                                        }
                                        $getorderdetails = $ci->common->gettblrowdata(['id' => $ord, 'status!=' => 0], "pickup_country,delivery_country,pickup_city,delivery_city,pickup_pincode,delivery_pincode,pickup_address2,delivery_address2,customer_id,product", "tb_orders", 0, 0);
                                        if (! empty($getorderdetails)) {
                                            $getservices = $ci->common->gettblrowdata(['order_row_id' => $ord, 'status' => 1], "order_type,service", "tb_order_details", 0, 0);
                                            if (! empty($getservices)) {
                                                $order_service = $getservices['service'];
                                                $order_otype   = $getservices['order_type'];
                                            }
                                            $productname = $getorderdetails['product'];
                                            $customer_id = $getorderdetails['customer_id'];
                                            if ($productname != "") {
                                                if (in_array($company_code, ['ZAKN', 'VNKN'], true)) {
                                                    $getproduct_id = $ci->common->gettblrowdata(['name' => $productname, 'status' => 1, 'company_code' => $company_code], "id", "tb_products_master", 0, 0);
                                                    $order_product = $getproduct_id['id'];
                                                } else {
                                                    $ci->db->select("id");
                                                    $ci->db->from("tb_products_master");
                                                    $ci->db->where(['name' => $productname]);
                                                    $ci->db->where($whr);
                                                    $ci->db->where(['status' => '1']);
                                                    $getproduct_id = $ci->db->get();
                                                    if ($getproduct_id->num_rows() > 0) {
                                                        $order_product = $getproduct_id->row()->id;
                                                    }

                                                }

                                            }
                                            $pickup     = ['country' => trim($getorderdetails['pickup_country']), 'state' => trim($getorderdetails['pickup_address2']), 'city' => trim($getorderdetails['pickup_city']), 'pincode' => $getorderdetails['pickup_pincode']];
                                            $delivery   = ['country' => trim($getorderdetails['delivery_country']), 'state' => trim($getorderdetails['delivery_address2']), 'city' => trim($getorderdetails['delivery_city']), 'pincode' => $getorderdetails['delivery_pincode']];
                                            $preference = $ci->Order->getvendorpreferencebyorderdetails($vend_profile_id, $user_id, $pickup, $delivery, [], $arr['rateRecordId'] ?? "");
                                            if (! empty($preference)) {
                                                foreach ($preference as $pre) {
                                                    $preference_id     = $pre['id'];
                                                    $rate_service_id   = $pre['rate_service_id'];
                                                    $rate_offering     = $pre['rate_offering_id'];
                                                    $rate_record_id    = $pre['rate_record_id'];
                                                    $auto_bill         = $pre['auto_bill'];
                                                    $info              = ['order_id' => $ord, 'product' => $productname];
                                                    $vendor_serviceses = $this->getvendorprofiledetailsbyid($vendor_id, $order_service, $info);
                                                    if (! empty($vendor_serviceses)) {
                                                        foreach ($vendor_serviceses as $serv) {
                                                            $service_row_ids[] = $serv['service_row_id'];
                                                        }
                                                    }
                                                    $checkLanes = $this->getlaneids_byservice($rate_service_id, $ord, ['consignee_country' => $delivery['country'], 'shipper_country' => $pickup['country'], 'shipper_city' => $pickup['city'], 'consignee_city' => $delivery['city'], 'shipper_zipcode' => $pickup['pincode'], 'consignee_zipcode' => $delivery['pincode']]);
                                                    if (in_array($rate_service_id, $service_row_ids)) {
                                                        $chk_rate_service = 1;
                                                    } else {
                                                        $chk_rate_service = 0;
                                                    }
                                                    if (empty($checkLanes)) {
                                                        $chk_rate_service = 0;
                                                    }
                                                    if ($chk_rate_service == 1) {
                                                        $refcheck = $this->checkrefandorcondition($ord, $rate_record_id);
                                                        if ($order_product > 0) {
                                                            $product_chk       = 1;
                                                            $chk_preferproduct = $ci->common->gettbldata(['rate_prefer_id' => $preference_id, 'status' => '1'], "product_id", "tb_rateprefer_product", 0, 0);
                                                            if (! empty($chk_preferproduct)) {
                                                                $product_chk    = 0;
                                                                $prefer_product = [];
                                                                foreach ($chk_preferproduct as $pro) {
                                                                    $prefer_product[] = $pro['product_id'];
                                                                }
                                                                if (! empty($prefer_product)) {
                                                                    if (in_array($order_product, $prefer_product)) {
                                                                        $product_chk = 1;
                                                                    }
                                                                }
                                                            } else {
                                                                $product_chk = 1;
                                                            }
                                                        } else {
                                                            $product_chk = 1;
                                                        }
                                                        if ($order_service > 0) {
                                                            $service_chk       = 1;
                                                            $chk_preferservice = $ci->common->gettbldata(['rate_prefer_id' => $preference_id, 'status' => '1'], "service_id", "tb_rateprefer_service", 0, 0);
                                                            if (! empty($chk_preferservice)) {
                                                                $service_chk    = 0;
                                                                $prefer_service = [];
                                                                foreach ($chk_preferservice as $pro) {
                                                                    $prefer_service[] = $pro['service_id'];
                                                                }
                                                                if (! empty($prefer_service)) {
                                                                    if (in_array($order_service, $prefer_service)) {
                                                                        $service_chk = 1;
                                                                    }
                                                                }
                                                            } else {
                                                                $service_chk = 1;
                                                            }
                                                        } else {
                                                            $service_chk = 1;
                                                        }
                                                        if ($order_otype > 0) {
                                                            $ordertype_chk   = 1;
                                                            $chk_preferotype = $ci->common->gettbldata(['rate_prefer_id' => $preference_id, 'user_id' => $user_id, 'status' => '1'], "order_type_id", "tb_rateprefer_ordertypes", 0, 0);
                                                            if (! empty($chk_preferotype)) {
                                                                $ordertype_chk = 0;
                                                                $prefer_otype  = [];
                                                                foreach ($chk_preferotype as $pro) {
                                                                    $prefer_otype[] = $pro['order_type_id'];
                                                                }
                                                                if (! empty($prefer_otype)) {
                                                                    if (in_array($order_otype, $prefer_otype)) {
                                                                        $ordertype_chk = 1;
                                                                    }
                                                                }
                                                            } else {
                                                                $ordertype_chk = 1;
                                                            }
                                                        } else {
                                                            $ordertype_chk = 1;
                                                        }
                                                        if ($rate_offering > 0) {
                                                            /*Check mode of transport i.e. offering type */
                                                            $getoffering_type = $ci->common->gettblrowdata(['id' => $rate_offering, 'status' => '1'], "offering_type,vendor_profile_id", "tb_rate_offerings", 0, 0);
                                                            if (! empty($getoffering_type)) {
                                                                $vendorProfileId = $getoffering_type['vendor_profile_id'];
                                                                if ($vendorProfileId > 0) {
                                                                    $checkProfile = $ci->common->gettblrowdata(['vp_id' => $vendorProfileId, 'profile_id' => $vendor_code, 'status' => '1'], "id", "tb_vendor_profile_list", 0, 0);
                                                                    if (empty($checkProfile)) {
                                                                        $service_chk = 0;
                                                                    }
                                                                }
                                                                $modechk       = 0;
                                                                $offering_type = $getoffering_type['offering_type'];
                                                                if ($offering_type == "") {
                                                                    $modechk = 1;
                                                                }
                                                                if (is_null($offering_type)) {
                                                                    $modechk       = 1;
                                                                    $offering_type = "";
                                                                }
                                                                if ($modechk == 0) {
                                                                    if ($offering_type != "" && $order_mod != "") {
                                                                        if (strtoupper($offering_type) == strtoupper($order_mod)) {
                                                                            $modechk = 1;
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                        $chk_ref = $this->preference_checkrefandorcondition($ord, $preference_id);
                                                        if ($chk_ref == '1' && $ordertype_chk == '1' && $service_chk == '1' && $product_chk == '1' && $refcheck == '1' && $modechk == '1') {
                                                            $data         = ['rate_record_id' => $rate_record_id, 'rate_offering' => $rate_offering, 'rate_autobill' => $auto_bill, 'order_id' => $ord, 'vendor_code' => $vendor_code, 'rate_service_id' => $rate_service_id];
                                                            $asspreferece = $this->add_buypreference($data);
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public function preference_checkrefandorcondition($order_id, $id)
    {
        $ci = &get_instance();
        if ($order_id != "" && $order_id > 0) {
            $noand    = $noor    = 1;
            $orwhr    = $andwhr    = "";
            $orar     = $andar     = [];
            $refcheck = 1;
            if ($id > 0) {
                $andcond = $orcond = $refcheknum_rows = $andrecordmatch = $orrecordmatch = 0;
                $chkref  = $ci->common->gettbldata(['rate_prefer_id' => $id, 'status' => '1'], "ref_id,ref_value,ref_condition", "tb_rateprefer_ref_types", 0, 0);
                if (! empty($chkref)) {
                    $chkref_count    = count($chkref);
                    $refcheck        = 0;
                    $refcheknum_rows = $andcond = $orcond = 1;
                    $a               = 0;
                    $getFileLineID   = $ci->common->gettblrowdata(['name' => 'FI'], "id", "tb_reference_master", 0, 0);
                    $fileLineId      = $getFileLineID['id'];
                    foreach ($chkref as $ref) {
                        $condition_type = $ref['ref_condition'];
                        $ref_pid        = $ref['ref_id'];
                        $ref_value      = $ref['ref_value'];
                        if ($chkref_count == 1) {
                            $condition_type = 'AND';
                            if ($ref_pid == $fileLineId) {
                                $getOrderFileRef = $ci->common->gettblrowdata(['order_id' => $order_id, 'reference_id' => 'FI', 'status' => '1'], "ref_value", "tb_order_references", 0, 0);
                                if (empty($getOrderFileRef)) {
                                    return 1;
                                }
                                $OrderFileLine = $getOrderFileRef['ref_value'];
                                if ($OrderFileLine == $ref_value) {
                                    return 1;
                                } else {
                                    return 0;
                                }
                            }
                        }
                        if ($condition_type == "AND") {
                            $noand   = 0;
                            $andar[] = ['ref_id' => $ref_pid, 'ref_value' => $ref_value];
                            $a++;
                        } else {
                            if ($condition_type == 'OR') {
                                $noor   = 0;
                                $orar[] = ['ref_id' => $ref_pid, 'ref_value' => $ref_value];
                            }
                        }
                    }
                    if (! empty($andar)) {
                        $andwhr .= " AND ( ";
                        for ($i = 0; $i < count($andar); $i++) {
                            if ($i == 0) {
                                $ref_pid   = $andar[0]['ref_id'];
                                $ref_value = $andar[0]['ref_value'];
                                $andwhr .= "( r.id='" . $ref_pid . "' AND o.reference_id = r.name AND o.ref_value='" . $ref_value . "' AND o.status ='1' ) ";
                            } else {
                                $ref_pid   = $andar[$i]['ref_id'];
                                $ref_value = $andar[$i]['ref_value'];
                                $andwhr .= " OR ( r.id='" . $ref_pid . "' AND o.reference_id = r.name AND o.ref_value='" . $ref_value . "' AND o.status ='1' ) ";
                            }
                        }
                        $andwhr .= " ) ";
                    }
                    if (! empty($orar)) {
                        if (count($orar) > 1) {
                            $orwhr .= " AND ( ";
                            for ($i = 0; $i < count($orar); $i++) {
                                if ($i == 0) {
                                    $ref_pid   = $orar[0]['ref_id'];
                                    $ref_value = $orar[0]['ref_value'];
                                    $orwhr .= "( r.id='" . $ref_pid . "' AND o.reference_id = r.name AND o.ref_value='" . $ref_value . "' AND o.status ='1' ) ";
                                } else {
                                    $ref_pid   = $orar[$i]['ref_id'];
                                    $ref_value = $orar[$i]['ref_value'];
                                    $orwhr .= " OR ( r.id='" . $ref_pid . "' AND o.reference_id = r.name AND o.ref_value='" . $ref_value . "' AND o.status ='1' ) ";
                                }
                            }
                            $orwhr .= " ) ";
                        } else {
                            $noor = 1;
                        }
                    }
                    if ($refcheknum_rows > 0) {
                        if ($andcond == 1) {
                            if ($andwhr != "") {
                                $andrecordmatch = $ci->Orderrevenuesmodel->checkandorconditionforref($order_id, $andwhr);
                                if ($andrecordmatch == $a) {
                                    $andrecordmatch = 1;
                                } else {
                                    $andrecordmatch = 0;
                                }
                            } else {
                                if ($noand == 1) {
                                    $andrecordmatch = 1;
                                } else {
                                    $andrecordmatch = 0;
                                }
                            }
                        } else {
                            $andrecordmatch = 0;
                        }
                        if ($orcond == 1) {
                            if ($orwhr != "") {
                                $orrecordmatch = $ci->Orderrevenuesmodel->checkandorconditionforref($order_id, $orwhr);
                            } else {
                                if ($noor == 1) {
                                    $orrecordmatch = 1;
                                } else {
                                    $orrecordmatch = 0;
                                }
                            }
                        } else {
                            $orrecordmatch = 0;
                        }
                    }
                    if ($orrecordmatch > 0 && $andrecordmatch > 0) {
                        $refcheck = 1;
                    } else {
                        $refcheck = 0;
                    }
                } else {
                    $refcheck = 1;
                }
            }
        }
        return $refcheck;
    }
    public function add_buypreference($arr)
    {
        $ci                = &get_instance();
        $cdate             = date("Y-m-d H:i:s");
        $user_id           = $ci->session->userdata('user_id');
        $company_code      = $ci->session->userdata('company_code');
        $exchange_rate     = $foreign_currency     = "";
        $charge_of_country = $vascharges = $charge_ar_vas = [];
        $type              = '1';
        $offering_gid      = 1;
        $record_id         = 1;
        if (! empty($arr)) {
            $rate_record     = $arr['rate_record_id'];
            $rate_offering   = $arr['rate_offering'];
            $rate_autobill   = $arr['rate_autobill'];
            $rate_service_id = $arr['rate_service_id'];
            if ($rate_offering != "" && $rate_offering != "0") {
                $getraterecord_id = $ci->common->gettblrowdata(['id' => $rate_record, 'status' => '1'], 'rate_id', "tb_rate_records", 0, 0);
                if (! empty($getraterecord_id)) {
                    $record_id = $getraterecord_id['rate_id'];
                }
                if ($arr['order_id'] != "" && $arr['order_id'] != '0') {
                    $vascharges = $this->getchargesthrougvasbyrecord($rate_offering, $rate_record, $arr['order_id'], $user_id, $type);
                }
                if (! empty($vascharges)) {
                    foreach ($vascharges as $vas) {
                        $vas_charge_id = $vas['charge_id'];
                        if ($vas_charge_id != '0' && $vas_charge_id != "") {
                            $getcharge_forlane = $ci->common->gettblrowdata(['id' => $vas_charge_id, 'status' => '1'], 'id,name', "tb_charge_codes", 0, 0);
                            if (! empty($getcharge_forlane)) {
                                $lane_chargerow_id = $getcharge_forlane['id'];
                                $lane_chargename   = $getcharge_forlane['name'];
                            }
                        } else {
                            $getcharge_forlane = $ci->common->gettblrowdata(['charge_code' => 'CSC', 'status' => '1'], 'id,name', "tb_charge_codes", 0, 0);
                            if (! empty($getcharge_forlane)) {
                                $lane_chargerow_id = $getcharge_forlane['id'];
                                $lane_chargename   = $getcharge_forlane['name'];
                            }
                        }
                        $charge_ar_vas[] = ['charge_code' => $lane_chargerow_id, 'description' => $lane_chargename, 'quantity_unit' => '1', 'value' => '1', 'rate_id' => $record_id, 'amount' => $vas['amount'], 'currency' => $vas['currency'], 'user_id' => $user_id, 'createdon' => $cdate];
                    }
                }
                /*  $offeringvascharges = $this->getchargesthrougvasbyoffering($rate_offering,$type,$arr['order_id'],$user_id);*/
                $getoffering_id = $ci->common->gettblrowdata(['id' => $rate_offering, 'status' => '1'], "offering_id", "tb_rate_offerings", 0, 0);
                if (! empty($getoffering_id)) {
                    $offering_gid = $getoffering_id['offering_id'];
                }
                $offeringvascharges = $this->getchargesthrougvasbyoffering($rate_offering, $type, $arr['order_id'], $user_id);
                if (! empty($offeringvascharges)) {
                    foreach ($offeringvascharges as $res) {
                        $getcharge_forlane = $ci->common->gettblrowdata(['id' => $res['charge_id'], 'status' => '1'], 'id,name', "tb_charge_codes", 0, 0);
                        if (! empty($getcharge_forlane)) {
                            $lane_chargerow_id = $getcharge_forlane['id'];
                            $lane_chargename   = $getcharge_forlane['name'];
                        }
                        $charge_of_country[] = ['charge_code' => $res['charge_id'], 'description' => $lane_chargename, 'quantity_unit' => '1', 'value' => '1', 'rate_id' => $offering_gid, 'amount' => $res['amount'], 'currency' => $res['currency'], 'rate_service_id' => $rate_service_id, 'rate_offering_id' => $rate_offering, 'rate_record_id' => $rate_record, 'user_id' => $user_id, 'createdon' => $cdate];
                    }
                }
            }

            if ($rate_record != "" && $rate_record != '0') {
                $getraterecord_id = $ci->common->gettblrowdata(['id' => $rate_record, 'status' => '1'], 'rate_id', "tb_rate_records", 0, 0);
                $record_id        = 1;
                if (! empty($getraterecord_id)) {
                    $record_id = $getraterecord_id['rate_id'];
                }
                /* $type ='0';*/
                $charge_ar        = $this->getraterecordcharges($rate_offering, $rate_record, $type, $arr['order_id'], $record_id, $user_id);
                $invoice_status   = 0;
                $debtor_jfr       = $invoice_number       = $credit_note_number       = "";
                $invoice_date     = '0000-00-00 00:00:00';
                $inv_createddate  = '0000-00-00 00:00:00';
                $inv_receiveddate = '0000-00-00 00:00:00';
                $customer_name    = 'Vendor';
                if ($company_code == 'RUKN') {
                    $getcustomerdetails = $ci->common->gettblrowdata(['code' => $arr['vendor_code'], 'status' => '1', 'company_code' => $company_code], "name", "tb_vendors", 0, 0);
                    if (! empty($getcustomerdetails)) {
                        $customer_name = $getcustomerdetails['name'];
                    }
                } else {
                    $getcustomerdetails = $ci->common->gettblrowdata(['code' => $arr['vendor_code'], 'status' => '1', 'user_id' => $user_id], "name", "tb_vendors", 0, 0);
                    if (! empty($getcustomerdetails)) {
                        $customer_name = $getcustomerdetails['name'];
                    }
                }
                $currency = '';
                if (! empty($charge_ar)) {
                    $foreign_currency = isset($charge_ar[0]['foreign_currency']) ? $charge_ar[0]['foreign_currency'] : "";
                    $currency         = isset($charge_ar[0]['currency']) ? $charge_ar[0]['currency'] : "";
                    $exchange_rate    = $charge_ar[0]['exchange_amount'];
                    for ($c = 0; $c < count($charge_ar); $c++) {
                        unset($charge_ar[$c]['foreign_currency']);
                        unset($charge_ar[$c]['exchange_amount']);
                        $charge_ar[$c]['rate_service_id']  = $rate_service_id;
                        $charge_ar[$c]['rate_offering_id'] = $rate_offering;
                        $charge_ar[$c]['rate_record_id']   = $rate_record;
                    }
                }
                $revenue_ar = ['order_id' => $arr['order_id'], 'type' => '1', 'recipient_role' => 'Carrier', 'recipient_code' => $arr['vendor_code'], 'recipient_name' => $customer_name, 'debtor_jfr' => $debtor_jfr, 'invoice_number' => $invoice_number, 'credit_note_number' => $credit_note_number, 'invoice_date' => $invoice_date, 'invoice_creation_date' => $inv_createddate, 'invoice_receivdon_date' => $inv_receiveddate, 'amount' => '0', 'currency' => $currency, 'status' => 1, 'user_id' => $user_id, 'createdon' => $cdate, 'exchange_rate' => $exchange_rate, 'invoice_status' => $invoice_status, 'foreign_currency' => $foreign_currency];
                $rev_row_id = $this->insertrecords($revenue_ar, $charge_ar, [], $charge_of_country, $charge_ar_vas);

                if ($rate_record > 0 && $rev_row_id > 0) {
                    $addfaf = $this->addfafcharges_toorder($arr['order_id'], $rev_row_id, $rate_record, 'RP - Rate Preference');
                }

                /*   if($rate_autobill == '1'){
                   $get_country = $ci->db->select('country_code,company_code')->get_where("tb_users",array('id'=>$user_id));
                       $country_code  = $get_country->row()->country_code;
                       $company_code  = $get_country->row()->company_code;
                       $info = array('country_code'=>$country_code,'user_id'=>$user_id,'revnue_id'=>$rev_row_id,'order_id'=>$arr['order_id'],'trip_id'=>'0');
                       $debtor_jfr = generatedebitro_jfrcode($info);
                       if($debtor_jfr != "" && $debtor_jfr != '0'){
                           $curtz = $ci->session->userdata("usr_tzone")['timezone'];
                           $cdate = date('Y-m-d H:i:s');
                           $getactual = getdatetimebytimezone(DFLT_TZ,$cdate,$curtz);
                           $update = $getactual['datetime'];
                           $upd = $ci->common->updatetbledata("tb_reveneus",array('debtor_jfr'=>$debtor_jfr,'invoice_status'=>'1','debitor_time'=>$update),array('id'=>$rev_row_id));
                       }
                   }*/
            }
        }
    }

    public function insertrecords($revenue_ar, $charge_ar, $charge_ar_country, $charge_ar_vas, $charge_of_country, $order_id = "", $shift_id = "")
    {
        $ci              = &get_instance();
        $user_currency   = $ci->session->userdata("usr_tzone")['currency'];
        $session_company = $session_companycode = $ci->session->userdata('company_code');
        if ($session_company == "PLKN") {
            $user_currency = 'PLN';
        }
        $revenue_ar['currency'] = $user_currency;
        if (! (count($charge_ar) + count($charge_ar_country) + count($charge_ar_vas) + count($charge_of_country))) {
            return 0;
        }
        //$revenue_id = $ci->common->insertTableData("tb_reveneus", $revenue_ar);
        
        $existing_revenue = isset($revenue_ar['shift_id']) ? $ci->db->get_where('trip_reveneus', ['shift_id' => $revenue_ar['shift_id'], 'type' => $revenue_ar['type']])->row_array() : $ci->db->get_where('tb_reveneus', ['order_id' => $revenue_ar['order_id'], 'type' => $revenue_ar['type']])->row_array();

        if ($existing_revenue) {
            isset($revenue_ar['shift_id']) ? $ci->common->updatetbledata('trip_reveneus', $revenue_ar, ['id' => $existing_revenue['id']]) : $ci->common->updatetbledata('tb_reveneus', $revenue_ar, ['id' => $existing_revenue['id']]);
            $revenue_id = $existing_revenue['id'];
            isset($revenue_ar['shift_id']) ? $ci->db->delete('trip_charges', ['revenue_id' => $revenue_id]) : $ci->db->delete('tb_charges', ['revenue_id' => $revenue_id]);
        } else {
            //$revenue_id = $ci->common->insertTableData("tb_reveneus", $revenue_ar);
            $revenue_id = isset($revenue_ar['shift_id']) ? $ci->common->insertTableData("trip_reveneus", $revenue_ar) : $ci->common->insertTableData("tb_reveneus", $revenue_ar);
        }
        
        if ($revenue_id != "0" && $revenue_id != "") {
            if (! empty($charge_ar)) {
                foreach ($charge_ar as $ar) {
                    $ar['revenue_id'] = $revenue_id;
                    if ($user_currency == $ar['currency']) {
                        $charge_amount = $ar['amount'];
                        if ($session_companycode == "VNKN") {
                            $charge_amount = round($ar['amount']);
                        } else {
                            $charge_amount = round($ar['amount'], 2);
                        }
                        $ar['amount']         = $charge_amount;
                        $ar['local_amount']   = $charge_amount;
                        $ar['local_currency'] = $ar['currency'];
                    }
                    $ar['source_created'] = $ar['source_created'] ?? 'RP - Rate Preference';
                    $charge_add = isset($revenue_ar['shift_id']) ? $ci->common->insertTableData("trip_charges", $ar) : $ci->common->insertTableData("tb_charges", $ar);
                }
            }
            if (! empty($charge_ar_country)) {
                $charge_ar_country['revenue_id'] = $revenue_id;
                $currency_ar                     = isset($charge_ar_country['currency']) ? $charge_ar_country['currency'] : "";
                if ($user_currency == $currency_ar) {
                    $charge_amount = $charge_ar_country['amount'];
                    if ($session_companycode == "VNKN") {
                        $charge_amount = round($charge_ar_country['amount']);
                    } else {
                        $charge_amount = round($charge_ar_country['amount'], 2);
                    }
                    $charge_ar_country['amount']         = $charge_amount;
                    $charge_ar_country['local_amount']   = $charge_amount;
                    $charge_ar_country['local_currency'] = $charge_ar_country['currency'];
                }
                $charge_ar_country['source_created'] = $charge_ar_country['source_created'] ?? 'RP - Rate Preference';
                $charge_add1                         = isset($revenue_ar['shift_id']) ? $ci->common->insertTableData("trip_charges", $charge_ar_country) : $ci->common->insertTableData("tb_charges", $charge_ar_country);
            }
            if (! empty($charge_ar_vas)) {
                foreach ($charge_ar_vas as $vas) {
                    $vas['revenue_id'] = $revenue_id;
                    $vas_currency      = isset($vas['currency']) ? $vas['currency'] : "";
                    if ($user_currency == $vas_currency) {
                        $charge_amount = $vas['amount'];
                        if ($session_companycode == "VNKN") {
                            $charge_amount = round($vas['amount']);
                        } else {
                            $charge_amount = round($vas['amount'], 2);
                        }
                        $vas['amount']         = $charge_amount;
                        $vas['local_amount']   = $charge_amount;
                        $vas['local_currency'] = $vas['currency'];
                    }
                    $vas['source_created'] = $vas['source_created'] ?? 'RP - Rate Preference';
                    $charge_ar_vas_id = isset($revenue_ar['shift_id']) ? $ci->common->insertTableData("trip_charges", $vas) : $ci->common->insertTableData("tb_charges", $vas);
                }

            }
            if (! empty($charge_of_country)) {
                foreach ($charge_of_country as $vas) {
                    $vas['revenue_id'] = $revenue_id;
                    $vas_currency1     = isset($vas['currency']) ? $vas['currency'] : "";
                    if ($user_currency == $vas_currency1) {
                        $charge_amount = $vas['amount'];
                        if ($session_companycode == "VNKN") {
                            $charge_amount = round($vas['amount']);
                        } else {
                            $charge_amount = round($vas['amount'], 2);
                        }
                        $vas['amount']         = $charge_amount;
                        $vas['local_amount']   = $charge_amount;
                        $vas['local_currency'] = $vas['currency'];
                    }
                    $vas['source_created'] = $vas['source_created'] ?? 'RP - Rate Preference';
                    $charge_of_country_id  = isset($revenue_ar['shift_id']) ? $ci->common->insertTableData("trip_charges", $vas) : $ci->common->insertTableData("tb_charges", $vas);
                }

            }
            $rev_ids[] = $revenue_id;
            $ci->vatcalculationtorate->updatevattorevenues($rev_ids, $shift_id, $order_id);
            $upd_utilized_amount = $this->updateutilizedamount_fororder($order_id);
        }
        return $revenue_id;
    }
    public function addrecodfororderinsertion($arr)
    {
        $ci              = &get_instance();
        $cdate           = date('Y-m-d H:i:s');
        $cust_profile_id = $exchange_rate = $service_chk = $product_chk = $order_otype = $refcheck = $chk_rate_service = $rate_service_id = $rate_offering = $rate_record = $modechk = 0;
        $service_row_ids = $serviceses = [];
        $order_mod       = $offering_type       = "";
        $company_code    = $ci->session->userdata('company_code');
        if ($arr) {
            $user_id        = $arr['user_id'];
            $order_product  = isset($arr['product']) ? $arr['product'] : "";
            $order_service  = isset($arr['service']) ? $arr['service'] : "0";
            $order_otype    = isset($arr['order_type']) ? $arr['order_type'] : "0";
            $pickup_id      = isset($arr['customer_row_id']) ? $arr['customer_row_id'] : "0";
            $pickup_country = isset($arr['pickup']) ? $arr['pickup'] : "";
            $pickup_pincode = isset($arr['pickup_pincode']) ? $arr['pickup_pincode'] : "";
            $pickup_city    = isset($arr['pickup_city']) ? $arr['pickup_city'] : "";
            $drop_country   = isset($arr['drop']) ? $arr['drop'] : "";
            $drop_city      = isset($arr['drop_city']) ? $arr['drop_city'] : "";
            $drop_pincode   = isset($arr['drop_pincode']) ? $arr['drop_pincode'] : "";

            $pickup_location   = ['country' => $pickup_country, 'zipcode' => $pickup_pincode, 'user_id' => $user_id, 'city' => $pickup_city];
            $delivery_location = ['country' => $drop_country, 'zipcode' => $drop_pincode, 'user_id' => $user_id, 'city' => $drop_city];
            if ($order_service == "") {
                $order_service = 0;
            }if ($order_otype == "") {
                $order_otype = 0;
            }
            $getorder_mod = $ci->common->gettblrowdata(['id' => $arr['order_id'], 'status!=' => 0], "transport_mode", "tb_orders", 0, 0);
            if (! empty($getorder_mod)) {
                $order_mod = $getorder_mod['transport_mode'];
                if ($order_mod == "") {
                    $modechk = 1;
                }
                if (is_null($order_mod)) {
                    $order_mod = "";
                    $modechk   = 1;
                }
            }
            $getprofile_id = $ci->Order->getcustomerprofileforpreference($arr['customer_id'], $arr['user_id']);
            if ($getprofile_id->num_rows() > 0) {
                $cust_profile_id = $getprofile_id->row()->id;
            }
            $product_id = 0;
            $whr        = " (company_code = '' OR company_code IS NULL ) ";
            if ($cust_profile_id != '0') {
                if ($order_product != "") {
                    if (in_array($company_code, ['ZAKN', 'VNKN'], true)) {
                        $getproduct_id1 = $ci->common->gettblrowdata(['name' => $order_product, 'status' => 1, 'company_code' => $company_code], "id", "tb_products_master", 0, 0);
                        if (! empty($getproduct_id1)) {
                            $product_id = $getproduct_id1['id'];
                        }
                    } else {
                        $ci->db->select("id");
                        $ci->db->from("tb_products_master");
                        $ci->db->where(['name' => $order_product]);
                        $ci->db->where($whr);
                        $ci->db->where(['status' => '1']);
                        $getproduct_id = $ci->db->get();
                        if ($getproduct_id->num_rows() > 0) {
                            $product_id = $getproduct_id->row()->id;
                        }

                    }
                }
                $charge_of_country = [];
                $rate_autobill     = 0;
                $getpreferences    = $ci->Order->getpreferencebyorderdetails($cust_profile_id, $user_id, $arr);
                $info              = ['order_id' => $arr['order_id'], 'product' => $order_product];
                $serviceses        = $this->getcustomerprofiledetailsbyid($pickup_id, $order_service, $pickup_location, $delivery_location, $info);
                if (! empty($getpreferences)) {
                    foreach ($getpreferences as $preference) {
                        $preference_id   = $preference['id'];
                        $rate_service_id = $preference['rate_service_id'];
                        $rate_offering   = $preference['rate_offering_id'];
                        $rate_record     = $preference['rate_record_id'];
                        $rate_autobill   = $preference['auto_bill'];
                        if ($rate_service_id > 0) {
                            if (! empty($serviceses)) {
                                foreach ($serviceses as $serv) {
                                    $service_row_ids[] = $serv['service_row_id'];
                                }
                            }
                            if (! empty($service_row_ids)) {
                                if (in_array($rate_service_id, $service_row_ids)) {
                                    $chk_rate_service = 1;
                                }
                            }
                        }
                        $checkLanes = $this->getlaneids_byservice($rate_service_id, $arr['order_id'], ['consignee_country' => $delivery_location['country'], 'shipper_country' => $pickup_location['country'], 'shipper_city' => $pickup_location['city'], 'consignee_city' => $delivery_location['city'], 'shipper_zipcode' => $pickup_location['zipcode'], 'consignee_zipcode' => $delivery_location['zipcode']]);
                        if (empty($checkLanes)) {
                            $chk_rate_service = 0;
                        }
                        if ($rate_offering > 0) {
                            /*Check mode of transport i.e. offering type */
                            $getoffering_type = $ci->common->gettblrowdata(['id' => $rate_offering, 'status' => '1'], "offering_type,cust_profile_id", "tb_rate_offerings", 0, 0);
                            if (! empty($getoffering_type)) {
                                $customerProfileId = $getoffering_type['cust_profile_id'];
                                if ($customerProfileId > 0) {
                                    $checkProfile = $ci->common->gettblrowdata(['cp_id' => $customerProfileId, 'profile_id' => $arr['customer_id'], 'status' => '1'], "id", "tb_customer_profile_list", 0, 0);
                                    if (empty($checkProfile)) {
                                        $chk_rate_service = 0;
                                    }
                                }
                                $modechk       = 0;
                                $offering_type = $getoffering_type['offering_type'];
                                if ($offering_type == "") {
                                    $modechk = 1;
                                }
                                if (is_null($offering_type)) {
                                    $modechk       = 1;
                                    $offering_type = "";
                                }
                                if ($modechk == 0) {
                                    if ($offering_type != "" && $order_mod != "") {
                                        if (strtoupper($offering_type) == strtoupper($order_mod)) {
                                            $modechk = 1;
                                        }
                                    }
                                }
                            }
                        }
                        if ($chk_rate_service == 1) {
                            $refcheck    = $this->checkrefandorcondition($arr['order_id'], $rate_record);
                            $chk_prefref = $this->preference_checkrefandorcondition($arr['order_id'], $preference_id);
                            if ($product_id > 0) {
                                $product_chk       = 1;
                                $chk_preferproduct = $ci->common->gettbldata(['rate_prefer_id' => $preference_id, 'user_id' => $user_id, 'status' => '1'], "product_id", "tb_rateprefer_product", 0, 0);
                                if (! empty($chk_preferproduct)) {
                                    $product_chk    = 0;
                                    $prefer_product = [];
                                    foreach ($chk_preferproduct as $pro) {
                                        $prefer_product[] = $pro['product_id'];
                                    }
                                    if (! empty($prefer_product)) {
                                        if (in_array($product_id, $prefer_product)) {
                                            $product_chk = 1;
                                        }
                                    }
                                } else {
                                    $product_chk = 1;
                                }
                            } else {
                                $product_chk = 1;
                            }
                            if ($order_service > 0) {
                                $service_chk       = 1;
                                $chk_preferservice = $ci->common->gettbldata(['rate_prefer_id' => $preference_id, 'user_id' => $user_id, 'status' => '1'], "service_id", "tb_rateprefer_service", 0, 0);
                                if (! empty($chk_preferservice)) {
                                    $service_chk    = 0;
                                    $prefer_service = [];
                                    foreach ($chk_preferservice as $pro) {
                                        $prefer_service[] = $pro['service_id'];
                                    }
                                    if (! empty($prefer_service)) {
                                        if (in_array($order_service, $prefer_service)) {
                                            $service_chk = 1;
                                        }
                                    }
                                } else {
                                    $service_chk = 1;
                                }
                            } else {
                                $service_chk = 1;
                            }
                            if ($order_otype > 0) {
                                $ordertype_chk   = 1;
                                $chk_preferotype = $ci->common->gettbldata(['rate_prefer_id' => $preference_id, 'user_id' => $user_id, 'status' => '1'], "order_type_id", "tb_rateprefer_ordertypes", 0, 0);
                                if (! empty($chk_preferotype)) {
                                    $ordertype_chk = 0;
                                    $prefer_otype  = [];
                                    foreach ($chk_preferotype as $pro) {
                                        $prefer_otype[] = $pro['order_type_id'];
                                    }
                                    if (! empty($prefer_otype)) {
                                        if (in_array($order_otype, $prefer_otype)) {
                                            $ordertype_chk = 1;
                                        }
                                    }
                                } else {
                                    $ordertype_chk = 1;
                                }
                            } else {
                                $ordertype_chk = 1;
                            }

                            $vascharges = [];
                            if ($refcheck == 1 && $ordertype_chk == 1 && $service_chk == 1 && $product_chk == 1 && $chk_prefref == 1 && $modechk == 1) {
                                $type = '0';
                                if ($rate_offering != "" && $rate_offering != "0") {
                                    if ($arr['order_id'] != "" && $arr['order_id'] != '0') {
                                        $vascharges = $this->getchargesthrougvasbyrecord($rate_offering, $rate_record, $arr['order_id'], $user_id, $type);
                                    }
                                    $offering_gid   = 1;
                                    $getoffering_id = $ci->common->gettblrowdata(['id' => $rate_offering, 'status' => '1'], "offering_id", "tb_rate_offerings", 0, 0);
                                    if (! empty($getoffering_id)) {
                                        $offering_gid = $getoffering_id['offering_id'];
                                    }
                                    $offeringvascharges = $this->getchargesthrougvasbyoffering($rate_offering, $type, $arr['order_id'], $user_id);
                                    if (! empty($offeringvascharges)) {
                                        foreach ($offeringvascharges as $res) {
                                            $getcharge_forlane = $ci->common->gettblrowdata(['id' => $res['charge_id'], 'status' => '1'], 'id,name', "tb_charge_codes", 0, 0);
                                            if (! empty($getcharge_forlane)) {
                                                $lane_chargerow_id = $getcharge_forlane['id'];
                                                $lane_chargename   = $getcharge_forlane['name'];
                                            }
                                            $charge_of_country[] = ['charge_code' => $res['charge_id'], 'description' => $lane_chargename, 'quantity_unit' => '1', 'value' => '1', 'rate_id' => $offering_gid, 'amount' => $res['amount'], 'currency' => $res['currency'], 'rate_service_id' => $rate_service_id, 'rate_offering_id' => $rate_offering, 'rate_record_id' => $rate_record, 'user_id' => $user_id, 'createdon' => $cdate, 'source_created' => 'RP - Rate Preference'];
                                        }
                                    }
                                }
                                $getraterecord_id = $ci->common->gettblrowdata(['id' => $rate_record, 'status' => '1'], 'rate_id', "tb_rate_records", 0, 0);
                                $record_id        = 1;
                                if (! empty($getraterecord_id)) {
                                    $record_id = $getraterecord_id['rate_id'];
                                }
                                $type               = '0';
                                $charge_ar          = $this->getraterecordcharges($rate_offering, $rate_record, $type, $arr['order_id'], $record_id, $user_id);
                                $invoice_status     = 0;
                                $debtor_jfr         = $invoice_number         = $credit_note_number         = "";
                                $invoice_date       = '0000-00-00 00:00:00';
                                $inv_createddate    = '0000-00-00 00:00:00';
                                $inv_receiveddate   = '0000-00-00 00:00:00';
                                $customer_name      = 'Customer';
                                $getcustomerdetails = $ci->common->gettblrowdata(['code' => $arr['customer_id'], 'status' => '1', 'user_id' => $user_id], "name", "tb_customers", 0, 0);
                                if (! empty($getcustomerdetails)) {
                                    $customer_name = $getcustomerdetails['name'];
                                }
                                $currency = $foreign_currency = '';
                                if (! empty($charge_ar)) {
                                    $foreign_currency = isset($charge_ar[0]['foreign_currency']) ? $charge_ar[0]['foreign_currency'] : "";
                                    $currency         = isset($charge_ar[0]['currency']) ? $charge_ar[0]['currency'] : "";
                                    $exchange_rate    = $charge_ar[0]['exchange_amount'];
                                    for ($c = 0; $c < count($charge_ar); $c++) {
                                        unset($charge_ar[$c]['foreign_currency']);
                                        unset($charge_ar[$c]['exchange_amount']);
                                        $charge_ar[$c]['rate_service_id']  = $rate_service_id;
                                        $charge_ar[$c]['rate_offering_id'] = $rate_offering;
                                        $charge_ar[$c]['rate_record_id']   = $rate_record;
                                        $charge_ar[$c]['source_created']   = 'RP - Rate Preference';
                                    }
                                }
                                $charge_ar_vas = [];
                                if (! empty($vascharges)) {
                                    foreach ($vascharges as $vas) {
                                        $vas_charge_id = $vas['charge_id'];
                                        if ($vas_charge_id != '0' && $vas_charge_id != "") {
                                            $getcharge_forlane = $ci->common->gettblrowdata(['id' => $vas_charge_id, 'status' => '1'], 'id,name', "tb_charge_codes", 0, 0);
                                            if (! empty($getcharge_forlane)) {
                                                $lane_chargerow_id = $getcharge_forlane['id'];
                                                $lane_chargename   = $getcharge_forlane['name'];
                                            }
                                        } else {
                                            $getcharge_forlane = $ci->common->gettblrowdata(['charge_code' => 'CSC', 'status' => '1'], 'id,name', "tb_charge_codes", 0, 0);
                                            if (! empty($getcharge_forlane)) {
                                                $lane_chargerow_id = $getcharge_forlane['id'];
                                                $lane_chargename   = $getcharge_forlane['name'];
                                            }
                                        }
                                        $charge_ar_vas[] = ['charge_code' => $lane_chargerow_id, 'description' => $lane_chargename, 'quantity_unit' => '1', 'value' => '1', 'rate_id' => $record_id, 'amount' => $vas['amount'], 'rate_service_id' => $rate_service_id, 'rate_offering_id' => $rate_offering, 'rate_record_id' => $rate_record, 'currency' => $vas['currency'], 'user_id' => $user_id, 'createdon' => $cdate, 'source_created' => 'RP - Rate Preference'];
                                    }
                                }
                                $revenue_ar = ['order_id' => $arr['order_id'], 'type' => '0', 'recipient_role' => 'Customer', 'recipient_code' => $arr['customer_id'], 'recipient_name' => $customer_name, 'debtor_jfr' => $debtor_jfr, 'invoice_number' => $invoice_number, 'credit_note_number' => $credit_note_number, 'invoice_date' => $invoice_date, 'invoice_creation_date' => $inv_createddate, 'invoice_receivdon_date' => $inv_receiveddate, 'amount' => '0', 'currency' => $currency, 'status' => 1, 'user_id' => $user_id, 'createdon' => $cdate, 'exchange_rate' => $exchange_rate, 'invoice_status' => $invoice_status, 'foreign_currency' => $foreign_currency];

                                $rev_row_id = $this->insertrecords($revenue_ar, $charge_ar, [], $charge_of_country, $charge_ar_vas);

                                if ($rate_record > 0 && $rev_row_id > 0) {
                                    $addfaf = $this->addfafcharges_toorder($arr['order_id'], $rev_row_id, $rate_record, 'RP - Rate Preference');
                                }

                                /* if($rate_autobill == '1'){
                                 $get_country = $ci->db->select('country_code,company_code')->get_where("tb_users",array('id'=>$user_id));
                                     $country_code  = $get_country->row()->country_code;
                                     $company_code  = $get_country->row()->company_code;
                                     $info = array('country_code'=>$country_code,'user_id'=>$user_id,'revnue_id'=>$rev_row_id,'order_id'=>$arr['order_id']);
                                     $debtor_jfr = generatedebitro_jfrcode($info);
                                     if($debtor_jfr != "" && $debtor_jfr != '0'){
                                         $curtz = $ci->session->userdata("usr_tzone")['timezone'];
                                         $cdate = date('Y-m-d H:i:s');
                                         $getactual = getdatetimebytimezone(DFLT_TZ,$cdate,$curtz);
                                         $update = $getactual['datetime'];
                                         $upd = $ci->common->updatetbledata("tb_reveneus",array('debtor_jfr'=>$debtor_jfr,'invoice_status'=>'1','debitor_time'=>$update),array('id'=>$rev_row_id));
                                     }
                                 }*/
                            }
                        }
                    }
                }
            }
        }
    }

    public function addfafcharges_toorder($order_id, $revenue_id, $rate_record_id, $source_created = null, $shift_id = "")
    {
        $ci       = &get_instance();
        $currency = $ci->session->userdata("usr_tzone")['currency'];
        if ($source_created == "") {
            $source_created = "AT - Apply Tariffs";
        }
        $cdate                = date('Y-m-d H:i:s');
        $user_id              = $ci->session->userdata('user_id');
        $raterecord           = $rate_record_id;
        $frt_chargecodeid     = 38;
        $getfrt_chargecode_id = $ci->common->gettblrowdata(["charge_code" => "FRT"], "id", "tb_charge_codes", 0, 0);
        if (! empty($getfrt_chargecode_id)) {
            $frt_chargecodeid = $getfrt_chargecode_id['id'];
        }
        $getfaf_chargecode_id = $ci->common->gettblrowdata(["charge_code" => "FAF"], "id,name", "tb_charge_codes", 0, 0);
        if (! empty($getfaf_chargecode_id)) {
            $getrate_id = $ci->common->gettblrowdata(['id' => $rate_record_id], "rate_id", "tb_rate_records", 0, 0);
            if (! empty($getrate_id)) {
                $raterecord = $getrate_id['rate_id'];
            }
            $faf_charge_id      = $getfaf_chargecode_id['id'];
            $faf_charge_name    = $getfaf_chargecode_id['name'];
            $record_percentage  = [];
            $getrate_recorddata = $ci->common->gettbldata(['raterecord_id' => $rate_record_id, 'rr_charge_id' => $faf_charge_id, 'charge_basis' => 'FRT', 'status' => '1'], 'percentage,fuel_surcharge_id', 'tb_raterecord_charges', 0, 0);
            if (! empty($getrate_recorddata)) {
                foreach ($getrate_recorddata as $rec) {
                    if ($rec['percentage'] > 0) {
                        $record_percentage[] = $rec['percentage'];
                    }
                    if ($rec['fuel_surcharge_id'] > 0) {
                        $row_id = $rec['fuel_surcharge_id'];
                        if (! empty($fuel_surcharge_id)) {
                            if (in_array($row_id, $fuel_surcharge_id)) {
                            } else {
                                $fuel_surcharge_id[] = $rec['fuel_surcharge_id'];
                            }
                        } else {
                            $fuel_surcharge_id[] = $rec['fuel_surcharge_id'];
                        }
                    }
                }
            }
            $amount = 0;
            if (! empty($fuel_surcharge_id)) {
                $fuel_surcharge_id = $ci->Orderrevenuesmodel->getactive_fuelsurcharge($fuel_surcharge_id);
            }
            if (! empty($record_percentage) || ! empty($fuel_surcharge_id)) {
                $ci->db->select("sum(amount) as amount");
                if (isset($shift_id) || $shift_id != "") {
                    $ci->db->from("trip_charges");
                } else {
                    $ci->db->from("tb_charges");
                }
                $ci->db->where("revenue_id='" . $revenue_id . "' AND charge_code ='" . $frt_chargecodeid . "' AND ( rate_id LIKE 'RR%' OR rate_id LIKE 'RT%' OR rate_id LIKE 'GT%' ) AND status='1'");
                $getcharges_fromrev = $ci->db->get();
                if ($getcharges_fromrev->num_rows() > 0) {
                    foreach ($getcharges_fromrev->result() as $res) {
                        $amount = $res->amount;
                    }
                    if ($amount > 0) {
                        if (! empty($fuel_surcharge_id)) {
                            $cdate            = date('Y-m-d');
                            $getallfafdetails = $ci->Orderrevenuesmodel->getfafdetailsbydate($fuel_surcharge_id, $cdate);
                            if (! empty($getallfafdetails)) {
                                foreach ($getallfafdetails as $per) {
                                    $faf_amount = $faf_percentage = 0;
                                    $faf_amount = $per['amount'];
                                    if ($faf_amount > 0) {
                                        $faf_currency = $per['currency'];
                                        if ($faf_currency == "") {
                                            $faf_currency = $currency;
                                        }
                                    } else {
                                        $faf_percentage = $per['percentage'];
                                        $faf_currency   = $currency;
                                    }
                                    if ($faf_percentage > 0) {
                                        $final_amount = $amount * ($faf_percentage / 100);
                                    } else {
                                        $final_amount = $faf_amount;
                                    }
                                    if ($faf_currency == $currency) {
                                        $local_amount = $final_amount;
                                    } else {
                                        $local_amount = 0;
                                    }
                                    $charges = ['revenue_id' => $revenue_id, 'charge_code' => $faf_charge_id, 'description' => $faf_charge_name, 'quantity_unit' => '1', 'value' => '1', 'rate_id' => $raterecord, 'amount' => $final_amount, 'currency' => $faf_currency, 'local_amount' => $local_amount, 'local_currency' => $currency, 'total_amount' => $final_amount, 'status' => '1', 'user_id' => $user_id, 'createdon' => $cdate, 'source_created' => $source_created];
                                    if (isset($shift_id) || $shift_id != "") {
                                        $ins     = $ci->common->insertTableData("trip_charges", $charges);
                                    } else {
                                        $ins     = $ci->common->insertTableData("tb_charges", $charges);
                                    }
                                }
                            }
                        }
                        if (! empty($record_percentage)) {
                            foreach ($record_percentage as $per) {
                                $final_amount = $amount * ($per / 100);
                                $charges      = ['revenue_id' => $revenue_id, 'charge_code' => $faf_charge_id, 'description' => $faf_charge_name, 'quantity_unit' => '1', 'value' => '1', 'rate_id' => $raterecord, 'amount' => $final_amount, 'currency' => $currency, 'local_amount' => $final_amount, 'local_currency' => $currency, 'total_amount' => $final_amount, 'status' => '1', 'user_id' => $user_id, 'createdon' => $cdate, 'source_created' => $source_created];
                                if (isset($shift_id) || $shift_id != "") {
                                    $ins = $ci->common->insertTableData("trip_charges", $charges);
                                } else {
                                    $ins = $ci->common->insertTableData("tb_charges", $charges);
                                }
                            }
                        }
                    }
                }
                $rev_ids[] = $revenue_id;
                $ci->vatcalculationtorate->updatevattorevenues($rev_ids, $order_id, $shift_id);
                $upd_utilized_amount = $this->updateutilizedamount_fororder($order_id);
            }
        }
    }

    public function getraterecordcharges($offering, $record, $type, $order_id, $record_id, $user_id, $legsLocation = [])
    {

        $ci = &get_instance();

        $exchange_amount  = $total_amount  = $unit2  = $final_conversion  = 0;
        $charge_ar        = [];
        $foreign_currency = "";
        $cdate            = date('Y-m-d H:i:s');
        $company_code     = $ci->session->userdata('company_code');
        $user_currency    = $ci->session->userdata("usr_tzone")['currency'];
        $where            = ['raterecord_id' => $record, 'status' => '1'];
        $select           = "rr_charge_type,rr_tier_id,geo_tier_id,rr_charge_id,charge_basis,exchange_rate_id,min_amount,amount,currency";
        $table            = "tb_raterecord_charges";
        $getrecords       = $ci->common->gettbldata($where, $select, $table, 0, 0);
        if (! empty($getrecords)) {
            foreach ($getrecords as $res) {
                $unit2            = 1;
                $tier_ar          = $geo_tier_ar          = [];
                $charge_id        = $res['rr_charge_id'];
                $rr_charge_type   = $res['rr_charge_type'];
                $geo_tier_id      = $res['geo_tier_id'];
                $tier_id          = $res['rr_tier_id'];
                $min_amount       = $res['min_amount'];
                $amount           = $res['amount'];
                $total_amount     = $amount;
                $currency         = $res['currency'];
                $exchange_rate_id = $res['exchange_rate_id'];
                $charge_basis     = strtoupper($res['charge_basis'] ?? "");
                $getchargeid      = $ci->common->gettblrowdata(['id' => $charge_id], 'charge_code', 'tb_charge_codes', 0, 0);
                $fafcharge_code   = "";
                if (! empty($getchargeid)) {
                    $fafcharge_code = $getchargeid['charge_code'];
                }
                if (trim($rr_charge_type) == "FIXED" && trim($fafcharge_code) == "FAF" && trim($charge_basis) == "FRT") {
                } else {
                    if ($exchange_rate_id != "0" && $exchange_rate_id != "") {
                        if ($company_code != "PLKN") {
                            if ($user_currency != $currency) {
                                $info             = ['exchange_rate_id' => $exchange_rate_id, 'from_currency' => $currency, 'to_currency' => $user_currency, 'user_id' => $user_id, 'order_id' => $order_id];
                                $exchange_amount  = $this->getexchnageamountfromcurrency($info);
                                $foreign_currency = $currency;
                            }

                        } else {
                            $foreign_currency = "EUR";
                            $info             = ['exchange_rate_id' => $exchange_rate_id, 'from_currency' => $currency, 'to_currency' => $user_currency, 'user_id' => $user_id, 'order_id' => $order_id];
                            $exchange_amount  = $this->getexchnageamountfromcurrency($info);
                        }

                    }
                    if ($exchange_amount == 0 && $currency != $user_currency) {
                        $getOrderDate = $ci->common->gettblrowdata(['id' => $order_id], "createdon", "tb_orders", 0, 0);
                        $ci->load->model('rateenquirymodel');
                        $query            = $ci->rateenquirymodel->getExchangeRateAmountFromUser(['userId' => $user_id, 'currency' => $currency, 'userCurrency' => $user_currency, 'currentDate' => $getOrderDate['createdon'] ?? date('y-m-d')]);
                        $exchange_rate_id = $query->num_rows() > 0 ? $query->row()->id : 0;
                        $exchange_amount  = $query->num_rows() > 0 ? $query->row()->exchange_rate : 0;
                    }
                    $charge_basis = strtoupper($res['charge_basis'] ?? "");
                    if ($charge_basis == "PER KG" || $charge_basis == 'KG' || $charge_basis == 'PER CBM' || $charge_basis == 'CBM' || $charge_basis == 'LDM' || $charge_basis == 'PER LDM' || $charge_basis == 'PIECE COUNT' || $charge_basis == 'GOODS VALUE') {
                        if ($order_id != '0' && $order_id != "") {
                            $unit_ar = $this->claculateperkgamount($offering, $order_id, $user_id, $type, $amount, $charge_basis, 'non-vas');
                            if (! empty($unit_ar)) {
                                $final_conversion = isset($unit_ar['final_conversion']) ? $unit_ar['final_conversion'] : '0';
                            }
                            if ($final_conversion > 0) {
                                $unit2 = $final_conversion;
                            } else {
                                $getorderdetails = $ci->Orderrevenuesmodel->getallordercargodetails($order_id);
                                if (! empty($getorderdetails)) {
                                    if ($charge_basis == 'PER KG' || $charge_basis == 'KG') {
                                        $unit2 = $getorderdetails['total_weight'];
                                    } else if ($charge_basis == 'PER LDM' || $charge_basis == 'LDM') {
                                        $unit2 = $getorderdetails['total_ldm'];
                                    } else if ($charge_basis == 'PER CBM' || $charge_basis == 'CBM') {
                                        $unit2 = $getorderdetails['total_volume'];
                                    } else if ($charge_basis == 'GOODS VALUE') {
                                        $unit2 = $getorderdetails['goods_value'];
                                    }
                                }
                            }
                        }
                    }
                    $total_amount = $unit2 * $total_amount;
                    if ($total_amount < $min_amount) {
                        $total_amount = $min_amount;
                    }
                    $charge_name = "";
                    if ($charge_id != "" && $charge_id != '0') {
                        $getcharge_name = $ci->common->gettblrowdata(['id' => $charge_id], "name", "tb_charge_codes", 0, 0);
                        if (! empty($getcharge_name)) {
                            $charge_name = $getcharge_name['name'];
                        }
                    } else {
                        $charge_id   = "38";
                        $charge_name = "Freight Charges";
                    }
                    if ($tier_id != "" && $tier_id != '0') {
                        $tier_ar = $this->getratechargeamount_bytier($offering, $tier_id, $order_id, $type, $user_id);
                        if (! empty($tier_ar)) {
                            $record_id    = $tier_ar['tier_id'];
                            $total_amount = $tier_ar['cost'];
                            $currency     = $tier_ar['currency'];
                            if ($currency != "") {
                                if (is_numeric($currency)) {
                                    $currency = $user_currency;
                                } else {
                                    $currency = $currency;
                                }
                                if ($company_code == 'PLKN') {
                                    $user_currency = 'PLN';
                                }
                                $foreign_currency = "";
                                if ($user_currency != $currency) {
                                    $currency         = $user_currency;
                                    $foreign_currency = $currency;
                                }
                            }
                        }
                    }
                    $amount_ar = [];
                    if ($geo_tier_id != "" && $geo_tier_id != '0') {
                        $geo_tier_ar = $this->getratechargeamount_bygeotier($offering, $geo_tier_id, $order_id, $type, $legsLocation);
                        if (! empty($geo_tier_ar)) {
                            $record_id = $geo_tier_ar['geo_tier_id'];
                            $amount_ar = $geo_tier_ar['cost'];
                            if (! empty($amount_ar)) {
                                $total_amount = isset($amount_ar['cost']) ? $amount_ar['cost'] : "";
                                $min_amount   = isset($amount_ar['min_amount']) ? $amount_ar['min_amount'] : "";
                                $currency     = isset($amount_ar['currency']) ? $amount_ar['currency'] : "";
                                if ($currency == "") {
                                    $currency = $user_currency;
                                }
                                if ($min_amount > $total_amount) {
                                    $total_amount = $min_amount;
                                }
                                if ($company_code == 'PLKN') {
                                    $user_currency = 'PLN';
                                }
                                $foreign_currency = "";
                                if ($user_currency != $currency) {
                                    $currency         = $user_currency;
                                    $foreign_currency = $currency;
                                }
                            }
                        }
                    }
                    if ($rr_charge_type == 'Fixed') {
                        $getraterecord_id = $ci->common->gettblrowdata(['id' => $record, 'status' => '1'], 'rate_id', "tb_rate_records", 0, 0);
                        if (! empty($getraterecord_id)) {
                            $record_id = $getraterecord_id['rate_id'];
                        }
                    }
                    if ($total_amount != '0') {
                        $charge_ar[] = ['charge_code' => $charge_id, 'description' => $charge_name, 'quantity_unit' => '1', 'value' => '1', 'rate_id' => $record_id, 'amount' => $total_amount, 'currency' => $currency, 'foreign_currency' => $foreign_currency, 'user_id' => $user_id, 'createdon' => $cdate, 'exchange_amount' => $exchange_amount];
                    }
                }

            }
        }
        return $charge_ar;

    }
    /* check and or conditions for reference */
    public function checkrefandorcondition($order_id, $record)
    {
        $ci = &get_instance();
        if ($order_id != "" && $order_id > 0) {
            $noand    = $noor    = 1;
            $orwhr    = $andwhr    = "";
            $orar     = $andar     = [];
            $refcheck = 1;
            if ($record > 0) {
                $andcond = $orcond = $refcheknum_rows = $andrecordmatch = $orrecordmatch = 0;
                $chkref  = $ci->common->gettbldata(['rate_record_id' => $record, 'status' => '1'], "ref_id,ref_name,ref_value,condition_type", "tb_raterecord_conditions", 0, 0);
                if (! empty($chkref)) {
                    $chkref_count    = count($chkref);
                    $refcheck        = 0;
                    $refcheknum_rows = $andcond = $orcond = 1;
                    $a               = 0;
                    foreach ($chkref as $ref) {
                        $condition_type = $ref['condition_type'];
                        $ref_pid        = $ref['ref_id'];
                        $ref_value      = $ref['ref_value'];
                        if ($chkref_count == 1) {
                            $condition_type = 'AND';
                        }
                        if ($condition_type == "AND") {
                            $noand   = 0;
                            $andar[] = ['ref_id' => $ref_pid, 'ref_value' => $ref_value];
                            $a++;
                        } else if ($condition_type == 'OR') {
                            $noor   = 0;
                            $orar[] = ['ref_id' => $ref_pid, 'ref_value' => $ref_value];
                        }
                    }
                    if (! empty($andar)) {
                        $andwhr .= " AND ( ";
                        for ($i = 0; $i < count($andar); $i++) {
                            if ($i == 0) {
                                $ref_pid   = $andar[0]['ref_id'];
                                $ref_value = $andar[0]['ref_value'];
                                $andwhr .= "( r.id='" . $ref_pid . "' AND o.reference_id = r.name AND o.ref_value='" . $ref_value . "' AND o.status ='1' ) ";
                            } else {
                                $ref_pid   = $andar[$i]['ref_id'];
                                $ref_value = $andar[$i]['ref_value'];
                                $andwhr .= " OR ( r.id='" . $ref_pid . "' AND o.reference_id = r.name AND o.ref_value='" . $ref_value . "' AND o.status ='1' ) ";
                            }
                        }
                        $andwhr .= " ) ";
                    }
                    if (! empty($orar)) {
                        if (count($orar) > 1) {
                            $orwhr .= " AND ( ";
                            for ($i = 0; $i < count($orar); $i++) {
                                if ($i == 0) {
                                    $ref_pid   = $orar[0]['ref_id'];
                                    $ref_value = $orar[0]['ref_value'];
                                    $orwhr .= "( r.id='" . $ref_pid . "' AND o.reference_id = r.name AND o.ref_value='" . $ref_value . "' AND o.status ='1' ) ";
                                } else {
                                    $ref_pid   = $orar[$i]['ref_id'];
                                    $ref_value = $orar[$i]['ref_value'];
                                    $orwhr .= " OR ( r.id='" . $ref_pid . "' AND o.reference_id = r.name AND o.ref_value='" . $ref_value . "' AND o.status ='1' ) ";
                                }
                            }
                            $orwhr .= " ) ";
                        } else {
                            $noor = 1;
                        }
                    }
                    if ($refcheknum_rows > 0) {
                        if ($andcond == 1) {
                            if ($andwhr != "") {
                                $andrecordmatch = $ci->Orderrevenuesmodel->checkandorconditionforref($order_id, $andwhr);
                                if ($andrecordmatch == $a) {
                                    $andrecordmatch = 1;
                                } else {
                                    $andrecordmatch = 0;
                                }
                            } else {
                                if ($noand == 1) {
                                    $andrecordmatch = 1;
                                } else {
                                    $andrecordmatch = 0;
                                }
                            }
                        } else {
                            $andrecordmatch = 0;
                        }
                        if ($orcond == 1) {
                            if ($orwhr != "") {
                                $orrecordmatch = $ci->Orderrevenuesmodel->checkandorconditionforref($order_id, $orwhr);
                            } else {
                                if ($noor == 1) {
                                    $orrecordmatch = 1;
                                } else {
                                    $orrecordmatch = 0;
                                }
                            }
                        } else {
                            $orrecordmatch = 0;
                        }
                    }
                    if ($orrecordmatch > 0 && $andrecordmatch > 0) {
                        $refcheck = 1;
                    } else {
                        $refcheck = 0;
                    }
                } else {
                    $refcheck = 1;
                }
            }
        }
        return $refcheck;
    }

    /*Get amount from geo tier */
    public function getratechargeamount_bygeotier($offering, $tier_row_id, $order_id, $type, $legsLocation = [])
    {
        $geo_from         = $geo_to         = "";
        $cost             = $tier_id             = 0;
        $currency         = "";
        $vehicle_type     = 0;
        $converted_weight = $unit2 = $total_cost = 0;
        $ci               = &get_instance();
        $cost             = $min_amount             = $flat             = 0;
        $where            = ['id' => $tier_row_id, 'status' => '1'];
        $select           = "geo_tier_id,uom1,unit_measure1,currency,geo_hierarchy,vehicle_type,flat";
        $table            = "tb_geo_tier";
        $gettierdetails   = $ci->common->gettblrowdata($where, $select, $table, 0, 0);
        if (! empty($gettierdetails)) {
            $tier_id       = $gettierdetails['geo_tier_id'];
            $currency      = $gettierdetails['currency'];
            $flat          = $gettierdetails['flat'];
            $vehicle_type  = $gettierdetails['vehicle_type'];
            $unit_measure2 = strtoupper($gettierdetails['unit_measure1']);
            $uom2          = strtoupper($gettierdetails['uom1']);
            $geo_hierarchy = strtoupper($gettierdetails['geo_hierarchy']);

            $total_weight = $total_volume = $second_weight = $second_volume = $total_quantity = 0;
            $weight_unit  = $secondweight_uom  = $fromLatitude  = $fromLongitude  = $toLatitude  = $toLongitude  = "";
            $shift_id     = 0;
            if (empty($legsLocation)) {
                $geo_select = "pickup_country as pickup,delivery_country as delivery,plat,plng,dlat,dlng,shift_id";
                if ($geo_hierarchy == 'CITY') {
                    $geo_select = "pickup_city as pickup,delivery_city as delivery,plat,plng,dlat,dlng,shift_id";
                } elseif ($geo_hierarchy == 'PROVINCE') {
                    $geo_select = "pickup_address2 as pickup,delivery_address2 as delivery,plat,plng,dlat,dlng,shift_id";
                } elseif ($geo_hierarchy == 'POSTAL CODE') {
                    $geo_select = "pickup_pincode as pickup,delivery_pincode as delivery,plat,plng,dlat,dlng,shift_id";
                }
                $getorderaddress = $ci->common->gettblrowdata(['id' => $order_id], $geo_select, "tb_orders", 0, 0);
                if (! empty($getorderaddress)) {
                    $geo_from      = trim($getorderaddress['pickup']);
                    $geo_to        = trim($getorderaddress['delivery']);
                    $shift_id      = trim($getorderaddress['shift_id']);
                    $fromLatitude  = $getorderaddress['plat'];
                    $fromLongitude = $getorderaddress['plat'];
                    $toLatitude    = $getorderaddress['plat'];
                    $toLongitude   = $getorderaddress['plat'];
                }
            } else {
                $shift_id = $legsLocation['shiftId'];
                $pickup   = $legsLocation['pickup'];
                $delivery = $legsLocation['delivery'];
                $geo_from = $pickup['country'];
                $geo_to   = $delivery['country'];
                if ($geo_hierarchy == 'CITY') {
                    $geo_from = $pickup['city'];
                    $geo_to   = $delivery['city'];
                } elseif ($geo_hierarchy == 'PROVINCE') {
                    $geo_from = $pickup['state'];
                    $geo_to   = $delivery['state'];
                } elseif ($geo_hierarchy == 'POSTAL CODE') {
                    $geo_from = $pickup['pincode'];
                    $geo_to   = $delivery['pincode'];
                }
            }
            $getcargodetails = $ci->db->query("SELECT sum(o.weight) as weight,sum(o.second_weight) as second_weight,sum(o.volume) as volume,sum(o.second_volume) as second_volume,sum(o.quantity) as total_quantity,c.weight_unit,c.secondweight_uom,o2.goods_value FROM tb_cargo_details c,tb_order_cargodetails o JOIN tb_orders o2 ON o.order_id = o2.id WHERE o.cargo_id=c.id AND o.order_id ='" . $order_id . "' AND o.status='1'");
            if ($getcargodetails->num_rows() > 0) {
                $total_weight     = $getcargodetails->row()->weight;
                $total_volume     = $getcargodetails->row()->volume;
                $second_volume    = $getcargodetails->row()->second_volume;
                $second_weight    = $getcargodetails->row()->second_weight;
                $total_quantity   = $getcargodetails->row()->total_quantity;
                $weight_unit      = strtoupper($getcargodetails->row()->weight_unit);
                $secondweight_uom = strtoupper($getcargodetails->row()->secondweight_uom);
                $goods_value      = strtoupper($getcargodetails->row()->goods_value);
            }
            if ($total_weight == "") {
                $total_weight = 0;
            }
            if ($total_volume == "") {
                $total_volume = 0;
            }
            if ($second_volume == "") {
                $second_volume = 0;
            }
            if ($second_weight == "") {
                $second_weight = 0;
            }
            if ($total_quantity == "") {
                $total_quantity = 0;
            }
            if ($uom2 == 'WEIGHT') {
                if ($second_weight > 0) {
                    $converted_weight = $this->weightunitsconversion($second_weight, "", $uom2, "", $unit_measure2, $secondweight_uom);
                    $unit2            = $converted_weight;
                }
            }
            if ($uom2 == 'ACTUAL WEIGHT') {
                if ($total_weight > 0) {
                    $converted_weight = $this->weightunitsconversion($total_weight, "", "WEIGHT", "", $unit_measure2, $weight_unit);
                    $unit2            = $converted_weight;
                }
            }
            if ($uom2 == 'VOLUME') {
                $unit2 = $second_volume;
            }
            if ($uom2 == 'ACTUAL VOLUME') {
                $unit2 = $total_volume;
            }
            if ($uom2 == 'QUANTITY') {
                $unit2 = $total_quantity;
            }

            if ($uom2 == 'GOODS VALUE') {
                $unit2 = $goods_value;
            }
            $trip_vehicletype = "";
            if ($vehicle_type != "" && $vehicle_type != "0") {
                if ($shift_id != "" && $shift_id != "0") {
                    $gettripvehicletype = $ci->common->gettblrowdata(['id' => $shift_id], "vehicle_type", "tb_shifts", 0, 0);
                    if (! empty($gettripvehicletype)) {
                        $trip_vehicletype = $gettripvehicletype['vehicle_type'];
                    }
                    $vehicle_typename = "";
                    if ($trip_vehicletype != "") {
                        $getvehicletypename = $ci->common->gettblrowdata(['id' => $vehicle_type], "trucktype", "tb_trucktypes", 0, 0);
                        if (! empty($getvehicletypename)) {
                            $vehicle_typename = $getvehicletypename['trucktype'];
                        }
                        if ($vehicle_typename == $trip_vehicletype) {
                            if ($unit_measure2 == 'KG' || $unit_measure2 == 'LDM' || $unit_measure2 == 'CBM' || $unit_measure2 == 'PIECE COUNT' || $this->is_currency_valid($unit_measure2)) {
                                $user_id = $ci->session->userdata('user_id');
                                $unit_ar = $this->claculateperkgamount($offering, $order_id, $user_id, $type, $cost, $unit_measure2, 'non-vas');
                                if (! empty($unit_ar)) {
                                    $final_conversion = isset($unit_ar['final_conversion']) ? $unit_ar['final_conversion'] : '0';
                                    if ($final_conversion > 0) {
                                        $unit2 = $final_conversion;
                                    }
                                }
                                $cost_ar = $this->getgeotierunitcharges($tier_row_id, $geo_from, $geo_to, $unit2);
                                if (! empty($cost_ar)) {
                                    $cost = isset($cost_ar['cost']) ? $cost_ar['cost'] : "0";
                                    if ($flat == "1") {
                                        $total_cost = $cost;
                                    } else {
                                        $total_cost = $cost * $unit2;
                                    }

                                    $geo_min_amount = isset($cost_ar['min_amount']) ? $cost_ar['min_amount'] : "0";
                                    if ($geo_min_amount > 0) {
                                        if ($geo_min_amount > $total_cost) {
                                            $total_cost = $geo_min_amount;
                                        }
                                    }

                                }
                            }
                        }
                    }
                }
            } else {
                $cost = 0;
                if (in_array($unit_measure2, ['KG', 'LDM', 'CBM', 'PIECE COUNT', 'KM', 'MI']) || $this->is_currency_valid($unit_measure2)) {
                    $user_id = $ci->session->userdata('user_id');
                    $unit_ar = $this->claculateperkgamount($offering, $order_id, $user_id, $type, '0', $unit_measure2, 'non-vas');
                    if (! empty($unit_ar)) {
                        $final_conversion = isset($unit_ar['final_conversion']) ? $unit_ar['final_conversion'] : '0';
                        if ($final_conversion > 0) {
                            $unit2 = $final_conversion;
                        }
                    }
                    if (in_array($unit_measure2, ['KM', 'MI'])) {
                        $response = distanceship($fromLatitude, $fromLongitude, $toLatitude, $toLongitude);
                        if ($response['distance'] == "") {
                            $response = distancemetrixship($fromLatitude, $fromLongitude, $toLatitude, $toLongitude);
                        }
                        if ($response['disttext'] != "") {
                            $distanceArray = explode(" ", $response['disttext']);
                            $distance      = $distanceArray[0] ?? 0;
                            if ($unit_measure2 == "KM") {
                                $unit2 = $distance;
                            } else {
                                $unit2 = $distance * .621371;
                            }
                        }
                    }
                    $cost_ar = $this->getgeotierunitcharges($tier_row_id, $geo_from, $geo_to, $unit2);
                    if (! empty($cost_ar)) {
                        $cost = isset($cost_ar['cost']) ? $cost_ar['cost'] : "0";
                        if ($flat == "1") {
                            $total_cost = $cost;
                        } else {
                            //$total_cost = $cost * $unit2;
                            $total_cost = floatval($cost) * floatval($unit2);
                        }

                        $geo_min_amount = isset($cost_ar['min_amount']) ? $cost_ar['min_amount'] : "0";
                        if ($geo_min_amount > 0) {
                            if ($geo_min_amount > $total_cost) {
                                $total_cost = $geo_min_amount;
                            }
                        }

                    }
                }
            }
        }
        $cost_ar['cost'] = $total_cost;
        $res             = ['cost' => $cost_ar, 'geo_tier_id' => $tier_id, 'currency' => $currency];
        return $res;

    }
    /*get */
    /*Get amount from rate tier */
    public function getratechargeamount_bytier($offering, $tier_row_id, $order_id, $type, $user_id)
    {

        $total_ldm        = $second_volume        = $second_weight        = $total_weight        = $total_volume        = $cost        = $tier_id        = $unit2        = 0;
        $secondweight_uom = $weight_unit = $utype2 = $utype1 = $currency = "";
        $unit_ar          = [];
        $ci               = &get_instance();
        $where            = ['id' => $tier_row_id, 'status' => '1'];
        $select           = "tier_id,tier_name,uom1,unit_measure1,uom2,unit_measure2,currency,billing_uom";
        $table            = "tb_tier_master";
        $gettierdetails   = $ci->common->gettblrowdata($where, $select, $table, 0, 0);
        if (! empty($gettierdetails)) {
            $uom1            = $gettierdetails['uom1'];
            $currency        = $gettierdetails['currency'];
            $tier_id         = $gettierdetails['tier_id'];
            $billing_uom     = $gettierdetails['billing_uom'];
            $unit_measure1   = strtoupper($gettierdetails['unit_measure1']);
            $uom2            = $gettierdetails['uom2'];
            $unit_measure2   = strtoupper($gettierdetails['unit_measure2']);
            $getorderdetails = $ci->Orderrevenuesmodel->getallordercargodetails($order_id);
            if (! empty($getorderdetails)) {
                $total_ldm        = $getorderdetails['total_ldm'];
                $second_volume    = $getorderdetails['second_volume'];
                $second_weight    = $getorderdetails['second_weight'];
                $total_weight     = $getorderdetails['total_weight'];
                $total_volume     = $getorderdetails['total_volume'];
                $secondweight_uom = $getorderdetails['secondweight_uom'];
                $weight_unit      = $getorderdetails['weight_unit'];
            }
            $converted_weight       = $this->weightunitsconversion($total_weight, $uom1, $uom2, $unit_measure1, $unit_measure2, $weight_unit);
            $converted_secondweight = $this->weightunitsconversion($second_weight, $uom1, $uom2, $unit_measure1, $unit_measure2, $secondweight_uom);
            if ($uom1 == "ACTUAL WEIGHT") {
                $utype1 = $converted_weight;
            }
            if ($uom1 == "WEIGHT") {
                $utype1 = $converted_secondweight;
            }
            if ($uom1 == "ACTUAL VOLUME") {
                $utype1 = $total_volume;
            }
            if ($uom1 == "VOLUME") {
                $utype1 = $second_volume;
            }
            if ($uom1 == "LDM") {
                $utype1 = $total_ldm;
            }
            if ($uom2 == "ACTUAL WEIGHT") {
                $utype2 = $converted_weight;
            }
            if ($uom2 == "WEIGHT") {
                $utype2 = $converted_secondweight;
            }
            if ($uom2 == "ACTUAL VOLUME") {
                $utype2 = $total_volume;
            }
            if ($uom2 == "VOLUME") {
                $utype2 = $second_volume;
            }
            if ($uom2 == "LDM") {
                $utype2 = $total_ldm;
            }

            if ($billing_uom == 'WEIGHT') {
                $unit2   = $second_weight;
                $unit_ar = $this->claculateperkgamount($offering, $order_id, $user_id, $type, $cost, $secondweight_uom, 'non-vas');
            } else if ($billing_uom == 'VOLUME') {
                $unit2   = $second_volume;
                $unit_ar = $this->claculateperkgamount($offering, $order_id, $user_id, $type, $cost, 'CBM', 'non-vas');
            } else if ($billing_uom == 'LDM') {
                $unit2   = $total_ldm;
                $unit_ar = $this->claculateperkgamount($offering, $order_id, $user_id, $type, $cost, 'LDM', 'non-vas');
            } else if ($billing_uom == 'ACTUAL WEIGHT') {
                $unit2   = $total_weight;
                $unit_ar = $this->claculateperkgamount($offering, $order_id, $user_id, $type, $cost, $weight_unit, 'non-vas');
            } else if ($billing_uom == 'ACTUAL VOLUME') {
                $unit2   = $total_volume;
                $unit_ar = $this->claculateperkgamount($offering, $order_id, $user_id, $type, $cost, 'LDM', 'non-vas');
            }
            if (! empty($unit_ar)) {
                $final_conversion = isset($unit_ar['final_conversion']) ? $unit_ar['final_conversion'] : '0';
                if ($final_conversion > 0) {
                    $unit2 = $final_conversion;
                }
            }
            if ($uom1 == $billing_uom) {
                $utype1 = $unit2;
            }
            if ($uom2 == $billing_uom) {
                $utype2 = $unit2;
            }
            if (in_array($unit_measure1, ['KM', 'MI']) || in_array($unit_measure2, ['KM', 'MI'])) {
                $getOrderLatlngs = $ci->common->gettblrowdata(['id' => $order_id], "plat,plng,dlat,dlng", "tb_orders", 0, 0);
                $fromLatitude    = $getOrderLatlngs['plat'];
                $fromLongitude   = $getOrderLatlngs['plng'];
                $toLatitude      = $getOrderLatlngs['dlat'];
                $toLongitude     = $getOrderLatlngs['dlng'];
                $response        = distanceship($fromLatitude, $fromLongitude, $toLatitude, $toLongitude);
                if ($response['distance'] == "") {
                    $response = distancemetrixship($fromLatitude, $fromLongitude, $toLatitude, $toLongitude);
                }
                if ($response['disttext'] != "") {
                    $distanceArray = explode(" ", $response['disttext']);
                    $distance      = $distanceArray[0] ?? 0;
                    if ($unit_measure1 == "KM") {
                        $utype1 = $distance;
                    } elseif ($unit_measure1 == "MI") {
                        $utype1 = $distance * .621371;
                    }
                    if ($unit_measure2 == "KM") {
                        $utype2 = $distance;
                    } elseif ($unit_measure2 == "MI") {
                        $utype2 = $distance * .621371;
                    }
                }
            }
            if ($utype1 > 0 && $utype2 > 0) {
                $cost = $this->getweightvolumecharges($tier_row_id, $utype1, $utype2);
            }
            $cost = $unit2 * $cost;
        }

        $res = ['cost' => $cost, 'tier_id' => $tier_id, 'currency' => $currency];
        return $res;

    }

    public function weightunitsconversion($total_weight, $uom1, $uom2, $unit_measure1, $unit_measure2, $weight_unit)
    {

        $converted_weight = 1;
        if (strtoupper($weight_unit) == 'KG') {
            if (strtoupper($uom1) == 'WEIGHT') {
                if ($unit_measure1 == 'KG') {
                    $converted_weight = $total_weight;
                } else if (strtoupper($unit_measure1) == 'LB') {
                    $converted_weight = ($total_weight * 2.2046);
                } else if ((strtoupper($unit_measure1) == 'TON') || (strtoupper($unit_measure1) == 'MTON')) {
                    $converted_weight = ($total_weight * 0.001);
                }
            } else if (strtoupper($uom2) == 'WEIGHT') {
                if (strtoupper($unit_measure2) == 'KG') {
                    $converted_weight = $total_weight;
                } else if (strtoupper($unit_measure2) == 'LB') {
                    $converted_weight = ($total_weight * 2.2046);
                } else if ((strtoupper($unit_measure2) == 'TON') || (strtoupper($unit_measure2) == 'MTON')) {
                    $converted_weight = ($total_weight * 0.001);
                }
            }
        } else if (strtoupper($weight_unit) == 'TON') {
            if (strtoupper($uom1) == 'WEIGHT') {
                if (strtoupper($unit_measure1) == 'KG') {
                    $converted_weight = ($total_weight * 1000);
                } else if (strtoupper($unit_measure1) == 'LB') {
                    $converted_weight = ($total_weight * 2204);
                } else if ((strtoupper($unit_measure1) == 'TON') || (strtoupper($unit_measure1) == 'MTON')) {
                    $converted_weight = $total_weight;
                }
            } else if (strtoupper($uom2) == 'WEIGHT') {
                if (strtoupper($unit_measure2) == 'KG') {
                    $converted_weight = ($total_weight * 1000);
                } else if (strtoupper($unit_measure2) == 'LB') {
                    $converted_weight = ($total_weight * 2204);
                } else if ((strtoupper($unit_measure2) == 'TON') || (strtoupper($unit_measure2) == 'MTON')) {
                    $converted_weight = $total_weight;
                }
            }
        }
        return $converted_weight;
    }
    public function getweightvolumecharges($tier_id, $uom1, $uom2)
    {
        $cost       = 0;
        $ci         = &get_instance();
        $getcharges = $ci->db->query("SELECT cost FROM tb_tier_rate_sheet WHERE tier_master_id='" . $tier_id . "' AND uom1_min <= '" . $uom1 . "' AND uom1_max >='" . $uom1 . "' AND uom2_min <= '" . $uom2 . "' AND uom2_max >= '" . $uom2 . "'");
        if ($getcharges->num_rows() > 0) {
            $cost = $getcharges->row()->cost;
        }
        return $cost;
    }
    public function getgeotierunitcharges($tier_id, $geo_from, $geo_to, $unit2)
    {
        $cost     = $uom1_minimum     = 0;
        $response = [];
        $ci       = &get_instance();
        if ($geo_from != "" && $geo_to != "") {
            if ($unit2 != "" && $unit2 > 0) {
                $getcharges = $ci->db->query("SELECT cost FROM tb_geo_tier_sheet WHERE geo_tier_id='" . $tier_id . "' AND geo_from LIKE '" . $geo_from . "' AND geo_to LIKE '" . $geo_to . "' AND uom1_min <= '" . $unit2 . "' AND uom1_max >='" . $unit2 . "' AND status ='1'");
                if ($getcharges->num_rows() > 0) {
                    $cost             = $getcharges->row()->cost;
                    $getminimumamount = $ci->db->query("SELECT cost FROM tb_geo_tier_sheet WHERE geo_tier_id='" . $tier_id . "' AND geo_from LIKE '" . $geo_from . "' AND geo_to LIKE '" . $geo_to . "' AND uom1_minimum <> '0' AND status ='1'");
                    if ($getminimumamount->num_rows() > 0) {
                        $uom1_minimum = $getminimumamount->row()->cost;
                    }
                }
                $response = ['cost' => $cost, 'min_amount' => $uom1_minimum];
            }
        }
        return $response;
    }

    public function getexchnageamountfromcurrency($info)
    {
        $ci                   = &get_instance();
        $exchange_rate_amount = 0;
        $order_createddate    = date('Y-m-d');
        $order_customer       = "0";
        $company_code         = $ci->session->userdata('company_code');
        $branch_code          = $ci->session->userdata('branch_code');
        $curtz                = $ci->session->userdata("usr_tzone")['timezone'];
        if ($company_code == "PLKN") {
            $info['to_currency'] = 'PLN';
        }
        if (! empty($info)) {
            $order_id = $info['order_id'];
            if ($order_id != "" && $order_id != "0") {
                $getorderdate = $ci->common->gettblrowdata(['id' => $order_id, 'user_id' => $info['user_id']], "pickup_datetime,customer_id,company_code,branch_code,createdon", "tb_orders", 0, 0);
                if (! empty($getorderdate)) {
                    $order_createddate = date('Y-m-d', strtotime($getorderdate['createdon']));
                    if ($getorderdate['pickup_datetime'] != "" && $getorderdate['pickup_datetime'] != "0000-00-00 00:00:00") {
                        $pdates            = getdatetimebytimezone($curtz, $getorderdate['pickup_datetime'], DFLT_TZ);
                        $early_pdate       = $pdates['datetime'];
                        $order_createddate = date('Y-m-d', strtotime($early_pdate));
                    }
                    $order_customer = $getorderdate['customer_id'];
                    $company_code   = $getorderdate['company_code'];
                    $branch_code    = $getorderdate['branch_code'];
                }
                if ($info['to_currency'] != "" && $info['from_currency'] != "") {
                    $info['customer_id']       = $order_customer;
                    $info['company_code']      = $company_code;
                    $info['branch_code']       = $branch_code;
                    $info['order_createddate'] = $order_createddate;

                }
            }
            $exchange_rate_amount = $ci->Orderrevenuesmodel->getexchangerateamount_fororder($info);
        }
        return $exchange_rate_amount;

    }
    public function updateutilizedamount_fororder($order_id)
    {
        $ci                          = &get_instance();
        $limit_orders                = [];
        $creditlimit_currency_amount = "";
        $session_currency            = $ci->session->userdata("usr_tzone")['currency'];
        $session_company             = $ci->session->userdata('company_code');
        $credit_limit                = $credit_limit_amount                = $credit_utilized_amount                = $total_amount                = $party_master_id                = $exchange_rate_amount                = $final_amount                = 0;
        $credit_currency             = "";
        if ($order_id != "0" && $order_id != "") {
            $getcustomerdetails = $ci->common->gettblrowdata(['id' => $order_id], "customer_id,user_id", "tb_orders", 0, 0);
            if (! empty($getcustomerdetails)) {
                $customer_id = $getcustomerdetails['customer_id'];
                $user_id     = $getcustomerdetails['user_id'];
                if ($customer_id != "" && $customer_id != "0") {
                    $getlimitamount = $ci->db->query("SELECT m.id,m.credit_limit,m.credit_limit_amount,m.credit_currency,m.credit_utilized_amount FROM tbl_party_master m,tb_customers c WHERE c.id ='" . $customer_id . "' AND c.code =m.code AND c.user_id =m.user_id and m.user_id ='" . $user_id . "'");
                    if ($getlimitamount->num_rows() > 0) {
                        $party_master_id             = $getlimitamount->row()->id;
                        $credit_limit                = $getlimitamount->row()->credit_limit;
                        $credit_limit_amount         = $getlimitamount->row()->credit_limit_amount;
                        $credit_currency             = $getlimitamount->row()->credit_currency;
                        $credit_utilized_amount      = $getlimitamount->row()->credit_utilized_amount;
                        $creditlimit_currency_amount = $credit_limit_amount;
                    }
                }
            }

            if ($credit_currency != "") {
                /* IF credit currency doesnt match with user currency i.e. in session (need to et exchange rate amunt)*/
                if ($credit_currency != $session_currency) {
                    $info                 = ['exchange_rate_id' => '0', 'from_currency' => $credit_currency, 'to_currency' => $session_currency, 'user_id' => $user_id, 'order_id' => $order_id];
                    $exchange_rate_amount = $this->getexchnageamountfromcurrency($info);
                }
            }

            /*IF credit limit is 1 then need to check if credit limit exceed or not */
            if ($credit_limit == '1') {
                /*Get all orders from customer id and check utilized amount */
                $getorder_ids = $ci->common->gettbldata(["customer_id" => $customer_id], "id", "tb_orders", 0, 0);
                if (! empty($getorder_ids)) {
                    foreach ($getorder_ids as $order_rows) {
                        $order_row_id = $order_rows['id'];

                        $limit_orders[]        = $order_row_id;
                        $getorder_totalrevenue = $ci->db->query("SELECT id FROM tb_reveneus WHERE order_id ='" . $order_row_id . "' AND status ='1'");
                        if ($getorder_totalrevenue->num_rows() > 0) {
                            foreach ($getorder_totalrevenue->result() as $res) {
                                $revenue_row_id = $res->id;

                                $chk_charges = $ci->db->query("SELECT amount,currency,local_amount,local_currency FROM tb_charges WHERE revenue_id='" . $revenue_row_id . "'");
                                if ($chk_charges->num_rows() > 0) {
                                    foreach ($chk_charges->result() as $charge) {
                                        $charge_amount   = $charge->amount;
                                        $charge_currency = $charge->currency;
                                        $local_amount    = $charge->local_amount;
                                        $local_currency  = $charge->local_currency;

                                        if ($charge_currency != $session_currency) {
                                            $info                 = ['exchange_rate_id' => '0', 'from_currency' => $charge_currency, 'to_currency' => $session_currency, 'user_id' => $user_id, 'order_id' => $order_row_id];
                                            $exchange_rate_amount = $this->getexchnageamountfromcurrency($info);
                                            if ($exchange_rate_amount > 0) {
                                                $charge_amount = $exchange_rate_amount * $charge_amount;
                                            }

                                        }
                                        $total_amount += $charge_amount;
                                    }
                                }

                            }
                        }
                    }
                }
                $total_utilized_amount = $total_amount;
                if ($credit_currency != "") {
                    if ($session_currency != $credit_currency) {
                        $info                 = ['exchange_rate_id' => '0', 'from_currency' => $session_currency, 'to_currency' => $credit_currency, 'user_id' => $user_id, 'order_id' => '0'];
                        $exchange_rate_amount = $this->getexchnageamountfromcurrency($info);
                        if ($exchange_rate_amount != "" && $exchange_rate_amount != "0") {
                            $total_utilized_amount = $total_utilized_amount * $exchange_rate_amount;
                        }
                    }
                }
                $upd = $ci->common->updatetbledata("tbl_party_master", ['credit_utilized_amount' => $total_utilized_amount], ['id' => $party_master_id]);
                if (! empty($limit_orders)) {
                    foreach ($limit_orders as $ids) {
                        $order_row_id = $ids;
                        if ($total_utilized_amount > $credit_limit_amount) {
                            $current_hold_type = 2;
                            $chkorder          = $ci->common->gettblrowdata(['id' => $order_row_id, 'status' => '1'], "hold_type", 'tb_orders', 0, 0);
                            if (! empty($chkorder)) {
                                $prev_hold_type = $chkorder['hold_type'];
                                if ($prev_hold_type != "0" && $prev_hold_type != "") {
                                    if ($prev_hold_type == '1') {
                                        $current_hold_type = 3;
                                    } else if ($prev_hold_type == '2') {
                                        $current_hold_type = 2;
                                    } else if ($prev_hold_type == '3') {
                                        $current_hold_type = 3;
                                    }
                                } else {
                                    $current_hold_type = 2;
                                }
                                $upd = $ci->common->updatetbledata("tb_orders", ['hold_type' => $current_hold_type], ["id" => $order_row_id]);
                            }
                        } else if ($total_utilized_amount < $credit_limit_amount) {
                            $current_hold_type = 0;
                            $chkorder          = $ci->common->gettblrowdata(['id' => $order_row_id, 'status' => '1'], "hold_type", 'tb_orders', 0, 0);
                            if (! empty($chkorder)) {
                                $prev_hold_type = $chkorder['hold_type'];
                                if ($prev_hold_type != "0" && $prev_hold_type != "") {
                                    if ($prev_hold_type == '1') {
                                        $current_hold_type = 1;
                                    } else if ($prev_hold_type == '2') {
                                        $current_hold_type = 0;
                                    } else if ($prev_hold_type == '3') {
                                        $current_hold_type = 1;
                                    }
                                }
                                $upd = $ci->common->updatetbledata("tb_orders", ['hold_type' => $current_hold_type], ["id" => $order_row_id, 'status' => '1', 'trip_id' => '0']);
                            }
                        }
                    }
                }
            }
        }
    }

    public function is_currency_valid($currency)
    {
        $response = false;
        if (empty($currency)) {
            return $response;
        }
        $ci                 = &get_instance();
        $get_country_master = $ci->common->gettblrowdata(['status' => 1, 'currency' => $currency], "id", "tbl_country_master", 0, 0);
        if (isset($get_country_master['id']) && $get_country_master['id'] != '') {
            $response = true;
        }
        return $response;
    }

    public function addratesForOrderFromRateEnquiry(array $data): void
    {
        $ci           = &get_instance();
        $checkProfile = $ci->Orderrevenuesmodel->checkCustomerInProfileList(['customerId' => $data['customerId'], 'profileId' => $data['customerProfile']]);
        if ($checkProfile > 0) {
            $this->addrevchargesbyrecord(['record' => $data['rateRecordRowId'], 'type' => 0, 'order_id' => $data['orderRowId'], 'customer_code' => $data['customerId'], 'lane_id' => $data['laneRowId'], 'rate_offering' => $data['rateOfferingRowId'], 'rate_Service' => $data['rateServiceRowId'], 'orderCreatedSource' => $data['orderCreatedSource'] ?? 0], $data['userId'], $data['currency']);
        }
        if ($data['vendorIdFromProfile'] > 0) {
            $data  = ['rate_record_id' => $data['rateRecordRowId'], 'rate_offering' => $data['rateOfferingRowId'], 'rate_autobill' => 0, 'order_id' => $data['orderRowId'], 'vendor_code' => $data['vendorCodeFromProfile'], 'rate_service_id' => $data['rateServiceRowId']];
            $rowId = $this->add_buypreference($data);
        }
    }

}
