<?php

class Ruexp_status
{
    private $ci;

    function __construct()
    {
        $this->ci = &get_instance();
        $this->ci->load->helper('log');
        $this->ci->load->model('Edi_common_model');
    }

    public function getrequest($referenceValue = '', $orderId = '')
    {
        log_error('RusExpress Call - ' . $referenceValue . '-' . $orderId);
        $customerCode = $this->ci->Edi_common_model->getCustomercode($orderId);
        $getCredentials = $this->ci->Edi_common_model->getCridencials($customerCode);
        $getVendorAndOrderId = $this->ci->common->gettblrowdata(['id' => $orderId], 'order_id,vendor_id', 'tb_orders', 1, 0);
        if (!empty($getVendorAndOrderId) && !empty($getCredentials)) {
            $vendorId = $getVendorAndOrderId['vendor_id'];
            $bookingId = $getVendorAndOrderId['order_id'];
            $requestXml = $this->getRequestXml($getCredentials['login'], $getCredentials['password'], $referenceValue);
            $statusResponse = rusExpressStatusCurl($requestXml, $bookingId);
            if ($statusResponse['status'] == 'Success') {
                $plainXml = getPlainXml(trim($statusResponse['response']));
                $arrayResult = json_decode(json_encode(SimpleXML_Load_String($plainXml, 'SimpleXMLElement', LIBXML_NOCDATA)), true);
                log_error('RusExpress result- ' . json_encode($arrayResult));
                log_error('RusExpress status string=' . json_encode($arrayResult['soap_Body']['TrackingResponse']['return']['Items']['State']));
                if ($arrayResult['soap_Body']['TrackingResponse']['return']['Items']['State'] == '') {
                    log_error('RusExpress Status not found');
                } else {
                    $orderWhere = [
                        'o.vendor_id' => $vendorId,
                        'o.status <>' => 0,
                        'o.trip_sts' => 0,
                        'r.reference_id' => 'RUCK',
                        'r.status' => 1,
                        'o.id' => $orderId,
                        'r.order_id' => $orderId
                    ];
                    $orderDetails = $this->ci->common->gettblrowdata($orderWhere, 'o.id,o.order_id,o.user_id,o.vendor_id,o.shift_id,o.shipmentid,o.trip_id,o.plat,o.plng,o.dlat,o.dlng,r.ref_value,o.shipment_id', 'tb_orders o,tb_order_references r', 1, 0);
                    if (!empty($orderDetails)) {
                        log_error('order details RusExpress -' . json_encode($orderDetails));
                        $this->saveOrderStatus($orderDetails, $arrayResult);
                    }
                }
            } else {
                log_error('RusExpress status error-' . $orderId);
            }
        } else {
            log_error('Vendor id not found for order id-' . $orderId);
        }
    }

    public function getRequestXml(string $login, string $password, string $referenceValue): string
    {
        return '<soap:Envelope xmlns:soap="http://www.w3.org/2003/05/soap-envelope" xmlns:car="http://www.cargo3.org">
                    <soap:Header/>
                    <soap:Body>
                    <car:Tracking>
	                <car:Language>ru</car:Language>
	                <car:Login>' . $login . '</car:Login>
	                <car:Password>' . $password . '</car:Password>
	                <car:Type>Waybill</car:Type>
	                <car:Documents>' . $referenceValue . '</car:Documents>
                    </car:Tracking>
                    </soap:Body>
                    </soap:Envelope>';
    }

    public function saveOrderStatus(array $orderDetails, array $arrayResponse): void
    {
        $responseString = $arrayResponse['soap_Body']['TrackingResponse']['return']['Items']['State'] ?? "";
        $validStrings = [
            'Заказ подтвержден',
            'Оформлена накладная',
            'Груз забран',
            'Груз выбыл с место хранения',
            'Груз в транзите у перевозчика',
            'ТС в пути',
            'Груз передан на доставку',
            'Груз доставлен',
            'Груз передан получателю'
        ];
        if (!in_array($responseString, $validStrings) || empty($orderDetails)) {
            return;
        }
        $checkDeliveryString = in_array($responseString, ['Груз доставлен', 'Груз передан получателю']) ? 1 : 0;
        date_default_timezone_set('UTC');
        $stopId = $stopDetailId = $vehicleId = $driverId = 0;
        $shipmentId = $orderDetails['shipmentid'];
        $order_row_id = $orderDetails['id'];
        $bookingId = $orderDetails['order_id'];
        $getOrderInfo = $this->ci->common->gettblrowdata(['id' => $order_row_id, 'shipmentid' => $shipmentId], 'id,user_id,shift_id,trip_id,plat,plng,dlat,dlng', 'tb_orders', 0, 0);
        if (empty($getOrderInfo)) {
            return;
        }
        $tripId = $getOrderInfo['trip_id'];
        $shiftId = $getOrderInfo['shift_id'];
        $orderId = $getOrderInfo['id'];
        $pickupLatitude = $getOrderInfo['plat'];
        $pickupLongitude = $getOrderInfo['plng'];
        $deliveryLatitude = $getOrderInfo['dlat'];
        $deliveryLongitude = $getOrderInfo['dlng'];
        $getVehicleId = $this->ci->common->gettblrowdata(['shft_id' => $shiftId, 'status' => 1], 'vehicle_id', 'tb_shft_veh', 0, 0);
        if (!empty($getVehicleId)) {
            $vehicleId = $getVehicleId['vehicle_id'];
            $driver = $this->ci->common->gettblrowdata(['vehicle_id' => $vehicleId, 'status' => 1], 'driver_id', 'tbl_assigned_drivers', 0, 0);
            if (!empty($driver)) {
                $driverId = $driver['driver_id'];
            }
        }
        $getStops = $this->ci->common->gettblrowdata(['shift_id' => $shiftId, 'order_id' => $bookingId], 'id,drop_stopid', 'tb_employee', 0, 0);
        if (!empty($getStops)) {
            $stopDetailId = $getStops['id'];
            $stopId = $getStops['drop_stopid'];
        }
        $stopStatusData = [
            'order_id' => $orderId,
            'shipment_id' => $shiftId,
            'stop_id' => $stopId,
            'stop_detail_id' => $stopDetailId,
            'stop_type' => 'P',
            'trip_id' => $tripId,
            'status_id' => 10,
            'loc_name' => '',
            'status' => 1,
            'reason' => 'Svkonekt EDI-RusExpress',
            'vehicle_id' => $vehicleId,
            'driver_id' => $driverId,
            'status_code' => '0212',
            'latitude' => $pickupLatitude,
            'longitude' => $pickupLongitude
        ];
        $acceptStatus = $pickupGateInStatus = $pickupStatus =$pickupGateOutStatus = $inTransitStatus = $gateInDeliveryStatus = $deliveryStatus = 0;
        $getStatuses = $this->ci->common->gettbldata(['order_id' => $orderId, 'status' => 1], 'status_code', 'tb_stop_status', 0, 0);
        foreach ($getStatuses as $eachStatus) {
            switch ($eachStatus['status_code']) {
                case '0212':
                    $acceptStatus = 1;
                    break;
                case '0420':
                    $pickupGateInStatus = 1;
                    break;
                case '0500':
                    $pickupStatus = 1;
                    break;
                case '0191':
                    $pickupGateOutStatus = 1;
                    break;
                case '1550':
                    $inTransitStatus = 1;
                    break;
                case '0192':
                    $gateInDeliveryStatus = 1;
                    break;
                case '3000':
                    $deliveryStatus = 1;
                    break;
                default:
                    $acceptStatus = $pickupGateInStatus = $pickupStatus = $pickupGateOutStatus = $inTransitStatus = $gateInDeliveryStatus = $deliveryStatus = 0;
            }
        }
        if (0 == $checkDeliveryString) {
            $pickupStatusDate = $arrayResponse['soap_Body']['TrackingResponse']['return']['Items']['CreateDate'];
        } else {
            $pickupStatusDate = $arrayResponse['soap_Body']['TrackingResponse']['return']['Items']['DeliveryDate'];
        }
        $formattedPickupStatusDate = date('Y-m-d H:i:s', strtotime($pickupStatusDate));
        if (0 == $acceptStatus) {
            $checkTripId = $this->ci->common->gettblrowdata(['shift_id' => $shiftId, 'status' => 1], 'id', 'tb_trips', 0, 0);
            if (empty($checkTripId)) {
                $insertTripData = [
                    'shift_id' => $shiftId,
                    'driver_id' => $driverId,
                    'vehicle_id' => $vehicleId,
                    'stime' => $formattedPickupStatusDate,
                    'created_on' => $formattedPickupStatusDate
                ];
                $tripId = $this->ci->common->insertTableData('tb_trips', $insertTripData);
            } else {
                $tripId = $checkTripId['id'];
            }
            $this->ci->db->where(['id' => $orderId])->update('tb_orders', ['trip_id' => $tripId]);
            $stopStatusData['trip_id'] = $tripId;
            $stopStatusData['createdon'] = $formattedPickupStatusDate;
            $this->ci->common->insertTableData('tb_stop_status', $stopStatusData);
        }
        if ((0 == $pickupGateInStatus) && (in_array($responseString, ['Заказ подтвержден','Оформлена накладная']) || 1 == $checkDeliveryString)) {
            $stopStatusData['status_id'] = 2;
            $stopStatusData['status_code'] = '0420';
            $this->ci->common->insertTableData('tb_stop_status', $stopStatusData);
        }
        if ((0 == $pickupStatus) && ('Груз забран' == $responseString || 1 == $checkDeliveryString)) {
            $stopStatusData['status_id'] = 1;
            $stopStatusData['status_code'] = '0500';
            $this->ci->common->insertTableData('tb_stop_status', $stopStatusData);
        }
        if ((0 == $pickupGateOutStatus) && ('Груз выбыл с место хранения' == $responseString || 1 == $checkDeliveryString)) {
            $stopStatusData['status_id'] = 3;
            $stopStatusData['status_code'] = '0191';
            $this->ci->common->insertTableData('tb_stop_status', $stopStatusData);
        }
        if ((0 == $inTransitStatus) && (in_array($responseString, ['Груз в транзите у перевозчика','ТС в пути']) || 1 == $checkDeliveryString)) {
            $stopStatusData['status_id'] = 4;
            $stopStatusData['status_code'] = '1550';
            $this->ci->common->insertTableData('tb_stop_status', $stopStatusData);
        }
        $deliveryStatusDate = $arrayResponse['soap_Body']['TrackingResponse']['return']['Items']['DeliveryDate'] ?? $pickupStatusDate;
        $formattedStatusDate = date('Y-m-d H:i:s', strtotime($deliveryStatusDate));
        $stopStatusData['stop_type'] = 'D';
        $stopStatusData['latitude'] = $deliveryLatitude;
        $stopStatusData['longitude'] = $deliveryLongitude;
        $stopStatusData['createdon'] = $formattedStatusDate;
        if ((0 == $gateInDeliveryStatus) && ('Груз передан на доставку' == $responseString || 1 == $checkDeliveryString)) {
            $stopStatusData['status_id'] = 2;
            $stopStatusData['status_code'] = '0192';
            $this->ci->common->insertTableData('tb_stop_status', $stopStatusData);
        }
        if (1 == $checkDeliveryString) {
            if (0 == $deliveryStatus) {
                $stopStatusData['status_id'] = 1;
                $stopStatusData['status_code'] = '2300';
                $this->ci->common->insertTableData('tb_stop_status', $stopStatusData);
                $stopStatusData['status_id'] = 3;
                $stopStatusData['status_code'] = '3000';
                $this->ci->common->insertTableData('tb_stop_status', $stopStatusData);
                $this->ci->common->updatetbledata('tb_orders', ['trip_sts' => 1], ['id' => $orderId]);
                $this->ci->common->updatetbledata('tb_shifts', ['status' => 0], ['id' => $shiftId]);
            }
        }
    }
}
