<?php
require_once './vendor/pear/http_request2/HTTP/Request2.php';
class SALOGDownloadDocuments {
	private $CI;
	public function __construct() {
        $this->CI = &get_instance();
    }

    public function downloadSALOGByDocumentType(int $orderId, int $trackingNumber, string $documentType, string $downloadType = 'ONE'): int {
    	$xml = $this->getXMLString($trackingNumber, $documentType);
    	log_message("error","SALOG Docs XML Post data {$xml}");
		$curl = curl_init();
		curl_setopt_array($curl, [
			CURLOPT_URL => SALOG_ESB_WSDL_URL,
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => 'POST',
			CURLOPT_POSTFIELDS =>$xml,
			CURLOPT_HTTPHEADER => array(
				'Content-Type: text/xml',
				'SOAPAction: ws.dvelop.com/SearchDocument',
				'Host: esb.int.kn:8443'
			),
		]);
		$response = curl_exec($curl);
		log_message('error',"SALOG DOCS DOWNLOAD Response {$response}");
		curl_close($curl);
		$cleanXML = str_ireplace(['SOAP-ENV:', 'SOAP:','ns3:','xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/"','xmlns:ns3="http://gen.ws.dvelop.com"'], '', $response);		
		$xml = simplexml_load_string($cleanXML, "SimpleXMLElement", LIBXML_NOCDATA); 		
		$json = json_encode($xml);
        $response = json_decode($json, true);
        log_message('error',"SALOG DOCS DOWNLOAD FINAL ARRAY Response ".json_encode($response));
        $allDocuments = [];
        if (isset($response['Body']['SearchDocumentResponse']['export']['number']) && $response['Body']['SearchDocumentResponse']['export']['number'] > 0) {
	        if (isset($response['Body']['SearchDocumentResponse']['table']['item']) && is_array($response['Body']['SearchDocumentResponse']['table']['item']) && count($response['Body']['SearchDocumentResponse']['table']['item']) > 0) {
	        	if ((int)$response['Body']['SearchDocumentResponse']['export']['number'] === 1) {
	        		$documents = $response['Body']['SearchDocumentResponse']['table']['item'];
	        	} else {
	        		if ($downloadType === 'ONE') {
	        			$documents = $response['Body']['SearchDocumentResponse']['table']['item'][0];
	        		} else {
	        			$docsList = $response['Body']['SearchDocumentResponse']['table']['item'];
	        			foreach ($docsList as $document) {
	        				$file = $this->downloadDocument($document['WSDownloadURL']);
							if ( $file !== 'Error') {
								$allDocuments[] = $file;
							}
	        			}
	        		}
	        	}

	        	if (isset($documents['WSDownloadURL']) && $documents['WSDownloadURL'] && $downloadType === 'ONE') {
					$file = $this->downloadDocument($documents['WSDownloadURL']);
					if ( $file !== 'Error') {
						$allDocuments[] = $file;
					}
				}
	        	
	        }

        }
        if (!empty($allDocuments)) {
        	$insertData = [];
        	$this->CI->load->model('common');
        	$getDocumentType = $this->CI->common->gettblrowdata(['document_id' => 'KN-'.$documentType],'id','tb_document_types',0,0);
        	if ($getDocumentType) {
				foreach ($allDocuments as $file) {
					$insertData[] = [
						'trip_id'=>0,
						'shipment_id'=>0,
						'stop_id'=>0,
						'doc_type'=>$getDocumentType['id'],
						'imgpath'=>$file,
						'pdfpath'=>$file,
						'user_id'=>0,
						'createdby'=>0,
						'order_id'=>$orderId,
						'createdon'=>date('Y-m-d H:i:s'),
						'updatedon'=>date('Y-m-d H:i:s')
					];
				}
				if ($insertData) {
					$this->CI->common->insertbulk('tb_pod_uploads',$insertData);
					return 1;
				}
        	}
        }
        return 0;
    }

    private function downloadDocument(string $url): string {
    	$fileName = 'SALOG_'.date('Ymdhis').rand(1111,9999).'.pdf';
		$curl = curl_init();

		curl_setopt_array($curl, [
			CURLOPT_URL => $url,
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => 'GET',
		]);
		$response = curl_exec($curl);
		curl_close($curl);
		$fp = fopen(NEW_POD_PATH.$fileName, 'w');
	    if (fwrite($fp, $response)) {
		    fclose($fp);
			return $fileName;
	    }
	    return 'Error';
    }

    private function getXMLString(int $trackingNumber, string $documentType): string {
    	return '<?xml version="1.0" encoding="utf-8"?>
		<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:gen="http://gen.ws.dvelop.com">
			<soapenv:Header/>
			<soapenv:Body>
				<gen:SearchDocumentRequest debug="1" MTOM="1">
					<archiv>
		                <User>'.SALOG_ESB_USERNAME.'</User>
		                <Password>'.SALOG_ESB_PASSWORD.'</Password>
		                <Language>001</Language>
		                <arch>01</arch>
		            </archiv>
					<import>
						<max_number_of_docs>100</max_number_of_docs>
						<doc_fields>
							<doc_field field_no="5" value="'.$documentType.'"/>
							<doc_field field_no="7" value="'.$trackingNumber.'"/>
						</doc_fields>
					</import>
				</gen:SearchDocumentRequest>
			</soapenv:Body>
		</soapenv:Envelope>';
    }
}