<?php
	require_once(APPPATH.'libraries/Firebase.php');
	class Sendfirebase
	{
		public function sendSinglePush($post){
			$response = array();
			//hecking the required params
			if(isset($post['title']) and isset($post['message']) and isset($post['emp_id'])){
				//creating a new push
				$push = null;
				//first check if the push has an image with it
				if(isset($post['image'])){
					$push["data"] = array(
							"title"=>$post['title'],
							'message'=>$post['message']
						);
				}else{
					//if the push don't have an image give null in place of image
					$push["data"] = array(
							"title"=>$post['title'],
							'message'=>$post['message']
						);
				}
				$this->savenotification($post['emp_id'],$post['title'],$post['message'],$post['type']);

				//getting the token from database object
				$devicetoken = getTokenByReg($post['emp_id'],$post['type']);
				//creating firebase class object
				$firebase = new Firebase();
				//sending push notification and displaying result
				$response['status']="1";
				$response['message']= $d = $firebase->send($devicetoken, $push);
				return $d;
			}else{
				$response['status']="0";
				$response['message']='Parameters missing';
			}
		return json_encode($response);
	}

	public function savenotification($emp_id,$title,$message,$type){
		$ci = & get_instance();
		$data["emp_id"]=$emp_id;
		$data["title"]=$title;
		$data["message"]=$message;
		$data["notify_type"]=$type;
		$data["created_on"]=date("Y-m-d H:i:s");
		$ins = $ci->db->insert("tb_firebase_notifications",$data);
	}

	public function sendMultiplePush($post){
		$response = array();
			//hecking the required params
			if(isset($post['title']) and isset($post['message']) and isset($post['trip_id'])) {
				//creating a new push
				$push = null;
				//first check if the push has an image with it
				if(isset($post['image'])){

					$push["data"] = array(
							"title"=>$post['title'],
							'message'=>$post['message']
						);
				}else{
					//if the push don't have an image give null in place of image
					$push["data"] = array(
							"title"=>$post['title'],
							'message'=>$post['message']
						);
				}
				$push['data']['timestamp'] = date('Y-m-d H:i:s');
				//getting the token from database object
				$devicetoken = getAllTokens($post["trip_id"]);
				foreach($devicetoken as $emp)
					$this->savenotification($emp,$post['title'],$post['message'],$post['type']);
				//creating firebase class object
				$firebase = new Firebase();
				//sending push notification and displaying result
				$response['status']="1";
				$response['message']=$firebase->send($devicetoken, $push);
			}else{
				$response['status']="0";
				$response['message']='Parameters missing';
			}
		return json_encode($response);
	}

	public function sendSingleOrderPush($post){
			$response = array();
			if(isset($post['title']) and isset($post['message']) and isset($post['user_id'])){
				$push = array(
							"title"=>$post['title'],
							'message'=>$post['message']
						);
				$ins = $this->saveshipnotification($post);
				//getting the token from database object
				$devicetoken = getTokenByReg($post['user_id'],$post['type']);
				//creating firebase class object
				$firebase = new Firebase();
				//sending push notification and displaying result
				$response['status']="1";
				$d = array();
				if(!empty($devicetoken)){
					$response['message']= $d = $firebase->send($devicetoken, $push);
				}
				return $d;
			}else{
				$response['status']="0";
				$response['message']='Parameters missing';
			}
		return json_encode($response);
	}

	public function saveshipnotification($post){
		$ci = & get_instance();
		$data["emp_id"]=$post['emp_id'];
		$data["shipment_id"]=$post['shipment_id'];
		$data["trip_id"]=$post['trip_id'];
		$data["stop_id"]=$post['stop_id'];
		$data["user_id"]=$post['user_id'];
		$data["title"]=$post['title'];
		$data["message"]=$post['message'];
		$data["notify_type"]=$post['type'];
		$data["created_on"]=date("Y-m-d H:i:s");
		$data["status_id"]=$post['status_id'];
		$data["msg_status"]=$post['msg_status'];
		$ins = $ci->db->insert("tb_firebase_notifications",$data);
	}
}
?>
