<?php
use phpseclib\Net\SFTP;
class Sendpodtoknservice
{
    private const JPL_PATH = "./assets/jpl_files/";
    private const KNLOGIN_EPOD_PATH = "/pub/inbound/D3/FO";
    public function __construct()
    {
        $this->ci = &get_instance();
        $this->ci->load->helper('log_helper');
    }
    public function imageToPdf(string $sourceFile, string $ext, string $destinationFileName): string
    {
        require 'vendor/autoload.php';
        $mpdf = new \Mpdf\Mpdf([
            'tempDir' => FCPATH . 'assets/tmp',
        ]);
        $size = getimagesize($sourceFile);
        $width = $size[0];
        $height = $size[1];
        $mpdf->WriteHTML('');
        $mpdf->Image($sourceFile, 5, 5, $width, $height, strtolower($ext), '', true, true);
        $mpdf->Output($destinationFileName, 'F');
        return $destinationFileName;
    }

    public function getNumPagesPdf(string $filePath): int
    {
        $fp = @fopen(preg_replace("/\[(.*?)\]/i", "", $filePath), "r");
        $max = 0;
        if (!$fp) {
            log_error("PODPages: Could not open file: " . $filePath);
        } else {
            while (!@feof($fp)) {
                $line = @fgets($fp, 255);
                if (preg_match('/\/Count [0-9]+/', $line, $matches)) {
                    preg_match('/[0-9]+/', $matches[0], $matches2);
                    if ($max < $matches2[0]) {
                        $max = trim($matches2[0]);
                        break;
                    }
                }
            }
            @fclose($fp);
        }
        return $max;
    }

    /*public function saveJPF(array $jplData): string
    {
        $ci = &get_instance();
        if (isset($jplData["unique_id"])) {
            $filePath = self::JPL_PATH . $jplData["unique_id"] . ".jpl";
        } else {
            $filePath = self::JPL_PATH . "RL" . $jplData["order_id"] . ".jpl";
        }
        $jplData["unique_id"] = basename($filePath, ".jpl");
        $jplData["senderInst"] = self::getEnvironment();
        $content = $ci->load->view("myknJplTemplate", $jplData, true);
        $fp = fopen($filePath, "wb");
        fwrite($fp, $content);
        fclose($fp);
        return $filePath;
    }*/
    
    public function saveJPF(array $jplData): string
    {
        $ci = &get_instance();
    
        if (isset($jplData["unique_id"])) {
            $filePath = self::JPL_PATH . $jplData["unique_id"] . ".jpl";
        } else {
            $filePath = self::JPL_PATH . "RL" . $jplData["order_id"] . ".jpl";
        }
    
        $jplData["unique_id"] = basename($filePath, ".jpl");
        $jplData["senderInst"] = self::getEnvironment();
    
        $content = $ci->load->view("myknJplTemplate", $jplData, true);
    
        // ✅ Safely open the file
        $fp = fopen($filePath, "wb");
        if ($fp === false) {
            throw new \Exception("Failed to open file for writing: $filePath");
        }
    
        fwrite($fp, $content);
        fclose($fp);
    
        return $filePath;
    }

    public function saveROADLOGJPF(array $jplData): string
    {
        $ci = &get_instance();
        if (isset($jplData["unique_id"])) {
            $filePath = self::JPL_PATH . $jplData["unique_id"] . ".jpl";
        } else {
            $filePath = self::JPL_PATH . "RL" . $jplData["order_id"] . ".jpl";
        }
        $jplData["unique_id"] = basename($filePath, ".jpl");
        $jplData["senderInst"] = self::getRoadlogEnvironment($jplData["order_id"]);
        $content = $ci->load->view("jpl_template", $jplData, true);
        file_put_contents($filePath, $content);
        return $filePath;
    }

    public function uploadKNFile($localFile)
    {
        $remotefile = basename($localFile);
        $sftp_url = SALOG_FTP;
        $username = SALOG_FTP_USER;
        $password = SALOG_FTP_PWD;
        try{
            $sftp = new SFTP($sftp_url);
            if (!$sftp->login($username, $password)) {
                unset($sftp);
                log_error("uploadKNFile: Cannot login into your KNLogin MTF Test server !");
            }else{
                $sftp->chdir(self::KNLOGIN_EPOD_PATH);
                $sftp->put(self::KNLOGIN_EPOD_PATH."/".$remotefile,$localFile,SFTP::SOURCE_LOCAL_FILE);
                unset($sftp);
                return true;
            }
        } catch (Exception $ex) {
            log_error("uploadKNFile: Some problem occured!, KNLogin MTF Test server, Please Try Again Later.");
        }
    }

    /**
     * @param order_id string
     * return string As Environment
     */
    private static function getEnvironment(): string
    {
        if (SYS_TYPE == "TMS") {
            return 'WWDPP01';
        } else {
            return 'WWDPT01';
        }
    }

    private function getRoadlogEnvironment($order_id)
    {
        $ci = &get_instance();
        $chkcust = $ci->db->query("SELECT physicalsender FROM tb_orders  WHERE  order_id=? LIMIT 1", [$order_id]);
        if ($chkcust->num_rows() == 0) {
            return 'TEST';
        }
        $orddata = $chkcust->row_array();
        switch ($orddata['physicalsender']) {
            case 'KNRLG01':
                return 'PROD';
            case 'KNRLG09':
                return 'TEST_ACCEPTANCE';
            case 'KNRLG03':
                return 'TEST_SPE';
            default:
                log_debug('Unable to define environement for physical sender \'' . $orddata['physicalsender'] . '\', use TEST');
                return 'TEST';
        }
    }
}
