<?php

use phpseclib\Net\SFTP;

class SftpProxyClient {

    private int $uploadCounter = 5;
    private int $loginCounter = 10;

    /**
     * @param $SFTPUrl (SFTP host name)
     * @param $SftpClientName (The log's purpose this parameter)
     * @return false|SFTP
     */
    public function proxyConnection($SFTPUrl,$SftpClientName)
    {
        $SFTPProxy = fsockopen(
            KN_PROXY_URL,
            '80',
            $errorNum,
            $errorMsg,
            3
        );
        if (!$SFTPProxy) {
            log_message(
                "error",
                $SftpClientName . ' Proxy Login failed,  ' .
                'Error NUmber:' . $errorNum . ', Error message ' . $errorMsg
            );
            return false;
        }
        fwrite($SFTPProxy, "CONNECT $SFTPUrl:22 HTTP/1.1\r\n\r\n");

        $sftpProxyConnection = new SFTP($SFTPProxy);
        $sftpProxyConnection->setTimeout(4);

        return $sftpProxyConnection;
    }

    /**
     * @param $sftpData (sftp->(This variable is the return of the "proxyConnection" function.),
     *                          sftpUsername,sftpPassword,sftpDestination,sftpSourceFile)
     * @param $SftpClientName (The log's purpose this parameter)
     * @return array
     * @throws JsonException
     */
    public function fileUpload($sftpData, $SftpClientName): array
    {
        $sftp = $sftpData['sftp'];

        if (!$sftp->login($sftpData['sftpUsername'], $sftpData['sftpPassword'])) {
            log_message("error", $SftpClientName . ' Login failed, tried to upload file: ' . $sftpData['sftpSourceFile']);
            return $this->repeatLogin($sftpData, $SftpClientName);
        }

        if ($sftp->put($sftpData['sftpDestination'], file_get_contents($sftpData['sftpSourceFile']))) {
            return ['status' => 1, 'response' => $SftpClientName . '  file successfully uploaded'];
        }

        log_message("error", $SftpClientName . ' file upload failed, tried to upload: '  . $sftpData['sftpSourceFile']);
        $this->repeatUpload($sftpData, $SftpClientName);

        return ['status' => 0, 'response' => $SftpClientName . '  file upload failed'];
    }

    /**
     * @throws Exception
     */
    private function repeatUpload($sftpData, $SftpClientName):void {
        if (!$this->uploadCounter--) {
            return;
        }

        sleep(random_int(2,5));
        log_message("error", "SftpProxyClient, retry upload ". $this->uploadCounter. " on failure, tried to upload: " . $sftpData['sftpSourceFile']);
        $this->fileUpload($sftpData, $SftpClientName);
    }

    /**
     * @throws Exception
     */
    private function repeatLogin($sftpData, $SftpClientName): array {
        if (!$this->loginCounter--) {
            return ['status' => 0, 'response' => $SftpClientName . '  sftp login failed'];
        }

        sleep(random_int(2,5));
        log_message("error", "SftpProxyClient, retry login ".$this->loginCounter." on failure");

        return $this->fileUpload($sftpData, $SftpClientName);
    }
}
