<?php

namespace App\Libraries;

class ShippeoIdentifiers
{
    /*
     *  Here
     *      Key in BRANCH_PARTY_IDENTIFIERS ref to branch code
     *      and
     *      value corresponding to every key refers to customer identifiers.
     */
    const BRANCH_PARTY_IDENTIFIERS = [
        'PLKTW' => ['PHILPLCRA001', 'PHILCHLAU006', 'PHILCHNEU003', 'KUEHDEGRO004'],
        'CZPRG' => ['KUEHDEGRO004', 'CHE116276488'],
        'RSBEG' => ['PHILPLCRA001', 'PHILCHLAU006', 'PHILCHNEU003', 'KUEHDEGRO004', 'PHILCHLAU004']
    ];
    const COMPANY_CODES = ['PLKN', 'CZKN', 'RSKN'];
    const BRANCH_CODES = ['PLKTW', 'CZPRG', 'RSBEG'];

    public static function getPartyIdentifiersByBranchCode(string $branchCode): array
    {
        return self::BRANCH_PARTY_IDENTIFIERS[$branchCode];
    }
}
