<?php

use App\Libraries\ShippeoIdentifiers;

class Shippeopositionsevent
{
    var $edi_request = '';
    var $edi_response = '';
    var $order_id = '';
    var $edi_status_flag = 0;
    static $counter_flag = 0;

    function __construct()
    {
    }

    function setEdi_request($edi_request): void
    {
        $this->edi_request = $edi_request;
    }

    function setEdi_response($edi_response): void
    {
        $this->edi_response = $edi_response;
    }

    function getEdi_request()
    {
        return $this->edi_request;
    }

    function getEdi_response()
    {
        return $this->edi_response;
    }

    function getOrder_id()
    {
        return $this->order_id;
    }

    function setOrder_id($order_id): void
    {
        $this->order_id = $order_id;
    }

    function getEdi_status_flag()
    {
        return $this->edi_status_flag;
    }

    function setEdi_status_flag($edi_status_flag): void
    {
        $this->edi_status_flag = $edi_status_flag;
    }

    /**
     *  To get Authentication token from Shippeo (its specifi for Poland)
     */
    private function shippeo_positions(string $uuid, array $postData): void
    {
        $ci = &get_instance();
        $chktoken = $ci->db->query("SELECT auth_token FROM tb_auth_tokens where token_for='Shippeo' LIMIT 1");
        if ($chktoken === false || $chktoken->num_rows() === 0) {
            log_message("error", "Token not found for  shippeo");
            exit;
        }
        $postData["auth_token"] = $chktoken->row()->auth_token;
        $this->shippeo_positions_request_format($chktoken->row()->auth_token, $uuid, $postData);
    }

    /**
     * @Description:    It will prepare request_format and calls Shippeo GPS Service
     */
    private function shippeo_positions_request_format(string $token, string $uuid, array $postData): void
    {
        $strtime = strtotime($postData['date_transmission']);
        $dateTransmission = date('Y-m-d', $strtime) . 'T' . date('H:i:s', $strtime) . 'Z';
        $requestFormat = $this->fetchShippeoPositionsRequestFormat($dateTransmission, $uuid, $postData);
        $this->setEdi_request(json_encode($requestFormat));
        $status_response = shippeo_positions_curl($requestFormat, $token);
        $str = '[' . json_encode($status_response['response']) . ']';
        $json = json_decode($str, true);
        $ci = &get_instance();
        $ci->load->model("common");
        $ci->load->library("shippeotokengeneration");
        foreach ($json as $elem) {
            if (!empty($elem['errors'])) {
                foreach ($elem['errors'] as $errors) {
                    if ($errors['code'] === "TOKEN_EXPIRED_EXCEPTION") {
                        $token = $ci->shippeotokengeneration->shippeotokenUpdate();
                        $status_response = shippeo_positions_curl($requestFormat, $token);
                    }
                }
            }
        }
        $this->setEdi_status_flag($status_response['status']);
        $this->setEdi_response($status_response['response']);
        $this->setOrder_id($postData['order_id']);
        $response_array = (array)($status_response['response']);
        foreach ($response_array as $key => $value) {
            if (isset($response_array[$key]->errors)) {
                $this->setEdi_status_flag(0);
                break;
            }
        }
        $this->is_triggered($postData);
        $this->log_shippeo_position_call(
            $this->getEdi_request(),
            is_array($this->getEdi_response()) ? $this->getEdi_response() : [ $this->getEdi_response()],
            $this->getOrder_id()
        );
    }

    private function fetchShippeoPositionsRequestFormat(string $dateTransmission, string $uuid, array $postData): array
    {
        return [
            'location' => [
                [
                    'timestamp' => $dateTransmission,
                    'coords' =>
                        [
                            'latitude' => $postData['latitude'],
                            'longitude' => $postData['longitude'],
                        ],
                    'uuid' => $uuid,
                    'externalID' => $postData['truck_number'],
                ],
            ],
        ];
    }

    /**
     * @Description:    If Positions triggered to Shippeo that truck_number corresponding is_triggered field should be updated to '1'
     */

    private function is_triggered(array $postData): void
    {
        echo "<table style='font-family: arial,sans-serif;border-collapse: collapse;width: 100%;'>";
        echo "<tr>";
        if ($this->getEdi_status_flag() == '1') {
            $ci = &get_instance();
            $ci->common->updatetbledata("tb_trucks_data", ["is_triggered" => "1"], ["id" => $postData["vehicle_id"]]);
            echo "<td style='width:36%;border: 1px solid #dddddd;text-align: left;padding: 8px;'> " . $postData["truck_number"] . "</td>";
            echo "<td style='width:36%;border: 1px solid #dddddd;text-align: left;padding: 8px;'>" . $postData["latitude"] . "</td>";
            echo "<td style='width:36%;border: 1px solid #dddddd;text-align: left;padding: 8px;'>" . $postData["longitude"] . "</td>";
        }
        echo "</tr>";
        echo "</table>";
    }

    /**
     * @Description:    Whenever Position URL triggered then this function will trigger Shippeo Posititons Service Calls.
     * @throws JsonException
     */

    private function log_shippeo_position_call(string $ediRequest, array $ediResponse, string $shiftId): void
    {
        $ci = &get_instance();
        $shipmentInfo = $ci->common->gettblrowdata(['id' => $shiftId], 'user_id,company_code,branch_code,shipmentId', 'tb_shifts', 0, 0);
        if (empty($shipmentInfo)) {
            log_message("error", "No shipments found with shipment id:" . $shiftId);
            return;
        }
        $ediTypeInfo = $ci->common->gettblrowdata(['edi_name' => 'SHIPPEO_POSITIONS', 'status' => 1], 'id', 'tb_edi_types', 0, 0);
        if (empty($ediTypeInfo)) {
            log_message("error", "There is no any edi type with name `SHIPPEO_POSITIONS`");
            return;
        }
        $userId = $shipmentInfo['user_id'];
        $companyCode = $shipmentInfo['company_code'];
        $branchCode = $shipmentInfo['branch_code'];
        $shiftId = $shipmentInfo['shipmentId'];
        $ediReferenceId = $ediTypeInfo['id'];
        try {
            $logResponse = !reset($ediResponse) ? null : json_encode($ediResponse, JSON_THROW_ON_ERROR);
        }catch (Exception $e) {
            $logResponse = null;
            log_message('error', 'Shippeopositionevent - '.$e->getMessage());
        }
        $params = [
            'edi_type' => 2, //'1->EDI Transport Order,2->EDI Status'
            'transaction_id' => time(),
            'edi_id' => $ediReferenceId, // edi id based on name take it from tb_edi_types
            'edi_name' => 'SHIPPEO_POSITIONS',
            'bounded_type' => 2, // '1->Inbound(partner => kN),2->Outbound (KN => partner)'
            'edi_format_type' => 'JSON',
            'status' => $this->getEdi_status_flag(),
            'obj_type' => 1,
            'txn_obj_id' => $shiftId,
            'user_id' => $userId,
            'company_code' => $companyCode,
            'branch_code' => $branchCode,
            'edi_request' => $ediRequest,
            'edi_response' => $logResponse
        ];
        $ci->common->insertTableData('tb_etn_edi_transactions', $params);
    }

    /**
     * @Description:    Logging Shippeo Status Positions Service Calls(its specifi for Poland).
     */

    public function shippeo_position_event_call(string $uuid, string $curtz, string $logDate): void
    {
        $ci = &get_instance();
        $ci->load->model("common");
        $getactual = getdatetimebytimezone(DFLT_TZ, $logDate, empty($curtz) ? DFLT_TZ : $curtz);
        $postdata['date_transmission'] = $getactual['datetime'];
        $postdata["truck_number"] = null;
        $query = "SELECT shift_id,id FROM `tb_orders` WHERE company_code IN ? and branch_code IN ? and trip_id != '0' and shift_id != '0' and trip_sts != '1' and status != '0' order by id desc";
        $chkordercount = $ci->db->query($query, [ShippeoIdentifiers::COMPANY_CODES, ShippeoIdentifiers::BRANCH_CODES]);
        if ($chkordercount === false || $chkordercount->num_rows() === 0) {
            return;
        }
        foreach ($chkordercount->result() as $res) {
            $postdata["order_id"] = $res->shift_id;
            $postdata["ord_id"] = $res->id;
            $postdata["id"] = $res->shift_id;
            $chkvehicle = $ci->db->query("SELECT vehicle_id FROM tb_trips WHERE shift_id = ? and pair_mean_status = '1' order by id desc LIMIT 1", [$res->shift_id]);
            if ($chkvehicle !== false && $chkvehicle->num_rows() > 0) {
                $res = $chkvehicle->row_array();
                $postdata["vehicle_id"] = $res['vehicle_id'];
                $query = "SELECT truck_number,latitude,longitude FROM tb_trucks_data WHERE id = ? and latitude IS NOT NULL and longitude IS NOT NULL and latitude != '' and longitude!= '' and is_triggered = '0' order by id desc LIMIT 1";
                $chktruck = $ci->db->query($query, [$postdata["vehicle_id"]]);
                if ($chktruck !== false && $chktruck->num_rows() > 0) {
                    $trucksData = $chktruck->row_array();
                    $postdata["truck_number"] = $trucksData['truck_number'];
                    $postdata["latitude"] = $trucksData['latitude'];
                    $postdata["longitude"] = $trucksData['longitude'];
                    $this->shippeo_positions($uuid, $postdata);
                }
            }
        }
    }
}
