<?php

use App\Libraries\ShippeoIdentifiers;

class shippeostatusintigration
{

    var $edi_request = '';
    var $edi_response = '';
    var $order_id = '';
    var $edi_status_flag = 0;
    static $counter_flag = 0;

    function __construct()
    {
    }

    function setEdi_request($edi_request): void
    {
        $this->edi_request = $edi_request;
    }

    function setEdi_response($edi_response): void
    {
        $this->edi_response = $edi_response;
    }

    function getEdi_request()
    {
        return $this->edi_request;
    }

    function getEdi_response()
    {
        return $this->edi_response;
    }

    function getOrder_id()
    {
        return $this->order_id;
    }

    function setOrder_id($order_id): void
    {
        $this->order_id = $order_id;
    }

    function getEdi_status_flag()
    {
        return $this->edi_status_flag;
    }

    function setEdi_status_flag($edi_status_flag): void
    {
        $this->edi_status_flag = $edi_status_flag;
    }

    /**
     *  To get Authentication token from Shippeo (its specifi for Poland)
     */
    public function shippeoStatusUpdate(array $postData): void
    {
        $ci = &get_instance();
        $chktoken = $ci->db->query("SELECT auth_token FROM tb_auth_tokens where token_for='Shippeo' LIMIT 1");
        if ($chktoken === false || $chktoken->num_rows() === 0) {
            log_message("error", "Shippeo token not found so please generate manually for now to continue process");
            return;
        }
        $postData["auth_token"] = $chktoken->row()->auth_token;
        log_message('error', 'src\application\libraries\Shippeostatusintigration.php (70) >>> '.json_encode($postData, 128));
        $this->request_processor($postData["auth_token"], $postData);
    }

    /**
     *  To process service call.
     */
    function request_processor(string $token, array $postData): void
    {
        if (empty($token)) {
            $this->logShippeoEventsCall([], 'SHIPPEO Auth token generation fail,So this events service call is not performed', $postData['order_id']);
            return;
        }
        $postData = $this->situationJustificationCode($postData);
        if (empty($postData['situation_code']) || empty($postData['justification_code'])) {
            return;
        }
        $this->postedi($token, $postData);
    }

    /**
     * @Description:    It will prepare request_format and calls Shippeo events Service
     */
    public function postedi(string $token, array $postData): void
    {
        // prepare requested date format
        $strtime = strtotime($postData['date_transmission']);
        $dateTransmission = date('Y-m-d', $strtime) . 'T' . date('H:i:s', $strtime) . 'Z';
        $requestFormat = $this->fetchShippeoStatusEventsRequestFormat($dateTransmission, $postData);
        $this->setEdi_request(json_encode($requestFormat));
        $ci = &get_instance();
        $ci->load->model("common");
        $ci->load->library("shippeotokengeneration");
        $orderUnknownByShippeo = false;
        $try = 1;
        $statusToPass = [201, 202, 204, 205];
        $statusToFail = 404;
        $statusResponse = [];
        while ($try < 3) {
            $httpShippeoResponse = shippeo_status_curl($requestFormat, $token, $postData["edi_reference"]);
            $statusResponse = json_decode($httpShippeoResponse->getBody(), true);
            $statusResponseOfShipeo = $httpShippeoResponse->getStatus();
            if (in_array($statusResponseOfShipeo, $statusToPass)) {
                break;
            }

            if ($statusResponseOfShipeo === $statusToFail) {
                $orderUnknownByShippeo = true;
                log_message("error", "response code 404: order unknown by shippeo" . $httpShippeoResponse->getStatus());
                break;
            }

            $token = $ci->shippeotokengeneration->shippeotokenUpdate();
            $try++;
        }

        if ($try == 3 || $orderUnknownByShippeo) { // We have failed 3 times to have a good answer from Shippeo
            $this->setEdi_response($statusResponse['errors']);
            $this->setEdi_status_flag(0);
        } else {
            $this->setEdi_response($statusResponse['response']);
            $this->setEdi_status_flag(1);
            if (is_numeric($postData['trip_id']) && $postData['trip_id'] > 0) {
                $ci->common->updatetbledata("tb_trips", ["pair_mean_status" => "1"], ["id" => $postData['trip_id']]);
            }
        }
        $this->setOrder_id($postData['order_id']);
    }

    private function fetchShippeoStatusEventsRequestFormat(string $dateTransmission, array $postData): array
    {
        return [
            'date_transmission' => $dateTransmission, //Triggered date and Time
            'situation' => [
                'situation_code' => $postData['situation_code'],
                //situation_code depends on Status_id from tb_stop_status
                'justification_code' => $postData['justification_code'],
                //justification_code depends on Status_id from tb_stop_status
                'date' => $dateTransmission,
                //Triggered date and Time
                'input_date' => $dateTransmission
                //Triggered date and Time
            ],
            'situation_justification' => [
                'pair' => [
                    'mean' => [
                        'id' =>
                            $postData['truck_number'],
                    ], //Vehicle Number
                    'mean_create' => [
                        'label' => $postData['truck_number'], //Vehicle Number
                        'telematic_unit_id' => $postData['truck_number'], //Vehicle Number
                        'telematicConfiguration' => SHIPPEO_TELEMATICCONFIGURATION,
                        'mode' => 'truck',
                    ],
                ],
            ],
        ];
    }

    /**
     *  Description:     It will Generate situation_code and justification_code using Order_Status_id
     */
    public function situationJustificationCode(array $postData): array
    {
        $stid = $postData["stid"];
        $stype = $postData["stype"];
        if ($stid == "10") {
            // Driver Accept
            $postData['situation_code'] = 'COM';
            $postData['justification_code'] = 'CFM';
        } elseif ($stid == "2" && $stype == "P") {
            // GATEIN
            $postData['situation_code'] = 'EML';
            $postData['justification_code'] = 'CFM';
        } elseif ($stid == "1" && $stype == "P") {
            // GATEIN PICKUP
            $postData['situation_code'] = 'EML';
            $postData['justification_code'] = 'ARS';
        } elseif ($stid == "3" && $stype == "P") {
            // GATEOUT PICKUP
            $postData['situation_code'] = 'ECH';
            $postData['justification_code'] = 'CFM';
        } elseif ($stid == "4" && $stype == "P") {
            // In-Transit
            $postData['situation_code'] = 'MLV';
            $postData['justification_code'] = 'CFM';
        } elseif ($stid == "1" && $stype == "D") {
            // Destination - delivery
            $postData['situation_code'] = 'LIV';
            $postData['justification_code'] = 'CFM';
        } elseif ($stid == "3" && $stype == "D") {
            // Destination - Gateout
            $postData['situation_code'] = 'LIV';
            $postData['justification_code'] = 'DES';
        } else {
            $postData['situation_code'] = '';
            $postData['justification_code'] = '';
        }

        return $postData;
    }

    /**
     *  Description:  Whenever an Order Status is changed in Mass Status Update then this function will trigger Shippeo  Events Service Calls.
     */
    public function shippeo_event_call(int $orderId, array $postData, string $curtz, int $stId, string $sType, string $vehicleId, string $ediReference, string $companyCode, string $branchCode, int $userId): void
    {
        if (!array_key_exists($branchCode, ShippeoIdentifiers::BRANCH_PARTY_IDENTIFIERS)) {
            log_message('error', 'src\application\libraries\Shippeostatusintigration.php (215) >>> reviced invalid branch code '.$branchCode);
            return;
        }
        log_message('error','shippeo_event_call:: 217 => shippo event triggered.. $postData => '. json_encode($postData,128));
        $ci = &get_instance();
        $ci->load->model("common");
        $postData["edi_reference"] = $ediReference;
        $getactual = getdatetimebytimezone(DFLT_TZ, date('Y-m-d H:i:s'), $curtz);
        $postData['date_transmission'] = $getactual['datetime'];
        $postData["truck_number"] = null;
        $chktruck = $ci->db->query("SELECT truck_number FROM tb_trucks_data WHERE id = ? LIMIT 1", [$vehicleId]);
        if ($chktruck !== false && $chktruck->num_rows() > 0) {
            $postData["truck_number"] = $chktruck->row()->truck_number;
        }
        $postData["stid"] = $stId;
        $postData["stype"] = $sType;
        $this->shippeoStatusUpdate($postData);
        $this->logShippeoEventsCall($this->getEdi_request(), $this->getEdi_response(), $this->getOrder_id(), $companyCode, $branchCode, $userId);
    }

    /**
     *  Description:     It will check Is Order Shippeo or not depends on edi_reference(its specifi for Poland).
     */
    function is_shippeo_order(int $orderId, string $companyCode, string $branchCode): string
    {
        if (!array_key_exists($branchCode, ShippeoIdentifiers::BRANCH_PARTY_IDENTIFIERS)) {
            return 0;
        }
        if ($this->is_shippeo_partyidentifier($orderId, $branchCode)) {
            $this->isshippeovalidtoken();
            $ci = &get_instance();
            $ci->load->model("common");
            $chkreference = $ci->common->gettblrowdata(['order_id' => $orderId, 'reference_id' => 'ABO', 'status' => 1], 'ref_value', 'tb_order_references', 0, 0);
            log_message('error', 'src\application\libraries\Shippeostatusintigration.php (247) >>> $this->db->last_query() >>> '.$ci->db->last_query());
            log_message('error', 'src\application\libraries\Shippeostatusintigration.php (248) >>> $chkreference[ref_value] >>> '.$chkreference['ref_value']);
            return empty($chkreference) ? 0 : $chkreference['ref_value'] ?? 0;
        } else {
            return 0;
        }
    }

    /**
     *  Description: It checks token expires or not if it expires it will generate new token.
     */

    function isshippeovalidtoken(): void
    {
        $ci = &get_instance();
        $ci->load->model("common");
        $chktoken = $ci->common->shippeotoken(SHIPPEOTOKENVALIDITY);
        if (!empty($chktoken)) {
            $ci->load->library("shippeotokengeneration");
            $ci->shippeotokengeneration->shippeotokenUpdate();
        }
    }

    /**
     *  Description: It will check specific order is belongs to shippeo or not.
     */

    function is_shippeo_partyidentifier(int $orderId, string $branchCode): bool
    {
        $ci = &get_instance();
        $ci->load->model("common");
        $party_types_query = "SELECT
                                tbl_party_master.partyindetifier
                                FROM tb_order_parties
                                JOIN `tbl_party_types` ON (tb_order_parties.party_type = tbl_party_types.id)
                                JOIN `tbl_party_master` ON (tb_order_parties.party_id = tbl_party_master.id)
                                WHERE order_id = ? AND (tbl_party_types.name = 'customer' OR tbl_party_types.name= 'FREIGHT_PAYER')
                                ORDER BY tbl_party_types.name DESC LIMIT 1";
        $chkpartyid = $ci->db->query($party_types_query, [$orderId])->row_array();
        log_message('error', 'src\application\libraries\Shippeostatusintigration.php (284) >>> $this->db->last_query() >>> '.$ci->db->last_query());
        $partyIdentifier = $chkpartyid['partyindetifier'] ?? '';
        return !empty($partyIdentifier) && in_array($partyIdentifier, ShippeoIdentifiers::getPartyIdentifiersByBranchCode($branchCode));
    }

    /**
     *  Description: Logging Shippeo Status Events Service Calls(its specifi for Poland).
     */
    private function logShippeoEventsCall(string $ediRequest, ?array $ediResponse, string $orderId, string $companyCode, string $branchCode, int $userId): void
    {
        $ci = &get_instance();
        $ci->load->model("common");
        $ediTypes = $ci->common->gettblrowdata(['edi_name' => 'SHIPPEO_EVENTS'], 'id', 'tb_edi_types', 0, 0);
        if (empty($ediTypes)) {
            log_message("error", "There is no any edi type with name `SHIPPEO_EVENTS`");
            return;
        }
        $ediId = $ediTypes['id'];
        $params = [
            'edi_type' => 2, //'1->EDI Transport Order,2->EDI Status'
            'transaction_id' => time(),
            'edi_id' => $ediId, // edi id based on name take it from tb_edi_types
            'edi_name' => 'SHIPPEO_EVENTS',
            'bounded_type' => 2, // '1->Inbound(partner => kN),2->Outbound (KN => partner)'
            'edi_format_type' => 'JSON',
            'status' => $this->getEdi_status_flag(),
            'obj_type' => 1,
            'txn_obj_id' => $orderId,
            'user_id' => $userId,
            'company_code' => $companyCode,
            'branch_code' => $branchCode,
            'edi_request' => $ediRequest,
            'edi_response' => is_null($ediResponse) ? null : json_encode($ediResponse)
        ];
        log_message('error','logShippeoEventsCall :: 317 => shippo event triggered.. params => '. json_encode($params,128));
        $ci->common->insertTableData('tb_etn_edi_transactions', $params);
        log_message('error', 'src\application\libraries\Shippeostatusintigration.php (319) >>> '. $ci->db->last_query());
    }

}
