<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Singletriporder
{
    private $ci;

    public function __Construct()
    {
        $this->ci = &get_instance();
        $this->ci->load->model('common');
        $this->ci->load->helper('log_helper');
    }

    public function ordercreatetrip($ordinput)
    {
        log_error(UNIQLO_LOG_PREFIX . "ordercreatetrip inbound data: " . implode(', ', $ordinput));

        $response = 0;
        if (!empty($ordinput)) {
            $userid = $ordinput['user_id'];
            $curtz = $ordinput['curtz'] = date_default_timezone_get();
            $year = date('y');
            $week = date('W');
            $curdt = date('Y-m-d H:i:s');
            $order = $this->ci->common->gettblrowdata(array("id" => $ordinput['order_id']), "*", "tb_orders", 0, 0);
            if (!empty($order)) {
                if ($order['shift_id'] > 0) {
                    $response = $order['shift_id'];
                } else {
                    $ordinput['company_code'] = $order['company_code'];
                    $count_code = substr($ordinput['company_code'], 0, 2);
                    $input['ordid'] = $ordinput['order_id'];
                    $order_nm = $order['order_id'];
                    $seq_num = substr($order_nm, -6);
                    $shipid = "T" . $count_code . $week . $year . $seq_num;

                    $vendor_id = $ordinput['carrier_id'];
                    $vehicle_id = "";
                    $driver_id = "";
                    $ttype = $this->ci->common->gettblrowdata(
                        array("trucktype" => "LTL", "status" => "Active", "company_code" => $ordinput['company_code']),
                        "id,trucktype",
                        "tb_trucktypes",
                        0,
                        0
                    );
                    if (count($ttype) > 0) {
                        $tpvehicle_type = $ttype['id'];
                        $vehicle_type = $ttype['trucktype'];
                    } else {
                        $tpvehicle_type = 1;
                        $vehicle_type = 'truck';
                    }
                    $carrier_instructions = "";
                    if ($shipid != "" && $ordinput['order_id'] > 0) {
                        $shift_idchk = isset($order['shift_id']) ? $order['shift_id'] : 0;
                        if ($shift_idchk == 0) {
                            $pickup = $order['pickup_address1'];
                            if ($pickup == "") {
                                $pickup = $order['pickup_city'];
                            }
                            $delivery = $order['delivery_address1'];
                            if ($delivery == "") {
                                $delivery = $order['delivery_city'];
                            }
                            $address = $dropaddr = "";
                            if ($order['pickup_address1'] != "") {
                                $address .= $order['pickup_address1'];
                                $dropaddr .= $order['delivery_address1'];
                            }
                            if ($order['pickup_company'] != "") {
                                $address .= ", " . $order['pickup_company'];
                                $dropaddr .= ", " . $order['delivery_company'];
                            }
                            if ($order['pickup_country'] != "") {
                                $address .= ", " . $order['pickup_country'];
                                $dropaddr .= ", " . $order['delivery_country'];
                            }
                            if ($order['pickup_city'] != "") {
                                $address .= ", " . $order['pickup_city'];
                                $dropaddr .= ", " . $order['delivery_city'];
                            }
                            if ($order['pickup_pincode'] != "") {
                                $address .= ", " . $order['pickup_pincode'];
                                $dropaddr .= ", " . $order['delivery_pincode'];
                            }
                            $plat = $order['plat'];
                            $plng = $order['plng'];
                            $dlat = $order['dlat'];
                            $dlng = $order['dlng'];
                            $where = array("shipmentid" => $shipid);
                            $select = "id,splace,slat,slng,eplace,elat,elng,vendor_id,weight,volume,units,vehicle_type";
                            $table = "tb_shifts";
                            $shipment = $this->ci->common->gettblrowdata($where, $select, $table, 0, 0);
                            if (count($shipment) == 0) {
                                $splace = $order['pickup_address1'];
                                $eplace = $order['delivery_address1'];
                                $pickup_city = $order['pickup_city'];
                                $delivery_city = $order['delivery_city'];
                                $customer_id = $order['customer_id'];
                                $transport_mode = $order['transport_mode'];
                                $weight = $order['weight'];
                                $volume = $order['volume'];
                                $txnid = $shipid;
                                $startdate = $order['pickup_datetime'];
                                $starttime = date('H:i', strtotime($startdate));
                                $enddate = $order['delivery_datetime'];
                                $endtime = date('H:i', strtotime($enddate));
                                /*$getactual = getdatetimebytimezone(DFLT_TZ,$enddate,$curtz);
                                $enddate = $getactual['datetime'];*/
                                $insarr = array(
                                    'user_id' => $userid,
                                    'stime' => $starttime,
                                    'etime' => $endtime,
                                    'splace' => $order['pickup_city'],
                                    'slat' => $plat,
                                    'slng' => $plng,
                                    'eplace' => $order['delivery_city'],
                                    'elat' => $dlat,
                                    'elng' => $dlng,
                                    'scity' => $order['pickup_city'],
                                    'dcity' => $order['delivery_city'],
                                    'zone_id' => 1,
                                    'empshift_start' => $starttime,
                                    'empshift_end' => $endtime,
                                    'trip_type' => 0,
                                    'startdate' => $startdate,
                                    'enddate' => $enddate,
                                    'shipment_name' => 'Boxes',
                                    'shipment_id' => 0,
                                    'transport_mode' => $transport_mode,
                                    'customer_id' => $customer_id,
                                    'vendor_id' => $vendor_id,
                                    'carrier_type' => 0,
                                    'shipmentid' => $shipid,
                                    'txnid' => $txnid,
                                    'weight' => $weight,
                                    'volume' => $volume,
                                    'units' => $order['quantity'],
                                    'domainname' => 'INFD',
                                    'vehicle_type' => $vehicle_type,
                                    'company_code' => $order['company_code'],
                                    'branch_code' => $order['branch_code'],
                                    'carrier_instructions' => $carrier_instructions,
                                    'status' => 1
                                );

                                log_error(
                                    UNIQLO_LOG_PREFIX .
                                    "ordercreatetrip inserted data in a tb_shifts: " . implode(', ', $insarr)
                                );

                                $ship_id = $this->ci->common->insertTableData("tb_shifts", $insarr);
                            } else {
                                $ship_id = $shipment['id'];
                            }
                            /* update order table */
                            $upddt = array(
                                'vendor_id' => $vendor_id,
                                'shift_id' => $ship_id,
                                "shipmentid" => $shipid,
                                "status" => 2
                            );
                            $updwhr = array("id" => $ordinput['order_id']);

                            log_error(
                                UNIQLO_LOG_PREFIX .
                                "ordercreatetrip updated data in a tb_orders: " . implode(', ', $upddt)
                            );

                            $upd = $this->ci->common->updatetbledata("tb_orders", $upddt, $updwhr);
                            /*$invtypes = makeorderinvolvedpartiestype($vendor_id, $ordinput['order_id'], "CARRIER");
                            $this->ci->ordernotify('trip_create', $ordinput['order_id']);*/
                            $capacity = $order['weight'];
                            if ($capacity == "") {
                                $capacity = "0";
                            }
                            /* insert stops records */
                            $where = array(
                                "shipment_id" => $ship_id,
                                "stopcity" => $order['pickup_city'],
                                "stoptype" => "P"
                            );
                            $select = "id";
                            $table = "tb_shiporder_stops";
                            $chkstop = $this->ci->common->gettblrowdata($where, $select, $table, 0, 0);
                            if (count($chkstop) == 0) {
                                $insarr = array(
                                    'stopname' => $order['pickup_city'],
                                    'plat' => $plat,
                                    'plng' => $plng,
                                    'stopcity' => $order['pickup_city'],
                                    'address' => $address,
                                    'stoptype' => 'P',
                                    'stopstatus' => 0,
                                    'shipment_id' => $ship_id,
                                    'ordernumber' => 1,
                                    'startdate' => $order['pickup_datetime'],
                                    'enddate' => $order['pickup_endtime'],
                                    'weight' => $order['weight'],
                                    'volume' => $order['volume'],
                                    'shipmentstopid' => 0,
                                    'ship_units' => $order['quantity'],
                                    'txncode' => 'NP',
                                    'status' => 1,
                                    'created_on' => $curdt
                                );

                                log_error(
                                    UNIQLO_LOG_PREFIX .
                                    "ordercreatetrip inserted data in a tb_shiporder_stops: " . implode(', ', $insarr)
                                );

                                $pickupstop_id = $this->ci->common->insertTableData("tb_shiporder_stops", $insarr);
                            } else {
                                $pickupstop_id = $chkstop['id'];
                            }
                            $where = array(
                                "shipment_id" => $ship_id,
                                "stopcity" => $order['delivery_city'],
                                "stoptype" => "D"
                            );
                            $select = "id";
                            $table = "tb_shiporder_stops";
                            $chkstop = $this->ci->common->gettblrowdata($where, $select, $table, 0, 0);
                            if (count($chkstop) == 0) {
                                $insarr = array(
                                    'stopname' => $order['delivery_city'],
                                    'plat' => $dlat,
                                    'plng' => $dlng,
                                    'stopcity' => $order['delivery_city'],
                                    'address' => $dropaddr,
                                    'stoptype' => 'D',
                                    'stopstatus' => 0,
                                    'shipment_id' => $ship_id,
                                    'ordernumber' => 2,
                                    'startdate' => $order['delivery_datetime'],
                                    'enddate' => $order['drop_endtime'],
                                    'weight' => $order['weight'],
                                    'volume' => $order['volume'],
                                    'shipmentstopid' => 0,
                                    'ship_units' => $order['quantity'],
                                    'txncode' => 'NP',
                                    'status' => 1,
                                    'created_on' => $curdt
                                );

                                log_error(
                                    UNIQLO_LOG_PREFIX .
                                    "ordercreatetrip inserted data in a tb_shiporder_stops: " . implode(', ', $insarr)
                                );

                                $dropstop_id = $this->ci->common->insertTableData("tb_shiporder_stops", $insarr);
                            } else {
                                $dropstop_id = $chkstop['id'];
                            }
                            /* add pickupstop and drop stop id into details/tb_employee table */
                            $where = array(
                                'stop_id' => $pickupstop_id,
                                'drop_stopid' => $dropstop_id,
                                'order_id' => $order['order_id'],
                                'shift_id' => $ship_id
                            );
                            $select = "id";
                            $table = "tb_employee";
                            $chkemp = $this->ci->common->gettblrowdata($where, $select, $table, 0, 0);
                            if (count($chkemp) == 0) {
                                $insarr = array(
                                    'assoc_id' => $shipid,
                                    'pickup' => $pickup,
                                    'plat' => $plat,
                                    'plng' => $plng,
                                    'drop' => $delivery,
                                    'dlat' => $dlat,
                                    'dlng' => $dlng,
                                    'pickup_city' => $order['pickup_city'],
                                    'drop_city' => $order['delivery_city'],
                                    'pickup_datetime' => $order['pickup_datetime'],
                                    'drop_datetime' => $order['delivery_datetime'],
                                    'name' => 'Boxes',
                                    'phone' => $order['customer_phone'],
                                    'address' => $address,
                                    'emailid' => $order['customer_email'],
                                    'user_id' => $userid,
                                    'status' => 1,
                                    'createdon' => $curdt,
                                    'material_id' => 0,
                                    'capacity' => $capacity,
                                    'information' => $order['customer_comments'],
                                    'shipment_weight' => $order['weight'],
                                    'shipment_volume' => $order['volume'],
                                    'ship_type' => 'P',
                                    'customer_id' => $order['customer_id'],
                                    'vendor_id' => $vendor_id,
                                    'shipment_id' => 0,
                                    'startdate' => $order['pickup_datetime'],
                                    'enddate' => $order['delivery_datetime'],
                                    'shift_id' => $ship_id,
                                    'stop_order' => 1,
                                    'drop_order' => 0,
                                    'basic_stop' => 0,
                                    'stop_id' => $pickupstop_id,
                                    'drop_stopid' => $dropstop_id,
                                    'order_id' => $order['order_id'],
                                    'pkgitemid' => 'BOXES',
                                    'no_of_pkgs' => $order['quantity'],
                                    'domainname' => 'INFD'
                                );

                                log_error(
                                    UNIQLO_LOG_PREFIX .
                                    "ordercreatetrip inserted data in a tb_employee: " . implode(', ', $insarr)
                                );

                                $detail_id = $this->ci->common->insertTableData("tb_employee", $insarr);
                            } else {
                                $detail_id = $chkemp['id'];
                            }

                            log_error(
                                UNIQLO_LOG_PREFIX .
                                "ordercreatetrip updated data in a tb_order_cargodetails: " . implode(
                                    ', ',
                                    ["stop_detail_id" => $detail_id]
                                )
                            );

                            $upd = $this->ci->common->updatetbledata(
                                "tb_order_cargodetails",
                                array("stop_detail_id" => $detail_id),
                                array("order_id" => $ordinput['order_id'])
                            );
                            $chk1 = $this->ci->common->gettblrowdata(
                                array("shft_id" => $ship_id),
                                "id",
                                "tb_shft_veh",
                                0,
                                0
                            );
                            if (count($chk1) > 0) {
                                $shftvehid = $chk1['id'];
                                $chk = $this->ci->common->gettblrowdata(
                                    array("shft_veh_id" => $shftvehid, "status" => 1),
                                    "id",
                                    "tb_shft_veh_emp",
                                    0,
                                    0
                                );
                                if (count($chk) == 0) {
                                    $getemp = $this->ci->common->gettbldata(
                                        array("shift_id" => $ship_id),
                                        "id,pickup_datetime,drop_datetime",
                                        "tb_employee",
                                        0,
                                        0
                                    );
                                    if (count($getemp) > 0) {
                                        $pri = 1;
                                        foreach ($getemp as $gt) {
                                            $insveh1 = array(
                                                "user_id" => $userid,
                                                "shft_veh_id" => $shftvehid,
                                                "emp_id" => $gt['id'],
                                                "priority" => $pri,
                                                "pickup_time" => $gt['pickup_datetime'],
                                                'created_on' => $curdt,
                                                'updated_on' => $curdt,
                                                "status" => 1,
                                                "drop_time" => $gt['drop_datetime']
                                            );

                                            log_error(
                                                UNIQLO_LOG_PREFIX .
                                                "ordercreatetrip inserted data in a tb_shft_veh_emp: " . implode(
                                                    ', ',
                                                    $insveh1
                                                )
                                            );

                                            $ins = $this->ci->common->insertTableData("tb_shft_veh_emp", $insveh1);
                                            $pri++;
                                        }
                                    }
                                } else {
                                    $chkemp = $this->ci->common->gettblrowdata(
                                        array("shft_veh_id" => $shftvehid, "emp_id" => $detail_id, "status" => 1),
                                        "id",
                                        "tb_shft_veh_emp",
                                        0,
                                        0
                                    );
                                    if (count($chkemp) == 0) {
                                        $insveh1 = array(
                                            "user_id" => $userid,
                                            "shft_veh_id" => $shftvehid,
                                            "emp_id" => $detail_id,
                                            "priority" => 3,
                                            "pickup_time" => $order['pickup_datetime'],
                                            'created_on' => $curdt,
                                            'updated_on' => $curdt,
                                            "status" => 1,
                                            "drop_time" => $order['delivery_datetime']
                                        );

                                        log_error(
                                            UNIQLO_LOG_PREFIX .
                                            "ordercreatetrip inserted data in a tb_shft_veh_emp: " . implode(
                                                ', ',
                                                $insveh1
                                            )
                                        );

                                        $ins = $this->ci->common->insertTableData("tb_shft_veh_emp", $insveh1);
                                    }
                                }
                            } else {
                                $veh = $this->ci->common->gettblrowdata(
                                    array("vendor_id" => '310', 'status' => 'Active'),
                                    "id,register_number",
                                    "tb_trucks_data",
                                    0,
                                    0
                                );
                                if (count($veh) > 0) {
                                    $veh_num = $veh['register_number'];
                                    $vehicle_id = $veh['id'];
                                    $arr = array(
                                        'user_id' => $userid,
                                        'route_id' => 0,
                                        'shft_id' => $ship_id,
                                        'carrier_id' => $vendor_id,
                                        'vehicle_id' => $vehicle_id,
                                        'register_number' => $veh_num,
                                        'created_on' => $curdt,
                                        'updated_on' => $curdt,
                                        'status' => 1
                                    );

                                    log_error(
                                        UNIQLO_LOG_PREFIX .
                                        "ordercreatetrip inserted data in a tb_shft_veh: " . implode(', ', $arr)
                                    );

                                    $shftvehid = $this->ci->common->insertTableData("tb_shft_veh", $arr);
                                    $getemp = $this->ci->common->gettbldata(
                                        array("shift_id" => $ship_id),
                                        "id,pickup_datetime,drop_datetime",
                                        "tb_employee",
                                        0,
                                        0
                                    );
                                    if (count($getemp) > 0) {
                                        $pri = 1;
                                        foreach ($getemp as $gt) {
                                            $insveh1 = array(
                                                "user_id" => $userid,
                                                "shft_veh_id" => $shftvehid,
                                                "emp_id" => $gt['id'],
                                                "priority" => $pri,
                                                "pickup_time" => $gt['pickup_datetime'],
                                                'created_on' => $curdt,
                                                'updated_on' => $curdt,
                                                "status" => 1,
                                                "drop_time" => $gt['drop_datetime']
                                            );

                                            log_error(
                                                UNIQLO_LOG_PREFIX .
                                                "ordercreatetrip inserted data in a tb_shft_veh_emp: " . implode(
                                                    ', ',
                                                    $insveh1
                                                )
                                            );

                                            $ins = $this->ci->common->insertTableData("tb_shft_veh_emp", $insveh1);
                                            $pri++;
                                        }
                                    }
                                }
                            }
                            if ($vehicle_id != "") {
                                $chk = $this->ci->common->gettblrowdata(
                                    array("vehicle_id" => $vehicle_id),
                                    "id,driver_id,status",
                                    "tb_vehicles_drivers",
                                    0,
                                    0
                                );
                                if (count($chk) > 0) {
                                    $driver_id = $chk['driver_id'];
                                    $chk11 = $this->ci->common->gettblrowdata(
                                        array("driver_id" => $driver_id, "vehicle_id" => $vehicle_id),
                                        "id",
                                        "tbl_assigned_drivers",
                                        0,
                                        0
                                    );
                                    if (count($chk11) > 0) {
                                        log_error(
                                            UNIQLO_LOG_PREFIX .
                                            "ordercreatetrip updated data in a tbl_assigned_drivers: " .
                                            implode(', ', ["status" => '1', 'updated_on' => $curdt])
                                        );

                                        $upd = $this->ci->common->updatetbledata(
                                            "tbl_assigned_drivers",
                                            array(
                                                "status" => '1',
                                                'updated_on' => $curdt
                                            ),
                                            array("id" => $chk11['id'])
                                        );
                                    } else {
                                        $insarr = array(
                                            "vehicle_id" => $vehicle_id,
                                            "user_id" => $userid,
                                            "driver_id" => $driver_id,
                                            "mobile_no" => $driver_id,
                                            "imei" => "",
                                            "from_time" => $curdt,
                                            "to_time" => $curdt,
                                            "status" => "1",
                                            'created_on' => $curdt
                                        );

                                        log_error(
                                            UNIQLO_LOG_PREFIX .
                                            "ordercreatetrip inserted data in a tbl_assigned_drivers: " . implode(
                                                ', ',
                                                $insarr
                                            )
                                        );

                                        $ins = $this->ci->common->insertTableData("tbl_assigned_drivers", $insarr);
                                    }
                                }
                            }
                            $response = $ship_id;
                            /* update status */
                            $chk = $this->ci->common->gettblrowdata(
                                array("shipment_id" => $ship_id, "status_id" => 9),
                                "id",
                                "tb_stop_status",
                                0,
                                0
                            );
                            if (count($chk) == 0) {
                                $ins = array(
                                    "order_id" => $ordinput['order_id'],
                                    "shipment_id" => $ship_id,
                                    "stop_id" => 0,
                                    "stop_detail_id" => 0,
                                    "stop_type" => "",
                                    "trip_id" => 0,
                                    "status_id" => 9,
                                    "status" => 1,
                                    "status_code" => "0100",
                                    "reason" => "Coming from E-Booking",
                                    "createdon" => $curdt
                                );

                                log_error(
                                    UNIQLO_LOG_PREFIX .
                                    "ordercreatetrip inserted data in a tb_stop_status: " . implode(', ', $ins)
                                );

                                $insqry = $this->ci->common->insertTableData("tb_stop_status", $ins);
                            }
                        }
                    }
                }
            }
        }

        log_error(UNIQLO_LOG_PREFIX . "ordercreatetrip outbound data: " . $response);

        return $response;
    }
}