<?php

class Standardbookinghandler
{
    private $ci;

    public function __construct()
    {
        $this->ci = &get_instance();
        $this->ci->load->helper('Log');
        $this->ci->load->model(['common', 'Standardbookingmodel', 'carriercommonmodel', 'Order']);
        $this->ci->load->library(['Altovaordercreation', 'knlogin']);
    }

    public function pullOrderXml(array $data): void
    {
        $filterData = $this->orderData($data);
        if (1 == $filterData['status']) {
            echo "Order Creation Failed, : " . $filterData['message'];
            return;
        }
        $BookingId = $this->saveOrderDetails($filterData['data']);
        echo "Order Created Successfully: Booking - " . $BookingId;
    }

    public function insertOrderXmlData(array $data): array
    {
        $filterData = $this->orderDTOData($data);
        if (1 == $filterData['status']) {
            return ["Order Creation Failed : " . $filterData['message']];
        }
        $BookingId = $this->saveOrderDetails($filterData['data']);
        return ["Order Created Successfully: Booking - " . $BookingId];
    }

    public function orderData(array $data): array
    {
        $orderInfo   = $data['SVKEDIOrderBody'];
        $orderHeader = $data['SVKEDIOrderHeader'];
        log_message("error","extordid:".json_encode($orderInfo));

        $externalOrderID = (empty($orderInfo['EXTOrderID']) ? "0" : $orderInfo['EXTOrderID']);
        log_message("error","extordid:".$orderInfo['EXTOrderID']);
        if ($externalOrderID == 0) {
            return ["status" => 1, "message" => 'External Order ID in the XML: ' . $orderInfo['EXTOrderID']];
        }
        $orderType = (empty($orderInfo['OrderType']) ? "" : $orderInfo['OrderType']);
        if (! empty($orderType)) {
            $orderType = $this->ci->Standardbookingmodel->checkOrderType($orderInfo);
            if ($orderType == 0) {
                log_error('Standard Order Create :  Invalid Order Type ' . $orderType);
                return ["status" => 1, "message" => ' Invalid Order Type ' . $orderType];
            }
        }
        $modeOfTransport = (empty($orderInfo['ModeOfTransport']) ? "" : $orderInfo['ModeOfTransport']);
        if (! empty($modeOfTransport)) {
            $modeOfTransport = $this->ci->Standardbookingmodel->checkModeOfTransport($modeOfTransport);
            if (empty($modeOfTransport)) {
                log_error('Standard Order Create :  Invalid Mode Of Transport ' . $modeOfTransport);
                return ["status" => 1, "message" => 'Invalid Mode Of Transport ' . $modeOfTransport];
            }
        } else {
            log_error('Standard Order Create : Empty  Mode Of Transport');
            return ["status" => 1, "message" => 'Empty  Mode Of Transport'];
        }
        $product = (empty($orderInfo['Product']) ? "" : $orderInfo['Product']);
        if (! empty($product)) {
            $product = $this->ci->Standardbookingmodel->checkProduct($product);
            if (empty($product)) {
                log_error('Standard Order Create :  Invalid Product ' . $product);
                return ["status" => 1, "message" => 'Invalid Product' . $product];
            }
        }
        $serviceType = (empty($orderInfo['ServiceType']) ? "" : $orderInfo['ServiceType']);
        if ($serviceType != "") {
            $serviceType = $this->ci->Standardbookingmodel->checkServiceType($serviceType);
            if (empty($serviceType)) {
                log_error('Standard Order Create :  Invalid Service Type ' . $serviceType);
                return ["status" => 1, "message" => ' Invalid Service Type ' . $serviceType];
            }
        }
        $orderData = [
            'EXTOrderID'         => $externalOrderID,
            'OrderID'            => (empty($orderInfo['OrderID']) ? $externalOrderID : $orderInfo['OrderID']),
            'OrderType'          => $orderType,
            'ModeOfTransport'    => $modeOfTransport,
            'Product'            => $product,
            'ServiceType'        => $serviceType,
            'TypeOfBusiness'     => (empty($orderInfo['TypeOfBusiness']) ? "0" : $orderInfo['TypeOfBusiness']),
            'Incoterm'           => (empty($orderInfo['TermsOfTrade']['Incoterm']) ? "" : $orderInfo['TermsOfTrade']['Incoterm']),
            'FreightTerm'        => (empty($orderInfo['TermsOfTrade']['FreightName']['Term']) ? "" : $orderInfo['TermsOfTrade']['FreightName']['Term']),
            'FreightTermName'    => (empty($orderInfo['TermsOfTrade']['FreightName']['Name']) ? "" : $orderInfo['TermsOfTrade']['FreightName']['Name']),
            'company_code'       => (empty($orderInfo['SVKOrgDetails']['Companycode']) ? "" : $orderInfo['SVKOrgDetails']['Companycode']),
            'branch_code'        => (empty($orderInfo['SVKOrgDetails']['Branchcode']) ? "" : $orderInfo['SVKOrgDetails']['Branchcode']),
            'department_code'    => (empty($orderInfo['SVKOrgDetails']['Departmentcode']) ? "" : $orderInfo['SVKOrgDetails']['Departmentcode']),
            'physicalReceiver'   => (empty($orderInfo['SVKOrgDetails']['PhysicalReceiver']) ? "" : $orderInfo['SVKOrgDetails']['PhysicalReceiver']),
            'logicalReceiver'    => (empty($orderInfo['SVKOrgDetails']['LogicalReceiver']) ? "" : $orderInfo['SVKOrgDetails']['LogicalReceiver']),
            'physicalSender'     => (empty($orderInfo['SVKOrgDetails']['PhysicalSender']) ? "" : $orderInfo['SVKOrgDetails']['PhysicalSender']),
            'logicalSender'      => (empty($orderInfo['SVKOrgDetails']['LogicalSender']) ? "" : $orderInfo['SVKOrgDetails']['LogicalSender']),
            'customerDetails'    => $orderInfo['CustomerDetails'],
            'sourceInfo'         => $orderInfo['LocationInfo']['Source'],
            'destinationInfo'    => $orderInfo['LocationInfo']['Destination'],
            'cargoSummary'       => $orderInfo['CargoSummary'],
            'cargoDetails'       => $orderInfo['CargoDetails'],
            'valueAddedServices' => $orderInfo['ValueAddedServices'],
            'involvedParties'    => $orderInfo['InvolvedParties'],
            'manageReferences'   => $orderInfo['ManageReferences'],
            'remarks'            => $orderInfo['Remarks'],
            'header'             => $orderHeader,
        ];
        return ["status" => 0, "data" => $orderData];
    }

    public function orderDTOData(array $data): array
    {
        $orderInfo   = $data['SVKEDIOrderBody'];
        $orderHeader = $data['SVKEDIOrderHeader'];

        $externalOrderID = (empty($orderInfo['EXTOrderID']) ? "" : $orderInfo['EXTOrderID']);
        if (! empty($externalOrderID)) {
            $shipmentDetails = $this->ci->Standardbookingmodel->getOrderShipment($externalOrderID);
            if (! empty($shipmentDetails)) {
                $shiftId    = $shipmentDetails['shift_id'];
                $shipmentId = $shipmentDetails['shipmentid'];
            }
            if ($shiftId != "" && $shipmentId != "") {
                log_error('Standard Trip Create :  Trip Already Created for Booking ' . $externalOrderID);
                return ["status" => 1, "message" => ' Trip Already Created for Booking ' . $externalOrderID];
            }
        } else {
            return ["status" => 1, "message" => 'External Order ID in the XML: ' . $orderInfo['EXTOrderID']];
        }
        $orderType = (empty($orderInfo['OrderType']) ? "" : $orderInfo['OrderType']);
        if (! empty($orderType)) {
            $orderType = $this->ci->Standardbookingmodel->checkOrderType($orderInfo);
            if ($orderType == 0) {
                log_error('Standard Order Create :  Invalid Order Type ' . $orderType);
                return ["status" => 1, "message" => ' Invalid Order Type ' . $orderType];
            }
        }
        $modeOfTransport = (empty($orderInfo['ModeOfTransport']) ? "" : $orderInfo['ModeOfTransport']);
        if (! empty($modeOfTransport)) {
            $modeOfTransport = $this->ci->Standardbookingmodel->checkModeOfTransport($modeOfTransport);
            if (empty($modeOfTransport)) {
                log_error('Standard Order Create :  Invalid Mode Of Transport ' . $modeOfTransport);
                return ["status" => 1, "message" => 'Invalid Mode Of Transport ' . $modeOfTransport];
            }
        } else {
            log_error('Standard Order Create : Empty  Mode Of Transport');
            return ["status" => 1, "message" => 'Empty  Mode Of Transport'];
        }
        $product = (empty($orderInfo['Product']) ? "" : $orderInfo['Product']);
        if (! empty($product)) {
            $product = $this->ci->Standardbookingmodel->checkProduct($product);
            if (empty($product)) {
                log_error('Standard Order Create :  Invalid Product ' . $product);
                return ["status" => 1, "message" => 'Invalid Product' . $product];
            }
        }
        $serviceType = (empty($orderInfo['ServiceType']) ? "" : $orderInfo['ServiceType']);
        if ($serviceType != "") {
            $serviceType = $this->ci->Standardbookingmodel->checkServiceType($serviceType);
            if (empty($serviceType)) {
                log_error('Standard Order Create :  Invalid Service Type ' . $serviceType);
                return ["status" => 1, "message" => ' Invalid Service Type ' . $serviceType];
            }
        }
        $customerData  = [];
        $customerData1 = (empty($orderInfo['CustomerDetails']['ID']) ? "" : $orderInfo['CustomerDetails']['ID']);
        if ($customerData1 != "") {
            $customerData = $this->ci->Standardbookingmodel->checkPartyType($customerData1);
            if (empty($customerData)) {
                log_error('Standard Trip Create :  Invalid Customer ' . $orderInfo['CustomerDetails']['ID']);
                return ["status" => 1, "message" => ' Invalid Customer ' . $orderInfo['CustomerDetails']['ID']];
            } else {
                $orderInfo['CustomerDetails']['ID']      = $customerData['code'];
                $orderInfo['CustomerDetails']['Company'] = [
                    'Name' => $customerData['name'],
                ];
                $orderInfo['CustomerDetails']['Address'] = [
                    'CustomerName' => $customerData['name'],
                    'Address1'     => $customerData['address'],
                    'Street'       => $customerData['street'],
                    'State'        => $customerData['state'],
                    'Postal'       => $customerData['pincode'],
                    'Country'      => $customerData['country'],
                    'Latitude'     => $customerData['latitude'],
                    'Longitude'    => $customerData['longitude'],
                    'ContactInfo'  => [
                        'ContactNo'    => $customerData['mobile'],
                        'EmailAddress' => $customerData['email'],
                    ],
                ];
                $orderInfo['CustomerDetails']['ID'] = $customerData['code'];
            }
        }
        $pickupData  = [];
        $pickupData1 = (empty($orderInfo['LocationInfo']['Source']['ID']) ? "" : $orderInfo['LocationInfo']['Source']['ID']);
        if ($pickupData1 != "") {
            $pickupData = $this->ci->Standardbookingmodel->checkPartyType($pickupData1);
            //log_message("error","Qry:".$this->ci->db->last_query());
            if (empty($pickupData)) {
                log_error('Standard Trip Create :  Invalid Pickup ' . $pickupData);
                return ["status" => 1, "message" => ' Invalid Pickup ' . $pickupData];
            } else {

                $orderInfo['LocationInfo']['Source']['ID']      = $pickupData['code'];
                $orderInfo['LocationInfo']['Source']['Company'] = [
                    'Name' => $pickupData['name'],
                ];
                $orderInfo['LocationInfo']['Source']['Address'] = [
                    'CompanyName' => $pickupData['name'],
                    'Address1'    => $pickupData['address'],
                    'Street'      => $pickupData['street'],
                    'State'       => $pickupData['state'],
                    'Postal'      => $pickupData['pincode'],
                    'Country'     => $pickupData['country'],
                    'Latitude'    => $pickupData['latitude'],
                    'Longitude'   => $pickupData['longitude'],
                    'ContactInfo' => [
                        'ContactNo'    => $pickupData['mobile'],
                        'EmailAddress' => $pickupData['email'],
                    ],
                ];
            }
        }
        $deliveryData  = [];
        $deliveryData1 = (empty($orderInfo['LocationInfo']['Destination']['ID']) ? "" : $orderInfo['LocationInfo']['Destination']['ID']);
        if ($deliveryData1 != "") {
            $deliveryData = $this->ci->Standardbookingmodel->checkPartyType($deliveryData1);
            //("error","Qry:".$this->ci->db->last_query());
            if (empty($deliveryData)) {
                log_error('Standard Trip Create :  Invalid Destination ' . $deliveryData1);
                return ["status" => 1, "message" => ' Invalid Destination ' . $deliveryData1];
            } else {

                $orderInfo['LocationInfo']['Destination']['ID']      = $deliveryData['code'];
                $orderInfo['LocationInfo']['Destination']['Address'] = [
                    'CompanyName' => $deliveryData['name'],
                    'Address1'    => $deliveryData['address'],
                    'Street'      => $deliveryData['street'],
                    'State'       => $deliveryData['state'],
                    'Postal'      => $deliveryData['pincode'],
                    'Country'     => $deliveryData['country'],
                    'ContactInfo' => [
                        'ContactNo'    => $deliveryData['mobile'],
                        'EmailAddress' => $deliveryData['email'],
                    ],
                ];
            }
        }
        if (! empty($orderInfo['InvolvedParties']['PartyType'])) {
            foreach ($orderInfo['InvolvedParties']['PartyType'] as $key => $party) {
                if (isset($party['Type']) && strtoupper($party['Type']) === "SHIPPER") {
                    $shipperId = (empty($party['ID']) ? "" : $party['ID']);

                    if ($shipperId != "" && ! empty($pickupData)) {
                        $orderInfo['InvolvedParties']['PartyType'][$key]['ID']      = $pickupData['code'];
                        $orderInfo['InvolvedParties']['PartyType'][$key]['Company'] = [
                            'Name' => $pickupData['name'],
                        ];
                        $orderInfo['InvolvedParties']['PartyType'][$key]['Address'] = [
                            'CompanyName' => $pickupData['name'],
                            'Address1'    => $pickupData['address'],
                            'Street'      => $pickupData['street'],
                            'State'       => $pickupData['state'],
                            'Postal'      => $pickupData['pincode'],
                            'Country'     => $pickupData['country'],
                            'Latitude'    => $pickupData['latitude'],
                            'Longitude'   => $pickupData['longitude'],
                            'ContactInfo' => [
                                'ContactNo'    => $pickupData['mobile'],
                                'EmailAddress' => $pickupData['email'],
                            ],
                        ];
                    }
                }
                if (isset($party['Type']) && strtoupper($party['Type']) === "CONSIGNEE") {
                    $consigneeId = (empty($party['ID']) ? "" : $party['ID']);

                    if ($consigneeId != "") {
                        $orderInfo['InvolvedParties']['PartyType'][$key]['ID']      = $deliveryData['code'];
                        $orderInfo['InvolvedParties']['PartyType'][$key]['Company'] = [
                            'Name' => $deliveryData['name'],
                        ];
                        $orderInfo['InvolvedParties']['PartyType'][$key]['Address'] = [
                            'CompanyName' => $deliveryData['name'],
                            'Address1'    => $deliveryData['address'],
                            'Street'      => $deliveryData['street'],
                            'State'       => $deliveryData['state'],
                            'Postal'      => $deliveryData['pincode'],
                            'Country'     => $deliveryData['country'],
                            'Latitude'    => $deliveryData['latitude'],
                            'Longitude'   => $deliveryData['longitude'],
                            'ContactInfo' => [
                                'ContactNo'    => $deliveryData['mobile'],
                                'EmailAddress' => $deliveryData['email'],
                            ],
                        ];
                    }
                }
                if (isset($party['Type']) && strtoupper($party['Type']) === "CUSTOMER") {
                    $shipperId = (empty($party['ID']) ? "" : $party['ID']);

                    if ($shipperId != "" && ! empty($customerData)) {
                        $orderInfo['InvolvedParties']['PartyType'][$key]['ID']      = $customerData['code'];
                        $orderInfo['InvolvedParties']['PartyType'][$key]['Company'] = [
                            'Name' => $customerData['name'],
                        ];
                        $orderInfo['InvolvedParties']['PartyType'][$key]['Address'] = [
                            'CompanyName' => $customerData['name'],
                            'Address1'    => $customerData['address'],
                            'Street'      => $customerData['street'],
                            'State'       => $customerData['state'],
                            'Postal'      => $customerData['pincode'],
                            'Country'     => $customerData['country'],
                            'Latitude'    => $customerData['latitude'],
                            'Longitude'   => $customerData['longitude'],
                            'ContactInfo' => [
                                'ContactNo'    => $customerData['mobile'],
                                'EmailAddress' => $customerData['email'],
                            ],
                        ];
                    }
                }
            }
        }
        $orderData = [
            'EXTOrderID'         => $externalOrderID,
            'OrderID'            => (empty($orderInfo['OrderID']) ? $externalOrderID : $orderInfo['OrderID']),
            'OrderType'          => $orderType,
            'ModeOfTransport'    => $modeOfTransport,
            'Product'            => $product,
            'ServiceType'        => $serviceType,
            'TypeOfBusiness'     => (empty($orderInfo['TypeOfBusiness']) ? "0" : $orderInfo['TypeOfBusiness']),
            'Incoterm'           => (empty($orderInfo['TermsOfTrade']['Incoterm']) ? "" : $orderInfo['TermsOfTrade']['Incoterm']),
            'FreightTerm'        => (empty($orderInfo['TermsOfTrade']['FreightName']['Term']) ? "" : $orderInfo['TermsOfTrade']['FreightName']['Term']),
            'FreightTermName'    => (empty($orderInfo['TermsOfTrade']['FreightName']['Name']) ? "" : $orderInfo['TermsOfTrade']['FreightName']['Name']),
            'company_code'       => (empty($orderInfo['SVKOrgDetails']['Companycode']) ? "" : $orderInfo['SVKOrgDetails']['Companycode']),
            'branch_code'        => (empty($orderInfo['SVKOrgDetails']['Branchcode']) ? "" : $orderInfo['SVKOrgDetails']['Branchcode']),
            'department_code'    => (empty($orderInfo['SVKOrgDetails']['Departmentcode']) ? "" : $orderInfo['SVKOrgDetails']['Departmentcode']),
            'physicalReceiver'   => (empty($orderInfo['SVKOrgDetails']['PhysicalReceiver']) ? "" : $orderInfo['SVKOrgDetails']['PhysicalReceiver']),
            'logicalReceiver'    => (empty($orderInfo['SVKOrgDetails']['LogicalReceiver']) ? "" : $orderInfo['SVKOrgDetails']['LogicalReceiver']),
            'physicalSender'     => (empty($orderInfo['SVKOrgDetails']['PhysicalSender']) ? "" : $orderInfo['SVKOrgDetails']['PhysicalSender']),
            'logicalSender'      => (empty($orderInfo['SVKOrgDetails']['LogicalSender']) ? "" : $orderInfo['SVKOrgDetails']['LogicalSender']),
            'customerDetails'    => $orderInfo['CustomerDetails'],
            'sourceInfo'         => $orderInfo['LocationInfo']['Source'],
            'destinationInfo'    => $orderInfo['LocationInfo']['Destination'],
            'cargoSummary'       => $orderInfo['CargoSummary'],
            'cargoDetails'       => $orderInfo['CargoDetails'],
            'valueAddedServices' => $orderInfo['ValueAddedServices'],
            'involvedParties'    => $orderInfo['InvolvedParties'],
            'manageReferences'   => $orderInfo['ManageReferences'],
            'remarks'            => $orderInfo['Remarks'],
            'header'             => $orderHeader,
        ];
        return ["status" => 0, "data" => $orderData];
    }

    public function saveOrderDetails(array $orderData): string
    {
        $booking_id = '';
        //$cdate           = date('Y-m-d H:i:s');
        $getactual       = getdatetimebytimezone(DFLT_TZ, date('Y-m-d H:i:s'), $timeZone);
        $logdate         = $getactual['datetime'];
        $cdate           = $logdate;
        $company_code    = $orderData['company_code'];
        $branch_code     = $orderData['branch_code'];
        $logicalReceiver = $orderData['logicalReceiver'];
        if ($logicalReceiver != "" && $company_code == "") {
            $checkBranchCompanyCodes = $this->ci->Standardbookingmodel->getBranchCompanyCodes($logicalReceiver);
            if (! empty($checkBranchCompanyCodes)) {
                $company_code = $checkBranchCompanyCodes['company_code'];
                $branch_code  = $checkBranchCompanyCodes['branch_code'];
            }
        }
        if (strlen($company_code) > 2) {
            $firstTwoChars = substr($company_code, 0, 2);
        } else {
            $firstTwoChars = $company_code;
        }
        $user_id = $this->ci->Standardbookingmodel->checkUser($company_code, $branch_code, $firstTwoChars);

        $customerInfo    = $this->checkPartyDetails($orderData['customerDetails'], $company_code, $branch_code, $user_id, "Customer");
        $sourceInfo      = $this->checkPartyDetails($orderData['sourceInfo'], $company_code, $branch_code, $user_id, "Shipper");
        $destinationInfo = $this->checkPartyDetails($orderData['destinationInfo'], $company_code, $branch_code, $user_id, "Consignee");

        $ship_row_id    = $this->insertShipmentData($orderData, $company_code, $branch_code);
        $timeZone       = $this->ci->Standardbookingmodel->getUserTimeZone($user_id);
        $order_id       = $this->ci->Standardbookingmodel->insertOrder($orderData, $customerInfo, $sourceInfo, $destinationInfo, $ship_row_id, $timeZone, $company_code, $branch_code, $user_id);
        $externalOrderId = "";
        $checkBookingId = $this->ci->common->gettblrowdata(['id' => $order_id], "order_id,external_order_id", "tb_orders", 0, 0);
        //log_message("error", "checkBookingId" . $this->ci->db->last_query());
        if (! empty($checkBookingId)) {
            $booking_id = $checkBookingId['order_id'];
            $externalOrderId = $checkBookingId['external_order_id'];
        }
        $orderDetails = [
            'shipper_id'      => $ship_row_id,
            'service'         => is_array($orderData['ServiceType']) ? "" : $orderData['ServiceType'],
            'delivery_term'   => is_array($orderData['FreightTerm']) ? "" : $orderData['FreightTerm'],
            'incoterm'        => is_array($orderData['Incoterm']) ? "" : $orderData['Incoterm'],
            'notify_party'    => "",
            'department_code' => is_array($orderData['department_code']) ? "" : $orderData['department_code'],
            'createdon'       => $cdate,
            'order_row_id'    => $order_id,
            'order_id'        => $booking_id,
            'order_type'      => is_array($orderData['OrderType']) ? "" : $orderData['OrderType'],
        ];

        $orderDetailsCount = $this->ci->Standardbookingmodel->checkOrderDetails($order_id, $booking_id);
        if ($orderDetailsCount > 0) {
            $this->ci->db->where(["order_row_id" => $order_id])->update("tb_order_details", $orderDetails);
        } else {
            $this->ci->db->insert('tb_order_details', $orderDetails);
        }
        /*$totalGoodValue = 0.0;
        log_message("error","cargoDetails:".json_encode($orderData));
        if (array_key_exists("0", $orderData['cargoDetails']['TransportHandlingUnit']) == 1) {
            foreach ($orderData['cargoDetails']['TransportHandlingUnit'] as $orderCargo) {
                $this->ci->Standardbookingmodel->insertCargoInfo($orderCargo, $order_id, $user_id);
                $valueOfGoods = is_array($orderCargo['ValueOfGoods']) ? "0.00" : $orderCargo['ValueOfGoods'];
                $totalGoodValue += $valueOfGoods;
            }
        } else {
            $this->ci->Standardbookingmodel->insertCargoInfo($orderData['cargoDetails']['TransportHandlingUnit'], $order_id, $user_id);
            $valueOfGoods = is_array($orderData['cargoDetails']['TransportHandlingUnit']['ValueOfGoods']) ? "0.00" : $orderData['cargoDetails']['TransportHandlingUnit']['ValueOfGoods'];
            $totalGoodValue += $valueOfGoods;
        }*/
        $totalGoodValue = 0.00;

        // Prefer TransportHandlingUnit if it exists, otherwise fall back to CargoThuDetails
        $thuData = null;
        
        if (!empty($orderData['cargoDetails']['TransportHandlingUnit'])) {
            $thuData = $orderData['cargoDetails']['TransportHandlingUnit'];
        } elseif (!empty($orderData['cargoDetails']['CargoThuDetails'])) {
            $thuData = $orderData['cargoDetails']['CargoThuDetails'];
        }
        
        if ($thuData !== null) {
            // Handle both single object and array of objects
            if (array_key_exists("0", $thuData)) {
                // It's an array of items
                foreach ($thuData as $orderCargo) {
                    $this->ci->Standardbookingmodel->insertCargoInfo($orderCargo, $order_id, $user_id);
                    $valueOfGoods = is_array($orderCargo['ValueOfGoods']) ? "0.00" : $orderCargo['ValueOfGoods'];
                    $totalGoodValue += (float) $valueOfGoods;
                }
            } else {
                // It's a single item
                $this->ci->Standardbookingmodel->insertCargoInfo($thuData, $order_id, $user_id);
                $valueOfGoods = is_array($thuData['ValueOfGoods']) ? "0.00" : $thuData['ValueOfGoods'];
                $totalGoodValue += (float) $valueOfGoods;
            }
        }

        $getCurrency = $this->ci->db->query(
            "SELECT c.currency, c.cntry_hrs,c.cntry_timezone
            FROM tbl_country_master AS c, tb_users AS u
            WHERE c.country_code = u.country_code AND u.id = ? AND c.status = 1
            LIMIT 1",
            [$user_id]
        );
        if ($getCurrency && $getCurrency->num_rows() > 0) {
            $currency = $getCurrency->row()->currency;
        }
        $this->ci->db->where(['id' => $order_id])->update("tb_orders", ['goods_value' => $totalGoodValue, 'currency' => $currency]);
        if (! empty($orderData['valueAddedServices'])) {
            if (array_key_exists("0", $orderData['valueAddedServices']['Addon']) == 1) {
                foreach ($orderData['valueAddedServices']['Addon'] as $valueAddedServices) {
                    $this->ci->Standardbookingmodel->insertValueAddedServices($valueAddedServices, $order_id, $user_id);
                }
            } else {
                $this->ci->Standardbookingmodel->insertValueAddedServices($orderData['valueAddedServices']['Addon'], $order_id, $user_id);
            }
        }
        if (count($orderData['involvedParties']) > 0) {
            foreach ($orderData['involvedParties']['PartyType'] as $party) {
                $party_type_id = $this->ci->Standardbookingmodel->getPartyTypeId($company_code, $branch_code, $party['Type']);
                $partyInfo     = $this->checkPartyDetails($party, $company_code, $branch_code, $user_id, $party['Type']);
                //log_message("error", "OrderId:" . $order_id);
                $orderParty = [
                    'order_id'     => $order_id,
                    'order_number' => $booking_id,
                    'party_id'     => $partyInfo['party_id'],
                    'party_type'   => $party_type_id,
                    'status'       => 1,
                ];
                //log_message("error", "orderParty:" . json_encode($orderParty));
                $this->ci->Standardbookingmodel->insertOrderParties($orderParty);
            }
        }
        
        /*log_message("error","Ref:".json_encode($orderData));
        if (! empty($orderData['manageReferences'])) {
            if (array_key_exists("0", $orderData['manageReferences']['References']) == 1) {
                foreach ($orderData['manageReferences']['References'] as $orderRef) {
                    $this->ci->Standardbookingmodel->insertOrderReferences($order_id, $orderRef);
                }
            } else {
                $this->ci->Standardbookingmodel->insertOrderReferences($order_id, $orderData['manageReferences']['References']);
            }
        } */
        
        $referencesKey = null;
        //log_message("error","ManageReferences:".json_encode($orderData));
        if (!empty($orderData['ManageReferences'])) {
            $referencesKey = $orderData['ManageReferences'];
        } elseif (!empty($orderData['manageReferences'])) {
            $referencesKey = $orderData['manageReferences'];
        }
        
        if ($referencesKey !== null) {
            //log_message("error","Reference:".json_encode($referencesKey['Reference']));
            $references = $referencesKey['References'] ?? null;
            //log_message("error","references:".json_encode($references));
            if (!empty($references)) {
                // Normalize to array (in case it's a single object)
                if (!array_key_exists(0, $references)) {
                    $references = [$references];
                }
        
                foreach ($references as $orderRef) {
                    $this->ci->Standardbookingmodel->insertOrderReferences($order_id, $orderRef);
                }
            }
            else {
                //log_message("error","referencesKey:".json_encode($referencesKey));
                $this->ci->Standardbookingmodel->insertOrderReferences($order_id, $referencesKey['References']);
            }
        }

        //log_message("error", "111:" . $booking_id);
        // log_message("error", "222:" . json_encode($orderData['header']));
        if ($orderData['header']['SourceApp'] == "XP_INDIA") {
            $carrierCode = "";
            $carrierId   = "";
            $vendor_list = $this->ci->db->select("id, code")->get_where("tb_vendors", ['code' => XP_INDIA_USERID]);
            //log_message("error","10:".$this->ci->db->last_query());
            if ($vendor_list->num_rows() > 0) {
                $carrierId   = $vendor_list->row()->id;
                $carrierCode = $vendor_list->row()->code;
            }

            $earlyquickbook_pickup   = $orderData['sourceInfo']['EstimatedDateTime']['From']['DateTime'];
            $earlyquickbook_delivery = null;

            $getpickup             = getdatetimebytimezone(DFLT_TZ, $earlyquickbook_pickup, $timeZone);
            $earlyquickbook_pickup = $getpickup['datetime'];

            $pickup_name    = $orderData['sourceInfo']['Company']['Name'];
            $pickup_street  = $orderData['sourceInfo']['Address']['Address1'] . "," . $orderData['sourceInfo']['Address']['Street'];
            $pickup_city    = $orderData['sourceInfo']['Address']['City'];
            $pickup_state   = $orderData['sourceInfo']['Address']['State'];
            $pickup_country = $orderData['sourceInfo']['Address']['Country'];
            $pickup_pincode = $orderData['sourceInfo']['Address']['Postal'];
            $drop_name      = $orderData['destinationInfo']['Company']['Name'];
            $drop_street    = ['destinationInfo']['Address']['Address1'] . "," . $orderData['destinationInfo']['Address']['Street'];
            $drop_city      = $orderData['destinationInfo']['Address']['City'];
            $drop_state     = $orderData['destinationInfo']['Address']['State'];
            $drop_country   = $orderData['destinationInfo']['Address']['Country'];
            $drop_pincode   = $orderData['destinationInfo']['Address']['Postal'];

            $pickup_latitude  = $orderData['sourceInfo']['Address']['Latitude'];
            $pickup_longitude = $orderData['sourceInfo']['Address']['Longitude'];
            if ($pickup_latitude != "" && $pickup_longitude != "") {
                $lat1 = $pickup_latitude;
                $lng1 = $pickup_longitude;
            } else {
                $add1 = implode(",", [$pickup_street, $pickup_city, $pickup_country, $pickup_pincode]);
                $data = getlatlngsbyplace($add1);
                $lat1 = @$data[0];
                $lng1 = @$data[1];
            }

            $add2     = implode(",", [$drop_street, $drop_city, $drop_country, $drop_pincode]);
            $dataDrop = getlatlngsbyplace($add2);
            $lat2     = @$dataDrop[0];
            $lng2     = @$dataDrop[1];

            $popupmodeof_trasnport = "LTL";
            // = $userId;

            //$order_id     = $this->ci->db->insert_id();
            //$order_id     = $booking_id;
            // log_message("error","order_id:".$order_id);
            $country_code = $companyCode;
            //$branch_code = $clientCode;
            //$company_code = $companyCode;
            $customer_id  = $customerId;
            $bookingIdNew = $booking_id;
            //$genord       = ["user_id" => $user_id, "order_id" => $order_id, "country_code" => $country_code, "company_code" => $company_code];
            //$bookingIdNew   = generatebookingid($genord);
            //log_message("error","booking_id:".$bookingIdNew);
            $invCarriertype = makeorderinvolvedpartiestype($carrierId, $order_id, "CARRIER", $user_id, $company_code);
            insertOrdersRefFileLineIdentifier(['pickupCity' => $pickup_city, 'pickupState' => $pickup_state, 'pickupCountry' => $pickup_country, 'dropCity' => $drop_city, 'dropState' => $drop_state, 'dropCountry' => $drop_country, 'companyCode' => $company_code, 'branchCode' => $branch_code, 'orderRowId' => $order_id, 'date' => $logdate]);
            // shift insertion
            $startTime          = date('H:i', strtotime($earlyquickbook_pickup));
            $endTime            = "";
            $year               = date('y');
            $week               = date('W');
            $countCode          = substr($company_code, 0, 2);
            $orderNumber        = $bookingIdNew;
            $sequenceNumber     = $countCode === 'UK' ? $orderNumber : substr($orderNumber, -6);
            $trip['shipmentId'] = "T" . $countCode . $week . $year . $sequenceNumber;

            $driver_id = "";
            $vehId     = "";

            $truckTypeVal = "COURIER";

            $checkVehicle = $this->ci->common->getjointbldata("tb_trucks_data td", "tb_trucktypes t", "td.truck_type = t.id", ['t.trucktype' => $truckTypeVal, 'td.vendor_id' => $carrierId, 'td.status' => 'Active', 't.status' => 'Active'], "td.id,td.register_number,t.trucktype", 0, 0);
            //log_message("error","11:".$this->ci->db->last_query());
            $shiftarr = [
                'user_id'        => $user_id,
                'stime'          => $startTime,
                'etime'          => $endTime,
                'splace'         => $pickup_city,
                'slat'           => $lat1,
                'slng'           => $lng1,
                'eplace'         => $drop_city,
                'elat'           => $lat2,
                'elng'           => $lng2,
                'scity'          => $pickup_city,
                'dcity'          => $drop_city,
                'zone_id'        => 1,
                'empshift_start' => $startTime,
                'empshift_end'   => $endTime,
                'trip_type'      => 0,
                'startdate'      => $earlyquickbook_pickup,
                'enddate'        => $latequickbook_delivery,
                'shipment_name'  => $packageType,
                'shipment_id'    => 0,
                'transport_mode' => $popupmodeof_trasnport,
                'customer_id'    => $customer_id,
                'vendor_id'      => $carrierId,
                'vehicle_type'   => $checkVehicle[0]['trucktype'],
                'carrier_type'   => 0,
                'shipmentid'     => $trip['shipmentId'],
                'txnid'          => $trip['shipmentId'],
                'company_code'   => $company_code,
                'branch_code'    => $branch_code,
                'created_on'     => $cdate,
                'status'         => 1,
            ];
            $shiftRowId = $this->ci->common->insertTableData("tb_shifts", $shiftarr);
            //log_message("error","shiftRowId:".$shiftRowId);
            //log_message("error","12:".$this->ci->db->last_query());
            // insering driver,vehicle,vehicletype
            $shiftVehArr = [
                'user_id'         => $user_id,
                'shft_id'         => $shiftRowId,
                'carrier_id'      => $carrierId,
                'vehicle_id'      => $checkVehicle[0]['id'],
                'register_number' => $checkVehicle[0]['register_number'],
                'created_on'      => $cdate,
                'status'          => 1,
            ];
            $shiftVehRowId = $this->ci->common->insertTableData("tb_shft_veh", $shiftVehArr);
            // log_message("error","shiftVehRowId:".$shiftVehRowId);
            //log_message("error","13:".$this->ci->db->last_query());

            $vehId = $checkVehicle[0]['id'];

            //log_message("error","vehId:".$vehId);
            $driverData = $this->ci->db->query("SELECT d.driver_id FROM tbl_assigned_drivers d WHERE d.vehicle_id=$vehId and d.user_id=$user_id AND d.status=1 LIMIT 1");

            //log_message("error","14:".$this->ci->db->last_query());
            if ($driverData->num_rows() > 0) {
                $driver_id = $driverData->row()->driver_id;
            }
            //log_message("error","driver_id:".$driver_id);
            $stopPickupAddress = $stopDropAddress = "";

            $stopPickupAddress .= $pickup_street;
            $stopDropAddress .= $drop_street;
            $stopPickupAddress .= ", " . $pickup_name;
            $stopDropAddress .= ", " . $drop_name;
            $stopPickupAddress .= ", " . $pickup_country;
            $stopDropAddress .= ", " . $drop_country;
            $stopPickupAddress .= ", " . $pickup_city;
            $stopDropAddress .= ", " . $drop_city;
            $stopPickupAddress .= ", " . $pickup_pincode;
            $stopDropAddress .= ", " . $drop_pincode;
            $pickshipArr = [
                'stopname'       => $pickup_city,
                'plat'           => $lat1,
                'plng'           => $lng1,
                'stopcity'       => $pickup_city,
                'address'        => $stopPickupAddress,
                'stoptype'       => 'P',
                'stopstatus'     => 0,
                'shipment_id'    => $shiftRowId,
                'ordernumber'    => 1,
                'startdate'      => $earlyquickbook_pickup,
                'enddate'        => $earlyquickbook_delivery,
                'shipmentstopid' => 0,
                'txncode'        => 'NP',
                'status'         => 1,
                'order_id'       => $order_id,
                'created_on'     => $cdate,
            ];
            $insPickupShip = $this->ci->common->insertTableData("tb_shiporder_stops", $pickshipArr);
            $DdropshipArr  = [
                'stopname'       => $drop_city,
                'plat'           => $lat2,
                'plng'           => $lng2,
                'stopcity'       => $drop_city,
                'address'        => $stopDropAddress,
                'stoptype'       => 'D',
                'stopstatus'     => 0,
                'shipment_id'    => $shiftRowId,
                'ordernumber'    => 2,
                'startdate'      => $earlyquickbook_pickup,
                'enddate'        => $earlyquickbook_delivery,
                'shipmentstopid' => 0,
                'txncode'        => 'NP',
                'status'         => 1,
                'order_id'       => $order_id,
                'created_on'     => $cdate,
            ];
            $insDropShip = $this->ci->common->insertTableData("tb_shiporder_stops", $DdropshipArr);

            $tripArr = [
                'shift_id'   => $shiftRowId,
                'status'     => 1,
                'created_on' => $cdate,
                'plat'       => $lat1,
                'plng'       => $lng1,
                'dlat'       => $lat2,
                'dlng'       => $lng2,
                'stime'      => $earlyquickbook_pickup,
                'etime'      => $latequickbook_delivery,
                'vehicle_id' => $vehId,
                'driver_id'  => $driver_id,
            ];
            $tripRowId = $this->ci->common->insertTableData("tb_trips", $tripArr);

            //log_message("error","tripRowId:".$tripRowId);
            //log_message("error","order_id:".$order_id);
            $upd = $this->ci->db->where(['id' => $order_id])->update("tb_orders", ['order_id' => $bookingIdNew, 'created_source' => '22', 'shift_id' => $shiftRowId, 'shipmentid' => $trip['shipmentId'], 'vendor_id' => $carrierId, 'trip_id' => $tripRowId]);

            // employee table update
            $employeearr = [
                'assoc_id '       => $trip['shipmentId'],
                'customer_id'     => $customer_id,
                'plat'            => $lat1,
                'plng'            => $lng1,
                'dlat'            => $lat2,
                'dlng'            => $lng2,
                'pickup_city'     => $pickup_city,
                'drop_city'       => $drop_city,
                'user_id'         => $user_id,
                'shift_id'        => $shiftRowId,
                'vendor_id'       => $carrierId,
                'order_id'        => $bookingIdNew,
                'status'          => 1,
                'startdate'       => $earlyquickbook_pickup,
                'enddate'         => $earlyquickbook_delivery,
                'pickup_datetime' => $earlyquickbook_pickup,
                'drop_datetime'   => $earlyquickbook_delivery,
                'pickup'          => $pickup_street,
                'drop'            => $drop_street,
                'ship_type'       => 'P',
                'stop_id'         => $insPickupShip,
                'stop_order'      => 1,
                'address'         => $stopPickupAddress,
                'createdon'       => $cdate,
            ];
            $employeeRowId = $this->ci->common->insertTableData("tb_employee", $employeearr);

            $getstatusid = $this->ci->db->select("id")->get_where("tb_status_master", ['status_code' => 'SV0100']);
            //log_message("error","15:".$this->ci->db->last_query());
            $status_id = 0;
            if ($getstatusid->num_rows() > 0) {
                $status_id = $getstatusid->row()->id;
            }

            $getStopStatusid = $this->ci->db->select("id")->get_where("tb_stop_status", ['order_id' => $order_id, 'status_id' => $status_id, 'status_code' => 'SV0100']);
            if ($getStopStatusid->num_rows() == 0) {
                $insertedStatus = $this->ci->common->insertTableData("tb_stop_status", ['order_id' => $order_id, 'shipment_id' => $shiftRowId, 'stop_detail_id' => $ship_row_id, 'trip_id' => $tripRowId, 'status_id' => $status_id, 'status_code' => 'SV0100', 'stop_type' => '', 'loc_name' => '', 'comment' => '', 'status' => '1', 'reason' => '', 'createdon' => $cdate]);
            }

            $masterCheck = [
                'UPPER(name)'  => 'CONSIGNEE',
                'user_id'      => $user_id,
                'company_code' => $company_code,
                'branch_code'  => $client_code,
                'status'       => '1',
            ];
            $checkconsignee = $this->ci->common->gettblrowdata($masterCheck, "id", "tbl_party_types", 1, 0);

            if (count($checkconsignee) > 0) {
                $delivery = $checkconsignee['id'];
            }

            $popupcustomer_id = $shipperCode;
            $popuporder_type  = 'LTL';

            $order_shipper_id   = isset($customer_id) ? $customer_id : "";
            $pickup_address     = $pickup_street . "," . $pickup_city . "," . $pickup_state;
            $shipper_address    = ['order_id' => $order_id, 'party_master_id' => $order_shipper_id, 'location_id' => $pickup_city, 'street' => $pickup_street, 'state' => $pickup_state, 'address' => $pickup_address, 'pincode' => $pickup_pincode, 'country' => $pickup_country, 'user_id' => $user_id];
            $chk_shipperaddress = $this->ci->db->select("id")->get_where("tbl_orderparty_address", ['order_id' => $order_id, 'party_master_id' => $order_shipper_id, 'status' => '1']);
            //("error","16:".$this->ci->db->last_query());
            if ($chk_shipperaddress->num_rows() > 0) {
                $shipperadd_id = $chk_shipperaddress->row()->id;
                $upd_add       = $this->ci->db->where(['id' => $shipperadd_id])->update("tbl_orderparty_address", $shipper_address);
            } else {
                $shipper_address['createdon'] = $cdate;
                $this->ci->db->insert("tbl_orderparty_address", $shipper_address);
                $shipperadd_id = $this->ci->db->insert_id();
            }
            $drop_address        = $drop_street . "," . $drop_city . "," . $drop_state;
            $delivery_address    = ['order_id' => $order_id, 'party_master_id' => $delivery, 'location_id' => $drop_city, 'street' => $drop_street, 'state' => $drop_state, 'address' => $drop_address, 'pincode' => $drop_pincode, 'country' => $drop_country, 'user_id' => $user_id];
            $chk_deliveryaddress = $this->ci->db->select("id")->get_where("tbl_orderparty_address", ['order_id' => $order_id, 'party_master_id' => $delivery, 'status' => '1']);
            //log_message("error","17:".$this->ci->db->last_query());
            if ($chk_deliveryaddress->num_rows() > 0) {
                $dropadd_id = $chk_deliveryaddress->row()->id;
                $upd_add    = $this->ci->db->where(['id' => $dropadd_id])->update("tbl_orderparty_address", $delivery_address);
            } else {
                $delivery_address['createdon'] = $cdate;
                $this->ci->db->insert("tbl_orderparty_address", $delivery_address);
                $dropadd_id = $this->ci->db->insert_id();
            }

            if (checkAccessConditions("CHECK_STS_REFERENCE_COUNTRIES", $company_code)) {
                $ins_ref     = ['order_id' => $order_id, 'reference_id' => 'STS'];
                $checkSTSRef = $this->ci->common->gettblrowdata($ins_ref, "id", "tb_order_references", 0, 0);
                if (count($checkSTSRef) == 0) {
                    $ins_ref['ref_value'] = "Pending";
                    $this->ci->common->insertTableData("tb_order_references", $ins_ref);
                }
            }

            /*$sub_cut_parties      = [];
                $sub_cut_parties['0'] = $order_shipper_id;
                $sub_cut_parties['1'] = $delivery;
                $sub_cut_parties['2'] = '0';
                $sub_cut_parties['3'] = '0';
                if (! empty($sub_cut_parties)) {
                    subcustpartiesinsert($order_id, $bookingIdNew, $sub_cut_parties);
                }*/
            if ($order_id != "" && $customer_id != "") {
                $checkTripForOrder = $this->ci->common->gettblrowdata("id='" . $order_id . "' AND shift_id >0", "id,shift_id", "tb_orders", 0, 0);
                if (! empty($checkTripForOrder)) {
                    $this->load->library('notifytrigger');
                    $this->notifytrigger->sendNotificationToCarrier($checkTripForOrder['shift_id'], $company_code, 'CR');
                }
            }

        }

        if ($order_id != "" && $order_id != '0' && $orderData['header']['SourceApp'] == "XP_INDIA") {
            try {
                $myKNCustomer = $this->ci->Order->checkMYKNCustomer($order_id);
                if ($myKNCustomer > 0) {
                    $this->ci->knlogin->shipmentxml($order_id);
                }
            } catch (Exception $ex) {
                log_message("error", "Some Problem occured!, While Sending Order to MYKN " . $ex->getMessage());
            }
        }
        if ($orderData['customerDetails']["ID"] == "1000307670") {
            $this->ci->load->library('PhpMailerLibrary');
            $subject = $booking_id . ' ' . 'GOODRICH AEROSPACE SERVICES PRIVATE LIMITED' . ' SHIPMENT CREATED';
            $message = "Hi Team,<br><br>";
            $message .= "Shipment Created in SVKonekt<br>";
            $message .= "SVK ID:  " . $booking_id . "<br>";
            $message .= "Customer Invoice No:  " . $externalOrderId . "<br><br>";
            $message .= "This is an automatically generated EMail, please do not reply <br><br>";
            $message .= "Thanks,<br>Support Team,<br>svkonekt.com";
                    
            try {
                if ($this->ci->phpmailerlibrary->sendmail('sachin.hinwar@kuehne-nagel.com', $subject, $message, ['rahul.kumar@kuehne-nagel.com', 'rajampeta.ealeshwari@kuehne-nagel.com'])) {
                //if ($this->ci->phpmailerlibrary->sendmail('external.vijetha.kakarlapudi@kuehne-nagel.com', $subject, $message, ['external.sowmya.thalari@kuehne-nagel.com', 'rajampeta.ealeshwari@kuehne-nagel.com'])) {
                    log_message("error", "Sent email sent for " . $subject);
                } else {
                    log_message("error", " Sent email failed for " . $subject);
                }
            } catch (Exception $e) {
                log_message("error", "Sent email failed - " . $e->getMessage());
            }        
        }
        
        return $booking_id;
    }

    private function insertShipmentData(
        array $orderData,
        string $company_code,
        string $branch_code
    ): int {
        $cdate = date('Y-m-d H:i:s');
        if (! empty($orderData['OrderID'])) {
            $shipment_id = $orderData['OrderID'];
        } else {
            $shipment_id = "SVK" . time();
        }
        $transportmodeid  = $transportmodename  = "";
        $gettrasnportmode = $this->ci->Standardbookingmodel->getTransportModeName($orderData['ModeOfTransport']);
        if (! empty($gettrasnportmode)) {
            $transportmodeid   = $gettrasnportmode['id'];
            $transportmodename = $gettrasnportmode['name'];
        }
        $incoterm        = empty($orderData['Incoterm']) ?? "";
        $freightTerm     = empty($orderData['FreightTerm']) ?? "60";
        $freightTermName = empty($orderData['FreightTermName']) ?? "Free of Charge";
        $enddate         = date('Y-m-d H:i:s', strtotime("+1 day"));
        $ship_arr        = [
            'shipid'           => $shipment_id,
            'txnid'            => $shipment_id,
            'trucktype'        => $transportmodename,
            'pickupcnt'        => '1',
            'dropcnt'          => '1',
            'unitspec'         => 1,
            'insertusr'        => "",
            'carrier'          => '0',
            'insertuserdate'   => $cdate,
            'enddate'          => $enddate,
            'insdate'          => $cdate,
            'upddate'          => $cdate,
            'reason'           => 'SHIPMENT',
            'purpose'          => 'SEND INTEGRATION',
            'ship_object'      => 'SHIPMENT',
            'logdate'          => $cdate,
            'transport_mode'   => $orderData['ModeOfTransport'],
            'domainname'       => $branch_code,
            'company_code'     => $company_code,
            'branch_code'      => $branch_code,
            'product'          => $orderData['Product'],
            'freight_term'     => $freightTerm,
            'freight_termname' => $freightTermName,
            'incoterm'         => $incoterm,
            'modeoftransport'  => $transportmodeid,
        ];
        $checkShipid = $this->ci->common->gettblrowdata(['shipid' => $shipment_id], "id", "tb_shipments", 0, 0);
        if (! empty($checkShipid)) {
            $this->ci->db->where(['id' => $checkShipid['id']])->update("tb_shipments", $ship_arr);
            $ship_row_id = $checkShipid['id'];
        } else {
            $ship_arr['createdon'] = $cdate;
            $ship_ins              = $this->ci->db->insert("tb_shipments", $ship_arr);
            $ship_row_id           = $this->ci->db->insert_id();
        }
        return $ship_row_id;
    }

    public function checkPartyDetails(
        array $partyData,
        string $company_code,
        string $branch_code,
        int $user_id,
        string $partyDataType
    ): array {
        log_message("error", "partyData111:" . json_encode($partyData));
        log_message("error", "partyDataType:" . $partyDataType);
        $curdt         = date("Y-m-d H:i:s");
        $party_type_id = $this->ci->Standardbookingmodel->getPartyTypeId($company_code, $branch_code, $partyDataType);
        $party_code    = is_array($partyData['ID']) ? "" : $partyData['ID'];
        $partyWhere    = ["code" => $party_code];
        $customer_id   = 0;
        $address       = is_array($partyData['Address']['Street']) ? "" : $partyData['Address']['Street'];
        if ('' !== (is_array($partyData['Address']['City']) ? "" : $partyData['Address']['City'])) {
            $address .= ", " . (is_array($partyData['Address']['City']) ? "" : $partyData['Address']['City']);
        }
        if ('' !== (is_array($partyData['Address']['State']) ? "" : $partyData['Address']['State'])) {
            $address .= ", " . (is_array($partyData['Address']['State']) ? "" : $partyData['Address']['State']);
        }
        if ('' !== (is_array($partyData['Address']['Postal']) ? "" : $partyData['Address']['Postal'])) {
            $address .= ", " . (is_array($partyData['Address']['Postal']) ? "" : $partyData['Address']['Postal']);
        }
        if ('' !== (is_array($partyData['Address']['Country']) ? "" : $partyData['Address']['Country'])) {
            $address .= ", " . (is_array($partyData['Address']['Country']) ? "" : $partyData['Address']['Country']);
        }
        $latitude  = empty($partyData['Address']['Latitude']) ?? "";
        $longitude = empty($partyData['Address']['Longitude']) ?? "";

        if ($latitude == "" && $longitude == "") {
            $data      = getlatlngsbyplace($address);
            $latitude  = @$data[0];
            $longitude = @$data[1];
        }
        log_message("error", "partyData:" . $party_code);
        $customerIdentifier      = "";
        if($party_code<> ''){
            $customerIdentifierExist = $this->ci->Standardbookingmodel->checkPartyType($party_code);
            //log_message("error","Qry:".$this->ci->db->last_query());
            if (! empty($customerIdentifierExist)) {
                //log_message("error","Name::".$pickupData['name']);
                $customerIdentifier = $customerIdentifierExist['customer_identifier'];
            }
        }

        $businessPartydata = [
            'name'               => (is_array($partyData['Company']['Name']) ? "" : $partyData['Company']['Name']),
            'email'              => empty($partyData['Address']['ContactNo']['EmailAddress']) ? "" : $partyData['Address']['ContactNo']['EmailAddress'],
            'location_id'        => (is_array($partyData['Address']['City']) ? "" : $partyData['Address']['City']),
            'street'             => (is_array($partyData['Address']['Street']) ? "" : $partyData['Address']['Street']),
            'state'              => (is_array($partyData['Address']['State']) ? "" : $partyData['Address']['State']),
            'address'            => $address,
            'pincode'            => (is_array($partyData['Address']['Postal']) ? "" : $partyData['Address']['Postal']),
            'country'            => (is_array($partyData['Address']['Country']) ? "" : $partyData['Address']['Country']),
            'user_id'            => $user_id,
            'customeridentifier' => empty($customerIdentifier) ? $party_type_id : $customerIdentifier,
            'partyindetifier'    => $party_type_id,
            'company_code'       => $company_code,
            'branch_code'        => $branch_code,
            'status'             => 1,
            'updated_on'         => $curdt,
        ];
        $timeZone = $this->ci->carriercommonmodel->getOrderUserTimeZone($user_id);

        $partyWhere['company_code'] = $company_code;
        $partyWhere['status']       = 1;
        
        $partyTypeIds = $this->ci->common->gettblrowdata(
            [
                'company_code' => $company_code,
                'branch_code' => $branch_code
            ],
            "GROUP_CONCAT(id) AS ids",
            "tbl_party_types",
            0,
            0,
            ['name' => ['SHIPPER', 'CONSIGNEE', 'CUSTOMER']]
        );
                
        if ($party_code != "") {
            $checkBusParty = $this->ci->common->gettblrowdata($partyWhere, "id,party_type_id,party_types", "tbl_party_master", 0, 0);
            if (count($checkBusParty) > 0) {
                $businessPartyId  = $checkBusParty['id'];
                $busparty_type_id = $checkBusParty['party_type_id'];
                $busparty_types   = $checkBusParty['party_types'] ?? "";
                $party_types      = explode(',', $busparty_types);
                if (! in_array($party_type_id, $party_types)) {
                    array_push($party_types, $party_type_id);
                }
                $businessPartydata["party_types"] = implode(",", $party_types);
                //log_message("error", "111:" . json_encode($businessPartydata));
                $this->ci->common->updatetbledata("tbl_party_master", $businessPartydata, ["id" => $businessPartyId]);
            } else {
                $pwd                                = password_hash($party_type_id, PASSWORD_DEFAULT);
                $businessPartydata["party_type_id"] = $party_type_id;
                $businessPartydata["party_types"]   = $party_type_id;
                $businessPartydata["password"]      = $pwd;
                $businessPartydata["created_on"]    = $curdt;
                $checkBusParty                      = $this->ci->common->gettblrowdata(['name' => (is_array($partyData['Company']['Name']) ? "" : $partyData['Company']['Name']), "status" => 1, 'company_code' => $company_code, 'branch_code' => $branch_code], "id,party_type_id,party_types,code", "tbl_party_master", 0, 0);
                if (count($checkBusParty) > 0) {
                    $businessPartyId = $checkBusParty['id'];
                    //log_message("error", "222:" . json_encode($businessPartydata));
                    $busparty_types   = $checkBusParty['party_types'] ?? "";
                    $party_types      = explode(',', $busparty_types);
                    if (! in_array($party_type_id, $party_types)) {
                        array_push($party_types, $party_type_id);
                    }
                    $businessPartydata["party_types"] = implode(",", $party_types);
                    $this->ci->common->updatetbledata("tbl_party_master", $businessPartydata, ['id' => $businessPartyId]);
                    if ($checkBusParty['code'] == "") {
                        $partyCode       = $timeZone['phone_code'] . date('y') . date('W') . str_pad($businessPartyId, 4, '0', STR_PAD_LEFT);
                        $partyData['ID'] = $partyCode;
                        $this->ci->common->updatetbledata("tbl_party_master", ['code' => $partyCode, 'mobile' => $partyCode, 'customeridentifier' => empty($customerIdentifier) ? $partyCode : $customerIdentifier], ['id' => $businessPartyId]);
                    }
                } else {
                    if($branch_code == "EATON" || $branch_code == "SIEMENS")
                    {
                        $businessPartydata["party_types"]   = $partyTypeIds;
                    }
                    else
                    {
                        $businessPartydata["party_types"]   = $party_type_id;
                    }
                    $businessPartyId = $this->ci->common->insertTableData('tbl_party_master', $businessPartydata);
                    $partyCode       = $timeZone['phone_code'] . date('y') . date('W') . str_pad($businessPartyId, 4, '0', STR_PAD_LEFT);
                    $partyData['ID'] = $partyCode;
                    $this->ci->common->updatetbledata("tbl_party_master", ['code' => $partyCode, 'mobile' => $partyCode, 'customeridentifier' => empty($customerIdentifier) ? $partyCode : $customerIdentifier], ['id' => $businessPartyId]);
                }
            }
        } else {
            $pwd                                = password_hash($party_type_id, PASSWORD_DEFAULT);
            $businessPartydata["party_type_id"] = $party_type_id;
            $businessPartydata["party_types"]   = $party_type_id;
            $businessPartydata["password"]      = $pwd;
            $businessPartydata["created_on"]    = $curdt;
            $checkBusParty                      = $this->ci->common->gettblrowdata(['name' => (is_array($partyData['Company']['Name']) ? "" : $partyData['Company']['Name']), "status" => 1, 'company_code' => $company_code, 'branch_code' => $branch_code], "id,party_type_id,party_types,code", "tbl_party_master", 0, 0);
            if (count($checkBusParty) > 0) {
                $businessPartyId = $checkBusParty['id'];
                $partyData['ID'] = $checkBusParty['code'];
                $busparty_types   = $checkBusParty['party_types'] ?? "";
                $party_types      = explode(',', $busparty_types);
                if (! in_array($party_type_id, $party_types)) {
                    array_push($party_types, $party_type_id);
                }
                $businessPartydata["party_types"] = implode(",", $party_types);
                //log_message("error", "333:" . json_encode($businessPartydata));
                $this->ci->common->updatetbledata("tbl_party_master", $businessPartydata, ['id' => $businessPartyId]);
                if ($checkBusParty['code'] == "" || $checkBusParty['code'] == 0) {
                    $partyCode       = $timeZone['phone_code'] . date('y') . date('W') . str_pad($businessPartyId, 4, '0', STR_PAD_LEFT);
                    $partyData['ID'] = $partyCode;
                    $this->ci->common->updatetbledata("tbl_party_master", ['code' => $partyCode, 'mobile' => $partyCode, 'customeridentifier' => empty($customerIdentifier) ? $partyCode : $customerIdentifier], ['id' => $businessPartyId]);
                }
            } else {
                //log_message("error", "BBB:" . json_encode($businessPartydata));
                if($branch_code == "EATON" || $branch_code == "SIEMENS")
                {
                    $businessPartydata["party_types"]   = $partyTypeIds;
                }
                else
                {
                    $businessPartydata["party_types"]   = $party_type_id;
                }
                $businessPartyId = $this->ci->common->insertTableData('tbl_party_master', $businessPartydata);
                $partyCode       = $timeZone['phone_code'] . date('y') . date('W') . str_pad($businessPartyId, 4, '0', STR_PAD_LEFT);
                $partyData['ID'] = $partyCode;
                $this->ci->common->updatetbledata("tbl_party_master", ['code' => $partyCode, 'mobile' => $partyCode, 'customeridentifier' => empty($customerIdentifier) ? $partyCode : $customerIdentifier], ['id' => $businessPartyId]);
            }
        }

        if ($partyDataType == "Customer") {
            $partyWhere['branch_code'] = $branch_code;
            $chkcust                   = $this->ci->common->gettblrowdata($partyWhere, "id", "tb_customers", 0, 0);
            if (count($chkcust) > 0) {
                $customer_id = $chkcust['id'];
            } else {
                $pwd  = password_hash($partyData['ID'], PASSWORD_DEFAULT);
                $data = [
                    'name'         => $partyData['Company']['Name'],
                    'phone'        => $partyData['ID'],
                    'location'     => (is_array($partyData['Address']['City']) ? "" : $partyData['Address']['City']),
                    'address'      => $address,
                    'pincode'      => (is_array($partyData['Address']['Postal']) ? "" : $partyData['Address']['Postal']),
                    'code'         => $partyData['ID'],
                    'country'      => (is_array($partyData['Address']['Country']) ? "" : $partyData['Address']['Country']),
                    'street'       => is_array($partyData['Address']['Street']) ? "" : $partyData['Address']['Street'],
                    'email_id'     => empty($partyData['Address']['ContactNo']['EmailAddress']) ? "" : $partyData['Address']['ContactNo']['EmailAddress'],
                    'password'     => $pwd,
                    'user_id'      => $user_id,
                    'partner_id'   => $businessPartyId,
                    'partyid'      => $businessPartyId,
                    'company_code' => $company_code,
                    'branch_code'  => $branch_code,
                    'status'       => 1,
                    'createdon'    => $curdt,
                    'updatedon'    => $curdt,
                ];
                $customer_id = $this->ci->common->insertTableData('tb_customers', $data);
            }
        }
        $responseData = [
            'party_code'  => $partyData['ID'],
            'party_id'    => $businessPartyId,
            'party_type'  => $party_type_id,
            'customer_id' => $customer_id,
        ];
        //log_message("Error", "Party Information" . json_encode($responseData));
        return $responseData;
    }

    public function sendAWSOrderEmailNotification(int $order_id, string $booking_id): void
    {
        if ($order_id == "") {
            log_message("error", "sendAWSOrderEmailNotification Empty Booking Id : ");
            return;
        }
        //log_message("error", "sendAWSOrderEmailNotification Booking Id : " . $order_id);
        $this->ci->load->library('PhpMailerLibrary');
        $orderReferences = $this->ci->common->gettbldata(["order_id" => $order_id, "status" => 1], "reference_id, ref_value", "tb_order_references", 0, 0);
        $awsDQ           = $aecINN           = $awsABO           = "";
        foreach ($orderReferences as $references) {
            if ($references['reference_id'] == "DQ") {
                $awsDQ = $references['ref_value'];
            }
            if ($references['reference_id'] == "INN") {
                $aecINN = $references['ref_value'];
            }
            if ($references['reference_id'] == "ABO") {
                $awsABO = $references['ref_value'];
            }
        }
        $subject = "AWS Order Created: " . $booking_id . " - " . $awsDQ;
        $message = "Hi Team,<br>";
        $message .= "Booking ID with below references <br>";
        $message .= "INN:  " . $aecINN . "<br>";
        $message .= "DQ:  " . $awsDQ . "<br><br>";
        $message .= "ABO:  " . $awsABO . "<br><br>";
        $message .= "SVK ID:  " . $booking_id . "<br><br>";
        $message .= "This is an automatically generated EMail, please do not reply <br><br><br><br>";
        $message .= "Thanks,<br>Support Team,<br>svkonekt.com";

        try {
            if ($this->ci->phpmailerlibrary->sendmail(AWSREPORT_MAILS, $subject, $message, json_decode(AWSREPORT_CC_MAILS))) {
                log_message("error", "sendAWSOrderEmailNotification email sent for " . $subject);
            } else {
                log_message("error", " sendAWSOrderEmailNotification email failed for " . $subject);
            }
        } catch (Exception $e) {
            log_message("error", "sendAWSOrderEmailNotification email failed - " . $e->getMessage());
        }
    }

    public function insertOrderAcknowledgementStatus(int $order_id): void
    {
        $orderInfo   = $this->ci->common->gettblrowdata(["id" => $order_id], "id,plat,plng,shift_id,createdon", "tb_orders", 0, 0);
        $orderStatus = [
            'order_id'      => $order_id,
            'status_id'     => '81',
            'latitude'      => $orderInfo['plat'],
            'longitude'     => $orderInfo['plng'],
            'status_code'   => '0142',
            'status_date'   => $orderInfo['createdon'],
            'status_type'   => "P",
            'shift_id'      => $orderInfo['shift_id'],
            'action_user'   => "AWS EDI",
            'createdon'     => date('Y-m-d H:i:s'),
            'status_reason' => 'From EDI',
        ];
        $this->ci->common->insertTableData('tb_order_status', $orderStatus);
    }

}
