<?php

/*require_once './vendor/autoload.php';
use PhpAmqpLib\Connection\AMQPStreamConnection;
use PhpAmqpLib\Message\AMQPMessage;
use PhpAmqpLib\Connection\AMQPSSLConnection;
use PhpAmqpLib\Wire;*/

use App\MobileEvents\Handler\MilestoneUpdateXmlChecker;

class Statusintigration
{
    const ROADLOG_CREATED_SOURCE_ID = '18';
    private const KNLOGIN_PUP_DOCTYPE = '507';
    private const KNLOGIN_POD_DOCTYPE = '545';
    private const KNLOGIN_PICTURE_DOCTYPE = '999';

    public function roadlogshipmentconfirm(array $postdata): bool
    {
        return $this->getOrderInfo($postdata, '0212');
    }

    public function roadlogshipmentpicked(array $postdata): bool
    {
        return $this->getOrderInfo($postdata, '0500');/*Source Location Pickup*/
    }

    public function roadlogshipmentpgatein($postdata): bool
    {
        return $this->getOrderInfo($postdata, '0420');/*Source Location Pickup*/
    }

    public function roadlogshipmentpgateout($postdata)
    {
        return $this->getOrderInfo($postdata, '0191');/*Pickup Location GateOut*/
    }

    public function roadlogshipmentdgatein(array $postdata)
    {
        return $this->getOrderInfo($postdata, '0192'); /*Delivery Location GateIn*/
    }

    public function roadlogshipmentdgateout(array $postdata): bool
    {
        return $this->getOrderInfo($postdata, '9250');/*Shipment Delivery Gateout*/
    }

    public function roadlogshipmentdeliverpartial(array $postdata): bool
    {
        return $this->getOrderInfo($postdata, '3002');/*'2420';*/ /*Partial Delivery Requested*/
    }

    public function roadlogshipmenttripdeliverpartial(array $postdata): bool
    {
        return $this->getOrderInfo($postdata, '0218');;/*'2420';*/ /*Trip Ended*/
    }

    public function roadlogshipcollectcancel(array $postdata): bool
    {
        return $this->getOrderInfo($postdata, '0460');/*Collection Order Declined by Driver*/
    }

    public function roadlogshipmentintransit(array $postdata): bool
    {
        return $this->getOrderInfo($postdata, '1550'); /*Actual Transit Location*/
    }

    public function roadlogshipmentdelivered(array $postdata): bool
    {
        $this->getOrderInfo($postdata, '2300');/*Delivery Shipment Dispatched*/
        $this->getOrderInfo($postdata, '3000');/*Delivered to Consignee*/
        return true;
    }

    public function roadlogshipmenttripdelivered(array $postdata): bool
    {
        return $this->getOrderInfo($postdata, '0218');/*Trip Ended*/
    }

    public function roadlogorderpodstatus(array $postdata): bool
    {
        if (isset($postdata['stop_type'])) {
            if ($postdata['stop_type'] == "P") {
                $this->getOrderInfo($postdata, '2490');/*Goods Loaded for Delivery*/
            }
        }
        return $this->getOrderInfo($postdata, '3060');/*ePOD available*/
    }

    public function roadlogshipmentreject(array $postdata): bool
    {
        return $this->getOrderInfo($postdata, '0213');/*Load Rejected by Driver*/
    }

    public function roadlogshipmentabort(array $postdata): bool
    {
        return $this->getOrderInfo($postdata, '0217');/*Load Rejected by Driver*/
    }

    public function roadlogorderrealesestatus(array $postdata):bool
    {
        return $this->getOrderInfo($postdata, '3002');/*'2420';*/ /*Partial Delivery Requested*/
    }

    public function roadlogshipmentcollected($postdata):bool
    {
        return $this->getOrderInfo($postdata,'0470'); /*Collection Order Confirmed*/
    }

    public function roadlogshipnotcollected(array $postdata): bool
    {
        return $this->getOrderInfo($postdata, '0520'); /*Shipment Not Collected*/
    }

    public function roadlogshipbookedbysupplier(array $postdata): bool
    {
        $post['shipment_id'] = $postdata['shipment_id'];
        $post['latitude'] = $postdata['latitude'] ?? "";
        $post['longitude'] = $postdata['longitude'] ?? "";
        if ($post['shipment_id'] != "" && $postdata['order_id'] != "") {
            $post['status_code'] = '0100'; /*Shipment Booked By Supplier*/
            $post['trackingnumber'] = $postdata['order_id'];
            $post['company_code'] = $postdata['company_code'];
            $post['branch_code'] = $postdata['branch_code'];
            $post['shipment_id'] = $postdata['shipmentid'];
            $post['modeoftransport'] = $postdata['modeoftransport'];
            $post['pickup_city'] = $postdata['pickup_city'];
            $post['logicalreceiver'] = $postdata['lreceiver'];
            $post['physicalreceiver'] = $postdata['preceiver'];
            $post['logicalsender'] = $postdata['lsender'];
            $post['physicalsender'] = $postdata['psender'];
            $post['createdon'] = date('Y-m-d H:i:s');
            $hrs = "Z";
            if (isset($postdata['hrs'])) {
                $hrs = str_replace(".", ":", $postdata['hrs']);
            }
            if (isset($postdata['curtz'])) {
                $getactual = getdatetimebytimezone($postdata['curtz'], $post['createdon'], DFLT_TZ);
                $post['createdon'] = $getactual['datetime'];
                $post['date'] = $getactual['date'];
                $post['time'] = $getactual['time'] . "" . $hrs;
            } else {
                $post['date'] = date('Y-m-d');
                $post['time'] = date('H:i:s') . "" . $hrs;
            }
            $post['curdt'] = date('Y-m-d\TH:i:s.u', strtotime($post['createdon'])) . "" . $hrs;
            $this->roadlogsendorderstatus($post);
            return true;
        } else {
            return false;
        }
    }

    /* xLog to Roadlog Status */
    public function roadlogshipplandeliverdate(array $postdata):bool
    {
        /* Shipment Planned Delivery Date */
        $post['shipment_id'] = $postdata['shipment_id'];
        $post['latitude'] = $postdata['latitude'] ?? "";
        $post['longitude'] = $postdata['longitude'] ?? "";
        if ($post['shipment_id'] != "" && $postdata['order_id'] != "") {
            $post['status_code'] = '2400'; /*Shipment Planned Delivery Date*/
            $post['trackingnumber'] = $postdata['order_id'];
            $post['company_code'] = $postdata['company_code'];
            $post['branch_code'] = $postdata['branch_code'];
            $post['shipment_id'] = $postdata['shipmentid'];
            $post['modeoftransport'] = $postdata['modeoftransport'];
            $post['pickup_city'] = $postdata['pickup_city'];
            $post['logicalreceiver'] = $postdata['lreceiver'];
            $post['physicalreceiver'] = $postdata['preceiver'];
            $post['logicalsender'] = $postdata['lsender'];
            $post['physicalsender'] = $postdata['psender'];
            $post['createdon'] = date('Y-m-d H:i:s');
            $hrs = "Z";
            if (isset($postdata['hrs'])) {
                $hrs = str_replace(".", ":", $postdata['hrs']);
            }
            if (isset($postdata['curtz'])) {
                $getactual = getdatetimebytimezone($postdata['curtz'], $post['createdon'], DFLT_TZ);
                $post['createdon'] = $getactual['datetime'];
                $post['date'] = $getactual['date'];
                $post['time'] = $getactual['time'] . "" . $hrs;
            } else {
                $post['date'] = date('Y-m-d');
                $post['time'] = date('H:i:s') . "" . $hrs;
            }
            $post['curdt'] = date('Y-m-d\TH:i:s.u', strtotime($post['createdon'])) . "" . $hrs;
            $this->roadlogsendorderstatus($post);
            return true;
        } else {
            return false;
        }
    }

    /* xLog to Roadlog Status */
    public function roadlogcustomsdocstatus(array $postdata): bool
    {
        return $this->getOrderInfo($postdata, '1600'); /*Customs Cleareance Completed at Bor*/
    }

    private function roadlogsendorderstatus(array $post): bool
    {
        $created_source = $post['created_source'] ?? '';
        if (empty($created_source) || $created_source != self::ROADLOG_CREATED_SOURCE_ID) {
            return false;
        }
        if (!MilestoneUpdateXmlChecker::isTest()) {
            log_message("error","Data Received at roadlog send order status /".json_encode($post));
        }
        $data = [
            "physicalreceiver" => $post['physicalreceiver'],
            "logicalreceiver" => $post['logicalreceiver'],
            "physicalsender" => $post['physicalsender'],
            "logicalsender" => $post['logicalsender'],
            "order_id" => $post['trackingnumber'],
            "assoc_id" => $post['shipment_id'],
            //"ref_value_kn_office" => 'RL' . $post['trackingnumber'],
            "ref_value_kn_office" => $post['innnumber'],
            "city" => $post['pickup_city'],
            "current_date_time" => $post['curdt'],
            "current_time" => $post['time'],
            "current_date" => $post['date'],
            "document_id" => '',
            "picture_id" => '',
            "remark" => $post['comment'] ?? '',
            "missing_qty" => '',
            "status_code" => $post['status_code'],
            "upload_type" => '',
            "exception_code" => '',
            "pod_signee" =>  $post['file_name'] ?? '',
            "branch_code" => $post['branch_code'],
            "company_code" => $post['company_code'],
            "user_id" => '',
            "device_id" => '',
            "latitude" => $post['latitude'],
            'longitude' => $post['longitude']
        ];
        try {
            $ci = &get_instance();
            $ci->load->library('Roadlog_status');
            $ci->roadlog_status->status_handler($data);
        } catch (Exception $ex) {
            log_message("error", "Some Problem occured!, Status Updated but Issue in the Roadlog status Handlar /" . $ex->getMessage());
            return false;
        }
        return true;
    }

public function roadlogsendordreleasestatus($post)
{
    $responsedata = true;
    return $responsedata;
}

public function roadlogsaveIntigrateRequest($request = '', $response = '')
{
    $ci = &get_instance();
    if ($request != '' && $response != '') {
        $tb_intigration_requests = array(
            "domain_name"        => isset($request["domain_name"]) ? $request["domain_name"] : null,
            "shipment_id"        => isset($request["shipment_id"]) ? $request["shipment_id"] : null,
            "trip_id"            => isset($request["trip_id"]) ? $request["trip_id"] : null,
            "stop_id"            => isset($request["stop_id"]) ? $request["stop_id"] : null,
            "driver_id"          => isset($request["driver_id"]) ? $request["driver_id"] : null,
            "order_id"           => isset($request["order_id"]) ? $request["order_id"] : null,
            "source_id"          => isset($request["source_id"]) ? $request["source_id"] : null,
            "source_reason_code" => isset($request["source_reason_code"]) ? $request["source_reason_code"] : null,
            "carrier"            => isset($request["carrier"]) ? $request["carrier"] : null,
            "kn_adminid"         => isset($request["kn_adminid"]) ? $request["kn_adminid"] : null,
            "txn_id"             => isset($request["txn_id"]) ? $request["txn_id"] : null,
            "txn_code"           => isset($request["txn_code"]) ? $request["txn_code"] : null,
            "remark"             => isset($request["remark"]) ? $request["remark"] : null,
            "reporttype"         => isset($request["reporttype"]) ? $request["reporttype"] : null,
            "reportpod"          => isset($request["reportpod"]) ? $request["reportpod"] : null,
            "ord_release"        => isset($request["ord_release"]) ? $request["ord_release"] : null,
            "response"           => isset($request["response"]) ? $request["response"] : null,
            "company_code"       => isset($request["company_code"]) ? $request["company_code"] : null,
            "branch_code"        => isset($request["branch_code"]) ? $request["branch_code"] : null,
            "status"             => 1,
            "createdon"          => isset($request["createdon"]) ? $request["createdon"] : null,
            "updatedon"          => isset($request["createdon"]) ? $request["createdon"] : null,
        );
        $ins = $ci->db->insert("tb_intigration_requests", $tb_intigration_requests);
    }
}

/* xLog to SALog shipment Status */
public function salogshipmentstatus($postData)
{
    $ci = &get_instance();
    /*2300 -> Delivery Shipment Dispatched, 2400 -> Planned Delivery Date, 3000 -> Delivered to Consignee, 3060 -> POD Available */
    $post['shipment_id'] = $postData['shipment_id'];
    $post['trip_id'] = $postData['trip_id'];
    $post['latitude'] = isset($postData['latitude']) ? $postData['latitude'] : "";
    $post['longitude'] = isset($postdata['longitude']) ? $postData['longitude'] : "";
    $post['order_id'] = isset($postData['order_id']) ? $postData['order_id'] : "";
    $post['comment'] = $postData['comment'] ?? '';
    if ($post['shipment_id'] != "" && $post['trip_id'] != "") {
        $post['status_code'] = isset($postData['status_code']) ? $postData['status_code'] : "";

        if (in_array($post['status_code'], ['2300', '3000', '0500', '0200', '0220', '1065', '3400'])) {
        $post['company_code'] = $post['branch_code'] = $post['shipment_id'] = $post['modeoftransport'] = $post['pickup_city'] = $post['order_pickup_city'] = $post['delivery_city'] = "";
        $post['logicalreceiver'] = $post['physicalreceiver'] = $post['logicalsender'] = $post['physicalsender'] = $post['department_code'] = $post['trackingnumber'] = $post['xsr'] = $post['brn'] = "";
        $whereCondition = [
            "order_id"=>$postData['order_id']
        ];
        $getOrderDetails = $ci->db->select("pickup_city,delivery_city, company_code, branch_code, shipmentid, logicalreceiver, physicalreceiver, physicalsender, logicalsender, modeoftransport, user_id")->get_where("tb_orders",$whereCondition,1,0);
        if($getOrderDetails->num_rows()>0){
            $post['company_code'] = $getOrderDetails->row()->company_code;
            $post['branch_code'] = $getOrderDetails->row()->branch_code;
            $post['shipment_id'] = $getOrderDetails->row()->shipmentid;
            $post['user_id'] = $getOrderDetails->row()->user_id;
            $post['pickup_city'] = ($post['pickup_city'] == "") ? $getOrderDetails->row()->pickup_city : $post['pickup_city'];
            $post['order_pickup_city'] = $getOrderDetails->row()->pickup_city;
            $post['delivery_city'] = $getOrderDetails->row()->delivery_city;
            $post['logicalreceiver'] = $getOrderDetails->row()->logicalreceiver;
            $post['physicalreceiver'] = $getOrderDetails->row()->physicalreceiver;
            $post['logicalsender'] = $getOrderDetails->row()->logicalsender;
            $post['physicalsender'] = $getOrderDetails->row()->physicalsender;
            $post['modeoftransport'] = $getOrderDetails->row()->modeoftransport;
        }
        $getDepartment = $ci->db->select("department_code")->get_where("tb_order_details",$whereCondition,1,0);
        if($getDepartment->num_rows()>0){
            $post['department_code'] = $getDepartment->row()->department_code;
        }
        $ci->db->select("reference_id,ref_value");
        $ci->db->from("tb_order_references");
        $ci->db->where(["order_id"=>$postData['ord_id'],"status"=>1]);
        $ci->db->where_in("reference_id",['DQ','XSR','SDT','BRN']);
        $getTrackingNumber = $ci->db->get();
        if($getTrackingNumber->num_rows()>0){
            foreach($getTrackingNumber->result() as $trackValue){
                if($trackValue->reference_id == "DQ"){
                    if (strlen($trackValue->ref_value) < 11 && (strpos($trackValue->ref_value, 'O') === false)) {
                        $post['trackingnumber'] = $trackValue->ref_value;
                    }
                }
                if($trackValue->reference_id == "XSR"){
                    $post['xsr'] = $trackValue->ref_value;
                }
                if ($trackValue->reference_id == "SDT") {
                    $post['sdt'] = $trackValue->ref_value;
                }
                if($trackValue->reference_id == "BRN"){
                    $post['brn'] = $trackValue->ref_value;
                }
            }
        }
        $post['xsr'] = ($post['xsr'] == "") ? $post['trackingnumber'] : $post['xsr'];
        $post['createdon'] = date('Y-m-d H:i:s');
        $hours = "Z";
        if(isset($postData['hrs'])){
            $hours = str_replace(".", ":", $postData['hrs']);
        }
        if(isset($postData['curtz'])){
            if(!isset($postData['web'])){
                $getLocalTime = getdatetimebytimezone($postData['curtz'],$post['createdon'],DFLT_TZ);
                $post['createdon'] = $getLocalTime['datetime'];
                $post['date'] = $getLocalTime['date'];
                $post['time'] = $getLocalTime['time']."".$hours;
            }else{
                $statusDate = date('Y-m-d',strtotime($postData['web']));
                if(strpos($statusDate, "1970-01-01") === false){
                    $post['createdon'] = $postData['web'];
                }
                $post['date'] = date('Y-m-d',strtotime($post['createdon']));
                $post['time'] = date('H:i:s',strtotime($post['createdon']))."".$hours;
            }
        }else{
            $post['date'] = date('Y-m-d');
            $post['time'] = date('H:i:s')."".$hours;
        }
        $post['curdt'] = date('Y-m-d\TH:i:s.u', strtotime($post['createdon']))."".$hours;
        $post['curdtz'] = date('Y-m-d\TH:i:s', strtotime($post['createdon']))."Z";
        $response = $this->salogsendorderstatus($post);
        return true;
         }
    } else {
        return false;
    }
}

public function salogsendorderstatus($post)
{
    $ci = &get_instance();
    $status_code = $post['status_code'] ?? '0';
    $getSalogStatusCodes = $ci->db->select("salog_status_code")->get_where("tb_statuscodes_reference", ["svk_status_code" => $status_code], 1, 0);
    if ($getSalogStatusCodes->num_rows() > 0) {
        $status_code = $getSalogStatusCodes->row()->salog_status_code;
    }
    $salogStatusFlag = checkAccessConditions('SALOG_STATUS_FLAG_BRANCH_WISE', $post['branch_code']);
    if ($salogStatusFlag && ($post['sdt'] == 'PUP') && $status_code == '3000') {
        return;
    }
    if ($status_code == '3000') {
        $statusLocation = $post['delivery_city'];
    } else {
        $statusLocation = $post['order_pickup_city'];
    }
    /*log_message("error","salogsendorderstatus ".json_encode($post));*/
    $request = '';
    $request .= '<?xml version="1.0" encoding="UTF-8"?>';
    $request .= '<ns9:RoadStatus xmlns:ns6="http://knie4.int.kn/com/lref/0100" xmlns:ns5="http://knie4.int.kn/com/lsts/0200" xmlns:ns8="http://knie4.int.kn/com/lpaci/0200" xmlns:ns7="http://knie4.int.kn/com/lrtv/0100" xmlns:ns9="http://knie4.int.kn/msg/roadstatus/0100" xmlns:ns2="http://knie4.int.kn/com/ltypes/0200" xmlns:ns4="http://knie4.int.kn/com/lmlv/0200" xmlns:ns3="http://knie4.int.kn/com/lhdr/0200">\r\n';
    $request .= '<ns3:MessageHeader>';
    $request .= '<ReceiverDetails ns2:AddressType="FW">';
    $request .= '<PhysicalReceiver>'.$post['physicalsender'].'</PhysicalReceiver>';
    $request .= '<LogicalReceiver>'.$post['logicalsender'].'</LogicalReceiver>';
    $request .= '</ReceiverDetails>';
    $request .= '<PhysicalSender>'.$post['physicalreceiver'].'</PhysicalSender>';
    $request .= '<LogicalSender>'.$post['logicalreceiver'].'</LogicalSender>';
    $request .= '<SendingApplication>Svkonekt</SendingApplication>';
    $request .= '<MessageType>RoadStatus</MessageType>';
    $request .= '<VersionNumber>0100</VersionNumber>';
    $request .= '<CreationDateTime>'.$post['curdtz'].'</CreationDateTime>';
    $request .= '<FunctionCode>CR</FunctionCode>';
    $request .= '</ns3:MessageHeader>';
    $request .= '<Message>';
    $request .= '<ns4:MessageLevel>';
    $request .= '<TrackingNumber>'.$post['trackingnumber'].'</TrackingNumber>';
    $request .= '<SenderInformation>';
    $request .= '<CompanyCode>'.$post['company_code'].'</CompanyCode>';
    $request .= '<BranchCode>'.$post['branch_code'].'</BranchCode>';
    $request .= '<DepartmentCode>'.$post['department_code'].'</DepartmentCode>';
    $request .= '<ModeOfTransport>'.$post['modeoftransport'].'</ModeOfTransport>';
    $request .= '</SenderInformation>';
    $request .= '<MessageReferences ns2:AddressType="FF">';
    $request .= '<Code>INN</Code>';
    $request .= '<Value>RL'.$post['trackingnumber'].'</Value>';
    $request .= '</MessageReferences>';
    $request .= '</ns4:MessageLevel>';
    $request .= '<ns5:StatusInformation ns2:StatusCode="'.$status_code.'">';
    $request .= '<StatusDate>'.$post['date'].'</StatusDate>';
    $request .= '<StatusTime>'.$post['time'].'</StatusTime>';
    $branch_code = $post['branch_code'];
    if($branch_code == "THBKK"){
        $statusLocation = "Bangkok";
    }
    $request .= '<StatusLocation ns2:LocationIssuer="6">'.$post['brn'].'</StatusLocation>';
    $request .= '<StatusLocation ns2:LocationIssuer="ZZZ">'.($statusLocation ?? '').'</StatusLocation>';
    $request .= '<AdditionalStatusInformation>';
    $request .= '<CreationIdentifier>X</CreationIdentifier>';
    $request .= '<StatusEntryDateTime>'.$post['curdt'].'</StatusEntryDateTime>';
    $request .= '<UserIdentifier>Svkonekt</UserIdentifier>';
    $request .= '<Remarks>Svkonekt</Remarks>';
    $request .= '</AdditionalStatusInformation>';
    $request .= '<AdditionalRoadStatusInformation/>';
    $request .= '</ns5:StatusInformation>';
    $request .= '<Shipment>';
    $request .= '<ns6:ReferencesDetails>';
    $request .= '<Code>TRN</Code>';
    $request .= '<Value>'.$post['trackingnumber'].'</Value>';
    $request .= '</ns6:ReferencesDetails>';
    $request .= '<ns6:ReferencesDetails>';
    $request .= '<Code>XSR</Code>';
    $request .= '<Value>'.$post['xsr'].'</Value>';
    $request .= '</ns6:ReferencesDetails>';
    $request .= '</Shipment>';
    $request .= '</Message>';
    $request .= '</ns9:RoadStatus>';
    if (MilestoneUpdateXmlChecker::isTest()) {
        MilestoneUpdateXmlChecker::rememberXml($request);
        return true;
    }
    //log_message('error', "salogrequest-xml " . $request);
    $serviceurl = ROADLOG_SVKONEKTURL;
    $username = BOOKING_ETRA_USRNAME;
    $password = BOOKING_ETRA_PWD;
    $headers = array(
        'Content-Type: application/xml',
        'Authorization: Basic '. base64_encode("$username:$password")
    );
  /*  $send = $this->publishxml($request,$post);*/
    $output = thirdpartyservicecurl($serviceurl,$headers,$request);
    $this->writedatatoedilogs($post,$request,$output,'SALOG');
    return true;
}


    /* xLog to Shippeo shipment Status */
    public function shippeoshipmentstatus($postdata)
    {
        $ci = &get_instance();
        /*2300 -> Delivery Shipment Dispatched, 2400 -> Planned Delivery Date, 3000 -> Delivered to Consignee, 3060 -> POD Available */
        $post['shipment_id'] = $postdata['shipment_id'];
        $post['trip_id'] = $postdata['trip_id'];
        $post['latitude'] = isset($postdata['latitude']) ? $postdata['latitude'] : "";
        $post['longitude'] = isset($postdata['longitude']) ? $postdata['longitude'] : "";
        $post['comment'] = $post['comment'] ?? '';
        if ($post['shipment_id'] != "" && $post['trip_id'] != "") {
            $post['status_code'] = isset($postdata['status_code']) ? $postdata['status_code'] : "";
            $post['trackingnumber'] = $postdata['order_id'];
            $post['company_code'] = $post['branch_code'] = $post['shipment_id'] = $post['modeoftransport'] = $post['pickup_city'] = "";
            $post['logicalreceiver'] = $post['physicalreceiver'] = $post['logicalsender'] = $post['physicalsender'] = "";
            $getordinfo = $ci->db->select("pickup_city, company_code, branch_code, shipmentid, logicalreceiver, physicalreceiver, physicalsender, logicalsender, modeoftransport, user_id")->get_where("tb_orders",array("order_id"=>$postdata['order_id']),1,0);
            if($getordinfo->num_rows()>0){
                $post['company_code'] = $getordinfo->row()->company_code;
                $post['branch_code'] = $getordinfo->row()->branch_code;
                $post['shipment_id'] = $getordinfo->row()->shipmentid;
                $post['user_id'] = $getordinfo->row()->user_id;
                if($post['pickup_city'] == ""){
                    $post['pickup_city'] = $getordinfo->row()->pickup_city;
                }
                $post['logicalreceiver'] = $getordinfo->row()->logicalreceiver;
                $post['physicalreceiver'] = $getordinfo->row()->physicalreceiver;
                $post['logicalsender'] = $getordinfo->row()->logicalsender;
                $post['physicalsender'] = $getordinfo->row()->physicalsender;
                $post['modeoftransport'] = $getordinfo->row()->modeoftransport;
            }
            $post['createdon'] = date('Y-m-d H:i:s');
            $hrs = "Z";
            if(isset($postdata['hrs'])){
                $hrs = str_replace(".", ":", $postdata['hrs']);
            }
            if(isset($postdata['curtz'])){
                $getactual = getdatetimebytimezone($postdata['curtz'],$post['createdon'],DFLT_TZ);
                $post['createdon'] = $getactual['datetime'];
                $post['date'] = $getactual['date'];
                $post['time'] = $getactual['time']."".$hrs;
            }else{
                $post['date'] = date('Y-m-d');
                $post['time'] = date('H:i:s')."".$hrs;
            }
            $post['curdt'] = date('Y-m-d\TH:i:s.u', strtotime($post['createdon']))."".$hrs;
            $response = $this->salogsendorderstatus($post);
            return true;
        } else {
            return false;
        }
    }
    public function publishxml($request,$post){
        $this->load->library('uuid');
        $uuid = $this->uuid->v4();
        $ssl_options = array(
            'verify_peer' => false,
            'verify_peer_name' => false
        );
        $headers = new Wire\AMQPTable
        (array(
            'uuid' => $uuid,
            'KNESB_Routing_SenderId' => KNESB_SENDERID,
            'KNESB_Routing_ReceiverId' => KNESB_RECEIVERID,
            'KN_MS_PhysRecvID' => $post['physicalreceiver'],
            'KN_MS_LogRecvID' => $post['logicalreceiver'],
        ));
        $headers->set('short', -1024, Wire\AMQPTable::T_INT_SHORT);
        $connection = new AMQPSSLConnection(SALOG_URL, 5671, SALOG_USRNAME,SALOG_PWD, SALOG_ESB, $ssl_options);
        $channel = $connection->channel();
        $Xmldata = new AMQPMessage($request,array('content_type' => 'Application/xml','delivery_mode' => AMQPMessage::DELIVERY_MODE_PERSISTENT));
        $Xmldata->set('application_headers', $headers);
        $channel->basic_publish($Xmldata,SALOG_EROADSTATUS,null);
        $channel->close();
        $connection->close();
    }
    /**
     * Used to register salog/roadlog outbound activity into logs.
     */
    function writedatatoedilogs($postdata,$request,$response,$edi_name){

        if (!$response) {
            $response = [];
        }
         $ci = &get_instance();
         $ci->load->library('Edi_logger');
         $ci->edi_logger->setEdi_type(2);
         $ci->edi_logger->setTransaction_id(time());
         $ci->edi_logger->setEdi_name($edi_name);
         $ci->edi_logger->setBounded_type(2);
         $ci->edi_logger->setEdi_format_type('XML');
         $ci->edi_logger->setStatus(isset($response['_error'])?0:1);
         if($edi_name =='SALOG'){
            $ci->edi_logger->setObj_type_name('delivery-note');
         }else{
            $ci->edi_logger->setObj_type_name('order-id');
         }
         $ci->edi_logger->setTxn_obj_id($postdata['trackingnumber']);
         $ci->edi_logger->setEdi_request($request);
         $ci->edi_logger->setEdi_response(json_encode($response));
         $ci->edi_logger->setCompany_code($postdata['company_code']);
         $ci->edi_logger->setBranch_code($postdata['branch_code']);
         if(!isset($postdata['user_id'])){
             $postdata['user_id'] = 0;
        }
        $ci->edi_logger->setUser_id($postdata['user_id']);
         if($postdata['user_id']=='' || $postdata['user_id'] == 0){
            $getordinfo = $ci->db->select("pickup_city, company_code, branch_code, shipmentid, logicalreceiver, physicalreceiver, physicalsender, logicalsender, modeoftransport, user_id")->get_where("tb_orders",array("order_id"=>$postdata['order_id']),1,0);
            if($getordinfo->num_rows()>0){
                $ci->edi_logger->setUser_id($getordinfo->row()->user_id);
            }else{
                $ci->edi_logger->setUser_id(0);
            }
         }
         $ci->edi_logger->saveToEdiLogs();
    }

    private function getOrderInfo(array $postdata, string $statusCode): bool
    {
        if (empty($postdata['order_id'])) {
            return false;
        }
        $ci = &get_instance();
        $post['shipment_id'] = $postdata['shipment_id'];
        $post['trip_id'] = $postdata['trip_id'];
        $post['stop_id'] = $postdata['stop_id'];
        $post['driver_id'] = $postdata['driver_id'];
        $post['latitude'] = $postdata['latitude'] ?? "";
        $post['longitude'] = $postdata['longitude'] ?? "";
        $post['comment'] = $postdata['comment'] ?? "";
        $post['pickup_city'] = $postdata['pickup_city'] ?? "";
        $post['status_code'] = $statusCode;
        $post['company_code'] = $post['branch_code'] = $post['modeoftransport'] = $post['logicalreceiver'] = $post['physicalreceiver'] = $post['logicalsender'] = $post['physicalsender'] = "";
        $select = ['id', 'pickup_city', 'company_code', 'branch_code', 'shipmentid', 'logicalreceiver', 'physicalreceiver', 'physicalsender', 'logicalsender', 'modeoftransport', 'user_id', 'created_source'];
        $getordinfo = $ci->db->select($select)->get_where("tb_orders", ["order_id" => $postdata['order_id']], 1, 0);

        $post['trackingnumber'] = $post['innnumber'] = '';
        if ($getordinfo && $getordinfo->num_rows() > 0) {
            $getordinfo = $getordinfo->row_array();
            $post['company_code'] = $getordinfo['company_code'];
            $post['branch_code'] = $getordinfo['branch_code'];
            $post['shipment_id'] = $getordinfo['shipmentid'];
            $post['user_id'] = $getordinfo['user_id'];
            $post['pickup_city'] = empty($post['pickup_city']) ? $getordinfo['pickup_city']:$post['pickup_city'];
            $post['logicalreceiver'] = $getordinfo['logicalreceiver'];
            $post['physicalreceiver'] = $getordinfo['physicalreceiver'];
            $post['logicalsender'] = $getordinfo['logicalsender'];
            $post['physicalsender'] = $getordinfo['physicalsender'];
            $post['modeoftransport'] = $getordinfo['modeoftransport'];
            $post['created_source'] = $getordinfo['created_source'];
            $post['trackingnumber'] = $postdata['order_id'];

            // Getting References
            $references = $ci->db->select(['*'])->order_by('id', 'ASC')->get_where("tb_order_references", [
                "order_id" => $getordinfo['id'],
                'reference_id' => 'INN'
            ], 1, 0);
            $post['innnumber'] = ($references->num_rows() > 0) ?  $references->row()->ref_value : "";

        }
        $post['createdon'] = date('Y-m-d H:i:s');
        $hrs = "Z";
        if (isset($postdata['hrs'])) {
            $hrs = str_replace(".", ":", $postdata['hrs']);
        }
        if (isset($postdata['curtz'])) {
            if (!isset($postdata['web'])) {
                $getactual = getdatetimebytimezone($postdata['curtz'], $post['createdon'], DFLT_TZ);
                $post['createdon'] = $getactual['datetime'];
                $post['date'] = $getactual['date'];
                $post['time'] = $getactual['time'] . "" . $hrs;
            } else {
                $post['createdon'] = $postdata['web'];
                $post['date'] = date('Y-m-d', strtotime($post['createdon']));
                $post['time'] = date('H:i:s', strtotime($post['createdon'])) . "" . $hrs;
            }
        } else {
            $post['date'] = date('Y-m-d');
            $post['time'] = date('H:i:s') . "" . $hrs;
        }
        $post['curdt'] = date('Y-m-d\TH:i:s', strtotime($post['createdon'])) . "" . $hrs;

        try {
            $this->roadlogsendorderstatus($post);
        } catch (Exception $ex) {
            log_message("error", "Some Problem occured!, While Pushing to Roadlog.".$ex->getMessage());
            return false;
        }
        return true;
    }

    public function sendPodToKnlogin(int $docType, int $orderId, int $fromSource = 0): void
    {
        $ci = &get_instance();
        $ci->load->model('completedordersmodel');
        $data['order'] = $orderData = $ci->completedordersmodel->getOrderAndCustomerDetails($orderId);
        $timeZone = $orderData['cntry_timezone'] ?? "";
        $currentDate = date('Y-m-d H:i:s');
        $data['pod'] = $ci->completedordersmodel->getOrderPodsData($orderId, $docType, $timeZone);
        if ($data["pod"]->num_rows() > 0) {
            $data['order']['pickup_address1'] = str_replace('， ', ',', $data['order']['pickup_address1']);
            $data['order']['delivery_address1'] = str_replace('， ', ',', $data['order']['delivery_address1']);
            $countryCode = $orderData['country_code'];
            if ($docType === 3) {
                $documentIdType = 1;
                $documentType = self::KNLOGIN_POD_DOCTYPE;
            } elseif ($docType === 4) {
                $documentIdType = 2;
                $documentType = self::KNLOGIN_PUP_DOCTYPE;
            } else {
                $documentIdType = 3;
                $documentType = self::KNLOGIN_PICTURE_DOCTYPE;
            }
            $ci->load->library(['m_pdf', 'sendpodtoknservice', 'DocumentSequenceLibrary']);
            $documentId = $ci->documentsequencelibrary->getSequence('ETN', $countryCode, $documentIdType);
            $ePodPath = "./assets/trippods/" . $documentId . ".pdf";
            $data["orderref"] = $ci->common->getallorderreferences($orderData["id"]);
            $data = $ci->completedordersmodel->getOrderPickupDeliveryDateTime($orderId, $timeZone, $data);
            if ($fromSource > 0) {
                /* If fromSource greater than 0, got call from secure link or mobile app. We need to convert date to order's user time zone */
                $getUserDate = getdatetimebytimezone($timeZone, $currentDate, DFLT_TZ);
                $currentDate = $getUserDate['datetime'];
                if(!in_array($docType, [3, 4], true)){
                    $data['delivery_datetime'] = $data['delivery_datetime'] ?: $currentDate;
                }
            }
            if (in_array($docType, [3, 4], true)) {
                $data['pickup_datetime'] = $data['pickup_datetime'] ?: $currentDate;
            }
            if ($docType === 3) {
                $data['delivery_datetime'] = $data['delivery_datetime'] ?: $currentDate;
            }
            $html = $ci->load->view("settings/bulkepod", $data, true);
            $ci->m_pdf->pdf->autoScriptToLang = true;
            $ci->m_pdf->pdf->autoLangToFont = true;
            $writeHtml = @$ci->m_pdf->pdf->WriteHTML($html);
            $storePod = @$ci->m_pdf->pdf->Output($ePodPath, "F");
            $pages = $ci->m_pdf->pdf->pages;
            $pagesCount = count($pages);
            $jplData = [
                "country" => $countryCode,
                "branch" => substr($orderData['branch_code'], 2),
                "order_id" => $orderData['order_id'],
                "time" => date("hi"),
                "unique_id" => $documentId,
                "date" => date("d.m.Y"),
                "pages" => $pagesCount,
                "doctype" => $documentType
            ];
            $jplFilePath = $ci->sendpodtoknservice->saveJPF($jplData);
            $ci->sendpodtoknservice->uploadKNFile($jplFilePath);
            $ci->sendpodtoknservice->uploadKNFile($ePodPath);
        }
    }
}
