<?php

class Stsintegrate
{
    /* xLog to Roadlog Status */
    public function roadlogshipmentconfirm1($postdata)
    {
        $ci = &get_instance();
        $post['shipment_id'] = $postdata['shipment_id'];
        $post['trip_id']     = $postdata['trip_id'];
        $post['stop_id']     = $postdata['stop_id'];
        $post['driver_id']   = $postdata['driver_id'];
        $post['latitude']   = isset($postdata['latitude']) ? $postdata['latitude'] : "";
        $post['longitude']   = isset($postdata['longitude']) ? $postdata['longitude'] : "";
        $post['pickup_city']   = isset($postdata['pickup_city']) ? $postdata['pickup_city'] : "";
        if ($post['shipment_id'] != "" && $post['trip_id'] != "") {
            $post['status_code'] = '0212'; /*Load Confirmed by Driver*/
            $post['trackingnumber'] = $postdata['order_id'];
            $post['company_code'] = $post['branch_code'] = $post['modeoftransport'] = "";
            $post['logicalreceiver'] = $post['physicalreceiver'] = $post['logicalsender'] = $post['physicalsender'] = "";
            $getordinfo = $ci->db->select("pickup_city, company_code, branch_code, shipmentid, logicalreceiver, physicalreceiver, physicalsender, logicalsender, modeoftransport")->get_where("tb_orders",array("order_id"=>$postdata['order_id']),1,0);
            if($getordinfo->num_rows()>0){
            	$post['company_code'] = $getordinfo->row()->company_code;
            	$post['branch_code'] = $getordinfo->row()->branch_code;
                $post['shipment_id'] = $getordinfo->row()->shipmentid;
                if($post['pickup_city'] == ""){
	            	$post['pickup_city'] = $getordinfo->row()->pickup_city;
	            }
        		$post['logicalreceiver'] = $getordinfo->row()->logicalreceiver;
        		$post['physicalreceiver'] = $getordinfo->row()->physicalreceiver;
        		$post['logicalsender'] = $getordinfo->row()->logicalsender;
        		$post['physicalsender'] = $getordinfo->row()->physicalsender;
        		$post['modeoftransport'] = $getordinfo->row()->modeoftransport;
            }
            $post['createdon'] = $postdata['createdon'];

            $hrs = "Z";
            if(isset($postdata['hrs'])){
                $hrs = str_replace(".", ":", $postdata['hrs']);
            }
            if(isset($postdata['curtz'])){
                if(!isset($postdata['web'])){
                    $getactual = getdatetimebytimezone($postdata['curtz'],$post['createdon'],DFLT_TZ);
                    $post['createdon'] = $getactual['datetime'];
                    $post['date'] = $getactual['date'];
                    $post['time'] = $getactual['time']."".$hrs;
                }else{
                    $post['createdon'] = $postdata['web'];
                    $post['date'] = date('Y-m-d',strtotime($post['createdon']));
                    $post['time'] = date('H:i:s',strtotime($post['createdon']))."".$hrs;
                }
            }else{
                $post['date'] = date('Y-m-d');
                $post['time'] = date('H:i:s')."".$hrs;
            }
            $post['curdt'] = date('Y-m-d\TH:i:s', strtotime($post['createdon']))."".$hrs;
            $response = $this->roadlogsendorderstatus1($post);
            return true;
        } else {
            return false;
        }
    }

    /* xLog to Roadlog Status */
    public function roadlogshipmentpicked1($postdata)
    {
        $ci = &get_instance();
        $post['shipment_id'] = $postdata['shipment_id'];
        $post['trip_id']     = $postdata['trip_id'];
        $post['stop_id']     = $postdata['stop_id'];
        $post['driver_id']   = $postdata['driver_id'];
        $post['latitude']   = isset($postdata['latitude']) ? $postdata['latitude'] : "";
        $post['longitude']   = isset($postdata['longitude']) ? $postdata['longitude'] : "";
        $post['pickup_city']   = isset($postdata['pickup_city']) ? $postdata['pickup_city'] : "";
        if ($post['shipment_id'] != "" && $post['trip_id'] != "") {
            $post['status_code'] = '0500'; /*Source Location Pickup*/
            $post['trackingnumber'] = $postdata['order_id'];
            $post['company_code'] = $post['branch_code'] = $post['shipment_id'] = $post['modeoftransport'] = "";
            $post['logicalreceiver'] = $post['physicalreceiver'] = $post['logicalsender'] = $post['physicalsender'] = "";
            $getordinfo = $ci->db->select("pickup_city, company_code, branch_code, shipmentid, logicalreceiver, physicalreceiver, physicalsender, logicalsender, modeoftransport")->get_where("tb_orders",array("order_id"=>$postdata['order_id']),1,0);
            if($getordinfo->num_rows()>0){
                $post['company_code'] = $getordinfo->row()->company_code;
                $post['branch_code'] = $getordinfo->row()->branch_code;
                $post['shipment_id'] = $getordinfo->row()->shipmentid;
                if($post['pickup_city'] == ""){
                    $post['pickup_city'] = $getordinfo->row()->pickup_city;
                }
                $post['logicalreceiver'] = $getordinfo->row()->logicalreceiver;
                $post['physicalreceiver'] = $getordinfo->row()->physicalreceiver;
                $post['logicalsender'] = $getordinfo->row()->logicalsender;
                $post['physicalsender'] = $getordinfo->row()->physicalsender;
                $post['modeoftransport'] = $getordinfo->row()->modeoftransport;
            }
            $post['createdon'] = $postdata['createdon'];
            $hrs = "Z";
            if(isset($postdata['hrs'])){
                $hrs = str_replace(".", ":", $postdata['hrs']);
            }
            if(isset($postdata['curtz'])){
                if(!isset($postdata['web'])){
                    $getactual = getdatetimebytimezone($postdata['curtz'],$post['createdon'],DFLT_TZ);
                    $post['createdon'] = $getactual['datetime'];
                    $post['date'] = $getactual['date'];
                    $post['time'] = $getactual['time']."".$hrs;
                }else{
                    $post['createdon'] = $postdata['web'];
                    $post['date'] = date('Y-m-d',strtotime($post['createdon']));
                    $post['time'] = date('H:i:s',strtotime($post['createdon']))."".$hrs;
                }
            }else{
                $post['date'] = date('Y-m-d');
                $post['time'] = date('H:i:s')."".$hrs;
            }
            $post['curdt'] = date('Y-m-d\TH:i:s', strtotime($post['createdon']))."".$hrs;
            $response = $this->roadlogsendorderstatus1($post);
            return true;
        } else {
            return false;
        }
    }

    /* xLog to Roadlog Status */
    public function roadlogshipmentpgatein1($postdata)
    {
        $ci = &get_instance();
        $post['shipment_id'] = $postdata['shipment_id'];
        $post['trip_id']     = $postdata['trip_id'];
        $post['stop_id']     = $postdata['stop_id'];
        $post['driver_id']   = $postdata['driver_id'];
        $post['latitude']   = isset($postdata['latitude']) ? $postdata['latitude'] : "";
        $post['longitude']   = isset($postdata['longitude']) ? $postdata['longitude'] : "";
        $post['pickup_city']   = isset($postdata['pickup_city']) ? $postdata['pickup_city'] : "";
        if ($post['shipment_id'] != "" && $post['trip_id'] != "") {
            $post['status_code'] = '0420'; /*Pickup Location Gatein*/
            $post['trackingnumber'] = $postdata['order_id'];
            $post['company_code'] = $post['branch_code'] = $post['shipment_id'] = $post['modeoftransport'] = "";
            $post['logicalreceiver'] = $post['physicalreceiver'] = $post['logicalsender'] = $post['physicalsender'] = "";
            $getordinfo = $ci->db->select("pickup_city, company_code, branch_code, shipmentid, logicalreceiver, physicalreceiver, physicalsender, logicalsender, modeoftransport")->get_where("tb_orders",array("order_id"=>$postdata['order_id']),1,0);
            if($getordinfo->num_rows()>0){
                $post['company_code'] = $getordinfo->row()->company_code;
                $post['branch_code'] = $getordinfo->row()->branch_code;
                $post['shipment_id'] = $getordinfo->row()->shipmentid;
                if($post['pickup_city'] == ""){
                    $post['pickup_city'] = $getordinfo->row()->pickup_city;
                }
                $post['logicalreceiver'] = $getordinfo->row()->logicalreceiver;
                $post['physicalreceiver'] = $getordinfo->row()->physicalreceiver;
                $post['logicalsender'] = $getordinfo->row()->logicalsender;
                $post['physicalsender'] = $getordinfo->row()->physicalsender;
                $post['modeoftransport'] = $getordinfo->row()->modeoftransport;
            }
            $post['createdon'] = $postdata['createdon'];
            $hrs = "Z";
            if(isset($postdata['hrs'])){
                $hrs = str_replace(".", ":", $postdata['hrs']);
            }
            if(isset($postdata['curtz'])){
                if(!isset($postdata['web'])){
                    $getactual = getdatetimebytimezone($postdata['curtz'],$post['createdon'],DFLT_TZ);
                    $post['createdon'] = $getactual['datetime'];
                    $post['date'] = $getactual['date'];
                    $post['time'] = $getactual['time']."".$hrs;
                }else{
                    $post['createdon'] = $postdata['web'];
                    $post['date'] = date('Y-m-d',strtotime($post['createdon']));
                    $post['time'] = date('H:i:s',strtotime($post['createdon']))."".$hrs;
                }
            }else{
                $post['date'] = date('Y-m-d');
                $post['time'] = date('H:i:s')."".$hrs;
            }
            $post['curdt'] = date('Y-m-d\TH:i:s', strtotime($post['createdon']))."".$hrs;
            $response = $this->roadlogsendorderstatus1($post);
            return true;
        } else {
            return false;
        }
    }

    /* xLog to Roadlog Status */
    public function roadlogshipmentpgateout1($postdata)
    {
        $ci = &get_instance();
        $post['shipment_id'] = $postdata['shipment_id'];
        $post['trip_id']     = $postdata['trip_id'];
        $post['stop_id']     = $postdata['stop_id'];
        $post['driver_id']   = $postdata['driver_id'];
        $post['latitude']   = isset($postdata['latitude']) ? $postdata['latitude'] : "";
        $post['longitude']   = isset($postdata['longitude']) ? $postdata['longitude'] : "";
        $post['pickup_city']   = isset($postdata['pickup_city']) ? $postdata['pickup_city'] : "";
        if ($post['shipment_id'] != "" && $post['trip_id'] != "") {
            $post['status_code'] = '0191'; /*Pickup Location GateOut*/
            $post['trackingnumber'] = $postdata['order_id'];
            $post['company_code'] = $post['branch_code'] = $post['shipment_id'] = $post['modeoftransport'] = "";
            $post['logicalreceiver'] = $post['physicalreceiver'] = $post['logicalsender'] = $post['physicalsender'] = "";
            $getordinfo = $ci->db->select("pickup_city, company_code, branch_code, shipmentid, logicalreceiver, physicalreceiver, physicalsender, logicalsender, modeoftransport")->get_where("tb_orders",array("order_id"=>$postdata['order_id']),1,0);
            if($getordinfo->num_rows()>0){
                $post['company_code'] = $getordinfo->row()->company_code;
                $post['branch_code'] = $getordinfo->row()->branch_code;
                $post['shipment_id'] = $getordinfo->row()->shipmentid;
                if($post['pickup_city'] == ""){
                    $post['pickup_city'] = $getordinfo->row()->pickup_city;
                }
                $post['logicalreceiver'] = $getordinfo->row()->logicalreceiver;
                $post['physicalreceiver'] = $getordinfo->row()->physicalreceiver;
                $post['logicalsender'] = $getordinfo->row()->logicalsender;
                $post['physicalsender'] = $getordinfo->row()->physicalsender;
                $post['modeoftransport'] = $getordinfo->row()->modeoftransport;
            }
            $post['createdon'] = $postdata['createdon'];
            $hrs = "Z";
            if(isset($postdata['hrs'])){
                $hrs = str_replace(".", ":", $postdata['hrs']);
            }
            if(isset($postdata['curtz'])){
                if(!isset($postdata['web'])){
                    $getactual = getdatetimebytimezone($postdata['curtz'],$post['createdon'],DFLT_TZ);
                    $post['createdon'] = $getactual['datetime'];
                    $post['date'] = $getactual['date'];
                    $post['time'] = $getactual['time']."".$hrs;
                }else{
                    $post['createdon'] = $postdata['web'];
                    $post['date'] = date('Y-m-d',strtotime($post['createdon']));
                    $post['time'] = date('H:i:s',strtotime($post['createdon']))."".$hrs;
                }
            }else{
                $post['date'] = date('Y-m-d');
                $post['time'] = date('H:i:s')."".$hrs;
            }
            $post['curdt'] = date('Y-m-d\TH:i:s', strtotime($post['createdon']))."".$hrs;
            $response = $this->roadlogsendorderstatus1($post);
            return true;
        } else {
            return false;
        }
    }

    /* xLog to Roadlog Status */
    public function roadlogshipmentdgatein1($postdata)
    {
        $ci = &get_instance();
        $post['shipment_id'] = $postdata['shipment_id'];
        $post['trip_id']     = $postdata['trip_id'];
        $post['stop_id']     = $postdata['stop_id'];
        $post['driver_id']   = $postdata['driver_id'];
        $post['latitude']   = isset($postdata['latitude']) ? $postdata['latitude'] : "";
        $post['longitude']   = isset($postdata['longitude']) ? $postdata['longitude'] : "";
        $post['pickup_city']   = isset($postdata['pickup_city']) ? $postdata['pickup_city'] : "";
        if ($post['shipment_id'] != "" && $post['trip_id'] != "") {
            $post['status_code'] = '0192'; /*Delivery Location GateIn*/
            $post['trackingnumber'] = $postdata['order_id'];
            $post['company_code'] = $post['branch_code'] = $post['shipment_id'] = $post['modeoftransport'] = "";
            $post['logicalreceiver'] = $post['physicalreceiver'] = $post['logicalsender'] = $post['physicalsender'] = "";
            $getordinfo = $ci->db->select("pickup_city, company_code, branch_code, shipmentid, logicalreceiver, physicalreceiver, physicalsender, logicalsender, modeoftransport")->get_where("tb_orders",array("order_id"=>$postdata['order_id']),1,0);
            if($getordinfo->num_rows()>0){
                $post['company_code'] = $getordinfo->row()->company_code;
                $post['branch_code'] = $getordinfo->row()->branch_code;
                $post['shipment_id'] = $getordinfo->row()->shipmentid;
                if($post['pickup_city'] == ""){
                    $post['pickup_city'] = $getordinfo->row()->pickup_city;
                }
                $post['logicalreceiver'] = $getordinfo->row()->logicalreceiver;
                $post['physicalreceiver'] = $getordinfo->row()->physicalreceiver;
                $post['logicalsender'] = $getordinfo->row()->logicalsender;
                $post['physicalsender'] = $getordinfo->row()->physicalsender;
                $post['modeoftransport'] = $getordinfo->row()->modeoftransport;
            }
            $post['createdon'] = $postdata['createdon'];
            $hrs = "Z";
            if(isset($postdata['hrs'])){
                $hrs = str_replace(".", ":", $postdata['hrs']);
            }
            if(isset($postdata['curtz'])){
                if(!isset($postdata['web'])){
                    $getactual = getdatetimebytimezone($postdata['curtz'],$post['createdon'],DFLT_TZ);
                    $post['createdon'] = $getactual['datetime'];
                    $post['date'] = $getactual['date'];
                    $post['time'] = $getactual['time']."".$hrs;
                }else{
                    $post['createdon'] = $postdata['web'];
                    $post['date'] = date('Y-m-d',strtotime($post['createdon']));
                    $post['time'] = date('H:i:s',strtotime($post['createdon']))."".$hrs;
                }
            }else{
                $post['date'] = date('Y-m-d');
                $post['time'] = date('H:i:s')."".$hrs;
            }
            $post['curdt'] = date('Y-m-d\TH:i:s', strtotime($post['createdon']))."".$hrs;
            $response = $this->roadlogsendorderstatus1($post);
            return true;
        } else {
            return false;
        }
    }

    /* xLog to Roadlog Status */
    public function roadlogshipmentdeliverpartial1($postdata)
    {
        $ci = &get_instance();
        $post['shipment_id'] = $postdata['shipment_id'];
        $post['trip_id']     = $postdata['trip_id'];
        $post['stop_id']     = $postdata['stop_id'];
        $post['driver_id']   = $postdata['driver_id'];
        $post['latitude']   = isset($postdata['latitude']) ? $postdata['latitude'] : "";
        $post['longitude']   = isset($postdata['longitude']) ? $postdata['longitude'] : "";
        $post['pickup_city']   = isset($postdata['pickup_city']) ? $postdata['pickup_city'] : "";
        if ($post['shipment_id'] != "" && $post['trip_id'] != "") {
            $post['status_code'] = '3002';/*'2420';*/ /*Partial Delivery Requested*/
            $post['trackingnumber'] = $postdata['order_id'];
            $post['company_code'] = $post['branch_code'] = $post['shipment_id'] = $post['modeoftransport'] = "";
            $post['logicalreceiver'] = $post['physicalreceiver'] = $post['logicalsender'] = $post['physicalsender'] = "";
            $getordinfo = $ci->db->select("pickup_city, company_code, branch_code, shipmentid, logicalreceiver, physicalreceiver, physicalsender, logicalsender, modeoftransport")->get_where("tb_orders",array("order_id"=>$postdata['order_id']),1,0);
            if($getordinfo->num_rows()>0){
                $post['company_code'] = $getordinfo->row()->company_code;
                $post['branch_code'] = $getordinfo->row()->branch_code;
                $post['shipment_id'] = $getordinfo->row()->shipmentid;
                if($post['pickup_city'] == ""){
                    $post['pickup_city'] = $getordinfo->row()->pickup_city;
                }
                $post['logicalreceiver'] = $getordinfo->row()->logicalreceiver;
                $post['physicalreceiver'] = $getordinfo->row()->physicalreceiver;
                $post['logicalsender'] = $getordinfo->row()->logicalsender;
                $post['physicalsender'] = $getordinfo->row()->physicalsender;
                $post['modeoftransport'] = $getordinfo->row()->modeoftransport;
            }
            $post['createdon'] = $postdata['createdon'];
            $hrs = "Z";
            if(isset($postdata['hrs'])){
                $hrs = str_replace(".", ":", $postdata['hrs']);
            }
            if(isset($postdata['curtz'])){
                $getactual = getdatetimebytimezone($postdata['curtz'],$post['createdon'],DFLT_TZ);
                $post['createdon'] = $getactual['datetime'];
                $post['date'] = $getactual['date'];
                $post['time'] = $getactual['time']."".$hrs;
            }else{
                $post['date'] = date('Y-m-d');
                $post['time'] = date('H:i:s')."".$hrs;
            }
            $post['curdt'] = date('Y-m-d\TH:i:s.u', strtotime($post['createdon']))."".$hrs;
            $response = $this->roadlogsendorderstatus1($post);
            return true;
        } else {
            return false;
        }
    }

    /* xLog to Roadlog Status */
    public function roadlogshipmenttripdeliverpartial1($postdata)
    {
        $ci = &get_instance();
        $post['shipment_id'] = $postdata['shipment_id'];
        $post['trip_id']     = $postdata['trip_id'];
        $post['stop_id']     = $postdata['stop_id'];
        $post['driver_id']   = $postdata['driver_id'];
        $post['latitude']   = isset($postdata['latitude']) ? $postdata['latitude'] : "";
        $post['longitude']   = isset($postdata['longitude']) ? $postdata['longitude'] : "";
        $post['pickup_city']   = isset($postdata['pickup_city']) ? $postdata['pickup_city'] : "";
        if ($post['shipment_id'] != "" && $post['trip_id'] != "") {
            $post['status_code'] = '0218';/*'2420';*/ /*Trip Ended*/
            $post['trackingnumber'] = $postdata['order_id'];
            $post['company_code'] = $post['branch_code'] = $post['shipment_id'] = $post['modeoftransport'] = "";
            $post['logicalreceiver'] = $post['physicalreceiver'] = $post['logicalsender'] = $post['physicalsender'] = "";
            $getordinfo = $ci->db->select("pickup_city, company_code, branch_code, shipmentid, logicalreceiver, physicalreceiver, physicalsender, logicalsender, modeoftransport")->get_where("tb_orders",array("order_id"=>$postdata['order_id']),1,0);
            if($getordinfo->num_rows()>0){
                $post['company_code'] = $getordinfo->row()->company_code;
                $post['branch_code'] = $getordinfo->row()->branch_code;
                $post['shipment_id'] = $getordinfo->row()->shipmentid;
                if($post['pickup_city'] == ""){
                    $post['pickup_city'] = $getordinfo->row()->pickup_city;
                }
                $post['logicalreceiver'] = $getordinfo->row()->logicalreceiver;
                $post['physicalreceiver'] = $getordinfo->row()->physicalreceiver;
                $post['logicalsender'] = $getordinfo->row()->logicalsender;
                $post['physicalsender'] = $getordinfo->row()->physicalsender;
                $post['modeoftransport'] = $getordinfo->row()->modeoftransport;
            }
            $post['createdon'] = $postdata['createdon'];
            $hrs = "Z";
            if(isset($postdata['hrs'])){
                $hrs = str_replace(".", ":", $postdata['hrs']);
            }
            if(isset($postdata['curtz'])){
                $getactual = getdatetimebytimezone($postdata['curtz'],$post['createdon'],DFLT_TZ);
                $post['createdon'] = $getactual['datetime'];
                $post['date'] = $getactual['date'];
                $post['time'] = $getactual['time']."".$hrs;
            }else{
                $post['date'] = date('Y-m-d');
                $post['time'] = date('H:i:s')."".$hrs;
            }
            $post['curdt'] = date('Y-m-d\TH:i:s.u', strtotime($post['createdon']))."".$hrs;
            $response = $this->roadlogsendorderstatus1($post);
            return true;
        } else {
            return false;
        }
    }

    /* xLog to Roadlog Status */
    public function roadlogshipcollectcancel1($postdata)
    {
        $ci = &get_instance();
        $post['shipment_id'] = $postdata['shipment_id'];
        $post['trip_id']     = $postdata['trip_id'];
        $post['stop_id']     = $postdata['stop_id'];
        $post['driver_id']   = $postdata['driver_id'];
        $post['latitude']   = isset($postdata['latitude']) ? $postdata['latitude'] : "";
        $post['longitude']   = isset($postdata['longitude']) ? $postdata['longitude'] : "";
        $post['pickup_city']   = isset($postdata['pickup_city']) ? $postdata['pickup_city'] : "";
        if ($post['shipment_id'] != "" && $post['trip_id'] != "") {
            $post['status_code'] = '0460'; /*Collection Order Declined by Driver*/
            $post['trackingnumber'] = $postdata['order_id'];
            $post['company_code'] = $post['branch_code'] = $post['shipment_id'] = $post['modeoftransport'] = "";
            $post['logicalreceiver'] = $post['physicalreceiver'] = $post['logicalsender'] = $post['physicalsender'] = "";
            $getordinfo = $ci->db->select("pickup_city, company_code, branch_code, shipmentid, logicalreceiver, physicalreceiver, physicalsender, logicalsender, modeoftransport")->get_where("tb_orders",array("order_id"=>$postdata['order_id']),1,0);
            if($getordinfo->num_rows()>0){
                $post['company_code'] = $getordinfo->row()->company_code;
                $post['branch_code'] = $getordinfo->row()->branch_code;
                $post['shipment_id'] = $getordinfo->row()->shipmentid;
                if($post['pickup_city'] == ""){
                    $post['pickup_city'] = $getordinfo->row()->pickup_city;
                }
                $post['logicalreceiver'] = $getordinfo->row()->logicalreceiver;
                $post['physicalreceiver'] = $getordinfo->row()->physicalreceiver;
                $post['logicalsender'] = $getordinfo->row()->logicalsender;
                $post['physicalsender'] = $getordinfo->row()->physicalsender;
                $post['modeoftransport'] = $getordinfo->row()->modeoftransport;
            }
            $post['createdon'] = $postdata['createdon'];
            $hrs = "Z";
            if(isset($postdata['hrs'])){
                $hrs = str_replace(".", ":", $postdata['hrs']);
            }
            if(isset($postdata['curtz'])){
                $getactual = getdatetimebytimezone($postdata['curtz'],$post['createdon'],DFLT_TZ);
                $post['createdon'] = $getactual['datetime'];
                $post['date'] = $getactual['date'];
                $post['time'] = $getactual['time']."".$hrs;
            }else{
                $post['date'] = date('Y-m-d');
                $post['time'] = date('H:i:s')."".$hrs;
            }
            $post['curdt'] = date('Y-m-d\TH:i:s.u', strtotime($post['createdon']))."".$hrs;
            $response = $this->roadlogsendorderstatus1($post);
            return true;
        } else {
            return false;
        }
    }

    /* xLog to Roadlog Status */
    public function roadlogshipmentintransit1($postdata)
    {
        $ci = &get_instance();
        $post['shipment_id'] = $postdata['shipment_id'];
        $post['trip_id']     = $postdata['trip_id'];
        $post['stop_id']     = $postdata['stop_id'];
        $post['driver_id']   = $postdata['driver_id'];
        $post['latitude']   = isset($postdata['latitude']) ? $postdata['latitude'] : "";
        $post['longitude']   = isset($postdata['longitude']) ? $postdata['longitude'] : "";
        $post['pickup_city']   = isset($postdata['pickup_city']) ? $postdata['pickup_city'] : "";
        if ($post['shipment_id'] != "" && $post['trip_id'] != "") {
            $post['status_code'] = '1550'; /*Actual Transit Location*/
            $post['trackingnumber'] = $postdata['order_id'];
            $post['company_code'] = $post['branch_code'] = $post['shipment_id'] = $post['modeoftransport'] = "";
            $post['logicalreceiver'] = $post['physicalreceiver'] = $post['logicalsender'] = $post['physicalsender'] = "";
            $getordinfo = $ci->db->select("pickup_city, company_code, branch_code, shipmentid, logicalreceiver, physicalreceiver, physicalsender, logicalsender, modeoftransport")->get_where("tb_orders",array("order_id"=>$postdata['order_id']),1,0);
            if($getordinfo->num_rows()>0){
                $post['company_code'] = $getordinfo->row()->company_code;
                $post['branch_code'] = $getordinfo->row()->branch_code;
                $post['shipment_id'] = $getordinfo->row()->shipmentid;
                if($post['pickup_city'] == ""){
                    $post['pickup_city'] = $getordinfo->row()->pickup_city;
                }
                $post['logicalreceiver'] = $getordinfo->row()->logicalreceiver;
                $post['physicalreceiver'] = $getordinfo->row()->physicalreceiver;
                $post['logicalsender'] = $getordinfo->row()->logicalsender;
                $post['physicalsender'] = $getordinfo->row()->physicalsender;
                $post['modeoftransport'] = $getordinfo->row()->modeoftransport;
            }
            $post['createdon'] = $postdata['createdon'];
            $hrs = "Z";
            if(isset($postdata['hrs'])){
                $hrs = str_replace(".", ":", $postdata['hrs']);
            }
            if(isset($postdata['curtz'])){
                if(!isset($postdata['web'])){
                    $getactual = getdatetimebytimezone($postdata['curtz'],$post['createdon'],DFLT_TZ);
                    $post['createdon'] = $getactual['datetime'];
                    $post['date'] = $getactual['date'];
                    $post['time'] = $getactual['time']."".$hrs;
                }else{
                    $post['createdon'] = $postdata['web'];
                    $post['date'] = date('Y-m-d',strtotime($post['createdon']));
                    $post['time'] = date('H:i:s',strtotime($post['createdon']))."".$hrs;
                }
            }else{
                $post['date'] = date('Y-m-d');
                $post['time'] = date('H:i:s')."".$hrs;
            }
            $post['curdt'] = date('Y-m-d\TH:i:s', strtotime($post['createdon']))."".$hrs;
            $response = $this->roadlogsendorderstatus1($post);
            return true;
        } else {
            return false;
        }
    }

    /* xLog to Roadlog Status */
    public function roadlogshipmentdelivered1($postdata)
    {
        $ci = &get_instance();
        $post['shipment_id'] = $postdata['shipment_id'];
        $post['trip_id']     = $postdata['trip_id'];
        $post['stop_id']     = $postdata['stop_id'];
        $post['driver_id']   = $postdata['driver_id'];
        $post['latitude']   = isset($postdata['latitude']) ? $postdata['latitude'] : "";
        $post['longitude']   = isset($postdata['longitude']) ? $postdata['longitude'] : "";
        $post['pickup_city']   = isset($postdata['pickup_city']) ? $postdata['pickup_city'] : "";
        if ($post['shipment_id'] != "" && $post['trip_id'] != "") {
            $post['status_code'] = '2300'; /*Delivery Shipment Dispatched*/
            $post['trackingnumber'] = $postdata['order_id'];
            $post['company_code'] = $post['branch_code'] = $post['shipment_id'] = $post['modeoftransport'] = "";
            $post['logicalreceiver'] = $post['physicalreceiver'] = $post['logicalsender'] = $post['physicalsender'] = "";
            $getordinfo = $ci->db->select("pickup_city, company_code, branch_code, shipmentid, logicalreceiver, physicalreceiver, physicalsender, logicalsender, modeoftransport")->get_where("tb_orders",array("order_id"=>$postdata['order_id']),1,0);
            if($getordinfo->num_rows()>0){
                $post['company_code'] = $getordinfo->row()->company_code;
                $post['branch_code'] = $getordinfo->row()->branch_code;
                $post['shipment_id'] = $getordinfo->row()->shipmentid;
                if($post['pickup_city'] == ""){
                    $post['pickup_city'] = $getordinfo->row()->pickup_city;
                }
                $post['logicalreceiver'] = $getordinfo->row()->logicalreceiver;
                $post['physicalreceiver'] = $getordinfo->row()->physicalreceiver;
                $post['logicalsender'] = $getordinfo->row()->logicalsender;
                $post['physicalsender'] = $getordinfo->row()->physicalsender;
                $post['modeoftransport'] = $getordinfo->row()->modeoftransport;
            }
            $post['createdon'] = $postdata['createdon'];
            $hrs = "Z";
            if(isset($postdata['hrs'])){
                $hrs = str_replace(".", ":", $postdata['hrs']);
            }
            if(isset($postdata['curtz'])){
                if(!isset($postdata['web'])){
                    $getactual = getdatetimebytimezone($postdata['curtz'],$post['createdon'],DFLT_TZ);
                    $post['createdon'] = $getactual['datetime'];
                    $post['date'] = $getactual['date'];
                    $post['time'] = $getactual['time']."".$hrs;
                }else{
                    $post['createdon'] = $postdata['web'];
                    $post['date'] = date('Y-m-d',strtotime($post['createdon']));
                    $post['time'] = date('H:i:s',strtotime($post['createdon']))."".$hrs;
                }
            }else{
                $post['date'] = date('Y-m-d');
                $post['time'] = date('H:i:s')."".$hrs;
            }
            $post['curdt'] = date('Y-m-d\TH:i:s', strtotime($post['createdon']))."".$hrs;
            $response = $this->roadlogsendorderstatus1($post);
            $post['status_code'] = '3000'; /*Delivered to Consignee*/
            $response = $this->roadlogsendorderstatus1($post);
            return true;
        } else {
            return false;
        }
    }

    /* xLog to Roadlog Status */
    public function roadlogshipmenttripdelivered1($postdata)
    {
        $ci = &get_instance();
        $post['shipment_id'] = $postdata['shipment_id'];
        $post['trip_id']     = $postdata['trip_id'];
        $post['stop_id']     = $postdata['stop_id'];
        $post['driver_id']   = $postdata['driver_id'];
        $post['latitude']   = isset($postdata['latitude']) ? $postdata['latitude'] : "";
        $post['longitude']   = isset($postdata['longitude']) ? $postdata['longitude'] : "";
        $post['pickup_city']   = isset($postdata['pickup_city']) ? $postdata['pickup_city'] : "";
        if ($post['shipment_id'] != "" && $post['trip_id'] != "") {
            $post['status_code'] = '0218'; /*Trip Ended*/
            $post['trackingnumber'] = $postdata['order_id'];
            $post['company_code'] = $post['branch_code'] = $post['shipment_id'] = $post['modeoftransport'] = "";
            $post['logicalreceiver'] = $post['physicalreceiver'] = $post['logicalsender'] = $post['physicalsender'] = "";
            $getordinfo = $ci->db->select("pickup_city, company_code, branch_code, shipmentid, logicalreceiver, physicalreceiver, physicalsender, logicalsender, modeoftransport")->get_where("tb_orders",array("order_id"=>$postdata['order_id']),1,0);
            if($getordinfo->num_rows()>0){
                $post['company_code'] = $getordinfo->row()->company_code;
                $post['branch_code'] = $getordinfo->row()->branch_code;
                $post['shipment_id'] = $getordinfo->row()->shipmentid;
                if($post['pickup_city'] == ""){
                    $post['pickup_city'] = $getordinfo->row()->pickup_city;
                }
                $post['logicalreceiver'] = $getordinfo->row()->logicalreceiver;
                $post['physicalreceiver'] = $getordinfo->row()->physicalreceiver;
                $post['logicalsender'] = $getordinfo->row()->logicalsender;
                $post['physicalsender'] = $getordinfo->row()->physicalsender;
                $post['modeoftransport'] = $getordinfo->row()->modeoftransport;
            }
            $post['createdon'] = $postdata['createdon'];
            $hrs = "Z";
            if(isset($postdata['hrs'])){
                $hrs = str_replace(".", ":", $postdata['hrs']);
            }
            if(isset($postdata['curtz'])){
                if(!isset($postdata['web'])){
                    $getactual = getdatetimebytimezone($postdata['curtz'],$post['createdon'],DFLT_TZ);
                    $post['createdon'] = $getactual['datetime'];
                    $post['date'] = $getactual['date'];
                    $post['time'] = $getactual['time']."".$hrs;
                }else{
                    $post['createdon'] = $postdata['web'];
                    $post['date'] = date('Y-m-d',strtotime($post['createdon']));
                    $post['time'] = date('H:i:s',strtotime($post['createdon']))."".$hrs;
                }
            }else{
                $post['date'] = date('Y-m-d');
                $post['time'] = date('H:i:s')."".$hrs;
            }
            $post['curdt'] = date('Y-m-d\TH:i:s', strtotime($post['createdon']))."".$hrs;
            $response = $this->roadlogsendorderstatus1($post);
            return true;
        } else {
            return false;
        }
    }

    /* xLog to Roadlog Status */
    public function roadlogorderpodstatus1($postdata)
    {
        $ci = &get_instance();
        $post['shipment_id'] = $postdata['shipment_id'];
        $post['trip_id']     = $postdata['trip_id'];
        $post['stop_id']     = $postdata['stop_id'];
        $post['driver_id']   = $postdata['driver_id'];
        $post['latitude']   = isset($postdata['latitude']) ? $postdata['latitude'] : "";
        $post['longitude']   = isset($postdata['longitude']) ? $postdata['longitude'] : "";
        $post['pickup_city']   = isset($postdata['pickup_city']) ? $postdata['pickup_city'] : "";
        if ($post['shipment_id'] != "" && $post['trip_id'] != "") {
            $post['status_code'] = '3060'; /*ePOD available*/
            $post['trackingnumber'] = $postdata['order_id'];
            $post['company_code'] = $post['branch_code'] = $post['shipment_id'] = $post['modeoftransport'] = "";
            $post['logicalreceiver'] = $post['physicalreceiver'] = $post['logicalsender'] = $post['physicalsender'] = "";
            $getordinfo = $ci->db->select("pickup_city, company_code, branch_code, shipmentid, logicalreceiver, physicalreceiver, physicalsender, logicalsender, modeoftransport")->get_where("tb_orders",array("order_id"=>$postdata['order_id']),1,0);
            if($getordinfo->num_rows()>0){
                $post['company_code'] = $getordinfo->row()->company_code;
                $post['branch_code'] = $getordinfo->row()->branch_code;
                $post['shipment_id'] = $getordinfo->row()->shipmentid;
                if($post['pickup_city'] == ""){
                    $post['pickup_city'] = $getordinfo->row()->pickup_city;
                }
                $post['logicalreceiver'] = $getordinfo->row()->logicalreceiver;
                $post['physicalreceiver'] = $getordinfo->row()->physicalreceiver;
                $post['logicalsender'] = $getordinfo->row()->logicalsender;
                $post['physicalsender'] = $getordinfo->row()->physicalsender;
                $post['modeoftransport'] = $getordinfo->row()->modeoftransport;
            }
            $post['createdon'] = $postdata['createdon'];
            $hrs = "Z";
            if(isset($postdata['hrs'])){
                $hrs = str_replace(".", ":", $postdata['hrs']);
            }
            if(isset($postdata['curtz'])){
                $getactual = getdatetimebytimezone($postdata['curtz'],$post['createdon'],DFLT_TZ);
                $post['createdon'] = $getactual['datetime'];
                $post['date'] = $getactual['date'];
                $post['time'] = $getactual['time']."".$hrs;
            }else{
                $post['date'] = date('Y-m-d');
                $post['time'] = date('H:i:s')."".$hrs;
            }
            $post['curdt'] = date('Y-m-d\TH:i:s', strtotime($post['createdon']))."".$hrs;
            if(isset($postdata['stop_type'])){
                if($postdata['stop_type'] == "P"){
                    $post['status_code'] = '2490'; /*Goods Loaded for Delivery*/
                    $response = $this->roadlogsendorderstatus1($post);
                }
            }
            $post['status_code'] = '3060';
            $response = $this->roadlogsendorderstatus1($post);
            return true;
        } else {
            return false;
        }
    }

    /* xLog to Roadlog Status */
    public function roadlogshipmentreject1($postdata)
    {
        $ci = &get_instance();
        $post['shipment_id'] = $postdata['shipment_id'];
        $post['trip_id']     = $postdata['trip_id'];
        $post['stop_id']     = $postdata['stop_id'];
        $post['driver_id']   = $postdata['driver_id'];
        $post['latitude']   = isset($postdata['latitude']) ? $postdata['latitude'] : "";
        $post['longitude']   = isset($postdata['longitude']) ? $postdata['longitude'] : "";
        $post['pickup_city']   = isset($postdata['pickup_city']) ? $postdata['pickup_city'] : "";
        if ($post['shipment_id'] != "" && $post['trip_id'] != "") {
            $post['status_code'] = '0213'; /*Load Rejected by Driver*/
            $post['trackingnumber'] = $postdata['order_id'];
            $post['company_code'] = $post['branch_code'] = $post['shipment_id'] = $post['modeoftransport'] = "";
            $post['logicalreceiver'] = $post['physicalreceiver'] = $post['logicalsender'] = $post['physicalsender'] = "";
            $getordinfo = $ci->db->select("pickup_city, company_code, branch_code, shipmentid, logicalreceiver, physicalreceiver, physicalsender, logicalsender, modeoftransport")->get_where("tb_orders",array("order_id"=>$postdata['order_id']),1,0);
            if($getordinfo->num_rows()>0){
                $post['company_code'] = $getordinfo->row()->company_code;
                $post['branch_code'] = $getordinfo->row()->branch_code;
                $post['shipment_id'] = $getordinfo->row()->shipmentid;
                if($post['pickup_city'] == ""){
                    $post['pickup_city'] = $getordinfo->row()->pickup_city;
                }
                $post['logicalreceiver'] = $getordinfo->row()->logicalreceiver;
                $post['physicalreceiver'] = $getordinfo->row()->physicalreceiver;
                $post['logicalsender'] = $getordinfo->row()->logicalsender;
                $post['physicalsender'] = $getordinfo->row()->physicalsender;
                $post['modeoftransport'] = $getordinfo->row()->modeoftransport;
            }
            $post['createdon'] = $postdata['createdon'];
            $hrs = "Z";
            if(isset($postdata['hrs'])){
                $hrs = str_replace(".", ":", $postdata['hrs']);
            }
            if(isset($postdata['curtz'])){
                $getactual = getdatetimebytimezone($postdata['curtz'],$post['createdon'],DFLT_TZ);
                $post['createdon'] = $getactual['datetime'];
                $post['date'] = $getactual['date'];
                $post['time'] = $getactual['time']."".$hrs;
            }else{
                $post['date'] = date('Y-m-d');
                $post['time'] = date('H:i:s')."".$hrs;
            }
            $post['curdt'] = date('Y-m-d\TH:i:s.u', strtotime($post['createdon']))."".$hrs;
            $response = $this->roadlogsendorderstatus1($post);
            return true;
        } else {
            return false;
        }
    }

    /* xLog to Roadlog Status */
    public function roadlogshipmentabort1($postdata)
    {
        $ci = &get_instance();
        $post['shipment_id'] = $postdata['shipment_id'];
        $post['trip_id']     = $postdata['trip_id'];
        $post['stop_id']     = $postdata['stop_id'];
        $post['driver_id']   = $postdata['driver_id'];
        $post['latitude']   = isset($postdata['latitude']) ? $postdata['latitude'] : "";
        $post['longitude']   = isset($postdata['longitude']) ? $postdata['longitude'] : "";
        $post['pickup_city']   = isset($postdata['pickup_city']) ? $postdata['pickup_city'] : "";
        if ($post['shipment_id'] != "" && $post['trip_id'] != "") {
            $post['status_code'] = '0217'; /*Load Rejected by Driver*/
            $post['trackingnumber'] = $postdata['order_id'];
            $post['company_code'] = $post['branch_code'] = $post['shipment_id'] = $post['modeoftransport'] = "";
            $post['logicalreceiver'] = $post['physicalreceiver'] = $post['logicalsender'] = $post['physicalsender'] = "";
            $getordinfo = $ci->db->select("pickup_city, company_code, branch_code, shipmentid, logicalreceiver, physicalreceiver, physicalsender, logicalsender, modeoftransport")->get_where("tb_orders",array("order_id"=>$postdata['order_id']),1,0);
            if($getordinfo->num_rows()>0){
                $post['company_code'] = $getordinfo->row()->company_code;
                $post['branch_code'] = $getordinfo->row()->branch_code;
                $post['shipment_id'] = $getordinfo->row()->shipmentid;
                if($post['pickup_city'] == ""){
                    $post['pickup_city'] = $getordinfo->row()->pickup_city;
                }
                $post['logicalreceiver'] = $getordinfo->row()->logicalreceiver;
                $post['physicalreceiver'] = $getordinfo->row()->physicalreceiver;
                $post['logicalsender'] = $getordinfo->row()->logicalsender;
                $post['physicalsender'] = $getordinfo->row()->physicalsender;
                $post['modeoftransport'] = $getordinfo->row()->modeoftransport;
            }
            $post['createdon'] = $postdata['createdon'];
            $hrs = "Z";
            if(isset($postdata['hrs'])){
                $hrs = str_replace(".", ":", $postdata['hrs']);
            }
            if(isset($postdata['curtz'])){
                $getactual = getdatetimebytimezone($postdata['curtz'],$post['createdon'],DFLT_TZ);
                $post['createdon'] = $getactual['datetime'];
                $post['date'] = $getactual['date'];
                $post['time'] = $getactual['time']."".$hrs;
            }else{
                $post['date'] = date('Y-m-d');
                $post['time'] = date('H:i:s')."".$hrs;
            }
            $post['curdt'] = date('Y-m-d\TH:i:s.u', strtotime($post['createdon']))."".$hrs;
            $response = $this->roadlogsendorderstatus1($post);
            return true;
        } else {
            return false;
        }
    }

    /* xLog to Roadlog Status */
    public function roadlogorderrealesestatus1($postdata)
    {
        $ci = &get_instance();
        $post['shipment_id'] = $postdata['shipment_id'];
        $post['trip_id']     = $postdata['trip_id'];
        $post['stop_id']     = $postdata['stop_id'];
        $post['driver_id']   = $postdata['driver_id'];
        $post['latitude']   = isset($postdata['latitude']) ? $postdata['latitude'] : "";
        $post['longitude']   = isset($postdata['longitude']) ? $postdata['longitude'] : "";
        $post['pickup_city']   = isset($postdata['pickup_city']) ? $postdata['pickup_city'] : "";
        if ($post['shipment_id'] != "" && $post['trip_id'] != "") {
            $post['status_code'] = '3002';/*'2420';*/ /*Partial Delivery Requested*/
            $post['trackingnumber'] = $postdata['order_id'];
            $post['company_code'] = $post['branch_code'] = $post['shipment_id'] = $post['modeoftransport'] = "";
            $post['logicalreceiver'] = $post['physicalreceiver'] = $post['logicalsender'] = $post['physicalsender'] = "";
            $getordinfo = $ci->db->select("pickup_city, company_code, branch_code, shipmentid, logicalreceiver, physicalreceiver, physicalsender, logicalsender, modeoftransport")->get_where("tb_orders",array("order_id"=>$postdata['order_id']),1,0);
            if($getordinfo->num_rows()>0){
                $post['company_code'] = $getordinfo->row()->company_code;
                $post['branch_code'] = $getordinfo->row()->branch_code;
                $post['shipment_id'] = $getordinfo->row()->shipmentid;
                if($post['pickup_city'] == ""){
                    $post['pickup_city'] = $getordinfo->row()->pickup_city;
                }
                $post['logicalreceiver'] = $getordinfo->row()->logicalreceiver;
                $post['physicalreceiver'] = $getordinfo->row()->physicalreceiver;
                $post['logicalsender'] = $getordinfo->row()->logicalsender;
                $post['physicalsender'] = $getordinfo->row()->physicalsender;
                $post['modeoftransport'] = $getordinfo->row()->modeoftransport;
            }
            $post['createdon'] = $postdata['createdon'];
            $hrs = "Z";
            if(isset($postdata['hrs'])){
                $hrs = str_replace(".", ":", $postdata['hrs']);
            }
            if(isset($postdata['curtz'])){
                $getactual = getdatetimebytimezone1($postdata['curtz'],$post['createdon'],DFLT_TZ);
                $post['createdon'] = $getactual['datetime'];
                $post['date'] = $getactual['date'];
                $post['time'] = $getactual['time']."".$hrs;
            }else{
                $post['date'] = date('Y-m-d');
                $post['time'] = date('H:i:s')."".$hrs;
            }
            $post['curdt'] = date('Y-m-d\TH:i:s.u', strtotime($post['createdon']))."".$hrs;
            $response = $this->roadlogsendordreleasestatus1($post);
            return true;
        } else {
            return false;
        }
    }

    /* xLog to Roadlog Status */
    public function roadlogshipmentcollected1($postdata)
    {
        /* Shipment Collect from Dealer / Supplier */
        $ci = &get_instance();
        $post['shipment_id'] = $postdata['shipment_id'];
        $post['trip_id']     = $postdata['trip_id'];
        $post['stop_id']     = $postdata['stop_id'];
        $post['driver_id']   = $postdata['driver_id'];
        $post['latitude']   = isset($postdata['latitude']) ? $postdata['latitude'] : "";
        $post['longitude']   = isset($postdata['longitude']) ? $postdata['longitude'] : "";
        $post['pickup_city']   = isset($postdata['pickup_city']) ? $postdata['pickup_city'] : "";
        if ($post['shipment_id'] != "" && $post['trip_id'] != "") {
            $post['status_code'] = '0470'; /*Collection Order Confirmed*/
            $post['trackingnumber'] = $postdata['order_id'];
            $post['company_code'] = $post['branch_code'] = $post['shipment_id'] = $post['modeoftransport'] = "";
            $post['logicalreceiver'] = $post['physicalreceiver'] = $post['logicalsender'] = $post['physicalsender'] = "";
            $getordinfo = $ci->db->select("pickup_city, company_code, branch_code, shipmentid, logicalreceiver, physicalreceiver, physicalsender, logicalsender, modeoftransport")->get_where("tb_orders",array("order_id"=>$postdata['order_id']),1,0);
            if($getordinfo->num_rows()>0){
                $post['company_code'] = $getordinfo->row()->company_code;
                $post['branch_code'] = $getordinfo->row()->branch_code;
                $post['shipment_id'] = $getordinfo->row()->shipmentid;
                if($post['pickup_city'] == ""){
                    $post['pickup_city'] = $getordinfo->row()->pickup_city;
                }
                $post['logicalreceiver'] = $getordinfo->row()->logicalreceiver;
                $post['physicalreceiver'] = $getordinfo->row()->physicalreceiver;
                $post['logicalsender'] = $getordinfo->row()->logicalsender;
                $post['physicalsender'] = $getordinfo->row()->physicalsender;
                $post['modeoftransport'] = $getordinfo->row()->modeoftransport;
            }
            $post['createdon'] = $postdata['createdon'];
            $hrs = "Z";
            if(isset($postdata['hrs'])){
                $hrs = str_replace(".", ":", $postdata['hrs']);
            }
            if(isset($postdata['curtz'])){
                $getactual = getdatetimebytimezone($postdata['curtz'],$post['createdon'],DFLT_TZ);
                $post['createdon'] = $getactual['datetime'];
                $post['date'] = $getactual['date'];
                $post['time'] = $getactual['time']."".$hrs;
            }else{
                $post['date'] = date('Y-m-d');
                $post['time'] = date('H:i:s')."".$hrs;
            }
            $post['curdt'] = date('Y-m-d\TH:i:s.u', strtotime($post['createdon']))."".$hrs;
            $response = $this->roadlogsendorderstatus1($post);
            return true;
        } else {
            return false;
        }
    }
    /* xLog to Roadlog Status */
    public function roadlogshipnotcollected1($postdata)
    {
        /* Shipment Collect from Dealer / Supplier */
        $ci = &get_instance();
        $post['shipment_id'] = $postdata['shipment_id'];
        $post['trip_id']     = $postdata['trip_id'];
        $post['stop_id']     = $postdata['stop_id'];
        $post['driver_id']   = $postdata['driver_id'];
        $post['latitude']   = isset($postdata['latitude']) ? $postdata['latitude'] : "";
        $post['longitude']   = isset($postdata['longitude']) ? $postdata['longitude'] : "";
        $post['pickup_city']   = isset($postdata['pickup_city']) ? $postdata['pickup_city'] : "";
        if ($post['shipment_id'] != "" && $post['trip_id'] != "") {
            $post['status_code'] = '0520'; /*Shipment Not Collected*/
            $post['trackingnumber'] = $postdata['order_id'];
            $post['company_code'] = $post['branch_code'] = $post['shipment_id'] = $post['modeoftransport'] = "";
            $post['logicalreceiver'] = $post['physicalreceiver'] = $post['logicalsender'] = $post['physicalsender'] = "";
            $getordinfo = $ci->db->select("pickup_city, company_code, branch_code, shipmentid, logicalreceiver, physicalreceiver, physicalsender, logicalsender, modeoftransport")->get_where("tb_orders",array("order_id"=>$postdata['order_id']),1,0);
            if($getordinfo->num_rows()>0){
                $post['company_code'] = $getordinfo->row()->company_code;
                $post['branch_code'] = $getordinfo->row()->branch_code;
                $post['shipment_id'] = $getordinfo->row()->shipmentid;
                if($post['pickup_city'] == ""){
                    $post['pickup_city'] = $getordinfo->row()->pickup_city;
                }
                $post['logicalreceiver'] = $getordinfo->row()->logicalreceiver;
                $post['physicalreceiver'] = $getordinfo->row()->physicalreceiver;
                $post['logicalsender'] = $getordinfo->row()->logicalsender;
                $post['physicalsender'] = $getordinfo->row()->physicalsender;
                $post['modeoftransport'] = $getordinfo->row()->modeoftransport;
            }
            $post['createdon'] = $postdata['createdon'];
            $hrs = "Z";
            if(isset($postdata['hrs'])){
                $hrs = str_replace(".", ":", $postdata['hrs']);
            }
            if(isset($postdata['curtz'])){
                $getactual = getdatetimebytimezone($postdata['curtz'],$post['createdon'],DFLT_TZ);
                $post['createdon'] = $getactual['datetime'];
                $post['date'] = $getactual['date'];
                $post['time'] = $getactual['time']."".$hrs;
            }else{
                $post['date'] = date('Y-m-d');
                $post['time'] = date('H:i:s')."".$hrs;
            }
            $post['curdt'] = date('Y-m-d\TH:i:s.u', strtotime($post['createdon']))."".$hrs;
            $response = $this->roadlogsendorderstatus1($post);
            return true;
        } else {
            return false;
        }
    }

    /* xLog to Roadlog Status */
    public function roadlogshipbookedbysupplier1($postdata)
    {
        /* Shipment Booked By Supplier */
        $ci = &get_instance();
        $post['shipment_id'] = $postdata['shipment_id'];
        $post['latitude'] = isset($postdata['latitude']) ? $postdata['latitude'] : "";
        $post['longitude'] = isset($postdata['longitude']) ? $postdata['longitude'] : "";
        if ($post['shipment_id'] != "" && $postdata['order_id'] != "") {
            $post['status_code'] = '0100'; /*Shipment Booked By Supplier*/
            $post['trackingnumber'] = $postdata['order_id'];
            $post['company_code'] = $postdata['company_code'];
            $post['branch_code'] = $postdata['branch_code'];
            $post['shipment_id'] = $postdata['shipmentid'];
            $post['modeoftransport'] = $postdata['modeoftransport'];
            $post['pickup_city'] = $postdata['pickup_city'];
            $post['logicalreceiver'] = $postdata['lreceiver'];
            $post['physicalreceiver'] = $postdata['preceiver'];
            $post['logicalsender'] = $postdata['lsender'];
            $post['physicalsender'] = $postdata['psender'];
            $post['createdon'] = $postdata['createdon'];
            $hrs = "Z";
            if(isset($postdata['hrs'])){
                $hrs = str_replace(".", ":", $postdata['hrs']);
            }
            if(isset($postdata['curtz'])){
                $getactual = getdatetimebytimezone($postdata['curtz'],$post['createdon'],DFLT_TZ);
                $post['createdon'] = $getactual['datetime'];
                $post['date'] = $getactual['date'];
                $post['time'] = $getactual['time']."".$hrs;
            }else{
                $post['date'] = date('Y-m-d');
                $post['time'] = date('H:i:s')."".$hrs;
            }
            $post['curdt'] = date('Y-m-d\TH:i:s.u', strtotime($post['createdon']))."".$hrs;
            $response = $this->roadlogsendorderstatus1($post);
            return true;
        } else {
            return false;
        }
    }

    /* xLog to Roadlog Status */
    public function roadlogshipplandeliverdate1($postdata)
    {
        /* Shipment Planned Delivery Date */
        $ci = &get_instance();
        $post['shipment_id'] = $postdata['shipment_id'];
        $post['latitude'] = isset($postdata['latitude']) ? $postdata['latitude'] : "";
        $post['longitude'] = isset($postdata['longitude']) ? $postdata['longitude'] : "";
        if ($post['shipment_id'] != "" && $postdata['order_id'] != "") {
            $post['status_code'] = '2400'; /*Shipment Planned Delivery Date*/
            $post['trackingnumber'] = $postdata['order_id'];
            $post['company_code'] = $postdata['company_code'];
            $post['branch_code'] = $postdata['branch_code'];
            $post['shipment_id'] = $postdata['shipmentid'];
            $post['modeoftransport'] = $postdata['modeoftransport'];
            $post['pickup_city'] = $postdata['pickup_city'];
            $post['logicalreceiver'] = $postdata['lreceiver'];
            $post['physicalreceiver'] = $postdata['preceiver'];
            $post['logicalsender'] = $postdata['lsender'];
            $post['physicalsender'] = $postdata['psender'];
            $post['createdon'] = $postdata['createdon'];
            $hrs = "Z";
            if(isset($postdata['hrs'])){
                $hrs = str_replace(".", ":", $postdata['hrs']);
            }
            if(isset($postdata['curtz'])){
                $getactual = getdatetimebytimezone($postdata['curtz'],$post['createdon'],DFLT_TZ);
                $post['createdon'] = $getactual['datetime'];
                $post['date'] = $getactual['date'];
                $post['time'] = $getactual['time']."".$hrs;
            }else{
                $post['date'] = date('Y-m-d');
                $post['time'] = date('H:i:s')."".$hrs;
            }
            $post['curdt'] = date('Y-m-d\TH:i:s.u', strtotime($post['createdon']))."".$hrs;
            $response = $this->roadlogsendorderstatus1($post);
            return true;
        } else {
            return false;
        }
    }

    /* xLog to Roadlog Status */
    public function roadlogcustomsdocstatus1($postdata)
    {
        $ci = &get_instance();
        $post['shipment_id'] = $postdata['shipment_id'];
        $post['trip_id'] = $postdata['trip_id'];
        $post['latitude'] = isset($postdata['latitude']) ? $postdata['latitude'] : "";
        $post['longitude'] = isset($postdata['longitude']) ? $postdata['longitude'] : "";
        if ($post['shipment_id'] != "" && $post['trip_id'] != "") {
            $post['status_code'] = '1600'; /*Customs Cleareance Completed at Bor*/
            $post['trackingnumber'] = $postdata['order_id'];
            $post['company_code'] = $post['branch_code'] = $post['shipment_id'] = $post['modeoftransport'] = $post['pickup_city'] = "";
            $post['logicalreceiver'] = $post['physicalreceiver'] = $post['logicalsender'] = $post['physicalsender'] = "";
            $getordinfo = $ci->db->select("pickup_city, company_code, branch_code, shipmentid, logicalreceiver, physicalreceiver, physicalsender, logicalsender, modeoftransport")->get_where("tb_orders",array("order_id"=>$postdata['order_id']),1,0);
            if($getordinfo->num_rows()>0){
                $post['company_code'] = $getordinfo->row()->company_code;
                $post['branch_code'] = $getordinfo->row()->branch_code;
                $post['shipment_id'] = $getordinfo->row()->shipmentid;
                if($post['pickup_city'] == ""){
                    $post['pickup_city'] = $getordinfo->row()->pickup_city;
                }
                $post['logicalreceiver'] = $getordinfo->row()->logicalreceiver;
                $post['physicalreceiver'] = $getordinfo->row()->physicalreceiver;
                $post['logicalsender'] = $getordinfo->row()->logicalsender;
                $post['physicalsender'] = $getordinfo->row()->physicalsender;
                $post['modeoftransport'] = $getordinfo->row()->modeoftransport;
            }
            $post['createdon'] = $postdata['createdon'];
            $hrs = "Z";
            if(isset($postdata['hrs'])){
                $hrs = str_replace(".", ":", $postdata['hrs']);
            }
            if(isset($postdata['curtz'])){
                $getactual = getdatetimebytimezone($postdata['curtz'],$post['createdon'],DFLT_TZ);
                $post['createdon'] = $getactual['datetime'];
                $post['date'] = $getactual['date'];
                $post['time'] = $getactual['time']."".$hrs;
            }else{
                $post['date'] = date('Y-m-d');
                $post['time'] = date('H:i:s')."".$hrs;
            }
            $post['curdt'] = date('Y-m-d\TH:i:s.u', strtotime($post['createdon']))."".$hrs;
            $response = $this->roadlogsendorderstatus1($post);
            return true;
        } else {
            return false;
        }
    }

    public function roadlogsendorderstatus1($post)
    {
        $request = '';
        $request .= '<?xml version="1.0" encoding="UTF-8"?>';
        $request .= '<roadstatus:RoadStatus xmlns:roadstatus="http://knie4.int.kn/msg/roadstatus/0100" xmlns:date="http://exslt.org/dates-and-times" xmlns:ext="http://exslt.org/common" xmlns:lrcc="http://knie4.int.kn/msg/roadcarriercost/0100" xmlns:lsts="http://knie4.int.kn/com/lsts/0200" xmlns:lpaci="http://knie4.int.kn/com/lpaci/0200" xmlns:lref="http://knie4.int.kn/com/lref/0100" xmlns:DateUtil="com.surikat.mobility.common.util.DateUtil" xmlns:lhdr="http://knie4.int.kn/com/lhdr/0200" xmlns:lmlv="http://knie4.int.kn/com/lmlv/0200" xmlns:ltru="http://knie4.int.kn/com/ltru/0200" xmlns:ltypes="http://knie4.int.kn/com/ltypes/0200">';
        $request .= '<lhdr:MessageHeader>';
        $request .= '<ReceiverDetails ltypes:AddressType="FW">';
        $request .= '<PhysicalReceiver>'.$post['physicalreceiver'].'</PhysicalReceiver>';
        $request .= '<LogicalReceiver>'.$post['logicalreceiver'].'</LogicalReceiver>';
        $request .= '</ReceiverDetails>';
        $request .= '<PhysicalSender>'.$post['physicalsender'].'</PhysicalSender>';
        $request .= '<LogicalSender>'.$post['logicalsender'].'</LogicalSender>';
        $request .= '<SendingApplication>xLOG</SendingApplication>';
        $request .= '<MessageType>RoadStatus</MessageType>';
        $request .= '<VersionNumber>0100</VersionNumber>';
        $request .= '<CreationDateTime>'.$post['curdt'].'</CreationDateTime>';
        $request .= '</lhdr:MessageHeader>';
        $request .= '<Message>';
        $request .= '<lmlv:MessageLevel>';
        $request .= '<TrackingNumber>'.$post['trackingnumber'].'</TrackingNumber>';
        $request .= '<SenderInformation>';
        $request .= '<CompanyCode>'.$post['company_code'].'</CompanyCode>';
        $request .= '<BranchCode>'.$post['branch_code'].'</BranchCode>';
        $request .= '<ModeOfTransport>'.$post['modeoftransport'].'</ModeOfTransport>';
        $request .= '</SenderInformation>';
        $request .= '<MessageNumber>'.$post['shipment_id'].'</MessageNumber>';
        $request .= '<MessageReferences ltypes:AddressType="FF">';
        $request .= '<Code>INN</Code>';
        $request .= '<Value>RL'.$post['trackingnumber'].'</Value>';
        $request .= '</MessageReferences>';
        $request .= '</lmlv:MessageLevel>';
        $request .= '<lsts:StatusInformation ltypes:StatusCode="'.$post['status_code'].'">';
        $request .= '<StatusDate>'.$post['date'].'</StatusDate>';
        $request .= '<StatusTime>'.$post['time'].'</StatusTime>';
        $request .= '<StatusLocation ltypes:LocationIssuer="ZZZ">'.$post['pickup_city'].'</StatusLocation>';
        $request .= '<AdditionalStatusInformation>';
        $request .= '<CreationIdentifier>X</CreationIdentifier>';
        $request .= '<StatusEntryDateTime>'.$post['curdt'].'</StatusEntryDateTime>';
        $request .= '<UserIdentifier>af485ee2-85f3-4c28-8fe7-4f7e540a298e</UserIdentifier>';
        $request .= '</AdditionalStatusInformation>';
        $request .= '<AdditionalRoadStatusInformation>';
        $request .= '<Latitude>'.$post['latitude'].'</Latitude>';
        $request .= '<Longitude>'.$post['longitude'].'</Longitude>';
        $request .= '</AdditionalRoadStatusInformation>';
        $request .= '</lsts:StatusInformation>';
        $request .= '<Shipment/>';
        $request .= '</Message>';
        $request .= '</roadstatus:RoadStatus>';
        log_message('error', "roadlogrequestxml " . json_encode($post));
        $dom = new DOMDocument;
        $dom->preserveWhiteSpace = false;
        $dom->loadXML($request);
        $dom->save('xml/xLog.xml');
        $serviceurl = ROADLOG_URL;
        $username = ROADLOG_USRNAME;
        $password = ROADLOG_PWD;
        $headers = array(
            'Content-Type: application/xml',
            'Authorization: Basic '. base64_encode("$username:$password")
        );
        $output = thirdpartyservicecurl($serviceurl,$headers,$request);
        $response = array();
        log_message('error', "roadlogresponsexml " . $output);
        /*$ins = $this->roadlogsaveIntigrateRequest($post, json_encode($response));*/
        $responsedata = $this->roadlogsendordreleasestatus1($response);
        return $responsedata;
    }

    public function roadlogsendordreleasestatus1($post)
    {
        $responsedata = true;
        return $responsedata;
    }

    public function roadlogsaveIntigrateRequest($request = '', $response = '')
    {
        $ci = &get_instance();
        if ($request != '' && $response != '') {
            $tb_intigration_requests = array(
                "domain_name"        => isset($request["domain_name"]) ? $request["domain_name"] : null,
                "shipment_id"        => isset($request["shipment_id"]) ? $request["shipment_id"] : null,
                "trip_id"            => isset($request["trip_id"]) ? $request["trip_id"] : null,
                "stop_id"            => isset($request["stop_id"]) ? $request["stop_id"] : null,
                "driver_id"          => isset($request["driver_id"]) ? $request["driver_id"] : null,
                "order_id"           => isset($request["order_id"]) ? $request["order_id"] : null,
                "source_id"          => isset($request["source_id"]) ? $request["source_id"] : null,
                "source_reason_code" => isset($request["source_reason_code"]) ? $request["source_reason_code"] : null,
                "carrier"            => isset($request["carrier"]) ? $request["carrier"] : null,
                "kn_adminid"         => isset($request["kn_adminid"]) ? $request["kn_adminid"] : null,
                "txn_id"             => isset($request["txn_id"]) ? $request["txn_id"] : null,
                "txn_code"           => isset($request["txn_code"]) ? $request["txn_code"] : null,
                "remark"             => isset($request["remark"]) ? $request["remark"] : null,
                "reporttype"         => isset($request["reporttype"]) ? $request["reporttype"] : null,
                "reportpod"          => isset($request["reportpod"]) ? $request["reportpod"] : null,
                "ord_release"        => isset($request["ord_release"]) ? $request["ord_release"] : null,
                "response"           => isset($request["response"]) ? $request["response"] : null,
                "company_code"       => isset($request["company_code"]) ? $request["company_code"] : null,
                "branch_code"        => isset($request["branch_code"]) ? $request["branch_code"] : null,
                "status"             => 1,
                "createdon"          => isset($request["createdon"]) ? $request["createdon"] : null,
                "updatedon"          => isset($request["createdon"]) ? $request["createdon"] : null,
            );
            $ins = $ci->db->insert("tb_intigration_requests", $tb_intigration_requests);
        }
    }
}
