<?php
class UpdateTripOrderCloseStatus
{
	public int $tripId;
	public int $shipmentId;
	public int $orderId;
	public int $vehicleId;
	public int $userId;
	public int $driverId;
	public string $companyCode;
	public string $branchCode;
	public string $dateTime;

	private const  CLOSE_STATUS_ID = '11';
	private const  CLOSE_STOP_TYPE = 'D';
	private const  ROADLOG_ORDER_SOURCE = 18;
	private const  KNLOGIN_ORDER_SOURCE = 11;
	private const  MACADAM_ORDER_SOURCE = 12;

	public function __construct() {
		$this->CI = &get_instance();
		$this->dateTime = date('Y-m-d H:i:s');
		$this->CI->load->model(['Common','Completedordersmodel','TripOrderCloseModel']);
		$this->CI->load->library(['shippeostatusintigration','statusintigration','knlogin','macdamstatusintigration']);
	}
	
	public function triggerShipmentClose(): int {
		$checkOrderType = (int) $this->getOrderType();
		log_message("error", "Trip Order Close => Trip ID:{$this->tripId}, Shipment ID: {$this->shipmentId}, Order ID: {$this->orderId}, Driver ID: {$this->driverId}, Vehicle ID: {$this->vehicleId}");
		$getOrderInfo = $this->CI->Common->gettblrowdata(["id"=>$this->orderId], "company_code, branch_code, user_id", "tb_orders", 1, 0);
		$this->companyCode 	= $getOrderInfo['company_code'];
		$this->branchCode 	= $getOrderInfo['branch_code'];
		$this->userId 		= $getOrderInfo['user_id'];
		if ( $checkOrderType === 0 ) {
			return $this->closeNormalOrder();
		} else if ( $checkOrderType === 1 ) {
			return $this->closeXBRDROrder();
		}
		log_message("error", "Trip Order Close => Invalid Shipment");
		return 0;
	}

	private function closeXBRDROrder() : int {
		$tripStatusCheck = 0;
		$shiftIds = [];
		$whereCondition = "id='".$this->shipmentId."' AND shift_leg_id > 0";
		$checkShiftLegs = $this->CI->Common->gettblrowdata($whereCondition, "shift_leg_id", "tb_shifts", 0, 0);
		if (!empty($checkShiftLegs)) {
			$getOrderDetails = $this->CI->Completedordersmodel->getOrderDetailsWithLatLngs($this->orderId);
			$createdsource 	= $getOrderDetails ? (int) $getOrderDetails['createdSource'] : 0;
			$latitude 		= $getOrderDetails['dlat'];
			$longitude 		= $getOrderDetails['dlng'];
			$currentTimeZone = DFLT_TZ;
			$currentTimezoneHours = "Z";
			$userInfo = $this->CI->Common->gettblrowdata(['company_code' => $this->companyCode],'country_code','tb_users',0,0);
			if ( !empty($userInfo) ) {
				$countryInfo = $this->CI->Common->gettblrowdata(['country_code' => $userInfo['country_code']],'cntry_timezone,cntry_hrs','tbl_country_master',0,0);
				if ( !empty($countryInfo) ) {
					$currentTimeZone = $countryInfo['cntry_timezone'];
					$currentTimezoneHours = $countryInfo['cntry_hrs'];
				}
			}

			$postData = array(
				"shipment_id" 	=> $this->shipmentId,
				"trip_id"     	=> $this->tripId,
				"driver_id"   	=> $this->driverId,
				"stop_id"     	=> '',
				"order_id"    	=> $this->orderId,
				"latitude"    	=> $latitude,
				"longitude"   	=> $longitude,
				"curtz"   		=> $currentTimeZone,
				"hrs" 			=> $currentTimezoneHours,
				"web"  			=> $this->dateTime
			);
			$shiftLegId = $checkShiftLegs['shift_leg_id'];
			$getAllLegIds = $this->CI->Common->gettbldata(['shift_leg_id'=>$shiftLegId,'status'=>'1'],"id","tb_shifts",0,0);
			$getDriversData = $this->CI->TripOrderCloseModel->getDriverInfo($this->driverId);
			if (count($getAllLegIds) > 1) {
				foreach ($getAllLegIds as $eachLegId) {
					$shiftIds[] = $eachLegId['id'];
				}
				$updateShifts = $this->CI->Common->updatetbledata("tb_shifts", ['status' => '0', 'updated_on' => $this->dateTime], ['id' => $this->shipmentId]);
				$updateTrips = $this->CI->Common->updatetbledata("tb_trips", ['end_imei' => $getDriversData['contact_num'], 'end_reading' => '0', 'etime' => $this->dateTime, 'updated_on' => $this->dateTime, 'status' => '0', 'transit_status' => '1'], ['id' => $this->tripId]);
				$checkPendingLegIds = $this->CI->Common->gettblrowdata("id IN (".implode(",",$shiftIds).") AND status ='1'","id","tb_shifts",0,0);
				if (empty($checkPendingLegIds)) {
					$updateShifts = $this->CI->Common->updatetbledata("tb_shifts", ['status'=>'0'], ['id'=>$shiftLegId,'status'=>'1']);
					$tripStatusCheck = 1;
				}
			} else {
				$shiftIds = [$shiftLegId,$this->shipmentId];
				$updateShifts = $this->CI->Common->updatetbledata("tb_shifts", ['status'=>'0'], "id IN (".implode(",",$shiftIds).") AND status ='1'");
				$updateTrips = $this->CI->Common->updatetbledata("tb_trips", ['end_imei'=>$getDriversData['contact_num'],'end_reading'=>'0','etime'=>$this->dateTime,'updated_on'=>$this->dateTime,'status'=>'0','transit_status'=>'1'], ['id'=>$this->tripId]);
				$tripStatusCheck = 1;

			}
			if (!in_array('0', [$tripStatusCheck, $shiftLegId])) {
				$updateOrder = $this->CI->Common->updatetbledata("tb_orders", ['trip_sts'=>'1'], ['shift_id'=>$shiftLegId]);
			}
			$this->finalClosure($createdsource, $postData);
			return 1;
		}
			return 0;
	}

	private function closeNormalOrder() : int {
		$checkForMultipleOrders = $this->CI->Common->gettblrowdata(["shift_id"=>$this->shipmentId,"trip_sts"=>"0"], "COUNT(id) AS pending_shipments", "tb_orders", 1, 0);
		if ( !empty($checkForMultipleOrders) && $checkForMultipleOrders['pending_shipments'] > 0) {
			$currentTimeZone = DFLT_TZ;
			$currentTimezoneHours = "Z";
			$userInfo = $this->CI->Common->gettblrowdata(['company_code' => $this->companyCode],'country_code','tb_users',0,0);
			if ( !empty($userInfo) ) {
				$countryInfo = $this->CI->Common->gettblrowdata(['country_code' => $userInfo['country_code']],'cntry_timezone,cntry_hrs','tbl_country_master',0,0);
				if ( !empty($countryInfo) ) {
					$currentTimeZone = $countryInfo['cntry_timezone'];
					$currentTimezoneHours = $countryInfo['cntry_hrs'];
				}
			}
			$getOrderDetails = $this->CI->Completedordersmodel->getOrderDetailsWithLatLngs($this->orderId);
			$createdsource = $getOrderDetails ? (int) $getOrderDetails['createdSource'] : 0;
			$latitude = $getOrderDetails['dlat'];
			$longitude = $getOrderDetails['dlng'];
			$postData = array(
				"shipment_id" 	=> $this->shipmentId,
				"trip_id"     	=> $this->tripId,
				"driver_id"   	=> $this->driverId,
				"stop_id"     	=> '',
				"order_id"    	=> $this->orderId,
				"latitude"    	=> $latitude,
				"longitude"   	=> $longitude,
				"curtz"   		=> $currentTimeZone,
				"hrs" 			=> $currentTimezoneHours,
				"web"  			=> $this->dateTime
			);

			if ( (int) $checkForMultipleOrders['pending_shipments'] > 1) {
				$update = $this->CI->Common->updatetbledata("tb_orders", ["trip_sts"=>'1'], ["id"=>$this->orderId,"trip_id !="=>"0"]);
			} else if ( (int) $checkForMultipleOrders['pending_shipments'] === 1 ) {
				$update = $this->CI->Common->updatetbledata("tb_shifts", ["status" => "0", "updated_on" => $this->dateTime], ["id" => $this->shipmentId]);
				$updateTripData = [
					"end_imei" => '',
					"end_reading" => '0',
					"etime" => $this->dateTime,
					"updated_on" => $this->dateTime,
					"status" => '0',
					"transit_status" => '1'
				];
				$update = $this->CI->Common->updatetbledata("tb_trips", $updateTripData, ["id"=>$this->tripId]);
				if ( $this->shipmentId > 0) {
					$update = $this->CI->Common->updatetbledata("tb_orders", ["trip_sts" => '1'], ["shift_id" => $this->shipmentId]);
				}
				$this->generateSummary($this->tripId, $currentTimeZone);
			}
			$this->finalClosure($createdsource, $postData);
		} else {
			return 0;
		}
		return 1;
	}

	private function finalClosure(int $createdsource, array $postData) : void  {
		try {
			if ( $createdsource === SELF::ROADLOG_ORDER_SOURCE ) {
				$ediReference = $this->CI->shippeostatusintigration->is_shippeo_order($this->orderId, $this->companyCode, $this->branchCode);
				if ($ediReference != 0) {
					$this->CI->shippeostatusintigration->shippeo_event_call($this->orderId, $postData, $currentTimeZone, SELF::CLOSE_STATUS_ID, SELF::CLOSE_STOP_TYPE, $this->vehicleId, $ediReference, $this->companyCode, $this->branchCode, $this->userId);
				}
				$this->CI->statusintigration->roadlogshipmenttripdelivered($postData);
			}
			if ($createdsource === SELF::MACADAM_ORDER_SOURCE) {
				$this->CI->macdamstatusintigration->macdamshipmenttripdelivered($postData);
			} else {
				if ( $createdsource === SELF::KNLOGIN_ORDER_SOURCE) {
					$this->CI->knlogin->knloginshipmentstatus($postData);
				}
			}
		} catch (Exception $ex) {
			log_message("error", "Some Problem occured!, While Sending Status to Road Log and shippeo using updatetriporderclosestatus Lib");
		}
	}

	private function getOrderType() : int  {
		$orderType = 0;
		if ( $this->shipmentId > 0) {
			$isMultiLegOrder = $this->CI->Common->gettblrowdata(['id'=>$this->shipmentId], ['shift_leg_id'], 'tb_shifts', 1, 0);
			if ( !empty($isMultiLegOrder) && (int) $isMultiLegOrder['shift_leg_id'] > 0 ) {
				$orderType = 1;
			}
		} else {
			$orderType = -1;
		}
		return $orderType;
	}

	public function generateSummary(int $tripId, string $timeZone): void
	{
		if ( $tripId > 0 ) {
			if (empty($timeZone) ) {
				$timeZone = date_default_timezone_get();
			}
			$logDate = date('Y-m-d H:i:s');
			$getActual = getdatetimebytimezone(DFLT_TZ, $logDate, $timeZone);
			$currentDate = $getActual['datetime'];
			$registerNumber = "";
			$getTripInfo = $this->CI->TripOrderCloseModel->getTripInfo($tripId, $timeZone);
			//log_message("error","Qry:".$this->CI->db->last_query());
			if (!empty($getTripInfo)) {
				$data = [];
				$data['driver_name'] = $data['driver_num'] = "";
				$shiftId = $getTripInfo['shift_id'];
				$getShiftInfo = $this->CI->TripOrderCloseModel->getShiftInfo($shiftId, $timeZone);
				$data["trip"] = $getShiftInfo;
				$employeeDetails = $this->CI->TripOrderCloseModel->getEmployeeInfo($tripId, $timeZone);
				$getTripEmployee = $this->CI->TripOrderCloseModel->getTripEmployee($tripId);
				$imei = $getTripInfo['start_imei'];
				$endImei = $getTripInfo['end_imei'];
				$driverId = $getTripInfo['driver_id'];
				$vehicleId = $getTripInfo['vehicle_id'];
				$startTime = $getShiftInfo['startdate'];
				$endTime = $getShiftInfo['enddate'];
				$userId = $getShiftInfo['user_id'];
				$odometerStart = trim($getTripInfo['start_reading']);
				$odometerEnd = trim($getTripInfo['end_reading']);
				$tripType = $getTripInfo['trip_type'];
				$vendorID = 0;
				$dlat = $dlng = "";
				$trucksQuery = $this->CI->TripOrderCloseModel->getVehicleInfo($vehicleId);
				$cabCapacity = $truckWeight = $truckVolume = 0;
				if ($trucksQuery) {
					$cabCapacity = $trucksQuery['truck_capacity'];
					$registerNumber = $trucksQuery['register_number'];
					$vendorID = $trucksQuery['vendor_id'];
					$truckWeight = $trucksQuery['truck_weight'];
					$truckVolume = $trucksQuery['truck_volume'];
					$dlat = $trucksQuery['latitude'];
					$dlng = $trucksQuery['longitude'];
				}
				if ($dlat == "") {
					$dlat = $getTripInfo['plat'];
					$dlng = $getTripInfo['plng'];
				}
				if ($dlat == $getTripInfo['plat']) {
					$dlat = $getShiftInfo['elat'];
					$dlng = $getShiftInfo['elng'];
				}
				$this->CI->Common->updatetbledata("tb_trips", ["dlat" => $dlat, "dlng" => $dlng], ["id" => $tripId]);
				$vehicleTripInfo = ["plat" => $getTripInfo['plat'], "plng" => $getTripInfo['plng'], "dlat" => $dlat, "dlng" => $dlng];
				$data['tripinfo'] = (object)$vehicleTripInfo;
				if ($cabCapacity == "") {
					$cabCapacity = 0;
				}
				$getDriversData = $this->CI->TripOrderCloseModel->getDriverInfo($driverId);
				if ($getDriversData) {
					$data['driver_name'] = $getDriversData['name'];
					$data['driver_num'] = $getDriversData['contact_num'];
					$vnid = $getDriversData['vendor_id'];
					if ($vendorID == 0 && $vnid != 0) {
						$vendorID = $vnid;
					}
				}
				$getDriverLocations = $this->CI->TripOrderCloseModel->getDriverLocations($tripId);
				$distance = $flag = $lat = $lng = 0;
				$finalResult = array_reverse($getDriverLocations);
				foreach ($finalResult as $row) {
					if ($flag == 0) {
						$flag = 1;
					} else {
						$a = calculateDistance12($lat, $lng, $row['latitude'], $row['longitude']);
						$distance = $distance + $a;
					}
					$lat = $row['latitude'];
					$lng = $row['longitude'];
				}
				$attendemp = 0;
				$totalEmployee = getempcount($tripId);
				if ($getTripEmployee) {
					$attendemp = $getTripEmployee['attcnt'];
				}
				$data["noofemp"] = $totalEmployee;
				$driverLate = 0.00;
				$startETime = date("Y-m-d H:i:s", strtotime($getShiftInfo['setime']));
				$toETime = date("Y-m-d H:i:s", strtotime(date("H:i:s", strtotime($getTripInfo['tetime']))));
				$toTime = strtotime($startETime);
				$fromTime = strtotime($toETime);
				if ($fromTime > $toTime) {
					$driverLate = round(abs($fromTime - $toTime) / 60, 2);
				}
				$checkTrip = $this->CI->Common->gettblrowdata(["trip_id" => $tripId], "id", "tb_trip_summary", 0, 0);
				if (empty($checkTrip)) {
					$this->CI->Common->insertTableData(
						"tb_trip_summary",
						['trip_id' => $tripId, 'vehicle_id' => $vehicleId, 'driver_id' => $driverId, 'vendor_id' => $vendorID, 'trip_distance' => $distance, 'no_of_emp' => $totalEmployee, 'attended_emp' => $attendemp, 'start_imei' => $imei, 'end_imei' => $endImei, 'start_time' => $startTime, 'end_time' => $endTime, 'user_id' => $userId, 'cab_capacity' => $cabCapacity, 'trip_status' => 1, 'trip_type' => $tripType, 'ship_delay' => $driverLate, 'createdon' => $currentDate]
					);
				}
				$data["trip_id"] = $tripId;
				$shifttime = 0;
				if ($tripType != 2) {
					$shiftStartDate = $getShiftInfo['startdate'];
					$shifttime = date('H:i A', strtotime($shiftStartDate));
				} else {
					$shifttime = "Empty";
				}
				$data["driver_late"] = $driverLate;
				$data["empshifttime"] = $shifttime;
				$data["distance"] = $distance;
				$data["stime"] = $startTime;
				$data["etime"] = $endTime;
				$data["simei"] = $imei;
				$data["eimei"] = $endImei;
				if ($odometerEnd == "") {
					$odometerEnd = 0;
				}
				if ($odometerStart == "") {
					$odometerStart = 0;
				}
				$data["odometer"] = ($odometerEnd - $odometerStart);
				$data["page_title"] = "Trip Report";
				$data["capacity"] = $cabCapacity;
				$data["employees"] = $employeeDetails;
				$data["trip_type"] = $tripType;
				$data["register_number"] = $registerNumber;
				$data["truck_weight"] = $truckWeight;
				$data["truck_volume"] = $truckVolume;
				$data["ep"] = "";
				$getUserMail = $this->CI->TripOrderCloseModel->getUserInfo($userId);
				if ($getUserMail) {
					$receivemail = $getUserMail['emailid'];
					$receivename = $getUserMail['name'];
					$receivecc = $getUserMail['cc_mails'];
					$data["ep"] = $getUserMail['address'];
					$insertdata = @[
						'trip_id' => $tripId,
						'shift_id' => $shiftId,
						'splace' => $data["trip"]->splace,
						'eplace' => $data["trip"]->eplace,
						'stime' => $startTime,
						'etime' => $endTime,
						'capacity' => $cabCapacity,
						'simei' => $data['simei'],
						'eimei' => $data['eimei'],
						'totcnt' => $totalEmployee,
						'attcnt' => $attendemp,
						'distance' => $data['distance'],
						'odometer' => $data['odometer'],
						'driver_late' => $data['driver_late'],
						'receivemail' => $receivemail,
						'receivename' => $receivename,
						'user_id' => $userId,
						'createdon' => $currentDate
					];
					$this->CI->Common->insertTableData('tb_trips_mails', $insertdata);
					/*$this->CI->load->library('PhpMailerLibrary');
					try {
						if ($tripType == 1) {
							$subject = "svkonekt: Return Trip Status";
						} else {
							if ($tripType == 2) {
								$subject = "svkonekt: Empty Trip Status";
								$this->CI->email->subject('');
							} else {
								$subject = "svkonekt: Trip Status";
							}
						}
						$body = $this->CI->load->view('mail_forms/basicreport', $data, true);
						if ( !$this->phpmailerlibrary->sendmail($receivemail, $subject, $body, [], []) ) {
							log_message("error", "Unable to send the email of UpdateTripOrderCloseStatus");
						} else {
							log_message("error", "Email of UpdateTripOrderCloseStatus has been sent successfully");
						}
					} catch (Exception $e) {
						log_message("error", "UpdateTripOrderCloseStatus not send on " . date('d-m-Y h:i A') . " - " . $e->getMessage());
					}*/
				}
			}
		}
	}
}