<?php

class WestPharmaService
{
    public function __construct()
    {
        $ci =& get_instance();
        $ci->load->model('common');
    }

    public function checkUser(string $company_code, string $branch_code, string $firstTwoChars): int
    {
        $ci =& get_instance();
        $userId = 0;
        $currentDate = date('Y-m-d H:i:s');
        $checkUser = $ci->db->query(
            "SELECT id FROM tb_users WHERE company_code=? AND branch_code=? AND status='Active' LIMIT 1", [$company_code, $branch_code]
        );
        if ($checkUser->num_rows() > 0) {
            $userId = $checkUser->row()->id;
        } else {
            $checkUserCompany = $ci->db->query(
                "SELECT user_id FROM tb_user_companies WHERE company_code=? AND branch_code=? AND status=1 LIMIT 1", [$company_code, $branch_code]
            );
            if ($checkUserCompany->num_rows() > 0) {
                $userId = $checkUserCompany->row()->user_id;
            } else {
                $adminPhone = time();
                $adminPassword = password_hash($adminPhone,PASSWORD_DEFAULT);
                $userData = [
                    'country_code' => $firstTwoChars,
                    'name' => $firstTwoChars . "_Admin",
                    'company_indv_name' => $company_code,
                    'business_type' => 'Truck_Owner',
                    'mobile_no' => $adminPhone,
                    'password' => $adminPassword,
                    'emailid' => 'svkonekt@kuehne-nagel.com',
                    'domain_name' => $branch_code,
                    'location_id' => 1646,
                    'createdby' => 1,
                    'status' => 'Active',
                    'createdon' => $currentDate,
                    'company_code' => $company_code,
                    'branch_code' => $branch_code,
                ];
                $userId = $ci->common->insertTableData('tb_users', $userData);
            }
        }
        return $userId;
    }

    public function checkCustomerinfo(
        int $userId,
        string $company_code,
        string $branch_code,
        string $firstTwoChars
    ): int {
        $ci =& get_instance();
        $customerId = 0;
        $currentDate = date('Y-m-d H:i:s');
        $branchWiseCustomer = $ci->db->query(
            "SELECT id FROM tb_customers WHERE user_id=? AND company_code=? AND branch_code=? ORDER BY id ASC LIMIT 1", [$userId, $company_code, $branch_code]
        );
        if ($branchWiseCustomer->num_rows() > 0) {
            $customerId = $branchWiseCustomer->row()->id;
        } else {
            $randomNumber = mt_rand();
            $password = password_hash($randomNumber,PASSWORD_DEFAULT);
            $customerData = [
                'name' => $company_code . "_Customer",
                'phone' => $randomNumber,
                'location' => $firstTwoChars,
                'address' => $firstTwoChars,
                'pincode' => $firstTwoChars,
                'code' => $randomNumber,
                'country' => $firstTwoChars,
                'password' => $password,
                'user_id' => $userId,
                'company_code' => $company_code,
                'branch_code' => $branch_code,
                'status' => 1,
                'createdon' => $currentDate,
                'updatedon' => $currentDate,
            ];
            $customerId = $ci->common->insertTableData('tb_customers', $customerData);
        }
        return (int)$customerId;
    }

    public function readShipmentData(object $xml): array
    {
        $response = $receivers = [];
        $xml->registerXPathNamespace('ns3', 'http://knie4.int.kn/com/hdr/0500');
        $data = $xml->xpath('ns3:MSGHDR');
        if (!empty($data[0]->xpath('REC'))) {
            foreach ($data[0]->xpath('REC') as $mm) {
                $receivers[] = [
                    'physicalreceiver' => (string)$mm->PHYREC,
                    'logicalreceiver' => (string)$mm->LOGREC,
                    'mtype' => (string)$mm->attributes('ns2', true)->ADRTYP,
                ];
            }
        }
        $physicalSender = (string)($data[0]->xpath('PHYSND')[0]);
        $logicalSender = (string)($data[0]->xpath('LOGSND')[0]);
        $senderApp = (string)($data[0]->xpath('SNDAPP')[0]);
        $messageType = (string)($data[0]->xpath('MSGTYP')[0]);
        $version = (string)($data[0]->xpath('VERNUM')[0]);
        $createdTime = (string)($data[0]->xpath('CREDTM')[0]);
        if ($createdTime != "") {
            $createdTime = date("Y-m-d H:i:s", strtotime($createdTime));
        } else {
            $createdTime = date("Y-m-d H:i:s");
        }
        $functionCode = (string)($data[0]->xpath('FNCCDE')[0]);
        $driver = $carrier = $consignor = [];
        $response['header'] = [
            "receivers" => $receivers,
            "psender" => $physicalSender,
            "lsender" => $logicalSender,
            "sendapp" => $senderApp,
            "msgtype" => $messageType,
            "version" => $version,
            "fnccode" => $functionCode,
            "createdtime" => $createdTime,
        ];
        $response['header']['preceiver'] = "";
        $response['header']['lreceiver'] = "";
        foreach ($receivers as $rec) {
            if ($rec['mtype'] == "CA") {
                $response['header']['preceiver'] = $rec['physicalreceiver'];
                $response['header']['lreceiver'] = $rec['logicalreceiver'];
            }
        }

        $response['shipdata'] = [];
        $xml->registerXPathNamespace('ns5', 'http://knie4.int.kn/com/mlv/0500');
        $metadata = $xml->xpath('//ns23:ROASHP');
        $shipmentInfo = $metadata[0]->xpath('MSG')[0]->SHP;
        foreach ($shipmentInfo as $key => $shipments) {
            $response['shipdata'][] = $this->generateShipmentData($shipments);
        }
        return $response;
    }

    public function generateShipmentData(object $xml): array
    {
        $xml->registerXPathNamespace('ns5', 'http://knie4.int.kn/com/mlv/0500');
        $titleData = $xml->xpath('ns5:MSGLVL');
        $arr['orderid'] = (string)($titleData[0]->xpath('TRCNUM')[0]);
        $arr['sendercmpcode'] = (string)($titleData[0]->xpath('SNDINF')[0]->CPNCDE);
        $arr['senderbranchcode'] = (string)($titleData[0]->xpath('SNDINF')[0]->BRACDE);
        $arr['senderdeptcode'] = (string)($titleData[0]->xpath('SNDINF')[0]->DPTCDE);
        $arr['sendertransmode'] = 1;
        $arr['sendertransmode'] = (string)($titleData[0]->xpath('SNDINF')[0]->MODTRS);
        $arr['senderflag'] = (string)($titleData[0]->xpath('SNDINF')[0]->EXPIMPFLG);
        $arr['xsrvalue'] = "";
        $arr['references'] = [];

        if (!empty($titleData[0]->xpath('REF'))) {
            $referenceCode = (string)($titleData[0]->xpath('REF')[0]->CDE);
            $referenceValue = (string)($titleData[0]->xpath('REF')[0]->VAL);
            if ($referenceCode == 'INN') {
                $arr['xsrvalue'] = $referenceValue;
            }
            if ($referenceCode == 'DQ') {
                $referenceCode = "ACD";
            }
            $arr['references'][] = ['code' => $referenceCode, 'value' => $referenceValue];
        }

        $statusInfo = $xml->xpath('ns6:STSINF');
        $arr['statusinfo_date'] = (string)($statusInfo[0]->xpath('DTE')[0]);
        $arr['statusinfo_time'] = (string)($statusInfo[0]->xpath('TME')[0]);
        $arr['statusinfo_locissue'] = (string)($statusInfo[0]->xpath('STSLOC')[0]);
        $arr['statusinfo_trg'] = (string)($statusInfo[0]->xpath('TRG')[0]);
        $arr['statusinfo_addrinfo'] = (string)($statusInfo[0]->xpath('ADDSTSINF')[0]->ENTDTM);
        $arr['statusinfo_useride'] = (string)($statusInfo[0]->xpath('ADDSTSINF')[0]->USRIDE);
        $arr['statusinfo_prl'] = (string)($statusInfo[0]->xpath('PRL')[0]);
        $infoData = $xml->SHPINF;
        $infoData->registerXPathNamespace('ns7', 'http://knie4.int.kn/com/shpd/0600');
        $details = $infoData->xpath('ns7:SHPDTL');
        $arr['packages'] = 1;
        $arr['measurements'] = [];
        $arr['dangerousflag'] = $arr['source'] = $arr['sourcebranch'] = $arr['destination'] = $arr['destinationbranch'] = $arr['bussolcode'] = $arr['bussolcatecode'] = "";
        $arr['totaldangerousflag'] = 0;
        $arr['items_count'] = $arr['pkgs_count'] = 1;
        $arr['pkgs_uom'] = 'PCS';
        $arr['gross_weight'] = $arr['volume'] = $arr['charge_weight'] = $arr['charge_uom'] = 1;
        $arr['weight_uom'] = 'KGM';
        $arr['volume_uom'] = 'MTQ';
        $arr['cargo_content'][] = 'Boxes';
        if (!empty($details)) {
            if (!empty($details[0]->xpath('TOTPAC'))) {
                $arr['packages'] = (string)($details[0]->xpath('TOTPAC')[0]);
            }
            if (!empty($details[0]->xpath('MEA'))) {
                foreach ($details[0]->xpath('MEA') as $mm) {
                    $arr['measurements'][] = [
                        'mtype' => (string)$mm->attributes('ns2', true)->MEATYP,
                        'value' => (string)$mm->VAL,
                        'uom' => (string)$mm->UOMCDE,
                    ];
                }
            }

            if (!empty($details[0]->xpath('DGSGOOFLG'))) {
                $arr['dangerousflag'] = (string)($details[0]->xpath('DGSGOOFLG')[0]);
            }

            if (!empty($details[0]->xpath('ORG'))) {
                $arr['source'] = (string)($details[0]->xpath('ORG')[0]->LOC[0]);
                $arr['sourcebranch'] = (string)($details[0]->xpath('ORG')[0]->LOC[1]);
            }

            if (!empty($details[0]->xpath('DES'))) {
                $arr['destination'] = (string)($details[0]->xpath('DES')[0]->LOC[0]);
                $arr['destinationbranch'] = (string)($details[0]->xpath('DES')[0]->LOC[1]);
            }

            if (!empty($details[0]->xpath('BIZSOL'))) {
                $arr['bussolcode'] = (string)($details[0]->xpath('BIZSOL')[0]->CDE);
                $arr['bussolcatecode'] = (string)($details[0]->xpath('BIZSOL')[0]->CATCDE);
            }
        }
        $shipper = $customer = $consignee = $dimensions = [];
        $infoData->registerXPathNamespace('ns8', 'http://knie4.int.kn/com/adr/0500');
        foreach ($infoData->xpath('ns8:ADR') as $addr) {
            if ($addr->attributes('ns2', true)->ADRTYP == "SH") {
                $shipper = $this->generatePartyData($addr, "Shipper");
            }
            if ($addr->attributes('ns2', true)->ADRTYP == "CU") {
                $customer = $this->generatePartyData($addr, "Customner");
            }
            if ($addr->attributes('ns2', true)->ADRTYP == "CN") {
                $consignee = $this->generatePartyData($addr, "Consignee");
            }
        }
        $arr['items_count'] = $arr['pkgs_count'] = 1;
        $arr['pkgs_uom'] = 'PCS';
        $arr['gross_weight'] = $arr['volume'] = $arr['charge_weight'] = $arr['charge_uom'] = 1;
        $arr['weight_uom'] = 'KGM';
        $arr['volume_uom'] = 'MTQ';
        $arr['cargo_content'][] = 'Boxes';
        if (null !== $infoData[0]->xpath('CGODSC')) {
            $cargo = $infoData[0]->xpath('CGODSC')[0];
            $cargo->registerXPathNamespace('ns9', 'http://knie4.int.kn/com/cgod/0600');
            $cargoDetails = $cargo->xpath('ns9:CGODTL');
            if (null !== $cargoDetails[0]->xpath('NUMPAC')[0]) {
                $arr['pkgs_count'] = isset(
                    $cargoDetails[0]->xpath(
                        'NUMPAC'
                    )[0]->VAL
                ) ? (string)($cargoDetails[0]->xpath('NUMPAC')[0]->VAL) : 1;
            }
            if (null !== $cargoDetails[0]->xpath('NUMPAC')[0]) {
                $arr['pkgs_uom'] = isset($cargoDetails[0]->xpath('NUMPAC')[0]->TYP) ? (string)($cargoDetails[0]->xpath(
                    'NUMPAC'
                )[0]->TYP) : 1;
            }
            if (null !== $cargoDetails[0]->xpath('GRSWGT')[0]) {
                $arr['gross_weight'] = isset(
                    $cargoDetails[0]->xpath(
                        'GRSWGT'
                    )[0]->VAL
                ) ? (string)($cargoDetails[0]->xpath('GRSWGT')[0]->VAL) : 1;
            }
            if (null !== $cargoDetails[0]->xpath('GRSWGT')[0]) {
                $arr['weight_uom'] = isset(
                    $cargoDetails[0]->xpath(
                        'GRSWGT'
                    )[0]->UOMCDE
                ) ? (string)($cargoDetails[0]->xpath('GRSWGT')[0]->UOMCDE) : 1;
            }
            if (null !== $cargoDetails[0]->xpath('CHGWGT')) {
                $arr['charge_weight'] = isset(
                    $cargoDetails[0]->xpath(
                        'CHGWGT'
                    )[0]->VAL
                ) ? (string)($cargoDetails[0]->xpath('CHGWGT')[0]->VAL) : 0;
                $arr['charge_uom'] = isset(
                    $cargoDetails[0]->xpath(
                        'CHGWGT'
                    )[0]->UOMCDE
                ) ? (string)($cargoDetails[0]->xpath('CHGWGT')[0]->UOMCDE) : 0;
            }
            $arr['volume'] = (string)($cargoDetails[0]->xpath('VOL')[0]->VAL);
            $arr['volume_uom'] = (string)($cargoDetails[0]->xpath('VOL')[0]->UOMCDE);

            if (!empty($cargoDetails[0]->xpath('CGOCTT'))) {
                $arr['cargo_content'] = [];
                foreach ($cargoDetails[0]->xpath('CGOCTT') as $cgoctt) {
                    $arr['cargo_content'][] = (string)$cgoctt;
                }
            }
            $cargo->registerXPathNamespace('ns11', 'http://knie4.int.kn/com/dim/0500');
            if (null !== $cargo->xpath('ns11:DIM')) {
                foreach ($cargo->xpath('ns11:DIM') as $dim) {
                    $measurs = [];
                    foreach ($dim->xpath('MEA') as $ms) {
                        $measurs[] = ["value" => (string)$ms->VAL, "uomcode" => (string)$ms->UOMCDE];
                    }
                    $dimensions[] = [
                        "nopkgs" => (string)($dim->xpath('NUMPAC')[0]->VAL),
                        "mom" => (string)($dim->xpath('NUMPAC')[0]->TYP),
                        "measerments" => $measurs,
                    ];
                }
            }
        }
        $arr['dimensions'] = $dimensions;
        $arr['shipper'] = $shipper;
        $arr['consignee'] = $consignee;
        $arr['customer'] = $customer;
        $carrier = $ff = $do = [];
        $infoData1 = $xml->SHPROA;
        $infoData1->registerXPathNamespace('ns13', 'http://knie4.int.kn/com/rdtl/0600');
        $roaddetail = $infoData1->xpath('ns13:ROADTL');
        $arr['serviceproduct'] = $arr['servicetype'] = $arr['freight_term'] = $arr['freight_termname'] = "";
        if (null !== $roaddetail[0]->xpath('INSFLG')) {
            $arr['serviceproduct'] = (string)($roaddetail[0]->xpath('INSFLG')[0]);
        }
        if ($arr['serviceproduct'] == "N" || $arr['serviceproduct'] == "Y") {
            $arr['serviceproduct'] = "LTL/FTL";
        }

        if (!empty($roaddetail[0]->xpath('TRUTYP'))) {
            $arr['servicetype'] = (string)($roaddetail[0]->xpath('TRUTYP')[0]);
        }

        if (null !== $roaddetail[0]->xpath('BND')) {
            $arr['freight_term'] = (string)($roaddetail[0]->xpath('BND')[0]->Term);
        }
        $pickdrop = [];
        $p = $d = 0;
        $infoData1->registerXPathNamespace('ns17', 'http://knie4.int.kn/com/txt/0500');
        $invoice = $infoData1->xpath('ns17:TXT');
        $arr['invoice'] = isset($invoice[0]) ? (string)($invoice[0]) : "";
        if ($arr['invoice'] != "") {
            $arr['invoice'] = str_replace("invoice no: ", "", $arr['invoice']);
        }
        $waypoints = $infoData1->TRUWPN;
        foreach ($waypoints as $sd) {
            if ($sd->attributes('ns23', true)->WPNTYP == "PUP") {
                $arr1 = $this->generateWayPoints($sd, 'PUP');
                $p++;
                $pickdrop[] = $arr1;
            }
            if ($sd->attributes('ns23', true)->WPNTYP == "DEL") {
                $arr2 = $this->generateWayPoints($sd, 'DEL');
                $d++;
                $pickdrop[] = $arr2;
            }
        }
        $arr['pickdrops'] = $pickdrop;
        $arr['pickcount'] = $p;
        $arr['dropcount'] = $d;
        $arr['typeofbusiness'] = "DOMESTIC";
        return $arr;
    }

    private function generatePartyData(object $addr, string $partyType): array
    {
        $arr['shreferences'] = $arr['cureferences'] = $arr['cnreferences'] = $arr['pfreferences'] = [];
        $firstName = (string)($addr->xpath('NAM')[0]) ?? "";
        $street = (string)($addr->xpath('STR')[0]) ?? "";
        $city = (string)($addr->xpath('CTY')[0]) ?? "";
        $country = (string)($addr->xpath('CNYCDE')[0]) ?? "";
        $zipcode = (string)($addr->xpath('ZIPCDE')[0]) ?? "";
        $cid = (string)($addr->xpath('CID')[0]) ?? "";
        $partyId = (string)($addr->xpath('IDE')[0]) ?? "";
        $data = [
            'name' => $firstName,
            'street' => $street,
            'city' => $city,
            'country' => $country,
            'zip' => $zipcode,
            'custid' => $cid,
            'partyid' => $partyId,
        ];
        if (!empty($addr->xpath('REF'))) {
            foreach ($addr->xpath('REF') as $ref) {
                $xsrValue = (string)$ref->CDE;
                if ($xsrValue != "") {
                    if ($xsrValue == 'XSR') {
                        $arr['xsrvalue'] = (string)$ref->VAL;
                    }
                    if ($xsrValue == 'DQ') {
                        $xsrValue = "ACD";
                    }
                    if ($partyType == "Consignee") {
                        $arr['cnreferences'][] = ['code' => $xsrValue, 'value' => (string)$ref->VAL];
                    }
                    if ($partyType == "Customer") {
                        $arr['cureferences'][] = ['code' => $xsrValue, 'value' => (string)$ref->VAL];
                    }
                    if ($partyType == "Shipper") {
                        $arr['shreferences'][] = ['code' => $xsrValue, 'value' => (string)$ref->VAL];
                    }
                }
            }
        }
        return $data;
    }

    private function generateWayPoints(object $sd, string $wayType): array
    {
        $sd->registerXPathNamespace('ns8', 'http://knie4.int.kn/com/adr/0500');
        $point = $sd->xpath('ns8:ADR');

        if ($wayType == 'PUP') {
            $arr1['pickup_company'] = (string)$point[0]->xpath('NAM')[0] ?? "";
            $arr1['pickup_address'] = (string)$point[0]->xpath('STR')[0] ?? "";
            $arr1['pickup_address1'] = (string)$point[0]->xpath('STR')[0] ?? "";
            $arr1['pickup_city'] = (string)$point[0]->xpath('CTY')[0] ?? "";
            $arr1['pickup_countrycode'] = (string)$point[0]->xpath('CNYCDE')[0] ?? "";
            $arr1['pickup_postal'] = (string)$point[0]->xpath('ZIPCDE')[0] ?? "";
            $arr1['pickup_custid'] = (string)$point[0]->xpath('CID')[0] ?? "";
            $arr1['pickup_partyid'] = (string)$point[0]->xpath('IDE')[0] ?? "";
            $arr1['sequence'] = 1;
            $arr1['stoptype'] = 'P';
            $arr1['pickup_datefrom'] = (string)$sd->DTERNG->DTEFRM;
            $arr1['pickup_datefromtime'] = (string)$sd->DTERNG->TMEFRM;
            $arr1['pickup_dateto'] = (string)$sd->DTERNG->DTEFRM;
            $arr1['pickup_datetotime'] = (string)$sd->DTERNG->TMEFRM;
        } else {
            $arr1['drop_company'] = (string)$point[0]->xpath('NAM')[0] ?? "";
            $arr1['drop_address'] = (string)$point[0]->xpath('STR')[0] ?? "";
            $arr1['drop_address1'] = (string)$point[0]->xpath('STR')[0] ?? "";
            $arr1['drop_city'] = (string)$point[0]->xpath('CTY')[0] ?? "";
            $arr1['drop_countrycode'] = (string)$point[0]->xpath('CNYCDE')[0] ?? "";
            $arr1['drop_postal'] = (string)$point[0]->xpath('ZIPCDE')[0] ?? "";
            $arr1['drop_custid'] = (string)$point[0]->xpath('CID')[0] ?? "";
            $arr1['drop_partyid'] = (string)$point[0]->xpath('IDE')[0] ?? "";
            $arr1['sequence'] = 2;
            $arr1['stoptype'] = 'D';
            $arr1['drop_datefrom'] = (string)$sd->DTERNG->DTEFRM;
            $arr1['drop_datefromtime'] = (string)$sd->DTERNG->TMEFRM;
            $arr1['drop_dateto'] = (string)$sd->DTERNG->DTEFRM;
            $arr1['drop_datetotime'] = (string)$sd->DTERNG->TMEFRM;
        }
        return $arr1;
    }

    public function getCustomerType(array $data): string
    {
        $freightTerms = ['10' => 'SH', '20' => 'PF', '30' => 'CN', '31' => 'CN', '60' => 'PF'];
        if (!in_array($data['freight_term'], array_keys($freightTerms))) {
            return '';
        }
        if ('60' !== $data['freight_term'] || ('60' === $data['freight_term'] && !isset($data['incoterm']))) {
            return $freightTerms[$data['freight_term']];
        }

        $incoTerms = ['DAP' => 'SH', 'DDP' => 'SH', 'EXW' => 'CN', 'FCA' => 'CN'];
        if (in_array($data['incoterm'], array_keys($incoTerms))) {
            return $incoTerms[$data['incoterm']];
        }
        return '';
    }

    public function insertOrderReceivers(int $orderId, array $data): void
    {
        $ci =& get_instance();
        $receivers = $data['header']['receivers'];
        foreach ($receivers as $refs) {
            $orderReference = [
                'order_id' => $orderId,
                'physicalsender' => $data['header']['psender'],
                'logicalsender' => $data['header']['lsender'],
                'sendermsgtype' => $data['header']['msgtype'],
                'physicalreceiver' => $refs['physicalreceiver'],
                'logicalreceiver' => $refs['logicalreceiver'],
                'receivermsgtype' => $refs['mtype'],
                'senderapp' => $data['header']['sendapp'],
            ];
            $ci->common->insertTableData('tb_order_send_receiver', $orderReference);
        }
    }

    public function insertShipmentDetails(
        string $orderId,
        array $shipmentData,
        array $data,
        string $logDate,
        string $transportMode,
        string $cargo_content
    ): int {
        $ci =& get_instance();
        $shipmentDataIns = [
            'shipid' => $orderId,
            'txnid' => $orderId,
            'trucktype' => $data['truck']['ordernum'],
            'product' => $shipmentData['serviceproduct'],
            'pickupcnt' => $shipmentData['pickcount'],
            'dropcnt' => $shipmentData['dropcount'],
            'unitspec' => $cargo_content,
            'insertusr' => $shipmentData['shipper']['custid'],
            'insertuserdate' => $shipmentData['statusinfo_date'],
            'enddate' => $shipmentData['statusinfo_date'],
            'insdate' => $shipmentData['statusinfo_date'],
            'upddate' => $shipmentData['statusinfo_date'],
            'reason' => $data['header']['sendapp'],
            'purpose' => 'SEND INTEGRATION',
            'ship_object' => $data['header']['msgtype'],
            'logdate' => $logDate,
            'status' => 1,
            'createdon' => $logDate,
            'transport_mode' => $transportMode,
            'txncode' => $shipmentData['orderid'],
            'domainname' => $data['header']['lsender'],
            'company_code' => $shipmentData['sendercmpcode'],
            'branch_code' => $shipmentData['senderbranchcode'],
            'freight_term' => $shipmentData['freight_term'],
            'freight_termname' => $shipmentData['freight_termname'],
            'incoterm' => $shipmentData['incoterm'],
            'logicalreceiver' => $data['header']['lreceiver'],
            'physicalreceiver' => $data['header']['preceiver'],
            'physicalsender' => $data['header']['psender'],
            'logicalsender' => $data['header']['lsender'],
            'modeoftransport' => $shipmentData['sendertransmode'],
        ];
        return $ci->common->insertTableData('tb_shipments', $shipmentDataIns);
    }

    public function generateRefererences(array $shipmentData): array
    {
        $dqnum = $shipmentData['orderid'];
        if (!empty($shipmentData['references'])) {
            foreach ($shipmentData['references'] as $sref) {
                $referenceData[] = $sref;
            }
            $referenceData[] = ['code' => 'DQ', 'value' => $dqnum];
        }
        if (!empty($shipmentData['pfreferences'])) {
            foreach ($shipmentData['pfreferences'] as $pfref) {
                $referenceData[] = $pfref;
            }
        }
        if (!empty($shipmentData['cnreferences'])) {
            foreach ($shipmentData['cnreferences'] as $cnref) {
                $referenceData[] = $cnref;
            }
        }
        if (!empty($shipmentData['cureferences'])) {
            foreach ($shipmentData['cureferences'] as $curef) {
                $referenceData[] = $curef;
            }
        }
        if (!empty($shipmentData['shreferences'])) {
            foreach ($shipmentData['shreferences'] as $shref) {
                $referenceData[] = $shref;
            }
        }
        if (!empty($shipmentData['doreferences'])) {
            foreach ($shipmentData['doreferences'] as $doref) {
                $referenceData[] = $doref;
            }
        }
        if (!empty($shipmentData['ffreferences'])) {
            foreach ($shipmentData['ffreferences'] as $ffref) {
                $referenceData[] = $ffref;
            }
        }
        if (!empty($shipmentData['careferences'])) {
            foreach ($shipmentData['careferences'] as $caref) {
                $referenceData[] = $caref;
            }
        }
        if ($shipmentData['invoice'] != "") {
            $referenceData[] = ['code' => 'IV', 'value' => $shipmentData['invoice']];
        }
        $referenceData[] = ['code' => 'SD', 'value' => $shipmentData['sendertransmode']];
        return $referenceData;
    }

}
