<?php

namespace App\Libraries;

abstract class XmlNode
{
    private $encoding = '';
    private $data = [];

    public function __construct(array $data, array $default, string $encoding = 'UTF-8')
    {
        $data = array_merge($default, $data);

        foreach (array_intersect(array_keys($default), array_keys($data)) as $key) {
            $this->{$key} = $data[$key];
        }

        $this->encoding = $encoding;
    }

    public function __set(string $dataName, $dataValue)
    {
        $this->data[$dataName] = htmlspecialchars($dataValue, ENT_XML1, $this->encoding, false);
    }

    public function __get($dataName)
    {
        if (!isset($this->data[$dataName])) {
            throw new \Exception('Data \'' . $dataName . '\' is undefined in XML node.');
        }
        return $this->data[$dataName];
    }

    abstract function getXml(): string;
}
