<?php
namespace SVKAPI\v1\Clients;

use SVKAPI\v1\Interfaces\ApiClientInterface;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\Psr7\Response;
use GuzzleHttp\Client;
use SVKAPI\v1\Exceptions\InvalidResponseException;

class ApiClient implements ApiClientInterface
{
    /**
     * @var string
     */
    private $endpoint;

    /**
     * @var string
     */
    private $data;

    /**
     * @data string
     */
    private $method;

    /**
     * @var array
     */
    private $options = [];

    /**
     * @var Response
     */
    private $response;


    /**
     * @param string $url
     * @return $this
     */
    public function setEndpoint(string $url): ApiClientInterface
    {
        $this->endpoint = $url;
        return $this;
    }

    /**
     * @return string
     */
    public function getEndpoint(): string
    {
        return $this->endpoint;
    }

    public function setOptions(array $options): ApiClientInterface
    {
        $this->options = $options;
        return $this;
    }

    /**
     * @return string
     */
    public function getOptions(): string
    {
        return $this->options;
    }

    /**
     * @param string $data
     * @return $this
     */
    public function setData(string $data): ApiClientInterface
    {
        $this->data = $data;
        return $this;
    }

    /**
     * @return string
     */
    public function getData(): array
    {
        return $this->data;
    }

    /**
     * @param string $method
     * @return $this
     */
    public function setMethod(string $method): ApiClientInterface
    {
        $this->method = $method;
        return $this;
    }

    /**
     * @return string
     */
    public function getMethod(): string
    {
        return $this->method;
    }

    /**
     * @return string
     */
    public function getStatusCode() : string
    {
        return $this->response->getStatusCode();
    }

    /**
     *
     */
    public function getResponseBody() : string
    {
        return $this->response->getBody()->getContents();
    }

    /**
     * @return bool
     * @throws InvalidResponseException if status code not in (200, 201)
     */
    public function send(): bool
    {
        $client = new Client();
        $this->response = $client->send($this->getCurlRequest(), [
            'http_errors' => false
        ]);

        if (!in_array($this->getStatusCode(), [200,201])) {
            throw new InvalidResponseException($this->getResponseBody());
        }

        return true;
    }

    /**
     * @return Request
     */
    private function getCurlRequest(): Request
    {
        return new Request(
            $this->method,
            $this->endpoint,
            $this->options['headers'] ?? [],
            $this->data
        );
    }
}
