<?php
namespace SVKAPI\v1\Mappings;


use SVKAPI\v1\Models\Trip;
use SVKAPI\v1\Models\TripGood;

class TripGoodsMapping extends AbstractMapping
{


    /**
     * Global Object for CI unstance
     */
    private $CI;

    /**
     */
    public function __construct()
    {
        $this->CI = &get_instance();
        $this->CI->load->model([
            'order',
            'order_cargo_details'
        ]);
    }


    /**
     * @param int $shiftId
     * @param Trip $model
     * @return Trip
     */
    public function map(int $shiftId, Trip &$model): Trip
    {
        $orders = $this->CI->order->base_query([
            'shift_id' => $shiftId
        ], false)->select(['id', 'volume', 'weight', 'quantity'])->get()->result_array();
        $dangerousGoodsFlag = false;
        $quantity = $volumeCBM = $weightKGS = 0;
        $handlingUnit = "PCs";

        if (!empty($orders)) {
            $quantity = array_sum(array_column($orders, 'quantity'));
            $volumeCBM = array_sum(array_column($orders, 'volume'));
            $weightKGS = array_sum(array_column($orders, 'weight'));

            $options = [
                'join' => [
                    [
                        'table' => 'tb_cargo_details cd',
                        'condition' => 'tb_order_cargodetails.cargo_id = cd.id',
                        'type' => 'INNER'
                    ]
                ]
            ];
            $cargoDetails = $this->CI->order_cargo_details->find([
                'order_id' => array_column($orders, 'id')
            ], [
                'cd.dg_goods'
            ], $options);
            $dgGoods = array_column($cargoDetails, 'dg_goods');
            $dangerousGoodsFlag = !empty( array_filter($dgGoods) );
        }
        $model->setTripGoods(new TripGood(compact('dangerousGoodsFlag', 'quantity', 'volumeCBM', 'weightKGS', 'handlingUnit')));
        return $model;
    }

}
