<?php
/**
 * DeliveryStop
 *
 * PHP version 7.1.3
 *
 * @category Class
 * @package  SVKAPI\v1\Models
 * @author   OpenAPI Generator team
 * @link     https://github.com/openapitools/openapi-generator
 */

/**
 * Shipsy
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 1.0
 * 
 * Generated by: https://github.com/openapitools/openapi-generator.git
 *
 */

/**
 * NOTE: This class is auto generated by the openapi generator program.
 * https://github.com/openapitools/openapi-generator
 * Do not edit the class manually.
 */

namespace SVKAPI\v1\Models;

use Symfony\Component\Validator\Constraints as Assert;
use JMS\Serializer\Annotation\Type;
use JMS\Serializer\Annotation\SerializedName;
use JMS\Serializer\Annotation\XmlRoot;
use JMS\Serializer\Annotation\XmlElement;
use JMS\Serializer\Annotation\XmlList;

/**
 * Class representing the DeliveryStop model.
 *
 * @package SVKAPI\v1\Models
 * @author  OpenAPI Generator team
 */
/** @XmlRoot("DeliveryStop") */
class DeliveryStop 
{
        /**
     * Sequence number of the stop within the trip
     *
     * @var string
     * @SerializedName("SequenceNumber")
     * @Assert\NotNull()
     * @Assert\Type("string")
     * @Type("string")
     * @XmlElement(cdata=false)
     */
    protected $sequenceNumber;

    /**
     * The type of the stop
     *
     * @var string
     * @SerializedName("Type")
     * @Assert\NotNull()
     * @Assert\Type("string")
     * @Type("string")
     * @XmlElement(cdata=false)
     */
    protected $type;

    /**
     * @var \DateTime
     * @SerializedName("DateTimeFrom")
     * @Assert\NotNull()
     * @Assert\Type("DateTime")
     * @Type("DateTime")
     */
    protected $dateTimeFrom;

    /**
     * @var \DateTime
     * @SerializedName("DateTimeTo")
     * @Assert\NotNull()
     * @Assert\Type("DateTime")
     * @Type("DateTime")
     */
    protected $dateTimeTo;

    /**
     * @var SVKAPI\v1\Models\ContactDetails
     * @SerializedName("ContactDetails")
     * @Assert\NotNull()
     * @Assert\Valid()
     * @Assert\Type("SVKAPI\v1\Models\ContactDetails")
     * @Type("SVKAPI\v1\Models\ContactDetails")
     */
    protected $contactDetails;

    /**
     * @var SVKAPI\v1\Models\Address
     * @SerializedName("Address")
     * @Assert\NotNull()
     * @Assert\Valid()
     * @Assert\Type("SVKAPI\v1\Models\Address")
     * @Type("SVKAPI\v1\Models\Address")
     */
    protected $address;

    /**
     * @var SVKAPI\v1\Models\Reference[]|null
     * @SerializedName("DeliveryReferences")
     * @Assert\All({
     *   @Assert\Type("SVKAPI\v1\Models\Reference")
     * })
     * @Type("array<SVKAPI\v1\Models\Reference>")
     * @XmlList(inline=false, entry="Reference")
     */
    protected $deliveryReferences;

    /**
     * Description for the carrier at the stop
     *
     * @var string
     * @SerializedName("CarrierInstructions")
     * @Assert\NotNull()
     * @Assert\Type("string")
     * @Type("string")
     * @XmlElement(cdata=false)
     */
    protected $carrierInstructions;

    /**
     * @var array|null
     * @SerializedName("Customs")
     * @Assert\Type("array")
     * @Type("array")
     */
    protected $customs;

    /**
     * Constructor
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->sequenceNumber = isset($data['sequenceNumber']) ? $data['sequenceNumber'] : null;
        $this->type = isset($data['type']) ? $data['type'] : null;
        $this->dateTimeFrom = isset($data['dateTimeFrom']) ? $data['dateTimeFrom'] : null;
        $this->dateTimeTo = isset($data['dateTimeTo']) ? $data['dateTimeTo'] : null;
        $this->contactDetails = isset($data['contactDetails']) ? $data['contactDetails'] : null;
        $this->address = isset($data['address']) ? $data['address'] : null;
        $this->deliveryReferences = isset($data['deliveryReferences']) ? $data['deliveryReferences'] : null;
        $this->carrierInstructions = isset($data['carrierInstructions']) ? $data['carrierInstructions'] : null;
        $this->customs = isset($data['customs']) ? $data['customs'] : null;
    }

    /**
     * Gets sequenceNumber.
     *
     * @return string
     */
    public function getSequenceNumber()
    {
        return $this->sequenceNumber;
    }

    /**
     * Sets sequenceNumber.
     *
     * @param string $sequenceNumber  Sequence number of the stop within the trip
     *
     * @return $this
     */
    public function setSequenceNumber($sequenceNumber)
    {
        $this->sequenceNumber = $sequenceNumber;

        return $this;
    }

    /**
     * Gets type.
     *
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Sets type.
     *
     * @param string $type  The type of the stop
     *
     * @return $this
     */
    public function setType($type)
    {
        $this->type = $type;

        return $this;
    }

    /**
     * Gets dateTimeFrom.
     *
     * @return \DateTime
     */
    public function getDateTimeFrom(): \DateTime
    {
        return $this->dateTimeFrom;
    }

    /**
     * Sets dateTimeFrom.
     *
     * @param \DateTime $dateTimeFrom
     *
     * @return $this
     */
    public function setDateTimeFrom(\DateTime $dateTimeFrom)
    {
        $this->dateTimeFrom = $dateTimeFrom;

        return $this;
    }

    /**
     * Gets dateTimeTo.
     *
     * @return \DateTime
     */
    public function getDateTimeTo(): \DateTime
    {
        return $this->dateTimeTo;
    }

    /**
     * Sets dateTimeTo.
     *
     * @param \DateTime $dateTimeTo
     *
     * @return $this
     */
    public function setDateTimeTo(\DateTime $dateTimeTo)
    {
        $this->dateTimeTo = $dateTimeTo;

        return $this;
    }

    /**
     * Gets contactDetails.
     *
     * @return SVKAPI\v1\Models\ContactDetails
     */
    public function getContactDetails(): ContactDetails
    {
        return $this->contactDetails;
    }

    /**
     * Sets contactDetails.
     *
     * @param SVKAPI\v1\Models\ContactDetails $contactDetails
     *
     * @return $this
     */
    public function setContactDetails(ContactDetails $contactDetails)
    {
        $this->contactDetails = $contactDetails;

        return $this;
    }

    /**
     * Gets address.
     *
     * @return SVKAPI\v1\Models\Address
     */
    public function getAddress(): Address
    {
        return $this->address;
    }

    /**
     * Sets address.
     *
     * @param SVKAPI\v1\Models\Address $address
     *
     * @return $this
     */
    public function setAddress(Address $address)
    {
        $this->address = $address;

        return $this;
    }

    /**
     * Gets deliveryReferences.
     *
     * @return SVKAPI\v1\Models\Reference[]|null
     */
    public function getDeliveryReferences(): ?array
    {
        return $this->deliveryReferences;
    }

    /**
     * Sets deliveryReferences.
     *
     * @param SVKAPI\v1\Models\Reference[]|null $deliveryReferences
     *
     * @return $this
     */
    public function setDeliveryReferences(array $deliveryReferences = null)
    {
        $this->deliveryReferences = $deliveryReferences;

        return $this;
    }

    /**
     * Gets carrierInstructions.
     *
     * @return string
     */
    public function getCarrierInstructions()
    {
        return $this->carrierInstructions;
    }

    /**
     * Sets carrierInstructions.
     *
     * @param string $carrierInstructions  Description for the carrier at the stop
     *
     * @return $this
     */
    public function setCarrierInstructions($carrierInstructions)
    {
        $this->carrierInstructions = $carrierInstructions;

        return $this;
    }

    /**
     * Gets customs.
     *
     * @return array|null
     */
    public function getCustoms(): ?array
    {
        return $this->customs;
    }

    /**
     * Sets customs.
     *
     * @param array|null $customs
     *
     * @return $this
     */
    public function setCustoms(array $customs = null)
    {
        $this->customs = $customs;

        return $this;
    }
}


