<?php
/**
 * DocumentUpload
 *
 * PHP version 7.1.3
 *
 * @category Class
 * @package  SVKAPI\v1\Models
 * @author   OpenAPI Generator team
 * @link     https://github.com/openapitools/openapi-generator
 */

/**
 * Shipsy
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 1.0
 * 
 * Generated by: https://github.com/openapitools/openapi-generator.git
 *
 */

/**
 * NOTE: This class is auto generated by the openapi generator program.
 * https://github.com/openapitools/openapi-generator
 * Do not edit the class manually.
 */

namespace SVKAPI\v1\Models;

use Symfony\Component\Validator\Constraints as Assert;
use JMS\Serializer\Annotation\Type;
use JMS\Serializer\Annotation\SerializedName;
use JMS\Serializer\Annotation\XmlRoot;
use JMS\Serializer\Annotation\XmlElement;
use JMS\Serializer\Annotation\XmlList;

/**
 * Class representing the DocumentUpload model.
 *
 * @package SVKAPI\v1\Models
 * @author  OpenAPI Generator team
 */
/** @XmlRoot("DocumentUpload") */
class DocumentUpload 
{
        /**
     * The sender of the document
     *
     * @var string
     * @SerializedName("SenderId")
     * @Assert\NotNull()
     * @Assert\Type("string")
     * @Type("string")
     * @XmlElement(cdata=false)
     */
    protected $senderId;

    /**
     * The receiving end of the document
     *
     * @var string
     * @SerializedName("ReceiverId")
     * @Assert\NotNull()
     * @Assert\Type("string")
     * @Type("string")
     * @XmlElement(cdata=false)
     */
    protected $receiverId;

    /**
     * Message identifier used for logging
     *
     * @var string
     * @SerializedName("MessageId")
     * @Assert\NotNull()
     * @Assert\Type("string")
     * @Type("string")
     * @XmlElement(cdata=false)
     */
    protected $messageId;

    /**
     * The ID for the trip
     *
     * @var string
     * @SerializedName("TripId")
     * @Assert\NotNull()
     * @Assert\Type("string")
     * @Type("string")
     * @XmlElement(cdata=false)
     */
    protected $tripId;

    /**
     * The ID for the order
     *
     * @var string
     * @SerializedName("OrderId")
     * @Assert\NotNull()
     * @Assert\Type("string")
     * @Type("string")
     * @XmlElement(cdata=false)
     */
    protected $orderId;

    /**
     * Filename of the document
     *
     * @var string
     * @SerializedName("Filename")
     * @Assert\NotNull()
     * @Assert\Type("string")
     * @Type("string")
     * @XmlElement(cdata=false)
     * @Assert\Length(
     *   max = 255
     * )
     */
    protected $filename;

    /**
     * Document types supported by the API
     *
     * @var string
     * @SerializedName("Type")
     * @Assert\NotNull()
     * @Assert\Choice({ "POD", "BOL" })
     * @Assert\Type("string")
     * @Type("string")
     * @XmlElement(cdata=false)
     */
    protected $type;

    /**
     * A Base64 encoded content of the file, must be between 10 KB and 10 MB in size and in PDF or JPG format
     *
     * @var string
     * @SerializedName("Content")
     * @Assert\NotNull()
     * @Assert\Type("string")
     * @Type("string")
     * @XmlElement(cdata=false)
     * @Assert\Length(
     *   max = 14000000
     * )
     * @Assert\Length(
     *   min = 13000
     * )
     */
    protected $content;

    /**
     * Constructor
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->senderId = isset($data['senderId']) ? $data['senderId'] : null;
        $this->receiverId = isset($data['receiverId']) ? $data['receiverId'] : null;
        $this->messageId = isset($data['messageId']) ? $data['messageId'] : null;
        $this->tripId = isset($data['tripId']) ? $data['tripId'] : null;
        $this->orderId = isset($data['orderId']) ? $data['orderId'] : null;
        $this->filename = isset($data['filename']) ? $data['filename'] : null;
        $this->type = isset($data['type']) ? $data['type'] : null;
        $this->content = isset($data['content']) ? $data['content'] : null;
    }

    /**
     * Gets senderId.
     *
     * @return string
     */
    public function getSenderId()
    {
        return $this->senderId;
    }

    /**
     * Sets senderId.
     *
     * @param string $senderId  The sender of the document
     *
     * @return $this
     */
    public function setSenderId($senderId)
    {
        $this->senderId = $senderId;

        return $this;
    }

    /**
     * Gets receiverId.
     *
     * @return string
     */
    public function getReceiverId()
    {
        return $this->receiverId;
    }

    /**
     * Sets receiverId.
     *
     * @param string $receiverId  The receiving end of the document
     *
     * @return $this
     */
    public function setReceiverId($receiverId)
    {
        $this->receiverId = $receiverId;

        return $this;
    }

    /**
     * Gets messageId.
     *
     * @return string
     */
    public function getMessageId()
    {
        return $this->messageId;
    }

    /**
     * Sets messageId.
     *
     * @param string $messageId  Message identifier used for logging
     *
     * @return $this
     */
    public function setMessageId($messageId)
    {
        $this->messageId = $messageId;

        return $this;
    }

    /**
     * Gets tripId.
     *
     * @return string
     */
    public function getTripId()
    {
        return $this->tripId;
    }

    /**
     * Sets tripId.
     *
     * @param string $tripId  The ID for the trip
     *
     * @return $this
     */
    public function setTripId($tripId)
    {
        $this->tripId = $tripId;

        return $this;
    }

    /**
     * Gets orderId.
     *
     * @return string
     */
    public function getOrderId()
    {
        return $this->orderId;
    }

    /**
     * Sets orderId.
     *
     * @param string $orderId  The ID for the order
     *
     * @return $this
     */
    public function setOrderId($orderId)
    {
        $this->orderId = $orderId;

        return $this;
    }

    /**
     * Gets filename.
     *
     * @return string
     */
    public function getFilename()
    {
        return $this->filename;
    }

    /**
     * Sets filename.
     *
     * @param string $filename  Filename of the document
     *
     * @return $this
     */
    public function setFilename($filename)
    {
        $this->filename = $filename;

        return $this;
    }

    /**
     * Gets type.
     *
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Sets type.
     *
     * @param string $type  Document types supported by the API
     *
     * @return $this
     */
    public function setType($type)
    {
        $this->type = $type;

        return $this;
    }

    /**
     * Gets content.
     *
     * @return string
     */
    public function getContent()
    {
        return $this->content;
    }

    /**
     * Sets content.
     *
     * @param string $content  A Base64 encoded content of the file, must be between 10 KB and 10 MB in size and in PDF or JPG format
     *
     * @return $this
     */
    public function setContent($content)
    {
        $this->content = $content;

        return $this;
    }
}


