<?php
/**
 * StatusExecution
 *
 * PHP version 7.1.3
 *
 * @category Class
 * @package  SVKAPI\v1\Models
 * @author   OpenAPI Generator team
 * @link     https://github.com/openapitools/openapi-generator
 */

/**
 * Shipsy
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 1.0
 * 
 * Generated by: https://github.com/openapitools/openapi-generator.git
 *
 */

/**
 * NOTE: This class is auto generated by the openapi generator program.
 * https://github.com/openapitools/openapi-generator
 * Do not edit the class manually.
 */

namespace SVKAPI\v1\Models;

use Symfony\Component\Validator\Constraints as Assert;
use JMS\Serializer\Annotation\Type;
use JMS\Serializer\Annotation\SerializedName;
use JMS\Serializer\Annotation\XmlRoot;
use JMS\Serializer\Annotation\XmlElement;
use JMS\Serializer\Annotation\XmlList;

/**
 * Class representing the StatusExecution model.
 *
 * @package SVKAPI\v1\Models
 * @author  OpenAPI Generator team
 */
/** @XmlRoot("StatusExecution") */
class StatusExecution 
{
        /**
     * The sender of the status execution
     *
     * @var string
     * @SerializedName("SenderId")
     * @Assert\NotNull()
     * @Assert\Type("string")
     * @Type("string")
     * @XmlElement(cdata=false)
     */
    protected $senderId;

    /**
     * The receiving end of the status execution
     *
     * @var string
     * @SerializedName("ReceiverId")
     * @Assert\NotNull()
     * @Assert\Type("string")
     * @Type("string")
     * @XmlElement(cdata=false)
     */
    protected $receiverId;

    /**
     * Message identifier used for logging
     *
     * @var string
     * @SerializedName("MessageId")
     * @Assert\NotNull()
     * @Assert\Type("string")
     * @Type("string")
     * @XmlElement(cdata=false)
     */
    protected $messageId;

    /**
     * The ID for the trip
     *
     * @var string
     * @SerializedName("TripId")
     * @Assert\NotNull()
     * @Assert\Type("string")
     * @Type("string")
     * @XmlElement(cdata=false)
     */
    protected $tripId;

    /**
     * @var SVKAPI\v1\Models\Status[]
     * @SerializedName("Statuses")
     * @Assert\NotNull()
     * @Assert\Valid()
     * @Assert\All({
     *   @Assert\Type("SVKAPI\v1\Models\Status")
     * })
     * @Type("array<SVKAPI\v1\Models\Status>")
     * @XmlList(inline=false, entry="Status")
     */
    protected $statuses;

    /**
     * Constructor
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->senderId = isset($data['senderId']) ? $data['senderId'] : null;
        $this->receiverId = isset($data['receiverId']) ? $data['receiverId'] : null;
        $this->messageId = isset($data['messageId']) ? $data['messageId'] : null;
        $this->tripId = isset($data['tripId']) ? $data['tripId'] : null;
        $this->statuses = isset($data['statuses']) ? $data['statuses'] : null;
    }

    /**
     * Gets senderId.
     *
     * @return string
     */
    public function getSenderId()
    {
        return $this->senderId;
    }

    /**
     * Sets senderId.
     *
     * @param string $senderId  The sender of the status execution
     *
     * @return $this
     */
    public function setSenderId($senderId)
    {
        $this->senderId = $senderId;

        return $this;
    }

    /**
     * Gets receiverId.
     *
     * @return string
     */
    public function getReceiverId()
    {
        return $this->receiverId;
    }

    /**
     * Sets receiverId.
     *
     * @param string $receiverId  The receiving end of the status execution
     *
     * @return $this
     */
    public function setReceiverId($receiverId)
    {
        $this->receiverId = $receiverId;

        return $this;
    }

    /**
     * Gets messageId.
     *
     * @return string
     */
    public function getMessageId()
    {
        return $this->messageId;
    }

    /**
     * Sets messageId.
     *
     * @param string $messageId  Message identifier used for logging
     *
     * @return $this
     */
    public function setMessageId($messageId)
    {
        $this->messageId = $messageId;

        return $this;
    }

    /**
     * Gets tripId.
     *
     * @return string
     */
    public function getTripId()
    {
        return $this->tripId;
    }

    /**
     * Sets tripId.
     *
     * @param string $tripId  The ID for the trip
     *
     * @return $this
     */
    public function setTripId($tripId)
    {
        $this->tripId = $tripId;

        return $this;
    }

    /**
     * Gets statuses.
     *
     * @return SVKAPI\v1\Models\Status[]
     */
    public function getStatuses(): array
    {
        return $this->statuses;
    }

    /**
     * Sets statuses.
     *
     * @param SVKAPI\v1\Models\Status[] $statuses
     *
     * @return $this
     */
    public function setStatuses(array $statuses)
    {
        $this->statuses = $statuses;

        return $this;
    }
}


