<?php
/**
 * Trip
 *
 * PHP version 7.1.3
 *
 * @category Class
 * @package  SVKAPI\v1\Models
 * @author   OpenAPI Generator team
 * @link     https://github.com/openapitools/openapi-generator
 */

/**
 * Shipsy
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 1.0
 * 
 * Generated by: https://github.com/openapitools/openapi-generator.git
 *
 */

/**
 * NOTE: This class is auto generated by the openapi generator program.
 * https://github.com/openapitools/openapi-generator
 * Do not edit the class manually.
 */

namespace SVKAPI\v1\Models;

use Symfony\Component\Validator\Constraints as Assert;
use JMS\Serializer\Annotation\Type;
use JMS\Serializer\Annotation\SerializedName;
use JMS\Serializer\Annotation\XmlRoot;
use JMS\Serializer\Annotation\XmlElement;
use JMS\Serializer\Annotation\XmlList;

/**
 * Class representing the Trip model.
 *
 * @package SVKAPI\v1\Models
 * @author  OpenAPI Generator team
 */
/** @XmlRoot("Trip") */
class Trip 
{
        /**
     * The ID for the trip
     *
     * @var string
     * @SerializedName("TripId")
     * @Assert\NotNull()
     * @Assert\Type("string")
     * @Type("string")
     * @XmlElement(cdata=false)
     */
    protected $tripId;

    /**
     * The sender of the trip
     *
     * @var string
     * @SerializedName("SenderId")
     * @Assert\NotNull()
     * @Assert\Type("string")
     * @Type("string")
     * @XmlElement(cdata=false)
     */
    protected $senderId;

    /**
     * The receiving end of the trip
     *
     * @var string
     * @SerializedName("ReceiverId")
     * @Assert\NotNull()
     * @Assert\Type("string")
     * @Type("string")
     * @XmlElement(cdata=false)
     */
    protected $receiverId;

    /**
     * Message identifier used for logging
     *
     * @var string
     * @SerializedName("MessageId")
     * @Assert\NotNull()
     * @Assert\Type("string")
     * @Type("string")
     * @XmlElement(cdata=false)
     */
    protected $messageId;

    /**
     * The ID of the driver assigned to the trip
     *
     * @var int
     * @SerializedName("DriverId")
     * @Assert\NotNull()
     * @Assert\Type("int")
     * @Type("int")
     */
    protected $driverId;

    /**
     * The ID of the vehicle that the driver is using this trip
     *
     * @var int
     * @SerializedName("VehicleId")
     * @Assert\NotNull()
     * @Assert\Type("int")
     * @Type("int")
     */
    protected $vehicleId;

    /**
     * The action that happened.
     *
     * @var string
     * @SerializedName("Action")
     * @Assert\NotNull()
     * @Assert\Type("string")
     * @Type("string")
     * @XmlElement(cdata=false)
     */
    protected $action;

    /**
     * API endpoint to send us status updates
     *
     * @var string
     * @SerializedName("StatusApiEndpoint")
     * @Assert\NotNull()
     * @Assert\Type("string")
     * @Type("string")
     * @XmlElement(cdata=false)
     */
    protected $statusApiEndpoint;

    /**
     * API endpoint to send us documents
     *
     * @var string
     * @SerializedName("PodApiEndpoint")
     * @Assert\NotNull()
     * @Assert\Type("string")
     * @Type("string")
     * @XmlElement(cdata=false)
     */
    protected $podApiEndpoint;

    /**
     * @var SVKAPI\v1\Models\Reference[]|null
     * @SerializedName("TripReferences")
     * @Assert\All({
     *   @Assert\Type("SVKAPI\v1\Models\Reference")
     * })
     * @Type("array<SVKAPI\v1\Models\Reference>")
     * @XmlList(inline=false, entry="Reference")
     */
    protected $tripReferences;

    /**
     * @var SVKAPI\v1\Models\TripGood|null
     * @SerializedName("TripGoods")
     * @Assert\Type("SVKAPI\v1\Models\TripGood")
     * @Type("SVKAPI\v1\Models\TripGood")
     */
    protected $tripGoods;

    /**
     * Carrier Code
     *
     * @var string
     * @SerializedName("CarrierCode")
     * @Assert\NotNull()
     * @Assert\Type("string")
     * @Type("string")
     * @XmlElement(cdata=false)
     */
    protected $carrierCode;

    /**
     * Carrier Name
     *
     * @var string
     * @SerializedName("CarrierName")
     * @Assert\NotNull()
     * @Assert\Type("string")
     * @Type("string")
     * @XmlElement(cdata=false)
     */
    protected $carrierName;

    /**
     * Instructions for the carrier for the whole trip
     *
     * @var string
     * @SerializedName("CarrierInstructions")
     * @Assert\NotNull()
     * @Assert\Type("string")
     * @Type("string")
     * @XmlElement(cdata=false)
     */
    protected $carrierInstructions;

    /**
     * Additional conditions that concern the whole trip
     *
     * @var string
     * @SerializedName("AdditionalConditions")
     * @Assert\NotNull()
     * @Assert\Type("string")
     * @Type("string")
     * @XmlElement(cdata=false)
     */
    protected $additionalConditions;

    /**
     * @var SVKAPI\v1\Models\Order[]
     * @SerializedName("Orders")
     * @Assert\NotNull()
     * @Assert\Valid()
     * @Assert\All({
     *   @Assert\Type("SVKAPI\v1\Models\Order")
     * })
     * @Type("array<SVKAPI\v1\Models\Order>")
     * @XmlList(inline=false, entry="Order")
     */
    protected $orders;

    /**
     * Constructor
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->tripId = isset($data['tripId']) ? $data['tripId'] : null;
        $this->senderId = isset($data['senderId']) ? $data['senderId'] : null;
        $this->receiverId = isset($data['receiverId']) ? $data['receiverId'] : null;
        $this->messageId = isset($data['messageId']) ? $data['messageId'] : null;
        $this->driverId = isset($data['driverId']) ? $data['driverId'] : null;
        $this->vehicleId = isset($data['vehicleId']) ? $data['vehicleId'] : null;
        $this->action = isset($data['action']) ? $data['action'] : null;
        $this->statusApiEndpoint = isset($data['statusApiEndpoint']) ? $data['statusApiEndpoint'] : null;
        $this->podApiEndpoint = isset($data['podApiEndpoint']) ? $data['podApiEndpoint'] : null;
        $this->tripReferences = isset($data['tripReferences']) ? $data['tripReferences'] : null;
        $this->tripGoods = isset($data['tripGoods']) ? $data['tripGoods'] : null;
        $this->carrierCode = isset($data['carrierCode']) ? $data['carrierCode'] : null;
        $this->carrierName = isset($data['carrierName']) ? $data['carrierName'] : null;
        $this->carrierInstructions = isset($data['carrierInstructions']) ? $data['carrierInstructions'] : null;
        $this->additionalConditions = isset($data['additionalConditions']) ? $data['additionalConditions'] : null;
        $this->orders = isset($data['orders']) ? $data['orders'] : null;
    }

    /**
     * Gets tripId.
     *
     * @return string
     */
    public function getTripId()
    {
        return $this->tripId;
    }

    /**
     * Sets tripId.
     *
     * @param string $tripId  The ID for the trip
     *
     * @return $this
     */
    public function setTripId($tripId)
    {
        $this->tripId = $tripId;

        return $this;
    }

    /**
     * Gets senderId.
     *
     * @return string
     */
    public function getSenderId()
    {
        return $this->senderId;
    }

    /**
     * Sets senderId.
     *
     * @param string $senderId  The sender of the trip
     *
     * @return $this
     */
    public function setSenderId($senderId)
    {
        $this->senderId = $senderId;

        return $this;
    }

    /**
     * Gets receiverId.
     *
     * @return string
     */
    public function getReceiverId()
    {
        return $this->receiverId;
    }

    /**
     * Sets receiverId.
     *
     * @param string $receiverId  The receiving end of the trip
     *
     * @return $this
     */
    public function setReceiverId($receiverId)
    {
        $this->receiverId = $receiverId;

        return $this;
    }

    /**
     * Gets messageId.
     *
     * @return string
     */
    public function getMessageId()
    {
        return $this->messageId;
    }

    /**
     * Sets messageId.
     *
     * @param string $messageId  Message identifier used for logging
     *
     * @return $this
     */
    public function setMessageId($messageId)
    {
        $this->messageId = $messageId;

        return $this;
    }

    /**
     * Gets driverId.
     *
     * @return int
     */
    public function getDriverId()
    {
        return $this->driverId;
    }

    /**
     * Sets driverId.
     *
     * @param int $driverId  The ID of the driver assigned to the trip
     *
     * @return $this
     */
    public function setDriverId($driverId)
    {
        $this->driverId = $driverId;

        return $this;
    }

    /**
     * Gets vehicleId.
     *
     * @return int
     */
    public function getVehicleId()
    {
        return $this->vehicleId;
    }

    /**
     * Sets vehicleId.
     *
     * @param int $vehicleId  The ID of the vehicle that the driver is using this trip
     *
     * @return $this
     */
    public function setVehicleId($vehicleId)
    {
        $this->vehicleId = $vehicleId;

        return $this;
    }

    /**
     * Gets action.
     *
     * @return string
     */
    public function getAction()
    {
        return $this->action;
    }

    /**
     * Sets action.
     *
     * @param string $action  The action that happened.
     *
     * @return $this
     */
    public function setAction($action)
    {
        $this->action = $action;

        return $this;
    }

    /**
     * Gets statusApiEndpoint.
     *
     * @return string
     */
    public function getStatusApiEndpoint()
    {
        return $this->statusApiEndpoint;
    }

    /**
     * Sets statusApiEndpoint.
     *
     * @param string $statusApiEndpoint  API endpoint to send us status updates
     *
     * @return $this
     */
    public function setStatusApiEndpoint($statusApiEndpoint)
    {
        $this->statusApiEndpoint = $statusApiEndpoint;

        return $this;
    }

    /**
     * Gets podApiEndpoint.
     *
     * @return string
     */
    public function getPodApiEndpoint()
    {
        return $this->podApiEndpoint;
    }

    /**
     * Sets podApiEndpoint.
     *
     * @param string $podApiEndpoint  API endpoint to send us documents
     *
     * @return $this
     */
    public function setPodApiEndpoint($podApiEndpoint)
    {
        $this->podApiEndpoint = $podApiEndpoint;

        return $this;
    }

    /**
     * Gets tripReferences.
     *
     * @return SVKAPI\v1\Models\Reference[]|null
     */
    public function getTripReferences(): ?array
    {
        return $this->tripReferences;
    }

    /**
     * Sets tripReferences.
     *
     * @param SVKAPI\v1\Models\Reference[]|null $tripReferences
     *
     * @return $this
     */
    public function setTripReferences(array $tripReferences = null)
    {
        $this->tripReferences = $tripReferences;

        return $this;
    }

    /**
     * Gets tripGoods.
     *
     * @return SVKAPI\v1\Models\TripGood|null
     */
    public function getTripGoods(): ?TripGood
    {
        return $this->tripGoods;
    }

    /**
     * Sets tripGoods.
     *
     * @param SVKAPI\v1\Models\TripGood|null $tripGoods
     *
     * @return $this
     */
    public function setTripGoods(TripGood $tripGoods = null)
    {
        $this->tripGoods = $tripGoods;

        return $this;
    }

    /**
     * Gets carrierCode.
     *
     * @return string
     */
    public function getCarrierCode()
    {
        return $this->carrierCode;
    }

    /**
     * Sets carrierCode.
     *
     * @param string $carrierCode  Carrier Code
     *
     * @return $this
     */
    public function setCarrierCode($carrierCode)
    {
        $this->carrierCode = $carrierCode;

        return $this;
    }

    /**
     * Gets carrierName.
     *
     * @return string
     */
    public function getCarrierName()
    {
        return $this->carrierName;
    }

    /**
     * Sets carrierName.
     *
     * @param string $carrierName  Carrier Name
     *
     * @return $this
     */
    public function setCarrierName($carrierName)
    {
        $this->carrierName = $carrierName;

        return $this;
    }

    /**
     * Gets carrierInstructions.
     *
     * @return string
     */
    public function getCarrierInstructions()
    {
        return $this->carrierInstructions;
    }

    /**
     * Sets carrierInstructions.
     *
     * @param string $carrierInstructions  Instructions for the carrier for the whole trip
     *
     * @return $this
     */
    public function setCarrierInstructions($carrierInstructions)
    {
        $this->carrierInstructions = $carrierInstructions;

        return $this;
    }

    /**
     * Gets additionalConditions.
     *
     * @return string
     */
    public function getAdditionalConditions()
    {
        return $this->additionalConditions;
    }

    /**
     * Sets additionalConditions.
     *
     * @param string $additionalConditions  Additional conditions that concern the whole trip
     *
     * @return $this
     */
    public function setAdditionalConditions($additionalConditions)
    {
        $this->additionalConditions = $additionalConditions;

        return $this;
    }

    /**
     * Gets orders.
     *
     * @return SVKAPI\v1\Models\Order[]
     */
    public function getOrders(): array
    {
        return $this->orders;
    }

    /**
     * Sets orders.
     *
     * @param SVKAPI\v1\Models\Order[] $orders
     *
     * @return $this
     */
    public function setOrders(array $orders)
    {
        $this->orders = $orders;

        return $this;
    }
}


