<?php
namespace SVKAPI\v1\Mappings;

use SVKAPI\v1\Exceptions\InvalidXMLException;
use SVKAPI\v1\Interfaces\OutputInterface;
use SVKAPI\v1\Models\Trip;
use JMS\Serializer\Handler\HandlerRegistry;
use JMS\Serializer\SerializerBuilder;
use JMS\Serializer\Handler\DateHandler;

class XmlOutput implements OutputInterface
{
    /**
     * @var string
     */
    private $output = '';

    /**
     * @param Trip $model
     * @return $this
     */
    public function generate(Trip $model): OutputInterface
    {
        $serializer = SerializerBuilder::create()->configureHandlers(function(HandlerRegistry $registry) {
            $registry->registerSubscribingHandler(new DateHandler(\DateTime::ATOM, 'UTC', false));
        })->build();
        $this->output = $serializer->serialize($model, 'xml');

        $xml = \XMLReader::XML($this->output);
        $xml->setParserProperty(\XMLReader::VALIDATE, true);
        if (!$xml->isValid()) {
            throw new InvalidXMLException('Generate XML is not valid: ' . $this->output);
        }
        return $this;
    }

    /**
     * @return string
     */
    public function getOutput(): string
    {
        return $this->output;
    }
}
