<?php
	class FlipkartEDIServices
	{
		public $shiftId;
		private $CI;
		private $returnOrderTypeId = '16';

		public function __construct()
		{
			$this->CI = &get_instance();
			$this->CI->load->model(['common', 'apis/FlipkartEDIModel', 'completedordersmodel', 'Singlestatusmodel', 'Order']);
			$this->CI->load->library(['Edi_logger','knlogin']);
			$this->CI->load->helper('user_helper');
			$this->CI->load->library('uuid');
		}

		public function triggerDelhiveryAPI(int $shiftId): int
		{
			$this->shiftId = $shiftId;
			if ($this->checkWareHouse() !== 1) {
				return 0;
			}
			return 1;
		}
		
		public function generateToken(): void
		{
		    $url = $username = $password = '';
		    $this->CI->db->select('domain, url, username, password')
                ->from('int_cred')
                ->where_in('domain', ['FLIPKART', 'BLUEDART', 'INSTAKART', 'BLUEDART OTM', 'SAFEEXPRESS'])
                ->where('status', 1);
            
            $authCredentails = $this->CI->db->get()->result_array();
            
		    if (! empty($authCredentails)) 
		    {
		        foreach ($authCredentails as $credentials) 
		        {
		            $domain = $credentials['domain'];
					$url = $credentials['url'];
					$username = $credentials['username'];
					$password = $credentials['password'];
		        
        			$message     = '';
        			$response    = '';
        			$authData = '';
        			$type = '';
        			$header = [];
        			
        			if($domain == "FLIPKART" || $domain == "INSTAKART"){
            			$credentials = [
            				"userName" => $username,
            				"password" => $password,
            			];
            			$authData = json_encode($credentials);
            			$header = ['Content-Type: application/json'];
            			$type = 'POST';
        			}
        			if ($domain == "BLUEDART" || $domain == "BLUEDART OTM") {
                        $authData = '';
                        $header = [
                            'ClientID: ' . $username,     
                            'clientSecret: ' . $password,  
                            'Content-Type: application/json'
                        ];
                        $type = 'GET';
                    }
                    if($domain == "SAFEEXPRESS"){
                        
                        $authToken = base64_encode($username . ':' . $password);

                        
                        $header = [
                            'Content-Type: application/x-www-form-urlencoded',
                            'Authorization: Basic ' . $authToken,
                            'Cookie: XSRF-TOKEN=fa510f94-420e-4793-9dff-1bba0f1d8911'
                        ];
                    
                        $authData = http_build_query([
                            'grant_type' => 'client_credentials'
                        ]);

            			$type = 'POST';
            			$serverURL = $url;
        			}
        			
        			$this->CI->edi_logger->setEdi_request($authData);
        			if($domain != "SAFEEXPRESS"){
        			    $serverURL = $url . 'login';
        			}
        			
        			try {
        				$curl = curl_init();
        				curl_setopt_array($curl, [
        					CURLOPT_URL            => $serverURL,
        					CURLOPT_RETURNTRANSFER => true,
        					CURLOPT_ENCODING       => '',
        					CURLOPT_MAXREDIRS      => 10,
        					CURLOPT_TIMEOUT        => 0,
        					CURLOPT_FOLLOWLOCATION => true,
        					CURLOPT_HTTP_VERSION   => CURL_HTTP_VERSION_1_1,
        					CURLOPT_CUSTOMREQUEST  => $type,
        					CURLOPT_POSTFIELDS     => $authData,
        					CURLOPT_HTTPHEADER     => $header,
        				]);
        			
        				$response = curl_exec($curl);
        				curl_close($curl);
        
        				$apiResponse = json_decode($response, true);
        				
        				log_message('error', "apiResponse:" . json_encode($response));
        			
        				/*if (! empty($apiResponse) && is_array($apiResponse) && (isset($apiResponse['data']) || isset($apiResponse['JWTToken'] || isset($apiResponse['access_token']))) {*/
        				if (! empty($apiResponse) && is_array($apiResponse)) {
        				    if(isset($apiResponse['data'])) {
        				        $apiResponseValue = $apiResponse['data'];
        				    }
        				    if(isset($apiResponse['JWTToken'])) {
        				        $apiResponseValue = $apiResponse['JWTToken'];
        				    }
        				    if(isset($apiResponse['access_token'])) {
        				        $apiResponseValue = $apiResponse['access_token'];
        				    }
        				    //$apiResponseValue = $apiResponse['data'] ?? $apiResponse['JWTToken'];
        					$isUpdate = $this->CI->common->gettblrowdata(['token_for' => $domain, 'status' => 1], "id", "tb_auth_tokens", 0, 0);
        					if (! empty($isUpdate)) {
        						$status = $this->CI->common->updatetbledata("tb_auth_tokens", ['auth_token' => $apiResponseValue, 'updated_on' => date('Y-m-d H:i:s')], ['id' => $isUpdate['id']]);
        					} else {
        						$status = $this->CI->common->insertTableData("tb_auth_tokens", [
        							'auth_token' => $apiResponseValue,
        							'created_on' => date('Y-m-d H:i:s'),
        							'updated_on' => date('Y-m-d H:i:s'),
        							'token_for'  => $domain,
        							'status'     => 1,
        						]);
        					}
        					if ($status) {
        						log_message('error', "{$domain} Carrier Token generated successfully @ " . gmdate('d-m-Y H:i:00'));
        					}
        				} else {
        					log_message('error',"Unable to generate {$domain} Token @ " . gmdate('d-m-Y H:i:00'));
        				}
        			} catch (Exception $e) {
        				$message = 'Error: ' . $e->getMessage();
        			}
		        }
			}
		}

		public function generateFlipkartToken(): void
		{
			$message     = '';
			$response    = '';
			$credentials = [
				"userName" => FLIPKART_LOGIN_USERNAME,
				"password" => FLIPKART_LOGIN_PASSWORD,
			];
			$authData = json_encode($credentials);
			$this->CI->edi_logger->setEdi_request($authData);
			$serverURL = FLIPKART_SERVER_BASE_URL . 'login';
			$companyCode = $this->CI->session->userdata('company_code');
		    $branchCode = $this->CI->session->userdata('branch_code');
            $userId = $this->CI->session->userdata('user_id') ?? 0;
			//log_message('error', "FLIPKART Carrier for {$serverURL} Payload credentials => {$authData}");
			try {
				$curl = curl_init();
				curl_setopt_array($curl, [
					CURLOPT_URL            => $serverURL,
					CURLOPT_RETURNTRANSFER => true,
					CURLOPT_ENCODING       => '',
					CURLOPT_MAXREDIRS      => 10,
					CURLOPT_TIMEOUT        => 0,
					CURLOPT_FOLLOWLOCATION => true,
					CURLOPT_HTTP_VERSION   => CURL_HTTP_VERSION_1_1,
					CURLOPT_CUSTOMREQUEST  => 'POST',
					CURLOPT_POSTFIELDS     => $authData,
					CURLOPT_HTTPHEADER     => ['Content-Type: application/json'],
				]);
				log_message('error', "cURL Request URL: $serverURL");
				//log_message('error', "cURL Request Body: " . $authData);
				$response = curl_exec($curl);
				//log_message('error', "Respnse:" . json_encode($response));
				curl_close($curl);

				$apiResponse = json_decode($response, true);
				log_message('error', "ApiResponseLoginToken:" . json_encode($apiResponse));
				if (! empty($apiResponse) && is_array($apiResponse) && isset($apiResponse['data'])) {
					$isUpdate = $this->CI->common->gettblrowdata(['token_for' => 'FLIPKART', 'status' => 1], "id", "tb_auth_tokens", 0, 0);
					if (! empty($isUpdate)) {
						$status = $this->CI->common->updatetbledata("tb_auth_tokens", ['auth_token' => $apiResponse['data'], 'updated_on' => date('Y-m-d H:i:s')], ['id' => $isUpdate['id']]);
					} else {
						$status = $this->CI->common->insertTableData("tb_auth_tokens", [
							'auth_token' => $apiResponse['data'],
							'created_on' => date('Y-m-d H:i:s'),
							'updated_on' => date('Y-m-d H:i:s'),
							'token_for'  => 'FLIPKART',
							'status'     => 1,
						]);
					}
					if ($status) {
						log_message('error', "FLIPKART Carrier Token generated successfully @ " . gmdate('d-m-Y H:i:00'));
					}
				} else {
					log_message('error', 'Unable to generate Flipkart Token @ ' . gmdate('d-m-Y H:i:00'));
				}
			} catch (Exception $e) {
				$message = 'Error: ' . $e->getMessage();
			} finally {
				$this->CI->edi_logger->setEdi_type(1);
				$this->CI->edi_logger->setTransaction_id(time());
				$this->CI->edi_logger->setEdi_name('FLIPKART');
				$this->CI->edi_logger->setBounded_type(1);
				$this->CI->edi_logger->setCompany_code($companyCode);
				$this->CI->edi_logger->setBranch_code($branchCode);
				//log_message("error","userId1:".$userId);
				$this->CI->edi_logger->setUser_id($userId);
				$this->CI->edi_logger->setEdi_format_type('JSON');
				$this->CI->edi_logger->setStatus(((isset($apiResponse['data']) && $apiResponse['data']) ? 1 : 0));
				$this->CI->edi_logger->setEdi_response(json_encode($response));
				$this->CI->edi_logger->setObj_type_name('FLIPKART CARRIER Auth Token Generation');
				$this->CI->edi_logger->saveToEdiLogs();
			}
		}

		public function getDocketNo(): string
		{
			$message     = '';
			$response    = '';
			$docketNo    = '';
			$authDetails = $this->CI->common->gettblrowdata(['token_for' => 'FLIPKART', 'status' => 1], "auth_token", "tb_auth_tokens", 0, 0);
			//log_message('error', "cURL Request URL:" . json_encode($authDetails));
			$authToken = $authDetails['auth_token'];
			$serverURL = FLIPKART_SERVER_BASE_URL . 'dkts/SUR/1';
			$companyCode = $this->CI->session->userdata('company_code');
		    $branchCode = $this->CI->session->userdata('branch_code');
            $userId = $this->CI->session->userdata('user_id') ?? 0;
			//log_message('error', "FLIPKART Carrier for {$serverURL} Payload credentials => {$authToken}");
			try {
				$curl = curl_init();
				curl_setopt_array($curl, [
					CURLOPT_URL            => $serverURL,
					CURLOPT_RETURNTRANSFER => true,
					CURLOPT_ENCODING       => '',
					CURLOPT_MAXREDIRS      => 10,
					CURLOPT_TIMEOUT        => 0,
					CURLOPT_FOLLOWLOCATION => true,
					CURLOPT_HTTP_VERSION   => CURL_HTTP_VERSION_1_1,
					CURLOPT_CUSTOMREQUEST  => 'GET',
					CURLOPT_POSTFIELDS     => '',
					CURLOPT_HTTPHEADER     => [
						'Content-Type: application/json',
						"Authorization: Bearer $authToken",
					],
				]);
				//log_message('error', "cURL Request URL: $serverURL");
				$response = curl_exec($curl);
				//log_message('error', "Respnse:" . json_encode($response));
				curl_close($curl);

				$apiResponse = json_decode($response, true);
				//log_message('error', "ApiResponseDocket:" . json_encode($apiResponse));
				if (! empty($apiResponse) && is_array($apiResponse) && isset($apiResponse['data'])) {
					$docketNo = $apiResponse['data'][0];
				} else {
					log_message('error', 'Unable to generate Flipkart Docket No @ ' . gmdate('d-m-Y H:i:00'));
				}
			} catch (Exception $e) {
				$message = 'Error: ' . $e->getMessage();
			}
			finally {
				$this->CI->edi_logger->setEdi_type(1);
				$this->CI->edi_logger->setTransaction_id(time());
				$this->CI->edi_logger->setEdi_name('FLIPKART CARRIER Docket Generation');
				$this->CI->edi_logger->setBounded_type(1);
				$this->CI->edi_logger->setCompany_code($companyCode);
				$this->CI->edi_logger->setBranch_code($branchCode);
				//log_message("error","userId2:".$userId);
				$this->CI->edi_logger->setUser_id($userId);
				$this->CI->edi_logger->setEdi_format_type('JSON');
				$this->CI->edi_logger->setStatus(((isset($apiResponse['data']) && $apiResponse['data']) ? 1 : 0));
				$this->CI->edi_logger->setEdi_response(json_encode($response));
				$this->CI->edi_logger->setObj_type_name('FLIPKART CARRIER Docket Generation');
				$this->CI->edi_logger->saveToEdiLogs();
			}
			return $docketNo;
		}
		
		public function createOrder(array $createOrderRequest): array
		{
		    //log_message("error","createOrderRequest:".json_encode($createOrderRequest));
			$message     = '';
			$response    = '';
			$docketNo    = '';
			$apiResponse = [];
			$authDetails = $this->CI->common->gettblrowdata(['token_for' => 'FLIPKART', 'status' => 1], "auth_token", "tb_auth_tokens", 0, 0);
			log_message('error', "cURL Request URL:" . json_encode($authDetails));
			$authToken = $authDetails['auth_token'];
			$serverURL = FLIPKART_SERVER_BASE_URL . 'order/create';
			$poNumber = $createOrderRequest['poNumber'] ?? null;
            //log_message("error", "Resolved poNumber: " . $poNumber);
            
            // Proceed only if poNumber is not null
            $chk_qry_order = [];
            if (!empty($poNumber)) {
                $chk_qry_order = $this->CI->db
                    ->get_where('tb_orders', ['order_id' => $poNumber])
                    ->row_array();
                //log_message("error", "orderStatusQry1111: " . $this->CI->db->last_query());
            } 
            // Fallback to order values if session is empty
            $userId = ($this->CI->session->userdata('user_id') ? $this->CI->session->userdata('user_id') : ($chk_qry_order['user_id'] ?? null));
            $companyCode = ($this->CI->session->userdata('company_code') ? $this->CI->session->userdata('company_code') : ($chk_qry_order['company_code'] ?? null));
            $branchCode = ($this->CI->session->userdata('branch_code') ? $this->CI->session->userdata('branch_code') : ($chk_qry_order['branch_code'] ?? null));
			//log_message('error', "FLIPKART Carrier for {$serverURL} Payload credentials => {$authToken}");
			//log_message('error', "Request:" . json_encode($createOrderRequest));
			try {
				$curl = curl_init();
				curl_setopt_array($curl, [
					CURLOPT_URL            => $serverURL,
					CURLOPT_RETURNTRANSFER => true,
					CURLOPT_ENCODING       => '',
					CURLOPT_MAXREDIRS      => 10,
					CURLOPT_TIMEOUT        => 0,
					CURLOPT_FOLLOWLOCATION => true,
					CURLOPT_HTTP_VERSION   => CURL_HTTP_VERSION_1_1,
					CURLOPT_CUSTOMREQUEST  => 'POST',
					CURLOPT_POSTFIELDS     => json_encode($createOrderRequest),
					CURLOPT_HTTPHEADER     => [
						'Content-Type: application/json',
						"Authorization: Bearer $authToken",
					],
				]);
				//log_message('error', "cURL Request URL: $serverURL");
				$response = curl_exec($curl);
				log_message('error', "Response:" . json_encode($response));
				curl_close($curl);

				// Decode the JSON
				
				$apiResponse = json_decode($response, true);
				
				// Check for successful response
				if ($apiResponse['status'] && isset($apiResponse['data'])) {
					$docketUrl = $apiResponse['data']['docketPdfLink'];
					
					$labelUrl = $apiResponse['data']['labelsLink'];
				
					// Specify the folder where files will be saved
					$saveFolder = "./assets/poduploads/"; // Make sure this folder exists and is writable
				
					// Extract file names from URLs
					//$docketFileName = basename(parse_url($docketUrl, PHP_URL_QUERY));
					//$labelFileName = basename(parse_url($labelUrl, PHP_URL_QUERY));
					// Step 1: Parse query string
					
					// Step 2: Get the value of 'image'
					
					// Step 3: Extract extension
					
					if($docketUrl != null)
					{
				        parse_str(parse_url($docketUrl, PHP_URL_QUERY), $queryParams);
				        $imageDocketPath = $queryParams['image'] ?? '';
				        $docketExtension = pathinfo($imageDocketPath, PATHINFO_EXTENSION);
				        $docketFileName =  $apiResponse['data']['poNumber'] . '_' . $apiResponse['data']['docketNo'] . '_Docket.' . $docketExtension;
				        $docketFilePath = $saveFolder . $docketFileName;
    					// Download and save docket PDF
    					file_put_contents($docketFilePath, file_get_contents($docketUrl));
					}
					
					if($labelUrl != null)
					{
				        parse_str(parse_url($labelUrl, PHP_URL_QUERY), $queryParams);
    					// Step 2: Get the value of 'image'
    					$imageLabelPath = $queryParams['image'] ?? '';
    					// Step 3: Extract extension
    					$labelExtension = pathinfo($imageLabelPath, PATHINFO_EXTENSION);
    					
    					$labelFileName =  $apiResponse['data']['poNumber'] . '_' . $apiResponse['data']['docketNo'] . '_Label.' . $labelExtension;
    					// Full path where files will be saved
    					
    					$labelFilePath = $saveFolder . $labelFileName;
    					// Download and save label PDF
    					file_put_contents($labelFilePath, file_get_contents($labelUrl));
					}
				
				} 
				$trackRequest = (array)$trackNo;
				
			} catch (Exception $e) {
				$message = 'Error: ' . $e->getMessage();
			}
			finally {
				$this->CI->edi_logger->setEdi_type(1);
				$this->CI->edi_logger->setTransaction_id(time());
				$this->CI->edi_logger->setEdi_name('FLIPKART CARRIER Order Request');
				$this->CI->edi_logger->setBounded_type(1);
				$this->CI->edi_logger->setCompany_code($companyCode);
				$this->CI->edi_logger->setBranch_code($branchCode);
				$this->CI->edi_logger->setUser_id($userId);
				$this->CI->edi_logger->setEdi_format_type('JSON');
				$this->CI->edi_logger->setStatus(((isset($apiResponse['data']) && $apiResponse['data']) ? 1 : 0));
				$this->CI->edi_logger->setEdi_request(json_encode($createOrderRequest));
				$this->CI->edi_logger->setEdi_response(json_encode($response));
				$this->CI->edi_logger->setObj_type_name('FLIPKART CARRIER Order Request');
				$this->CI->edi_logger->saveToEdiLogs();
			}

			return $apiResponse;
		}
		
		public function getOrderDetails(string $startDate, string $endDate): array
		{
			$message     = '';
			$response    = '';
			$docketNo    = '';
			$authDetails = $this->CI->common->gettblrowdata(['token_for' => 'FLIPKART', 'status' => 1], "auth_token", "tb_auth_tokens", 0, 0);
			//log_message('error', "cURL Request URL:" . json_encode($authDetails));
			$authToken = $authDetails['auth_token'];
			$serverURL = FLIPKART_SERVER_BASE_URL . 'order/list/'.$startDate.'/'.$endDate;
			$companyCode = $this->CI->session->userdata('company_code');
		    $branchCode = $this->CI->session->userdata('branch_code');
            $userId = $this->CI->session->userdata('user_id');
			//log_message('error', "FLIPKART Carrier for {$serverURL} Payload credentials => {$authToken}");
			try {
				$curl = curl_init();
				curl_setopt_array($curl, [
					CURLOPT_URL            => $serverURL,
					CURLOPT_RETURNTRANSFER => true,
					CURLOPT_ENCODING       => '',
					CURLOPT_MAXREDIRS      => 10,
					CURLOPT_TIMEOUT        => 0,
					CURLOPT_FOLLOWLOCATION => true,
					CURLOPT_HTTP_VERSION   => CURL_HTTP_VERSION_1_1,
					CURLOPT_CUSTOMREQUEST  => 'GET',
					CURLOPT_POSTFIELDS     => '',
					CURLOPT_HTTPHEADER     => [
						'Content-Type: application/json',
						"Authorization: Bearer $authToken",
					],
				]);
				//log_message('error', "cURL Request URL: $serverURL");
				$response = curl_exec($curl);
				//log_message('error', "Response:" . json_encode($response));
				curl_close($curl);

				$apiResponse = json_decode($response, true);
				//log_message('error', "ApiResponseGetOrderDetails:" . json_encode($apiResponse));
				if ($apiResponse['status'] && isset($apiResponse['data'])) {
					$dataList = $apiResponse['data'];
					log_message('error', 'dataList'.json_encode($dataList));
					// Loop through eventList and print details
					foreach ($dataList as $data) {
						$orderId = $data['poNumber'];
						$dimensionsUom = $data['packetLbhUom'];
						$deliveredDate = $data['deliveryAppointmentDate'];
						$dt    = date('Y-m-d H:i:s');
						if ($orderId<>"")
						{
						    $chk_qry_order = $this->CI->db->get_where('tb_orders', ['order_id' => $orderId])->row_array();
                			//log_message("error","orderStatusQry1111:".$this->CI->db->last_query());
                            $id = $chk_qry_order['id'];
                            $userId = $chk_qry_order['user_id'];
                            $companyCode = $chk_qry_order['company_code'];
                            $branchCode = $chk_qry_order['branch_code'];
                            //log_message('error', 'deliveredDate:'.$deliveredDate);
						    if ($deliveredDate && $deliveredDate<>null && $deliveredDate<>"")
						    {
						        $deliveryTimeSlot  = $data['deliveryTimeSlot'];
						        $baseDate = DateTime::createFromFormat('d-m-Y', $deliveredDate)->format('Y-m-d');
                                list($startHour, $endHour) = explode('-', $deliveryTimeSlot);
                                $startDateTime = $baseDate . ' ' . str_pad($startHour, 2, '0', STR_PAD_LEFT) . ':00:00';
                                $endDateTime   = $baseDate . ' ' . str_pad($endHour, 2, '0', STR_PAD_LEFT) . ':00:00';
                                $timeZone = $this->CI->Standardbookingmodel->getUserTimeZone($chk_qry_order['user_id']);
						        $getactual = getdatetimebytimezone(DFLT_TZ, $startDateTime, $timeZone);
                                $startDateTime = $getactual['datetime'];
						        $getactualend = getdatetimebytimezone(DFLT_TZ, $endDateTime, $timeZone);
                                $endDateTime = $getactualend['datetime'];
    							//log_message('error', 'orderId:'.$orderId);
    							$upd = $this->CI->db->where(['order_id' => $orderId])->update("tb_orders", ['delivery_datetime' => $startDateTime, 'drop_endtime' => $endDateTime, 'updatedon'   => $dt]);
    							//log_message("error","orderStatusQry1111:".$this->CI->db->last_query());
    							$shipmentDetails = $this->CI->common->gettblrowdata(['order_id' => $orderId, 'status' => 1], "shipmentid", "tb_orders", 0, 0);
    							//log_message('error', "cURL Request URL:" . json_encode($shipmentDetails));
    							$shipmentId = $shipmentDetails['shipmentid'];
    							$updShipment = $this->CI->db->where(['shipmentid' => $shipmentId])->update("tb_shifts", ['enddate' => $endDateTime, 'updated_on'   => $dt]);
    							/*$chk_qry = $this->CI->db->select("id")->get_where('tb_shifts', ['shipmentid' => $shipmentId]);
    							if ($chk_qry->num_rows() > 0) {
    							    $updTrip = $this->CI->db->where(['shift_id' => $chk_qry['id']])->update("tb_trips", ['etime' => $deliveredDate, 'updated_on'   => $dt]);
    							}*/
    							$chk_qry = $this->CI->db->select("id")->get_where('tb_shifts', ['shipmentid' => $shipmentId])->row_array();
    							if (!empty($chk_qry)) {
                                    $updTrip = $this->CI->db->where(['shift_id' => $chk_qry['id']])->update("tb_trips", [
                                            'etime'      => $endDateTime,
                                            'updated_on' => $dt
                                        ]);
                                }
    						}
    						if (!empty($data['lbhData']) && is_array($data['lbhData'])) {
                                foreach ($data['lbhData'] as $cargo) {
                                    $packetCount = $cargo['packetCount'] ?? 0;
                                    $length = $cargo['packetLength'] ?? 0;
                                    $width = $cargo['packetWidth'] ?? 0;
                                    $height = $cargo['packetHeight'] ?? 0;
                                    $weight = $cargo['actualWeight'] ?? 0;
                                    $refNo = $cargo['customerPacketRefNo'] ?? '';
                            
                                    if (strpos($refNo, '-') !== false) {
                                        [, $cargoId] = explode('-', $refNo, 2);
                                        $volume = $length * $width * $height;
                                        //$dimensionsUom = "IN"; // example input
                                        if (strtoupper($dimensionsUom) === "IN") {
                                            // 1 inch = 2.54 cm
                                            /*$length = $length * 2.54;
                                            $width = $width * 2.54;
                                            $height = $height * 2.54;
                                            $volume = $volume * 2.54;
                                            $dimensionsUom = "CM";*/
                                            $dimensionsUom = "INCHES";
                                            $voldimensionsUom = "CU IN";
                                        }
                                        else
                                        {
                                            $dimensionsUom = "INCHES";
                                            $voldimensionsUom = "CU CM";
                                        }
                                        $weightUnit = "KG";
                            
                                        $updateCargoData = [
                                            'length' => $length,
                                            'width' => $width,
                                            'height' => $height,
                                            'weight' => $weight,
                                            'second_weight' => $weight,
                                            'volumetric_weight' => $weight,
                                            'volume' => $volume,
                                            'second_volume' => $volume,
                                            'quantity' => $packetCount,
                                            'volweight_uom' => $weightUnit,
                                            'updatedon'   => $dt
                                        ];
                                        $updateData = [
                                            'length' => $length,
                                            'width' => $width,
                                            'height' => $height,
                                            'weight' => $weight,
                                            'second_weight' => $weight,
                                            'volumetric_weight' => $weight,
                                            'volume' => $volume,
                                            'second_volume' => $volume,
                                            'quantity' => $packetCount,
                                            'volweight_uom' => $weightUnit,
                                            'updatedon'   => $dt,
                                            'length_unit' => $dimensionsUom,
                                            'width_unit' => $dimensionsUom,
                                            'height_unit' => $dimensionsUom,
                                            'volume_unit' => $voldimensionsUom,
                                            'secondvolume_uom' => $voldimensionsUom,
                                            'weight_unit' => $weightUnit,
                                            'secondweight_uom' => $weightUnit
                                        ];
                            
                                        $this->CI->db->where(['id' => $cargoId])->update('tb_cargo_details', $updateData);
                                        $this->CI->db->where(['order_id' => $id, 'cargo_id' => $cargoId])->update('tb_order_cargodetails', $updateCargoData);
                                    }
                                }
                            }
    						if (!empty($data['invoiceDetails']) && is_array($data['invoiceDetails'])) {
                                foreach ($data['invoiceDetails'] as $invoice) {
                                    $fields = [
                                        'invoiceNo'     => 'IV',
                                        'invoiceDate'   => 'ID',
                                        'invoiceAmount' => 'INV',
                                        'ewbNo'         => 'AWB',
                                        'ewbValidTill'  => 'AWBVD',
                                        'ewbDate'       => 'AWBD'
                                    ];
                            
                                    foreach ($fields as $key => $refCode) {
                                        if (!empty($invoice[$key])) {
                                            $this->CI->Order->updateOrderReference($id, $refCode, $invoice[$key]);
                                        }
                                    }
                                }
                            }
						}
					}
				}
				/*if (! empty($apiResponse) && is_array($apiResponse) && isset($apiResponse['data'])) {
					$docketNo = $apiResponse['data'][0];
				} else {
					log_message('error', 'Unable to generate Flipkart Docket No @ ' . gmdate('d-m-Y H:i:00'));
				}*/
			} catch (Exception $e) {
				$message = 'Error: ' . $e->getMessage();
			}
			finally {
				$this->CI->edi_logger->setEdi_type(1);
				$this->CI->edi_logger->setTransaction_id(time());
				$this->CI->edi_logger->setEdi_name('FLIPKART CARRIER Get Order Details');
				$this->CI->edi_logger->setBounded_type(1);
				$this->CI->edi_logger->setCompany_code($companyCode);
				$this->CI->edi_logger->setBranch_code($branchCode);
				//log_message("error","userId4:".$userId);
				$this->CI->edi_logger->setUser_id($userId);
				$this->CI->edi_logger->setEdi_format_type('JSON');
				$this->CI->edi_logger->setStatus(((isset($apiResponse['data']) && $apiResponse['data']) ? 1 : 0));
				$this->CI->edi_logger->setEdi_request($serverURL);
				$this->CI->edi_logger->setEdi_response(json_encode($response));
				$this->CI->edi_logger->setObj_type_name('FLIPKART CARRIER Get Order Details');
				$this->CI->edi_logger->saveToEdiLogs();
			}
			return $apiResponse;
		}
		
		public function getLiveStatus(): string
        {
            // ---- CRON LOCK (prevents overlap) ----
            $lockFile = APPPATH . 'cache/getLiveStatus.lock';
            if (file_exists($lockFile)) {
                log_message('error', 'getLiveStatus already running');
                return 'already running';
            }
            file_put_contents($lockFile, time());
        
            set_time_limit(0);        // allow long run
            ini_set('memory_limit', '512M');
        
            try {
        
                $userId = [XP_INDIA_USERID, FLIPKART_USERID];
        
                $sql = "
                    SELECT tot.id, tot.customer_id
                    FROM tb_orders tot
                    INNER JOIN tb_vendors tv ON tot.vendor_id = tv.id
                    INNER JOIN tb_stop_status ts ON ts.order_id = tot.id
                    WHERE tv.code IN (?, ?)
                    AND ts.status_code <> 'SV0510'
                    AND tot.status <> 0
                    ORDER BY tot.id
                ";
        
                $getOrderId = $this->CI->db->query($sql, $userId);
        
                if ($getOrderId->num_rows() === 0) {
                    return "no records";
                }
        
                foreach ($getOrderId->result_array() as $order) {
        
                    // ---- TRACK NUMBER ----
                    $trackNo = getorderreftypeinfo('TKN', $order['id']);
                    if (empty($trackNo)) {
                        continue;
                    }
        
                    $trackRequest = (array)$trackNo;
        
                    // ---- CUSTOMER CODE ----
                    $cust_code = '';
                    $cust = $this->CI->common->gettblrowdata(
                        ['id' => $order['customer_id'], 'status' => 1],
                        'code',
                        'tb_customers'
                    );
                    if (!empty($cust)) {
                        $cust_code = $cust['code'];
                    }
        
                    // ---- ONE CARRIER ONLY ----
                    if ($cust_code === XP_INDIA_EATON) {
                        $carrier = 'XP_INDIA_SOUTH';
                    } elseif ($cust_code === XP_INDIA_SIEMENS) {
                        $carrier = 'XP_INDIA_WEST';
                    } else {
                        $carrier = 'FLIPKART';
                    }
        
                    // ---- CALL API (SAFE) ----
                    $this->getTracking($trackRequest, (int)$order['id'], $carrier);
        
                    // ---- THROTTLE (VERY IMPORTANT) ----
                    usleep(300000); // 0.3 sec
                }
        
            } catch (Throwable $e) {
                log_message('error', 'getLiveStatus failed: ' . $e->getMessage());
            } finally {
                unlink($lockFile);
            }
        
            return "success";
        }

		
		/*public function getLiveStatus(): string
		{
		    $userId = [XP_INDIA_USERID, FLIPKART_USERID]; 
		    $sql = "SELECT tot.id AS id, tot.customer_id AS customer_id FROM tb_orders tot INNER JOIN tb_vendors tv ON tot.vendor_id = tv.id INNER JOIN tb_stop_status ts ON ts.order_id = tot.id WHERE tv.code IN (?, ?) AND ts.status_code <> 'SV0510' AND tot.status <> 0 ORDER BY tot.id"; 
		    $getOrderId = $this->CI->db->query($sql, $userId);
            //log_message("error","QRy000:".$this->CI->db->last_query());
            //log_message("error","QRy:".$this->CI->db->last_query());
            if ( $getOrderId->num_rows() > 0) {
                $orderData =  $getOrderId->result();
                $data = json_decode(json_encode($orderData), true);
                //log_message("error","orderData:".json_encode($orderData));
                foreach ( $data as $order ) {
                    
                    $trackNo = getorderreftypeinfo('TKN', $order['id']);
                    $trackRequest = (array)$trackNo;
                    //$trackRequest = $trackNo;
                    //log_message("error","trackRequest:". $trackRequest);
                    //log_message("error","orderId:". $order['id']);
                    //$trackingData = $this->getTracking($trackRequest, $order['id'], 'XP_INDIA');
                    $getcustomerid = $this->CI->common->gettblrowdata(
                        ['id' => $order['customer_id'], 'status' => '1'],
                        "code",
                        "tb_customers",
                        0,
                        0
                    );
                    //log_message("error","QRy11:".$this->CI->db->last_query());
                    if (! empty($getcustomerid)) {
                        $cust_code = $getcustomerid['code'];
                    }
                    if($cust_code == XP_INDIA_EATON)
                    {
                        $trackingData = $this->getTracking($trackRequest, $order['id'], 'XP_INDIA_SOUTH');
                    }
                    else if($cust_code == XP_INDIA_SIEMENS)
                    {
                        $trackingData = $this->getTracking($trackRequest, $order['id'], 'XP_INDIA_WEST');
                    }
                    $trackingData = $this->getTracking($trackRequest, $order['id'], 'FLIPKART');
                    //log_message("error","trackingData:". json_encode($trackingData));
                }
            }
            return "success";
		}*/
		
		public function getTracking(array $trackRequest, int $id, string $carrier): array
        {
            $apiResponse = [];
            $response    = '';
            $type        = '';
        
            // ---- Fetch order once ----
            $order = $this->CI->db
                ->select('order_id,user_id,company_code,branch_code')
                ->get_where('tb_orders', ['id' => $id])
                ->row_array();
        
            if (empty($order)) {
                return [];
            }
        
            $orderId     = $order['order_id'];
            $userId      = $this->CI->session->userdata('user_id') ?: $order['user_id'];
            $companyCode = $this->CI->session->userdata('company_code') ?: $order['company_code'];
            $branchCode  = $this->CI->session->userdata('branch_code') ?: $order['branch_code'];
        
            // ---- Auth token ----
            $authDetails = $this->CI->common->gettblrowdata(
                ['token_for' => $carrier, 'status' => 1],
                "auth_token",
                "tb_auth_tokens"
            );
        
            if (empty($authDetails['auth_token'])) {
                return [];
            }
        
            $authToken = $authDetails['auth_token'];
        
            try {
        
                /* ================= FLIPKART ================= */
                if ($carrier === "FLIPKART") {
        
                    $type = "JSON";
                    $serverURL = FLIPKART_SERVER_BASE_URL . 'kn/order/track';
        
                    $payload = json_encode(['docketNo' => $trackRequest]);
        
                    $curl = curl_init($serverURL);
                    curl_setopt_array($curl, [
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_POST           => true,
                        CURLOPT_POSTFIELDS     => $payload,
                        CURLOPT_HTTPHEADER     => [
                            'Content-Type: application/json',
                            "Authorization: Bearer $authToken"
                        ],
                        CURLOPT_TIMEOUT        => 20,
                        CURLOPT_CONNECTTIMEOUT => 5
                    ]);
        
                    $response = curl_exec($curl);
        
                    if (curl_errno($curl)) {
                        curl_close($curl);
                        return [];
                    }
        
                    curl_close($curl);
        
                    $apiResponse = json_decode($response, true);
                    if (empty($apiResponse['status']) || empty($apiResponse['data'])) {
                        return [];
                    }
        
                    // ---- POD ----
                    $podImageUrl = $apiResponse['data'][0]['podImageUrl'] ?? '';
                    if (!empty($podImageUrl)) {
                        $podXml = "
                            <SVKDocumentUpload>
                                <SVKHeader>
                                    <SVKSourceApp>{$carrier}</SVKSourceApp>
                                    <SVKDestinationApp>SVKonekt</SVKDestinationApp>
                                </SVKHeader>
                                <SVKAction>POD UPLOADED</SVKAction>
                                <SVKOrderID>{$orderId}</SVKOrderID>
                                <SVKDocumentType>POD</SVKDocumentType>
                                <SVKUploadDetails>
                                    <SVKDocumentName>POD</SVKDocumentName>
                                    <SVKURL>{$podImageUrl}</SVKURL>
                                </SVKUploadDetails>
                            </SVKDocumentUpload>
                        ";
        
                        if ($xml = @simplexml_load_string($podXml)) {
                            $this->getXPPod($xml, $id);
                        }
                    }
        
                    // ---- STATUS ----
                    $statusInput  = '<SVKEDIResponseMessage><SVKEDITransmissionBody><Order>';
                    $statusInput .= '<OrderID>' . $orderId . '</OrderID>';
        
                    foreach ($apiResponse['data'][0]['eventList'] as $status) {
                        $statusInput .= "
                            <Status>
                                <StatusCode>{$status['eventCode']}</StatusCode>
                                <StatusValue>{$status['eventName']}</StatusValue>
                                <StatusType>{$status['eventCode']}</StatusType>
                                <DateTime>{$status['eventTimestamp']}</DateTime>
                                <TimeZone>+00:00</TimeZone>
                                <Location>{$status['eventBranchCity']}, {$status['eventBranchState']}</Location>
                            </Status>";
                    }
        
                    $statusInput .= '</Order></SVKEDITransmissionBody></SVKEDIResponseMessage>';
        
                    if ($xml = @simplexml_load_string($statusInput)) {
                        $this->getStatus($xml, $id, $carrier);
                    }
                }
        
                /* ================= XP INDIA ================= */
                else {
        
                    $type = "XML";
                    $carrier = "XP_INDIA";
                    $serverURL = XP_INDIA_SERVER_BASE_URL . 'kuehne/check/order/status/' . $trackRequest[0];
        
                    $curl = curl_init($serverURL);
                    curl_setopt_array($curl, [
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_HTTPHEADER     => [
                            "Content-Type: application/xml",
                            "AuthToken: $authToken"
                        ],
                        CURLOPT_TIMEOUT        => 20,
                        CURLOPT_CONNECTTIMEOUT => 5
                    ]);
        
                    $response = curl_exec($curl);
        
                    if (!curl_errno($curl) && $response) {
                        $response = preg_replace('/<\?xml.*?\?>/', '', $response);
                        $xml = @simplexml_load_string($response);
                        if ($xml) {
                            $this->getStatus($xml, $id, $carrier);
                        }
                    }
        
                    curl_close($curl);
                }
        
            } catch (Throwable $e) {
                log_message('error', 'getTracking error: ' . $e->getMessage());
            }
        
            // ---- EDI LOGGING ----
            $this->CI->edi_logger->setEdi_type(1);
            $this->CI->edi_logger->setTransaction_id(time());
            $this->CI->edi_logger->setEdi_name($carrier . ' Tracking');
            $this->CI->edi_logger->setBounded_type(1);
            $this->CI->edi_logger->setCompany_code($companyCode);
            $this->CI->edi_logger->setBranch_code($branchCode);
            $this->CI->edi_logger->setUser_id($userId);
            $this->CI->edi_logger->setEdi_format_type($type);
            $this->CI->edi_logger->setStatus(!empty($apiResponse) ? 1 : 0);
            $this->CI->edi_logger->setEdi_request(json_encode($trackRequest));
            $this->CI->edi_logger->setEdi_response(substr($response, 0, 5000));
            $this->CI->edi_logger->saveToEdiLogs();
        
            return $apiResponse;
        }

		
		/*public function getTracking(array $trackRequest, int $id, string $carrier): array
		{
		    //("error","carrier:".$carrier);
		    //log_message("error","trackRequest:".$trackRequest);
			$message     = '';
			$response    = '';
			$docketNo    = '';
			$apiResponse = [];
			$companyCode = $this->CI->session->userdata('company_code');
		    $branchCode = $this->CI->session->userdata('branch_code');
            $userId = $this->CI->session->userdata('user_id');
			$chk_qry_order = $this->CI->db->get_where('tb_orders', ['id' => $id])->row_array();
			//log_message("error","orderStatusQry1111:".$this->CI->db->last_query());
            $orderId = $chk_qry_order['order_id'];
            if($userId == null || $userId == "")
            {
                $userId = $chk_qry_order['user_id'];
            }
            if($companyCode == null || $companyCode == "")
            {
                $companyCode = $chk_qry_order['company_code'];
            }
            if($branchCode == null || $branchCode == "")
            {
                $branchCode = $chk_qry_order['branch_code'];
            }
			$authDetails = $this->CI->common->gettblrowdata(['token_for' => $carrier, 'status' => 1], "auth_token", "tb_auth_tokens", 0, 0);
			//log_message('error', "cURL Request URL:" . json_encode($authDetails));
			$authToken = $authDetails['auth_token'];
			try {
			    if($carrier == "FLIPKART")
    			{
    			    $url = FLIPKART_SERVER_BASE_URL;
    			    $type = "JSON";
    			    $serverURL = $url . 'kn/order/track';
        			//log_message('error', "FLIPKART Carrier for {$serverURL} Payload credentials => {$authToken}");
        			$data = [
        				'docketNo' => $trackRequest
        			];
        			//log_message('error', "Request1111:" . json_encode($data));
        			$curl = curl_init();
				    curl_setopt_array($curl, [
    					CURLOPT_URL            => $serverURL,
    					CURLOPT_RETURNTRANSFER => true,
    					CURLOPT_ENCODING       => '',
    					CURLOPT_MAXREDIRS      => 10,
    					CURLOPT_TIMEOUT        => 0,
    					CURLOPT_FOLLOWLOCATION => true,
    					CURLOPT_HTTP_VERSION   => CURL_HTTP_VERSION_1_1,
    					CURLOPT_CUSTOMREQUEST  => 'POST',
    					CURLOPT_POSTFIELDS     => json_encode($data),
    					CURLOPT_HTTPHEADER     => [
    						'Content-Type: application/json',
    						"Authorization: Bearer $authToken",
    					],
    				]);
    				//log_message('error', "cURL Request URL: $serverURL");
    				$response = curl_exec($curl);
    			
    				curl_close($curl);
    				
    				$data = json_decode($response, true);
    				//log_message('error', "Response11:" . $data['status']);

        			if($data['status'] != 1){
        			    return $apiResponse;
        			}
        			
        			//log_message('error', "Response33:" . json_encode($response));
    			
        			$apiResponse = json_decode($response, true);
    				//log_message('error', "ApiResponseGetStatus:" . json_encode($apiResponse));
    				if ($apiResponse['status'] && isset($apiResponse['data'])) {
    				    $podImageUrl = $apiResponse['data'][0]['podImageUrl'] ?? "";
    				    
    				    $check_array_status = [
        					'order_id'    => $orderId,
        					'status_code' => 'SV0510',
        					'status'      => 1,
        				];
    				    $chk_qry_stop = $this->CI->db->select("id")->get_where('tb_stop_status', $check_array_status);
    				    //log_message('error', "Count:" . $chk_qry_stop->num_rows());
        				if ($chk_qry_stop->num_rows() == 0) {
        				    if (!empty($podImageUrl)) {
                                $podInput  = '<SVKDocumentUpload>';
                                $podInput .= '<SVKHeader>';
                                $podInput .= '<SVKSourceApp>' . $carrier . '</SVKSourceApp>';
                                $podInput .= '<SVKDestinationApp>SVKonekt</SVKDestinationApp>';
                                $podInput .= '</SVKHeader>';
                                $podInput .= '<SVKAction>POD UPLOADED</SVKAction>';
                                $podInput .= '<SVKOrderID>' . $orderId . '</SVKOrderID>';
                                $podInput .= '<SVKDocumentType>POD</SVKDocumentType>';
                                $podInput .= '<SVKUploadDetails>';
                                $podInput .= '<SVKDocumentName>POD</SVKDocumentName>';
                                $podInput .= '<SVKURL>' . $podImageUrl . '</SVKURL>';
                                $podInput .= '</SVKUploadDetails>';
                                $podInput .= '</SVKDocumentUpload>';
                        
                                $xml = simplexml_load_string($podInput);
                                $res = $this->getXPPod($xml, $id);
                            }
                            
                            $statusList = $apiResponse['data'][0]['eventList'];
                            //log_message('error', "statusList:" . json_encode($statusList));
                            // Build statusInput XML
                            $statusInput  = '<SVKEDIResponseMessage>';
                            $statusInput .= '<SVKEDITransmissionHeader>';
                            $statusInput .= '<EDIVersion>SVK2.0</EDIVersion>';
                            $statusInput .= '<AckSpec><AckOption>SUCCESS</AckOption></AckSpec>';
                            $statusInput .= '<SourceApp>' . $carrier . '</SourceApp>';
                            $statusInput .= '<DestinationApp>SVKONEKT</DestinationApp>';
                            $statusInput .= '<Action>BookingStatusUpdate</Action>';
                            $statusInput .= '</SVKEDITransmissionHeader>';
                            $statusInput .= '<SVKEDITransmissionBody><Order>';
                            $statusInput .= '<OrderID>' . $orderId . '</OrderID>';
                        
                            // Status can be a single item or multiple; normalize it
                            /*$statusList = $eventList['Status'] ?? [];
                            if (isset($statusList['StatusCode'])) {
                                // Single status, wrap in array
                                $statusList = [$statusList];
                            }---------------
                        
                            foreach ($statusList as $status) {
                                $statusCode = $status['eventCode'] ?? '';
                                $statusDateTime = $status['eventTimestamp'] ?? '';
                                $statusValue = $status['eventName'] ?? '';
                                $location = $status['eventBranchCity'] . ", " . $status['eventBranchState'];
                        
                                $statusInput .= '<Status>';
                                $statusInput .= '<StatusCode>' . $statusCode . '</StatusCode>';
                                $statusInput .= '<StatusValue>' . $statusValue . '</StatusValue>';
                                $statusInput .= '<StatusType>' . $statusCode . '</StatusType>';
                                $statusInput .= '<DateTime>' . $statusDateTime . '</DateTime>';
                                $statusInput .= '<TimeZone>+00:00</TimeZone>';
                                $statusInput .= '<Location>' . $location . '</Location>';
                                $statusInput .= '</Status>';
                            }
                        
                            $statusInput .= '</Order></SVKEDITransmissionBody></SVKEDIResponseMessage>';
                            //log_message('error', "statusInput:" . $statusInput);
                        
                            $xml = simplexml_load_string($statusInput);
                            $res = $this->getStatus($xml, $id, $carrier);
        				}
                    }
    			}
    			else if($carrier == "XP_INDIA_SOUTH" || $carrier == "XP_INDIA_WEST")
    			{
    			    $carrier = "XP_INDIA";
    			    $url = XP_INDIA_SERVER_BASE_URL;
    			    $type = "XML";
    			    $serverURL = $url . 'kuehne/check/order/status/' . $trackRequest[0];;
                    //log_message('error', "Request222:" . $serverURL);
                    
                    $curl = curl_init($serverURL);
                    
                    curl_setopt($curl, CURLOPT_HTTPHEADER, [
                        "Content-Type: application/xml",
                        "AuthToken: $authToken"
                    ]);
                    
                    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                    
                    // Execute the request
                    $response = curl_exec($curl);
                    
                    curl_close($curl);
                    $apiResponse = json_decode($response, true);
                    $postData = str_replace('<?xml version="1.0" encoding="utf-16"?>', "", $response);
                    $postData = str_replace(' xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"', "", $postData);
                    
                    // Load XML
                    $xml = simplexml_load_string($postData);
                    if($apiResponse == null){
        			    $apiResponse = [];
        			}
                    $res = 0;
                    //log_message("error","order11:".$orderId);
                    $res = $this->getStatus($xml, $id, $carrier);
    			}
			}catch (Exception $e) {
				$message = 'Error: ' . $e->getMessage();
			}
			finally {
				$this->CI->edi_logger->setEdi_type(1);
				$this->CI->edi_logger->setTransaction_id(time());
				$this->CI->edi_logger->setEdi_name($carrier.' CARRIER Tracking Status');
				$this->CI->edi_logger->setBounded_type(1);
				$this->CI->edi_logger->setCompany_code($companyCode);
				$this->CI->edi_logger->setBranch_code($branchCode);
				//log_message("error","userId5:".$userId);
				$this->CI->edi_logger->setUser_id($userId);
				$this->CI->edi_logger->setEdi_format_type($type);
				$this->CI->edi_logger->setStatus(((isset($apiResponse) && $apiResponse) ? 1 : 0));
				$this->CI->edi_logger->setEdi_request(json_encode($trackRequest));
				$this->CI->edi_logger->setEdi_response(json_encode($response));
				$this->CI->edi_logger->setObj_type_name($carrier.' CARRIER Tracking Status');
				$this->CI->edi_logger->saveToEdiLogs();
			}
			return $apiResponse;
		}*/
	
        public function getXPStatus(string $trackRequest, int $orderId, string $carrier): array
        {
            $message     = '';
            $response    = '';
            $docketNo    = '';
            $parsedData  = [];
            $companyCode = $this->CI->session->userdata('company_code');
		    $branchCode = $this->CI->session->userdata('branch_code');
            $userId = $this->CI->session->userdata('user_id');
            //log_message("error","userId:".$userId);
            $authDetails = $this->CI->common->gettblrowdata(
                ['token_for' => $carrier, 'status' => 1],
                "auth_token",
                "tb_auth_tokens",
                0,
                0
            );
            //log_message("error","orderStatusQry1111:".$this->CI->db->last_query());
            $authToken = $authDetails['auth_token'];
            try{
            if($carrier == "FLIPKART")
			{
			    $url = FLIPKART_SERVER_BASE_URL;
			    $type = "JSON";
			}
			else if($carrier == "XP_INDIA_SOUTH" || $carrier == "XP_INDIA_WEST")
    		{
    			$carrier = "XP_INDIA";
			    $url = XP_INDIA_SERVER_BASE_URL;
			    $type = "XML";
			}
            $serverURL = $url . 'kuehne/check/order/status/' . $trackRequest;
            //log_message('error', "Request222111:" . $serverURL);
            
            $ch = curl_init($serverURL);
            
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                "Content-Type: application/xml",
                "AuthToken: $authToken"
            ]);
            
            //log_message("error","authToken:".$authToken);
            
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            
            // Execute the request
                $response = curl_exec($ch);
                log_message("error","response:".$response);
                $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                
                // Check for errors
                if (curl_errno($ch)) {
                    //echo "cURL Error: " . curl_error($ch);
                } else {
                    /*echo "HTTP Status: $httpCode\n";
                    echo "Response:\n$response\n";*/
                }
                
                curl_close($ch);
                
                
                
                if (!empty($response)) {
                // Clean the XML string
                $postData = str_replace('<?xml version="1.0" encoding="utf-16"?>', "", $response);
                $postData = str_replace(' xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"', "", $postData);
                
                // Load XML
                $xml = simplexml_load_string($postData);
                $res = 0;
                //log_message("error","order11:".$orderId);
                $res = $this->getStatus($xml, $orderId, $carrier);
                }
                
                
               /*log_message("error", "xml:".json_encode($xml));
                
                // Navigate to SVKEDITransmissionBody
                $gLogElement = $xml->xpath('/SVKEDIResponseMessage/SVKEDITransmissionBody');
                log_message("error", "gLogElement:".$gLogElement);
                
                if (!empty($gLogElement)) {
                    // Try to get DocketNumber under OrderDetail
                    $docketNumberNode = $gLogElement[0]->xpath('Order/OrderID');
                
                log_message("error", "docketNumberNode:".$docketNumberNode);
                    
                } else {
                    log_message("error", "SVKEDITransmissionBody not found in XML.");
                }*/
            }catch (Exception $e) {
				$message = 'Error: ' . $e->getMessage();
			}
			finally {
				$this->CI->edi_logger->setEdi_type(1);
				$this->CI->edi_logger->setTransaction_id(time());
				$this->CI->edi_logger->setEdi_name($carrier.' CARRIER Tracking Status');
				$this->CI->edi_logger->setBounded_type(1);
				$this->CI->edi_logger->setCompany_code($companyCode);
				$this->CI->edi_logger->setBranch_code($branchCode);
				//log_message("error","userId6:".$userId);
				$this->CI->edi_logger->setUser_id($userId);
				$this->CI->edi_logger->setEdi_format_type($type);
				$this->CI->edi_logger->setStatus(((isset($xml) && $xml) ? 1 : 0));
				$this->CI->edi_logger->setEdi_request($trackRequest);
				$this->CI->edi_logger->setEdi_response(json_encode($xml));
				$this->CI->edi_logger->setObj_type_name($carrier.' CARRIER Tracking Status');
				$this->CI->edi_logger->saveToEdiLogs();
			}
            
            redirect('orders/orderslist/' . $orderId);
        }
        
        public function getStatus(object $xmldata, int $id, string $carrier,string $from_email="", array $cc_emails=[],int $statusCode=0): int
        {
            $body = $xmldata->xpath('SVKEDITransmissionBody');
            $ordersData = [];
            $statusresponse = 0;
           /* log_message("error","order:".$id);
            log_message("error","body:".json_encode($body[0]->Order));*/
            foreach ($body[0]->Order as $order) {
                $chk_qry_order = $this->CI->db->get_where('tb_orders', ['id' => $id])->row_array();
    			log_message("error","orderStatusQry1111:".$this->CI->db->last_query());
                $orderId = $chk_qry_order['order_id'];
                /*if (!containsOnlyAlphabetsAndSpaces($input)) {
                    echo "Invalid: Contains characters other than alphabets and spaces.";
                }*/
                $deliveryDateTime = $chk_qry_order['delivery_datetime'] ?? "";
                $dropEndTime = $chk_qry_order['drop_endtime'];
                $shipmentId = $chk_qry_order['shipmentid'];
                $uid = $chk_qry_order['user_id'];
                $branchCode = $chk_qry_order['branch_code'];
                $deliveryPincode = $chk_qry_order['delivery_pincode'];
                
                $check_array_status = [
    					'order_id'    => $orderId,
    					'status_code' => 'SV0510',
    					'status'      => 1,
    				];
    			$chk_qry_stop = $this->CI->db->query("SELECT ts.id FROM tb_stop_status ts LEFT JOIN tb_orders o ON o.id = ts.order_id WHERE o.order_id = ? and ts.status_code='SV0510' and ts.status=1", [$orderId]);
				
    			if ($chk_qry_stop->num_rows() == 0) {
                    foreach ($order->Status as $status) {
                        $statusCode = isset($status->StatusCode) ? (string)($status->StatusCode) : "";
                        $estimatedDeliveryDate = isset($status->EstimatedDeliveryDate) ? (string)($status->EstimatedDeliveryDate) : "";
                        /*$estimatedDeliveryDate = "";
                        if($branchCode<>'EATON'){
                            $estimatedDeliveryDate = isset($status->EstimatedDeliveryDate) ? (string)($status->EstimatedDeliveryDate) : "";
                        }
                        else
                        {
                            if($statusCode == "1002")if ($statusCode == "1002"){
                                $statusDateTime = isset($status->DateTime) ? (string)($status->DateTime) : "";
                                log_message("error", "StatusDateTime: " . $statusDateTime);
                            
                                $chk_delivery_qry = $this->CI->db->get_where('tb_customer_pincodes', [
                                    'destination_pin' => $deliveryPincode,
                                    'status' => 1
                                ])->row_array();
                            
                                if (!empty($chk_delivery_qry)) {
                                    $checkDateTime = $this->checkDateTime($statusDateTime);
                                    $weekDay = $checkDateTime['is_sunday'] ? "Yes" : "No";
                                    $dayTime = $checkDateTime['time_check'];
                                    $custZone = $chk_delivery_qry['cust_zone'];
                                    $custSurfaceTat = (int)$chk_delivery_qry['cust_surface_tat'];
                            
                                    if ($custZone == "Direct" && $weekDay == "Yes" && $dayTime == "before") {
                                        $addDays = $custSurfaceTat + 1;
                                    } elseif ($custZone == "Direct" && $weekDay == "No" && $dayTime == "before") {
                                        $addDays = $custSurfaceTat;
                                    } elseif ($custZone == "Direct" && $weekDay == "Yes" && $dayTime == "after") {
                                        $addDays = $custSurfaceTat + 2;
                                    } elseif ($custZone == "Direct" && $weekDay == "No" && $dayTime == "after") {
                                        $addDays = $custSurfaceTat + 1;
                                    } elseif ($custZone == "ODA" && $weekDay == "Yes" && $dayTime == "before") {
                                        $addDays = $custSurfaceTat + 3;
                                    } elseif ($custZone == "ODA" && $weekDay == "No" && $dayTime == "before") {
                                        $addDays = $custSurfaceTat + 2;
                                    } elseif ($custZone == "ODA" && $weekDay == "Yes" && $dayTime == "after") {
                                        $addDays = $custSurfaceTat + 4;
                                    } elseif ($custZone == "ODA" && $weekDay == "No" && $dayTime == "after") {
                                        $addDays = $custSurfaceTat + 3;
                                    } else {
                                        $addDays = $custSurfaceTat; // fallback
                                    }
                            
                                    // Calculate estimated delivery date
                                    $estimatedDeliveryDate = date('Y-m-d', strtotime($statusDateTime . " +$addDays days"));
                            
                                    // Skip holidays and Sundays
                                    while ($this->isHoliday($estimatedDeliveryDate, $chk_delivery_qry['state']) || date('w', strtotime($estimatedDeliveryDate)) == 0) {
                                        $estimatedDeliveryDate = date('Y-m-d', strtotime($estimatedDeliveryDate . " +1 day"));
                                    }
                            
                                    log_message("error", "Final EstimatedDeliveryDate: " . $estimatedDeliveryDate);
                                }
                            }
                        }*/
                        
                        /*
                        $estimatedDeliveryDate = $statusDateTime = date($statusDateTime, strtotime("+" . $addDays . " day"));
                        $estimatedDeliveryDate = isset($status->EstimatedDeliveryDate) ? (string)($status->EstimatedDeliveryDate) : "";*/
                        
                        if($estimatedDeliveryDate != "" && ($deliveryDateTime == "" || $deliveryDateTime == "0000-00-00 00:00:00")){
                            $timeZone        = $this->CI->Standardbookingmodel->getUserTimeZone($chk_qry_order['user_id']);
                    		$getactual = getdatetimebytimezone(DFLT_TZ, $estimatedDeliveryDate, $timeZone);
                            $estimatedDeliveryDate = $getactual['datetime'];
                            $this->CI->db->query("UPDATE tb_orders set delivery_datetime = ?, drop_endtime = ?  WHERE order_id = ?", [$estimatedDeliveryDate, $estimatedDeliveryDate, $orderId]);
                            if($shipmentId != null & $shipmentId != ""){
                                $this->CI->db->query("UPDATE tb_shifts set enddate = ? WHERE shipmentid = ?", [$estimatedDeliveryDate,$shipmentId]);
                            }
                            $currentDate = date('Y-m-d H:i:s');
                            $updatedDate = date('Y-m-d\TH:i:s', strtotime($currentDate));
                            $checkOrders = $this->CI->Order->checkMyknCustomerFromOrders(
                                "o.id,
                                 o.order_id,
                                 o.pickup_city,
                                 o.delivery_city,
                                 o.user_id,
                                 o.company_code,
                                 o.branch_code,
                                 o.modeoftransport,
                                 o.shift_id,
                                 o.trip_id,
                                 o.shipmentid,
                                 o.is_created,
                                 o.shift_id,
                                 c.name,
                                 c.sendto_knlogin,
                                 d.department_code,
                                 o.company_code,
                                 o.branch_code",
                                 [$id]
                            );
                            
                            if (!empty($checkOrders)) {
                                $LogicalReceiver = "WWWWW99";
                                $PhysicalReceiver = 'WWDPT01';
                                $PhysicalSender = 'KNRLG09';
                                if (SYS_TYPE == 'TMS') {
                                    $PhysicalReceiver = 'WWDPP01';
                                    $PhysicalSender = 'KNRLG01';
                                }
                                $logicalinfo = $this->CI->common->gettblrowdata(['company_code' => $companyCode, 'branch_code' => $branchCode], "logical_sender", "tb_branch_master", 0, 0);
                                //log_message("error","idStatusQry11:".$ci->db->last_query());
                                $logicalSender = $logicalinfo['logical_sender'] ?: "THPNA74";
                                foreach ($checkOrders as $eachOrder) {
                                    if($eachOrder['order_id'] == $orderId){
                                        $companyCode = $chk_qry_order['company_code'];
                                        $branchCode = $chk_qry_order['branch_code'];
                                        $timeZoneHour = $gethrs = "";
                                        $gethrs = $this->CI->db->query(
                                            "SELECT c.cntry_hrs,c.cntry_timezone
                                            FROM tbl_country_master AS c, tb_users AS u
                                            WHERE c.country_code = u.country_code AND u.id = ? AND c.status = 1
                                            LIMIT 1",
                                            [$uid]
                                        );
                                        //log_message("error","gethrs:".$this->CI->db->last_query());
                                        if ($gethrs && $gethrs->num_rows() > 0) {
                                            $timeZoneHours = $gethrs->row()->cntry_hrs;
                                            $timeZoneHours = str_replace(".", ":", $timeZoneHours);
                                            $timeZone = $gethrs->row()->cnry_timezone;
                                        }
                                        if ($eachOrder['sendto_knlogin'] == 1) {
                                            //log_message("error","shiftid:".$eachOrder['shift_id']);
                                            if ($eachOrder['shift_id'] > 0) {
                                                //log_message("error","is_created:".$eachOrder['is_created']);
                                                if ($eachOrder['is_created'] == 2) {
                                                    $orderIds[] = $eachOrder['id'];
                                                    $ordersToSent[] = [
                                                        'id' => $eachOrder['id'],
                                                        'order_id' => $eachOrder['order_id'],
                                                        'pickup_city' => $eachOrder['pickup_city'],
                                                        'delivery_city' => $eachOrder['delivery_city'],
                                                        'company_code' => $eachOrder['company_code'],
                                                        'branch_code' => $eachOrder['branch_code'],
                                                        'modeoftransport' => $eachOrder['modeoftransport'],
                                                        'department_code' => $eachOrder['department_code'],
                                                        'shift_id' => $eachOrder['shift_id'],
                                                        'trip_id' => $eachOrder['trip_id'],
                                                        'shipmentid' => $eachOrder['shipmentid']
                                                    ];
                                                }
                                            } 
                                        }
                                    }
                                }
                                //log_message("error","orderIds:".json_encode($orderIds));
                                if (!empty($orderIds)) {
                                    $date = $getactual['date'];
                                    $time = $getactual['time'] . "" . $timeZoneHours;
                                    $statusDateTime = date('Y-m-d\TH:i:s', strtotime($estimatedDeliveryDate)) . "" . $timeZoneHours;
                                    $order = $ordersToSent[0] ?? [];
                                    $statusToBeSent = [
                                        "status_code" => "2400",
                                        "company_code" => $companyCode,
                                        "branch_code" => $branchCode ?? "",
                                        "pickup_city" => $order['pickup_city'] ?? "",
                                        "delivery_city" => $order['delivery_city'] ?? "",
                                        "logicalreceiver" => $LogicalReceiver,
                                        "physicalreceiver" => $PhysicalReceiver,
                                        "physicalsender" => $PhysicalSender,
                                        "logicalsender" => $logicalSender,
                                        "modeoftransport" => $order['modeoftransport'] ?? "",
                                        "department_code" => $order['department_code'] ?? "",
                                        "trackingnumber" => $order['order_id'] ?? "",
                                        "ref_id" => "INN",
                                        "ref_num" => "RL" . ($order['order_id'] ?? ""),
                                        "createdon" => $estimatedDeliveryDate,
                                        "date" => $date,
                                        "time" => $time,
                                        'curdt' => $statusDateTime,
                                        'curdt1' => $updatedDate,
                                        "order_id" => $order['order_id'] ?? ""
                                    ];

                                    
                                    //log_message("error","statusToBeSent:".json_encode($statusToBeSent));
                                    $this->CI->knlogin->knloginsendorderstatus($statusToBeSent);
                                }
                            }
                        }
                        if ($orderId != '' && $statusCode != '') {
                            $ordersData[] = [
                                "OrderID" => $orderId,
                                "statustype" => isset($status->StatusType) ? (string)($status->StatusType) : "",
                                "statuscode" => $statusCode,
                                "statusvalue" => isset($status->StatusValue) ? (string)($status->StatusValue) : "",
                                "datetime" => isset($status->DateTime) ? (string)($status->DateTime) : "",
                                "timezone" => isset($status->TimeZone) ? (string)($status->TimeZone) : "",
                                "lat" => isset($status->Lat) ? (string)($status->Lat) : "",
                                "lng" => isset($status->Lng) ? (string)($status->Lng) : "",
                                "location" => isset($status->Location) ? (string)($status->Location) : "",
                                "comment"     => !empty($status->Comment)
                                    ? (string) $status->Comment
                                    : (!empty($status->StatusValue)
                                        ? (string) $status->StatusValue
                                        : "")
                            ];
                        }
                    }
                    //log_message("error","ordersData:".json_encode($ordersData));
                    $statusresponse = $this->CI->Singlestatusmodel->updateXPStatus(json_encode($ordersData), $carrier);
                    if ($carrier == "COLLINS" and $statusresponse > 0) {
                        if ($from_email != "") {
                            $this->sendMail("no-reply@svkonekt.com",$from_email, $cc_emails, $orderId, $statusCode);
                        } else {
                            $this->sendMail("no-reply@svkonekt.com","datlasrinivasvarma@gmail.com", "vijetha.kakarlapudi@tphrs.com", $orderId, $statusCode);
                        }
                    }
                    $this->CI->knlogin->sendOrderStatusXmlstoKNlogin($id);
                    //log_message("error","statusresponse:".$statusresponse);
    			}
            }
            
            return $statusresponse;
        }
        
        function checkDateTime($datetimeStr) {
            $datetime = new DateTime($datetimeStr); // e.g., '2025-10-12 18:30:00'
        
            // Check if it's Sunday (0 = Sunday)
            $isSunday = $datetime->format('w') == 0;
        
            // Check if time is before or after 7 PM (19:00:00)
            $time = $datetime->format('H:i:s');
            $threshold = '19:00:00';
        
            $timeComparison = ($time < $threshold) ? 'before' : 'after';
        
            return [
                'is_sunday' => $isSunday,
                'time_check' => $timeComparison
            ];
        }
        
        private function isHoliday($date, $state) {
            $query = $this->CI->db
                ->where('holiday', $date)
                ->where('state', $state) // Optional: only if holidays are state-specific
                ->get('tb_customer_holidays_list');
        
            return $query->num_rows() > 0;
        }
        
        
        public function getPod(string $trackRequest, int $orderId, string $carrier): array
        {
            $message     = '';
            $response    = '';
            $docketNo    = '';
            $parsedData  = [];
            $type = '';
            $companyCode = $this->CI->session->userdata('company_code');
		    $branchCode = $this->CI->session->userdata('branch_code');
            $userId = $this->CI->session->userdata('user_id');
            //log_message("error", "carrier:".$carrier);
            $authDetails = $this->CI->common->gettblrowdata(
                ['token_for' => $carrier, 'status' => 1],
                "auth_token",
                "tb_auth_tokens",
                0,
                0
            );
            $authToken = $authDetails['auth_token'];
            try{
            if($carrier == "FLIPKART")
			{
			    $url = FLIPKART_SERVER_BASE_URL;
			    $type = "JSON";
			}
			else if($carrier == "XP_INDIA_SOUTH" || $carrier == "XP_INDIA_WEST")
    		{
    			$carrier = "XP_INDIA";
			    $url = XP_INDIA_SERVER_BASE_URL;
			    $type = "XML";
			}
            $serverURL = $url . 'kuehne/check/docket/pod/' . $trackRequest;
            
            $ch = curl_init($serverURL);
            
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                "Content-Type: application/xml",
                "AuthToken: $authToken"
            ]);
            
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            
            // Execute the request
                $response = curl_exec($ch);
                $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                
                // Check for errors
                if (curl_errno($ch)) {
                    //echo "cURL Error: " . curl_error($ch);
                } else {
                    /*echo "HTTP Status: $httpCode\n";
                    echo "Response:\n$response\n";*/
                }
                
                curl_close($ch);
                //log_message("ERROR","response:".$response);
               // Clean the XML string
               if (!empty($response)) {
                $postData = str_replace('<?xml version="1.0" encoding="utf-16"?>', "", $response);
                $postData = str_replace(' xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"', "", $postData);
                
                // Load XML
                $xml = simplexml_load_string($postData);
                $res = $this->getXPPod($xml, $orderId);
               }
                
               /*log_message("error", "xml:".json_encode($xml));
                
                // Navigate to SVKEDITransmissionBody
                $gLogElement = $xml->xpath('/SVKEDIResponseMessage/SVKEDITransmissionBody');
                log_message("error", "gLogElement:".$gLogElement);
                
                if (!empty($gLogElement)) {
                    // Try to get DocketNumber under OrderDetail
                    $docketNumberNode = $gLogElement[0]->xpath('Order/OrderID');
                
                log_message("error", "docketNumberNode:".$docketNumberNode);
                    
                } else {
                    log_message("error", "SVKEDITransmissionBody not found in XML.");
                }*/
            }catch (Exception $e) {
				$message = 'Error: ' . $e->getMessage();
			}
			finally {
				$this->CI->edi_logger->setEdi_type(1);
				$this->CI->edi_logger->setTransaction_id(time());
				$this->CI->edi_logger->setEdi_name($carrier.' CARRIER POD');
				$this->CI->edi_logger->setBounded_type(1);
				$this->CI->edi_logger->setCompany_code($companyCode);
				$this->CI->edi_logger->setBranch_code($branchCode);
				//log_message("error","userId7:".$userId);
				$this->CI->edi_logger->setUser_id($userId);
				$this->CI->edi_logger->setEdi_format_type($type);
				$this->CI->edi_logger->setStatus(((isset($xml) && $xml) ? 1 : 0));
				$this->CI->edi_logger->setEdi_request($trackRequest);
				$this->CI->edi_logger->setEdi_response(json_encode($xml));
				$this->CI->edi_logger->setObj_type_name($carrier.' CARRIER POD');
				$this->CI->edi_logger->saveToEdiLogs();
			}
            redirect('orders/orderslist/' . $orderId);
        }
        
        /*public function getXPPod(object $xmldata, string $orderRowId): string
        {
            log_message("error", "xmldata:".json_encode($xmldata));
            $body = $xmldata->xpath('SVKUploadDetails');
            //log_message("error","order:".json_encode($body[0]));
            $orderId = isset($body[0]->SVKOrderID) ? (string)($body[0]->SVKOrderID) : "";
            log_message("error","order:".json_encode($docUploadDetails));
            $podImageUrl = isset($body[0]->SVKURL) ? (string)($body[0]->SVKURL) : "";
            
            $statusresponse = "";
            
            if($podImageUrl <> '')
    		{
        		$saveFolder = "./assets/poduploads/"; // Make sure this folder exists and is writable
        		//log_message("error","url:".$podImageUrl);
        		// Extract file names from URLs
        		$podImageName = basename(parse_url($podImageUrl, PHP_URL_PATH));
        		
        		// Step 2: Extract extension
        		$podExtension = pathinfo($podImageName, PATHINFO_EXTENSION);
        		// Full path where files will be saved
        		$podFilePath = $saveFolder . $podImageName;
        		//log_message('error', "podFilePath:" . $podFilePath);
        		// Download and save docket PDF
        		file_put_contents($podFilePath, file_get_contents($podImageUrl));
    		
        		$orderinfo = $this->CI->common->gettblrowdata(array('id' => $orderRowId), 'id,order_id,user_id,plat,plng,trip_id,shift_id,company_code,branch_code,vendor_id', 'tb_orders', 0, 0);
                //log_message('error', "query:" . $this->CI->db->last_query());
                if (!empty($orderinfo)) {
                    $log_edi_arr['order_id'] = $orderinfo['order_id'];
                    $log_edi_arr['user_id'] = $orderinfo['user_id'];
                    $log_edi_arr['company_code'] = $orderinfo['company_code'];
                    $log_edi_arr['branch_code'] = $orderinfo['branch_code'];
                    $log_edi_arr['vendor_id'] = $orderinfo['vendor_id'];
                    $log_edi_arr['order_row_id'] = $orderinfo['id'];
                    $log_edi_arr['request'] = "ePOD through API";
                    $log_edi_arr['status'] = 0;
                    $doctype = $this->CI->common->gettblrowdata(array(
                        'type_name' => 'Others'
                        ), 'id', 'tb_document_types', 0, 0);
                    $insert['order_id'] = $orderinfo['id'];
                    $insert['trip_id'] = $orderinfo['trip_id'];
                    $insert['shipment_id'] = $orderinfo['shift_id'];
                    $insert['stop_id'] = 0;
                    $insert['stop_detail_id'] = 0;
                    $insert['stop_type'] = 'P';
                    $insert['doc_type'] = $doctype['id'];
                    $insert['latitude'] = $orderinfo['plat'];
                    $insert['longitude'] = $orderinfo['plng'];
                    $insert['user_id'] = $orderinfo['user_id'];
                    $insert['status'] = 1;
                    $insert['createdon'] = $insert['updatedon'] = date('Y-m-d H:i:s');
                    $insert['imgpath'] = $podImageName;
                    $imageSize = filesize(NEW_POD_PATH.$podImageName);
                    $insert['filesize'] = $imageSize;
                    $this->CI->common->insertTableData("tb_pod_uploads", $insert);
                    $statusresponse = "success";
                }
    		}
            
            return $statusresponse;
        }*/
        
        public function getXPPod(object $xmldata, int $orderRowId): string 
        {
            $statusresponse = "failed";
        
            // Get Order Info only once
            $orderinfo = $this->CI->common->gettblrowdata(
                ['id' => $orderRowId],
                'id,order_id,user_id,plat,plng,trip_id,shift_id,company_code,branch_code,vendor_id',
                'tb_orders', 0, 0
            );
        
            if (empty($orderinfo)) {
                log_message('error', 'Order not found for ID: ' . $orderRowId);
                return $statusresponse;
            }
        
            // Prepare save folder once
            $saveFolder = "./assets/poduploads/";
            if (!is_dir($saveFolder)) mkdir($saveFolder, 0777, true);
        
            // Current datetime once
            $curtz = $this->CI->session->userdata("usr_tzone")['timezone'] ?? DFLT_TZ;
            $logdate = date('Y-m-d H:i:s');
            $getactual = getdatetimebytimezone(DFLT_TZ, $logdate, $curtz);
            $curdt = $getactual['datetime'];
        
            // Cache for URL headers to avoid multiple requests to same URL
            $urlContentTypeCache = [];
        
            $uploadDetailsList = $xmldata->xpath('SVKUploadDetails');
        
            foreach ($uploadDetailsList as $uploadDetails) {
                $documentName = isset($uploadDetails->SVKDocumentName) ? (string)$uploadDetails->SVKDocumentName : "";
        
                // Get doc type ID
                $doctype = $this->CI->common->gettblrowdata(
                    ['type_name' => $documentName],
                    'id', 'tb_document_types', 0, 0
                );
                $docTypeId = $doctype['id'] ?? 0;
        
                $urlListStr = isset($uploadDetails->SVKURL) ? (string)$uploadDetails->SVKURL : "";
                if (empty($urlListStr)) continue;
        
                $urls = explode(",", $urlListStr);
        
                foreach ($urls as $podImageUrl) {
                    $podImageUrl = trim($podImageUrl);
                    if (empty($podImageUrl)) continue;
        
                    // Filename
                    $podImageName = $orderinfo['order_id'] . "_" . basename(parse_url($podImageUrl, PHP_URL_PATH));
                    $extension = pathinfo($podImageName, PATHINFO_EXTENSION);
        
                    // If no extension, detect from headers (with cache)
                    if (empty($extension)) {
                        if (!isset($urlContentTypeCache[$podImageUrl])) {
                            $headers = @get_headers($podImageUrl, 1);
                            $contentType = $headers['Content-Type'] ?? null;
                            if (is_array($contentType)) $contentType = end($contentType);
                            $urlContentTypeCache[$podImageUrl] = $contentType;
                        } else {
                            $contentType = $urlContentTypeCache[$podImageUrl];
                        }
        
                        if (strpos($contentType, 'image/') !== false) {
                            $podImageName .= '.jpg';
                        } elseif ($contentType === 'application/pdf') {
                            $podImageName .= '.pdf';
                        } else {
                            $podImageName .= '.jpg';
                        }
                    }
        
                    $podFilePath = $saveFolder . $podImageName;
        
                    try {
                        // Download the file
                        file_put_contents($podFilePath, file_get_contents($podImageUrl));
        
                        // Check existing record
                        $docInfo = $this->CI->common->gettblrowdata(
                            ['order_id' => $orderinfo['id'], 'doc_type' => $docTypeId, 'url' => $podImageUrl],
                            'id', 'tb_pod_uploads', 0, 0
                        );
        
                        $dataToSave = [
                            'order_id' => $orderinfo['id'],
                            'trip_id' => $orderinfo['trip_id'],
                            'shipment_id' => $orderinfo['shift_id'],
                            'stop_id' => 0,
                            'stop_detail_id' => 0,
                            'stop_type' => 'P',
                            'doc_type' => $docTypeId,
                            'latitude' => $orderinfo['plat'],
                            'longitude' => $orderinfo['plng'],
                            'user_id' => $orderinfo['user_id'],
                            'status' => 1,
                            'createdon' => $curdt,
                            'updatedon' => $curdt,
                            'imgpath' => $podImageName,
                            'filesize' => filesize($podFilePath),
                            'url' => $podImageUrl
                        ];
        
                        if (empty($docInfo)) {
                            $this->CI->common->insertTableData("tb_pod_uploads", $dataToSave);
                        } else {
                            $this->CI->common->updatetbledata(
                                "tb_pod_uploads",
                                $dataToSave,
                                ['order_id' => $orderinfo['id'], 'doc_type' => $docTypeId, 'url' => $podImageUrl]
                            );
                        }
        
                        $statusresponse = "success";
                    } catch (Exception $e) {
                        log_message("error", "Error saving POD file: " . $e->getMessage());
                    }
                }
            }
        
            return $statusresponse;
        }

        
        /*public function getXPPod(object $xmldata, int $orderRowId): string 
        {
            //log_message("error", "xmldata: " . json_encode($xmldata));
        
            $uploadDetailsList = $xmldata->xpath('SVKUploadDetails');
            $statusresponse = "failed";
        
            // Get Order Info only once
            $orderinfo = $this->CI->common->gettblrowdata(
                ['id' => $orderRowId],
                'id,order_id,user_id,plat,plng,trip_id,shift_id,company_code,branch_code,vendor_id',
                'tb_orders', 0, 0
            );
        
            if (empty($orderinfo)) {
                log_message('error', 'Order not found for ID: ' . $orderRowId);
                return $statusresponse;
            }
            
        
            foreach ($uploadDetailsList as $uploadDetails) {
                
                $documentName = isset($uploadDetails->SVKDocumentName) ? (string)$uploadDetails->SVKDocumentName : "";
                $doctype = $this->CI->common->gettblrowdata(
                    ['type_name' => $documentName],
                    'id', 'tb_document_types', 0, 0
                );
                //log_message("error", "doctype: " . $this->CI->db->last_query());
                $docTypeId = $doctype['id'] ?? 0;
                $urlListStr = isset($uploadDetails->SVKURL) ? (string)$uploadDetails->SVKURL : "";
                if (empty($urlListStr)) continue;
        
                // Support multiple comma-separated URLs
                $urls = explode(",", $urlListStr);
                    
                foreach ($urls as $podImageUrl) {
                    $podImageUrl = trim($podImageUrl);
                    if (empty($podImageUrl)) continue;
        
                    $saveFolder = "./assets/poduploads/";
                    if (!is_dir($saveFolder)) {
                        mkdir($saveFolder, 0777, true);
                    }
        
                    /*$podImageName = basename(parse_url($podImageUrl, PHP_URL_PATH));
                    $podFilePath = $saveFolder . $podImageName;-------------------
                    
                    
                    // Extract filename from URL
                    $podImageName = $orderinfo['order_id'] . "_"  . basename(parse_url($podImageUrl, PHP_URL_PATH));
                    
                    // Get extension (if any)
                    $extension = pathinfo($podImageName, PATHINFO_EXTENSION);
                    
                    // If no extension, default to .pdf
                    if (empty($extension)) {
                        //$podImageName .= '.pdf';
                        $headers = get_headers($podImageUrl, 1);

                        if (isset($headers['Content-Type'])) {
                            $contentType = $headers['Content-Type'];
                        
                            if (is_array($contentType)) {
                                $contentType = end($contentType); // In case of multiple Content-Type headers
                            }
                        
                            if (strpos($contentType, 'image/') !== false) {
                                $podImageName .= '.jpg';
                            } elseif ($contentType === 'application/pdf') {
                                $podImageName .= '.pdf';
                            } else {
                                $podImageName .= '.jpg';
                            }
                        } else {
                            $podImageName .= '.jpg';
                        }
                    }
                    
                    // Full file path
                    $podFilePath = $saveFolder . $podImageName;

        
                    try {
                        // Download the file
                        file_put_contents($podFilePath, file_get_contents($podImageUrl));
                        
                        $docInfo = $this->CI->common->gettblrowdata(array('order_id' => $orderinfo['id'], 'doc_type' => $docTypeId, 'url' => $podImageUrl), 'id', 'tb_pod_uploads', 0, 0);
                        //log_message("error", "docInfo: " . $this->CI->db->last_query());
                        $curtz = $this->CI->session->userdata("usr_tzone")['timezone'];
                            $logdate = date('Y-m-d H:i:s');
                            $getactual = getdatetimebytimezone(DFLT_TZ, $logdate, $curtz);
                            $curdt = $getactual['datetime'];
                        if (empty($docInfo)) {
                            // Insert into DB
                            $insert = [
                                'order_id' => $orderinfo['id'],
                                'trip_id' => $orderinfo['trip_id'],
                                'shipment_id' => $orderinfo['shift_id'],
                                'stop_id' => 0,
                                'stop_detail_id' => 0,
                                'stop_type' => 'P',
                                'doc_type' => $docTypeId,
                                'latitude' => $orderinfo['plat'],
                                'longitude' => $orderinfo['plng'],
                                'user_id' => $orderinfo['user_id'],
                                'status' => 1,
                                'createdon' => $curdt,
                                'updatedon' => $curdt,
                                'imgpath' => $podImageName,
                                'filesize' => filesize($podFilePath),
                                'url' => $podImageUrl
                            ];
                            $this->CI->common->insertTableData("tb_pod_uploads", $insert);
                        }
                        else
                        {
                            $this->CI->common->updatetbledata("tb_pod_uploads", ['createdon' => $curdt, 'imgpath' => $podImageName,
                                'filesize' => filesize($podFilePath), 'updatedon' => $curdt], ['order_id' => $orderinfo['id'], 'doc_type' => $docTypeId, 'url' => $podImageUrl]);
                        }
                        $statusresponse = "success";
                    } catch (Exception $e) {
                        log_message("error", "Error saving POD image: " . $e->getMessage());
                    }
                }
            }
        
            return $statusresponse;
        }*/
        
        public function sendMail($from_emails, $to_emails, $cc_emails, $order_id, $statusCode)
        {
            $this->CI->load->library('PhpMailerLibrary');
            $statusDesc=$this->CI->common->gettblrowdata(['status_code'=>$statusCode],'status_name','tb_status_master',1,0);
            //log_message("error", "statusDesc: " . json_encode($statusDesc));
            $subject = "Order status update";
            $message = "Hi Team,<br><br>";
            $message .= $statusDesc['status_name'] . " Status updated Successfully for " . $order_id . "<br><br>";
            $message .= "This is an automatically generated EMail, please do not reply <br><br>";
            $message .= "Thanks,<br>Support Team,<br>svkonekt.com";
            try {
                log_message("error", "email sent for FROM:" . $from_emails);
                log_message("error", "email sent for CC: " . json_encode($cc_emails));
                log_message("error", "email sent for TO:" . $to_emails);
                if ($this->CI->phpmailerlibrary->sendMailCollins($from_emails, $subject, $message, $cc_emails, $to_emails)) {
                    log_message("error", "email sent for " . $subject);
                } else {
                    log_message("error", "email failed for " . $subject);
                }
            } catch (Exception $e) {
                log_message("error", "sendMail failed - " . $e->getMessage());
            }
        }
	}
