<?php
class TCIExpressEDIServices
{
    private $CI;

    public function __construct()
    {
        $this->CI = &get_instance();
        $this->CI->load->model(['common', 'apis/FlipkartEDIModel', 'completedordersmodel', 'Singlestatusmodel', 'Order']);
        $this->CI->load->library(['Edi_logger', 'knlogin']);
        $this->CI->load->helper('user_helper');
        $this->CI->load->library('uuid');

        $companyCode = $this->CI->session->userdata('company_code');
        $branchCode  = $this->CI->session->userdata('branch_code');
        $userId      = $this->CI->session->userdata('user_id');
    }

    public function generateTCIExpressToken(): void
    {
        $authDetails = $this->CI->common->gettblrowdata(['domain' => 'TCI EXPRESS', 'status' => 1], "url, username, password", "init_cred", 0, 0);
        //log_message('error', "cURL Request URL:" . json_encode($authDetails));
        $url      = $authDetails['url'];
        $username = $authDetails['username'];
        $password = $authDetails['password'];
        $xml_data = '<?xml version="1.0" encoding="utf-8"?>
            <soap:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                    xmlns:xsd="http://www.w3.org/2001/XMLSchema"
                            xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/">
                <soap:Body>
                    <getToken xmlns="http://www.tciexpress.in/">
                    <username>' . htmlspecialchars($username, ENT_XML1) . '</username>
                    <password>' . htmlspecialchars($password, ENT_XML1) . '</password>
                    </getToken>
                </soap:Body>
                </soap:Envelope>'; 

        $headers = [
            "Content-Type: text/xml; charset=utf-8",
            "Content-Length: " . strlen($xml_data),
            "SOAPAction: \"http://www.tciexpress.in/getToken\"",
        ];
        try {
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $xml_data);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

            $response = curl_exec($ch);

            if (curl_errno($ch)) {
                throw new Exception("cURL Error: " . curl_error($ch));
            }
            curl_close($ch);

            // Parse the SOAP response
            $xml = simplexml_load_string($response);
            if ($xml === false) {
                throw new Exception("Failed to parse XML response");
            }

            // Register namespaces
            $xml->registerXPathNamespace('soap', 'http://schemas.xmlsoap.org/soap/envelope/');
            $xml->registerXPathNamespace('ns', 'http://www.tciexpress.in/');

            // Extract token
            $token = $xml->xpath('//ns:getTokenResult');

            //log_message('error', "ApiResponseLoginToken:" . json_encode($apiResponse));
            if (isset($token[0])) {
                $isUpdate = $this->CI->common->gettblrowdata(['token_for' => 'TCI EXPRESS', 'status' => 1], "id", "tb_auth_tokens", 0, 0);
                if (! empty($isUpdate)) {
                    $status = $this->CI->common->updatetbledata("tb_auth_tokens", ['auth_token' => $token[0], 'updated_on' => date('Y-m-d H:i:s')], ['id' => $isUpdate['id']]);
                } else {
                    $status = $this->CI->common->insertTableData("tb_auth_tokens", [
                        'auth_token' => $token[0],
                        'created_on' => date('Y-m-d H:i:s'),
                        'updated_on' => date('Y-m-d H:i:s'),
                        'token_for'  => 'TCI EXPRESS',
                        'status'     => 1,
                    ]);
                }
                if ($status) {
                    log_message('error', "TCI EXPRESS Carrier Token generated successfully @ " . gmdate('d-m-Y H:i:00'));
                }
            } else {
                log_message('error', 'Unable to generate TCI EXPRESS Token @ ' . gmdate('d-m-Y H:i:00'));
            }
        } catch (Exception $e) {
            $message = 'Error: ' . $e->getMessage();
        } finally {
            $this->CI->edi_logger->setEdi_type(1);
            $this->CI->edi_logger->setTransaction_id(time());
            $this->CI->edi_logger->setEdi_name('TCI EXPRESS');
            $this->CI->edi_logger->setBounded_type(1);
            $this->CI->edi_logger->setCompany_code($companyCode);
            $this->CI->edi_logger->setBranch_code($branchCode);
            //log_message("error","userId1:".$userId);
            $this->CI->edi_logger->setUser_id($userId);
            $this->CI->edi_logger->setEdi_format_type('String');
            $this->CI->edi_logger->setStatus((isset($$token[0]) ? 1 : 0));
            $this->CI->edi_logger->setEdi_response(json_encode($response));
            $this->CI->edi_logger->setObj_type_name('TCI EXPRESS CARRIER Token Generation');
            $this->CI->edi_logger->saveToEdiLogs();
        }
    }
    
    public function checkClientAuth(string $source): bool
    {
        log_message("error", "SourceApp111: " . $source);
        $authHeader = $this->CI->input->get_request_header('Authorization');

        if (! $authHeader) {
            return false;
        }
        
        if($source == "XPS")
        {
            $source = "XP_INDIA_INBOUND";
        }
        // Match "Basic base64encoded"
        $authDetails = $this->CI->common->gettblrowdata(['token_for' => $source, 'status' => 1], "auth_token", "tb_auth_tokens", 0, 0);
        log_message('error', "Qry:" . $this->CI->db->last_query());
        log_message('error', "cURL Request URL:" . json_encode($authDetails));
        $authToken = $authDetails['auth_token'];
        if (preg_match('/Basic\s+(\S+)/', $authHeader, $matches)) {
            $clientToken = trim($matches[1]);
            // Compare client token with saved token
            log_message('error', "clientToken:" . $clientToken);
            log_message('error', "authToken:" . $authToken);
            if ($clientToken === $authToken) {
                return true;
            }
        }
        return false;
    }
    
    public function getStatus(object $xmldata, int $id, string $carrier): int
    {
        //log_message("error","xmldata:".json_encode($xmldata));
        //$body = $xmldata->xpath('SVKEDITransmissionBody');
        $order = $xmldata;
        $ordersData = [];
        $statusresponse = 0;
     	/*log_message("error","xmldata:".json_encode($body));
     	log_message("error","id:".json_encode($id));*/
        //foreach ($body[0]->Order as $order) {
            $chk_qry_order = $this->CI->db->get_where('tb_orders', ['id' => $id])->row_array();
    		//log_message("error","orderStatusQry1111:".$this->CI->db->last_query());
            $orderId = $chk_qry_order['order_id'];
            
            $check_array_status = [
    			'order_id'    => $orderId,
    			'status_code' => 'SV0510',
    			'status'      => 1,
    		];
    		$chk_qry_stop = $this->CI->db->query("SELECT ts.id FROM tb_stop_status ts LEFT JOIN tb_orders o ON o.id = ts.order_id WHERE o.order_id = ? and ts.status_code='SV0510' and ts.status=1", [$orderId]);
            log_message("error","orderStatusQry2222:".$this->CI->db->last_query());
    		if ($chk_qry_stop->num_rows() == 0) {
                foreach ($order->Status as $status) {
                    $statusCode = isset($status->StatusCode) ? (string)($status->StatusCode) : "";
                    if($carrier == "TCI EXPRESS"){
                        if($statusCode!='D00' && $statusCode!='ARR' && $statusCode!='PKP' && $statusCode!='D27' && $statusCode!='OFD' && $statusCode!='D59' && $statusCode!='D60' && $statusCode!='DIS'){
                            $statusCode = "D86";
                        }
                    }
                    $estimatedDeliveryDate = isset($status->EstimatedDeliveryDate) ? (string)($status->EstimatedDeliveryDate) : "";
                   
                    if ($orderId != '' && $statusCode != '') {
                        $ordersData[] = [
                            "OrderID" => $orderId,
                            //"statustype" => isset($status->StatusType) ? (string)($status->StatusType) : "",
                            "statustype" => $statusCode,
                            "statuscode" => $statusCode,
                            "statusvalue" => isset($status->StatusValue) ? (string)($status->StatusValue) : "",
                            "datetime" => isset($status->DateTime) ? (string)($status->DateTime) : "",
                            "timezone" => isset($status->TimeZone) ? (string)($status->TimeZone) : "",
                            "lat" => isset($status->Lat) ? (string)($status->Lat) : "",
                            "lng" => isset($status->Lng) ? (string)($status->Lng) : "",
                            "location" => isset($status->Location) ? (string)($status->Location) : "",
                        ];
                    }
                }
                log_message("error","ordersData:".json_encode($ordersData));
                $statusresponse = $this->CI->Singlestatusmodel->updateXPStatus(json_encode($ordersData), $carrier);
    		}
        //}
            
        return $statusresponse;
    }     
    
    /*public function getXPPod(object $xmldata, int $orderRowId): string 
    {
        //log_message("error", "xmldata: " . json_encode($xmldata));
        
        $uploadDetailsList = $xmldata->xpath('SVKUploadDetails');
        $statusresponse = "failed";
        
        $orderinfo = $this->CI->common->gettblrowdata(
            ['id' => $orderRowId],
            'id,order_id,user_id,plat,plng,trip_id,shift_id,company_code,branch_code,vendor_id',
            'tb_orders', 0, 0
        );
        
        if (empty($orderinfo)) {
            log_message('error', 'Order not found for ID: ' . $orderRowId);
            return $statusresponse;
        }
        
        foreach ($uploadDetailsList as $uploadDetails) {
            $documentName = isset($uploadDetails->SVKDocumentName) ? (string)$uploadDetails->SVKDocumentName : "";
            $doctype = $this->CI->common->gettblrowdata(
                ['type_name' => $documentName],
                'id', 'tb_document_types', 0, 0
            );
            $docTypeId = $doctype['id'] ?? 0;
        
            $urlListStr = isset($uploadDetails->SVKURL) ? (string)$uploadDetails->SVKURL : "";
            $base64Data = isset($uploadDetails->SVKBASE64) ? (string)$uploadDetails->SVKBASE64 : "";
        
            if (empty($urlListStr) && empty($base64Data)) {
                log_message("error", "Both URL & BASE64 are empty for documentName: $documentName");
                continue;
            }
        
            $saveFolder = "./assets/poduploads/";
            if (!is_dir($saveFolder)) {
                if (!mkdir($saveFolder, 0777, true)) {
                log_message("error", "Failed to create folder: $saveFolder");
                // Maybe exit or continue
                }
            }
        
            if (!empty($urlListStr)) {
                $urls = explode(",", $urlListStr);
                foreach ($urls as $url) {
                $url = trim($url);
                if (empty($url)) {
                    log_message("error", "Empty URL in list for order: " . $orderinfo['order_id']);
                    continue;
                }
        
                $url = preg_replace('#\\\\/#', '/', $url);
                $podImageUrl = $url;

                log_message("error", "Trying URL fetch: [$url]");
        
                // Use cURL to fetch
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, $url);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
                curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
                curl_setopt($ch, CURLOPT_TIMEOUT, 60);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
                // Set a browser user-agent
                curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (compatible; PHP script)');
                
                $fileContents = curl_exec($ch);
                $curlErr = curl_error($ch);
                $httpStatus = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                $contentType = curl_getinfo($ch, CURLINFO_CONTENT_TYPE);
                $contentLength = curl_getinfo($ch, CURLINFO_CONTENT_LENGTH_DOWNLOAD);
                curl_close($ch);
        
                log_message("error", "cURL status: $httpStatus, contentType: [$contentType], contentLength: $contentLength");
        
                if ($fileContents === false) {
                    log_message("error", "cURL error: $curlErr");
                    continue;
                }
                if ($httpStatus !== 200) {
                    log_message("error", "HTTP status not 200: $httpStatus");
                    continue;
                }
                if (empty($fileContents)) {
                    log_message("error", "fileContents is empty for URL: $url");
                    continue;
                }
        
                // Determine extension
                $extension = 'jpg';
                if (stripos($contentType, 'application/pdf') !== false) {
                    $extension = 'pdf';
                } elseif (stripos($contentType, 'image/') !== false) {
                    $ext = substr($contentType, strlen('image/'));
                    $ext = preg_replace('/[^a-z0-9]/', '', strtolower($ext));
                    if (!empty($ext)) {
                        $extension = $ext;
                    }
                }
        
                $podImageName = $orderinfo['order_id'] . "_" . uniqid() . "." . $extension;
                $podFilePath = $saveFolder . $podImageName;
        
                $bytesWritten = @file_put_contents($podFilePath, $fileContents);
                if ($bytesWritten === false) {
                    log_message("error", "Failed to write file to $podFilePath");
                    continue;
                }
                if ($bytesWritten === 0) {
                    log_message("error", "Written 0 bytes to $podFilePath");
                    continue;
                }
        
                log_message("error", "Successfully saved file: $podImageName, bytes: $bytesWritten");
        
                $this->processPodFile($orderinfo, $docTypeId, $podImageUrl, $podFilePath, $podImageName);
                $statusresponse = "success";
                }
            }
            elseif (!empty($base64Data)) {
                log_message("error", "Handling base64 data");
        
                // Base64 logic unchanged, but include checks
                $matches = [];
                $extension = 'jpg'; // default
        
                if (preg_match('/^data:(.*?);base64,/', $base64Data, $matches)) {
                $mime = $matches[1];
                if ($mime === 'application/pdf') {
                    $extension = 'pdf';
                } elseif (strpos($mime, 'image/') !== false) {
                    $extension = str_replace('image/', '', $mime);
                }
                $base64Body = substr($base64Data, strpos($base64Data, ',') + 1);
                } else {
                log_message("error", "Base64 string missing mime prefix");
                $base64Body = $base64Data;
                }
        
                $decoded = base64_decode($base64Body);
                if ($decoded === false || strlen($decoded) === 0) {
                log_message("error", "base64_decode failed or empty");
                continue;
                }
        
                $podImageName = $orderinfo['order_id'] . "_" . uniqid() . "." . $extension;
                $podFilePath = $saveFolder . $podImageName;
        
                $bytesWritten = @file_put_contents($podFilePath, $decoded);
                if ($bytesWritten === false || $bytesWritten === 0) {
                log_message("error", "Failed to write base64 decoded file or wrote 0 bytes: $podFilePath");
                continue;
                }
        
                log_message("error", "Successfully saved base64 file: $podImageName, bytes: $bytesWritten");
                $podImageUrl = "";
                $this->processPodFile($orderinfo, $docTypeId, $podImageUrl, $podFilePath, $podImageName);
                $statusresponse = "success";
            }
        }
        
        return $statusresponse;
    }*/
    
    public function getXPPod(object $xmldata, int $orderRowId): string
    {
        $uploadDetailsList = $xmldata->xpath('SVKUploadDetails');
        $statusresponse = "failed";
        
        $orderinfo = $this->CI->common->gettblrowdata(
            ['id' => $orderRowId],
            'id,order_id,user_id,plat,plng,trip_id,shift_id,company_code,branch_code,vendor_id',
            'tb_orders', 0, 0
        );
        
        if (empty($orderinfo)) {
            log_message('error', 'Order not found for ID: ' . $orderRowId);
            return $statusresponse;
        }
        
        $saveFolder = "./assets/poduploads/";
        if (!is_dir($saveFolder)) {
            mkdir($saveFolder, 0777, true);
        }
        
        foreach ($uploadDetailsList as $uploadDetails) {
        
            $documentName = (string)($uploadDetails->SVKDocumentName ?? '');
            $doctype = $this->CI->common->gettblrowdata(
                ['type_name' => $documentName],
                'id', 'tb_document_types', 0, 0
            );
            $docTypeId = $doctype['id'] ?? 0;
        
            $urlListStr = trim((string)($uploadDetails->SVKURL ?? ''));
            $base64Data = trim((string)($uploadDetails->SVKBASE64 ?? ''));
        
            /* ===============================
               1️⃣ BASE64 HAS HIGHEST PRIORITY
               =============================== */
            if (!empty($base64Data)) {
    
                if (preg_match('/^data:(.*?);base64,/', $base64Data, $m)) {
                    $mime = $m[1];
                    $base64Body = substr($base64Data, strpos($base64Data, ',') + 1);
                } else {
                    $mime = '';
                    $base64Body = $base64Data;
                }
        
                $data = base64_decode($base64Body, true);
                if ($data === false || strlen($data) === 0) {
                    log_message('error', 'Invalid SVKBASE64 data');
                    continue;
                }
        
                $extension = $this->detectExtension($data);
                if (!$extension) {
                    log_message('error', 'Unknown BASE64 file type');
                    continue;
                }
        
                $podImageName = $orderinfo['order_id'] . "_" . uniqid() . "." . $extension;
                $podFilePath = $saveFolder . $podImageName;
        
                file_put_contents($podFilePath, $data);
        
                $this->processPodFile($orderinfo, $docTypeId, '', $podFilePath, $podImageName);
                $statusresponse = "success";
                continue;
            }
        
            /* ===============================
               2️⃣ URL PROCESSING
               =============================== */
            if (empty($urlListStr)) {
                log_message('error', 'Both URL & BASE64 empty');
                continue;
            }
        
            foreach (explode(',', $urlListStr) as $url) {
        
                $url = trim(preg_replace('#\\\\/#', '/', $url));
                if (!$url) continue;
        
                log_message("error", "Trying URL fetch: [$url]");
        
                $ch = curl_init();
                curl_setopt_array($ch, [
                    CURLOPT_URL => $url,
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_TIMEOUT => 60,
                    CURLOPT_SSL_VERIFYPEER => false,
                    CURLOPT_SSL_VERIFYHOST => false,
                    CURLOPT_USERAGENT => 'Mozilla/5.0'
                ]);
        
                $data = curl_exec($ch);
                $httpStatus = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                curl_close($ch);
        
                if ($httpStatus !== 200 || !$data) {
                    log_message('error', 'Failed URL fetch');
                    continue;
                }
        
                /* ===============================
                   3️⃣ HTML HANDLING
                =============================== */
                if (stripos($data, '<html') !== false) {
                    $extracted = $this->extractFileFromHtml($data, $url);
                    if (!$extracted) {
                        log_message('error', 'HTML returned but no file extracted');
                        continue;
                    }
                    $data = $extracted;
                }
        
                /* ===============================
                4️⃣ FILE TYPE DETECTION
                =============================== */
                $extension = $this->detectExtension($data);
                if (!$extension) {
                    log_message('error', 'Unknown POD binary type');
                    continue;
                }
        
                $podImageName = $orderinfo['order_id'] . "_" . uniqid() . "." . $extension;
                $podFilePath = $saveFolder . $podImageName;
        
                file_put_contents($podFilePath, $data);
        
                log_message("error", "Successfully saved file: $podImageName");
        
                $this->processPodFile($orderinfo, $docTypeId, $url, $podFilePath, $podImageName);
                $statusresponse = "success";
            }
        }
        
        return $statusresponse;
    }
        
    private function detectExtension(string $data): string
    {
        if (substr($data, 0, 4) === '%PDF') return 'pdf';
        if (substr($data, 0, 2) === "\xFF\xD8") return 'jpg';
        if (substr($data, 0, 4) === "\x89PNG") return 'png';
        return null;
    }
       
    private function extractFileFromHtml(string $html, string $baseUrl): ?string
    {
        if (preg_match('/base64,([^"\'>\s]+)/i', $html, $m)) {
            return base64_decode($m[1]);
        }
    
        libxml_use_internal_errors(true);
        $dom = new DOMDocument();
        $dom->loadHTML($html);
        libxml_clear_errors();
    
        foreach (['img' => 'src', 'iframe' => 'src', 'object' => 'data'] as $tag => $attr) {
        $nodes = $dom->getElementsByTagName($tag);
            if ($nodes->length) {
                $src = $nodes->item(0)->getAttribute($attr);
                if ($src) {
                    return @file_get_contents($this->absoluteUrl($src, $baseUrl));
                }
            }
        }
        return null;
    }
      
    private function absoluteUrl(string $url, string $base): string
    {
        if (parse_url($url, PHP_URL_SCHEME)) return $url;
        $p = parse_url($base);
        return $p['scheme'] . '://' . $p['host'] . '/' . ltrim($url, '/');
    }

    
    public function processPodFile($orderinfo, $docTypeId, $podImageUrl, $podFilePath, $podImageName) {
    $docInfo = $this->CI->common->gettblrowdata([
            'order_id' => $orderinfo['id'],
            'doc_type' => $docTypeId,
            'url' => $podImageUrl
        ], 'id', 'tb_pod_uploads', 0, 0);
        
        $curtz = $this->CI->session->userdata("usr_tzone")['timezone'];
        $logdate = date('Y-m-d H:i:s');
        $getactual = getdatetimebytimezone(DFLT_TZ, $logdate, $curtz);
        $curdt = $getactual['datetime'];
        
        if (empty($docInfo)) {
            $insert = [
                'order_id' => $orderinfo['id'],
                'trip_id' => $orderinfo['trip_id'],
                'shipment_id' => $orderinfo['shift_id'],
                'stop_id' => 0,
                'stop_detail_id' => 0,
                'stop_type' => 'P',
                'doc_type' => $docTypeId,
                'latitude' => $orderinfo['plat'],
                'longitude' => $orderinfo['plng'],
                'user_id' => $orderinfo['user_id'],
                'status' => 1,
                'createdon' => $curdt,
                'updatedon' => $curdt,
                'imgpath' => $podImageName,
                'filesize' => filesize($podFilePath),
                'url' => $podImageUrl
            ];
            $this->CI->common->insertTableData("tb_pod_uploads", $insert);
        } else {
            $this->CI->common->updatetbledata("tb_pod_uploads", [
                'createdon' => $curdt,
                'imgpath' => $podImageName,
                'filesize' => filesize($podFilePath),
                'updatedon' => $curdt
            ], [
                'order_id' => $orderinfo['id'],
                'doc_type' => $docTypeId,
                'url' => $podImageUrl
            ]);
        }
    }
}
