<?php

/**
 * Description of EdiEngine
 *      It will manages  EDI's chunk of tasks.   
 *       
 * @author Apple
 */
class EdiEngine
{

    private $ci;

    //put your code here
    function __construct()
    {
        $this->ci = &get_instance();
        $this->ci->load->model('common');
        $this->ci->load->model('Order');
    }

    /*
     *  Purpose:    Based on shipment Id we will fetch order ids from tb_orders table.
     *  @param      shipmentid      int    
     *  return      array       
     */

    function getOrderIds(int $shipment_id): array
    {
        return $this->ci->common->gettbldata(['shift_id' => $shipment_id, 'status !=' => 0], "id,order_id", "tb_orders", 0, 0);
    }

    /*
     *  Purpose:    Based on Order Id we will fech OrderRelated Routing Information. from tb_order and tb_order_details.
     *  @param      orderid      int    
     *  return      array  
     */

    function getOrderRoutingDetails($order_id)
    {
        $result = array();
        $res = $this->ci->Order->getordertoedit($order_id); // ->row_array();
        if ($res->num_rows() > 0) {
            $result = $res->row_array();
        }
        return $result;
    }

    /*
     *  Purpose : To get Order id related cargo details sums
     *  @param      order_id        int
     *  return      array
     */

    function getCargoDetailsSum($order_id)
    {
        $where = array("order_id" => $order_id, "status" => 1);
        $params = "count(*) total_cargos_count,group_concat(cargo_id,',') cargo_id, group_concat(handling_unit,',') handling_unit, sum(length) as length, sum(width) width, sum(height) height, sum(weight) weight, sum(volume) volume, sum(quantity) quantity,quantity_type,cargo_content";
        $this->ci->db->select($params);
        $this->ci->db->from('tb_order_cargodetails');
        $this->ci->db->where($where);
        $this->ci->db->group_by('order_id');
        $result = $this->ci->db->get()->row_array();
        return $result;
    }

    /*
     *  Purpose : To get shipper and consingee details.
     *  @param      type        string      Shipper || Consignee
     *  @param      ord_row_id  int     
     *  return      array
     */

    function getOrderParites($type, $ord_row_id)
    {
        $result = array();
        $select = array(
            "pm.order_id", "pm.party_master_id", "pm.location_id", "pm.street",
            "pm.address", "pm.pincode", "pm.country"
        );
        $from = array("`tbl_party_types` pt,`tb_order_parties` po, `tbl_orderparty_address` pm");
        $where = "po.party_type=pt.id and po.party_id = pm.party_master_id";
        $where1 = array("pt.name" => $type, "po.order_id" => $ord_row_id, "pm.order_id" => $ord_row_id);

        $shipper_info = $this->ci->db->select($select)
            ->from($from)
            ->where($where)->where($where1)->get();
        if ($shipper_info->num_rows() > 0) {
            $result = $shipper_info->row_array();
            $party_master_id = $shipper_info->row()->party_master_id;
            $getname = $this->ci->db->select(array(
                "name", "email", "mobile", "vat_reg_no",
                "tax_payer_no", "state", "code"
            ))
                ->from('tbl_party_master')
                ->where(array("id" => $party_master_id))->get();
            if ($getname->num_rows() > 0) {
                $result['name'] = $getname->row()->name;
                $result['email'] = $getname->row()->email;
                $result['mobile'] = $getname->row()->mobile;
                $result['vat_reg_no'] = $getname->row()->vat_reg_no;
                $result['tax_payer_no'] = $getname->row()->tax_payer_no;
                $result['state'] = $getname->row()->state;
                $result['code'] = $getname->row()->code;
            }
        } else {
            $select = "pm.name,pm.email,pm.mobile,pm.location_id,pm.address,pm.street,pm.pincode,po.order_id,pm.vat_reg_no,pm.tax_payer_no,pm.state,pm.code";
            $from = "`tbl_party_types` pt,`tb_order_parties` po, `tbl_party_master` pm";
            $where = "po.party_type=pt.id and po.party_id=pm.id";
            $where1 = array('pt.name' => $type, "po.order_id" => $ord_row_id);

            $shipperinfo = $this->ci->db->select($select)
                ->from($from)
                ->where($where)->where($where1)->get();
            if ($shipper_info->num_rows() > 0) {
                $result = $shipper_info->row_array();
            }
        }

        return $result;
    }

    /*
     *  Purpose : To get customer details based on customer_id. 
     *  @param      customer_id  int     
     *  return      array
     */

    function getOrderRelatedCustomer($customer_id)
    {
        $customer = array();
        $where = array("id" => $customer_id);
        $customer = $this->ci->common->gettbldata($where, "*", "tb_customers", 0, 0);
        return $customer;
    }

    /*
     *  Purpose : To Get Office Id Wrt to shipper/consignee city names. for Bite Transit Api  
     *  @param      city        string
     *  return      int
     */

    function getOfficeId($city)
    {
        $office_id = 0;
        $where = array("LOWER(city)" => strtolower($city), 'status' => '1');
        $officeid = $this->ci->common->gettblrowdata($where, array('office_id'), 'bite_api_city_codes', 0, 0);
        if ((!empty($officeid)) && isset($officeid['office_id']) && is_numeric($officeid['office_id'])) {
            $office_id = $officeid['office_id'];
        }
        return $office_id;
    }

    /*
     *  Purpose :   To get any type of order related references.
     *  @param      ord_row_id  int     
     *  @param      string      reference id.
     *  @param      string      separator           1|0
     *  return      string
     */
    /*   Few reference ids   
     *   'ORD_PIKINST'      to get pickup instructon
     *   'ORD_DLVINST'      to get Delivery instructon
     * 
     */

    function getOrderReferences($ord_row_id, $reference_id, $separator = '1')
    {
        $result = "";
        $reference_detais = $this->ci->common->gettbldata(array(
            'order_id' => $ord_row_id,
            'reference_id' => $reference_id,
            'status' => 1
        ), "reference_id,ref_value", "tb_order_references", 0, 0);
        if ((!empty($reference_detais)) && count($reference_detais) > 0 && isset($reference_detais[0]['ref_value']) && $reference_detais[0]['ref_value'] != '') {
            if ($separator == '1') {
                $result = "," . $reference_detais[0]['ref_value'];
            } else {
                $result = $reference_detais[0]['ref_value'];
            }
        }
        return $result;
    }

    /*
     *  Purpose : This method used in bite transit ap. ,based on few condition we need to change vat_reg_no.   
     *  @param          vat_reg_no      mixed     
     *  @param          order_row_id    int 
     *  @param          reference_id    mixed 
     */

    function bite_transit_vat_reg_no_process($vat_reg_no, $order_row_id, $reference_id)
    {
        if ($vat_reg_no == "") {
            $result = $this->getOrderReferences($order_row_id, $reference_id);
            if ($result != "") {
                // if vat reg no is empty then we no need to add ,(comma) in front of result. so i removed it. 
                return str_replace(',', "", $result);
            } else {
                return "";
            }
        } else {
            return $vat_reg_no;
        }
    }

    /*
     *  Pickup and drop instructions result will be process here as per bite transit api requirment.
     *  @param      pickup_ins      string
     *  @param      drop_ins        string
     *  return      string
     * 
     */

    function bite_transit_pickup_and_drop_instruction_process($pickup_ins, $drop_ins)
    {
        $ins = "";
        $pickup_ins_length = strlen($pickup_ins);
        $drop_ins_length = strlen($drop_ins);
        if ($pickup_ins_length == "0" && $drop_ins_length == "0") {
            return $ins;
        }
        if ($pickup_ins_length > 0) {
            $ins .= $pickup_ins;
        }
        if ($drop_ins_length > 0) {
            if ($pickup_ins_length > 0) {
                $ins .= ',' . $drop_ins_length;
            } else {
                $ins .= $drop_ins_length;
            }
        }
        return $ins;
    }

    /*
     *      Purpose: To get check reference is already stored OR not.
     *      @param         order_id         int
     *      @param         reference_id     mixed       int| String
     *      return         boolean
     */

    function check_reference_exit_or_not($order_id, $reference_id)
    {
        $result_ref = $this->ci->common->gettblrowdata(array("order_id" => $order_id, "reference_id" => $reference_id, 'status' => 1), 'id', 'tb_order_references', 0, 0);
        if (isset($result_ref['id']) && $result_ref['id'] != "" && is_numeric($result_ref['id'])) {
            return 1;
        } else {
            return 0;
        }
    }

    /*
     *      Purpose: To check a particular order has particular vas or not.
     *      @param         order_id         int
     *      @param         search_vas       String      ex. DOC,RTN,LOO
     *      return         boolean
     */

    function order_related_vas_existance_checking($order_id, $search_vas)
    {
        $existance_flag = 0;
        $result = $this->ci->db->select("GROUP_CONCAT(tvm.vas_id) AS vas_id,GROUP_CONCAT(tvm.vas_name) AS vas_name")
            ->from('tb_order_vas tov')
            ->join('tb_vas_master tvm', 'tvm.id=tov.vas_id AND tvm.status=1', "JOIN")
            ->where(array('tov.status' => '1', 'tov.order_id' => $order_id, 'tvm.vas_id' => $search_vas))->get()->row_array();
        if ((!empty($result)) && isset($result['vas_id']) && $result['vas_id'] != '') {
            $vas_id = $result['vas_id'];
            $vas_name = $result['vas_name'];
            if ($vas_id != "") {
                $vas_ids_array = explode(',', $vas_id);
                if (in_array($search_vas, $vas_ids_array)) {
                    $existance_flag = 1;
                }
            }
        }
        return $existance_flag;
    }

    /*
     *  Purpose : To generate barcodes array based on Z04 reference.
     *  @param          order_row_id            int
     *  @param          reference_id            string
     * 
     */

    function bite_transit_barcodes_processor($order_row_id, $reference_id)
    {
        $result = array();
        $reference_value = $this->getOrderReferences($order_row_id, $reference_id, '0');
        //   log_message("error", $this->ci->db->last_query() . '--' . $reference_value . '--');
        if ($reference_value != "") {
            $reference_ids_array = explode(',', $reference_value);
            if ((!empty($reference_ids_array)) && count($reference_ids_array) > 0) {
                $size = count($reference_ids_array);
                for ($i = 0; $i < $size; $i++) {
                    $result[] = array(
                        "code" => $reference_ids_array[$i],
                        "quantity" => 1, // fix
                        "volume" => 0.1, // fix
                        "weight" => 0.1  // fix
                    );
                }
            }
        }
        return $result;
    }

    function get_order_row_id($order_id)
    {
        $order_info = $this->ci->common->gettblrowdata(array("order_id" => $order_id), 'id', 'tb_orders', 0, 0);
        if ((!empty($order_info)) && count($order_info) > 0 && isset($order_info['id'])) {
            return $order_info['id'];
        }
        return "0";
    }


    function bite_transit_expedition_phone_number_process($phone_number, $reference_of_z05)
    {
        if ($phone_number == "" && $reference_of_z05 == "") {
            return "";
        }
        if ($phone_number != "" && $reference_of_z05 != "") {
            return $phone_number . ',' . $reference_of_z05;
        }

        if ($phone_number == "" && $reference_of_z05 != "") {
            return $reference_of_z05;
        }

        if ($phone_number != "" && $reference_of_z05 == "") {
            return $phone_number;
        }
    }

    /*
     *  Purpose : To get Order Id based on order reference_type and reference value.
     *  @param          reference_type      string          like RUCK
     *  $param          reference_type      mixed
     *  return          array.
     */

    function get_order_id_based_on_order_reference($reference_type, $reference_id)
    {
        $result = array();
        $order_detais = $this->ci->common->gettblrowdata(array("ref_value" => $reference_id, "reference_id" => $reference_type, "status" => "1"), "order_id,order_shortNo", "tb_order_references", 0, 0);
        if ((!empty($order_detais)) && count($order_detais) > 0 && isset($order_detais['order_id'])) {
            $result = $order_detais;
        }
        return $result;
    }

    function bite_transit_insurance_val_process($result)
    {
        if ($result == "") {
            return 0;
        }
        return $result;
    }

    function bite_tranist_time_val_process($time)
    {
        $custom_mintues = "00";
        $time_parts = explode(':', $time);
        $hours = $time_parts[0];
        $mintues = $time_parts[1];
        if ($mintues > 30) {
            $custom_mintues = "30";
        }
        return $hours . ':' . $custom_mintues;
    }

    function get_vozovoz_ct_project_id($customer_id)
    {
        $result = "";
        $project_id_detais = $this->ci->common->gettblrowdata(array('order_customer_id' => $customer_id), "project_id", "vozovoz_ct_project", 0, 0);
        if ((!empty($project_id_detais)) && count($project_id_detais) > 0 && isset($project_id_detais['project_id']) && $project_id_detais['project_id'] != '') {
            $result = $project_id_detais['project_id'];
        }
        return $result;
    }
}
