<?php

/**
 * Description of EdiStatusProcess
 *
 * @author Apple
 */
class EdiStatusProcess {

    private $ci;

    //put your code here
    function __construct() {
        error_reporting(0);
        $this->ci = & get_instance();
        $this->ci->load->model('common');
    }

    /*
     *  Purpose : To get status_id and status_code based on status
     *  @param      status          mixed   i.e. int | String
     *  @param      company_code    string
     *  @param      condition       mixed   i.e. int | String
     *  retrun      array
     */

    function get_status_ids($status, $company_code, $condition = 'code') {
        $status_master_info = array("id" => 0, "status_code" => 0);
        $select = "id,status_code";
        $table = "tb_status_master";
        if ($condition == "code") {
            $where = array("status_code" => $status, "status" => 1, 'company_code' => $company_code);
        } else {
            // ifn condition is name.
            $where = array("status_name" => $status, "status" => 1);
        }
        $statusinfo = $this->ci->common->gettblrowdata($where, $select, $table, 0, 0);
        // log_message("error", $this->ci->db->last_query());
        if ((!empty($statusinfo)) && count($statusinfo) > 0) {
            $status_master_info = $statusinfo;
        }
        // log_message("error", "---get status ids---" . $this->ci->db->last_query());
        return $status_master_info;
    }

    /*
     *  Purpose : Get Allotted vehicle for shipment
     *  @param  shipment_id     int
     *  return  array
     */

    function get_vehicle_info($shipment_id) {
        $driver_id = 0;
        $vehicle_id = 0;
        $where = array('shift_id' => $shipment_id);
        $select = "vehicle_id,driver_id";
        $table = "tb_trips";
        $dvinfo = $this->ci->common->gettblrowdata($where, $select, $table, 0, 0);
        if (count($dvinfo) > 0) {
            $driver_id = $dvinfo['driver_id'];
            $vehicle_id = $dvinfo['vehicle_id'];
        }
        // log_message("error", "---get_vehicle_info---" . $this->ci->db->last_query());
        return array('driver_id' => $driver_id, "vehicle_id" => $vehicle_id);
    }

    /*
     *  Purpose : Get Allotted Driver information.
     *  @param  driver_id     int
     *  return  array
     */

    function get_driver_info($driver_id) {
        $where = array('id' => $driver_id);
        $select = "imei";
        $table = "tb_truck_drivers";
        $dinfo = $this->ci->common->gettblrowdata($where, $select, $table, 0, 0);
        $mobile_num = '000000000';
        if (count($dinfo) > 0) {
            if ($dinfo['imei'] != '') {
                $mobile_num = $dinfo['imei'];
            }
        }
        // log_message("error", "---get_driver_info---" . $this->ci->db->last_query());
        return $mobile_num;
    }

    /*
     *    Purpose : To get shipment Id for particular order.
     *    @param        order_id        int
     *    return        int             i.e shipment id.
     */

    function getshipment_id($order_id) {
        $where = array("id" => $order_id);
        $shipment_id = $this->ci->common->gettblrowdata($where, "shift_id,trip_id,order_id", "tb_orders", 0, 0);
        // log_message("error", "---getshipment_id---" . $this->ci->db->last_query());
        return $shipment_id;
    }

    /*
     *  Purpose : To insert record into tb_Stop_Status.
     *  @param  insert_array        array   an array of values.
     *  return          void.
     */

    function add_stop_status($insert_array) {
        $this->ci->db->insert('tb_stop_status', $insert_array);
    }

    /*
     *  Purpose : To check is give record is already exist or not..
     *  @param  $check_array        array   an array of values.
     *  return      boolean         i.e 0 | 1
     */

    function check_stop_status_exists_or_not($check_array) {
        $chk_qry = $this->ci->db->select("id")->get_where('tb_stop_status', $check_array);
        if ($chk_qry != FALSE && $chk_qry->num_rows() == 0) {
            // not found.
            // log_message("error", "---check_stop_status_exists_or_not---" . $this->ci->db->last_query());
            return "0";
        } else {
            // exist
            // log_message("error", "---else check_stop_status_exists_or_not---" . $this->ci->db->last_query());
            return "1";
        }
    }

    /*
     *  Purpose : To store/update Driver location information into tb_rtdrive_locations.
     *  @param     driver_id       int
     *  @param     vechicle_id     int
     *  @param     trip_id         int
     *  @param     lat1            float
     *  @param     lng1            float
     *  @param     mobile_num      int
     *  @param     createdon       datetime
     *  return      void.
     */

    function add_driver_location($driver_id, $vehicle_id, $trip_id, $lat1, $lng1, $mobile_num, $createdon) {
        $drive_loc = array('driver_id' => $driver_id, 'vehicle_id' => $vehicle_id, 'trip_id' => $trip_id, 'latitude' => $lat1, 'longitude' => $lng1, 'accuracy' => 50, 'speed' => 0, 'battery' => 0, 'bearing' => 50, 'timestamp' => $createdon, 'mobileimei' => $mobile_num);
        $check_drive_loc = array('driver_id' => $driver_id, 'vehicle_id' => $vehicle_id, 'trip_id' => $trip_id, 'latitude' => $lat1, 'longitude' => $lng1);
        if ($lat1 != '' && $lat1 != 0) {
            $chk_qry = $this->ci->db->select("id")->get_where('tb_rtdrive_locations', $check_drive_loc);
            if ($chk_qry->num_rows() == 0) {
                $vehins = $this->ci->db->insert('tb_rtdrive_locations', $drive_loc);
            } else {
                $vehins = $this->ci->db->where_in("id", array("id" => $chk_qry->row()->id))->update("tb_rtdrive_locations", $drive_loc);
            }
        }
        // log_message("error", "---add_driver_location---" . $this->ci->db->last_query());
    }

    /*
     *  Purpose : To store/update truck data related information into add_truck_data.
     *  @param      vechicle_id     int
     *  @param      lat1            float
     *  @param      lng1            float
     *  return      void.
     */

    function add_truck_data($vehicle_id, $lat, $lng) {
        $veh_info = array('latitude' => $lat, 'longitude' => $lng, 'speed' => 0, 'battery' => 0, 'bearing' => 50);
        if ($lat != '' && $lat != 0) {
            $vehins = $this->ci->db->where_in("id", array("id" => $vehicle_id))->update("tb_trucks_data", $veh_info);
        }
        // log_message("error", "---add_truck_data---" . $this->ci->db->last_query());
    }

    /*
     *  Purpose : To get stop_details_id that associated with shipment_id and order_id.
     *  @param      shipment_id         int
     *  @param      order_id            int
     *  return      stop_details_id     int
     */

    function get_order_stops_details_id($shipment_id, $order_id) {
        $stop_detail_id = 0;
        $select = "id";
        $table = "tb_employee";
        $where = array("shift_id" => $shipment_id, "order_id" => $order_id, "status" => 1);
        $stop_detail_idinfo = $this->ci->common->gettblrowdata($where, $select, $table, 0, 0);
        if ((!empty($stop_detail_idinfo)) && count($stop_detail_idinfo) > 0) {
            $stop_detail_id = $stop_detail_idinfo['id'];
        }
        // log_message("error", "---get_order_stops_details_id---" . $this->ci->db->last_query());
        return $stop_detail_id;
    }

    /*
     *  Purpose :   To close trip.
     *  @param      shipment_id     int
     *  @param      order_id        int
     *  return      stop_details_id int
     */

    function close_shipment($order_row_id, $shipment_id, $trip_id) {
        $this->ci->common->updatetbledata("tb_orders", array("trip_sts" => 1), array("id" => $order_row_id));
        // log_message("error", "---close_shipment1---" . $this->ci->db->last_query());
        $this->ci->common->updatetbledata("tb_shifts", array("status" => 0), array("id" => $shipment_id));
        // log_message("error", "---close_shipment2---" . $this->ci->db->last_query());
        $this->ci->common->updatetbledata("tb_trips", array("status" => 0), array("id" => $trip_id));
        // log_message("error", "---close_shipment3---" . $this->ci->db->last_query());
    }

    /*
     *  Purpose :   To lat and lang based on location
     *  @param      address       string
     *  return      array.
     */

    function get_lat_lng($address) {
        $lat_lng = array("lat" => 0, 'lng' => 0);
        if ($address != '') {
            $data = getlatlngsbyplace($address);
            $lat = @$data[0];
            $lng = @$data[1];
            $lat_lng = array("lat" => $lat, 'lng' => $lng);
        }
        return $lat_lng;
    }

    /*
     *  Purpose :   To check record exist or not on given table and conditions
     *  @param      table       string
     *  @param      where       array
     *  return      boolean.
     */

    function record_exist_or_not($table, $where) {
        $qry = $this->ci->db->select("id")->limit(1)->get_where($table, $where);
        if ($qry != FALSE && $qry->num_rows() == 0) {
            // not found.
            // log_message("error", "---record_exist_or_not---" . $this->ci->db->last_query());
            return "0";
        } else {
            // log_message("error", "---record_exist_or_not---" . $this->ci->db->last_query());
            // found
            return "1";
        }
    }

    /*
     *  Purpose :   To insert records.
     *  @param      table       string
     *  @param      data        array
     */

    function insert_record($table, $data) {
        $res = 0;
        $qry = $this->ci->db->insert($table, $data);
        if ($qry) {
            $res = $this->ci->db->insert_id();
        }
        // log_message("error", "---insert_record---" . $this->ci->db->last_query());
        return $res;
    }

    /*
     *  Purpose :   This will check carrier related status codes exist or not in tb_status_master
     *              if records are not found then it will insert new records.
     *  @param      table       string
     *  @param      data        array
     */

    function bite_transit_carrier_status_update($company_code, $branch_code, $createdon)
    {
        // $avilable_status = array("Accept", "Gate In", "Pickup", "Gate Out", "In-Transit", "Gate IN", "Delivery", "Gate Out", "Close");
        // $avilable_status = array("Accept", "0420", "Pickup", "0191", "1550", "0192", "Delivery", "2300", "Close");
        $bite_transit_status_codes = [
            "Gate In" => "0420",
            "Gate Out" => "0191",
            "Pickup" => "0500",
            "In-Transit" => "1550",
            "Departed from terminal" => "1300",
            "Received in terminal" => "1000",
            "Gate IN" => "0192",
            "Delivered" => "3000",
            "Gate Out" => "2300"
        ];
        foreach ($bite_transit_status_codes as $key => $value) {
            $where = ["company_code" => $company_code, "branch_code" => $branch_code, "status_code" => $value];
            // $where = array("status_code" => $value);
            if ($this->record_exist_or_not('tb_status_master', $where) == 0) {
                // not found so insert.
                $insert_tb_status_master = ["status_name" => $key, "description" => $key, "status_type" => 'yes', "status_code" => $value, "company_code" => $company_code, "branch_code" => $branch_code, "status" => 1, "createdon" => $createdon];
                $this->insert_record('tb_status_master', $insert_tb_status_master);
                // log_message("error", "---bite_transit_carrier_status_update---" . $this->ci->db->last_query());
            }
        }
    }

    /*
     *  Purpose : To get stop_id that associated with shipment_id and stop_type.
     *  @param      shipment_id     int
     *  @param      stop_type       string
     *  return      stop_id.        int
     */

    function get_order_stop_id($shipment_id, $stop_type) {
        $stop_id = 0;
        $select = "id";
        $table = "tb_shiporder_stops";
        $where = array("shipment_id" => $shipment_id, 'stoptype' => $stop_type, "status" => 1);
        $stopidinfo = $this->ci->common->gettblrowdata($where, $select, $table, 0, 0);
        if ((!empty($stopidinfo)) && count($stopidinfo) > 0) {
            $stop_id = $stopidinfo['id'];
        }
        return $stop_id;
    }

    /*
     *  Purpose:To read xml file in specified path.
     *  @param      path    string
     *  returns xmlobj
     */

    function readxmlfile($path) {
        $xml = simplexml_load_file($path);
        return $xml;
    }

    /*
    *  To get Vendor related Order Details.
    */

    function get_vendor_related_orders($vendorId)
    {
        $this->ci->db->select(['tb_o.id', 'tb_o.order_id', 'tb_o.shift_id', 'tb_o.trip_id', 'tb_o.vendor_id', 'tb_o_r.ref_value', 'tb_o_r.id AS tb_order_reference_row_id']);
        $this->ci->db->from('tb_orders tb_o');
        $this->ci->db->join('tb_order_references tb_o_r', "tb_o_r.order_id= tb_o.id AND tb_o_r.reference_id='RUCK'");
        $this->ci->db->where(['tb_o.trip_sts' => '0', 'tb_o.status!=' => '0', "trip_id!=" => '0', 'tb_o.vendor_id' => $vendorId, 'tb_o_r.status' => '1']);
        $query = $this->ci->db->get();
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }

}

// 10 - status_accept
