<?php

use App\Libraries\XmlNode;

class HeaderSegment extends XmlNode
{
    const VERSION = 'V1';
    const SEQUENCE_NUMBER = 0;
    const SOURCE_APP = 'SVKONEKT';

    public function __construct($headerSegmentInfo = [])
    {
        parent::__construct(
            $headerSegmentInfo,
            [
                'username' => '',
                'password' => '',
            ]
        );
    }

    public function setVersion(string $version): void
    {
        $this->version = $version;
    }

    public function getVersion(): string
    {
        return $this->version;
    }

    public function setSequenceNumber(int $sequenceNumber): void
    {
        $this->sequenceNumber = $sequenceNumber;
    }

    public function getSequenceNumber(): int
    {
        return $this->sequenceNumber;
    }

    public function setSourceApp(string $sourceApp): void
    {
        $this->sourceApp = $sourceApp;
    }

    public function getSourceApp(): string
    {
        return $this->sourceApp;
    }

    public function setUsername(string $username): void
    {
        $this->username = $username;
    }

    public function getUsername(): string
    {
        return $this->username;
    }

    public function setPassword(string $password): void
    {
        $this->password = $password;
    }

    public function getPassword(): string
    {
        return $this->password;
    }

    public function getXml(): string
    {
        return '<Header>
                 <Version>' . self::VERSION . '</Version>
                 <SequenceNumber>' . self::SEQUENCE_NUMBER . '</SequenceNumber>
                 <SourceApp>' . self::SOURCE_APP . '</SourceApp>
                 <Username>' . $this->username . '</Username>
                 <Password>' . $this->password . '</Password>
             </Header>';
    }
}
