<?php

use App\Libraries\XmlNode;

class OrderCargoDetailsHeader extends XmlNode
{
    public function __construct(array $orderCargoDetailsHeader = [])
    {
        parent::__construct(
            $orderCargoDetailsHeader,
            [
                'cargoType' => '',
                'dangerousGoodsFlag' => '',
                'totalPackagesOfDangerousGoods' => '',
            ]
        );
    }

    public function setCargoType(string $cargoType): void
    {
        $this->cargoType = $cargoType;
    }

    public function getCargoType(): string
    {
        return $this->cargoType;
    }

    public function setDangerousGoodsFlag(string $dangerousGoodsFlag): void
    {
        $this->dangerousGoodsFlag = $dangerousGoodsFlag;
    }

    public function getDangerousGoodsFlag(): string
    {
        return $this->dangerousGoodsFlag;
    }

    public function setTotalPackagesOfDangerousGoods(string $totalPackagesOfDangerousGoods): void
    {
        $this->totalPackagesOfDangerousGoods = $totalPackagesOfDangerousGoods;
    }

    public function getTotalPackagesOfDangerousGoods(): string
    {
        return $this->totalPackagesOfDangerousGoods;
    }

    public function getXml(): string
    {
        return '<DangerousGoodsFlag>' . $this->dangerousGoodsFlag . '</DangerousGoodsFlag>
                <TotalPackagesOfDangerousGoods>' . $this->totalPackagesOfDangerousGoods . '</TotalPackagesOfDangerousGoods>';
    }

}
