<?php

use App\Libraries\XmlNode;

class OrderCargoSummary extends XmlNode
{
    public function __construct(array $orderCargoSummary = [])
    {
        parent::__construct(
            $orderCargoSummary,
            [
                'totalQuantityValue' => '',
                'totalQuantityUOM' => '',
                'totalVolumeValue' => '',
                'totalVolumeUOM' => '',
                'totalWeightValue' => '',
                'totalWeightUOM' => '',
                'dangerousGoodsFlag' => 'NO',
                'totalPackagesOfDangerousGoods' => 0,
            ]
        );
    }

    public function __set(string $name, $value)
    {
        switch (strtolower($name)) {
            case 'totalquantityuom':
            case 'totalvolumeuom':
            case 'totalweightuom':
                parent::__set($name, strtolower($value));
                break;

            default:
                parent::__set($name, $value);
        }
    }

    public function setTotalQuantityValue(string $totalQuantityValue): void
    {
        $this->totalQuantityValue = $totalQuantityValue;
    }

    public function getTotalQuantityValue(): int
    {
        return $this->totalQuantityValue;
    }

    public function setTotalQuantityUOM(string $totalQuantityUOM): void
    {
        $this->totalQuantityUOM = $totalQuantityUOM;
    }

    public function getTotalQuantityUOM(): string
    {
        return $this->totalQuantityUOM;
    }

    public function setTotalVolumeValue(string $totalVolumeValue): void
    {
        $this->totalVolumeValue = $totalVolumeValue;
    }

    public function getTotalVolumeValue(): int
    {
        return $this->totalVolumeValue;
    }

    public function setTotalVolumeUOM(string $totalVolumeUOM): void
    {
        $this->totalVolumeUOM = $totalVolumeUOM;
    }

    public function getTotalVolumeUOM(): string
    {
        return $this->totalVolumeUOM;
    }

    public function setTotalWeightValue(string $totalWeightValue): void
    {
        $this->totalWeightValue = $totalWeightValue;
    }

    public function getTotalWeightValue(): int
    {
        return $this->totalWeightValue;
    }

    public function setTotalWeightUOM(string $totalWeightUOM): void
    {
        $this->totalWeightUOM = $totalWeightUOM;
    }

    public function getTotalWeightUOM(): string
    {
        return $this->totalWeightUOM;
    }

    public function setDangerousGoodsFlag(string $dangerousGoodsFlag): void
    {
        $this->dangerousGoodsFlag = $dangerousGoodsFlag;
    }

    public function getDangerousGoodsFlag(): int
    {
        return $this->dangerousGoodsFlag;
    }

    public function setTotalPackagesOfDangerousGoods(string $totalPackagesOfDangerousGoods): void
    {
        $this->totalPackagesOfDangerousGoods = $totalPackagesOfDangerousGoods;
    }

    public function getTotalPackagesOfDangerousGoods(): int
    {
        return $this->totalPackagesOfDangerousGoods;
    }

    public function getXml(): string
    {
        return '<OrderCargoSummary>
                 <TotalQuantity>
                     <Value>' . $this->totalQuantityValue . '</Value>
                 </TotalQuantity>
                 <TotalVolume>
                     <Value>' . $this->totalVolumeValue . '</Value>
                     <UOM>' . $this->totalVolumeUOM . '</UOM>
                 </TotalVolume>
                 <TotalWeight>
                     <Value>' . $this->totalWeightValue . '</Value>
                     <UOM>' . $this->totalWeightUOM . '</UOM>
                 </TotalWeight>
                 <DangerousGoodsFlag>' . $this->dangerousGoodsFlag . '</DangerousGoodsFlag>
                 <TotalPackagesOfDangerousGoods>' . $this->totalPackagesOfDangerousGoods . '</TotalPackagesOfDangerousGoods>
                </OrderCargoSummary>';
    }
}
