<?php

use App\Libraries\XmlNode;

class OrderEndLocation extends XmlNode
{
    public function __construct(array $orderEndLocation = [])
    {
        parent::__construct(
            $orderEndLocation,
            [
                'stopSequence' => 0,
                'address1' => '',
                'street' => '',
                'city' => '',
                'state' => '',
                'postal' => '',
                'country' => '',
                'timezone' => '',
                'from' => '',
                'to' => '',
                'deliveryInstructions' => '',
            ]
        );
    }

    public function setStopSequence(int $stopSequence): void
    {
        $this->stopSequence = $stopSequence;
    }

    public function getStopSequence(): int
    {
        return $this->stopSequence;
    }

    public function setAddress1(string $address1): void
    {
        $this->address1 = $address1;
    }

    public function getAddress1(): string
    {
        return $this->address1;
    }

    public function setStreet(string $street): void
    {
        $this->street = $street;
    }

    public function getStreet(): string
    {
        return $this->street;
    }

    public function setCity(string $city): void
    {
        $this->city = $city;
    }

    public function getCity(): string
    {
        return $this->city;
    }

    public function setState(string $state): void
    {
        $this->state = $state;
    }

    public function getState(): string
    {
        return $this->state;
    }

    public function setPostal(string $postal): void
    {
        $this->postal = $postal;
    }

    public function getPostal(): string
    {
        return $this->postal;
    }

    public function setCountry(string $country): void
    {
        $this->country = $country;
    }

    public function getCountry(): string
    {
        return $this->country;
    }

    public function setTimezone(string $timezone): void
    {
        $this->timezone = $timezone;
    }

    public function getTimezone(): string
    {
        return $this->timezone;
    }

    public function setFrom(string $from): void
    {
        $this->from = $from;
    }

    public function getFrom(): string
    {
        return $this->from;
    }

    public function setTo(string $to): void
    {
        $this->to = $to;
    }

    public function getTo(): string
    {
        return $this->to;
    }

    public function setDeliveryInstructions(string $deliveryInstructions): void
    {
        $this->deliveryInstructions = $deliveryInstructions;
    }

    public function getDeliveryInstructions(): string
    {
        return $this->deliveryInstructions;
    }

    public function getXml(): string
    {
        return '<OrderEndLocation>
                     <StopSequence>' . $this->stopSequence . '</StopSequence>
                     <Address>
                         <Name>' . $this->address1 . '</Name>
                         <Street>' . $this->street . '</Street>
                         <City>' . $this->city . '</City>
                         <State>' . $this->state . '</State>
                         <Postal>' . $this->postal . '</Postal>
                         <Country>' . $this->country . '</Country>
                         <Timezone>' . $this->timezone . '</Timezone>
                     </Address>
                     <PlannedDateTime>
                         <From>' . $this->from . '</From>
                         <To>' . $this->to . '</To>
                     </PlannedDateTime>
                     <DriverInstructions>' . $this->deliveryInstructions . '</DriverInstructions>
                 </OrderEndLocation>';
    }
}
