<?php

use App\Libraries\XmlNode;

class OrderInfo extends XmlNode
{
    public function __construct(array $orderInfo = [])
    {
        parent::__construct(
            $orderInfo,
            [
                'orderID' => '',
                'eXTOrderID' => '',
                'departmentCode' => '',
                'orderType' => '',
                'modeOfTransport' => '',
                'serviceType' => '',
                'typeOfBusiness' => '',
                'deliveryTerms' => '',
                'goodsValue' => 0.0,
                'currency' => '',
            ]
        );
    }

    public function setOrderID(string $orderID): void
    {
        $this->orderID = $orderID;
    }

    public function getOrderID(): string
    {
        return $this->orderID;
    }

    public function setEXTOrderID(string $eXTOrderID): void
    {
        $this->eXTOrderID = $eXTOrderID;
    }

    public function getEXTOrderID(): string
    {
        return $this->eXTOrderID;
    }

    public function setOrderType(string $orderType): void
    {
        $this->orderType = $orderType;
    }

    public function getOrderType(): string
    {
        return $this->orderType;
    }

    public function setModeOfTransport(string $modeOfTransport): void
    {
        $this->modeOfTransport = $modeOfTransport;
    }

    public function getModeOfTransport(): string
    {
        return $this->modeOfTransport;
    }

    public function setServiceType(string $serviceType): void
    {
        $this->serviceType = $serviceType;
    }

    public function getServiceType(): string
    {
        return $this->serviceType;
    }

    public function setTypeOfBusiness(string $typeOfBusiness): void
    {
        $this->typeOfBusiness = $typeOfBusiness;
    }

    public function getTypeOfBusiness(): string
    {
        return $this->typeOfBusiness;
    }

    public function setDeliveryTerms(string $deliveryTerms): void
    {
        $this->deliveryTerms = $deliveryTerms;
    }

    public function getDeliveryTerms(): string
    {
        return $this->deliveryTerms;
    }

    public function setGoodsValue(string $goodsValue): void
    {
        $this->goodsValue = $goodsValue;
    }

    public function getGoodsValue(): string
    {
        return $this->goodsValue;
    }

    public function setCurrency(string $currency): void
    {
        $this->currency = $currency;
    }

    public function getCurrency(): string
    {
        return $this->currency;
    }

    public function setDepartmentCode(string $departmentCode): void
    {
        $this->departmentCode = $departmentCode;
    }

    public function getDepartmentCode(): string
    {
        return $this->departmentCode;
    }

    public function getXml(): string
    {
        return '<OrderID>' . $this->orderID . '</OrderID>
             <EXTOrderID>' . $this->eXTOrderID . '</EXTOrderID>
             <DepartmentCode>' . $this->departmentCode . '</DepartmentCode>
             <OrderType>' . $this->orderType . '</OrderType>
             <ModeOfTransport>' . $this->modeOfTransport . '</ModeOfTransport>
             <ServiceType>' . $this->serviceType . '</ServiceType>
             <DeliveryTerms>' . $this->deliveryTerms . '</DeliveryTerms>
             <GoodsValue>
                    <Value>' . $this->goodsValue . '</Value>
                    <Currency>' . $this->currency . '</Currency>
             </GoodsValue>
             <TypeOfBusiness>' . $this->typeOfBusiness . '</TypeOfBusiness>';
    }
}
