<?php

use App\Libraries\XmlNode;

class VehicleDetails extends XmlNode
{
    public function __construct($vehicleDetails = [])
    {
        parent::__construct(
            $vehicleDetails,
            [
                'vehicleTypeCode' => '',
                'vehicleModelCode' => '',
                'registrationNumber' => '',
                'license' => '',
                'applicableForDangerousGoods' => '',
                'weightMin' => 0.0,
                'weightMax' => 0.0,
                'weightUOM' => 'KG',
                'volumeMin' => 0.0,
                'volumeMax' => 0.0,
                'volumeUOM' => 'CBM',
                'lengthMin' => 0.0,
                'lengthMax' => 0.0,
                'lengthUOM' => 'CM',
                'widthMin' => 0.0,
                'widthMax' => 0.0,
                'widthUOM' => '',
                'heightMin' => 0.0,
                'heightMax' => 0.0,
                'heightUOM' => 'M',
            ]
        );
    }

    public function __set(string $name, $value)
    {
        switch (strtolower($name)) {
            case 'weightuom':
            case 'volumeuom':
            case 'lengthuom':
            case 'widthuom':
            case 'heightuom':
                parent::__set($name, strtolower($value));
                break;

            default:
                parent::__set($name, $value);
        }
    }

    public function setVehicleTypeCode(string $vehicleTypeCode): void
    {
        $this->vehicleTypeCode = $vehicleTypeCode;
    }

    public function getVehicleTypeCode(): string
    {
        return $this->vehicleTypeCode;
    }

    public function setVehicleModelCode(string $vehicleModelCode): void
    {
        $this->vehicleModelCode = $vehicleModelCode;
    }

    public function getVehicleModelCode(): string
    {
        return $this->vehicleModelCode;
    }

    public function setWeightMin(string $weightMin): void
    {
        $this->weightMin = $weightMin;
    }

    public function getWeightMin(): string
    {
        return $this->weightMin;
    }

    public function setWeightMax(string $weightMax): void
    {
        $this->weightMax = $weightMax;
    }

    public function getWeightMax(): string
    {
        return $this->weightMax;
    }

    public function setWeightUOM(string $weightUOM): void
    {
        $this->weightUOM = $weightUOM;
    }

    public function getWeightUOM(): string
    {
        return $this->weightUOM;
    }

    public function setVolumeMin(string $volumeMin): void
    {
        $this->volumeMin = $volumeMin;
    }

    public function getVolumeMin(): string
    {
        return $this->volumeMin;
    }

    public function setVolumeMax(string $volumeMax): void
    {
        $this->volumeMax = $volumeMax;
    }

    public function getVolumeMax(): string
    {
        return $this->volumeMax;
    }

    public function setVolumeUOM(string $volumeUOM): void
    {
        $this->volumeUOM = $volumeUOM;
    }

    public function getVolumeUOM(): string
    {
        return $this->volumeUOM;
    }

    public function setLengthMin(string $lengthMin): void
    {
        $this->lengthMin = $lengthMin;
    }

    public function getLengthMin(): string
    {
        return $this->lengthMin;
    }

    public function setLengthMax(string $lengthMax): void
    {
        $this->lengthMax = $lengthMax;
    }

    public function getLengthMax(): string
    {
        return $this->lengthMax;
    }

    public function setLengthUOM(string $lengthUOM): void
    {
        $this->lengthUOM = $lengthUOM;
    }

    public function getLengthUOM(): string
    {
        return $this->lengthUOM;
    }

    public function setWidthMin(string $widthMin): void
    {
        $this->widthMin = $widthMin;
    }

    public function getWidthMin(): string
    {
        return $this->widthMin;
    }

    public function setWidthMax(string $widthMax): void
    {
        $this->widthMax = $widthMax;
    }

    public function getWidthMax(): string
    {
        return $this->widthMax;
    }

    public function setWidthUOM(string $widthUOM): void
    {
        $this->widthUOM = $widthUOM;
    }

    public function getWidthUOM(): string
    {
        return $this->widthUOM;
    }

    public function setHeightMin(string $heightMin): void
    {
        $this->heightMin = $heightMin;
    }

    public function getHeightMin(): string
    {
        return $this->heightMin;
    }

    public function setHeightMax(string $heightMax): void
    {
        $this->heightMax = $heightMax;
    }

    public function getHeightMax(): string
    {
        return $this->heightMax;
    }

    public function setHeightUOM(string $heightUOM): void
    {
        $this->heightUOM = $heightUOM;
    }

    public function getHeightUOM(): string
    {
        return $this->heightUOM;
    }

    public function setRegistrationNumber(string $registrationNumber): void
    {
        $this->registrationNumber = $registrationNumber;
    }

    public function getRegistrationNumber(): string
    {
        return $this->registrationNumber;
    }

    public function setLicense(string $license): void
    {
        $this->license = $license;
    }

    public function getLicense(): string
    {
        return $this->license;
    }

    public function setApplicableForDangerousGoods(string $applicableForDangerousGoods): void
    {
        $this->applicableForDangerousGoods = $applicableForDangerousGoods;
    }

    public function getApplicableForDangerousGoods(): string
    {
        return $this->applicableForDangerousGoods;
    }

    public function getXml(): string
    {
        return '<VehicleDetails>
                 <VehicleTypeCode>' . $this->vehicleTypeCode . '</VehicleTypeCode>
                 <VehicleModelCode>' . $this->vehicleModelCode . '</VehicleModelCode>
                 <RegistrationNumber>' . $this->registrationNumber . '</RegistrationNumber>
                 <License>' . $this->license . '</License>
                 <ApplicableForDangerousGoods>' . $this->applicableForDangerousGoods . '</ApplicableForDangerousGoods>
                    <Properties>
                            <Weight>
                                 <Value>' . $this->weightMax . '</Value>
                                 <UOM>' . $this->weightUOM . '</UOM>
                             </Weight>
                            <Volume>
                                 <Value>' . $this->volumeMax . '</Value>
                                 <UOM>' . $this->volumeUOM . '</UOM>
                             </Volume>
                            <Length>
                                 <Value>' . $this->lengthMax . '</Value>
                                 <UOM>' . $this->lengthUOM . '</UOM>
                             </Length>
                            <Width>
                                 <Value>' . $this->widthMax . '</Value>
                                 <UOM>' . $this->widthUOM . '</UOM>
                             </Width>
                            <Height>
                                 <Value>' . $this->heightMax . '</Value>
                                 <UOM>' . $this->heightUOM . '</UOM>
                             </Height>
                    </Properties>
             </VehicleDetails>';
    }
}
