<?php

namespace App\Libraries\infrastructure;

use Aws\CloudWatchLogs\CloudWatchLogsClient;
use Maxbanton\Cwh\Handler\CloudWatch;
use Monolog\Formatter\JsonFormatter;
use Monolog\Logger;

class LogService implements LogServiceInterface
{
    /** @var int */
    private const LOGS_RETENTION_IN_DAYS = 30;

    /** @var string */
    private $group = '';

    /** @var string */
    private $stream = '';

    /** @var Logger */
    private $logger;

    /**
     * @throws \Exception
     */
    public function __construct($group, $stream)
    {
        $this->group = $group;
        $this->stream = $stream;

        $this->init();
    }

    /**
     * @throws \Exception
     */
    private function init(): void
    {
        $handler = new CloudWatch($this->initCloudWatchClient(), $this->group, $this->stream, static::LOGS_RETENTION_IN_DAYS);
        $handler->setFormatter(new JsonFormatter());

        $this->logger = new Logger($this->stream);
        $this->logger->pushHandler($handler);
    }

    /**
     * @return CloudWatchLogsClient
     */
    private function initCloudWatchClient(): CloudWatchLogsClient
    {
        $args = [
            'region' => 'eu-central-1',
            'version' => 'latest'
        ];

        // If the environment is development use hard coded credentials.
        // All other environments will be automatically authenticated through AWS.
        if (ENVIRONMENT === 'development') {
            $args['credentials'] = [
                'key' => AWS_CREDENTIALS_KEY ?? '',
                'secret' => AWS_CREDENTIALS_SECRET ?? '',
                'token' => AWS_CREDENTIALS_TOKEN ?? ''
            ];
        }

        return new CloudWatchLogsClient($args);
    }

    /**
     * @return Logger
     */
    public function getLogger(): Logger
    {
        return $this->logger;
    }
}
